/******************************************************************************/
/*                                                                            */
/*         Infentra Design Unit                                               */
/*                                                                            */
/******************************************************************************/
/*                                                                            */
/* All Rights Reserved Copyright (C) 2016-2017, Infentra solutions            */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or without         */
/* modification, are not permitted in any case                                */
/*                                                                            */
/* Infentra name may not be used to endorse or promote products derived from  */
/* this software without specific prior written permission.                   */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/* All Rights Reserved Copyright (C) 2016-2017, Infentra solutions  .         */
/*                                                                            */
/* \File Name   :    IOC.c                                                    */
/* \Author      :    Vivek.K                                                  */
/* \Version     :    V7                                                       */
/* \Date        :    2/1/2017                                                 */
/*                                                                            */
/* Common Software Framework                                                  */
/******************************************************************************/

/******************************************************************************/
/* User Header Files Section                                                  */
/******************************************************************************/
#include "IOC_Priv.h"

#include "IOC.h"

/******************************************************************************/
/* Global Definitions Section                                                 */
/******************************************************************************/

#define IOC_BASE                        (0x40081000)

/******************************************************************************/
/* Global Variables   Section                                                 */
/******************************************************************************/

ST_IOC_REG_t  *p_gst_ioc_base =
{
 (ST_IOC_REG_t *)IOC_BASE,
};


EN_IOC_RESULT IOC_Init()
{
    EN_IOC_RESULT   en_lresult = IOC_SUCCESS;

    /*Clear IOCFG6_PORTID */
    p_gst_ioc_base->IOCFG6 = ((0x00000000) & IOC_IOCFG6_PORT_ID_GPIO);

    /*Set the GPIO output */
    p_gst_ioc_base->IOCFG6 = IOC_IOCFG6_PORT_ID_GPIO;

    /* Clear IOCFG_IE bit set */
    p_gst_ioc_base->IOCFG6 = IOC_IOCFG6_IE_M;
}

/******************************************************************************/
/* End of IOC.c                                                              */
/******************************************************************************/
