#include "msp432.h"
#include "PhotoDiode_Sensor.h"

#define NUM_SAMPLES 8
#define MEASUREMENT_TIME 3
#define MV_REF 1200 /* Vref[mV] */
#define ADC_BITS 12 /* Be sure to match w/ ADC config */

int sample_index=0;
int voltage_ave=0;
int millivolts;
int volts;
unsigned int val;
unsigned int min, max;
unsigned int samples[NUM_SAMPLES];
unsigned int readingNo;
unsigned char idleCounter = 0;
unsigned char measurementCounter = 0;
bool sleeping;
bool reading;


int main(void) {
volatile int i;
max = 0;
min = UINT16_MAX;
sleeping = false;
reading = false;

diode_sensor_init();

WDTCTL = WDTPW | WDTHOLD;                 		// Stop WDT

// GPIO Setup
P1OUT &= ~BIT0;                           		// Clear LED to start
P1DIR |= BIT0;                            		// Set P1.0/LED to output
P5SEL1 |= BIT4;                           		// Configure P5.4 for ADC
P5SEL0 |= BIT4;

__enable_interrupt();

readingNo = 0;
reading = true;

diode_sensor_read();

while (1) {
    if (diode_sensor_read_result(&samples[readingNo]) == true) {
      // We got a result from the ADC, deal with it
      readingNo = (readingNo + 1) % NUM_SAMPLES;
      if( readingNo == 0) {
        // The result was the last one needed for this sensor, calculate the average
        // of the readings, and update min/max values.
        val = 0;
        for (i=0;i<NUM_SAMPLES;i++) {
          val += samples[i];
        }
        val = val >> 3;
        if (val > max) {
          max = val;
        }
        if (val < min) {
          min = val;
        }

        voltage_ave = 0;
        for (i=0; i<NUM_SAMPLES; i++) {
        voltage_ave = voltage_ave + samples[i];
        }
        voltage_ave = voltage_ave / NUM_SAMPLES; //>> 4; // divide by 4 by right shifting 2
        //theVoltage = (voltage_ave*1.2) / 4096 * 100; //in mV
        millivolts = (voltage_ave * MV_REF) >> ADC_BITS; //shift replaces /4096
        volts = millivolts / 1000;
        for (i=0; i<NUM_SAMPLES; i++) {
          samples[i] = 0;
        }
        P1OUT ^= BIT0;  // Toggle LED0 after every average
        sample_index = 0;
          //  reset reading state and update display
          ADC14CTL0 &= ~(REFON|ADC14ON);
          reading = false;
          measurementCounter = 0;
          //curVal = 0;
      } else {
        // We need more readings for the current sensor
        diode_sensor_read();
      }
   }  else {
      // No ADC result. We are thus awoken by (not mutual exclusive).
      // a) the user pressing a button.
      // b) idleCounter reached the defined value.
      // c) measurementCounter reached the defined value.
      //
      // a) and b) are both handled in updateDisplay
      //updateDisplay();

      if( measurementCounter >= MEASUREMENT_TIME && reading == false) {
        // Deal with c) here:
        reading = true;
        diode_sensor_read();
      }
    }
    if( !reading && sleeping) {
      __sleep();
    } else {
      __sleep();
    }
  }
 //   return 0;
    __no_operation();                       // For debugger
}
