/*
 * SAR.c
 *
 * Description:
 *  Controls the ADC of the dsp chip.
 *
 *  Created on: Jan 5, 2018
 *      Author: aaron.jencks
 */

// Included libraries
#include <csl_sar.h>
#include <csl_general.h>
#include <stdio.h>

/* SAR object Structure    */
CSL_SarHandleObj SarObj;
CSL_SarHandleObj *SarHandle;

int SAR_initialize();
unsigned short * SAR_ReadValues(unsigned short num);

int SAR_initialize()
{
    printf("Beginning SAR initialization...\n");
    CSL_Status    status;
    CSL_SarChSetup param;
    int chanNo;

    // Initializes the SAR.
    status = SAR_init();
    if(status != CSL_SOK)
    {
        printf("SAR Init Failed!!\n");
        return(1);
    }
    printf("SAR Init successfull!\n");

    /* Open SAR channel */
    status = SAR_chanOpen(&SarObj,CSL_SAR_CHAN_3);
    SarHandle = &SarObj;
    if(status != CSL_SOK)
    {
        printf("SAR_chanOpen Failed!!\n");
        return(2);
    }
    /* Initialize channel */
    status = SAR_chanInit(SarHandle);
    if(status != CSL_SOK)
    {
        printf("SAR_chanInit Failed!!\n");
        return(3);
    }
    param.OpMode = CSL_SAR_POLLING;
    param.MultiCh = CSL_SAR_NO_DISCHARGE;
    param.RefVoltage = CSL_SAR_REF_VIN;
    param.SysClkDiv = 0x0b ;
    /* Configuration for SAR module */
    status = SAR_chanSetup(SarHandle,&param);
    if(status != CSL_SOK)
    {
        printf("SAR_chanConfig Failed!!\n");
        return(4);
    }
    /* Set channel cycle set */
    status = SAR_chanCycSet(SarHandle,CSL_SAR_CONTINUOUS_CONVERSION);
    if(status != CSL_SOK)
    {
        printf("SAR_chanCycSet Failed!!\n");
        return(5);
    }
    /* set ADC Measurement parameters */
    status = SAR_A2DMeasParamSet(SarHandle,CSL_KEYPAD_MEAS,&chanNo);
    if(status != CSL_SOK)
    {
        printf("SAR_A2DMeasParamSet Failed!!\n");
        return(6);
    }
    printf("Channel Number selected %d\n",chanNo);
    /* start the conversion */
    status = SAR_startConversion(SarHandle);
    if(status != CSL_SOK)
    {
        printf("SAR_startConversion Failed!!\n");
        return(7);
    }
    printf("SAR Initialization competed successfully!\n");
    return 0;
}

unsigned short * SAR_ReadValues(unsigned short num)
{
    printf("Attempting to read samples from the ADC...\n");

    CSL_Status    status;
    Uint16 readBuffer;
    unsigned short i;
    unsigned short *result;

    for(i = 0; i < num; i++)
    {
        // Waits until the SAR is available.
        while(CSL_SAR_DATA_AVAILABLE !=
               SAR_getStatus(SarHandle,&status));

        // Reads the value
        status = SAR_readData(SarHandle, &readBuffer);
        if(status != CSL_SOK)
            {
                printf("SAR_readData Failed!!\n");
                return(result);
            }

        // Stores the value into the array to be returned
        *(result + i) = readBuffer;

        // Prints out the read value
        printf("SAR ADC read data 0x%x\n",readBuffer);
    }

    // Returns the array to the caller
    printf("Successfully read %d samples", i);
    return result;

}

