/****************************************************************************/
/*  C6713.cmd                                                               */
/*  Copyright (c) 2010 Texas Instruments Incorporated                       */
/*  Author: Rafael de Souza                                                 */
/*                                                                          */
/*    Description: This file is a sample linker command file that can be    */
/*                 used for linking programs built with the C compiler and  */
/*                 running the resulting .out file on an TMS320C6713        */
/*                 device.  Use it as a guideline.  You will want to        */
/*                 change the memory layout to match your specific C6xxx    */
/*                 target system.  You may want to change the allocation    */
/*                 scheme according to the size of your program.            */
/*                                                                          */
/****************************************************************************/

MEMORY
{
    IRAM     o = 0x00000000  l = 0x00030000  /* 192kB - Internal RAM */
    L2RAM    o = 0x00030000  l = 0x00010000  /* 64kB - Internal RAM/CACHE */
    EMIFCE0  o = 0x80000000  l = 0x10000000  /* SDRAM in 6713 DSK */
    EMIFCE1  o = 0x90000000  l = 0x10000000  /* Flash/CPLD in 6713 DSK */
    EMIFCE2  o = 0xA0000000  l = 0x10000000  /* Daughterboard in 6713 DSK */
    EMIFCE3  o = 0xB0000000  l = 0x10000000  /* Daughterboard in 6713 DSK */
}

SECTIONS
{
    .text          >>  IRAM | L2RAM
    .stack         >  IRAM | L2RAM  fill = 0xCAFECAFE
    .bss           >  IRAM | L2RAM
    .cio           >>  IRAM | L2RAM
    .const         >>  IRAM | L2RAM
    .data          >>  IRAM | L2RAM
    .switch        >>  IRAM | L2RAM
    .sysmem        >  IRAM | L2RAM
    .far           >>  IRAM | L2RAM
    .args          >>  IRAM | L2RAM
    .ppinfo        >>  IRAM | L2RAM
    .ppdata        >>  IRAM | L2RAM
  
    /* COFF sections */
    .pinit         >>  IRAM | L2RAM
    .cinit         >  IRAM | L2RAM
  
    /* EABI sections */
    .binit         >>  IRAM | L2RAM
    .init_array    >>  IRAM | L2RAM
    .neardata      >>  IRAM | L2RAM
    .fardata       >>  IRAM | L2RAM
    .rodata        >>  IRAM | L2RAM
    .c6xabi.exidx  >>  IRAM | L2RAM
    .c6xabi.extab  >>  IRAM | L2RAM

}
