/*
 * Codec_AIC23.h
 *
 *  Created on: May 23, 2017
 *      Author: User
 */

//. Invia due campioni al ch dx / sx, mediante routine interrupt temporale (periodo conteggio 51MHz eseguito ogni  _timerPeriod emesso un nuovo campione, per un intervallo di  _timerPeriod / 51MHz)
//. Legge campioni mediante interrupt seriale McBSP (Sriale 1 Rx letturea ADC acquisizione segnale su Uint32 di cui 16 bit nteri per canale dx e 16 canale sx) mediante codec AIC23
//. Scrive campioni mediante interrupt Timer1 su seriale McBSP (Sriale 1 Tx scrittura su DAC scrittura segnale su Uint32 di cui 186 bit nteri per canale dx e 16 canale sx) mediante codec AIC23
//. Seriale 0 viene usata per segnali di controllo al codec AIC23
//. Grandezze di impostazione : segnale digitale sinusoide Ampiezza - Frequenza.
//. Periodo ripetizione timer : quano raggiunge _timerPeriod (1000) (ogni conteggio a 1/_clkTimer (51000000) ) = T_rip_cmpione = 1.9608e-06s , viene generato interrupt teporale da TIMER1, ed emesso campione
//  mediante seriale 1 McBSP Tx scrivendo il campione da emettere
//  Dopo T_rip_cmpione * N_campioni = Periodo_segnale (440Hz) = 1/440Hz ==> N_campioni = 1/440 * 1/T_rip_cmpione = 1/440Hz * 1/T_rip_cmpione = 1.9608e-06s =  1.1591e+03
//  Sono memorizzati sul vettore Globale : "bufferRx_rigth" cui dimensione  la costante "BUFFER_RX_SIZE" (=1159)

//Ref. : https://e2e.ti.com/support/dsp/tms320c6000_high_performance_dsps/f/115/t/598596
//		 https://e2e.ti.com/support/dsp/tms320c6000_high_performance_dsps/f/115/t/413968
//		 http://www.ti.com/product/TLV320AIC23B/technicaldocuments

#ifndef CODEC_AIC23_H_
#define CODEC_AIC23_H_

#include "../Hw_Config/Hw_config.h"

//Const
#define _timerPeriod 1000  			//!! n.b. ADC or DAC conversion rate 96 kHz (massima accettabie per produre prosimo campione da ripordurre) !!
#define FondoscalaMax 0xFFFFFF	    //!! n.b. DAC 0-dB full-scale output voltage (16777215) 1.0 VRMS !!

//								**	Globals	**

//DSK 6713 board resources
DSK6713_AIC23_CodecHandle hCodec;

//Write (Timer event e Interrupt 14 per scrivere sinusoide)
Uint32 TimerEventId1;
TIMER_Handle hTimer1;				//Handle timer 1
Bool testTimeCount;					//flag segnalazione del processo scrittura (a timer) completato: nuovo campione emesso
volatile double istanteTemporale;	//Tempo  del segnale discreto calcolato per emettere prossimo campione
volatile Bool writingRoutine;		//Flag segnalazione operazione scrttura in corso
double testSin;						//Valore del segnale discreto calcolato per emettere prossimo campione

Int32 Amplitude;					//Ampiezza segnale discreto
Int32 Frequence;  					//Frequenza segnale discreto : 1kHz


#define BUFFER_RX_SIZE  300//118
Int32 bufferRx_rigth[BUFFER_RX_SIZE];
Int32 bufferRx_left[BUFFER_RX_SIZE];
Uint32 countBuffer  = 0;
Uint32 countBuffer1 = 0;
Uint32 countBuffer2 = 0;
Uint32 countBuffer21 = 0;
volatile Bool testReceiveFull;					//flag segnalazione del processo LETTURA (cone evento ricezione interrupt seriale 1) completato: nuovo campione letto nel bufer
volatile Bool testReceiveDone;					//flag segnalazione del processo LETTURA (cone evento ricezione interrupt seriale 1) completato: nuovo campione letto nel bufer

GPIO_Handle hGpio;

//									**	Prototipe	**

void   write_Codec_AIC23_valueStereo(DSK6713_AIC23_CodecHandle hCodec, Int32 val1, Int32 val2);
Uint32 read_Codec_AIC23_value(DSK6713_AIC23_CodecHandle hCodec);
void initTimer(Uint32 period);
Uint32 routine_convIntToUInt(Int32 number);			//Trasforma intero con segno   (16bit) in intero senza segno (16 bit)
Int32  routine_convUIntToInt(Uint32 number);		//Trasforma intero senza segno (16bit) in intero con segno   (16 bit)

//									** Strutture e costanti di impostazione CODE AIC23 & TIMER1

//Struttura di configurazione del Timer
static Uint32 TimerControl = TIMER_CTL_RMK( /* Timer control register (CTL)*/
  TIMER_CTL_INVINP_NO, /* TINP inverter control(INVINP). Only affects operation
                          if CLKSRC =0.
                           TIMER_CTL_INVINP_NO  - Uninverted TINP drives timer
                           TIMER_CTL_INVINP_YES - inverted TINP drives timer */

  TIMER_CTL_CLKSRC_CPUOVR4,/* Timer input clock source (CLKSRC)
                           TIMER_CTL_CLKSRC_CPUOVR4 - CPU clock /4           */

  TIMER_CTL_CP_PULSE, /* Clock/pulse mode(CP)
                           TIMER_CTL_CP_PULSE - Pulse mode.TSTAT is active one
                                CPU clock after the timer reaches the timer
                                period.PWID determines when it goes inactive.*/

  TIMER_CTL_HLD_YES, /* Hold(HLD). Counter may be read or written regardless of
                        HLD value.
                           TIMER_CTL_HLD_YES - Counter is disabled and held in
                                current value.
                           TIMER_CTL_HLD_NO - COunter is allowed to count.   */

  TIMER_CTL_GO_NO, /* Go bit(GO). Resets and starts the timer counter.
                           TIMER_CTL_GO_NO - No effects on the timer.
                           TIMER_CTL_GO_YES - if HLD =1, the counter register
                                is zeroed and begins counting on next clock. */
  TIMER_CTL_PWID_ONE, /* Pulse width(PWID). Only used in pulse mode.
                           TIMER_CTL_PWID_ONE - TSTAT goes inactive one timer
                                input clock cycle after the timer counter value
                                equals the timer period value.
                           TIMER_CTL_PWID_TWO -  TSTAT goes inactive one timer
                                input clock cycle after the timer counter value
                                equals the timer period value.               */

  TIMER_CTL_DATOUT_0, /* Data output (DATOUT).
                           TIMER_CTL_DATOUT_0 - If FUNC  =0,the DATOUT is
                                driven on TOUT.
                           TIMER_CTL_DATOUT_1 - If FUNC =1,The DATOUT is driven
                                on TOUT after inversion by INVOUT.           */

  TIMER_CTL_INVOUT_NO, /* TOUT inverter control (INVOUT)
                           TIMER_CTL_INVOUT_NO - Uninverted TSTAT drives TOUT
                           TIMER_CTL_INVOUT_YES - Inverted TSTAT drives TOUT.*/
  TIMER_CTL_FUNC_GPIO /* Function of TOUT pin(FUNC).
                           TIMER_CTL_FUNC_GPIO - TOU is a general purpose
                                output pin
                           TIMER_CTL_FUNC_TOUT - TOUT is a timer output pin  */

);

/* Codec configuration settings */
DSK6713_AIC23_Config config1 = { \
			0x0000,  /* 0 DSK6713_AIC23_LEFTINVOL  volume del canale ingresso sinistro*/ \
		    0x0017,  /* 1 DSK6713_AIC23_RIGHTINVOL volume del canale ingresso destro */\
		    0x00d8,  /* 2 DSK6713_AIC23_LEFTHPVOL  volume dell'headphone dela canale sinistro */  \
		    0x00d8,  /* 3 DSK6713_AIC23_RIGHTHPVOL volume dell'headphone dela canale sinistro */ \
		    0x0011,  /* 4 DSK6713_AIC23_ANAPATH    controllo del percorso dell' audio analogico */      \
		    0x0000,  /* 5 DSK6713_AIC23_DIGPATH    controllo del percorso dell' audio digitale */     \
		    0x0000,  /* 6 DSK6713_AIC23_POWERDOWN  controllo del power down */             \
		    0x0043,  /* 7 DSK6713_AIC23_DIGIF      formato dell'interfaccia audio digitale */ \
		    0x0081,  /* 8 DSK6713_AIC23_SAMPLERATE controllo del tasso dei campioni */            \
		    0x0001   /* 9 DSK6713_AIC23_DIGACT     attivazione dell'interfaccia digitale */   \

};


union { // union structure to facilitate 32-bit data transfers
	Uint32 u; // both channels packed as codec.u = 32-bits
	Uint16 c[2]; // left-channel = codec.c[1], right-channel = codec.c[0]
} codec, codecDebug;


//								** Definizione Routine	**


//Srittura campioni al codec AIC23 (modalit stereo)
void write_Codec_AIC23_valueStereo(DSK6713_AIC23_CodecHandle hCodec, Int32 val1, Int32 val2){
	Uint32 valueToPlay1 = 0;
	Uint32 valueToPlay2 = 0;
	valueToPlay1 = routine_convIntToUInt(val1);
	valueToPlay2 = routine_convIntToUInt(val2);

	if( (val1<=FondoscalaMax)){
		//Creates a loop until the port is ready to transmit.
		while(!DSK6713_AIC23_write(hCodec, valueToPlay1)){}	//Sx ch
	}
	if( (val2<=FondoscalaMax)){
		//Creates a loop until the port is ready to transmit.
		while(!DSK6713_AIC23_write(hCodec, valueToPlay2)){}	//Dx ch
	}

}

//Lettura campioni dal codec (modalit singolo canale)
Uint32 read_Codec_AIC23_value(DSK6713_AIC23_CodecHandle hCodec){
	Uint32 valueToRet = 0;
	Uint32 * IN_VAL;

	//Creates a loop until the port is ready to transmit.
	while (!DSK6713_AIC23_read(hCodec, IN_VAL));	//Single ch

	valueToRet = *IN_VAL;
	return valueToRet;
}


//Timer

void initCodecAIC23(Uint32 period)
{

	//INIT del codec AIC23
	DSK6713_rset(DSK6713_MISC,0x00);
	hCodec = DSK6713_AIC23_openCodec(0, &config1);
	DSK6713_AIC23_setFreq(hCodec, DSK6713_AIC23_FREQ_48KHZ);
	//--------------------------

	//INIT pin led per debug processo
	DSK6713_LED_init( ) ;
	//--------------------------

	//Init variabili e globals
	for(countBuffer=0;countBuffer<BUFFER_RX_SIZE;countBuffer++){
		bufferRx_rigth[countBuffer] = 0;
		bufferRx_left[countBuffer]  = 0;
	}

	testTimeCount 		= 0;
	istanteTemporale 	= 0;

	writingRoutine		= 0;
	countBuffer 		= 0;
	testReceiveFull 	= 0;
	testReceiveDone 	= 0;

	/* Open TIMER1 device, and reset them to power-on default state */
	hTimer1 = TIMER_open(TIMER_DEV1, TIMER_OPEN_RESET);

	/* Obtain the event ID for the timer device */
	TimerEventId1 = TIMER_getEventId(hTimer1);
	IRQ_setVecs(vectors);     /* point to the IRQ vector table    */
	IRQ_globalEnable();       /* Globally enable interrupts       */
	IRQ_nmiEnable();          /* Enable NMI interrupt             */



	//McBSP1 (in RX  lettura dal codec AIC23) INIT per lettura campioni dal codec (interrupt seriale McBSP), mediante INTERRUPT SERIALE1 11
	IRQ_map(IRQ_EVT_RINT1,11);        // Maps an event to a physical interrupt
	IRQ_reset(IRQ_EVT_RINT1);
	IRQ_enable(IRQ_EVT_RINT1);        // Enables the event

	//TIMER INIT per scrittura campioni al code canale dx / sx (interrupt temporale)

	/* Map TIMER events to physical interrupt number */
	IRQ_map(TimerEventId1, 14);

	/* Reset the timer events */
	IRQ_reset(TimerEventId1);

	/* Configure the timer devices */
	TIMER_configArgs(hTimer1,
			TimerControl, 	/* use predefined control value  */
			_timerPeriod,   /* set period                    */
			0x00000000    	/* start count value at zero     */
	);

	/* Enable the timer events(events are disabled while resetting) */
	IRQ_enable(TimerEventId1);

	/* Start the timers */
	TIMER_start(hTimer1);

}

//Routine di conversione interi (con segno / senza segno), usate in lettura e scrittura campioni (dal codec AIC23)

Uint32 routine_convIntToUInt(Int32 numero){
	Uint32 retVal = 0;

	if(numero <0){
		retVal = numero+65536;
	}else{
		retVal = numero;
	}

	return retVal;
}

Int32  routine_convUIntToInt(Uint32 numero){
	Int32 retVal = 0;

	if(numero >=32768){
		retVal = numero-65536;
	}else{
		retVal = numero;
	}

	return retVal;
}


//										**	Routine interrupt (Associata al rx McBSP) -> Lettura campioni	**

interrupt void c_int11(void) /* DMA 2 */
{
	IRQ_clear(IRQ_EVT_RINT1);
	IRQ_reset(IRQ_EVT_RINT1);

	Uint32 *IN_L;
	testReceiveDone = 1;

	if(testTimeCount==1){

		//---
		Uint32 * IN_VAL;

		IN_VAL = (Uint32 *)(_MCBSP_hDev1->drrAddr);//(Uint32 *)(DSK6713_AIC23_DATAHANDLE->drrAddr);//
		Uint32 val = * IN_VAL ;
		codec.u = val; 						// read 32-bit word
		Uint32 dxL1 = codec.c[1]; 			// unpack the two 16-bit parts
		Uint32 dxR1 = codec.c[0];

		bufferRx_rigth[countBuffer] = routine_convUIntToInt(codec.c[0]);
		//bufferRx_left[countBuffer]  = dxL1;
		//---

		countBuffer++;
		if(countBuffer>=BUFFER_RX_SIZE){
			countBuffer = 0;
			testReceiveFull = 1;

			countBuffer1++;
//			//--------------------
//			//Debug
			if(countBuffer1==10){
				countBuffer1 = 0;
				Int32 i = 0;
				for(i=0;i<BUFFER_RX_SIZE;i++){
					printf("%i	%i\n",bufferRx_left[i], bufferRx_rigth[i] );
				}
				i=0;
			}
//			//--------------------
//
		}


		testTimeCount=0;
	}


	IRQ_enable(IRQ_EVT_RINT1);
}

//Routine interrupt (Associata al timer-interrupt) -> Scrittura campioni

interrupt void c_int14(void) /* DMA 2 */
{
	TIMER_pause(hTimer1);
	writingRoutine = 1;

	if(istanteTemporale>9.9999e+307 ){
		istanteTemporale = 0.0 ;
	}

	DSK6713_LED_toggle(0);

	//*****************
	istanteTemporale = istanteTemporale+(double)(((double) _timerPeriod)/((double) _clkTimer));
	testSin = ( ((double)Amplitude) * sin( 2.0*3.1415*((double)Frequence)*((double)istanteTemporale)+0.0 ) ) ;
	Int32 value = (Int32)testSin;
	//*****************

	write_Codec_AIC23_valueStereo(hCodec,value,value);

	//Uint32 debgNum = read_Codec_AIC23_value(hCodec);

	MCBSP_read(_MCBSP_hDev1);//DSK6713_AIC23_read(hCodec, IN_VAL);


	testTimeCount = 1;

	//bufferSin[countBuffer] = testSin;
    /*
	*IN_L1 = read_Codec_AIC23_value(hCodec);
	*IN_L2 = read_Codec_AIC23_value(hCodec);

	Int32 s = routine_convUIntToInt((*IN_L1));
	Int32 d = routine_convUIntToInt((*IN_L2));
	amplitudeSS[countBuffer] = s+d;
	countBuffer++;
	if(countBuffer>118){
		countBuffer = 0;
		int i = 0;
		for(i=0;i<118;i++){
			//printf("%i\n", amplitudeSS[i]);
		}
		i=0;
	}*/


	//Segnalo flag scrittura eseguita e trasmissione campione


	//Debug----------------
	/*Int32 valoreInt = (Int32)testSin;
	bufferSin[countBuffer] = valoreInt;
	bufferTime[countBuffer] = ((Int32)(istanteTemporale*100000.0));
	if(countBuffer>=46){
		countBuffer=0;
		int i = 0;
		for(i=0;i<46;i++){
			printf("%i , %d\n", bufferTime[i], bufferSin[i] );
		}
		i=0;
	}
	countBuffer++;*/
	//Debug----------------

	TIMER_resume(hTimer1);
	writingRoutine = 0;
}

#endif /* CODEC_AIC23_H_ */
