/*
 * main.c
 */
#include "main.h"

// Parametri relativi a dimensione LUT, e frequenze varie
#define SAMPLING_FREQUENCY 8000
#define SAMPLING_PERIOD 1.0/SAMPLING_FREQUENCY
#define SINEWAVE_FREQUENCY   50
#define N_PERIODS            50
#define LUT_LENGTH    N_PERIODS*SAMPLING_FREQUENCY/SINEWAVE_FREQUENCY // NOTA: Questo presume campionamento con fc multiplo intero di f0
#define SIGNAL_DURATION 1.0*LUT_LENGTH*SAMPLING_PERIOD
#define SAMPLES_PER_PERIOD	SAMPLING_FREQUENCY/SINEWAVE_FREQUENCY //  da usare per generare registri
																  //  a lunghezza parametrizzata

#define DIP_START_TIME  0.4   // Con start si intende l'inizio del transitorio di discesa
#define DIP_FALL_TIME   0.02  // tempo di discesa dal valore nominale a quello del buco
#define DIP_DURATION    0.1  // durata del buco a regime
#define DIP_RISE_TIME   0.02  // tempo di salita dal valore del buco a quello nominale
// NB: si ipotizza un profilo lineare per le transizioni dell'inviluppo
#define DIP_DEPTH       0.89  // profondit del buco, rispetto al valore nominale
#define PI 3.14159265358979323
#define DAC_DIGITAL_FS 32768
#define HISTERESIS_SAMPLES 40

// Potenze di due e indirizzo per accedere alla porta parallela

#define _TWO_POW_0		1
#define _TWO_POW_1		2
#define _TWO_POW_2		4
#define _TWO_POW_3		8
#define _TWO_POW_4		16
#define _TWO_POW_5		32
#define _TWO_POW_6		64
#define _TWO_POW_7		128
#define _TWO_POW_8		256
#define _TWO_POW_9		512
#define _TWO_POW_10		1024
#define _TWO_POW_11		2048
#define _TWO_POW_12		4096
#define _TWO_POW_13		8192
#define _TWO_POW_14		16384
#define _TWO_POW_15		32768
#define _TWO_POW_16		65536
#define _TWO_POW_17		131072
#define _TWO_POW_18		262144
#define _TWO_POW_19		524288
#define _TWO_POW_20		1048576
#define _TWO_POW_21		2097152
#define _TWO_POW_22		4194304
#define _TWO_POW_23		8388608
#define	FLAG_ADDRESS		 ((volatile unsigned int *) 0xA0000000)

//Int32 LUT_INT_2[LUT_LENGTH];
int LUT_INT[LUT_LENGTH];
int ACQUIRED_DATA[LUT_LENGTH];
float LG_evolution[LUT_LENGTH];
float A_vector[LUT_LENGTH];


double estimated_digital_amplitude=10034; double estimated_digital_offset=0.3365;
double estimated_phi=-0.0845;
// Configuration settings del CODEC
DSK6713_AIC23_Config config = {
    0x0017, // 0 DSK6713_AIC23_LEFTINVOL  Left line input channel volume
    0x0017, // 1 DSK6713_AIC23_RIGHTINVOL Right line input channel volume
    0x00d8, // 2 DSK6713_AIC23_LEFTHPVOL  Left channel headphone volume
    0x00d8, // 3 DSK6713_AIC23_RIGHTHPVOL Right channel headphone volume
    0x0011, // 4 DSK6713_AIC23_ANAPATH    Analog audio path control
    0x0000, // 5 DSK6713_AIC23_DIGPATH    Digital audio path control
    0x0000, // 6 DSK6713_AIC23_POWERDOWN  Power down control
    0x0043, // 7 DSK6713_AIC23_DIGIF      Digital audio interface format
    0x000D, // 8 DSK6713_AIC23_SAMPLERATE Sample rate control (8KHz)
    0x0001  // 9 DSK6713_AIC23_DIGACT     Digital interface activation
};

/* ---------------------------------------------------------------------------*/
void main() {

	// Creo l'oggetto hCodec
	    DSK6713_AIC23_CodecHandle hCodec;

		// Definisco le variabili necessarie alla creazione della LUT
		double dip_start_time = DIP_START_TIME;
	    double dip_fall_time=DIP_FALL_TIME;
	    double dip_duration=DIP_DURATION;
	    double dip_rise_time=DIP_RISE_TIME;
	    double sampling_period=SAMPLING_PERIOD;
	    double	A=1.0;
		double 	s_A_0= A*DAC_DIGITAL_FS;
		double  s_A_1=A*(DAC_DIGITAL_FS-1);
	    double temp,temp2;
		int temp_int;
		int start_fall_index=(int)floor(dip_start_time/sampling_period);
	    int end_fall_index=(int)floor((dip_start_time+dip_fall_time)/sampling_period);
	    int start_rise_index=(int)floor((dip_start_time+dip_fall_time+dip_duration)/sampling_period);
	    int end_rise_index=(int)floor((dip_start_time+dip_fall_time+dip_duration+dip_rise_time)/sampling_period);
	    double fall_slope=1.0*(DIP_DEPTH-1)/(end_fall_index-start_fall_index); // pendenza del transitorio di discesa
	    double rise_slope=1.0*(1-DIP_DEPTH)/(end_rise_index-start_rise_index); // pendenza del transitorio di salita
	    int n, wait_flag=0, histeresis_counter=0;

		// Definisco le variabili relative al test GLRT
		int b=16;
		int j;
		int Fc=8000;
		int Fo=50;
		int N=Fc/Fo; // numero di campioni per periodo N=Fc/Fo
		Uint32 shiftregister[160];
		Uint32 c;
		int i; // numero di campioni acquisiti (dimensione di "buffer")
			//	  NB i=(40+P*160)*2 dove P=# di periodi acquisiti
			//	  P=1  ->  i= 400
			//	  P=2  ->  i= 720
			//	  P=3  ->  i= 1040
			//	  P=4  ->  i= 1360
		int soglia,k;	// relativi alla modifica dovuta al com a 2
		int shiftregisterB[160];
		//double delta; // delta ADC, con l'approccio seguito non dovrebbe servire
		double FS=sqrt(2);
		float shiftregisterV[160];
		float V;

		int n0_stim= 10; // NB gli shiftregister "corti" devono essere lunghi N-n0_stim
		//float avgV=1.353654701038923*pow(10,-5); // Questo era stato stimato da misure pregresse
		// con il blocco di condizionamento, quindi lo leviamo
		// float G=0.4581242658639577;  // G adc // Commento, non serve
		double A0=1.0; 	// tensione di picco nominale [V] (nei file prec era Vp_nominale)
						// divido per due: vedi setup_vsag_001_GLRT.m Calabresi: A0=sqrt(2)*1;
						// Potrei anche mettere A0 pari a quella digitale, comunque se dopo normalizzo
		// la soluzione A0=1 mi sembra la migliore
		double T=50;  // soglia 17.0094
		int ptot=150;	// periodi acquisiti

		int periodi=1;   // periodo corrente
	    int z;
		float array[150]; // vettore di test lungo ptot
	//	int zz=0;

		float shiftregisterVt[160];
		float Vt;

		double acc_S0_stim=0;
		double S0_stim_values[160];
		double S0_stim=0;
		double S0_stim2=0;

		double acc_num=0;
		double num_values[150];
		double acc_den=0;
		double den_values[150];
		double acc_num2=0;
		double acc_den2=0;
		double A_stim=0;
		double A_stim2=0;

		double A_stimFISSO=0;
		double acc_S1b_stim=0;
		double S1b_stim_values[150];
		double S1b_stim=0;
		double S1b_stim2=0;

		double acc_S1a_stim=0;
		double acc=0;
		double S1a_stim=0;
		double S1a_stim_values[150];
		double S1a_stim2=0;

		double Lg=0;
		double Lg2=0;

		soglia=pow(2,b-1);
		k=pow(2,b)-1;


		//CSL_init();


	    // Inizializzo la BSL ed il modulo dei led
	    DSK6713_init();
		DSK6713_LED_init();
	    // Apro il codec
	    hCodec = DSK6713_AIC23_openCodec(0, &config);
		// Imposto la Fc pari a 8 KHz
		DSK6713_AIC23_setFreq(hCodec, DSK6713_AIC23_FREQ_8KHZ);

		// *************************************************************************

		// accendo i 4 led (start fase inizializzazione)
		DSK6713_LED_on(0);
		DSK6713_LED_on(1);
		DSK6713_LED_on(2);
		DSK6713_LED_on(3);


	   	// inizializzo i vettori
	 	for(i=0;i<N;i++)
	 	{
			shiftregister[i]=0;
			shiftregisterB[i]=0;
			shiftregisterV[i]=0;
			S0_stim_values[i]=0;
		}
	 	for(i=0;i<N-n0_stim;i++)
	 	{
			num_values[i]=0;
			den_values[i]=0;
			S1b_stim_values[i]=0;
			S1a_stim_values[i]=0;
		}

		//delta=2*FS/pow(2,b);




		// Genera la LUT
		for(n=0;n<LUT_LENGTH;n++)
	    {
	        // genera l'n-esimo campione double
	        temp=A*sin(2*PI*SINEWAVE_FREQUENCY*n/SAMPLING_FREQUENCY);
	        temp2=temp;
	        // applica le maschere con degli if
	        if((n>=start_fall_index)&&(n<end_fall_index))
	        {
	            temp2=temp*(1+fall_slope*(n-start_fall_index));
	        }
	        if((n>=end_fall_index)&&(n<start_rise_index))
	        {
	            temp2=temp*DIP_DEPTH;
	        }
	        if((n>=start_rise_index)&&(n<end_rise_index))
	        {
	            temp2=temp*(DIP_DEPTH+rise_slope*(n-start_rise_index));
	        }
	        // adesso crea gli interi equivalenti
	        if(temp2>=0)
	            temp2=s_A_1*temp2; //double
	        else
	            temp2=s_A_0*temp2;  // cosi i valori del seno andranno
	        // (dopo esser stati convertiti in int32) da -32768 a +32767
			// che rappresenta il range del codec

	 		// int32
	 		LUT_INT[n]=0;//((temp2-floor(temp2))>0.5) ? (floor(temp2)+1) : (floor(temp2));
	    }

		// tronco i primi 40000 campioni  (tolgo il transitorio)
	 	for(i=0;i<40000;i++)
	 	{
			while(!DSK6713_AIC23_read(hCodec, &c));
		}

		// preset porta parallela
		*(FLAG_ADDRESS)=0;

		// spengo i 4 led (stop fase inizializzazione)
		DSK6713_LED_off(0);
		DSK6713_LED_off(1);
		DSK6713_LED_off(2);
		DSK6713_LED_off(3);

	    //     ****************    Acquisisco il segnale    ****************
		z=0;
		i=0;
		j=0;
		n=0;

		//	for(z=0;z<ptot*2*N;z++){  // NB se uso il for non devo aggiornare z!!
		while(1)
		{
			// Qui deve scrivere sul DAC
			// Send a sample to the left channel
	        while (!DSK6713_AIC23_write(hCodec, LUT_INT[n]));
	        // Send a sample to the right channel
	        while (!DSK6713_AIC23_write(hCodec, LUT_INT[n]));


			// legge un dato
			//while(!DSK6713_AIC23_read(hCodec, &data));
			//sin_acquisita[h][n] = data;
			while(!DSK6713_AIC23_read(hCodec, &c));

		}
}

