#ifndef LIB_H
#define LIB_H

	#include <csl.h>
	#include <csl_mcbsp.h>
	#include <csl_edma.h>
	#include <csl_dma.h>
	#include <csl_irq.h>
	#include <csl_chip.h>
	#include <csl_chiphal.h>.h>
	#include <stdio.h>

#endif

#define CHIP_6713 1

/* Create buffers and aligning them on an L2 cache line boundary. */
#pragma DATA_SECTION(xmitbuf2,"xmit_buf");
unsigned short xmitbuf2[0x0400];

#pragma DATA_SECTION(recvbuf2,"recv_buf");
unsigned short recvbuf2[0x0400];

/* Definitions	*/
#define BUFFER_SIZE	27				/* total number of UART data words	*/
#define TRUE 1
#define FALSE 0

/* Declare CSL objects */
MCBSP_Handle hMcbsp1; /* handle for McBSP1  */
#if (EDMA_SUPPORT)
EDMA_Handle hEdma14; /* handle for EDMA 14 */
EDMA_Handle hEdma15; /* handle for EDMA 15 */
#endif
#if (DMA_SUPPORT)
DMA_Handle hDma1; /* handle for DMA 1 */
DMA_Handle hDma2; /* handle for DMA 2 */
#endif

/* Global Variables	*/
volatile int receive_done2 = FALSE;
volatile int transmit_done2 = TRUE;
char xmit_msg2[BUFFER_SIZE] = "A";
char recv_msg2[BUFFER_SIZE] = "Transmission didn't work!\n";

/* Include the vector table to call the IRQ ISRs hookup */
extern far void vectors();

/* Prototypes	*/
void preInitConfig2(void);
void postConfig2(void);
void ConfigMcBSP2(void);
void ConfigEDMA2(void);
void ConfigDMA2(void);
void ProcessTransmitData2(char* xmit_msg, int lengthArray);
void ProcessTransmitData_test2(void);


void preInitConfig2(void) {

	int waittime = 0;

	/* enable NMI and GI */
	IRQ_nmiEnable();
	IRQ_globalEnable();

	/* point to the IRQ vector table */
	IRQ_setVecs(vectors);

#if (EDMA_SUPPORT)

	/* disable and clear the event interrupt */
	IRQ_reset(IRQ_EVT_EDMAINT);

	/* clear Parameter RAM of EDMA */
	EDMA_clearPram(0x00000000);

#endif

#if (DMA_SUPPORT)

	DMA_reset(INV);

#endif

	//------------------------------------
	ProcessTransmitData_test2();
	//------------------------------------


#if (EDMA_SUPPORT)

	/* Open the EDMA channels - EDMA 14 for transmit, EDMA 15 for receive	*/
	hEdma14 = EDMA_open(EDMA_CHA_XEVT1, EDMA_OPEN_RESET);
	hEdma15 = EDMA_open(EDMA_CHA_REVT1, EDMA_OPEN_RESET);

#endif

#if (DMA_SUPPORT)

	/* Open the DMA channels - DMA 1 for transmit, DMA 2 for receive */
	hDma1 = DMA_open(DMA_CHA1, DMA_OPEN_RESET);
	hDma2 = DMA_open(DMA_CHA2, DMA_OPEN_RESET);

#endif



}




void postConfig2(void) {


#if (EDMA_SUPPORT)

	/* Configure the EDMA channels */
	ConfigEDMA2();

	/* enable EDMA-CPU interrupt tied to McBSP */
	IRQ_enable(IRQ_EVT_EDMAINT);

	/* enable EDMA channel interrupt to CPU */
	EDMA_intEnable(14);
	EDMA_intEnable(15);

	/* Enable EDMA channels */
	EDMA_enableChannel(hEdma14);
	EDMA_enableChannel(hEdma15);

#endif

#if (DMA_SUPPORT)

	/* Configure the DMA channels */
	ConfigDMA();

	IRQ_disable(IRQ_EVT_DMAINT1);
	IRQ_disable(IRQ_EVT_DMAINT2);

	IRQ_clear(IRQ_EVT_DMAINT1);
	IRQ_clear(IRQ_EVT_DMAINT2);

	IRQ_enable(IRQ_EVT_DMAINT1);
	IRQ_enable(IRQ_EVT_DMAINT2);

	DMA_start(hDma1); /*start DMA channel 1*/
	DMA_start(hDma2); /*start DMA channel 2*/

#endif

}




void ProcessTransmitData_test2(void)
{
	int		i;
	short	cnt = 1;
	unsigned char 	xmit_char;
	unsigned short	*xmitbufptr;

	/* point to Transmit Buffer	*/
	xmitbufptr = (unsigned short *)xmitbuf2;

	for (i=0; i<(sizeof(xmitbuf2)/sizeof(unsigned int)); i++)
	{
		xmitbufptr[i] = 0x0000;	/* zero fill buffer	*/
	}

	xmitbufptr = (unsigned short *)xmitbuf2;

	/* Process data BYTES in xmit_msg[] and put in xmit buffer	*/
	for (i = 0; i < BUFFER_SIZE; i++)
	{
	    /*Get transmit character (one byte) from xmit_msg[] and put in xmit buffer*/
		xmit_char	=	xmit_msg[i];

		/* Process each BYTE of transmit character	*/
		for (cnt = -1; cnt < 10; cnt++)
		{
			if (cnt == -1)
				*xmitbufptr++ 	= 	0x0000;

			else if (cnt == 8 || cnt ==9)
				*xmitbufptr++ 	= 	0xFFFF;

			else if (xmit_char & (1 << cnt))
				*xmitbufptr++	=	0xFFFF;

			else
				*xmitbufptr++	=	0x0000;

		}	/* end for cnt	*/

	}	/* end for i	*/

}	/* end ProcessTransmitData	*/

void ProcessTransmitData2(char* xmit_msg, int lengthArray)
{
	int		i;
	short	cnt = 1;
	unsigned char 	xmit_char;
	unsigned short	*xmitbufptr;

	/* point to Transmit Buffer	*/
	xmitbufptr = (unsigned short *)xmitbuf2;

	for (i=0; i<(sizeof(xmitbuf2)/sizeof(unsigned int)); i++)
	{
		xmitbufptr[i] = 0x0000;	/* zero fill buffer	*/
	}

	xmitbufptr = (unsigned short *)xmitbuf2;

	/* Process data BYTES in xmit_msg[] and put in xmit buffer	*/
	for (i = 0; i < BUFFER_SIZE; i++)
	{
	    /*Get transmit character (one byte) from xmit_msg[] and put in xmit buffer*/
		xmit_char	=	xmit_msg[i];

		/* Process each BYTE of transmit character	*/
		for (cnt = -1; cnt < 10; cnt++)
		{
			if (cnt == -1)
				*xmitbufptr++ 	= 	0x0000;

			else if (cnt == 8 || cnt ==9)
				*xmitbufptr++ 	= 	0xFFFF;

			else if (xmit_char & (1 << cnt))
				*xmitbufptr++	=	0xFFFF;

			else
				*xmitbufptr++	=	0x0000;

		}	/* end for cnt	*/

	}	/* end for i	*/

}	/* end ProcessTransmitData	*/



/*******************************************************************/
/* void ConfigEDMA(void): set up EDMA channel 14/15 for UART Xmit  */
/*******************************************************************/
#if (EDMA_SUPPORT)

void ConfigEDMA2(void) {
	EDMA_configArgs(hEdma14,

	/* OPT Setup */
#if (C64_SUPPORT)
			EDMA_OPT_RMK(
					EDMA_OPT_PRI_HIGH, /* 1  */
					EDMA_OPT_ESIZE_16BIT, /* 01 */
					EDMA_OPT_2DS_NO, /* 0  */
					EDMA_OPT_SUM_INC, /* 01 */
					EDMA_OPT_2DD_NO, /* 0  */
					EDMA_OPT_DUM_NONE, /* 00 */
					EDMA_OPT_TCINT_YES, /* 1  */
					EDMA_OPT_TCC_OF(14), /* 14 */
					EDMA_OPT_TCCM_DEFAULT, /* 0  */
					EDMA_OPT_ATCINT_DEFAULT, /* 0  */
					EDMA_OPT_ATCC_DEFAULT, /* 0  */
					EDMA_OPT_PDTS_DEFAULT, /* 0  */
					EDMA_OPT_PDTD_DEFAULT, /* 0  */
					EDMA_OPT_LINK_NO, /* 0  */
					EDMA_OPT_FS_NO /* 0  */
			),
#else
			EDMA_OPT_RMK(
					EDMA_OPT_PRI_HIGH, /* 1  */
					EDMA_OPT_ESIZE_16BIT, /* 01 */
					EDMA_OPT_2DS_NO, /* 0  */
					EDMA_OPT_SUM_INC, /* 01 */
					EDMA_OPT_2DD_NO, /* 0  */
					EDMA_OPT_DUM_NONE, /* 00 */
					EDMA_OPT_TCINT_YES, /* 1  */
					EDMA_OPT_TCC_OF(14), /* 14 */
					EDMA_OPT_LINK_NO, /* 0  */
					EDMA_OPT_FS_NO /* 0  */
			),
#endif

			/* SRC Setup */EDMA_SRC_RMK((Uint32) xmitbuf), /*xmitbuf address*/

			/* CNT Setup */EDMA_CNT_RMK(
					EDMA_CNT_FRMCNT_DEFAULT,
					EDMA_CNT_ELECNT_OF(BUFFER_SIZE*11)
			),

			/* DST Setup */EDMA_DST_RMK(MCBSP_getXmtAddr(hMcbsp1)),

			/* IDX Setup */EDMA_IDX_RMK(0,0),

			/* RLD Setup */EDMA_RLD_RMK(0,0));

	EDMA_configArgs(hEdma15,

	/* OPT Setup */
#if (C64_SUPPORT)
			EDMA_OPT_RMK(
					EDMA_OPT_PRI_HIGH, /* 1  */
					EDMA_OPT_ESIZE_16BIT, /* 01 */
					EDMA_OPT_2DS_NO, /* 0  */
					EDMA_OPT_SUM_NONE, /* 00 */
					EDMA_OPT_2DD_NO, /* 0  */
					EDMA_OPT_DUM_INC, /* 01 */
					EDMA_OPT_TCINT_YES, /* 1  */
					EDMA_OPT_TCC_OF(15), /* 15 */
					EDMA_OPT_TCCM_DEFAULT, /* 0  */
					EDMA_OPT_ATCINT_DEFAULT, /* 0  */
					EDMA_OPT_ATCC_DEFAULT, /* 0  */
					EDMA_OPT_PDTS_DEFAULT, /* 0  */
					EDMA_OPT_PDTD_DEFAULT, /* 0  */
					EDMA_OPT_LINK_NO, /* 0  */
					EDMA_OPT_FS_NO /* 0  */
			),
#else
			EDMA_OPT_RMK(
					EDMA_OPT_PRI_HIGH, /* 1  */
					EDMA_OPT_ESIZE_16BIT, /* 01 */
					EDMA_OPT_2DS_NO, /* 0  */
					EDMA_OPT_SUM_NONE, /* 00 */
					EDMA_OPT_2DD_NO, /* 0  */
					EDMA_OPT_DUM_INC, /* 01 */
					EDMA_OPT_TCINT_YES, /* 1  */
					EDMA_OPT_TCC_OF(15), /* 15 */
					EDMA_OPT_LINK_NO, /* 0  */
					EDMA_OPT_FS_NO /* 0  */
			),
#endif

			/* SRC Setup */EDMA_SRC_RMK(MCBSP_getRcvAddr(hMcbsp1)),

			/* CNT Setup */EDMA_CNT_RMK(0, (BUFFER_SIZE * 11)),

			/* DST Setup */EDMA_DST_RMK((Uint32) recvbuf), /*recvbuf address*/

			/* IDX Setup */EDMA_IDX_RMK(0,0),

			/* RLD Setup */EDMA_RLD_RMK(0,0));

} /* End of ConfigEDMA() */

#endif

/*******************************************************************/
/* void ConfigDMA(void): set up DMA channels 1 & 2 for UART Xmit   */
/*******************************************************************/
#if (DMA_SUPPORT)

void ConfigDMA2(void)
{

	DMA_configArgs(hDma1,

			/* PRICTL Setup */
			DMA_PRICTL_RMK(
					DMA_PRICTL_DSTRLD_NONE,
					DMA_PRICTL_SRCRLD_NONE,
					DMA_PRICTL_EMOD_HALT,
					DMA_PRICTL_FS_DISABLE,
					DMA_PRICTL_TCINT_ENABLE,
					DMA_PRICTL_PRI_DMA,
					DMA_PRICTL_WSYNC_XEVT1,
					DMA_PRICTL_RSYNC_NONE,
					DMA_PRICTL_INDEX_NA,
					DMA_PRICTL_CNTRLD_NA,
					DMA_PRICTL_SPLIT_DISABLE,
					DMA_PRICTL_ESIZE_16BIT,
					DMA_PRICTL_DSTDIR_NONE,
					DMA_PRICTL_SRCDIR_INC,
					DMA_PRICTL_START_STOP
			),

			/* SECCTL Setup */
			DMA_SECCTL_RMK(
					DMA_SECCTL_WSPOL_ACTIVEHIGH,
					DMA_SECCTL_RSPOL_ACTIVEHIGH,
					DMA_SECCTL_FSIG_NORMAL,
					DMA_SECCTL_DMACEN_FRAMECOND,
					DMA_SECCTL_WSYNCCLR_NOTHING,
					DMA_SECCTL_WSYNCSTAT_CLEAR,
					DMA_SECCTL_RSYNCCLR_NOTHING,
					DMA_SECCTL_RSYNCSTAT_CLEAR,
					DMA_SECCTL_WDROPIE_DISABLE,
					DMA_SECCTL_WDROPCOND_CLEAR,
					DMA_SECCTL_RDROPIE_DISABLE,
					DMA_SECCTL_RDROPCOND_CLEAR,
					DMA_SECCTL_BLOCKIE_ENABLE, /* BLOCK IE=1: enables DMA channel int */
					DMA_SECCTL_BLOCKCOND_CLEAR,
					DMA_SECCTL_LASTIE_DISABLE,
					DMA_SECCTL_LASTCOND_CLEAR,
					DMA_SECCTL_FRAMEIE_DISABLE,
					DMA_SECCTL_FRAMECOND_CLEAR,
					DMA_SECCTL_SXIE_DISABLE,
					DMA_SECCTL_SXCOND_CLEAR
			),

			/* SRC Setup */
			DMA_SRC_RMK((Uint32) xmitbuf), /*xmitbuf*/

			/* DST Setup */
			DMA_DST_RMK(MCBSP_getXmtAddr(hMcbsp1)), /*McBSP DXR */

			/* XFRCNT Setup */
			DMA_XFRCNT_RMK(
					DMA_XFRCNT_FRMCNT_OF(1),
					DMA_XFRCNT_ELECNT_OF(BUFFER_SIZE*11)
			)

	);

	DMA_configArgs(hDma2,

			/* PRICTL Setup */
			DMA_PRICTL_RMK(
					DMA_PRICTL_DSTRLD_NONE,
					DMA_PRICTL_SRCRLD_NONE,
					DMA_PRICTL_EMOD_HALT,
					DMA_PRICTL_FS_DISABLE,
					DMA_PRICTL_TCINT_ENABLE,
					DMA_PRICTL_PRI_DMA,
					DMA_PRICTL_WSYNC_NONE,
					DMA_PRICTL_RSYNC_REVT1,
					DMA_PRICTL_INDEX_NA,
					DMA_PRICTL_CNTRLD_NA,
					DMA_PRICTL_SPLIT_DISABLE,
					DMA_PRICTL_ESIZE_16BIT,
					DMA_PRICTL_DSTDIR_INC,
					DMA_PRICTL_SRCDIR_NONE,
					DMA_PRICTL_START_STOP
			),

			/* SECCTL Setup */
			DMA_SECCTL_RMK(
					DMA_SECCTL_WSPOL_ACTIVEHIGH,
					DMA_SECCTL_RSPOL_ACTIVEHIGH,
					DMA_SECCTL_FSIG_NORMAL,
					DMA_SECCTL_DMACEN_FRAMECOND,
					DMA_SECCTL_WSYNCCLR_NOTHING,
					DMA_SECCTL_WSYNCSTAT_CLEAR,
					DMA_SECCTL_RSYNCCLR_NOTHING,
					DMA_SECCTL_RSYNCSTAT_CLEAR,
					DMA_SECCTL_WDROPIE_DISABLE,
					DMA_SECCTL_WDROPCOND_CLEAR,
					DMA_SECCTL_RDROPIE_DISABLE,
					DMA_SECCTL_RDROPCOND_CLEAR,
					DMA_SECCTL_BLOCKIE_ENABLE, /* BLOCK IE=1: enables DMA channel int */
					DMA_SECCTL_BLOCKCOND_CLEAR,
					DMA_SECCTL_LASTIE_DISABLE,
					DMA_SECCTL_LASTCOND_CLEAR,
					DMA_SECCTL_FRAMEIE_DISABLE,
					DMA_SECCTL_FRAMECOND_CLEAR,
					DMA_SECCTL_SXIE_DISABLE,
					DMA_SECCTL_SXCOND_CLEAR
			),

			/* SRC Setup */
			DMA_SRC_RMK(MCBSP_getRcvAddr(hMcbsp1)), /*McBSP DRR */

			/* DST Setup */
			DMA_DST_RMK((Uint32) recvbuf), /*recvbuf*/

			/* XFRCNT Setup */
			DMA_XFRCNT_RMK(
					DMA_XFRCNT_FRMCNT_OF(1),
					DMA_XFRCNT_ELECNT_OF(BUFFER_SIZE*11)
			)

	);

} /* End of ConfigDMA() */

#endif

/*******************************************************************/
/* EDMA Data Transfer Completion ISRs                              */
/*******************************************************************/


