/**
 * main.c
 */
/**
 * main.c
 */ /*
#include <stdbool.h>
#include <stdint.h>
#include <string.h>
#include <math.h>
#include "hw_memmap.h"
#include "hw_types.h"
#include "hw_gpio.h"
#include "debug.h"
#include "rom.h"
#include "sysctl.h"
#include "gpio.h"
#include "rom_map.h"
#include "abi_prefix.h"
#include "crc_defines.h"
#include "rtos_bindings.h"
#include "fpu.h"
#include "adc.h"
#include "aes.h"
#include "arm_acle.h"
#include "assert.h"
#include "can.h"
#include "comp.h"
#include "complex.h"
#include "cpu.h"
#include "cpy_tbl.h"
#include "crc.h"
#include "ctype.h"
#include "des.h"
#include "etsi.h"
#include "interrupt.h"
#include "inttypes.h"
#include "lcd.h"
#include "iso646.h"
#include "limits.h"
#include "lowlev.h"
#include "locale.h"
#include "mpu.h"
#include "onewire.h"
#include "pprof.h"
#include "pin_map.h"
#include "stdio.h"
#include "stdnoreturn.h"
#include "stdlib.h"
#include "sysexc.h"
#include "signal.h"
#include "shamd5.h"
#include "tm4c123gh6pm.h"
#include "i2c.h"
#include "time.h"
#include "timer.h"
#include "pwm.h"
*/
#include <stdint.h>
#include <stdbool.h>
#include <tm4c123gh6pm.h>
#include <hw_types.h>
#include <interrupt.h>
#include <hw_memmap.h>
#include <gpio.h>


void delay_1(void){
    unsigned i = 300000;
    while(i){
        i--;
    }
}

int main(void){
    unsigned long delay;
    SYSCTL_RCGC2_R |= 0x00000020;               /* enable clock to PORTF */
    delay = SYSCTL_RCGC2_R;
    /* PORTF0 has special function, need to unlock to modify */
    GPIO_PORTF_LOCK_R = 0x4C4F434B;         /* unlock commit register */
    GPIO_PORTF_CR_R = 0x1F;                 /* make PORTF0 configurable */
    /* configure PORTF for switch input and LED output */
    GPIO_PORTF_DIR_R &= ~0x11;              /* make PORTF4 input for switch */
    GPIO_PORTF_DIR_R |= 0x0E;               /* make PORTF3, 2, 1 output for LEDs */
    GPIO_PORTF_DEN_R |= 0x1F;               /* make PORTF-0 digital pins */
    GPIO_PORTF_AFSEL_R &= ~0x00000011;
    GPIO_PORTF_AMSEL_R &= ~0x00000011;
    GPIO_PORTF_PCTL_R &= ~0x000F000F;
    GPIO_PORTF_PUR_R |= 0x11;               /* enable pull up for PORTF4, 0 */
    /* configure PORTF4, 0 for falling edge trigger interrupt */
    GPIO_PORTF_IS_R &= ~0x11;               /* make bit 4, 0 edge sensitive */
    GPIO_PORTF_IBE_R &= ~0x11;              /* trigger is controlled by IEV */
    GPIO_PORTF_IEV_R &= ~0x11;              /* falling edge trigger */
    GPIO_PORTF_ICR_R |= 0x11;               /* clear any prior interrupt */
    GPIO_PORTF_IM_R |= 0x11;                /* unmask interrupt */
    NVIC_PRI7_R = (NVIC_PRI7_R & ~0xFF0FFFFF) | 0x00400000;                  /* set interrupt priority to 3 */
    NVIC_EN0_R |= 0x40000000;               /* enable IRQ 30 ( D30 of ISER[0]) */


    /* toggle the red LED (PF1) continuously */
    while(1)
    {
        GPIO_PORTF_DATA_R |= 0x02;
        delay_1();
        GPIO_PORTF_DATA_R &= ~0x02;
        delay_1();
    }
}
/* SW1 is connected to PF4 pin, SW2 is connected to PF0. */
/* Both of them trigger PORTF interrupt */


