@ Array Multiply Program
@ This program multiplies each half word from the Multiplicands
@ array by the same numbered half word in MULTIPLIERS array and
@ puts the result in the same numbered element in PRODUCTS array.
@ Uses R1-R4, R6-R8
@ Douglas V. Hall September 2016

.text
.global _start
_start:
.equ 	NUM, 4
		LDR R1, =MULTIPLICANDS	@ Load pointer to MULTIPLICANDS array
		LDR R2, =MULTIPLIERS	@ Load pointer to MULTIPLIERS array
		LDR R3, =PRODUCTS		@ Load pointer to PRODUCTS array
		MOV R4, #NUM			@ Initialize loop counter
NEXT:	LDRH R6,[R1]		@ Load a MULTIPLICAND Half word in R6
		LDRH R7,[R2] 		@ Load a MULTIPLIER half Word in R7
		MUL R8, R6, R7		@ Multiply
		STR R8, [R3]		@ Store result in PRODUCTS array
		ADD R1,R1,#2		@ Increment MULTIPLICANT pointer to next
		ADD R2,R2,#2		@ Increment MULTIPLIER pointer to next
		ADD R3,R3,#4		@ Increment PRODUCTS pointer to next
		SUBS R4,#1			@ Decrement loop counter by 1
		BNE NEXT 			@ Go to NEXT if all elements not multiplied
		NOP				@ Instruction for breakpoint. Does nothing.


.data

MULTIPLICANDS: .HWORD 0x1111, 0x2222, 0x3333, 0x4444
MULTIPLIERS:   .HWORD 0x1111, 0x2222, 0X3333, 0x4444
PRODUCTS:	   .WORD  0x0, 0x0, 0x0, 0x0
.END
