#include <msp430.h> 
#include <msp430f6638.h>
#include <math.h>
#include "measureMode.h"  // entre guillemets c'est pour des librairies du programme que nous on cre et entre chevron c'est les librairies externes

/**
 * main.c
 */
int main(void)
{
    WDTCTL = WDTPW | WDTHOLD;	              // stop watchdog timer

    UCSCTL4|=SELA__XT1CLK|SELS__XT2CLK;       // source ACLK from XT1 and SMCLK from XT2
    UCSCTL6|=XT2DRIVE_0|XCAP_0;              // select range for XT2 4 to 8 MHz and 2pF caps knowing that we already have 20 pF external caps
    UCSCTL6&=~XT2OFF;                       // turn on XT2
    UCSCTL6&=~XT1OFF;                      // turn on XT1

    P3SEL&=~BIT7;
    P3DIR&=~BIT7;
    P4SEL&=~BIT1;
    P4DIR|=BIT1;

    return 0;
}

while (1)
{
    if ((P3IN>>7) & (0x01) == 1)
    {
        P4OUT|=BIT1;
    }
    else
    {

    }
}
