/*
 * measureMode.c
 *
 *  Created on: Feb 6, 2013
 *      Author: a0220221
 */

//#include "ext_config.h"
#include "measureMode.h"
#include <msp430f6638.h>


#define PWM_PERIOD 4000
#define PUMP_DC    3400
#define VALVE_DC   2500

/**********************************************************************//**
 * @brief  ADC12Init():Configure ADC Module, ACLK as clock source and channel 5 input
 * @param  none
 * @return none
 *************************************************************************/
void ADC12Init(void)
{

    P6SEL|=BIT5;                                                        //SELECT P6.5 AS ADC and not I/O
    ADC12CTL0 &= ~ADC12ENC;                                             // ADC12 disabled
    ADC12CTL0 =  ADC12REFON + ADC12REF2_5V + ADC12SHT0_2;     // Sample time 16, around 16/4.8MHz = 3.3us, rfrence 2.5 V, rfrence on et ADC12 on
    //ADC12CTL0 |= ADC12ENC; already written in the interrupt routine
    ADC12CTL1 = ADC12SHP + ADC12SHS_1 + ADC12DIV1 + ADC12CONSEQ_2;      // enable sample timer, ADC clock from MODCLK, trigger source 1 timer and CONSEQ=2 so we have to set ENC just once !
    ADC12MCTL0 = ADC12SREF_1 + ADC12INCH_5;                             // choix du port ADC5 et de la rfrence
    ADC12IE|= ADC12IE0;                                                 // ATTENTION ON LE FAIT POUR 1 SEUL BIT !!!!!! Enable interrupt pour ADC
    ADC12CTL0|=ADC12ENC;                                                // Enable conversion

}

/**********************************************************************//**
 * @brief  ADC12_ON()
 * @param  none
 * @return none
 *************************************************************************/

void ADC12_ON(void)
{
    ADC12CTL0|=ADC12ON;
}

/**********************************************************************//**
 * @brief  ADC12_OFF()
 * @param  none
 * @return none
 *************************************************************************/

void ADC12_OFF(void)
{
    ADC12CTL0&= ~ADC12ON;
}

/**********************************************************************//**
 * @brief  ADC12_sample_clk()
 * @param  none
 * @return none
 *************************************************************************/
void ADC12_sample_clk(void)
{
    P1SEL|=BIT1;                             //SELECT P1.1 AS TA0 and not I/O
    P1DIR|=BIT1;
    P1SEL|=BIT2;                             //SELECT P1.2 AS TA0 output and not I/O
    P1DIR|=BIT2;
    TA0CCR0 = 320 - 1;                      // 100hz sampling frequency
    TA0CCR1 = 295;                          // duty cycle not important it's the period which is important
    TA0CCTL1 = OUTMOD_2;                    // out mode 2
    TA0CTL = TASSEL_1 + TACLR+ MC_1;        // ACLK, up mode
    //TA0CCTL1|= CCIE;                       // enable interrupt we don't need it since we use adc12_isr
}



/**********************************************************************//**
 * @brief  pwm_period(void)
 * @param  period : none
 * @return none
 *************************************************************************/
void pwm_period(void)
{

    P3SEL|=BIT1;                                    //SELECT P3.1 AS TA1 and not I/O
    P3DIR|=BIT1;                                    //DEFINE P3.1 AS OUTPUT (COMPARE)
    TA1CCR0 = PWM_PERIOD-1;                      // counter value that defines the pwm period
}

/**********************************************************************//**
 * @brief  pump_timer_config(void)
 * @param  none
 * @return none
 *************************************************************************/
void pump_timer_config(void)
{
    P3SEL|=BIT2;           //SELECT P3.2 AS TA1 OUTPUT
    P3DIR|=BIT2;            // Define P3.2 as output (compare)
}

/**********************************************************************//**
 * @brief  pump_ON()
 * @param  none
 * @return none
 *************************************************************************/
void pump_ON(void)
{

    TA1CCTL1 = OUTMOD_6;   // toggle/set
    TA1CCR1 = PUMP_DC;
    TA1CTL = TASSEL_2 + TACLR+ MC_1;              // SMCLK, up mode
}

/**********************************************************************//**
 * @brief  pump_OFF()
 * @param  none
 * @return none
 *************************************************************************/
void pump_OFF(void)
{
    TA1CCTL1 = OUTMOD_0 | (0*OUT);  // Force TA1.1 to OUT=0 immediately
    /*TA1CCTL1 = OUTMOD_5;          // reset
    TA1CCR1 = 1;                    // very short DC so the pump remains off quickly*/
}

/**********************************************************************//**
 * @brief  valve_timer_config(void)
 * @param  none
 * @return none
 *************************************************************************/
void valve_timer_config(void)
{

    P3DIR|=BIT3;            // Define P3.3 as output
    P3SEL|=BIT3;           //SELECT P3.3 AS TA1 OUTPUT
}


/**********************************************************************//**
 * @brief  valve_ON()
 * @param  none
 * @return none
 *************************************************************************/

void valve_ON(void)
{
    TA1CCTL2 = OUTMOD_1;
    TA1CCR2 = VALVE_DC;
    TA1CTL = TASSEL_2 + TACLR+ MC_1;              // SMCLK, up mode
}

/**********************************************************************//**
 * @brief  valve_OFF()
 * @param  none
 * @return none
 *************************************************************************/
void valve_OFF(void)
{
    TA1CCTL2 = OUTMOD_0 | (0*OUT);  // Force TA1.1 to OUT=0 immediately
    /*TA1CCTL2 = OUTMOD_5;  // reset
    TA1CCR2 = 1;   // very short DC so the valve remains off quickly*/
}

/**********************************************************************//**
 * @brief  SPI_flash_config()
 * @param  none
 * @return none
 *************************************************************************/

void SPI_flash_config(void)
   {

       P8SEL|= BIT1|BIT2|BIT3;  // select SPI function for P8.1 P8.2 and P8.3
       UCA1CTL1 |= UCSWRST;    // **Put state machine in reset**
       UCA1CTL0|=UCMST|UCSYNC; // master mode, 3-pin spi, 8 bit, lsb first
       UCA1CTL1 |= UCSSEL_2;   // SMCLK as clock source
       UCA1BR0 = 0x02;        //  divide CLK by 2
       UCA1BR1 = 0;
       UCA1CTL1 &= ~UCSWRST;  // **Initialize USCI state machine by disabling the reset**
       UCA1IE|=UCRXIE|UCTXIE; // Enable interrupt for transfering and receving

   }

/**********************************************************************//**
 * @brief  SPI_AFE_config()
 * @param  none
 * @return none
 *************************************************************************/

void SPI_AFE_config(void)
   {

       P8SEL|= BIT1|BIT2|BIT3;  // select SPI function for P8.1 P8.2 and P8.3
       UCA1CTL1 |= UCSWRST;    // **Put state machine in reset**
       UCA1CTL0|=UCMST|UCSYNC; // master mode, 3-pin spi, 8 bit, lsb first
       UCA1CTL1 |= UCSSEL_2;   // SMCLK as clock source
       UCA1BR0 = 0x02;        //  divide CLK by 2
       UCA1BR1 = 0;
       UCA1CTL1 &= ~UCSWRST;  // **Initialize USCI state machine by disabling the reset**
       UCA1IE|=UCRXIE|UCTXIE; // Enable interrupt for transfering and receving

   }









/**********************************************************************//**
 * @brief  ADCInit():Configure ADC Module, ACLK as clock source and channel 0 input
 * @param  none
 * @return none
 *************************************************************************/
void ADCInit(void)
{
    P6OUT|=BIT3;
    P6DIR|=BIT3;
}




/*_BIS_SR(GIE); // ?? le mettre ou non ? // et le GIE ??? voir p 746 datasheet; set the command once the initialization is done

    P1DIR|= BIT0|BIT3|BIT4|BIT5|BIT6|BIT7;   // configure unused pins of P1 as output (no need to set P1SEL and select I/O function because it's already selected by default)
    P2SEL|= BIT1|BIT2|BIT3|BIT4|BIT5;       // configure port 2  for SPI and UART except pin 0 6 and 7 as GPIOs
    P2DIR|= BIT0|BIT6|BIT7;                 // configured as output
    P3SEL|= BIT4;                           // Select SMCLK function
    P3DIR|= BIT0|BIT4;                     // Configured as output
    P4SEL|= BIT0|BIT1;                       // configure as Timer output
    P4DIR|= BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT7;
    P5SEL = 0;                                // everything as GPIOs
    P5DIR|= BIT2|BIT3;                      // as output
    P6SEL| = BIT4;                          //ATTENTION SEL DAC, NE PAS OUBLIER DANS FONCTION DAC METTRE DAC12OPS=0 ET DAC12AMP> 1 P 98 ET 831 !!
    P6DIR|= BIT0|BIT1|BIT2|BIT6;
    P7SEL|= BIT2|BIT3;                      // !! DON'T FORGET TO SET XT2BYPASS TO 0.
    P7DIR|= BIT4|BIT5|BIT6;                 // DON'T FORGET TO TEST USB_DETETC IN THE PROG TO GET DATA IN PC
    P8SEL|= BIT1|BIT2|BIT3|BIT4|BIT5|BIT6; // ATTENTION SEL DU SPI
    P8DIR|= BIT0|BIT7;
    P9SEL = 0;                              // Everything as GPIO
    P9DIR|= BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7; // DON'T FORGET TO SET AFE PDN TO HIGH IN THE CODE !! */

    /*P2MAP3 = PM_UCB0CLK; // = 16  according to msp430f6638.h library
        P2MAP1 = PM_UCB0SOMI; // = 14
        P2MAP2 = PM_UCB0SIMO; // = 15

        P2MAP4 = PM_UCA0TXD; // = 12 according to msp430f6638.h library
        P2MAP5 = PM_UCA0RXD ; // = 11*/















/*while(1)
{
    etat_interrupt =
            press_but =
                    selectionner sensor_out au lieu de test_BP (mux)
    switch(etat_interrupt)
    {
    case 1:
        if (press_but == 0 && step_0 == 0)
        {
            step_0 = 1;
            step_1 = 1;
        }

        if (step_1 == 1 && rtc_flag == 1)
        {
            valve_OFF();                        // because the valve is normally open so we have to close it to avoid to inflate and deflate the cuff at the same time during the inflation phase.
            while (val_threshold < threshold)  // en ralit c'est un test de la sortie numrique du capteur qui faut faire, si c'est  1 ou 0
            {
                pump_ON();
            }
            pump_OFF();
            step_2 = 1;
            changer threshold avec dac
        }

        if (step_2 == 1)
        {
            ADC_ON();

            while (val_threshold > threshold)
            {
                valve_ON();
                if (write_mem == 1)
                {
                    length_tab++;
                    length_mem++;
                    write_mem = 0;
                    converted_value = ADC12MEM0;
                    mettre cs  1 !!!
                    write_flash(data);
                }
            }

            ADC_OFF();
            valve_OFF();
            tab = [length_tab][2];
            initialisation des cases  0
            step_3 = 1;
            step_2 = 0;
        }

        if (step_3 == 1)
        {
            step_3 = 0;

            for(i=1; i<length_tab+1;i++)
            {
                x_k_1 = read_flash(adr_offset+(i-1));
                tab[i][0] = LPF(omega_c, x_k_1, tab[i-1][0]);
                tab[i][1] = HPF(                           )
            }

            index_max = find_max_index(tab);
            sys_comp_max = 0.7*tab[index_max][0];

            for (j=1; j < index_max+1; j++)
            {
                p_inf[j] = tab[j][0];
                sys_diff[j] = fabs(sys_comp_max - p_inf[j]);

                if (sys_diff[j] < sys_diff[j-1])
                {
                    systole = p_inf[j];
                }

                else
                {
                    systole = p_inf[j-1];
                }
            }

            dias_comp_max = 0.5*tab[index_max][0];

            for (k=index_max; k < length_tab; k++)
            {
                p_sup[k] = tab[k][0];
                dias_diff[k] = fabs(dias_comp_max - p_sup[k]);

                if (dias_diff[k] < dias_diff[k-1])
                {
                    diastole = p_sup[k]
                }

                else
                {
                    diastole = p_sup[k-1];
                }
            }

            adr_offset = length_mem;
            length_tab = 0;
            step_4 = 1;
        }

        if (step_4 == 1)
        {
            step_4 = 0;
            DAC = systole + 30 mmHg;
            threshold = DAC;
            RTC
            RTC_flag = 0;
        }

        else
        {

        }

        break;

    case 0:


    }

}


#pragma vector=TIMER0_A0_VECTOR

    __interrupt void TIMER0_CCR0_ISR(void){

        ADC12CTL0 |= ADC12ENC|ADC12SC; // enable and start conversion
    }



#pragma vector = ADC12_VECTOR
__interrupt void adc12_ISR(void)
{
    // l'interruption est automatiquemen quittanc quand on accde le registre de data mais on peut la quittancer une fois dans la routine car
    // on ne lira pas le registre dans l'interruption (on perd du temps)

    // on met un flag qui s'incrmente (voir cahier) pour lire la valeur du registre en dehors de l'interrupt
    write_mem = 1;
}
 */


