#include <mcasp_osal.h>
#include <mcasp_drv.h>
#include <ti/csl/cslr_device.h>
#include <include/McaspLocal.h>
#ifdef _TMS320C6X
#include <ti/sysbios/family/c64p/Hwi.h>
#include <ti/sysbios/family/c66/tci66xx/CpIntc.h>
#include <ti/sysbios/family/c64p/EventCombiner.h>
#else
#include <ti/sysbios/hal/Hwi.h>
#endif

#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/hal/Cache.h>

#include <ti/sysbios/knl/Queue.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/knl/Swi.h>
#include <ti/osal/osal.h>


extern Void Mcasp_localIsrSwiFxn(Arg arg0,Arg arg1);
extern Mcasp_Module_State Mcasp_module;
extern Void Mcasp_swiTxFifo(Arg arg0,Arg arg1);



void osal_Queue_construct(void * ptr, int32_t arg)
{
	Queue_construct((Queue_Struct*)ptr, NULL);
}

void osal_Cache_wb(void * pktAddr, int32_t size)
{
	Cache_wb(pktAddr, size, Cache_Type_ALL, TRUE);
}
void osal_Cache_wbInv(void * pktAddr, int32_t size)
{
	Cache_wbInv(pktAddr, size, Cache_Type_ALL, TRUE);
}
void osal_Task_sleep(int32_t msec)
{
	int i,j;
	//Task_sleep(msec);
	 for (i=0; i < msec; i++) {
	        for (j=0; j < 1000; j++) {
#ifdef _TMS320C6X
	        	asm("* Comment to maintain loops through compiler optimization");
#endif
	        }
	 }
}
int32_t osal_getThreadType()
{
	return BIOS_getThreadType() == BIOS_ThreadType_Task;

}
#ifdef _TMS320C6X
int hostintArr[6]={33,34,35,36,37,38};
int eventIdArr[6]={0x33,0x34,0x35,0x36,0x37,0x38};
void osal_EventCombiner_disableEvent(int32_t cpuEventNum)
{

	EventCombiner_disableEvent(eventIdArr[cpuEventNum- CSL_CIC_McASP_0_XINT]);


}
void osal_EventCombiner_enableEvent(int32_t cpuEventNum)
{

	EventCombiner_enableEvent(eventIdArr[cpuEventNum- CSL_CIC_McASP_0_XINT]);

}

void osal_EventCombiner_dispatchPlug(Uint32 evt, void * intIsr, void *arg, int32_t flag )
{
	int hostint,eventId;
	  CpIntc_dispatchPlug(evt, (CpIntc_FuncPtr)intIsr, 0, TRUE);
	  hostint=hostintArr[evt- CSL_CIC_McASP_0_XINT];
	                           /* The configuration is for CPINTC0. We map system interrupt 0x88 to Host Interrupt 32. */
	                           CpIntc_mapSysIntToHostInt(0, evt, hostint);

	                           /* Enable the Host Interrupt. */
	                           CpIntc_enableHostInt(0, hostint);

	                           /* Enable the System Interrupt */
	                           CpIntc_enableSysInt(0, evt);

	                           /* Get the event id associated with the host interrupt. */
	                           eventId = eventIdArr[evt- CSL_CIC_McASP_0_XINT];
	                           /* enable the 'global' switch */

	                          /* Enable the Xfer Completion Event Interrupt */
	                               EventCombiner_dispatchPlug(eventId,
	                               						(EventCombiner_FuncPtr)(&CpIntc_dispatch),
	                                                   	hostint, 1);


	//EventCombiner_dispatchPlug(evt, (EventCombiner_FuncPtr)intIsr, arg, flag);
}
#endif


#if 0
int gDebug=0;

void assert(int in)
{
if(in <=0)
	gDebug++;
}
#endif

void osal_Swi_post(void * obj)
{
	Swi_post((Swi_Handle)obj);

}
int32_t osal_Queue_empty(void * handle)
{
return Queue_empty(Queue_handle(handle));
//	return ((Mcasp_QueueElem*)handle->next == &((Mcasp_QueueElem*)handle));

}

MCASP_Packet * osal_Queue_get(void * handle)
{
return Queue_get(Queue_handle(handle));
}

void osal_Queue_put(void * handle,Ptr ptr)
		{
	Queue_put(Queue_handle(handle),(Ptr)ptr);
		}


McaspOsal_IntrHandle McaspOsal_registerIntr(
    UInt32              intNum,
    McaspOsal_IntrFuncPtr fxn,
    const void         *arg0)
{
    Hwi_Params hwiParams = {0};

    Hwi_Params_init(&hwiParams);
    hwiParams.arg = (UInt32) arg0;
    return (McaspOsal_IntrHandle) Hwi_create(
               (Int32) intNum,
               (Hwi_FuncPtr) fxn,
               &hwiParams,
               0U);
}

/* OSAL functions for Platform Library */
uint8_t *Osal_platformMalloc (uint32_t num_bytes, uint32_t alignment)
{
	return malloc(num_bytes);
}

void Osal_platformFree (uint8_t *dataPtr, uint32_t num_bytes)
{
    /* Free up the memory */
    if (dataPtr)
    {
        free(dataPtr);
    }
}

void Osal_platformSpiCsEnter(void)
{
    /* Get the hardware semaphore.
     *
     * Acquire Multi core CPPI synchronization lock
     */
    //while ((CSL_semAcquireDirect (PLATFORM_SPI_HW_SEM)) == 0);

    return;
}

void Osal_platformSpiCsExit (void)
{
    /* Release the hardware semaphore
     *
     * Release multi-core lock.
     */
    //CSL_semReleaseSemaphore (PLATFORM_SPI_HW_SEM);

    return;
}
