#include <stdbool.h>

#include <msp430.h> 

static bool debugger_connected = false;

/*
 * main.c
 */
int main(void) {
    WDTCTL = WDTPW | WDTHOLD;	// Stop watchdog timer

    P1OUT &= ~BIT0;
    P1DIR |= BIT0;
    P4OUT &= ~BIT7;
    P4DIR |= BIT7;

    for (;;)
    {
    	_delay_cycles (500000);
    	if (debugger_connected)
    	{
    		/* Flash red LED1 */
    		P1OUT ^= BIT0;
    	    P4OUT &= ~BIT7;
    	}
    	else
    	{
    		/* Flash green LED2 */
    		P4OUT ^= BIT7;
    		P1OUT &= BIT0;
    	}
    }
	
	return 0;
}
