/**
 * The MySensors Arduino library handles the wireless radio link and protocol
 * between your home built sensors/actuators and HA controller of choice.
 * The sensors forms a self healing radio network with optional repeaters. Each
 * repeater and gateway builds a routing tables in EEPROM which keeps track of the
 * network topology allowing messages to be routed to nodes.
 *
 * Created by Henrik Ekblad <henrik.ekblad@mysensors.org>
 * Copyright (C) 2013-2015 Sensnology AB
 * Full contributor list: https://github.com/mysensors/Arduino/graphs/contributors
 *
 * Documentation: http://www.mysensors.org
 * Support Forum: http://forum.mysensors.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 */


/*
 * The MySensors Arduino library handles the wireless radio link and protocol
 * between your home built sensors/actuators and HA controller of choice.
 * The sensors forms a self healing radio network with optional repeaters. Each
 * repeater and gateway builds a routing tables in EEPROM which keeps track of the
 * network topology allowing messages to be routed to nodes.
 *
 * Created by Henrik Ekblad <henrik.ekblad@mysensors.org>
 * Copyright (C) 2013-2015 Sensnology AB
 * Full contributor list: https://github.com/mysensors/Arduino/graphs/contributors
 *
 * Documentation: http://www.mysensors.org
 * Support Forum: http://forum.mysensors.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 */

/**
 * @file MyMessage.h
 *
 * @brief API and type declarations for MySensors messages
 * @defgroup MyMessagegrp MyMessage
 * @{
 *
 * @brief Here you can find all message types used by the MySensors protocol as well as macros for
 * parsing and manipulating messages.
 */

//mycode
//#include "Arduino.h"
//mycode
/*
 * Arduino.h
 *
 *  Created on: Jan 11, 2017
 *      Author: Kingsman
 */



/*****************************************************************************/
/* stdarg.h   v16.12.0                                                       */
/*                                                                           */
/* Copyright (c) 1996-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


#pragma diag_push
#pragma CHECK_MISRA("-20.1") /* standard headers must define standard names */
#pragma CHECK_MISRA("-20.2") /* standard headers must define standard names */
#pragma CHECK_MISRA("-19.7") /* function-like macros are OK */
#pragma CHECK_MISRA("-19.10") /* need types as macro arguments */

namespace std {

typedef char *va_list;

} /* namespace std */


/*****************************************************************************/
/* On the MSP430, the stack grows down (towards 0x0), and arguments are      */
/* pushed in reverse order, so later arguments are at higher addresses.      */
/*****************************************************************************/

/*****************************************************************************/
/* VA_START(va_list ap, parmN)                                               */
/*                                                                           */
/*   Set "ap" to point to the address of the next argument past parmN.       */
/*   So add the size of parmN to the address of parmN.                       */
/*                                                                           */
/*   NOTES -must use the address of the level 1 symbol (via va_parmadr).     */
/*         -must account for "chars", which are widened to "ints".           */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************/
/* VA_ARG(va_list, type)                                                     */
/*                                                                           */
/*   Return next argument (currently pointed to by "va_list", and set the    */
/*   argument pointer to point to the next argument after current one.       */
/*                                                                           */
/*   Notes -must handle variables passed by reference (_va_argref())         */
/*         -must round up chars.                                             */
/*                                                                           */
/*****************************************************************************/



#pragma diag_pop


#pragma diag_push

/* using declarations must occur outside header guard to support including both
   C and C++-wrapped version of header; see _CPP_STYLE_HEADER check */
/* this code is for C++ mode only and thus also not relevant for MISRA */
#pragma CHECK_MISRA("-19.15")

using std::va_list;

#pragma diag_pop
/*****************************************************************************/
/* stddef.h   v16.12.0                                                       */
/*                                                                           */
/* Copyright (c) 1993-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


#pragma diag_push
#pragma CHECK_MISRA("-19.7") /* macros required for implementation */
#pragma CHECK_MISRA("-20.1") /* standard headers must define standard names */
#pragma CHECK_MISRA("-20.2") /* standard headers must define standard names */

extern "C" namespace std {


typedef int ptrdiff_t;

typedef unsigned size_t;


#pragma diag_push
#pragma CHECK_MISRA("-19.10") /* need types as macro arguments */


} /* extern "C" namespace std */

#pragma diag_pop


using std::ptrdiff_t;
using std::size_t;
/*using std::wchar_t;*/

#pragma diag_push
#pragma CHECK_MISRA("-19.15") /* code outside guard; see below comment */

/*-----------------------------------------------------------------------*/
/* Define _win_t, for compiling GCC libraries with the TI compiler.      */
/* GCC's library (newlib) expects wint_t to be defined here, in stddef.h,*/
/* which is arguably incorrect, but we go along for compatibility.       */
/* This is outside the _STDDEF guard in case this file has already       */
/* been included without __need_wint_t.                                  */
/*-----------------------------------------------------------------------*/

#pragma diag_pop
/*****************************************************************************/
/* STDINT.H v16.12.0                                                         */
/*                                                                           */
/* Copyright (c) 2002-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/

/* 7.18.1.1 Exact-width integer types */

    typedef   signed char    int8_t;
    typedef unsigned char   uint8_t;
    typedef          int    int16_t;
    typedef unsigned int   uint16_t;
    typedef          long   int32_t;
    typedef unsigned long  uint32_t;


    typedef          long long  int64_t;
    typedef unsigned long long uint64_t;

/* 7.18.1.2 Minimum-width integer types */

    typedef  int8_t   int_least8_t;
    typedef uint8_t  uint_least8_t;

    typedef  int16_t  int_least16_t;
    typedef uint16_t uint_least16_t;
    typedef  int32_t  int_least32_t;
    typedef uint32_t uint_least32_t;


    typedef  int64_t  int_least64_t;
    typedef uint64_t uint_least64_t;

/* 7.18.1.3 Fastest minimum-width integer types */

    typedef  int16_t  int_fast8_t;
    typedef uint16_t uint_fast8_t;
    typedef  int16_t  int_fast16_t;
    typedef uint16_t uint_fast16_t;

    typedef  int32_t  int_fast32_t;
    typedef uint32_t uint_fast32_t;


    typedef  int64_t  int_fast64_t;
    typedef uint64_t uint_fast64_t;

/* 7.18.1.4 Integer types capable of holding object pointers */
    typedef          long intptr_t;
    typedef unsigned long uintptr_t;

/* 7.18.1.5 Greatest-width integer types */
    typedef          long long intmax_t;
    typedef unsigned long long uintmax_t;

/* 
   According to footnotes in the 1999 C standard, "C++ implementations
   should define these macros only when __STDC_LIMIT_MACROS is defined
   before <stdint.h> is included." 
*/

/*****************************************************************************/
/* stdlib.h   v16.12.0                                                       */
/*                                                                           */
/* Copyright (c) 1993-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/



#pragma diag_push
#pragma CHECK_MISRA("-6.3") /* standard types required for standard headers */
#pragma CHECK_MISRA("-8.5") /* need to define inline function */
#pragma CHECK_MISRA("-19.1") /* #includes required for implementation */
#pragma CHECK_MISRA("-19.7") /* need function-like macros */
#pragma CHECK_MISRA("-20.1") /* standard headers must define standard names */
#pragma CHECK_MISRA("-20.2") /* standard headers must define standard names */

/*---------------------------------------------------------------------------*/
/* Attributes are only available in relaxed ANSI mode.                       */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* <cstdlib> IS RECOMMENDED OVER <stdlib.h>.  <stdlib.h> IS PROVIDED FOR     */
/* COMPATIBILITY WITH C AND THIS USAGE IS DEPRECATED IN C++                  */
/*---------------------------------------------------------------------------*/
extern "C" namespace std {

#pragma diag_push
#pragma CHECK_MISRA("-5.7") /* keep names intact */

typedef struct { int quot, rem; } div_t;

typedef struct { long quot, rem; } ldiv_t;

typedef struct { long long quot, rem; } lldiv_t;

#pragma diag_pop







/*****************************************************************************/
/* linkage.h   v16.12.0                                                      */
/*                                                                           */
/* Copyright (c) 1998-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


#pragma diag_push
#pragma CHECK_MISRA("-19.4") /* macros required for implementation */

/* No modifiers are needed to access code or data */


/*--------------------------------------------------------------------------*/
/* Define _IDECL ==> how inline functions are declared                      */
/*--------------------------------------------------------------------------*/

#pragma diag_pop


/*---------------------------------------------------------------*/
/* NOTE - Normally, abs, labs, and fabs are expanded inline, so  */
/*        no formal definition is really required. However, ANSI */
/*        requires that they exist as separate functions, so     */
/*        they are supplied in the library.  The prototype is    */
/*        here mainly for documentation.                         */
/*---------------------------------------------------------------*/
#pragma diag_push
#pragma CHECK_MISRA("-16.4") /* false positives due to builtin declarations */
      int       abs(int _val); 
      long      labs(long _val);
      long long llabs(long long _val);
#pragma diag_pop

     int       atoi(const char *_st);
     long      atol(const char *_st);
     long long atoll(const char *_st);
     int       ltoa(long val, char *buffer);
          extern  double    atof(const char *_st);

     long      strtol(const char *_st, char **_endptr, int _base);
     unsigned long strtoul(const char *_st, char **_endptr,
    					  int _base);
     long long strtoll(const char *_st, char **_endptr, int _base);
     unsigned long long strtoull(const char *_st, char **_endptr,
					     int _base);
     float     strtof(const char * _st, 
                                  char ** _endptr);
     double    strtod(const char * _st, 
                                  char ** _endptr);
     long double strtold(const char * _st, 
                                     char ** _endptr);
    
     int    rand(void);
     void   srand(unsigned _seed);
    
     void  *calloc(size_t _num, size_t _size)
               __attribute__((malloc));
     void  *malloc(size_t _size)
               __attribute__((malloc));
     void  *realloc(void *_ptr, size_t _size)
               __attribute__((malloc));
     void   free(void *_ptr);
     void  *memalign(size_t _aln, size_t _size)
               __attribute__((malloc));
    
     void   abort(void); 

    typedef void (*__TI_atexit_fn)(void);
     int    atexit(__TI_atexit_fn _func);

    typedef int (*__TI_compar_fn)(const void *_a,const void *_b);
     void  *bsearch(const void *_key, const void *_base,
                                size_t _nmemb, size_t _size, 
                                __TI_compar_fn compar);
     void   qsort(void *_base, size_t _nmemb, size_t _size, 
                              __TI_compar_fn compar);

     void   exit(int _status);
    
     div_t  div(int _numer, int _denom);
     ldiv_t ldiv(long _numer, long _denom);
     lldiv_t lldiv(long long _numer, long long _denom);

     char  *getenv(const char *_string);
     int    system(const char *_name);

     int    mblen(const char *_s, size_t _n);
     size_t mbstowcs(wchar_t *_dest, const char *_src, size_t _n);
     int    mbtowc(wchar_t *_dest, const char *_src, size_t _n);

     size_t wcstombs(char *_dest, const wchar_t *_src, size_t _n);
     int    wctomb(char *_s, wchar_t _wc);

} /* extern "C" namespace std */




#pragma diag_pop


#pragma diag_push

/* using declarations must occur outside header guard to support including both
   C and C++-wrapped version of header; see _CPP_STYLE_HEADER check */
/* this code is for C++ mode only and thus also not relevant for MISRA */
#pragma CHECK_MISRA("-19.15")

using std::div_t;
using std::ldiv_t;
using std::lldiv_t;
using std::size_t;
using std::abs;
using std::labs;
using std::atoi;
using std::atol;
using std::llabs;
using std::atoll;
using std::atof;
using std::strtol;
using std::strtoul;
using std::strtoll;
using std::strtoull;
using std::strtof;
using std::strtod;
using std::strtold;
using std::rand;
using std::srand;
using std::calloc;
using std::malloc;
using std::realloc;
using std::free;
using std::memalign;
using std::abort;
using std::atexit;
using std::bsearch;
using std::qsort;
using std::exit;
using std::div;
using std::ldiv;
using std::lldiv;
using std::getenv;
using std::system;
using std::mblen;
using std::mbtowc;
using std::wctomb;
using std::mbstowcs;
using std::wcstombs;

#pragma diag_pop

#pragma diag_push

/* C2000-specific additions to header implemented with #include */
#pragma CHECK_MISRA("-19.1")
#pragma CHECK_MISRA("-19.15")


#pragma diag_pop
/*
 * Copyright (c) 2000 Jeroen Ruigrok van der Werven <asmodai@FreeBSD.org>
 * All rights reserved.
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: release/10.0.0/include/stdbool.h 228878 2011-12-25 20:15:41Z ed $
 */


/*
 * filen.h
 *
 *  Created on: Jan 11, 2017
 *      Author: Kingsman
 */


/*
  stdlib_noniso.h - nonstandard (but usefull) conversion functions
  Copyright (c) 2014 Ivan Grokhotkov. All rights reserved.
  This file is part of the esp8266 core for Arduino environment.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


extern "C"{

int atoi(const char *s);

long atol(const char* s);

double atof(const char* s);

//char* itoa (int val, char *s, int radix);

//char* ltoa (long val, char *s, int radix);

char* utoa (unsigned int val, char *s, int radix);

char* ultoa (unsigned long val, char *s, int radix);

char* dtostrf (double val, signed char width, unsigned char prec, char *s);

void reverse(char* begin, char* end);

} // extern "C"





/*****************************************************************************/
/* STDIO.H v16.12.0                                                          */
/*                                                                           */
/* Copyright (c) 1993-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


/*****************************************************************************/
/* stdarg.h   v16.12.0                                                       */
/*                                                                           */
/* Copyright (c) 1996-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


#pragma diag_push

/* using declarations must occur outside header guard to support including both
   C and C++-wrapped version of header; see _CPP_STYLE_HEADER check */
/* this code is for C++ mode only and thus also not relevant for MISRA */
#pragma CHECK_MISRA("-19.15")

using std::va_list;

#pragma diag_pop

/*---------------------------------------------------------------------------*/
/* Attributes are only available in relaxed ANSI mode.                       */
/*---------------------------------------------------------------------------*/


//----------------------------------------------------------------------------
// <cstdio> IS RECOMMENDED OVER <stdio.h>.  <stdio.h> IS PROVIDED FOR
// COMPATIBILITY WITH C AND THIS USAGE IS DEPRECATED IN C++
//----------------------------------------------------------------------------
extern "C" namespace std {

/****************************************************************************/
/* TYPES THAT ANSI REQUIRES TO BE DEFINED                                   */
/****************************************************************************/

typedef struct {
      int fd;                    /* File descriptor */
      unsigned char* buf;        /* Pointer to start of buffer */
      unsigned char* pos;        /* Position in buffer */
      unsigned char* bufend;     /* Pointer to end of buffer */
      unsigned char* buff_stop;  /* Pointer to last read char in buffer */
      unsigned int   flags;      /* File status flags (see below) */
} FILE;

typedef long fpos_t;

/****************************************************************************/
/* DEVICE AND STREAM RELATED MACROS                                         */
/****************************************************************************/
/****************************************************************************/
/* MACROS THAT DEFINE AND USE FILE STATUS FLAGS                             */
/****************************************************************************/



/****************************************************************************/
/* MACROS THAT ANSI REQUIRES TO BE DEFINED                                  */
/****************************************************************************/








/******** END OF ANSI MACROS ************************************************/


/****************************************************************************/
/* DEVICE AND STREAM RELATED DATA STRUCTURES AND MACROS                     */
/****************************************************************************/

extern  FILE _ftable[10];
extern  char __TI_tmpnams[10][16];

/****************************************************************************/
/*   FUNCTION DEFINITIONS  - ANSI                                           */
/****************************************************************************/
/****************************************************************************/
/* OPERATIONS ON FILES                                                      */
/****************************************************************************/
extern  int     remove(const char *_file);
extern  int     rename(const char *_old, const char *_new);
extern  FILE   *tmpfile(void);
extern  char   *tmpnam(char *_s);

/****************************************************************************/
/* FILE ACCESS FUNCTIONS                                                    */
/****************************************************************************/
extern  int     fclose(FILE *_fp); 
extern  FILE   *fopen(const char *_fname, const char *_mode);
extern  FILE   *freopen(const char *_fname, const char *_mode,
			            register FILE *_fp);
extern  void    setbuf(register FILE *_fp, char *_buf);
extern  int     setvbuf(register FILE *_fp, register char *_buf, 
			            register int _type, register size_t _size);
extern  int     fflush(register FILE *_fp); 

/****************************************************************************/
/* FORMATTED INPUT/OUTPUT FUNCTIONS                                         */
/****************************************************************************/
extern  int fprintf(FILE *_fp, const char *_format, ...)
               __attribute__((__format__ (__printf__, 2, 3)));
extern  int fscanf(FILE *_fp, const char *_fmt, ...)
               __attribute__((__format__ (__scanf__, 2, 3)));
extern  int printf(const char *_format, ...)
               __attribute__((__format__ (__printf__, 1, 2)));
extern  int scanf(const char *_fmt, ...)
               __attribute__((__format__ (__scanf__, 1, 2)));
extern  int sprintf(char *_string, const char *_format, ...)
               __attribute__((__format__ (__printf__, 2, 3)));
extern  int snprintf(char *_string, size_t _n, 
				 const char *_format, ...)
               __attribute__((__format__ (__printf__, 3, 4)));
extern  int sscanf(const char *_str, const char *_fmt, ...)
               __attribute__((__format__ (__scanf__, 2, 3)));
extern  int vfprintf(FILE *_fp, const char *_format, va_list _ap)
               __attribute__((__format__ (__printf__, 2, 0)));
extern  int vfscanf(FILE *_fp, const char *_fmt, va_list _ap)
               __attribute__((__format__ (__scanf__, 2, 0)));
extern  int vprintf(const char *_format, va_list _ap)
               __attribute__((__format__ (__printf__, 1, 0)));
extern  int vscanf(const char *_format, va_list _ap)
               __attribute__((__format__ (__scanf__, 1, 0)));
extern  int vsprintf(char *_string, const char *_format,
				 va_list _ap)
               __attribute__((__format__ (__printf__, 2, 0)));
extern  int vsnprintf(char *_string, size_t _n, 
				  const char *_format, va_list _ap)
               __attribute__((__format__ (__printf__, 3, 0)));
extern  int vsscanf(const char *_str, const char *_fmt, va_list _ap)
               __attribute__((__format__ (__scanf__, 2, 0)));

/****************************************************************************/
/* CHARACTER INPUT/OUTPUT FUNCTIONS                                         */
/****************************************************************************/
extern  int     fgetc(register FILE *_fp);
extern  char   *fgets(char *_ptr, register int _size,
				  register FILE *_fp);
extern  int     fputc(int _c, register FILE *_fp);
extern  int     fputs(const char *_ptr, register FILE *_fp);
extern  int     getc(FILE *_p);
extern  int     getchar(void);
extern  char   *gets(char *_ptr); 
extern  int     putc(int _x, FILE *_fp);
extern  int     putchar(int _x);
extern  int     puts(const char *_ptr); 
extern  int     ungetc(int _c, register FILE *_fp);

/****************************************************************************/
/* DIRECT INPUT/OUTPUT FUNCTIONS                                            */
/****************************************************************************/
extern  size_t  fread(void *_ptr, size_t _size, size_t _count,
				  FILE *_fp);
extern  size_t  fwrite(const void *_ptr, size_t _size,
				   size_t _count, register FILE *_fp); 

/****************************************************************************/
/* FILE POSITIONING FUNCTIONS                                               */
/****************************************************************************/
extern  int     fgetpos(FILE *_fp, fpos_t *_pos);
extern  int     fseek(register FILE *_fp, long _offset,
				  int _ptrname);
extern  int     fsetpos(FILE *_fp, const fpos_t *_pos);
extern  long    ftell(FILE *_fp);
extern  void    rewind(register FILE *_fp); 

/****************************************************************************/
/* ERROR-HANDLING FUNCTIONS                                                 */
/****************************************************************************/
extern  void    clearerr(FILE *_fp);
extern  int     feof(FILE *_fp);
extern  int     ferror(FILE *_fp);
extern  void    perror(const char *_s);




} /* extern "C" namespace std */


using std::size_t;
using std::FILE;
using std::fpos_t;
using std::_ftable;
using std::__TI_tmpnams;
using std::remove;
using std::rename;
using std::tmpfile;
using std::tmpnam;
using std::fclose;
using std::fopen;
using std::freopen;
using std::setbuf;
using std::setvbuf;
using std::fflush;
using std::fprintf;
using std::fscanf;
using std::printf;
using std::scanf;
using std::sprintf;
using std::snprintf;
using std::sscanf;
using std::vfprintf;
using std::vprintf;
using std::vsprintf;
using std::vsnprintf;
using std::fgetc;
using std::fgets;
using std::fputc;
using std::fputs;
using std::getc;
using std::getchar;
using std::gets;
using std::putc;
using std::putchar;
using std::puts;
using std::ungetc;
using std::fread;
using std::fwrite;
using std::fgetpos;
using std::fseek;
using std::fsetpos;
using std::ftell;
using std::rewind;
using std::clearerr;
using std::feof;
using std::ferror;
using std::perror;



/*****************************************************************************/
/* string.h   v16.12.0                                                       */
/*                                                                           */
/* Copyright (c) 1993-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/



#pragma diag_push
#pragma CHECK_MISRA("-6.3") /* standard types required for standard headers */
#pragma CHECK_MISRA("-19.1") /* #includes required for implementation */
#pragma CHECK_MISRA("-20.1") /* standard headers must define standard names */
#pragma CHECK_MISRA("-20.2") /* standard headers must define standard names */

/*---------------------------------------------------------------------------*/
/* <cstring> IS RECOMMENDED OVER <string.h>.  <string.h> IS PROVIDED FOR     */
/* COMPATIBILITY WITH C AND THIS USAGE IS DEPRECATED IN C++                  */
/*---------------------------------------------------------------------------*/
extern "C" namespace std
{
 



#pragma diag_push
#pragma CHECK_MISRA("-19.4") /* macros required for implementation */


#pragma diag_pop

 size_t  strlen(const char *string);

 char *strcpy(char *dest, const char *src);
 char *strncpy(char *dest, const char *src, size_t n);
 char *strcat(char *string1, const char *string2);
 char *strncat(char *dest, const char *src, size_t n);
 char *strchr(const char *string, int c);
 char *strrchr(const char *string, int c);

 int  strcmp(const char *string1, const char *string2);
 int  strncmp(const char *string1, const char *string2, size_t n);

 int     strcoll(const char *string1, const char *_string2);
 size_t  strxfrm(char *to, const char *from, size_t n);
 char   *strpbrk(const char *string, const char *chs);
 size_t  strspn(const char *string, const char *chs);
 size_t  strcspn(const char *string, const char *chs);
 char   *strstr(const char *string1, const char *string2);
 char   *strtok(char *str1, const char *str2);
 char   *strerror(int _errno);
 char   *strdup(const char *string);


 void   *memmove(void *s1, const void *s2, size_t n);
#pragma diag_push
#pragma CHECK_MISRA("-16.4") /* false positives due to builtin declarations */
 void   *memcpy(void *s1, const void *s2, size_t n);
#pragma diag_pop

 int     memcmp(const void *cs, const void *ct, size_t n);
 void   *memchr(const void *cs, int c, size_t n);

   void   *memset(void *mem, int ch, size_t length);


} /* extern "C" namespace std */


#pragma diag_pop


#pragma diag_push

/* using declarations must occur outside header guard to support including both
   C and C++-wrapped version of header; see _CPP_STYLE_HEADER check */
/* this code is for C++ mode only and thus also not relevant for MISRA */
#pragma CHECK_MISRA("-19.15")

using std::size_t;
using std::strlen;
using std::strcpy;
using std::strncpy;
using std::strcat;
using std::strncat;
using std::strchr;
using std::strrchr;
using std::strcmp;
using std::strncmp;
using std::strcoll;
using std::strxfrm;
using std::strpbrk;
using std::strspn;
using std::strcspn;
using std::strstr;
using std::strtok;
using std::strerror;
using std::strdup;
using std::memmove;
using std::memcpy;
using std::memcmp;
using std::memchr;
using std::memset;



#pragma diag_pop
/*
 * Copyright (c) 2015-2015 Texas Instruments Incorporated
 *
 * ====================================================
 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
 *
 * Developed at SunPro, a Sun Microsystems, Inc. business.
 * Permission to use, copy, modify, and distribute this
 * software is freely granted, provided that this notice
 * is preserved.
 * ====================================================
 */

/*
 * from: @(#)fdlibm.h 5.1 93/09/24
 * $FreeBSD$
 */


#pragma diag_push
#pragma CHECK_MISRA("-6.3") /* standard types required for standard headers */
#pragma CHECK_MISRA("-16.4") /* identifiers in fn defn/decl identical??? fabs/fabsf */
#pragma CHECK_MISRA("-19.1") /* only comments and preproc before #include */
#pragma CHECK_MISRA("-19.7") /* macros required for implementation */
#pragma CHECK_MISRA("-20.1") /* standard headers must define standard names */
#pragma CHECK_MISRA("-20.2") /* standard headers must define standard names */

/*****************************************************************************/
/* _defs.h   v16.12.0                                                        */
/*                                                                           */
/* Copyright (c) 2015-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


#pragma diag_push

#pragma CHECK_MISRA("-8.1") /* visible prototypes */
#pragma CHECK_MISRA("-8.5") /* functions in header files */
#pragma CHECK_MISRA("-8.11") /* use static on fns with internal linkage */
#pragma CHECK_MISRA("-10.1") /* implicit conversion ... bool to int??? */
#pragma CHECK_MISRA("-12.1") /* operator precedence */
#pragma CHECK_MISRA("-12.2") /* different order of operations??? */
#pragma CHECK_MISRA("-12.4") /* RHS of &&/|| has side effects??? */
#pragma CHECK_MISRA("-14.7") /* single point of return */
#pragma CHECK_MISRA("-14.9") /* only compound statement after if/else */
#pragma CHECK_MISRA("-19.1") /* only comments and preproc before #include??? */
#pragma CHECK_MISRA("-19.4") /* macro expands to unparenthesized */

#pragma diag_suppress 1558 /* --float_operations_allowed checks */ 

/* This file is included in other user header files; take care not to
   pollute the namespace */


typedef unsigned long long __uint64_t;
typedef unsigned long __uint32_t;


/* normalize target-specific intrinsics */



























extern "C" {



/* always inline these functions so that calls to them don't appear in
   an object file and become part of the ABI. */

 __inline int __isfinite(double d)
{ return (((((unsigned int)(__f64_bits_as_u64(d) >> 48)) & 0x7ff0u) == 0x7ff0u)) == 0; }
 __inline int __isfinitef(float f)
{ return (((((unsigned int)(__f32_bits_as_u32(f) >> 16)) & 0x7f80u) == 0x7f80u)) == 0; }
 __inline int __isfinitel(long double e)
{ return (((((unsigned int)(__f64_bits_as_u64(e) >> 48)) & 0x7ff0u) == 0x7ff0u)) == 0; }

 __inline int __isnan(double d)
{ return (((((unsigned int)(__f64_bits_as_u64(d) >> 48)) & 0x7ff0u) == 0x7ff0u)) &&
        ((((__f64_bits_as_u64(d) & (((__uint64_t)(1) << (53-1)) - 1)) == 0)) == 0); }
 __inline int __isnanf(float f)
{ return (((((unsigned int)(__f32_bits_as_u32(f) >> 16)) & 0x7f80u) == 0x7f80u)) &&
        ((((__f32_bits_as_u32(f) & (((__uint32_t)(1) << (24-1)) - 1)) == 0)) == 0); }
 __inline int __isnanl(long double e)
{ return (((((unsigned int)(__f64_bits_as_u64(e) >> 48)) & 0x7ff0u) == 0x7ff0u)) &&
        ((((__f64_bits_as_u64(e) & (((__uint64_t)(1) << (53-1)) - 1)) == 0)) == 0); }

 __inline int __isnormal(double d)
{ return (((((__f64_bits_as_u64(d) >> (53-1)) & ((1024u * 2) - 1)) == 0)) == 0) &&
         ((((((unsigned int)(__f64_bits_as_u64(d) >> 48)) & 0x7ff0u) == 0x7ff0u)) == 0); }

 __inline int __isnormalf(float f)
{ return ((((((unsigned int)(__f32_bits_as_u32(f) >> (24-1))) & ((128u * 2) - 1)) == 0)) == 0) &&
         ((((((unsigned int)(__f32_bits_as_u32(f) >> 16)) & 0x7f80u) == 0x7f80u)) == 0); }

 __inline int __isnormall(long double e)
{ return (((((__f64_bits_as_u64(e) >> (53-1)) & ((1024u * 2) - 1)) == 0)) == 0) &&
         ((((((unsigned int)(__f64_bits_as_u64(e) >> 48)) & 0x7ff0u) == 0x7ff0u)) == 0); }

 __inline int __signbit(double d)
{ return (((__f64_bits_as_u64(d) & ((__uint64_t)(1) << (64-1))) == 0)) == 0; }
 __inline int __signbitf(float f)
{ return (((__f32_bits_as_u32(f) & ((__uint32_t)(1) << (32-1))) == 0)) == 0; }
 __inline int __signbitl(long double e)
{ return (((__f64_bits_as_u64(e) & ((__uint64_t)(1) << (64-1))) == 0)) == 0; }

/* FreeBSD lib/libc/gen/isinf.c says "These routines belong in libm,
   but they must remain in libc for binary compat until we can bump
   libm's major version number" */

 __inline int __isinff(float f)
{ return (((((unsigned int)(__f32_bits_as_u32(f) >> 16)) & 0x7f80u) == 0x7f80u)) && (((__f32_bits_as_u32(f) & (((__uint32_t)(1) << (24-1)) - 1)) == 0)); }
 __inline int __isinf (double d)
{ return (((((unsigned int)(__f64_bits_as_u64(d) >> 48)) & 0x7ff0u) == 0x7ff0u)) && (((__f64_bits_as_u64(d) & (((__uint64_t)(1) << (53-1)) - 1)) == 0)); }
 __inline int __isinfl(long double e)
{ return (((((unsigned int)(__f64_bits_as_u64(e) >> 48)) & 0x7ff0u) == 0x7ff0u)) && (((__f64_bits_as_u64(e) & (((__uint64_t)(1) << (53-1)) - 1)) == 0)); }

/* Symbolic constants to classify floating point numbers. */

 __inline int __fpclassifyf(float f)
{
    if ((((((unsigned int)(__f32_bits_as_u32(f) >> 16)) & 0x7f80u) == 0x7f80u)))
    {
        if ((((__f32_bits_as_u32(f) & (((__uint32_t)(1) << (24-1)) - 1)) == 0)))
            return 1;
        else return 2;
    }
    if ((((((unsigned int)(__f32_bits_as_u32(f) >> (24-1))) & ((128u * 2) - 1)) == 0)))
    {
        if ((((__f32_bits_as_u32(f) & (((__uint32_t)(1) << (24-1)) - 1)) == 0)))
            return 0;
        else return (-2);
    }            
    return (-1);
}

 __inline int __fpclassify (double d)
{
    if ((((((unsigned int)(__f64_bits_as_u64(d) >> 48)) & 0x7ff0u) == 0x7ff0u)))
    {
        if ((((__f64_bits_as_u64(d) & (((__uint64_t)(1) << (53-1)) - 1)) == 0)))
            return 1;
        else return 2;
    }
    if (((((__f64_bits_as_u64(d) >> (53-1)) & ((1024u * 2) - 1)) == 0)))
    {
        if ((((__f64_bits_as_u64(d) & (((__uint64_t)(1) << (53-1)) - 1)) == 0)))
            return 0;
        else return (-2);
    }            
    return (-1);
}

 __inline int __fpclassifyl(long double e)
{
    if ((((((unsigned int)(__f64_bits_as_u64(e) >> 48)) & 0x7ff0u) == 0x7ff0u)))
    {
        if ((((__f64_bits_as_u64(e) & (((__uint64_t)(1) << (53-1)) - 1)) == 0)))
            return 1;
        else return 2;
    }
    if (((((__f64_bits_as_u64(e) >> (53-1)) & ((1024u * 2) - 1)) == 0)))
    {
        if ((((__f64_bits_as_u64(e) & (((__uint64_t)(1) << (53-1)) - 1)) == 0)))
            return 0;
        else return (-2);
    }            
    return (-1);
}

}

/*
 * Relevant target macros indicating hardware float support
 *
 * all
 * 	__TI_STRICT_FP_MODE__
 * ARM
 *      __TI_VFPV3_SUPPORT__
 *      __TI_VFPV3D16_SUPPORT__
 *      __TI_FPv4SPD16_SUPPORT__
 *      __TI_VFP_SUPPORT__
 * C2000
 *      __TMS320C28XX_FPU32__
 *      __TMS320C28XX_FPU64__
 *      __TMS320C28XX_TMU__	adds div, sqrt, sin, cos, atan, atan2
 * C6000
 *      _TMS320C6700		indicates C67x or later
 */







#pragma diag_pop



/*
 * ANSI/POSIX
 */





/* Symbolic constants to classify floating point numbers. */





/*
 * XOPEN/SVID
 */

extern "C" namespace std {

/*---------------------------------------------------------------------------*/
/* If --fp_mode=relaxed is used and VFP is enabled, use the hardware square  */
/* root directly instead of calling the sqrtx routine. This will not set     */
/* errno if the argument is negative.                                        */
/*                                                                           */
/* This is done by defining sqrt to _relaxed_sqrt to allow other translation */
/* units to use the normal sqrt routine under strict mode.                   */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* TMU SUPPORT AND RELAXED MODE: USE INSTRINSICS.                            */
/*---------------------------------------------------------------------------*/

/* Disable double_t and float_t for C28x because of Motorware (AY 2015) */
/* These typedefs depend on the value of FLT_EVAL_METHOD */
typedef	double	double_t;
typedef	float	float_t;

 double      acos(double x);
 float       acosf(float x);
 long double acosl(long double x);
 double      asin(double x);
 float       asinf(float x);
 long double asinl(long double x);
 double      atan(double x);
 float       atanf(float x);
 long double atanl(long double x);
 double      atan2(double y, double x);
 float       atan2f(float y, float x);
 long double atan2l(long double y, long double x);
 double      cos(double x);
 float       cosf(float x);
 long double cosl(long double x);
 double      sin(double x);
 float       sinf(float x);
 long double sinl(long double x);
 double      tan(double x);
 float       tanf(float x);
 long double tanl(long double x);
 double      acosh(double x);
 float       acoshf(float x);
 long double acoshl(long double x);
 double      asinh(double x);
 float       asinhf(float x);
 long double asinhl(long double x);
 double      atanh(double x);
 float       atanhf(float x);
 long double atanhl(long double x);
 double      cosh(double x);
 float       coshf(float x);
 long double coshl(long double x);
 double      sinh(double x);
 float       sinhf(float x);
 long double sinhl(long double x);
 double      tanh(double x);
 float       tanhf(float x);
 long double tanhl(long double x);
 double      exp(double x);
 float       expf(float x);
 long double expl(long double x);
 double      exp2(double x);
 float       exp2f(float x);
 long double exp2l(long double x);
 double      expm1(double x);
 float       expm1f(float x);
 long double expm1l(long double x);
 double      frexp(double val, int *e);
 float       frexpf(float val, int *e);
 long double frexpl(long double val, int *e);
 int         ilogb(double x);
 int         ilogbf(float x);
 int         ilogbl(long double x);
 double      ldexp(double x, int e);
 float       ldexpf(float x, int e);
 long double ldexpl(long double x, int e);
 double      log(double x);
 float       logf(float x);
 long double logl(long double x);
 double      log10(double x);
 float       log10f(float x);
 long double log10l(long double x);
 double      log1p(double x);
 float       log1pf(float x);
 long double log1pl(long double x);
 double      log2(double x);
 float       log2f(float x);
 long double log2l(long double x);
 double      logb(double x);
 float       logbf(float x);
 long double logbl(long double x);
 double      modf(double val, double *iptr);
 float       modff(float val, float *iptr);
 long double modfl(long double val, long double *iptr);
 double      scalbn(double x, int n);
 float       scalbnf(float x, int n);
 long double scalbnl(long double x, int n);
 double      scalbln(double x, long n);
 float       scalblnf(float x, long n);
 long double scalblnl(long double x, long n);
 double      cbrt(double x);
 float       cbrtf(float x);
 long double cbrtl(long double x);
 double      fabs(double x);
 float       fabsf(float x);
 long double fabsl(long double x);
 double      hypot(double x, double y);
 float       hypotf(float x, float y);
 long double hypotl(long double x, long double y);
 double      pow(double x, double y);
 float       powf(float x, float y);
 long double powl(long double x, long double y);
 double      sqrt(double x);
 float       sqrtf(float x);
 long double sqrtl(long double x);
 double      erf(double x);
 float       erff(float x);
 long double erfl(long double x);
 double      erfc(double x);
 float       erfcf(float x);
 long double erfcl(long double x);
 double      lgamma(double x);
 float       lgammaf(float x);
 long double lgammal(long double x);
 double      tgamma(double x);
 float       tgammaf(float x);
 long double tgammal(long double x);
 double      ceil(double x);
 float       ceilf(float x);
 long double ceill(long double x);
 double      floor(double x);
 float       floorf(float x);
 long double floorl(long double x);
 double      nearbyint(double x);
 float       nearbyintf(float x);
 long double nearbyintl(long double x);
 double      rint(double x);
 float       rintf(float x);
 long double rintl(long double x);
 long        lrint(double x);
 long        lrintf(float x);
 long        lrintl(long double x);
 long long   llrint(double x);
 long long   llrintf(float x);
 long long   llrintl(long double x);
 double      round(double x);
 float       roundf(float x);
 long double roundl(long double x);
 long        lround(double x);
 long        lroundf(float x);
 long        lroundl(long double x);
 long long   llround(double x);
 long long   llroundf(float x);
 long long   llroundl(long double x);
 double      trunc(double x);
 float       truncf(float x);
 long double truncl(long double x);
 double      fmod(double x, double y);
 float       fmodf(float x, float y);
 long double fmodl(long double x, long double y);
 double      remainder(double x, double y);
 float       remainderf(float x, float y);
 long double remainderl(long double x, long double y);
 double      remquo(double x, double y, int *quo);
 float       remquof(float x, float y, int *quo);
 long double remquol(long double x, long double y, int *quo);
 double      copysign(double x, double y);
 float       copysignf(float x, float y);
 long double copysignl(long double x, long double y);
 double      nan(const char *tagp);
 float       nanf(const char *tagp);
 long double nanl(const char *tagp);
 double      nextafter(double x, double y);
 float       nextafterf(float x, float y);
 long double nextafterl(long double x, long double y);
 double      nexttoward(double x, long double y);
 float       nexttowardf(float x, long double y);
 long double nexttowardl(long double x, long double y);
 double      fdim(double x, double y);
 float       fdimf(float x, float y);
 long double fdiml(long double x, long double y);
 double      fmax(double x, double y);
 float       fmaxf(float x, float y);
 long double fmaxl(long double x, long double y);
 double      fmin(double x, double y);
 float       fminf(float x, float y);
 long double fminl(long double x, long double y);
 double      fma(double x, double y, double z);
 float       fmaf(float x, float y, float z);
 long double fmal(long double x, long double y, long double z);

    }

#pragma diag_pop


#pragma diag_push

/* using declarations must occur outside header guard to support including both
   C and C++-wrapped version of header; see _CPP_STYLE_HEADER check */
/* this code is for C++ mode only and thus also not relevant for MISRA */
#pragma CHECK_MISRA("-19.15")


using std::acos;
using std::acosf;
using std::acosl;
using std::asin;
using std::asinf;
using std::asinl;
using std::atan;
using std::atanf;
using std::atanl;
using std::atan2;
using std::atan2f;
using std::atan2l;
using std::cos;
using std::cosf;
using std::cosl;
using std::sin;
using std::sinf;
using std::sinl;
using std::tan;
using std::tanf;
using std::tanl;
using std::acosh;
using std::acoshf;
using std::acoshl;
using std::asinh;
using std::asinhf;
using std::asinhl;
using std::atanh;
using std::atanhf;
using std::atanhl;
using std::cosh;
using std::coshf;
using std::coshl;
using std::sinh;
using std::sinhf;
using std::sinhl;
using std::tanh;
using std::tanhf;
using std::tanhl;
using std::exp;
using std::expf;
using std::expl;
using std::exp2;
using std::exp2f;
using std::exp2l;
using std::expm1;
using std::expm1f;
using std::expm1l;
using std::frexp;
using std::frexpf;
using std::frexpl;
using std::ilogb;
using std::ilogbf;
using std::ilogbl;
using std::ldexp;
using std::ldexpf;
using std::ldexpl;
using std::log;
using std::logf;
using std::logl;
using std::log10;
using std::log10f;
using std::log10l;
using std::log1p;
using std::log1pf;
using std::log1pl;
using std::log2;
using std::log2f;
using std::log2l;
using std::logb;
using std::logbf;
using std::logbl;
using std::modf;
using std::modff;
using std::modfl;
using std::scalbn;
using std::scalbnf;
using std::scalbnl;
using std::scalbln;
using std::scalblnf;
using std::scalblnl;
using std::cbrt;
using std::cbrtf;
using std::cbrtl;
using std::fabs;
using std::fabsf;
using std::fabsl;
using std::hypot;
using std::hypotf;
using std::hypotl;
using std::pow;
using std::powf;
using std::powl;
using std::sqrt;
using std::sqrtf;
using std::sqrtl;
using std::erf;
using std::erff;
using std::erfl;
using std::erfc;
using std::erfcf;
using std::erfcl;
using std::lgamma;
using std::lgammaf;
using std::lgammal;
using std::tgamma;
using std::tgammaf;
using std::tgammal;
using std::ceil;
using std::ceilf;
using std::ceill;
using std::floor;
using std::floorf;
using std::floorl;
using std::nearbyint;
using std::nearbyintf;
using std::nearbyintl;
using std::rint;
using std::rintf;
using std::rintl;
using std::lrint;
using std::lrintf;
using std::lrintl;
using std::llrint;
using std::llrintf;
using std::llrintl;
using std::round;
using std::roundf;
using std::roundl;
using std::lround;
using std::lroundf;
using std::lroundl;
using std::llround;
using std::llroundf;
using std::llroundl;
using std::trunc;
using std::truncf;
using std::truncl;
using std::fmod;
using std::fmodf;
using std::fmodl;
using std::remainder;
using std::remainderf;
using std::remainderl;
using std::remquo;
using std::remquof;
using std::remquol;
using std::copysign;
using std::copysignf;
using std::copysignl;
using std::nan;
using std::nanf;
using std::nanl;
using std::nextafter;
using std::nextafterf;
using std::nextafterl;
using std::nexttoward;
using std::nexttowardf;
using std::nexttowardl;
using std::fdim;
using std::fdimf;
using std::fdiml;
using std::fmax;
using std::fmaxf;
using std::fmaxl;
using std::fmin;
using std::fminf;
using std::fminl;
using std::fma;
using std::fmaf;
using std::fmal;

using std::float_t;
using std::double_t;



#pragma diag_pop
/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/* NOTE : this header has no guards and is MEANT for multiple inclusion!
 * If you are using "header protection" option with your compiler,
 * please also find #pragma which disables it and put it here, to
 * allow reentrancy of this header.
 */

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/* NOTE : this header has no guards and is MEANT for multiple inclusion!
 * If you are using "header protection" option with your compiler,
 * please also find #pragma which disables it and put it here, to
 * allow reentrancy of this header.
 */




/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

 /*
  *
  * Copyright (c) 1994
  * Hewlett-Packard Company
  *
  * Copyright (c) 1996,1997
  * Silicon Graphics Computer Systems, Inc.
  *
  * Copyright (c) 1997
  * Moscow Center for SPARC Technology
  *
  * Copyright (c) 1999
  * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
  *
  * This material is provided "as is", with absolutely no warranty expressed
  * or implied. Any use is at your own risk.
  *
  * Permission to use or copy this software for any purpose is hereby granted
  * without fee, provided the above notices are retained on all copies.
  * Permission to modify the code and to distribute modified code is granted,
  * provided the above notices are retained, and a notice that the code was
  * modified is included with the above copyright notice.
  *
  */


/*
 * Purpose of this file:
 *
 * Defines all STLport settings.
 * This file is actually a wrapper : it includes compiler-specific
 * settings from <config/stlcomp.h>
 * and user-defined settings from <config/user_config.h>.
 * See <config/stl_mycomp.h> and <config/user_config.h> for the description
 * of those macros
 *
 */

/* Definition of the STLport version informations */
/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> by Texas Instruments.   */
/******************************************************************************/

 /*
 *
 * Copyright (c) 2005
 * Francois Dumont
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


/* The last SGI STL release we merged with */

/* STLport version */



/* Other macros defined by this file:

 * bool, true, and false, if _STLP_NO_BOOL is defined.
 * typename, as a null macro if it's not already a keyword.
 * explicit, as a null macro if it's not already a keyword.
 * namespace-related macros (_STLP_STD, _STLP_BEGIN_NAMESPACE, etc.)
 * exception-related macros (_STLP_TRY, _STLP_UNWIND, etc.)
 * _STLP_ASSERT, either as a test or as a null macro, depending on
   whether or not _STLP_ASSERTIONS is defined.
*/

/* Definition of the 2 STLport debug levels */

/* Placeholder for user to override settings.
 * It could be also used to mask settings from
 * different directories.
 */
/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 */

/*
 * Purpose of this file :
 *
 * To hold user-definable portion of STLport settings which may be overridden
 * on per-project basis.
 * Please note that if you use STLport iostreams (compiled library) then you have
 * to use consistent settings when you compile STLport library and your project.
 * Those settings are defined in host.h and have to be the same for a given
 * STLport installation.
 */


/*==========================================================
 * User-settable macros that control compilation:
 *              Features selection
 *==========================================================*/

/*
 * Use this switch for embedded systems where no iostreams are available
 * at all. STLport own iostreams will also get disabled automatically then.
 * You can either use STLport iostreams, or no iostreams.
 * If you want iostreams, you have to compile library in ../build/lib
 * and supply resulting library at link time.
 */
/*
#define _STLP_NO_IOSTREAMS 1
*/

/*
 * Set _STLP_DEBUG to turn the "Debug Mode" on.
 * That gets you checked iterators/ranges in the manner
 * of "Safe STL". Very useful for debugging. Thread-safe.
 * Please do not forget to link proper STLport library flavor
 * (e.g libstlportstlg.so or libstlportstlg.a) when you set this flag
 * in STLport iostreams mode, namespace customization guaranty that you
 * link to the right library.
 */
/*
#define _STLP_DEBUG 1
*/
/*
 * You can also choose the debug level:
 * STLport debug level: Default value
 *                      Check only what the STLport implementation consider as invalid.
 *                      It also change the iterator invalidation schema.
 * Standard debug level: Check for all operations the standard consider as "undefined behavior"
 *                       even if STlport implement it correctly. It also invalidates iterators
 *                       more often.
 */
/*
#define   _STLP_DEBUG_LEVEL _STLP_STLPORT_DBG_LEVEL
#define   _STLP_DEBUG_LEVEL _STLP_STANDARD_DBG_LEVEL
*/
/* When an inconsistency is detected by the 'safe STL' the program will abort.
 * If you prefer an exception define the following macro. The thrown exception
 * will be the Standard runtime_error exception.
 */
/*
#define _STLP_DEBUG_MODE_THROWS
 */

/*
 * _STLP_NO_CUSTOM_IO : define this if you do not instantiate basic_xxx iostream
 * classes with custom types (which is most likely the case). Custom means types
 * other than char, wchar_t, char_traits<> and allocator<> like
 * basic_ostream<my_char_type, my_traits<my_char_type> > or
 * basic_string<char, char_traits<char>, my_allocator >
 * When this option is on, most non-inline template functions definitions for iostreams
 * are not seen by the client which saves a lot of compile time for most compilers,
 * also object and executable size for some.
 * Default is off, just not to break compilation for those who do use those types.
 * That also guarantees that you still use optimized standard i/o when you compile
 * your program without optimization. Option does not affect STLport library build; you
 * may use the same binary library with and without this option, on per-project basis.
 */
/*
#define _STLP_NO_CUSTOM_IO
*/

/*
 * _STLP_NO_RELOPS_NAMESPACE: if defined, don't put the relational
 * operator templates (>, <=, >=, !=) in namespace std::rel_ops, even
 * if the compiler supports namespaces.
 * Note : if the compiler do not support namespaces, those operators are not be provided by default,
 * to simulate hiding them into rel_ops. This was proved to resolve many compiler bugs with ambiguity.
 */
/*
#define _STLP_NO_RELOPS_NAMESPACE 1
*/

/*
 * If STLport use its own namespace, see _STLP_NO_OWN_NAMESPACE in host.h, it will try
 * by default to rename std:: for the user to stlport::. If you do not want this feature,
 * please define the following switch and then use stlport::
 */
/*
#define _STLP_DONT_REDEFINE_STD 1
*/

/*
 * _STLP_WHOLE_NATIVE_STD : only meaningful if STLport uses its own namespace.
 * Normally, STLport only imports necessary components from native std:: namespace.
 * You might want everything from std:: being available in std:: namespace when you
 * include corresponding STLport header (like STLport <map> provides std::map as well, etc.),
 * if you are going to use both stlport:: and std:: components in your code.
 * Otherwise this option is not recommended as it increases the size of your object files
 * and slows down compilation.
 * Beware, if you do not use STLport iostream (_STLP_NO_IOSTREAMS above), ask STLport to
 * not rename std:: in stlport:: and try to have access to whole native Standard stuff then
 * STLport will only throw exceptions from the std namespace and not from stlport.
 * For instance a problem in stlport::vector::at will throw a std::out_of_range exception
 * and not a stlport::out_of_range.
 * Notice that STLport exceptions inherits from std::exception.
 */
/*
#define _STLP_WHOLE_NATIVE_STD
*/

/*
 * Use this option to catch uninitialized members in your classes.
 * When it is set, construct() and destroy() fill the class storage
 * with _STLP_SHRED_BYTE (see below).
 * Note : _STLP_DEBUG and _STLP_DEBUG_ALLOC don't set this option automatically.
 */
/*
#define _STLP_DEBUG_UNINITIALIZED 1
#define _STLP_DEBUG_ALLOC 1
*/

/*
 * Uncomment and provide a definition for the byte with which raw memory
 * will be filled if _STLP_DEBUG_ALLOC or _STLP_DEBUG_UNINITIALIZED is defined.
 * Choose a value which is likely to cause a noticeable problem if dereferenced
 * or otherwise abused. A good value may already be defined for your platform.
 */
/*
#define _STLP_SHRED_BYTE 0xA3
*/

/*
 *  This option is for gcc users only and only affects systems where native linker
 *  does not let gcc to implement automatic instantiation of static template data members/
 *  It is being put in this file as there is no way to check if we are using GNU ld automatically,
 *  so it becomes user's responsibility.
 */
/*
#define _STLP_GCC_USES_GNU_LD
*/

/*==========================================================
 * Compatibility section
 *==========================================================*/

/*
 *  Define this macro to disable anachronistic constructs (like the ones used in HP STL and
 *  not included in final standard, etc.
 */
/*
#define _STLP_NO_ANACHRONISMS 1
*/

/*
 *  Define this macro to disable STLport extensions (for example, to make sure your code will
 *  compile with some other implementation )
 */
/*
#define _STLP_NO_EXTENSIONS 1
*/

/*
 * You should define this macro if compiling with MFC - STLport <stl/config/_windows.h>
 * then include <afx.h> instead of <windows.h> to get synchronisation primitives
 */
/*
#define _STLP_USE_MFC 1
*/

/*
 * boris : this setting is here as we cannot detect precense of new Platform SDK automatically
 * If you are using new PSDK with VC++ 6.0 or lower,
 * please define this to get correct prototypes for InterlockedXXX functions
 */
/*
#define _STLP_NEW_PLATFORM_SDK 1
*/

/*
 * For the same reason as the one above we are not able to detect easily use
 * of the compiler coming with the Platform SDK instead of the one coming with
 * a Microsoft Visual Studio release. This change native C/C++ library location
 * and implementation, please define this to get correct STLport configuration.
 */
/*
#define _STLP_USING_PLATFORM_SDK_COMPILER 1
*/

/*
 * Some compilers support the automatic linking feature.
 * Uncomment the following if you prefer to specify the STLport library
 * to link with yourself.
 * For the moment, this feature is only supported and implemented within STLport
 * by the Microsoft compilers.
 */
/*
#define _STLP_DONT_USE_AUTO_LINK 1
*/

/*
 * If you customize the STLport generated library names don't forget to give
 * the motif you used during configuration here if you still want the auto link
 * to work. (Do not remove double quotes in the macro value)
 */
/*
#define _STLP_LIB_NAME_MOTIF "???"
 */

/*
 * Uncomment to get feedback at compilation time about result of build environment
 * introspection.
 */
/*
#define _STLP_VERBOSE 1
*/

/*
 * Use minimum set of default arguments on template classes that have more
 * than one - for example map<>, set<>.
 * This has effect only if _STLP_LIMITED_DEFAULT_TEMPLATES is on.
 * If _STLP_MINIMUM_DEFAULT_TEMPLATE_PARAMS is set, you'll be able to compile
 * set<T> with those compilers, but you'll have to use __set__<T, less<T>>
 *
 * Affects : map<>, multimap<>, set<>, multiset<>, hash_*<>,
 * queue<>, priority_queue<>, stack<>, istream_iterator<>
 */
/*
#define _STLP_MINIMUM_DEFAULT_TEMPLATE_PARAMS 1
*/

/*
 * The agregation of strings using the + operator is an expensive operation
 * as it requires construction of temporary objects that need memory allocation
 * and deallocation. The problem can be even more important if you are adding
 * several strings together in a single expression. To avoid this problem STLport
 * implement expression template. With this technique addition of 2 strings is not
 * a string anymore but a temporary object having a reference to each of the
 * original strings involved in the expression. This object carry information
 * directly to the destination string to set its size correctly and only make
 * a single call to the allocator. This technique also works for the addition of
 * N elements where elements are basic_string, C string or a single character.
 * The drawback can be longer compilation time and bigger executable size.
 * Another problem is that some compilers (gcc) fail to use string proxy object
 * if do with class derived from string (see unit tests for details).
 * STLport rebuild: Yes
 */


/*
 * By default the STLport basic_string implementation use a little static buffer
 * (of 16 chars when writing this doc) to avoid systematically memory allocation
 * in case of little basic_string. The drawback of such a method is bigger
 * basic_string size and some performance penalty for method like swap. If you
 * prefer systematical dynamic allocation turn on this macro.
 * STLport rebuild: Yes
 */
/*
#define _STLP_DONT_USE_SHORT_STRING_OPTIM 1
*/

/*
 * To reduce the famous code bloat trouble due to the use of templates STLport grant
 * a specialization of some containers for pointer types. So all instanciations
 * of those containers with a pointer type will use the same implementation based on
 * a container of void*. This feature has shown very good result on object files size
 * but after link phase and optimization you will only experiment benefit if you use
 * many container with pointer types.
 * There are however a number of limitation to use this option:
 *   - with compilers not supporting partial template specialization feature, you won't
 *     be able to access some nested container types like iterator as long as the
 *     definition of the type used to instanciate the container will be incomplete
 *     (see IncompleteClass definition in test/unit/vector_test.cpp).
 *   - you won't be able to use complex Standard allocator implementations which are
 *     allocators having pointer nested type not being a real C pointer.
 */
//#define _STLP_USE_PTR_SPECIALIZATIONS 1

/*
 * To achieve many different optimizations within the template implementations STLport
 * uses some type traits technique. With this macro you can ask STLport to use the famous
 * boost type traits rather than the internal one. The advantages are more compiler
 * integration and a better support. If you only define this macro once the STLport has been
 * built you just have to add the boost install path within your include path. If you want
 * to use this feature at STLport built time you will have to define the
 * STLP_BUILD_BOOST_PATH enrironment variable with the value of the boost library path.
 */

/*
#define _STLP_USE_BOOST_SUPPORT 1
*/


/*==========================================================*/

/*
  Local Variables:
  mode: C++
  End:
*/



/* ========================================================= */
/* This file is used for compatibility; it accepts old-style config
   switches */
/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> by Texas Instruments.   */
/******************************************************************************/

/*
 * Compatibility section
 * This section sets new-style macros based on old-style ones, for compatibility
 */










/* STLport do not support anymore the iostream wrapper mode so this macro should
 * always been define for other libraries that was using it:
 */


/* Common configuration file for this particular installation. */
/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * This file defines site configuration.
 */

/*
 * _STLP_NO_THREADS: if defined, STLport don't use any
 * multithreading support. Synonym is _NOTHREADS
 */
/*
#define _NOTHREADS
#define _STLP_NO_THREADS
*/

/* _PTHREADS: if defined, use POSIX threads for multithreading support. */
/*
#define _PTHREADS
*/

/* compatibility section
 */


/*
 * Turn _STLP_USE_DYNAMIC_LIB to enforce use of .dll version of STLport library.
 * NOTE: please do that only if you know what you are doing!
 * Changing default will require you to change makefiles in "build" accordingly
 * and to rebuild STLPort library!
 * On UNIX, this has no effect, see build/lib/README for make tags.
 * See STLport configuration file (build/lib/configure.bat) for help in building
 * the require library versions.
 */
/*
#define _STLP_USE_DYNAMIC_LIB
*/

/*
 * Turn _STLP_USE_STATIC_LIB to enforce use of static version of STLport library.
 * NOTE: please do that only if you know what you are doing!
 * Changing default will require you to change makefile in "build" accordingly
 * and to rebuild STLPort library!
 * On UNIX, this has no effect, see build/lib/README for make tags.
 * See STLport configuration file (build/lib/configure.bat) for help in building
 * the require library versions.
 */
/*
#define _STLP_USE_STATIC_LIB
*/

/*
 * Edit relative path below (or put full path) to get native
 * compiler vendor's headers included. Default is "../include"
 * for _STLP_NATIVE_INCLUDE_PATH, default for other macros is
 * _STLP_NATIVE_INCLUDE_PATH.
 * Hint: never install STLport in the directory that ends with "include"
 */
/*
#undef _STLP_NATIVE_INCLUDE_PATH
#define _STLP_NATIVE_INCLUDE_PATH ../include
*/
/* same for C library headers like <cstring> */
/*
#undef _STLP_NATIVE_CPP_C_INCLUDE_PATH
#define _STLP_NATIVE_CPP_C_INCLUDE_PATH _STLP_NATIVE_INCLUDE_PATH
*/
/* same for C headers like <string.h> */
/*
#undef _STLP_NATIVE_C_INCLUDE_PATH
#define _STLP_NATIVE_C_INCLUDE_PATH _STLP_NATIVE_INCLUDE_PATH
*/
/* Some compilers locate basic C++ runtime support headers (<new>, <typeinfo>, <exception>) in separate directory */
/*
#undef _STLP_NATIVE_CPP_RUNTIME_INCLUDE_PATH
#define _STLP_NATIVE_CPP_RUNTIME_INCLUDE_PATH _STLP_NATIVE_INCLUDE_PATH
*/

/*
 * If namespases available, STLport use own namespace (and masquerade
 * it as std). Disable own namespace may cause undefined behaviour.
 */
/*
#define _STLP_NO_OWN_NAMESPACE  1
*/

/*
 * Uncomment _STLP_LEAKS_PEDANTIC to force deallocation of ALL allocated
 * memory chunks. Normally not required. But if you worry about quazi-leaks
 * (may be reported by some leaks detection tools), use
 * _STLP_LEAKS_PEDANTIC. It should be used with _STLP_USE_NEWALLOC or
 * _STLP_USE_MALLOC (see below), the default node_alloc allocator also clean
 * its internal memory pool but only if STLport is used as a dynamic library
 * under Win32 (using MSVC like compilers).
 */
/*
#define _STLP_LEAKS_PEDANTIC 1
*/

/*
 * Uncomment _STLP_USE_NEWALLOC to force allocator<T> to use plain "new"
 * instead of STLport optimized node allocator engine.
 */
/*
#define _STLP_USE_NEWALLOC 1
*/

/*
 * Uncomment _STLP_USE_MALLOC to force allocator<T> to use plain "malloc"
 * instead of STLport optimized node allocator engine.
 *
 * This is default allocator for glibc 2.3.x and later, if not mentioned other
 */
/*
#define _STLP_USE_MALLOC 1
*/

/*
 * Uncomment _STLP_USE_PERTHREAD_ALLOC to force allocator<T> to use
 * a specific implementation targetting the massively multi-threaded
 * environment. The implementation is based on the POSIX pthread
 * interface.
 */
/*
#define _STLP_USE_PERTHREAD_ALLOC 1
*/

/*
 * Uncomment _STLP_USE_NODE_ALLOC if you want to force allocator<T> to use
 * "node_alloc" allocator (this is default allocator for STLport, if not
 * used other above, except glibc 2.3.x and later, where default is
 * "malloc", due to better results)
 */
/*
#define _STLP_USE_NODE_ALLOC 1
*/

/*
 * Set _STLP_DEBUG_ALLOC to use allocators that perform memory debugging,
 * such as padding/checking for memory consistency
 */
/*
#define _STLP_DEBUG_ALLOC 1
*/

/*
 * For compiler not supporting partial template specialization or ordering of
 * template functions STLport implement a workaround based on inheritance
 * detection. This inheritance can introduce trouble in client code when
 * a user class derived a STL container (which is not advised as STL containers
 * do not have virtual destructors). To disable this workaround turn this macro on:
 */
/*
#define _STLP_DONT_USE_PARTIAL_SPEC_WRKD 1
*/

/*
 * Uncomment this to force all debug diagnostic to be directed through a
 * user-defined global function:
 *  void __stl_debug_message(const char * format_str, ...)
 * instead of predefined STLport routine.
 * This allows you to take control of debug message output.
 * Default routine calls fprintf(stderr,...)
 * Note : If you set this macro, you must supply __stl_debug_message
 * function definition somewhere.
 */
/*
#define _STLP_DEBUG_MESSAGE 1
*/

/*
 * Uncomment this to force all failed assertions to be executed through
 * user-defined global function:
 *  void __stl_debug_terminate(void). This allows
 * you to take control of assertion behaviour for debugging purposes.
 * Default routine calls _STLP_ABORT().
 * Note : If you set this macro, you must supply __stl_debug_terminate
 * function definition somewhere.
 */
/*
#define _STLP_DEBUG_TERMINATE 1
*/

/*
 * Uncomment that to disable exception handling code
 */
/*
#define _STLP_DONT_USE_EXCEPTIONS 1
*/

/*
 * _STLP_NO_NAMESPACES: if defined, don't put the library in namespace
 * stlport:: or std::, even if the compiler supports namespaces
 */
/*
#define _STLP_NO_NAMESPACES 1
*/

/*==========================================================
 * Compatibility section
 *==========================================================*/

/*
 * Use abbreviated class names for linker benefit (don't affect interface).
 * This option is obsolete, but should work in this release.
 *
 */
/*
#define _STLP_USE_ABBREVS
*/

/*
 * This definition precludes STLport reverse_iterator to be compatible with
 * other parts of MSVC library. (With partial specialization, it just
 * has no effect).
 * Use it _ONLY_ if you use SGI-style reverse_iterator<> template explicitly
 */
/*
#define _STLP_NO_MSVC50_COMPATIBILITY 1
*/

/*
 * Use obsolete overloaded template functions iterator_category(), value_type(), distance_type()
 * for querying iterator properties. Please note those names are non-standard and are not guaranteed
 * to be used by every implementation. However, this setting is on by default when partial specialization
 * is not implemented in the compiler and cannot be simulated (only if _STLP_NO_ANACHRONISMS is not set).
 * Use of those interfaces for user-defined iterators is strongly discouraged:
 * please use public inheritance from iterator<> template to achieve desired effect.
 * Second form is to disable old-style queries in any case.
 */
/*
#define _STLP_USE_OLD_HP_ITERATOR_QUERIES
#define _STLP_NO_OLD_HP_ITERATOR_QUERIES
*/


/*
 * On systems with support of large files (_LARGEFILE_SOURCE,
 * _LARGEFILE64_SOURCE defined) we will use 64-bit file offset, even if
 * __USE_FILE_OFFSET64 or _FILE_OFFSET_BITS not defined or _FILE_OFFSET_BITS
 * less than 64. In the last case sizeof(std::streamoff) may not be equal to
 * sizeof(off_t); if you want to force equal size of off_t and streamoff,
 * uncomment macro below. But pay attention, this has influence on libstlport
 * and in future usage it may cause conflict with defined _FILE_OFFSET_BITS macro.
 */

/*
#define _STLP_USE_DEFAULT_FILE_OFFSET
*/

/*
 * _STLP_USE_STDIO_IO, _STLP_USE_UNIX_IO: force selection of stdio calls
 * (fopen/flose/fread/fwrite) under fstream buffers or unistd calls
 * (open/close/read/write + mmap). On systems that have both (i.e. most Unixes)
 * _STLP_USE_UNIX_IO is used. 
 *
 * There is a third variant for Windows: _STLP_USE_WIN32_IO, that based
 * on Windows calls (CreateFile/CloseHandle/ReadFile/WriteFile + CreateFileMapping,
 * MapViewOfFile)
 *
 * Uncomment only one define here!
 */
/*
#define _STLP_USE_UNIX_IO
*/
/*
#define _STLP_USE_STDIO_IO
*/
/*
#define _STLP_USE_WIN32_IO
 */

/*==========================================================================*/

/* This section contains swithes which should be off by default,
 * but so few compilers would have it undefined, so that we set them here,
 * with the option to be turned off later in compiler-specific file
 */


/*==========================================================================*/



/*
  Local Variables:
  mode:C++
  End:
*/

/* Operational Environment specific */
/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

/*
 * Purpose of this file :
 *
 * To hold COMPILER-SPECIFIC portion of STLport settings.
 * In general, user should not edit this file unless
 * using the compiler not recognized below.
 *
 * If your compiler is not being recognized yet,
 * please look for definitions of macros in stl_mycomp.h,
 * copy stl_mycomp.h to stl_YOUR_COMPILER_NAME,
 * adjust flags for your compiler, and add  <include config/stl_YOUR_COMPILER_NAME>
 * to the secton controlled by unique macro defined internaly by your compiler.
 *
 * To change user-definable settings, please edit <user_config.h>
 *
 */


/*****************************************************************************/
/*  s_c__ti.h v16.12.0                                                       */
/*                                                                           */
/* Copyright (c) 2014-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


//==========================================================



/******************************************************************************/
/* Get TI access macros.                                                      */
/******************************************************************************/


/******************************************************************************/
/* Enable any TI fixes for standard compliance.                               */
/******************************************************************************/


/******************************************************************************/
/* Set Endianness                                                             */
/******************************************************************************/


/******************************************************************************/
/* Setup std:: namespace                                                      */
/* We have an unusual setup: we don't have the native new-style C library     */
/* headers, but our C headers can be made to imitate them and place           */
/* declarations in the std:: namespace.   To allow for this, we both define   */
/* _STLP_HAS_NO_NEW_C_HEADERS and the _STLP_VENDOR_CSTD.                      */
/******************************************************************************/

// Uncomment if native new-style C library headers lile <cstddef>, etc are not available.

// uncomment this if your compiler consider as ambiguous a function imported within
// the stlport namespace and called without scope (:: or std::)

// When in C++ mode, we define C functions in the ::std namespace.

/******************************************************************************/
/* Use stdio for file handling.                                               */
/******************************************************************************/


/******************************************************************************/
/* THREADING SUPPORT                                                          */
/* We don't want the threading C++ API.                                       */
/******************************************************************************/


/******************************************************************************/
/* Setup Exception Handling                                                   */
/******************************************************************************/
// Uncomment this if your compiler does not support exceptions
// Uncomment this when you are able to detect that the user do not
// want to use the exceptions feature.


/******************************************************************************/
/* Setup Memory Allocator.                                                    */
/******************************************************************************/


/******************************************************************************/
/* Template Configuration                                                     */
/******************************************************************************/


/******************************************************************************/
/* No special handling is required to allow unused parameters.                */
/******************************************************************************/


/******************************************************************************/
/* Additional Unused Configuration Options                                    */
/******************************************************************************/
// the values choosen here as defaults try to give
// maximum functionality on the most conservative settings

// Mostly correct guess, change it for Alpha (and other environments
// that has 64-bit "long")
// #  define _STLP_UINT32_T unsigned long

// Disables wchar_t functionality
// #  define _STLP_NO_WCHAR_T  1

// Define if wchar_t is not an intrinsic type, and is actually a typedef to unsigned short.
// #  define _STLP_WCHAR_T_IS_USHORT 1

// Uncomment if long long is available
// #  define _STLP_LONG_LONG long long

// Uncomment if long double is not available
// #  define _STLP_NO_LONG_DOUBLE 1

// Uncomment this if your compiler does not support "typename" keyword
// #  define _STLP_NEED_TYPENAME 1

// Uncomment this if your compiler does not support "mutable" keyword
// #  define _STLP_NEED_MUTABLE 1

// Uncomment this if your compiler does not support "explicit" keyword
// #  define _STLP_NEED_EXPLICIT 1

// Uncomment if new-style-casts like const_cast<> are not available
// #  define _STLP_NO_NEW_STYLE_CASTS 1

// Uncomment this if your compiler does not have "bool" type
// #  define  _STLP_NO_BOOL 1

// Uncomment this if your compiler does not have "bool" type, but has "bool" keyword reserved
// #  define  _STLP_DONT_USE_BOOL_TYPEDEF 1

// Uncomment this if your compiler does not have "bool" type, but defines "bool" in <yvals.h>
// #  define  _STLP_YVALS_H 1

// Uncomment this if your compiler has limited or no default template arguments for classes
// #  define _STLP_LIMITED_DEFAULT_TEMPLATES 1

// Uncomment this if your compiler support only complete (not dependent on other parameters)
// types as default parameters for class templates
// #  define _STLP_DEFAULT_TYPE_PARAM 1

// Uncomment this if your compiler do not support default parameters in template class methods
// #  define _STLP_DONT_SUP_DFLT_PARAM 1

// Uncomment this if your compiler has problem with not-type
// default template parameters
// #  define _STLP_NO_DEFAULT_NON_TYPE_PARAM 1

// Define if compiler has
// trouble with functions getting non-type-parameterized classes as parameters
// #  define _STLP_NON_TYPE_TMPL_PARAM_BUG 1

// Uncomment this if your compiler does not support namespaces
// #  define _STLP_HAS_NO_NAMESPACES 1

// Uncomment if "using" keyword does not work with template types
// # define _STLP_BROKEN_USING_DIRECTIVE 1

// Uncomment this if your compiler does not support exceptions
// #  define _STLP_HAS_NO_EXCEPTIONS 1

// Uncomment this when you are able to detect that the user do not
// want to use the exceptions feature.
// #  define _STLP_DONT_USE_EXCEPTIONS 1

// Uncomment this if your compiler does not support exception specifications
// #  define _STLP_NO_EXCEPTION_SPEC

// Define this if your compiler requires return statement after throw()
// # define _STLP_THROW_RETURN_BUG 1

// Define this if your compiler do not support return of void
// # define _STLP_DONT_RETURN_VOID 1

// Header <new> that comes with the compiler
// does not define bad_alloc exception
// #  define _STLP_NO_BAD_ALLOC  1

// Define this if your compiler do not throw bad_alloc from the new operator
// #  define _STLP_NEW_DONT_THROW_BAD_ALLOC  1

// Define this if your compiler has no rtti support or if it has been disabled
// #  define _STLP_NO_RTTI 1

// Define this if there is no native type_info definition
// #  define _STLP_NO_TYPEINFO 1

// Uncomment if member template methods are not available
// #  define _STLP_NO_MEMBER_TEMPLATES   1

// Uncomment if member template classes are not available
// #  define _STLP_NO_MEMBER_TEMPLATE_CLASSES   1

// Uncomment if your compiler do not support the std::allocator rebind technique
// This is a special case of bad member template classes support, it is automatically
// defined if _STLP_NO_MEMBER_TEMPLATE_CLASSES is defined.
// # define _STLP_DONT_SUPPORT_REBIND_MEMBER_TEMPLATE 1

// Uncomment if no "template" keyword should be used with member template classes
// #  define _STLP_NO_MEMBER_TEMPLATE_KEYWORD   1

// Compiler does not accept friend declaration qualified with namespace name.
// #  define _STLP_NO_QUALIFIED_FRIENDS 1

// Uncomment if partial specialization is not available
// #  define _STLP_NO_CLASS_PARTIAL_SPECIALIZATION 1

// Define if class being partially specialized require full name (template parameters)
// of itself for method declarations
// #  define _STLP_PARTIAL_SPEC_NEEDS_TEMPLATE_ARGS

// Compiler has problem with qualified specializations (cont int, volatile int...)
// #  define _STLP_QUALIFIED_SPECIALIZATION_BUG

// Compiler has problems specializing members of partially
// specialized class
// #  define _STLP_MEMBER_SPECIALIZATION_BUG

// Uncomment if partial order of template functions is not available
// #  define _STLP_NO_FUNCTION_TMPL_PARTIAL_ORDER 1

// Uncomment if specialization of methods is not allowed
// #  define _STLP_NO_METHOD_SPECIALIZATION  1

// Uncomment if full  specialization does not use partial spec. syntax : template <> struct ....
// #  define _STLP_NO_PARTIAL_SPECIALIZATION_SYNTAX  1

// Uncomment if compiler does not support explicit template arguments for functions
// # define _STLP_NO_EXPLICIT_FUNCTION_TMPL_ARGS

// Uncomment this if your compiler can't inline while(), for()
// #  define _STLP_LOOP_INLINE_PROBLEMS 1

// Define if the compiler fails to match a template function argument of base
// #  define _STLP_BASE_MATCH_BUG          1

// Define if the compiler fails to match a template function argument of base
// (non-template)
//#  define  _STLP_NONTEMPL_BASE_MATCH_BUG 1

// Define if the compiler rejects outline method definition
// explicitly taking nested types/typedefs
// #  define _STLP_NESTED_TYPE_PARAM_BUG   1

// Compiler requires typename keyword on outline method definition
// explicitly taking nested types/typedefs
// #define  _STLP_TYPENAME_ON_RETURN_TYPE

// Define if the baseclass typedefs not visible from outside
// #  define _STLP_BASE_TYPEDEF_OUTSIDE_BUG 1

// if your compiler have serious problems with typedefs, try this one
// #  define _STLP_BASE_TYPEDEF_BUG          1

// Uncomment if getting errors compiling mem_fun* adaptors
// #  define _STLP_MEMBER_POINTER_PARAM_BUG 1

// Uncomment if the compiler can't handle a constant-initializer in the
// declaration of a static const data member of integer type.
// (See section 9.4.2, paragraph 4, of the C++ standard.)
// # define _STLP_STATIC_CONST_INIT_BUG

// Uncomment to indicate that the compiler do not like static constant
// definition.
// Meaningfull only if  _STLP_STATIC_CONST_INIT_BUG is not defined.
// # define _STLP_NO_STATIC_CONST_DEFINITION

// Define if default constructor for builtin integer type fails to initialize it to 0
// In expression like new(&char) char():
//# define _STLP_DEF_CONST_PLCT_NEW_BUG 1
// In default function parameter like _M_method(_Tp __x = _Tp())
//# define _STLP_DEF_CONST_DEF_PARAM_BUG 1

// Defined if constructor
// required to explicitly call member's default constructors for const objects
// #  define _STLP_CONST_CONSTRUCTOR_BUG    1

// Defined if the compiler has trouble calling POD-types constructors/destructors
// #  define _STLP_TRIVIAL_CONSTRUCTOR_BUG    1
// #  define _STLP_TRIVIAL_DESTRUCTOR_BUG    1

// Define if having problems specializing maps/sets with
// key type being const
// #  define _STLP_MULTI_CONST_TEMPLATE_ARG_BUG

// Uncomment this to disable -> operators on all iterators
// #  define   _STLP_NO_ARROW_OPERATOR 1

// Uncomment this to disble at() member functions for containers
// #  define   _STLP_NO_AT_MEMBER_FUNCTION 1

// Define this if compiler lacks <exception> header
// #  define _STLP_NO_EXCEPTION_HEADER 1

// Uncomment this if your C library has lrand48() function
// #  define _STLP_RAND48 1

// uncomment if new-style headers <new> is available
// #  define _STLP_HAS_NEW_NEW_HEADER 1

// uncomment this if <iostream> and other STD headers put their stuff in ::namespace,
// not std::
// #  define _STLP_VENDOR_GLOBAL_STD

// uncomment this if <cstdio> and the like put stuff in ::namespace,
// not std::
// #  define _STLP_VENDOR_GLOBAL_CSTD

// uncomment this if your compiler define all the C math functions C++ additional
// overloads in ::namespace and not only in std::.
// #  define _STLP_HAS_GLOBAL_C_MATH_FUNCTIONS 1

// Edit relative path below (or put full path) to get native
// compiler headers included. Default is "../include".
// C headers may reside in different directory, so separate macro is provided.
// Hint : never install STLport in the directory that ends with "include"
// # define _STLP_NATIVE_INCLUDE_PATH ../include
// # define _STLP_NATIVE_C_INCLUDE_PATH ../include
// # define _STLP_NATIVE_CPP_C_INCLUDE_PATH ../include

// This macro constructs header path from directory and name.
// You may change it if your compiler does not understand "/".
// #  define _STLP_MAKE_HEADER(path, header) <path/header>

// This macro constructs native include header path from include path and name.
// You may have do define it if experimenting problems with preprocessor
// # define _STLP_NATIVE_HEADER(header) _STLP_MAKE_HEADER(_STLP_NATIVE_INCLUDE_PATH,header)

// Same for C headers
// #define _STLP_NATIVE_C_HEADER(header)

//==========================================================



/* ========================================================= */

/* some fixes to configuration. This also includes modifications
 * of STLport switches depending on compiler flags,
 * or settings applicable to a group of compilers, such as
 * to all who use EDG front-end.
 */
/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

/*
 * STLport configuration file
 * It is internal STLport header - DO NOT include it directly
 * Purpose of this file : to define STLport settings that depend on
 * compiler flags or can be otherwise missed
 *
 */


/* If, by any chance, C compiler gets there, try to help it to pass smoothly */


/* Modena C++ library  */

/* common switches for EDG front-end */
/* __EDG_SWITCHES do not seem to be an official EDG macro.
 * We keep it for historical reason. */

/* __EDG_VERSION__ is an official EDG macro, compilers based
 * on EDG have to define it. */















/* ==========================================================
 * final workaround tuning based on given flags
 * ========================================================== */


/* assume it as the default, turn it off later if NO_NAMESPACES selected */


/* Operating system recognition (basic) */


/* Native headers access macros */

/*  shared library tune-up */


/* Use own namespace always if possible and not explicitly instructed otherwise */






/* disable new-style headers if requested */



/* SUNpro 4.2 inline string literal bug */


/* Some compiler support 0 size array so we use negative size array to generate
 * a compilation time error.
 */

/* apple mpw exception handling bug */


/* default parameters as template types derived from arguments ( not always supported ) */


/* default parameters as complete types */

/* SGI compatibility */



/* debug mode tool */

/* pointer specialization tool */


/* this always mean the C library is in global namespace */

/* Depending of whether compiler supports namespaces,
 * tune the parameters for vendor-supplied libraries.
 * This section is guarded by _STLP_HAS_NO_NAMESPACES, not by _STLP_USE_NAMESPACES,
 * since it depends only on the native features, not on user's preference whether
 * to use namespace for STLport or not.
 */
/* Import some vendor's headers into corresponding STLport ones if they might be needed
 * (if we wrap native iostreams and use namepace other than std::) */

/* if using stlport:: namespace or if C library stuff is not in vendor's std::,
 * try importing 'em.
 * MSVC has ambiguity problem when we try to import C-style std:: stuff back into global namespace */



namespace std { }
namespace __std_alias = std;

/* assume std:: namespace for C++ std library if not being told otherwise */

/* tune things that come from C library */
/* exception, typeinfo, new - always come from the vendor */




/* decide whether or not we use separate namespace for rel ops */
/* Use std::rel_ops namespace */



/* Official STLport namespace when std is not redefined.
 * Here we don't use a macro because we do not need it and because
 * stlport is used as file name by boost and folder name under beos:
 */
namespace stlport = std;

/* Backward compatibility:
 */
namespace _STL = std;





/* advanced keywords usage */
















/* When the compiler do not correctly initialized the basic types value in default parameters we prefer
 * to avoid them to be able to correct this bug.
 */



















/*
 * Here we check _STLP_NO_EXCEPTIONS which means that the compiler has no
 * exception support but not the _STLP_USE_EXCEPTIONS which simply means
 * that the user do not want to use them.
 */

/* STLport function not returning are functions that throw so we translate
 * the noreturn functions in throwing functions taking also into account
 * exception support activation.
 */


/* uninitialized value filler */
/* This value is designed to cause problems if an error occurs */

/* shared library tune-up */

/* a keyword used to instantiate export template */














/* We only need to expose details of streams implementation
   if we use non-standard i/o or are building STLport*/

/* We only need to expose details of global implementation if we are building STLport
   or have not instantiated everything in the lib */



/* Activation of the partial template workaround:
 */



/* Some really useful macro */



/* some cleanup */


/* If the platform provides any specific prolog actions,
 * like #pragmas, do include platform-specific prolog file */

/* Get all debug things, potentially only empty macros if none of
 * the debug features available in user config file is activated. */
 /* Thanks to _STLP_OUTERMOST_HEADER_ID we hide _debug.h when C standard
  * headers are included as some platforms (Win32) include C standard headers
  * in an 'extern "C"' scope which do not accept the templates exposed
  * in _debug.h. */
/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */




// this section is for _STLP_DEBUG only




// Local Variables:
// mode:C++
// End:

// remove() conflicts, <cstdio> should always go first
/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */



/*****************************************************************************/
/* STDIO.H v16.12.0                                                          */
/*                                                                           */
/* Copyright (c) 1993-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/








/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

/* NOTE: This is an internal header file, included by other STL headers.
 *   You should not attempt to use it directly.
 */


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

/* NOTE: This is an internal header file, included by other STL headers.
 *   You should not attempt to use it directly.
 */


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */



/*****************************************************************************/
/* stddef.h   v16.12.0                                                       */
/*                                                                           */
/* Copyright (c) 1993-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/



#pragma diag_push
#pragma CHECK_MISRA("-19.15") /* code outside guard; see below comment */

/*-----------------------------------------------------------------------*/
/* Define _win_t, for compiling GCC libraries with the TI compiler.      */
/* GCC's library (newlib) expects wint_t to be defined here, in stddef.h,*/
/* which is arguably incorrect, but we go along for compatibility.       */
/* This is outside the _STDDEF guard in case this file has already       */
/* been included without __need_wint_t.                                  */
/*-----------------------------------------------------------------------*/

#pragma diag_pop



/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


/*****************************************************************************/
/* string.h   v16.12.0                                                       */
/*                                                                           */
/* Copyright (c) 1993-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


#pragma diag_push

/* using declarations must occur outside header guard to support including both
   C and C++-wrapped version of header; see _CPP_STYLE_HEADER check */
/* this code is for C++ mode only and thus also not relevant for MISRA */
#pragma CHECK_MISRA("-19.15")


#pragma diag_pop



/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */



/*****************************************************************************/
/* limits.h   v16.12.0                                                       */
/*                                                                           */
/* Copyright (c) 1993-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


#pragma diag_push
#pragma CHECK_MISRA("-20.1") /* standard headers must define standard names */










#pragma diag_pop


#pragma diag_push

/* using declarations must occur outside header guard to support including both
   C and C++-wrapped version of header; see _CPP_STYLE_HEADER check */
/* this code is for C++ mode only and thus also not relevant for MISRA */
#pragma CHECK_MISRA("-19.15")


#pragma diag_pop



// Local Variables:
// mode:C++
// End:

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


/*****************************************************************************/
/* stdlib.h   v16.12.0                                                       */
/*                                                                           */
/* Copyright (c) 1993-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


#pragma diag_push

/* using declarations must occur outside header guard to support including both
   C and C++-wrapped version of header; see _CPP_STYLE_HEADER check */
/* this code is for C++ mode only and thus also not relevant for MISRA */
#pragma CHECK_MISRA("-19.15")


#pragma diag_pop

#pragma diag_push

/* C2000-specific additions to header implemented with #include */
#pragma CHECK_MISRA("-19.1")
#pragma CHECK_MISRA("-19.15")


#pragma diag_pop


/* on evc3/evc4 including stdlib.h also defines setjmp macro */





//HP-UX native lib has abs() and div() functions in global namespace

//MSVC starting with .Net 2003 already define all math functions in global namespace:
namespace std {
inline long abs(long __x) { return std::labs(__x); }
}

/** VC since version 8 has this, the platform SDK and CE SDKs hanging behind. */
namespace std {
inline std::ldiv_t div(long __x, long __y) { return std::ldiv(__x, __y); }
}



namespace std {
inline long long  abs(long long __x) { return std::llabs(__x); }
inline std::lldiv_t div(long long __x, long long __y) { return std::lldiv(__x, __y); }
}

/* C++ Standard is unclear about several call to 'using ::func' if new overloads
 * of ::func appears between 2 successive 'using' calls. To avoid this potential
 * problem we provide all abs overload before the 'using' call.
 * Beware: This header inclusion has to be after all abs overload of this file.
 *         The first 'using ::abs' call is going to be in the other header.
 */
/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


/* gcc do not like when a using directive appear after a function
 * declaration. cmath have abs overloads and cstdlib a using directive
 * so cstdlib has to be included first.
 */

/*
 * Copyright (c) 2015-2015 Texas Instruments Incorporated
 *
 * ====================================================
 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
 *
 * Developed at SunPro, a Sun Microsystems, Inc. business.
 * Permission to use, copy, modify, and distribute this
 * software is freely granted, provided that this notice
 * is preserved.
 * ====================================================
 */

/*
 * from: @(#)fdlibm.h 5.1 93/09/24
 * $FreeBSD$
 */


#pragma diag_push

/* using declarations must occur outside header guard to support including both
   C and C++-wrapped version of header; see _CPP_STYLE_HEADER check */
/* this code is for C++ mode only and thus also not relevant for MISRA */
#pragma CHECK_MISRA("-19.15")


#pragma diag_pop






/** macros to define math functions
These macros (having an X somewhere in the name) forward to the C library's
double functions but cast the arguments and return values to the given type. */



/** rough characterization of compiler and native C library
For the compiler, it can either support long double or not. If it doesn't, the
macro _STLP_NO_LONG_DOUBLE is not defined and we don't define any long double
overloads.
For the native C library the question is whether it has variants with an 'f'
suffix (for float as opposed to double) or an 'l' suffix (for long double). If
the float variants are missing, _STLP_NO_VENDOR_MATH_F is defined, when the
long double variants are missing, _STLP_NO_VENDOR_MATH_L is defined. Of course
the latter doesn't make sense anyway when the compiler already has no long
double support.

Those two traits determine a) which overloads get defined and b) how they are
defined.

Meaning of suffixes:
""   : function returning and taking a float_type
"2"  : function returning a float_type and taking to float_types
"2P" : function returning a float_type and taking a float_type and a float_type*
"2PI": function returning a float_type and taking a float_type and an int*
"2I" : function returning a float_type and taking a float_Type and an int
*/

   // long double support and both e.g. sinl(long double) and sinf(float)
   // This is the default for a correct and complete native library.




/* MSVC native lib starting with .Net 2003 has already all math functions
 * in global namespace.
 * HP-UX native lib has math functions in the global namespace.
 */
  /* We have these already defined in our library so we don't
   * need the definitions below. */
/*****************************************************************************/
/*  CPP_INLINE_MATH.H v16.12.0                                               */
/*                                                                           */
/* Copyright (c) 1995-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


namespace std
{
/*****************************************************************************/
/* These two inline functions for double, the other 23 should be default math*/
/* function defined in ANSI                                                  */
/*****************************************************************************/
inline double abs(double x)	// OVERLOADS
	{	// return absolute value
	return (fabs(x));
	}

inline double pow(double x, int y)
	{	// raise to integer power
	     return (pow(x, (double)y));
	}

/*****************************************************************************/
/* 24 float math functions defined by C++ ISO/IEC 14882 26.5                 */
/*****************************************************************************/
inline float acos(float x)
	{	// return arccosine
	return acosf(x);
	}

inline float asin(float x)
	{	// return arcsine
	return asinf(x);
	}

inline float atan(float x)
	{	// return arctangent
	return atanf(x);
	}

inline float atan2(float x, float y)
	{	// return arctangent
	return atan2f(x, y);
	}

inline float ceil(float x)
	{	// return ceiling
	return ceilf(x);
	}

inline float cos(float x)
	{	// return cosine
	return cosf(x);
	}

inline float cosh(float x)
	{	// return hyperbolic cosine
	return coshf(x);
	}

inline float exp(float x)
	{	// return exponential
	return expf(x);
	}

inline float fabs(float x)
	{	// return absolute value
	return fabsf(x);
	}

inline float floor(float x)
	{	// return floor
	return floorf(x);
	}

inline float fmod(float x, float y)
	{	// return modulus
	return fmodf(x, y);
	}

inline float frexp(float x, int *y)
	{	// unpack exponent
	return frexpf(x, y);
	}

inline float ldexp(float x, int y)
	{	// pack exponent
	return ldexpf(x, y);
	}

inline float log(float x)
	{	// return natural logarithm
	return logf(x);
	}

inline float log10(float x)
	{	// return base-10 logarithm
	return log10f(x);
	}

inline float modf(float x, float *y)
	{	// unpack fraction
	return modff(x, y);
	}

inline float pow(float x, float y)
	{	// raise to power
	return powf(x, y);
	}

inline float pow(float x, int y)
	{	// raise to integer power
	return powf(x, y);
	}

inline float sin(float x)
	{	// return sine
	return sinf(x);
	}

inline float sinh(float x)
	{	// return hyperbolic sine
	return sinhf(x);
	}

inline float sqrt(float x)
	{	// return square root
	return sqrtf(x);
	}

inline float tan(float x)
	{	// return tangent
	return tanf(x);
	}

inline float tanh(float x)
	{	// return hyperbolic tangent
	return tanhf(x);
	}

inline float abs(float x)	// OVERLOADS
	{	// return absolute value
	return fabsf(x);
	}

/*****************************************************************************/
/* 24 long double math functions defined by C++ ISO/IEC 14882 26.5           */
/*****************************************************************************/
inline long double acos(long double x)
	{	// return arccosine
	return acosl(x);
	}

inline long double asin(long double x)
	{	// return arcsine
	return asinl(x);
	}

inline long double atan(long double x)
	{	// return arctangent
	return atanl(x);
	}

inline long double atan2(long double x, long double y)
	{	// return arctangent
	return atan2l(x, y);
	}

inline long double ceil(long double x)
	{	// return ceiling
	return ceill(x);
	}

inline long double cos(long double x)
	{	// return cosine
	return cosl(x);
	}

inline long double cosh(long double x)
	{	// return hyperbolic cosine
	return coshl(x);
	}

inline long double exp(long double x)
	{	// return exponential
	return expl(x);
	}

inline long double fabs(long double x)
	{	// return absolute value
	return fabsl(x);
	}

inline long double floor(long double x)
	{	// return floor
	return floorl(x);
	}

inline long double fmod(long double x, long double y)
	{	// return modulus
	return fmodl(x, y);
	}

inline long double frexp(long double x, int *y)
	{	// unpack exponent
	return frexpl(x, y);
	}

inline long double ldexp(long double x, int y)
	{	// pack exponent
	return ldexpl(x, y);
	}

inline long double log(long double x)
	{	// return natural logarithm
	return logl(x);
	}

inline long double log10(long double x)
	{	// return base-10 logarithm
	return log10l(x);
	}

inline long double modf(long double x, long double *y)
	{	// unpack fraction
	return modfl(x, y);
	}

inline long double pow(long double x, long double y)
	{	// raise to power
	return powl(x, y);
	}

inline long double pow(long double x, int y)
	{	// raise to integer power
	return powl(x, y);
	}

inline long double sin(long double x)
	{	// return sine
	return sinl(x);
	}

inline long double sinh(long double x)
	{	// return hyperbolic sine
	return sinhl(x);
	}

inline long double sqrt(long double x)
	{	// return square root
	return sqrtl(x);
	}

inline long double tan(long double x)
	{	// return tangent
	return tanl(x);
	}

inline long double tanh(long double x)
	{	// return hyperbolic tangent
	return tanhl(x);
	}

inline long double abs(long double x)	// OVERLOADS
	{	// return absolute value
	return fabsl(x);
	}

} /* namespace std */




/* C++ Standard is unclear about several call to 'using ::func' if new overloads
 * of ::func appears between 2 successive 'using' calls. To avoid this potential
 * problem we provide all abs overload before the 'using' call.
 * Beware: This header inclusion has to be after all abs overload of this file.
 *         The first 'using ::abs' call is going to be in the other header.
 */



// Local Variables:
// mode:C++
// End:



/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


/* NOTE: This is an internal header file, included by other STL headers.
 *   You should not attempt to use it directly.
 */


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


/*
This header file provides a framework for allowing compile time dispatch
based on type attributes. This is useful when writing template code.
For example, when making a copy of an array of an unknown type, it helps
to know if the type has a trivial copy constructor or not, to help decide
if a memcpy can be used.

The class template __type_traits provides a series of typedefs each of
which is either __true_type or __false_type. The argument to
__type_traits can be any type. The typedefs within this template will
attain their correct values by one of these means:
    1. The general instantiation contain conservative values which work
       for all types.
    2. Specializations may be declared to make distinctions between types.
    3. Some compilers (such as the Silicon Graphics N32 and N64 compilers)
       will automatically provide the appropriate specializations for all
       types.

EXAMPLE:

//Copy an array of elements which have non-trivial copy constructors
template <class T> void copy(T* source, T* destination, int n, __false_type);
//Copy an array of elements which have trivial copy constructors. Use memcpy.
template <class T> void copy(T* source, T* destination, int n, __true_type);

//Copy an array of any type by using the most efficient copy mechanism
template <class T> inline void copy(T* source,T* destination,int n) {
   copy(source, destination, n,
        typename __type_traits<T>::has_trivial_copy_constructor());
}
*/


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 2003
 * Francois Dumont
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */



namespace std {

struct __true_type {};
struct __false_type {};

namespace priv {
using ::std::__true_type;
using ::std::__false_type;
}

//bool to type
template <int _Is>
struct __bool2type
{ typedef __true_type _Ret; };

template< >
struct __bool2type<1> { typedef __true_type _Ret; };

template< >
struct __bool2type<0> { typedef __false_type _Ret; };

//type to bool
template <class __bool_type>
struct __type2bool { enum __attribute__((__packed__)) {_Ret = 1}; };

template< >
struct __type2bool<__true_type> { enum __attribute__((__packed__)) {_Ret = 1}; };

template< >
struct __type2bool<__false_type> { enum __attribute__((__packed__)) {_Ret = 0}; };

//Negation
template <class _BoolType>
struct _Not { typedef __false_type _Ret; };

template< >
struct _Not<__false_type> { typedef __true_type _Ret; };

// logical and of 2 predicated
template <class _P1, class _P2>
struct _Land2 { typedef __false_type _Ret; };

template< >
struct _Land2<__true_type, __true_type> { typedef __true_type _Ret; };

// logical and of 3 predicated
template <class _P1, class _P2, class _P3>
struct _Land3 { typedef __false_type _Ret; };

template< >
struct _Land3<__true_type, __true_type, __true_type> { typedef __true_type _Ret; };

//logical or of 2 predicated
template <class _P1, class _P2>
struct _Lor2 { typedef __true_type _Ret; };

template< >
struct _Lor2<__false_type, __false_type> { typedef __false_type _Ret; };

// logical or of 3 predicated
template <class _P1, class _P2, class _P3>
struct _Lor3 { typedef __true_type _Ret; };

template< >
struct _Lor3<__false_type, __false_type, __false_type> { typedef __false_type _Ret; };

////////////////////////////////////////////////////////////////////////////////
// class template __select
// Selects one of two types based upon a boolean constant
// Invocation: __select<_Cond, T, U>::Result
// where:
// flag is a compile-time boolean constant
// T and U are types
// Result evaluates to T if flag is true, and to U otherwise.
////////////////////////////////////////////////////////////////////////////////
// BEWARE: If the compiler do not support partial template specialization or nested template
//classes the default behavior of the __select is to consider the condition as false and so return
//the second template type!!


template <bool _Cond, class _Tp1, class _Tp2>
struct __select { typedef _Tp1 _Ret; };

template <class _Tp1, class _Tp2>
struct __select<false, _Tp1, _Tp2> { typedef _Tp2 _Ret; };


/* Rather than introducing a new macro for the following constrution we use
 * an existing one (_STLP_DONT_SIMULATE_PARTIAL_SPEC_FOR_TYPE_TRAITS) that
 * is used for a similar feature.
 */
// Helper struct that will forbid volatile qualified types:
struct _NoVolatilePointerShim { _NoVolatilePointerShim(const void*); };
template <class _Tp>
char  _IsCopyableFun(bool, _NoVolatilePointerShim, _Tp const*, _Tp*); // no implementation is required
char*  _IsCopyableFun(bool, ...);       // no implementation is required

template <class _Src, class _Dst>
struct _Copyable {
  static _Src* __null_src();
  static _Dst* __null_dst();
  enum __attribute__((__packed__)) { _Ret = (sizeof(_IsCopyableFun(false, __null_src(), __null_src(), __null_dst())) == sizeof(char)) };
  typedef typename __bool2type<_Ret>::_Ret _RetT;
};

/*
 * The following struct will tell you if 2 types are the same and if copying memory
 * from the _Src type to the _Dst type is right considering qualifiers. If _Src and
 * _Dst types are the same unqualified types _Ret will be false if:
 *  - any of the type has the volatile qualifier
 *  - _Dst is const qualified
 */
template <class _Src, class _Dst>
struct _AreCopyable {
  enum __attribute__((__packed__)) { _Same = _Copyable<_Src, _Dst>::_Ret };
  typedef typename _Copyable<_Src, _Dst>::_RetT _Ret;
};

template <class _Tp1, class _Tp2>
struct _AreSameTypes {
  enum __attribute__((__packed__)) { _Same = 0 };
  typedef __false_type _Ret;
};

template <class _Tp>
struct _AreSameTypes<_Tp, _Tp> {
  enum __attribute__((__packed__)) { _Same = 1 };
  typedef __true_type _Ret;
};

template <class _Src, class _Dst>
struct _ConversionHelper {
  static char _Test(bool, _Dst);
  static char* _Test(bool, ...);
  static _Src _MakeSource();
};

template <class _Src, class _Dst>
struct _IsConvertible {
  typedef _ConversionHelper<_Src*, const volatile _Dst*> _H;
  enum __attribute__((__packed__)) { value = (sizeof(char) == sizeof(_H::_Test(false, _H::_MakeSource()))) };
  typedef typename __bool2type<value>::_Ret _Ret;
};


/* This struct is intended to say if a pointer can be convertible to an other
 * taking into account cv qualifications. It shouldn't be instanciated with
 * something else than pointer type as it uses pass by value parameter that
 * results in compilation error when parameter type has a special memory
 * alignment
 */
template <class _Src, class _Dst>
struct _IsCVConvertible {
  typedef _ConversionHelper<_Src, _Dst> _H;
  enum __attribute__((__packed__)) { value = (sizeof(char) == sizeof(_H::_Test(false, _H::_MakeSource()))) };
  typedef typename __bool2type<value>::_Ret _Ret;
};


}



namespace std {


// The following could be written in terms of numeric_limits.
// We're doing it separately to reduce the number of dependencies.

template <class _Tp> struct _IsIntegral
{ typedef __false_type _Ret; };

template< > struct _IsIntegral<bool>
{ typedef __true_type _Ret; };

template< > struct _IsIntegral<char>
{ typedef __true_type _Ret; };

template< > struct _IsIntegral<signed char>
{ typedef __true_type _Ret; };

template< > struct _IsIntegral<unsigned char>
{ typedef __true_type _Ret; };

template< > struct _IsIntegral<wchar_t>
{ typedef __true_type _Ret; };

template< > struct _IsIntegral<short>
{ typedef __true_type _Ret; };

template< > struct _IsIntegral<unsigned short>
{ typedef __true_type _Ret; };

template< > struct _IsIntegral<int>
{ typedef __true_type _Ret; };

template< > struct _IsIntegral<unsigned int>
{ typedef __true_type _Ret; };

template< > struct _IsIntegral<long>
{ typedef __true_type _Ret; };

template< > struct _IsIntegral<unsigned long>
{ typedef __true_type _Ret; };

template< > struct _IsIntegral<long long>
{ typedef __true_type _Ret; };

template< > struct _IsIntegral<unsigned long long>
{ typedef __true_type _Ret; };

template <class _Tp> struct _IsRational
{ typedef __false_type _Ret; };

template< > struct _IsRational<float>
{ typedef __true_type _Ret; };

template< > struct _IsRational<double>
{ typedef __true_type _Ret; };

template< > struct _IsRational<long double>
{ typedef __true_type _Ret; };

// Forward declarations.
template <class _Tp> struct __type_traits;
template <class _IsPOD> struct __type_traits_aux {
   typedef __false_type    has_trivial_default_constructor;
   typedef __false_type    has_trivial_copy_constructor;
   typedef __false_type    has_trivial_assignment_operator;
   typedef __false_type    has_trivial_destructor;
   typedef __false_type    is_POD_type;
};

template< >
struct __type_traits_aux<__false_type> {
   typedef __false_type    has_trivial_default_constructor;
   typedef __false_type    has_trivial_copy_constructor;
   typedef __false_type    has_trivial_assignment_operator;
   typedef __false_type    has_trivial_destructor;
   typedef __false_type    is_POD_type;
};

template< >
struct __type_traits_aux<__true_type> {
  typedef __true_type    has_trivial_default_constructor;
  typedef __true_type    has_trivial_copy_constructor;
  typedef __true_type    has_trivial_assignment_operator;
  typedef __true_type    has_trivial_destructor;
  typedef __true_type    is_POD_type;
};

template <class _Tp>
struct _IsRef {
  typedef __false_type _Ret;
};


template <class _Tp>  struct _IsPtr {
  typedef __false_type _Ret;
};

template <class _Tp>
struct __type_traits {
   typedef __true_type     this_dummy_member_must_be_first;
                   /* Do not remove this member. It informs a compiler which
                      automatically specializes __type_traits that this
                      __type_traits template is special. It just makes sure that
                      things work if an implementation is using a template
                      called __type_traits for something unrelated. */

   /* The following restrictions should be observed for the sake of
      compilers which automatically produce type specific specializations
      of this class:
          - You may reorder the members below if you wish
          - You may remove any of the members below if you wish
          - You must not rename members without making the corresponding
            name change in the compiler
          - Members you add will be treated like regular members unless

            you add the appropriate support in the compiler. */
   typedef __false_type    has_trivial_default_constructor;
   typedef __false_type    has_trivial_copy_constructor;
   typedef __false_type    has_trivial_assignment_operator;
   typedef __false_type    has_trivial_destructor;
   typedef __false_type    is_POD_type;
};

template <class _Tp> struct _IsPtr<_Tp*>
{ typedef __true_type _Ret; };
template <class _Tp> struct _IsRef<_Tp&>
{ typedef __true_type _Ret; };

template <class _Tp> struct __type_traits<_Tp*> : __type_traits_aux<__true_type>
{};


// Provide some specializations.  This is harmless for compilers that
//  have built-in __types_traits support, and essential for compilers
//  that don't.

template< > struct __type_traits< bool > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const bool > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< volatile bool > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const volatile bool > : __type_traits_aux<__true_type> {};
template< > struct __type_traits< char > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const char > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< volatile char > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const volatile char > : __type_traits_aux<__true_type> {};
template< > struct __type_traits< signed char > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const signed char > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< volatile signed char > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const volatile signed char > : __type_traits_aux<__true_type> {};
template< > struct __type_traits< unsigned char > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const unsigned char > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< volatile unsigned char > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const volatile unsigned char > : __type_traits_aux<__true_type> {};
template< > struct __type_traits< wchar_t > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const wchar_t > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< volatile wchar_t > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const volatile wchar_t > : __type_traits_aux<__true_type> {};

template< > struct __type_traits< short > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const short > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< volatile short > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const volatile short > : __type_traits_aux<__true_type> {};
template< > struct __type_traits< unsigned short > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const unsigned short > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< volatile unsigned short > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const volatile unsigned short > : __type_traits_aux<__true_type> {};
template< > struct __type_traits< int > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const int > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< volatile int > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const volatile int > : __type_traits_aux<__true_type> {};
template< > struct __type_traits< unsigned int > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const unsigned int > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< volatile unsigned int > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const volatile unsigned int > : __type_traits_aux<__true_type> {};
template< > struct __type_traits< long > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const long > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< volatile long > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const volatile long > : __type_traits_aux<__true_type> {};
template< > struct __type_traits< unsigned long > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const unsigned long > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< volatile unsigned long > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const volatile unsigned long > : __type_traits_aux<__true_type> {};

template< > struct __type_traits< long long > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const long long > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< volatile long long > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const volatile long long > : __type_traits_aux<__true_type> {};
template< > struct __type_traits< unsigned long long > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const unsigned long long > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< volatile unsigned long long > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const volatile unsigned long long > : __type_traits_aux<__true_type> {};

template< > struct __type_traits< float > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const float > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< volatile float > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const volatile float > : __type_traits_aux<__true_type> {};
template< > struct __type_traits< double > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const double > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< volatile double > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const volatile double > : __type_traits_aux<__true_type> {};

template< > struct __type_traits< long double > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const long double > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< volatile long double > : __type_traits_aux<__true_type> {}; template< > struct __type_traits< const volatile long double > : __type_traits_aux<__true_type> {};

template <class _ArePtrs, class _Src, class _Dst>
struct _IsCVConvertibleIf
{ typedef typename _IsCVConvertible<_Src, _Dst>::_Ret _Ret; };

template <class _Src, class _Dst>
struct _IsCVConvertibleIf<__false_type, _Src, _Dst>
{ typedef __false_type _Ret; };

template <class _Src, class _Dst>
struct _TrivialNativeTypeCopy {
  typedef typename _IsPtr<_Src>::_Ret _Ptr1;
  typedef typename _IsPtr<_Dst>::_Ret _Ptr2;
  typedef typename _Land2<_Ptr1, _Ptr2>::_Ret _BothPtrs;
  typedef typename _IsCVConvertibleIf<_BothPtrs, _Src, _Dst>::_Ret _Convertible;
  typedef typename _Land2<_BothPtrs, _Convertible>::_Ret _Trivial1;

  typedef typename __bool2type<(sizeof(_Src) == sizeof(_Dst))>::_Ret _SameSize;

  typedef typename _IsIntegral<_Src>::_Ret _Int1;
  typedef typename _IsIntegral<_Dst>::_Ret _Int2;
  typedef typename _Land2<_Int1, _Int2>::_Ret _BothInts;

  typedef typename _IsRational<_Src>::_Ret _Rat1;
  typedef typename _IsRational<_Dst>::_Ret _Rat2;
  typedef typename _Land2<_Rat1, _Rat2>::_Ret _BothRats;

  typedef typename _Lor2<_BothInts, _BothRats>::_Ret _BothNatives;
  typedef typename _Land2<_BothNatives, _SameSize>::_Ret _Trivial2;
  typedef typename _Lor2<_Trivial1, _Trivial2>::_Ret _Ret;
};

template <class _Src, class _Dst>
struct _TrivialCopy {
  typedef typename _TrivialNativeTypeCopy<_Src, _Dst>::_Ret _NativeRet;
  typedef typename __type_traits<_Src>::has_trivial_assignment_operator _Tr1;
  typedef typename _AreCopyable<_Src, _Dst>::_Ret _Tr2;
  typedef typename _Land2<_Tr1, _Tr2>::_Ret _UserRet;
  typedef typename _Lor2<_NativeRet, _UserRet>::_Ret _Ret;
  static _Ret _Answer() { return _Ret(); }
};

template <class _Src, class _Dst>
struct _TrivialUCopy {
  typedef typename _TrivialNativeTypeCopy<_Src, _Dst>::_Ret _NativeRet;
  typedef typename __type_traits<_Src>::has_trivial_copy_constructor _Tr1;
  typedef typename _AreCopyable<_Src, _Dst>::_Ret _Tr2;
  typedef typename _Land2<_Tr1, _Tr2>::_Ret _UserRet;
  typedef typename _Lor2<_NativeRet, _UserRet>::_Ret _Ret;
  static _Ret _Answer() { return _Ret(); }
};

template <class _Tp>
struct _DefaultZeroValue {
  typedef typename _IsIntegral<_Tp>::_Ret _Tr1;
  typedef typename _IsRational<_Tp>::_Ret _Tr2;
  typedef typename _IsPtr<_Tp>::_Ret _Tr3;
  typedef typename _Lor3<_Tr1, _Tr2, _Tr3>::_Ret _Ret;
};

template <class _Tp>
struct _TrivialInit {
  typedef typename __type_traits<_Tp>::has_trivial_default_constructor _Tr1;
  typedef typename _DefaultZeroValue<_Tp>::_Ret _Tr2;
  typedef typename _Not<_Tr2>::_Ret _Tr3;
  typedef typename _Land2<_Tr1, _Tr3>::_Ret _Ret;
  static _Ret _Answer() { return _Ret(); }
};


template <class _Tp>
struct _IsPtrType {
  typedef typename _IsPtr<_Tp>::_Ret _Type;
  static _Type _Ret() { return _Type(); }
};

template <class _Tp>
struct _IsRefType {
  typedef typename _IsRef<_Tp>::_Ret _Type;
  static _Type _Ret() { return _Type();}
};

template <class _Tp>
struct __call_traits {
  typedef const _Tp& const_param_type;
  typedef _Tp& param_type;
};

template <class _Tp>
struct __call_traits<_Tp&> {
  typedef _Tp& param_type;
  typedef const _Tp& const_param_type;
};
template <class _Tp>
struct __call_traits<const _Tp&> {
  typedef _Tp& param_type;
  typedef const _Tp& const_param_type;
};

template <class _Tp1, class _Tp2>
struct _BothPtrType {
  typedef typename _IsPtr<_Tp1>::_Ret _IsPtr1;
  typedef typename _IsPtr<_Tp2>::_Ret _IsPtr2;

  typedef typename _Land2<_IsPtr1, _IsPtr2>::_Ret _Ret;
  static _Ret _Answer() { return _Ret(); }
};

template <class _Tp1, class _Tp2, class _IsRef1, class _IsRef2>
struct _OKToSwap {
  typedef typename _AreSameTypes<_Tp1, _Tp2>::_Ret _Same;
  typedef typename _Land3<_Same, _IsRef1, _IsRef2>::_Ret _Type;
  static _Type _Answer() { return _Type(); }
};

template <class _Tp1, class _Tp2, class _IsRef1, class _IsRef2>
inline _OKToSwap<_Tp1, _Tp2, _IsRef1, _IsRef2>
_IsOKToSwap(_Tp1*, _Tp2*, const _IsRef1&, const _IsRef2&)
{ return _OKToSwap<_Tp1, _Tp2, _IsRef1, _IsRef2>(); }

template <class _Src, class _Dst>
inline _TrivialCopy<_Src, _Dst> _UseTrivialCopy(_Src*, _Dst*)
{ return _TrivialCopy<_Src, _Dst>(); }

template <class _Src, class _Dst>
inline _TrivialUCopy<_Src, _Dst> _UseTrivialUCopy(_Src*, _Dst*)
{ return _TrivialUCopy<_Src, _Dst>(); }

struct _NegativeAnswer {
  typedef __false_type _Ret;
  static _Ret _Answer() { return _Ret(); }
};

template <class _Src, class _Dst>
inline _NegativeAnswer _UseTrivialCopy(_Src*, const _Dst*)
{ return _NegativeAnswer(); }

template <class _Src, class _Dst>
inline _NegativeAnswer _UseTrivialCopy(_Src*, volatile _Dst*)
{ return _NegativeAnswer(); }

template <class _Src, class _Dst>
inline _NegativeAnswer _UseTrivialCopy(_Src*, const volatile _Dst*)
{ return _NegativeAnswer(); }

template <class _Src, class _Dst>
inline _NegativeAnswer _UseTrivialUCopy(_Src*, const _Dst*)
{ return _NegativeAnswer(); }

template <class _Src, class _Dst>
inline _NegativeAnswer _UseTrivialUCopy(_Src*, volatile _Dst*)
{ return _NegativeAnswer(); }

template <class _Src, class _Dst>
inline _NegativeAnswer _UseTrivialUCopy(_Src*, const volatile _Dst*)
{ return _NegativeAnswer(); }

template <class _Tp>
inline _TrivialInit<_Tp> _UseTrivialInit(_Tp*)
{ return _TrivialInit<_Tp>(); }

template <class _Tp>
struct _IsPOD {
  typedef typename __type_traits<_Tp>::is_POD_type _Type;
  static _Type _Answer() { return _Type(); }
};

template <class _Tp>
inline _IsPOD<_Tp> _Is_POD(_Tp*)
{ return _IsPOD<_Tp>(); }

template <class _Tp>
struct _DefaultZeroValueQuestion {
  typedef typename _DefaultZeroValue<_Tp>::_Ret _Ret;
  static _Ret _Answer() { return _Ret(); }
};

template <class _Tp>
inline _DefaultZeroValueQuestion<_Tp> _HasDefaultZeroValue(_Tp*)
{ return _DefaultZeroValueQuestion<_Tp>(); }

/*
 * Base class used:
 * - to simulate partial template specialization
 * - to simulate partial function ordering
 * - to recognize STLport class from user specialized one
 */
template <class _Tp>
struct __stlport_class
{ typedef _Tp _Type; };

template <class _Tp>
struct _IsSTLportClass {
  typedef typename _IsConvertible<_Tp, __stlport_class<_Tp> >::_Ret _Ret;
};


template <class _Tp>
class _TpWithState : private _Tp {
  _TpWithState();
  int _state;
};

/* This is an internal helper struct used to guess if we are working
 * on a stateless class. It can only be instanciated with a class type. */
template <class _Tp>
struct _IsStateless {
  enum __attribute__((__packed__)) { _Is = sizeof(_TpWithState<_Tp>) == sizeof(int) };
  typedef typename __bool2type<_Is>::_Ret _Ret;
};

}



// Local Variables:
// mode:C++
// End:

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 2003
 * Francois Dumont
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */



namespace std {

/*************************************************************
 * Move constructor framework
 *************************************************************/

/*************************************************************
 *Partial move:
 *The source HAS to be a valid instance after the move!
 *************************************************************/
template <class _Tp>
class __move_source {
public:
  explicit __move_source (_Tp &_src) : _M_data(_src)
  {}

  _Tp& get() const
  { return _M_data; }
private:
  _Tp &_M_data;

  //We explicitely forbid assignment to avoid warning:
  typedef __move_source<_Tp> _Self;
  _Self& operator = (_Self const&);
};

//Class used to signal move constructor support, implementation and type.
template <class _Tp>
struct __move_traits {
  /*
   * implemented tells if a the special move constructor has to be called or the classic
   * copy constructor is just fine. Most of the time the copy constructor is fine only
   * if the following info is true.
   */
  typedef __false_type implemented;
  /*
   * complete tells if the move is complete or partial, that is to say, does the source
   * needs to be destroyed once it has been moved.
   */
  typedef typename __type_traits<_Tp>::has_trivial_destructor complete;
};

namespace priv {

/*
 * This struct should never be used if the user has not explicitely stipulated
 * that its class support the full move concept. To check that the return type
 * in such a case will be __invalid_source<_Tp> to generate a compile error
 * revealing the configuration problem.
 */
template <class _Tp>
struct _MoveSourceTraits {
  typedef typename __move_traits<_Tp>::implemented _MvImpRet;
  enum __attribute__((__packed__)) {_MvImp = __type2bool<_MvImpRet>::_Ret};
  typedef typename __select<_MvImp,
                            __move_source<_Tp>,
                            _Tp const&>::_Ret _Type;
};

//The helper function
template <class _Tp>
inline typename _MoveSourceTraits<_Tp>::_Type
_AsMoveSource (_Tp &src) {
  typedef typename _MoveSourceTraits<_Tp>::_Type _SrcType;
  return _SrcType(src);
}

//Helper structs used for many class.
template <class _Tp>
struct __move_traits_aux {
  typedef typename __move_traits<_Tp>::implemented implemented;
  typedef typename __move_traits<_Tp>::complete complete;
};

template <class _Tp1, class _Tp2>
struct __move_traits_aux2 {
  typedef __move_traits<_Tp1> _MoveTraits1;
  typedef __move_traits<_Tp2> _MoveTraits2;

  typedef typename _Lor2<typename _MoveTraits1::implemented,
                         typename _MoveTraits2::implemented>::_Ret implemented;
  typedef typename _Land2<typename _MoveTraits1::complete,
                          typename _MoveTraits2::complete>::_Ret complete;
};

/*
 * Most of the time a class implement a move constructor but its use depends
 * on a third party, this is what the following struct are for.
 */
template <class _Tp>
struct __move_traits_help {
  typedef __true_type implemented;
  typedef typename __move_traits<_Tp>::complete complete;
};

template <class _Tp1, class _Tp2>
struct __move_traits_help1 {
  typedef __move_traits<_Tp1> _MoveTraits1;
  typedef __move_traits<_Tp2> _MoveTraits2;

  typedef typename _Lor2<typename _MoveTraits1::implemented,
                         typename _MoveTraits2::implemented>::_Ret implemented;
  typedef typename _Land2<typename _MoveTraits1::complete,
                          typename _MoveTraits2::complete>::_Ret complete;
};

template <class _Tp1, class _Tp2>
struct __move_traits_help2 {
  typedef __move_traits<_Tp1> _MoveTraits1;
  typedef __move_traits<_Tp2> _MoveTraits2;

  typedef __true_type implemented;
  typedef typename _Land2<typename _MoveTraits1::complete,
                          typename _MoveTraits2::complete>::_Ret complete;
};

}

}


namespace std {

template <class _T1, class _T2>
struct pair {
  typedef _T1 first_type;
  typedef _T2 second_type;

  _T1 first;
  _T2 second;
  pair() : first(_T1()), second(_T2()) {}
  pair(const _T1& __a, const _T2& __b) : first(__a), second(__b) {}

  template <class _U1, class _U2>
  pair(const pair<_U1, _U2>& __p) : first(__p.first), second(__p.second) {}

  pair(const pair<_T1,_T2>& __o) : first(__o.first), second(__o.second) {}

  pair(__move_source<pair<_T1, _T2> > src) : first(::std::priv:: _AsMoveSource(src.get().first)),
                                             second(::std::priv:: _AsMoveSource(src.get().second))
  {}

  
};

template <class _T1, class _T2>
inline bool  operator==(const pair<_T1, _T2>& __x, const pair<_T1, _T2>& __y)
{ return __x.first == __y.first && __x.second == __y.second; }

template <class _T1, class _T2>
inline bool  operator<(const pair<_T1, _T2>& __x, const pair<_T1, _T2>& __y) {
  return __x.first < __y.first ||
         (!(__y.first < __x.first) && __x.second < __y.second);
}

template <class _T1, class _T2>
inline bool  operator!=(const pair<_T1, _T2>& __x, const pair<_T1, _T2>& __y)
{ return !(__x == __y); }

template <class _T1, class _T2>
inline bool  operator>(const pair<_T1, _T2>& __x, const pair<_T1, _T2>& __y)
{ return __y < __x; }

template <class _T1, class _T2>
inline bool  operator<=(const pair<_T1, _T2>& __x, const pair<_T1, _T2>& __y)
{ return !(__y < __x); }

template <class _T1, class _T2>
inline bool  operator>=(const pair<_T1, _T2>& __x, const pair<_T1, _T2>& __y)
{ return !(__x < __y); }

template <class _T1, class _T2, int _Sz>
inline pair<_T1, _T2 const*> make_pair(_T1 const& __x,
                                       _T2 const (&__y)[_Sz])
{ return pair<_T1, _T2 const*>(__x, static_cast<_T2 const*>(__y)); }

template <class _T1, class _T2, int _Sz>
inline pair<_T1 const*, _T2> make_pair(_T1 const (&__x)[_Sz],
                                       _T2 const& __y)
{ return pair<_T1 const*, _T2>(static_cast<_T1 const*>(__x), __y); }

template <class _T1, class _T2, int _Sz1, int _Sz2>
inline pair<_T1 const*, _T2 const*> make_pair(_T1 const (&__x)[_Sz1],
                                              _T2 const (&__y)[_Sz2]) {
  return pair<_T1 const*, _T2 const*>(static_cast<_T1 const*>(__x),
                                      static_cast<_T2 const*>(__y));
}

template <class _T1, class _T2>
inline pair<_T1, _T2>  make_pair(_T1 __x, _T2 __y)
{ return pair<_T1, _T2>(__x, __y); }

}

namespace std { namespace rel_ops {

template <class _Tp>
inline bool  operator!=(const _Tp& __x, const _Tp& __y)
{ return !(__x == __y); }

template <class _Tp>
inline bool  operator>(const _Tp& __x, const _Tp& __y)
{ return __y < __x; }

template <class _Tp>
inline bool  operator<=(const _Tp& __x, const _Tp& __y)
{ return !(__y < __x); }

template <class _Tp>
inline bool   operator>=(const _Tp& __x, const _Tp& __y)
{ return !(__x < __y); }

} }

namespace std {

template <class _T1, class _T2>
struct __type_traits<pair<_T1, _T2> > {
  typedef __type_traits<_T1> _T1Traits;
  typedef __type_traits<_T2> _T2Traits;
  typedef typename _Land2<typename _T1Traits::has_trivial_default_constructor,
                          typename _T2Traits::has_trivial_default_constructor>::_Ret has_trivial_default_constructor;
  typedef typename _Land2<typename _T1Traits::has_trivial_copy_constructor,
                          typename _T2Traits::has_trivial_copy_constructor>::_Ret has_trivial_copy_constructor;
  typedef typename _Land2<typename _T1Traits::has_trivial_assignment_operator,
                          typename _T2Traits::has_trivial_assignment_operator>::_Ret has_trivial_assignment_operator;
  typedef typename _Land2<typename _T1Traits::has_trivial_destructor,
                          typename _T2Traits::has_trivial_destructor>::_Ret has_trivial_destructor;
  typedef __false_type is_POD_type;
};

template <class _T1, class _T2>
struct __move_traits<pair<_T1, _T2> >
  : ::std::priv:: __move_traits_help1<_T1, _T2> {};

}


// Local Variables:
// mode:C++
// End:

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996-1998
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

/* NOTE: This is an internal header file, included by other STL headers.
 *   You should not attempt to use it directly.
 */



//# if defined  (_STLP_IMPORT_VENDOR_CSTD) && ! defined (_STLP_VENDOR_GLOBAL_CSTD)
//_STLP_BEGIN_NAMESPACE
//using namespace _STLP_VENDOR_CSTD;
//_STLP_END_NAMESPACE
//#endif /* _STLP_IMPORT_VENDOR_CSTD */


namespace std {

struct input_iterator_tag {};
struct output_iterator_tag {};
struct forward_iterator_tag : public input_iterator_tag {};
struct bidirectional_iterator_tag : public forward_iterator_tag {};
struct random_access_iterator_tag : public bidirectional_iterator_tag {};

template <class _Category, class _Tp, class _Distance = ptrdiff_t,
          class _Pointer = _Tp*, class _Reference = _Tp& >
struct iterator {
  typedef _Category  iterator_category;
  typedef _Tp        value_type;
  typedef _Distance  difference_type;
  typedef _Pointer   pointer;
  typedef _Reference reference;
};
template< >
struct iterator<output_iterator_tag, void, void, void, void> {
  typedef output_iterator_tag  iterator_category;
  typedef void                value_type;
  typedef void                difference_type;
  typedef void                pointer;
  typedef void                reference;
};


template <class _Iterator>
struct iterator_traits {
  typedef typename _Iterator::iterator_category iterator_category;
  typedef typename _Iterator::value_type        value_type;
  typedef typename _Iterator::difference_type   difference_type;
  typedef typename _Iterator::pointer           pointer;
  typedef typename _Iterator::reference         reference;
};



// fbp : this order keeps gcc happy
template <class _Tp>
struct iterator_traits<const _Tp*> {
  typedef random_access_iterator_tag  iterator_category;
  typedef _Tp                         value_type;
  typedef ptrdiff_t                   difference_type;
  typedef const _Tp*                  pointer;
  typedef const _Tp&                  reference;
};

template <class _Tp>
struct iterator_traits<_Tp*> {
  typedef random_access_iterator_tag  iterator_category;
  typedef _Tp                         value_type;
  typedef ptrdiff_t                   difference_type;
  typedef _Tp*                        pointer;
  typedef _Tp&                        reference;
};



}
/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/


namespace std {

// The overloaded functions iterator_category, distance_type, and
// value_type are not part of the C++ standard.  (They have been
// replaced by struct iterator_traits.)  They are included for
// backward compatibility with the HP STL.
// We introduce internal names for these functions.



// The base classes input_iterator, output_iterator, forward_iterator,
// bidirectional_iterator, and random_access_iterator are not part of
// the C++ standard.  (They have been replaced by struct iterator.)
// They are included for backward compatibility with the HP STL.
template <class _Tp, class _Distance> struct input_iterator :
  public iterator <input_iterator_tag, _Tp, _Distance, _Tp*, _Tp&> {};
struct output_iterator : public iterator <output_iterator_tag, void, void, void, void> {};
template <class _Tp, class _Distance> struct forward_iterator :
  public iterator<forward_iterator_tag, _Tp, _Distance, _Tp*, _Tp&> {};
template <class _Tp, class _Distance> struct bidirectional_iterator :
  public iterator<bidirectional_iterator_tag, _Tp, _Distance, _Tp*, _Tp&> {};
template <class _Tp, class _Distance> struct random_access_iterator :
  public iterator<random_access_iterator_tag, _Tp, _Distance, _Tp*, _Tp&> {};


namespace priv {

template <class _InputIterator>
inline typename iterator_traits<_InputIterator> ::difference_type 
__distance(const _InputIterator& __first, const _InputIterator& __last,
           const input_iterator_tag &) {
  typename iterator_traits<_InputIterator> ::difference_type __n = 0;
  _InputIterator __it(__first);
  while (__it != __last) {
    ++__it; ++__n;
  }
  return __n;
}


template <class _RandomAccessIterator>
inline typename iterator_traits<_RandomAccessIterator> ::difference_type 
__distance(const _RandomAccessIterator& __first, const _RandomAccessIterator& __last,
           const random_access_iterator_tag &)
{ return __last - __first; }

}

template <class _InputIterator>
inline typename iterator_traits<_InputIterator> ::difference_type 
distance(_InputIterator __first, _InputIterator __last)
{ return ::std::priv:: __distance(__first, __last, typename ::std::iterator_traits< _InputIterator > ::iterator_category()); }

template <class _InputIterator, class _Distance>
inline void  distance(const _InputIterator& __first,
                                const _InputIterator& __last, _Distance& __n)
{ __n += ::std::distance(__first, __last); }


// fbp: those are being used for iterator/const_iterator definitions everywhere
template <class _Tp>
struct _Nonconst_traits;

template <class _Tp>
struct _Const_traits {
  typedef _Tp value_type;
  typedef const _Tp&  reference;
  typedef const _Tp*  pointer;
  typedef _Const_traits<_Tp> _ConstTraits;
  typedef _Nonconst_traits<_Tp> _NonConstTraits;
};

template <class _Tp>
struct _Nonconst_traits {
  typedef _Tp value_type;
  typedef _Tp& reference;
  typedef _Tp* pointer;
  typedef _Const_traits<_Tp> _ConstTraits;
  typedef _Nonconst_traits<_Tp> _NonConstTraits;
};

/*
 * dums: A special iterator/const_iterator traits for set and multiset for which even
 * the iterator is not mutable
 */
template <class _Tp>
struct _Nonconst_Const_traits;

template <class _Tp>
struct _Const_Const_traits {
  typedef _Tp value_type;
  typedef const _Tp&  reference;
  typedef const _Tp*  pointer;
  typedef _Const_Const_traits<_Tp> _ConstTraits;
  typedef _Nonconst_Const_traits<_Tp> _NonConstTraits;
};

template <class _Tp>
struct _Nonconst_Const_traits {
  typedef _Tp value_type;
  typedef const _Tp& reference;
  typedef const _Tp* pointer;
  typedef _Const_Const_traits<_Tp> _ConstTraits;
  typedef _Nonconst_Const_traits<_Tp> _NonConstTraits;
};

/*
 * A macro to generate a new iterator traits from one of the
 * previous one. Changing the iterator traits type make iterators
 * from different containers not comparable.
 */



/*
#  if defined (_STLP_BASE_TYPEDEF_BUG)
// this workaround is needed for SunPro 4.0.1
template <class _Traits>
struct __cnst_traits_aux : private _Traits {
  typedef typename _Traits::value_type value_type;
};
#  define __TRAITS_VALUE_TYPE(_Traits) __cnst_traits_aux<_Traits>::value_type
#  else
#  define __TRAITS_VALUE_TYPE(_Traits) _Traits::value_type
#  endif
*/

namespace priv {

template <class _InputIter, class _Distance>
inline void 
__advance(_InputIter& __i, _Distance __n, const input_iterator_tag &)
{ while (__n--) ++__i; }

// fbp : added output iterator tag variant
template <class _InputIter, class _Distance>
inline void 
__advance(_InputIter& __i, _Distance __n, const output_iterator_tag &)
{ while (__n--) ++__i; }


template <class _BidirectionalIterator, class _Distance>
inline void 
__advance(_BidirectionalIterator& __i, _Distance __n,
          const bidirectional_iterator_tag &) {
  if (__n > 0)
    while (__n--) ++__i;
  else
    while (__n++) --__i;
}

template <class _RandomAccessIterator, class _Distance>
inline void 
__advance(_RandomAccessIterator& __i, _Distance __n,
          const random_access_iterator_tag &)
{ __i += __n; }

}

template <class _InputIterator, class _Distance>
inline void  advance(_InputIterator& __i, _Distance __n)
{ ::std::priv:: __advance(__i, __n, typename ::std::iterator_traits< _InputIterator > ::iterator_category()); }

}



// Local Variables:
// mode:C++
// End:


namespace std {


// swap and iter_swap
template <class _Tp>
inline void swap(_Tp& __a, _Tp& __b) {
  _Tp __tmp = __a;
  __a = __b;
  __b = __tmp;
}

namespace priv {

template <class _ForwardIter1, class _ForwardIter2, class _Value>
inline void __iter_swap_aux_aux(_ForwardIter1& __i1, _ForwardIter2& __i2, _Value *) {
  _Value tmp = *__i1;
  *__i1 = *__i2;
  *__i2 = tmp;
}

template <class _ForwardIter1, class _ForwardIter2>
inline void __iter_swap_aux(_ForwardIter1& __i1, _ForwardIter2& __i2, const __true_type& /*OKToSwap*/) {
  /* namespace specification breaks access to the right swap template overload (at least for gcc) */
  /*_STLP_STD::*/ swap(*__i1, *__i2);
}

template <class _ForwardIter1, class _ForwardIter2>
inline void __iter_swap_aux(_ForwardIter1& __i1, _ForwardIter2& __i2, const __false_type& /*OKToSwap*/) {
  ::std::priv:: __iter_swap_aux_aux( __i1, __i2, (typename ::std::iterator_traits< _ForwardIter1 > ::value_type*)0 );
}

}

template <class _ForwardIter1, class _ForwardIter2>
inline void iter_swap(_ForwardIter1 __i1, _ForwardIter2 __i2) {
  ::std::priv:: __iter_swap_aux( __i1, __i2, _IsOKToSwap((typename ::std::iterator_traits< _ForwardIter1 > ::value_type*)0, (typename ::std::iterator_traits< _ForwardIter2 > ::value_type*)0,
                                                      ::std::_IsRefType< typename ::std::iterator_traits< _ForwardIter1 > ::reference > ::_Ret(),
                                                      ::std::_IsRefType< typename ::std::iterator_traits< _ForwardIter2 > ::reference > ::_Ret())._Answer());
}

//--------------------------------------------------
// min and max

template <class _Tp>
inline const _Tp& (min)(const _Tp& __a, const _Tp& __b) { return __b < __a ? __b : __a; }
template <class _Tp>
inline const _Tp& (max)(const _Tp& __a, const _Tp& __b) {  return  __a < __b ? __b : __a; }


template <class _Tp, class _Compare>
inline const _Tp& (min)(const _Tp& __a, const _Tp& __b, _Compare __comp) {
  return __comp(__b, __a) ? __b : __a;
}

template <class _Tp, class _Compare>
inline const _Tp& (max)(const _Tp& __a, const _Tp& __b, _Compare __comp) {
  return __comp(__a, __b) ? __b : __a;
}

//--------------------------------------------------
// copy

// All of these auxiliary functions serve two purposes.  (1) Replace
// calls to copy with memmove whenever possible.  (Memmove, not memcpy,
// because the input and output ranges are permitted to overlap.)
// (2) If we're using random access iterators, then write the loop as
// a for loop with an explicit count.

namespace priv {

template <class _InputIter, class _OutputIter, class _Distance>
inline _OutputIter __copy(_InputIter __first, _InputIter __last,
                          _OutputIter __result, const input_iterator_tag &, _Distance*) {
  for ( ; __first != __last; ++__result, ++__first)
    *__result = *__first;
  return __result;
}


template <class _RandomAccessIter, class _OutputIter, class _Distance>
inline _OutputIter
__copy(_RandomAccessIter __first, _RandomAccessIter __last,
       _OutputIter __result, const random_access_iterator_tag &, _Distance*) {
  for (_Distance __n = __last - __first; __n > 0; --__n) {
    *__result = *__first;
    ++__first;
    ++__result;
  }
  return __result;
}

inline void*
__copy_trivial(const void* __first, const void* __last, void* __result) {
  size_t __n = (const char*)__last - (const char*)__first;
  return __n ? (void *)((char*)memmove(__result, __first, __n) + __n) : __result;
}

//--------------------------------------------------
// copy_backward auxiliary functions

template <class _BidirectionalIter1, class _BidirectionalIter2,
          class _Distance>
inline _BidirectionalIter2 __copy_backward(_BidirectionalIter1 __first,
                                           _BidirectionalIter1 __last,
                                           _BidirectionalIter2 __result,
                                           const bidirectional_iterator_tag &,
                                           _Distance*) {
  while (__first != __last)
    *--__result = *--__last;
  return __result;
}

template <class _RandomAccessIter, class _BidirectionalIter, class _Distance>
inline _BidirectionalIter __copy_backward(_RandomAccessIter __first,
                                          _RandomAccessIter __last,
                                          _BidirectionalIter __result,
                                          const random_access_iterator_tag &,
                                          _Distance*) {
  for (_Distance __n = __last - __first; __n > 0; --__n)
    *--__result = *--__last;
  return __result;
}

inline void*
__copy_trivial_backward(const void* __first, const void* __last, void* __result) {
  const ptrdiff_t _Num = (const char*)__last - (const char*)__first;
  return (_Num > 0) ? memmove((char*)__result - _Num, __first, _Num) : __result ;
}

template <class _InputIter, class _OutputIter>
inline _OutputIter __copy_ptrs(_InputIter __first, _InputIter __last, _OutputIter __result,
                               const __false_type& /*IsOKToMemCpy*/) {
  return ::std::priv:: __copy(__first, __last, __result, random_access_iterator_tag(), (ptrdiff_t*)0);
}
template <class _InputIter, class _OutputIter>
inline _OutputIter __copy_ptrs(_InputIter __first, _InputIter __last, _OutputIter __result,
                               const __true_type& /*IsOKToMemCpy*/) {
  // we know they all pointers, so this cast is OK
  //  return (_OutputIter)__copy_trivial(&(*__first), &(*__last), &(*__result));
  return (_OutputIter)::std::priv:: __copy_trivial(__first, __last, __result);
}

template <class _InputIter, class _OutputIter>
inline _OutputIter __copy_aux(_InputIter __first, _InputIter __last, _OutputIter __result,
                              const __true_type& /*BothPtrType*/) {
  return ::std::priv:: __copy_ptrs(__first, __last, __result,
                                _UseTrivialCopy((typename ::std::iterator_traits< _InputIter > ::value_type*)0,
                                                (typename ::std::iterator_traits< _OutputIter > ::value_type*)0)._Answer());
}

template <class _InputIter, class _OutputIter>
inline _OutputIter __copy_aux(_InputIter __first, _InputIter __last, _OutputIter __result,
                              const __false_type& /*BothPtrType*/) {
  return ::std::priv:: __copy(__first, __last, __result,
                           typename ::std::iterator_traits< _InputIter > ::iterator_category(),
                           (typename ::std::iterator_traits< _InputIter > ::difference_type*)0);
}

}

template <class _InputIter, class _OutputIter>
inline _OutputIter copy(_InputIter __first, _InputIter __last, _OutputIter __result) {
  
  return ::std::priv:: __copy_aux(__first, __last, __result, _BothPtrType< _InputIter, _OutputIter>::_Answer());
}

namespace priv {

template <class _InputIter, class _OutputIter>
inline _OutputIter __copy_backward_ptrs(_InputIter __first, _InputIter __last,
                                        _OutputIter __result, const __false_type& /*TrivialAssignment*/) {
  return ::std::priv:: __copy_backward(__first, __last, __result,
                                    typename ::std::iterator_traits< _InputIter > ::iterator_category(),
                                    (typename ::std::iterator_traits< _InputIter > ::difference_type*)0);
}
template <class _InputIter, class _OutputIter>
inline _OutputIter __copy_backward_ptrs(_InputIter __first, _InputIter __last,
                                        _OutputIter __result, const __true_type& /*TrivialAssignment*/) {
  return (_OutputIter)::std::priv:: __copy_trivial_backward(__first, __last, __result);
}

template <class _InputIter, class _OutputIter>
inline _OutputIter __copy_backward_aux(_InputIter __first, _InputIter __last, _OutputIter __result, const __false_type&) {
  return ::std::priv:: __copy_backward(__first, __last, __result,
                                    typename ::std::iterator_traits< _InputIter > ::iterator_category(),
                                    (typename ::std::iterator_traits< _InputIter > ::difference_type*)0);
}

template <class _InputIter, class _OutputIter>
inline _OutputIter __copy_backward_aux(_InputIter __first, _InputIter __last, _OutputIter __result, const __true_type&) {
  return ::std::priv:: __copy_backward_ptrs(__first, __last, __result,
                                         _UseTrivialCopy((typename ::std::iterator_traits< _InputIter > ::value_type*)0,
                                                         (typename ::std::iterator_traits< _OutputIter > ::value_type*)0)._Answer());
}

}

template <class _InputIter, class _OutputIter>
inline _OutputIter copy_backward(_InputIter __first, _InputIter __last, _OutputIter __result) {
  
  return ::std::priv:: __copy_backward_aux(__first, __last, __result, _BothPtrType< _InputIter, _OutputIter>::_Answer() );
}


//--------------------------------------------------
// copy_n (not part of the C++ standard)

namespace priv {

template <class _InputIter, class _Size, class _OutputIter>
inline ::std::pair<_InputIter, _OutputIter>
__copy_n(_InputIter __first, _Size __count, _OutputIter __result,
         const input_iterator_tag &) {
  for ( ; __count > 0; --__count) {
    *__result = *__first;
    ++__first;
    ++__result;
  }
  return ::std::pair<_InputIter, _OutputIter>(__first, __result);
}

template <class _RAIter, class _Size, class _OutputIter>
inline ::std::pair<_RAIter, _OutputIter>
__copy_n(_RAIter __first, _Size __count, _OutputIter __result,
         const random_access_iterator_tag &) {
  _RAIter __last = __first + __count;
  return ::std::pair<_RAIter, _OutputIter>(__last, ::std::copy(__first, __last, __result));
}

}

template <class _InputIter, class _Size, class _OutputIter>
inline pair<_InputIter, _OutputIter>
copy_n(_InputIter __first, _Size __count, _OutputIter __result) {
  
  return ::std::priv:: __copy_n(__first, __count, __result, typename ::std::iterator_traits< _InputIter > ::iterator_category());
}

//--------------------------------------------------
// fill and fill_n
namespace priv {

template <class _ForwardIter, class _Tp>
inline
void __fill_fwd(_ForwardIter __first, _ForwardIter __last, const _Tp& __val) {
  for ( ; __first != __last; ++__first)
    *__first = __val;
}

template <class _ForwardIter, class _Tp, class _Distance>
inline void __fill(_ForwardIter __first, _ForwardIter __last, const _Tp& __val,
                   const input_iterator_tag &, _Distance*) {
  ::std::priv:: __fill_fwd(__first, __last, __val);
}


template <class _RandomAccessIter, class _Tp, class _Distance>
inline
void __fill(_RandomAccessIter __first, _RandomAccessIter __last, const _Tp& __val,
            const random_access_iterator_tag &, _Distance*) {
  for (_Distance __n = __last - __first ; __n > 0; ++__first, --__n)
    *__first = __val;
}

}

template <class _ForwardIter, class _Tp>
inline void fill(_ForwardIter __first, _ForwardIter __last, const _Tp& __val) {
  
  ::std::priv:: __fill(__first, __last, __val,
                    typename ::std::iterator_traits< _ForwardIter > ::iterator_category(),
                    (typename ::std::iterator_traits< _ForwardIter > ::difference_type*)0);
}

// Specialization: for one-byte types we can use memset.
inline void fill(unsigned char* __first, unsigned char* __last,
                 const unsigned char& __val) {
  unsigned char __tmp = __val;
  memset(__first, __tmp, __last - __first);
}
inline void fill(signed char* __first, signed char* __last,
                 const signed char& __val) {
  signed char __tmp = __val;
  memset(__first, static_cast<unsigned char>(__tmp), __last - __first);
}
inline void fill(char* __first, char* __last, const char& __val) {
  char __tmp = __val;
  memset(__first, static_cast<unsigned char>(__tmp), __last - __first);
}

namespace priv {

template <class _OutputIter, class _Size, class _Tp>
inline
_OutputIter __fill_n(_OutputIter __first, _Size __n, const _Tp& __val) {
  
  for ( ; __n > 0; --__n, ++__first)
    *__first = __val;
  return __first;
}

template <class _Size>
inline unsigned char* __fill_n(unsigned char* __first, _Size __n,
                               const unsigned char& __val) {
  ::std::fill(__first, __first + __n, __val);
  return __first + __n;
}
template <class _Size>
inline signed char* __fill_n(signed char* __first, _Size __n,
                             const signed char& __val) {
  ::std::fill(__first, __first + __n, __val);
  return __first + __n;
}
template <class _Size>
inline char* __fill_n(char* __first, _Size __n,
                      const char& __val) {
  ::std::fill(__first, __first + __n, __val);
  return __first + __n;
}

}

template <class _OutputIter, class _Size, class _Tp>
inline void fill_n(_OutputIter __first, _Size __n, const _Tp& __val) {
  
  ::std::priv:: __fill_n(__first, __n, __val);
}


//--------------------------------------------------
// equal and mismatch

template <class _InputIter1, class _InputIter2>
inline
::std::pair<_InputIter1, _InputIter2> mismatch(_InputIter1 __first1,
                                                   _InputIter1 __last1,
                                                   _InputIter2 __first2) {
  
  
  while (__first1 != __last1 && *__first1 == *__first2) {
    ++__first1;
    ++__first2;
  }
  return ::std::pair<_InputIter1, _InputIter2>(__first1, __first2);
}

template <class _InputIter1, class _InputIter2, class _BinaryPredicate>
inline
::std::pair<_InputIter1, _InputIter2> mismatch(_InputIter1 __first1,
                                                   _InputIter1 __last1,
                                                   _InputIter2 __first2,
                                                   _BinaryPredicate __binary_pred) {
  
  
  while (__first1 != __last1 && __binary_pred(*__first1, *__first2)) {
    ++__first1;
    ++__first2;
  }
  return ::std::pair<_InputIter1, _InputIter2>(__first1, __first2);
}

template <class _InputIter1, class _InputIter2>
inline
bool equal(_InputIter1 __first1, _InputIter1 __last1,
           _InputIter2 __first2) {
     
  
  for ( ; __first1 != __last1; ++__first1, ++__first2)
    if (!(*__first1 == *__first2))
      return false;
  return true;
}

template <class _InputIter1, class _InputIter2, class _BinaryPredicate>
inline
bool equal(_InputIter1 __first1, _InputIter1 __last1,
           _InputIter2 __first2, _BinaryPredicate __binary_pred) {
  
  
  for ( ; __first1 != __last1; ++__first1, ++__first2)
    if (!__binary_pred(*__first1, *__first2))
      return false;
  return true;
}

//--------------------------------------------------
// lexicographical_compare and lexicographical_compare_3way.
// (the latter is not part of the C++ standard.)

template <class _InputIter1, class _InputIter2>
bool lexicographical_compare(_InputIter1 __first1, _InputIter1 __last1,
                             _InputIter2 __first2, _InputIter2 __last2);

template <class _InputIter1, class _InputIter2, class _Compare>
bool lexicographical_compare(_InputIter1 __first1, _InputIter1 __last1,
                             _InputIter2 __first2, _InputIter2 __last2,
                             _Compare __comp);

inline bool
lexicographical_compare(const unsigned char* __first1,
                        const unsigned char* __last1,
                        const unsigned char* __first2,
                        const unsigned char* __last2) {
  const size_t __len1 = __last1 - __first1;
  const size_t __len2 = __last2 - __first2;
  
  

  const int __result = memcmp(__first1, __first2, (min) (__len1, __len2));
  return __result != 0 ? (__result < 0) : (__len1 < __len2);
}


inline bool lexicographical_compare(const char* __first1, const char* __last1,
                                    const char* __first2, const char* __last2) {
  
  

  return lexicographical_compare((const unsigned char*) __first1,
                                 (const unsigned char*) __last1,
                                 (const unsigned char*) __first2,
                                 (const unsigned char*) __last2);
}

namespace priv {

template <class _InputIter1, class _InputIter2>
int __lexicographical_compare_3way(_InputIter1 __first1, _InputIter1 __last1,
                                   _InputIter2 __first2, _InputIter2 __last2);

inline int
__lexicographical_compare_3way(const unsigned char* __first1,
                               const unsigned char* __last1,
                               const unsigned char* __first2,
                               const unsigned char* __last2) {
  const ptrdiff_t __len1 = __last1 - __first1;
  const ptrdiff_t __len2 = __last2 - __first2;
  const int __result = memcmp(__first1, __first2, (min) (__len1, __len2));
  return __result != 0 ? __result
                       : (__len1 == __len2 ? 0 : (__len1 < __len2 ? -1 : 1));
}


inline int
__lexicographical_compare_3way(const char* __first1, const char* __last1,
                               const char* __first2, const char* __last2) {
  return __lexicographical_compare_3way((const unsigned char*) __first1,
                                        (const unsigned char*) __last1,
                                        (const unsigned char*) __first2,
                                        (const unsigned char*) __last2);
}

}

template <class _InputIter1, class _InputIter2>
int lexicographical_compare_3way(_InputIter1 __first1, _InputIter1 __last1,
                                 _InputIter2 __first2, _InputIter2 __last2);


// count
template <class _InputIter, class _Tp>
inline typename iterator_traits<_InputIter> ::difference_type
count(_InputIter __first, _InputIter __last, const _Tp& __val) {
  
  typename iterator_traits<_InputIter> ::difference_type __n = 0;
  for ( ; __first != __last; ++__first)
    if (*__first == __val)
      ++__n;
  return __n;
}

// find and find_if. Note find may be expressed in terms of find_if if appropriate binder was available.
template <class _InputIter, class _Tp>
_InputIter find(_InputIter __first, _InputIter __last, const _Tp& __val);

template <class _InputIter, class _Predicate>
_InputIter find_if(_InputIter __first, _InputIter __last, _Predicate __pred);

// search.
template <class _ForwardIter1, class _ForwardIter2, class _BinaryPred>
_ForwardIter1 search(_ForwardIter1 __first1, _ForwardIter1 __last1,
                     _ForwardIter2 __first2, _ForwardIter2 __last2, _BinaryPred  __predicate);

namespace priv {

// find_first_of
template <class _InputIter, class _ForwardIter>
_InputIter __find_first_of(_InputIter __first1, _InputIter __last1,
                           _ForwardIter __first2, _ForwardIter __last2);

template <class _InputIter, class _ForwardIter, class _BinaryPredicate>
_InputIter __find_first_of(_InputIter __first1, _InputIter __last1,
                           _ForwardIter __first2, _ForwardIter __last2,
                           _BinaryPredicate __comp);

}

template <class _ForwardIter1, class _ForwardIter2,
          class _BinaryPredicate>
_ForwardIter1
find_end(_ForwardIter1 __first1, _ForwardIter1 __last1,
         _ForwardIter2 __first2, _ForwardIter2 __last2,
         _BinaryPredicate __comp);

// replace
template <class _ForwardIter, class _Tp>
inline void
replace(_ForwardIter __first, _ForwardIter __last,
        const _Tp& __old_value, const _Tp& __new_value) {
  
  for ( ; __first != __last; ++__first)
    if (*__first == __old_value)
      *__first = __new_value;
}

namespace priv {

template <class _ForwardIter, class _Tp, class _Compare1, class _Compare2, class _Distance>
_ForwardIter __lower_bound(_ForwardIter __first, _ForwardIter __last,
                           const _Tp& __val, _Compare1 __comp1, _Compare2 __comp2, _Distance*);

}

}

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996-1998
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

/* NOTE: This is an internal header file, included by other STL headers.
 *   You should not attempt to use it directly.
 */



namespace std {

template <class _Arg, class _Result>
struct unary_function {
  typedef _Arg argument_type;
  typedef _Result result_type;
};

template <class _Arg1, class _Arg2, class _Result>
struct binary_function {
  typedef _Arg1 first_argument_type;
  typedef _Arg2 second_argument_type;
  typedef _Result result_type;
};

template <class _Tp>
struct equal_to : public binary_function<_Tp, _Tp, bool> {
  bool operator()(const _Tp& __x, const _Tp& __y) const { return __x == __y; }
};

template <class _Tp>
struct less : public binary_function<_Tp,_Tp,bool>
/* less is the default template parameter for many STL containers, to fully use
 * the move constructor feature we need to know that the default less is just a
 * functor.
 */
              , public __stlport_class<less<_Tp> >
{
  bool operator()(const _Tp& __x, const _Tp& __y) const { return __x < __y; }

};

template <class _Tp>
struct __type_traits<less<_Tp> > {
  typedef typename _IsSTLportClass<less<_Tp> >::_Ret _STLportLess;
  typedef _STLportLess has_trivial_default_constructor;
  typedef _STLportLess has_trivial_copy_constructor;
  typedef _STLportLess has_trivial_assignment_operator;
  typedef _STLportLess has_trivial_destructor;
  typedef _STLportLess is_POD_type;
};

namespace priv {

template <class _Tp>
struct _ti_equal_to : public binary_function<_Tp, _Tp, bool> {
  bool operator()(const _Tp& __x, const _Tp& __y) const { return __x == __y; }
  bool operator()(_Tp& __x, _Tp& __y) const             { return __x == __y; }
};

template <class _Tp>
struct _ti_less : public binary_function<_Tp,_Tp,bool>
{
  bool operator()(const _Tp& __x, const _Tp& __y) const { return __x < __y; }
  bool operator()(_Tp& __x, _Tp& __y) const             { return __x < __y; }
};

template <class _Tp>
_ti_less<_Tp> __less(_Tp* ) { return _ti_less<_Tp>(); }

template <class _Tp>
_ti_equal_to<_Tp> __equal_to(_Tp* ) { return _ti_equal_to<_Tp>(); }

}

template <class _Tp>
struct plus : public binary_function<_Tp, _Tp, _Tp> {
  _Tp operator()(const _Tp& __x, const _Tp& __y) const { return __x + __y; }
};

template <class _Tp>
struct minus : public binary_function<_Tp, _Tp, _Tp> {
  _Tp operator()(const _Tp& __x, const _Tp& __y) const { return __x - __y; }
};

namespace priv {

template <class _Tp>
struct _ti_plus : public binary_function<_Tp, _Tp, _Tp> {
  _Tp operator()(const _Tp& __x, const _Tp& __y) const { return __x + __y; }
  _Tp operator()(_Tp& __x, _Tp& __y) const             { return __x + __y; }
};

template <class _Tp>
struct _ti_minus : public binary_function<_Tp, _Tp, _Tp> {
  _Tp operator()(const _Tp& __x, const _Tp& __y) const { return __x - __y; }
  _Tp operator()(_Tp& __x, _Tp& __y) const             { return __x - __y; }
};

template <class _Tp>
_ti_plus<_Tp> __plus(_Tp* ) { return _ti_plus<_Tp>(); }

template <class _Tp>
_ti_minus<_Tp> __minus(_Tp* ) { return _ti_minus<_Tp>(); }

}

template <class _Tp>
struct multiplies : public binary_function<_Tp, _Tp, _Tp> {
  _Tp operator()(const _Tp& __x, const _Tp& __y) const { return __x * __y; }
};

namespace priv {

template <class _Pair>
struct _Select1st : public unary_function<_Pair, typename _Pair::first_type> {
  const typename _Pair::first_type& operator()(const _Pair& __x) const {
    return __x.first;
  }
};

template <class _Pair>
struct _Select2nd : public unary_function<_Pair, typename _Pair::second_type> {
  const typename _Pair::second_type& operator()(const _Pair& __x) const {
    return __x.second;
  }
};

// project1st and project2nd are extensions: they are not part of the standard
template <class _Arg1, class _Arg2>
struct _Project1st : public binary_function<_Arg1, _Arg2, _Arg1> {
  _Arg1 operator()(const _Arg1& __x, const _Arg2&) const { return __x; }
};

template <class _Arg1, class _Arg2>
struct _Project2nd : public binary_function<_Arg1, _Arg2, _Arg2> {
  _Arg2 operator()(const _Arg1&, const _Arg2& __y) const { return __y; }
};


template <class _Tp>
struct _Identity : public unary_function<_Tp,_Tp> {
  const _Tp& operator()(const _Tp& __x) const { return __x; }
};

template <class _Result, class _Argument>
struct _Constant_unary_fun {
  typedef _Argument argument_type;
  typedef  _Result  result_type;
  result_type _M_val;

  _Constant_unary_fun(const result_type& __v) : _M_val(__v) {}
  const result_type& operator()(const _Argument&) const { return _M_val; }
};

template <class _Result, class _Arg1, class _Arg2>
struct _Constant_binary_fun {
  typedef  _Arg1   first_argument_type;
  typedef  _Arg2   second_argument_type;
  typedef  _Result result_type;
  _Result _M_val;

  _Constant_binary_fun(const _Result& __v) : _M_val(__v) {}
  const result_type& operator()(const _Arg1&, const _Arg2&) const {
    return _M_val;
  }
};

// identity_element (not part of the C++ standard).
template <class _Tp> inline _Tp __identity_element(plus<_Tp>) {  return _Tp(0); }
template <class _Tp> inline _Tp __identity_element(multiplies<_Tp>) { return _Tp(1); }

}

}


// Local Variables:
// mode:C++
// End:

namespace std {

template <class _InputIter1, class _InputIter2>
bool lexicographical_compare(_InputIter1 __first1, _InputIter1 __last1,
                             _InputIter2 __first2, _InputIter2 __last2) {
  
  
  for ( ; __first1 != __last1 && __first2 != __last2
        ; ++__first1, ++__first2) {
    if (*__first1 < *__first2) {
      
      return true;
    }
    if (*__first2 < *__first1)
      return false;
  }
  return __first1 == __last1 && __first2 != __last2;
}

template <class _InputIter1, class _InputIter2, class _Compare>
bool lexicographical_compare(_InputIter1 __first1, _InputIter1 __last1,
                             _InputIter2 __first2, _InputIter2 __last2,
                             _Compare __comp) {
  
  
  for ( ; __first1 != __last1 && __first2 != __last2
        ; ++__first1, ++__first2) {
    if (__comp(*__first1, *__first2)) {
      
      return true;
    }
    if (__comp(*__first2, *__first1))
      return false;
  }
  return __first1 == __last1 && __first2 != __last2;
}

namespace priv {

template <class _InputIter1, class _InputIter2>
int __lexicographical_compare_3way(_InputIter1 __first1, _InputIter1 __last1,
                                   _InputIter2 __first2, _InputIter2 __last2) {
  while (__first1 != __last1 && __first2 != __last2) {
    if (*__first1 < *__first2) {
      
      return -1;
    }
    if (*__first2 < *__first1)
      return 1;
    ++__first1;
    ++__first2;
  }
  if (__first2 == __last2) {
    return !(__first1 == __last1);
  }
  else {
    return -1;
  }
}

}

template <class _InputIter1, class _InputIter2>
int lexicographical_compare_3way(_InputIter1 __first1, _InputIter1 __last1,
                                 _InputIter2 __first2, _InputIter2 __last2) {
  
  
  return ::std::priv:: __lexicographical_compare_3way(__first1, __last1, __first2, __last2);
}

namespace priv {

template <class _RandomAccessIter, class _Tp>
inline _RandomAccessIter __find(_RandomAccessIter __first, _RandomAccessIter __last,
                                           const _Tp& __val,
                                           const random_access_iterator_tag &) {
  typename iterator_traits<_RandomAccessIter> ::difference_type __trip_count = (__last - __first) >> 2;

  for ( ; __trip_count > 0 ; --__trip_count) {
    if (*__first == __val) return __first;
    ++__first;

    if (*__first == __val) return __first;
    ++__first;

    if (*__first == __val) return __first;
    ++__first;

    if (*__first == __val) return __first;
    ++__first;
  }

  switch (__last - __first) {
  case 3:
    if (*__first == __val) return __first;
    ++__first;
  case 2:
    if (*__first == __val) return __first;
    ++__first;
  case 1:
    if (*__first == __val) return __first;
    //++__first;
  case 0:
  default:
    return __last;
  }
}

inline char*
__find(char* __first, char* __last, char __val, const random_access_iterator_tag &) {
  void *res =  memchr(__first, __val, __last - __first);
  return res != 0 ? static_cast<char* >(res) : __last;
}
inline const char*
__find(const char* __first, const char* __last, char __val, const random_access_iterator_tag &) {
  const void *res =  memchr(__first, __val, __last - __first);
  return res != 0 ? static_cast<const char* >(res) : __last;
}

template <class _RandomAccessIter, class _Predicate>
inline _RandomAccessIter __find_if(_RandomAccessIter __first, _RandomAccessIter __last,
                                              _Predicate __pred,
                                              const random_access_iterator_tag &) {
  typename iterator_traits<_RandomAccessIter> ::difference_type __trip_count = (__last - __first) >> 2;

  for ( ; __trip_count > 0 ; --__trip_count) {
    if (__pred(*__first)) return __first;
    ++__first;

    if (__pred(*__first)) return __first;
    ++__first;

    if (__pred(*__first)) return __first;
    ++__first;

    if (__pred(*__first)) return __first;
    ++__first;
  }

  switch(__last - __first) {
  case 3:
    if (__pred(*__first)) return __first;
    ++__first;
  case 2:
    if (__pred(*__first)) return __first;
    ++__first;
  case 1:
    if (__pred(*__first)) return __first;
      //++__first;
  case 0:
  default:
    return __last;
  }
}

template <class _InputIter, class _Tp>
inline _InputIter __find(_InputIter __first, _InputIter __last,
                                    const _Tp& __val,
                                    const input_iterator_tag &) {
  while (__first != __last && !(*__first == __val)) ++__first;
  return __first;
}

template <class _InputIter, class _Predicate>
inline _InputIter __find_if(_InputIter __first, _InputIter __last,
                                       _Predicate __pred,
                                       const input_iterator_tag &) {
  while (__first != __last && !__pred(*__first))
    ++__first;
  return __first;
}

}

template <class _InputIter, class _Predicate>
_InputIter find_if(_InputIter __first, _InputIter __last,
                   _Predicate __pred) {
  
  return ::std::priv:: __find_if(__first, __last, __pred, typename ::std::iterator_traits< _InputIter > ::iterator_category());
}

template <class _InputIter, class _Tp>
_InputIter find(_InputIter __first, _InputIter __last, const _Tp& __val) {
  
  return ::std::priv:: __find(__first, __last, __val, typename ::std::iterator_traits< _InputIter > ::iterator_category());
}

template <class _ForwardIter1, class _ForwardIter2, class _BinaryPred>
_ForwardIter1 search(_ForwardIter1 __first1, _ForwardIter1 __last1,
                     _ForwardIter2 __first2, _ForwardIter2 __last2,
                     _BinaryPred  __pred) {
  
  
  // Test for empty ranges
  if (__first1 == __last1 || __first2 == __last2)
    return __first1;

  // Test for a pattern of length 1.
  _ForwardIter2 __p1(__first2);

  if ( ++__p1 == __last2 ) {
    while (__first1 != __last1 && !__pred(*__first1, *__first2)) {
      ++__first1;
    }
    return __first1;
  }

  // General case.

  for ( ; ; ) { // __first1 != __last1 will be checked below
    while (__first1 != __last1 && !__pred(*__first1, *__first2)) {
      ++__first1;
    }
    if (__first1 == __last1) {
      return __last1;
    }
    _ForwardIter2 __p = __p1;
    _ForwardIter1 __current = __first1;
    if (++__current == __last1) return __last1;

    while (__pred(*__current, *__p)) {
      if (++__p == __last2)
        return __first1;
      if (++__current == __last1)
        return __last1;
    }
    ++__first1;
  }
}

namespace priv {
template <class _Tp>
struct _IsCharLikeType
{ typedef __false_type _Ret; };

template< > struct _IsCharLikeType<char>
{ typedef __true_type _Ret; };

template< > struct _IsCharLikeType<unsigned char>
{ typedef __true_type _Ret; };

template< > struct _IsCharLikeType<signed char>
{ typedef __true_type _Ret; };

template <class _Tp1, class _Tp2>
inline bool __stlp_eq(_Tp1 __val1, _Tp2 __val2)
{ return __val1 == __val2; }

template <class _Tp>
inline bool __stlp_eq(_Tp, _Tp)
{ return true; }

template <class _InputIter, class _ForwardIter, class _Tp2, class _Predicate>
inline _InputIter __find_first_of_aux2(_InputIter __first1, _InputIter __last1,
                                       _ForwardIter __first2, _ForwardIter __last2,
                                       _Tp2*, _Predicate __pred,
                                       const __true_type& /* _UseStrcspnLikeAlgo */) {
  /*-------------------------------------------------------------------------*/
  /* On C28x, char and int are the same size (16-bits). Because of this,     */
  /* UCHAR_MAX+1 is actually 0 which is wrong here. To solve the problem,    */
  /* just cast UCHAR_MAX to long. This could break for targets where char    */
  /* long are the same size, but lets hope that doesn't happen.              */
  /*-------------------------------------------------------------------------*/
  unsigned char __hints[((long)255 + 1) / 8];
  memset(__hints, 0, sizeof(__hints) / sizeof(unsigned char));
  for (; __first2 != __last2; ++__first2) {
    unsigned char __tmp = (unsigned char)*__first2;
    __hints[__tmp / 8] |= (1 << (__tmp % 8));
  }

  for (; __first1 != __last1; ++__first1) {
    _Tp2 __tmp = (_Tp2)*__first1;
    if (__stlp_eq(*__first1, __tmp) &&
        __pred((__hints[(unsigned char)__tmp / 8] & (1 << ((unsigned char)__tmp % 8))) != 0))
      break;
  }
  return __first1;
}

template <class _InputIter, class _ForwardIter, class _Tp2, class _Predicate>
inline _InputIter __find_first_of_aux2(_InputIter __first1, _InputIter __last1,
                                       _ForwardIter __first2, _ForwardIter __last2,
                                       _Tp2* /* __dummy */, _Predicate /* __pred */,
                                       const __false_type& /* _UseStrcspnLikeAlgo */) {
  return ::std::priv:: __find_first_of(__first1, __last1, __first2, __last2,
                                    ::std::priv:: __equal_to((typename ::std::iterator_traits< _InputIter > ::value_type*)0));
}

template <class _InputIter, class _ForwardIter, class _Tp1, class _Tp2>
inline _InputIter __find_first_of_aux1(_InputIter __first1, _InputIter __last1,
                                       _ForwardIter __first2, _ForwardIter __last2,
                                       _Tp1* __pt1, _Tp2* __pt2) {
  typedef typename ::std::_IsIntegral<_Tp1>::_Ret _IsIntegral;
  typedef typename ::std::priv:: _IsCharLikeType<_Tp2>::_Ret _IsCharLike;
  typedef typename ::std::_Land2<_IsIntegral, _IsCharLike>::_Ret _UseStrcspnLikeAlgo;
  return ::std::priv:: __find_first_of_aux2(__first1, __last1,
                                         __first2, __last2,
                                         __pt2, _Identity<bool>(), _UseStrcspnLikeAlgo());
}

template <class _InputIter, class _ForwardIter>
inline _InputIter __find_first_of(_InputIter __first1, _InputIter __last1,
                                  _ForwardIter __first2, _ForwardIter __last2) {
  return ::std::priv:: __find_first_of_aux1(__first1, __last1, __first2, __last2,
                                         (typename ::std::iterator_traits< _InputIter > ::value_type*)0,
                                         (typename ::std::iterator_traits< _ForwardIter > ::value_type*)0);
}

// find_first_of, with and without an explicitly supplied comparison function.
template <class _InputIter, class _ForwardIter, class _BinaryPredicate>
_InputIter __find_first_of(_InputIter __first1, _InputIter __last1,
                           _ForwardIter __first2, _ForwardIter __last2,
                           _BinaryPredicate __comp) {
  for ( ; __first1 != __last1; ++__first1) {
    for (_ForwardIter __iter = __first2; __iter != __last2; ++__iter) {
      if (__comp(*__first1, *__iter)) {
        return __first1;
      }
    }
  }
  return __last1;
}

// find_end, with and without an explicitly supplied comparison function.
// Search [first2, last2) as a subsequence in [first1, last1), and return
// the *last* possible match.  Note that find_end for bidirectional iterators
// is much faster than for forward iterators.

// find_end for forward iterators.
template <class _ForwardIter1, class _ForwardIter2,
  class _BinaryPredicate>
_ForwardIter1 __find_end(_ForwardIter1 __first1, _ForwardIter1 __last1,
                         _ForwardIter2 __first2, _ForwardIter2 __last2,
                         const forward_iterator_tag &, const forward_iterator_tag &,
                         _BinaryPredicate __comp) {
  if (__first2 == __last2)
    return __last1;
  else {
    _ForwardIter1 __result = __last1;
    for (;;) {
      _ForwardIter1 __new_result = ::std::search(__first1, __last1, __first2, __last2, __comp);
      if (__new_result == __last1)
        return __result;
      else {
        __result = __new_result;
        __first1 = __new_result;
        ++__first1;
      }
    }
  }
}

}

// find_end for bidirectional iterators.  Requires partial specialization.

}
/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996-1998
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

/* NOTE: This is an internal header file, included by other STL headers.
 *   You should not attempt to use it directly.
 */



namespace std {

// This is the new version of reverse_iterator, as defined in the
//  draft C++ standard.  It relies on the iterator_traits template,
//  which in turn relies on partial specialization.  The class
//  reverse_bidirectional_iterator is no longer part of the draft
//  standard, but it is retained for backward compatibility.

template <class _Iterator>
class reverse_iterator :
  public iterator<typename iterator_traits<_Iterator>::iterator_category,
                  typename iterator_traits<_Iterator>::value_type,
                  typename iterator_traits<_Iterator>::difference_type,
                  typename iterator_traits<_Iterator>::pointer,
                  typename iterator_traits<_Iterator>::reference> {
protected:
  _Iterator current;
  typedef reverse_iterator<_Iterator> _Self;
public:
  typedef typename iterator_traits<_Iterator>::difference_type difference_type;
  // pointer type required for arrow operator hidden behind _STLP_DEFINE_ARROW_OPERATOR:
  typedef typename iterator_traits<_Iterator>::pointer pointer;
  typedef typename iterator_traits<_Iterator>::reference reference;
  typedef _Iterator iterator_type;
public:
  reverse_iterator() {}
  explicit reverse_iterator(iterator_type __x) : current(__x) {}
  reverse_iterator(const _Self& __x) : current(__x.current) {}
  _Self& operator = (const _Self& __x) { current = __x.base(); return *this; }
  template <class _Iter>
  reverse_iterator(const reverse_iterator<_Iter>& __x) : current(__x.base()) {}
  template <class _Iter>
  _Self& operator = (const reverse_iterator<_Iter>& __x) { current = __x.base(); return *this; }

  iterator_type base() const { return current; }
  reference operator*() const {
    _Iterator __tmp = current;
    return *--__tmp;
  }
  pointer operator->() const { return &(operator*()); }
  _Self& operator++() {
    --current;
    return *this;
  }
  _Self operator++(int) {
    _Self __tmp = *this;
    --current;
    return __tmp;
  }
  _Self& operator--() {
    ++current;
    return *this;
  }
  _Self operator--(int) {
    _Self __tmp = *this;
    ++current;
    return __tmp;
  }

  _Self operator+(difference_type __n) const { return _Self(current - __n); }
  _Self& operator+=(difference_type __n) {
    current -= __n;
    return *this;
  }
  _Self operator-(difference_type __n) const { return _Self(current + __n); }
  _Self& operator-=(difference_type __n) {
    current += __n;
    return *this;
  }
  reference operator[](difference_type __n) const { return *(*this + __n); }
};

template <class _Iterator>
inline bool   operator==(const reverse_iterator<_Iterator>& __x,
                                   const reverse_iterator<_Iterator>& __y)
{ return __x.base() == __y.base(); }

template <class _Iterator>
inline bool  operator<(const reverse_iterator<_Iterator>& __x,
                                 const reverse_iterator<_Iterator>& __y)
{ return __y.base() < __x.base(); }

template <class _Iterator>
inline bool  operator!=(const reverse_iterator<_Iterator>& __x,
                                  const reverse_iterator<_Iterator>& __y)
{ return !(__x == __y); }

template <class _Iterator>
inline bool  operator>(const reverse_iterator<_Iterator>& __x,
                                 const reverse_iterator<_Iterator>& __y)
{ return __y < __x; }

template <class _Iterator>
inline bool  operator<=(const reverse_iterator<_Iterator>& __x,
                                  const reverse_iterator<_Iterator>& __y)
{ return !(__y < __x); }

template <class _Iterator>
inline bool  operator>=(const reverse_iterator<_Iterator>& __x,
                                  const reverse_iterator<_Iterator>& __y)
{ return !(__x < __y); }

template <class _Iterator>
inline typename reverse_iterator<_Iterator>::difference_type 
operator-(const reverse_iterator<_Iterator>& __x,
          const reverse_iterator<_Iterator>& __y)
{ return __y.base() - __x.base(); }

template <class _Iterator, class _DifferenceType>
inline reverse_iterator<_Iterator>  
operator+(_DifferenceType n,const reverse_iterator<_Iterator>& x)
{ return x.operator+(n); }

template <class _Container>
class back_insert_iterator
  : public iterator<output_iterator_tag, void, void, void, void> {
  typedef back_insert_iterator<_Container> _Self;
protected:
  //c is a Standard name (24.4.2.1), do no make it STLport naming convention compliant.
  _Container *container;
public:
  typedef _Container          container_type;
  typedef output_iterator_tag iterator_category;

  explicit back_insert_iterator(_Container& __x) : container(&__x) {}

  _Self& operator=(const _Self& __other) {
    container = __other.container;
    return *this;
  }
  _Self& operator=(const typename _Container::value_type& __val) {
    container->push_back(__val);
    return *this;
  }
  _Self& operator*() { return *this; }
  _Self& operator++() { return *this; }
  _Self  operator++(int) { return *this; }
};

template <class _Container>
inline back_insert_iterator<_Container>   back_inserter(_Container& __x)
{ return back_insert_iterator<_Container>(__x); }

template <class _Container>
class front_insert_iterator
  : public iterator<output_iterator_tag, void, void, void, void> {
  typedef front_insert_iterator<_Container> _Self;
protected:
  //c is a Standard name (24.4.2.3), do no make it STLport naming convention compliant.
  _Container *container;
public:
  typedef _Container          container_type;
  typedef output_iterator_tag iterator_category;
  explicit front_insert_iterator(_Container& __x) : container(&__x) {}

  _Self& operator=(const _Self& __other) {
    container = __other.container;
    return *this;
  }
  _Self& operator=(const typename _Container::value_type& __val) {
    container->push_front(__val);
    return *this;
  }
  _Self& operator*() { return *this; }
  _Self& operator++() { return *this; }
  _Self  operator++(int) { return *this; }
};

template <class _Container>
inline front_insert_iterator<_Container>   front_inserter(_Container& __x)
{ return front_insert_iterator<_Container>(__x); }

/*****************************************************************************/
/* The standard compliant name for _M_iter, below, is iter. (24.4.2.5)       */
/*****************************************************************************/

template <class _Container>
class insert_iterator
  : public iterator<output_iterator_tag, void, void, void, void> {
  typedef insert_iterator<_Container> _Self;
protected:
  //container is a Standard name (24.4.2.5), do no make it STLport naming convention compliant.
  _Container *container;
  typename _Container::iterator iter;
public:
  typedef _Container          container_type;
  typedef output_iterator_tag iterator_category;
  insert_iterator(_Container& __x, typename _Container::iterator __i)
    : container(&__x), iter(__i) {}

  _Self& operator=(_Self const& __other) {
    container = __other.container;
    iter = __other. iter;
    return *this;
  }
  _Self& operator=(const typename _Container::value_type& __val) {
    iter = container->insert(iter, __val);
    ++iter;
    return *this;
  }
  _Self& operator*() { return *this; }
  _Self& operator++() { return *this; }
  _Self& operator++(int) { return *this; }
};


template <class _Container, class _Iterator>
inline insert_iterator<_Container>  
inserter(_Container& __x, _Iterator __i) {
  typedef typename _Container::iterator __iter;
  return insert_iterator<_Container>(__x, __iter(__i));
}

}



// Local Variables:
// mode:C++
// End:
namespace std {

namespace priv {

template <class _BidirectionalIter1, class _BidirectionalIter2,
          class _BinaryPredicate>
_BidirectionalIter1
__find_end(_BidirectionalIter1 __first1, _BidirectionalIter1 __last1,
           _BidirectionalIter2 __first2, _BidirectionalIter2 __last2,
           const bidirectional_iterator_tag &, const bidirectional_iterator_tag &,
           _BinaryPredicate __comp) {
  typedef ::std::reverse_iterator<_BidirectionalIter1> _RevIter1;
  typedef ::std::reverse_iterator<_BidirectionalIter2> _RevIter2;

  _RevIter1 __rlast1(__first1);
  _RevIter2 __rlast2(__first2);
  _RevIter1 __rresult = ::std::search(_RevIter1(__last1), __rlast1,
                                          _RevIter2(__last2), __rlast2,
                                          __comp);

  if (__rresult == __rlast1)
    return __last1;
  else {
    _BidirectionalIter1 __result = __rresult.base();
    ::std::advance(__result, - ::std::distance(__first2, __last2));
    return __result;
  }
}

}

template <class _ForwardIter1, class _ForwardIter2,
          class _BinaryPredicate>
_ForwardIter1
find_end(_ForwardIter1 __first1, _ForwardIter1 __last1,
         _ForwardIter2 __first2, _ForwardIter2 __last2,
         _BinaryPredicate __comp) {
  
  
  return ::std::priv:: __find_end(__first1, __last1, __first2, __last2,
                               typename ::std::iterator_traits< _ForwardIter1 > ::iterator_category(),
                               typename ::std::iterator_traits< _ForwardIter2 > ::iterator_category(),
                               __comp);
}

namespace priv {

template <class _ForwardIter, class _Tp, class _Compare1, class _Compare2, class _Distance>
_ForwardIter __lower_bound(_ForwardIter __first, _ForwardIter __last, const _Tp& __val,
                           _Compare1 __comp1, _Compare2 __comp2, _Distance*) {
  _Distance __len = ::std::distance(__first, __last);
  _Distance __half;
  _ForwardIter __middle;

  while (__len > 0) {
    __half = __len >> 1;
    __middle = __first;
    ::std::advance(__middle, __half);
    if (__comp1(*__middle, __val)) {
      
      __first = __middle;
      ++__first;
      __len = __len - __half - 1;
    }
    else
      __len = __half;
  }
  return __first;
}

}

}


// Local Variables:
// mode:C++
// End:


// Local Variables:
// mode:C++
// End:


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Hewlett-Packard Company makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * Copyright (c) 1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Silicon Graphics makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 */

/* NOTE: This is an internal header file, included by other STL headers.
 *   You should not attempt to use it directly.
 */


namespace std {

// Heap-manipulation functions: push_heap, pop_heap, make_heap, sort_heap.

template <class _RandomAccessIterator>
void
push_heap(_RandomAccessIterator __first, _RandomAccessIterator __last);


template <class _RandomAccessIterator, class _Compare>
void
push_heap(_RandomAccessIterator __first, _RandomAccessIterator __last,
          _Compare __comp);

template <class _RandomAccessIterator, class _Distance, class _Tp>
void
__adjust_heap(_RandomAccessIterator __first, _Distance __holeIndex,
              _Distance __len, _Tp __val);

template <class _RandomAccessIterator, class _Tp, class _Distance>
inline void
__pop_heap(_RandomAccessIterator __first, _RandomAccessIterator __last,
           _RandomAccessIterator __result, _Tp __val, _Distance*)
{
  *__result = *__first;
  __adjust_heap(__first, _Distance(0), _Distance(__last - __first), __val);
}

template <class _RandomAccessIterator>
void pop_heap(_RandomAccessIterator __first,
        _RandomAccessIterator __last);

template <class _RandomAccessIterator, class _Distance,
          class _Tp, class _Compare>
void
__adjust_heap(_RandomAccessIterator __first, _Distance __holeIndex,
              _Distance __len, _Tp __val, _Compare __comp);

template <class _RandomAccessIterator, class _Tp, class _Compare,
          class _Distance>
inline void
__pop_heap(_RandomAccessIterator __first, _RandomAccessIterator __last,
           _RandomAccessIterator __result, _Tp __val, _Compare __comp,
           _Distance*)
{
  *__result = *__first;
  __adjust_heap(__first, _Distance(0), _Distance(__last - __first),
                __val, __comp);
}

template <class _RandomAccessIterator, class _Compare>
void
pop_heap(_RandomAccessIterator __first,
         _RandomAccessIterator __last, _Compare __comp);

template <class _RandomAccessIterator>
void
make_heap(_RandomAccessIterator __first, _RandomAccessIterator __last);

template <class _RandomAccessIterator, class _Compare>
void
make_heap(_RandomAccessIterator __first,
          _RandomAccessIterator __last, _Compare __comp);

template <class _RandomAccessIterator>
inline
void sort_heap(_RandomAccessIterator __first, _RandomAccessIterator __last)
{
  while (__last - __first > 1)
    pop_heap(__first, __last--);
}

template <class _RandomAccessIterator, class _Compare>
inline
void
sort_heap(_RandomAccessIterator __first,
          _RandomAccessIterator __last, _Compare __comp)
{
  while (__last - __first > 1)
    pop_heap(__first, __last--, __comp);
}

}

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */



namespace std {

template <class _RandomAccessIterator, class _Distance, class _Tp>
inline
void
__push_heap(_RandomAccessIterator __first,
            _Distance __holeIndex, _Distance __topIndex, _Tp __val)
{
  _Distance __parent = (__holeIndex - 1) / 2;
  while (__holeIndex > __topIndex && *(__first + __parent) < __val) {
    *(__first + __holeIndex) = *(__first + __parent);
    __holeIndex = __parent;
    __parent = (__holeIndex - 1) / 2;
  }
  *(__first + __holeIndex) = __val;
}

template <class _RandomAccessIterator, class _Distance, class _Tp>
inline void
__push_heap_aux(_RandomAccessIterator __first,
                _RandomAccessIterator __last, _Distance*, _Tp*)
{
  __push_heap(__first, _Distance((__last - __first) - 1), _Distance(0),
              _Tp(*(__last - 1)));
}

template <class _RandomAccessIterator>
void
push_heap(_RandomAccessIterator __first, _RandomAccessIterator __last)
{
  __push_heap_aux(__first, __last,
                  (typename ::std::iterator_traits< _RandomAccessIterator > ::difference_type*)0, (typename ::std::iterator_traits< _RandomAccessIterator > ::value_type*)0);
}


template <class _RandomAccessIterator, class _Distance, class _Tp,
          class _Compare>
inline
void
__push_heap(_RandomAccessIterator __first, _Distance __holeIndex,
            _Distance __topIndex, _Tp __val, _Compare __comp)
{
  _Distance __parent = (__holeIndex - 1) / 2;
  while (__holeIndex > __topIndex && __comp(*(__first + __parent), __val)) {
    
    *(__first + __holeIndex) = *(__first + __parent);
    __holeIndex = __parent;
    __parent = (__holeIndex - 1) / 2;
  }
  *(__first + __holeIndex) = __val;
}

template <class _RandomAccessIterator, class _Compare,
          class _Distance, class _Tp>
inline void
__push_heap_aux(_RandomAccessIterator __first,
                _RandomAccessIterator __last, _Compare __comp,
                _Distance*, _Tp*)
{
  __push_heap(__first, _Distance((__last - __first) - 1), _Distance(0),
              _Tp(*(__last - 1)), __comp);
}

template <class _RandomAccessIterator, class _Compare>
void
push_heap(_RandomAccessIterator __first, _RandomAccessIterator __last,
          _Compare __comp)
{
  __push_heap_aux(__first, __last, __comp,
                  (typename ::std::iterator_traits< _RandomAccessIterator > ::difference_type*)0, (typename ::std::iterator_traits< _RandomAccessIterator > ::value_type*)0);
}

template <class _RandomAccessIterator, class _Distance, class _Tp>
void
__adjust_heap(_RandomAccessIterator __first, _Distance __holeIndex,
              _Distance __len, _Tp __val) {
  _Distance __topIndex = __holeIndex;
  _Distance __secondChild = 2 * __holeIndex + 2;
  while (__secondChild < __len) {
    if (*(__first + __secondChild) < *(__first + (__secondChild - 1)))
      __secondChild--;
    *(__first + __holeIndex) = *(__first + __secondChild);
    __holeIndex = __secondChild;
    __secondChild = 2 * (__secondChild + 1);
  }
  if (__secondChild == __len) {
    *(__first + __holeIndex) = *(__first + (__secondChild - 1));
    __holeIndex = __secondChild - 1;
  }
  __push_heap(__first, __holeIndex, __topIndex, __val);
}


template <class _RandomAccessIterator, class _Tp>
inline void
__pop_heap_aux(_RandomAccessIterator __first, _RandomAccessIterator __last, _Tp*) {
  __pop_heap(__first, __last - 1, __last - 1,
             _Tp(*(__last - 1)), (typename ::std::iterator_traits< _RandomAccessIterator > ::difference_type*)0);
}

template <class _RandomAccessIterator>
void pop_heap(_RandomAccessIterator __first,
        _RandomAccessIterator __last) {
  __pop_heap_aux(__first, __last, (typename ::std::iterator_traits< _RandomAccessIterator > ::value_type*)0);
}

template <class _RandomAccessIterator, class _Distance,
          class _Tp, class _Compare>
void
__adjust_heap(_RandomAccessIterator __first, _Distance __holeIndex,
              _Distance __len, _Tp __val, _Compare __comp)
{
  _Distance __topIndex = __holeIndex;
  _Distance __secondChild = 2 * __holeIndex + 2;
  while (__secondChild < __len) {
    if (__comp(*(__first + __secondChild), *(__first + (__secondChild - 1)))) {
      
      __secondChild--;
    }
    *(__first + __holeIndex) = *(__first + __secondChild);
    __holeIndex = __secondChild;
    __secondChild = 2 * (__secondChild + 1);
  }
  if (__secondChild == __len) {
    *(__first + __holeIndex) = *(__first + (__secondChild - 1));
    __holeIndex = __secondChild - 1;
  }
  __push_heap(__first, __holeIndex, __topIndex, __val, __comp);
}


template <class _RandomAccessIterator, class _Tp, class _Compare>
inline void
__pop_heap_aux(_RandomAccessIterator __first,
               _RandomAccessIterator __last, _Tp*, _Compare __comp)
{
  __pop_heap(__first, __last - 1, __last - 1, _Tp(*(__last - 1)), __comp,
             (typename ::std::iterator_traits< _RandomAccessIterator > ::difference_type*)0);
}


template <class _RandomAccessIterator, class _Compare>
void
pop_heap(_RandomAccessIterator __first,
         _RandomAccessIterator __last, _Compare __comp)
{
    __pop_heap_aux(__first, __last, (typename ::std::iterator_traits< _RandomAccessIterator > ::value_type*)0, __comp);
}

template <class _RandomAccessIterator, class _Tp, class _Distance>
inline
void
__make_heap(_RandomAccessIterator __first,
            _RandomAccessIterator __last, _Tp*, _Distance*)
{
  if (__last - __first < 2) return;
  _Distance __len = __last - __first;
  _Distance __parent = (__len - 2)/2;

  for (;;) {
    __adjust_heap(__first, __parent, __len, _Tp(*(__first + __parent)));
    if (__parent == 0) return;
    __parent--;
  }
}

template <class _RandomAccessIterator>
void
make_heap(_RandomAccessIterator __first, _RandomAccessIterator __last)
{
  __make_heap(__first, __last,
              (typename ::std::iterator_traits< _RandomAccessIterator > ::value_type*)0, (typename ::std::iterator_traits< _RandomAccessIterator > ::difference_type*)0);
}

template <class _RandomAccessIterator, class _Compare,
          class _Tp, class _Distance>
inline
void
__make_heap(_RandomAccessIterator __first, _RandomAccessIterator __last,
            _Compare __comp, _Tp*, _Distance*)
{
  if (__last - __first < 2) return;
  _Distance __len = __last - __first;
  _Distance __parent = (__len - 2)/2;

  for (;;) {
    __adjust_heap(__first, __parent, __len, _Tp(*(__first + __parent)),
                  __comp);
    if (__parent == 0) return;
    __parent--;
  }
}

template <class _RandomAccessIterator, class _Compare>
void
make_heap(_RandomAccessIterator __first,
          _RandomAccessIterator __last, _Compare __comp)
{
  __make_heap(__first, __last, __comp,
              (typename ::std::iterator_traits< _RandomAccessIterator > ::value_type*)0, (typename ::std::iterator_traits< _RandomAccessIterator > ::difference_type*)0);
}

}


// Local Variables:
// mode:C++
// End:


// Local Variables:
// mode:C++
// End:




namespace std {

// for_each.  Apply a function to every element of a range.
template <class _InputIter, class _Function>
inline _Function
for_each(_InputIter __first, _InputIter __last, _Function __f) {
  for ( ; __first != __last; ++__first)
    __f(*__first);
  return __f;
}

// count_if
template <class _InputIter, class _Predicate>
inline typename iterator_traits<_InputIter> ::difference_type
count_if(_InputIter __first, _InputIter __last, _Predicate __pred) {
  
  typename iterator_traits<_InputIter> ::difference_type __n = 0;
  for ( ; __first != __last; ++__first) {
    if (__pred(*__first))
      ++__n;
  }
  return __n;
}

// adjacent_find.

template <class _ForwardIter, class _BinaryPredicate>
inline _ForwardIter
adjacent_find(_ForwardIter __first, _ForwardIter __last,
              _BinaryPredicate __binary_pred) {
  
  if (__first == __last)
    return __last;
  _ForwardIter __next = __first;
  while(++__next != __last) {
    if (__binary_pred(*__first, *__next))
      return __first;
    __first = __next;
  }
  return __last;
}

template <class _ForwardIter>
inline _ForwardIter
adjacent_find(_ForwardIter __first, _ForwardIter __last) {
  return adjacent_find(__first, __last,
                       ::std::priv:: __equal_to((typename ::std::iterator_traits< _ForwardIter > ::value_type*)0));
}

template <class _InputIter, class _Tp, class _Size>
inline void
count(_InputIter __first, _InputIter __last, const _Tp& __val, _Size& __n) {
  
    for ( ; __first != __last; ++__first)
      if (*__first == __val)
        ++__n;
}

template <class _InputIter, class _Predicate, class _Size>
inline void
count_if(_InputIter __first, _InputIter __last, _Predicate __pred, _Size& __n) {
  
  for ( ; __first != __last; ++__first)
    if (__pred(*__first))
      ++__n;
}

template <class _ForwardIter1, class _ForwardIter2>
_ForwardIter1 search(_ForwardIter1 __first1, _ForwardIter1 __last1,
                     _ForwardIter2 __first2, _ForwardIter2 __last2);

// search_n.  Search for __count consecutive copies of __val.
template <class _ForwardIter, class _Integer, class _Tp>
_ForwardIter search_n(_ForwardIter __first, _ForwardIter __last,
                      _Integer __count, const _Tp& __val);
template <class _ForwardIter, class _Integer, class _Tp, class _BinaryPred>
_ForwardIter search_n(_ForwardIter __first, _ForwardIter __last,
                      _Integer __count, const _Tp& __val, _BinaryPred __binary_pred);

template <class _InputIter, class _ForwardIter>
inline _InputIter find_first_of(_InputIter __first1, _InputIter __last1,
                                _ForwardIter __first2, _ForwardIter __last2) {
  
  
  return ::std::priv:: __find_first_of(__first1, __last1, __first2, __last2);
}

template <class _InputIter, class _ForwardIter, class _BinaryPredicate>
inline _InputIter
find_first_of(_InputIter __first1, _InputIter __last1,
              _ForwardIter __first2, _ForwardIter __last2, _BinaryPredicate __comp) {
  
  
  return ::std::priv:: __find_first_of(__first1, __last1, __first2, __last2, __comp);
}

template <class _ForwardIter1, class _ForwardIter2>
_ForwardIter1
find_end(_ForwardIter1 __first1, _ForwardIter1 __last1,
         _ForwardIter2 __first2, _ForwardIter2 __last2);

// swap_ranges
template <class _ForwardIter1, class _ForwardIter2>
inline _ForwardIter2
swap_ranges(_ForwardIter1 __first1, _ForwardIter1 __last1, _ForwardIter2 __first2) {
  
  for ( ; __first1 != __last1; ++__first1, ++__first2)
    iter_swap(__first1, __first2);
  return __first2;
}

// transform
template <class _InputIter, class _OutputIter, class _UnaryOperation>
inline _OutputIter
transform(_InputIter __first, _InputIter __last, _OutputIter __result, _UnaryOperation __opr) {
  
  for ( ; __first != __last; ++__first, ++__result)
    *__result = __opr(*__first);
  return __result;
}
template <class _InputIter1, class _InputIter2, class _OutputIter, class _BinaryOperation>
inline _OutputIter
transform(_InputIter1 __first1, _InputIter1 __last1,
          _InputIter2 __first2, _OutputIter __result,_BinaryOperation __binary_op) {
  
  for ( ; __first1 != __last1; ++__first1, ++__first2, ++__result)
    *__result = __binary_op(*__first1, *__first2);
  return __result;
}

// replace_if, replace_copy, replace_copy_if

template <class _ForwardIter, class _Predicate, class _Tp>
inline void
replace_if(_ForwardIter __first, _ForwardIter __last, _Predicate __pred, const _Tp& __new_value) {
  
  for ( ; __first != __last; ++__first)
    if (__pred(*__first))
      *__first = __new_value;
}

template <class _InputIter, class _OutputIter, class _Tp>
inline  _OutputIter
replace_copy(_InputIter __first, _InputIter __last,_OutputIter __result,
             const _Tp& __old_value, const _Tp& __new_value) {
  
  for ( ; __first != __last; ++__first, ++__result)
    *__result = *__first == __old_value ? __new_value : *__first;
  return __result;
}

template <class _Iterator, class _OutputIter, class _Predicate, class _Tp>
inline _OutputIter
replace_copy_if(_Iterator __first, _Iterator __last,
                _OutputIter __result,
                _Predicate __pred, const _Tp& __new_value) {
  
  for ( ; __first != __last; ++__first, ++__result)
    *__result = __pred(*__first) ? __new_value : *__first;
  return __result;
}

// generate and generate_n

template <class _ForwardIter, class _Generator>
inline void
generate(_ForwardIter __first, _ForwardIter __last, _Generator __gen) {
  
  for ( ; __first != __last; ++__first)
    *__first = __gen();
}

template <class _OutputIter, class _Size, class _Generator>
inline void
generate_n(_OutputIter __first, _Size __n, _Generator __gen) {
  for ( ; __n > 0; --__n, ++__first)
    *__first = __gen();
}

// remove, remove_if, remove_copy, remove_copy_if

template <class _InputIter, class _OutputIter, class _Tp>
inline _OutputIter
remove_copy(_InputIter __first, _InputIter __last,_OutputIter __result, const _Tp& __val) {
  
  for ( ; __first != __last; ++__first) {
    if (!(*__first == __val)) {
      *__result = *__first;
      ++__result;
    }
  }
  return __result;
}

template <class _InputIter, class _OutputIter, class _Predicate>
inline _OutputIter
remove_copy_if(_InputIter __first, _InputIter __last, _OutputIter __result, _Predicate __pred) {
  
  for ( ; __first != __last; ++__first) {
    if (!__pred(*__first)) {
      *__result = *__first;
      ++__result;
    }
  }
  return __result;
}

template <class _ForwardIter, class _Tp>
inline _ForwardIter
remove(_ForwardIter __first, _ForwardIter __last, const _Tp& __val) {
  
  __first = find(__first, __last, __val);
  if (__first == __last)
    return __first;
  else {
    _ForwardIter __next = __first;
    return remove_copy(++__next, __last, __first, __val);
  }
}

template <class _ForwardIter, class _Predicate>
inline _ForwardIter
remove_if(_ForwardIter __first, _ForwardIter __last, _Predicate __pred) {
  
  __first = find_if(__first, __last, __pred);
  if ( __first == __last )
    return __first;
  else {
    _ForwardIter __next = __first;
    return remove_copy_if(++__next, __last, __first, __pred);
  }
}

// unique and unique_copy
template <class _InputIter, class _OutputIter>
_OutputIter unique_copy(_InputIter __first, _InputIter __last, _OutputIter __result);

template <class _InputIter, class _OutputIter, class _BinaryPredicate>
_OutputIter unique_copy(_InputIter __first, _InputIter __last,_OutputIter __result,
                        _BinaryPredicate __binary_pred);

template <class _ForwardIter>
inline _ForwardIter unique(_ForwardIter __first, _ForwardIter __last) {
     /* STLport's stock implementation requires operator== be const */
    if (__first == __last) return __last;
    _ForwardIter res = __first;
    while (++__first != __last)
    {
        /* Operator== required, operator!= is not */
        if (!(*res == *__first))
        {
            res++;
            *(res) = *__first;
        }
    }
    res++;
    return res;
}

template <class _ForwardIter, class _BinaryPredicate>
inline _ForwardIter unique(_ForwardIter __first, _ForwardIter __last,
                           _BinaryPredicate __binary_pred) {
    /* STLport's stock implementation calls __binary_pred too many times. */
    if (__first == __last) return __last;
    _ForwardIter res = __first;
    while (++__first != __last)
    {
        if (!__binary_pred(*res, *__first))
        {
            res++;
            *(res) = *__first;
        }
    }
    res++;
    return res;
}

// reverse and reverse_copy, and their auxiliary functions

namespace priv {

template <class _BidirectionalIter>
inline void
__reverse(_BidirectionalIter __first, _BidirectionalIter __last, const bidirectional_iterator_tag &) {
  for (; __first != __last && __first != --__last; ++__first)
    ::std::iter_swap(__first,__last);
}

template <class _RandomAccessIter>
inline void
__reverse(_RandomAccessIter __first, _RandomAccessIter __last, const random_access_iterator_tag &) {
  for (; __first < __last; ++__first)
    ::std::iter_swap(__first, --__last);
}

}

template <class _BidirectionalIter>
inline void
reverse(_BidirectionalIter __first, _BidirectionalIter __last) {
  
  ::std::priv:: __reverse(__first, __last, typename ::std::iterator_traits< _BidirectionalIter > ::iterator_category());
}

template <class _BidirectionalIter, class _OutputIter>
inline
_OutputIter reverse_copy(_BidirectionalIter __first,
                         _BidirectionalIter __last,
                         _OutputIter __result) {
  
  while (__first != __last) {
    --__last;
    *__result = *__last;
    ++__result;
  }
  return __result;
}

template <class _ForwardIter>
void rotate(_ForwardIter __first, _ForwardIter __middle, _ForwardIter __last);

template <class _ForwardIter, class _OutputIter>
inline _OutputIter rotate_copy(_ForwardIter __first, _ForwardIter __middle,
                               _ForwardIter __last, _OutputIter __result) {
  return ::std::copy(__first, __middle, copy(__middle, __last, __result));
}

// random_shuffle

template <class _RandomAccessIter>
void random_shuffle(_RandomAccessIter __first, _RandomAccessIter __last);

template <class _RandomAccessIter, class _RandomNumberGenerator>
void random_shuffle(_RandomAccessIter __first, _RandomAccessIter __last,
                    _RandomNumberGenerator& __rand);

// random_sample and random_sample_n (extensions, not part of the standard).

template <class _ForwardIter, class _OutputIter, class _Distance>
_OutputIter random_sample_n(_ForwardIter __first, _ForwardIter __last,
                            _OutputIter __out_ite, const _Distance __n);

template <class _ForwardIter, class _OutputIter, class _Distance,
          class _RandomNumberGenerator>
_OutputIter random_sample_n(_ForwardIter __first, _ForwardIter __last,
                            _OutputIter __out_ite, const _Distance __n,
                            _RandomNumberGenerator& __rand);

template <class _InputIter, class _RandomAccessIter>
_RandomAccessIter
random_sample(_InputIter __first, _InputIter __last,
              _RandomAccessIter __out_first, _RandomAccessIter __out_last);

template <class _InputIter, class _RandomAccessIter,
          class _RandomNumberGenerator>
_RandomAccessIter
random_sample(_InputIter __first, _InputIter __last,
              _RandomAccessIter __out_first, _RandomAccessIter __out_last,
              _RandomNumberGenerator& __rand);


// partition, stable_partition, and their auxiliary functions

template <class _ForwardIter, class _Predicate>
_ForwardIter partition(_ForwardIter __first, _ForwardIter __last, _Predicate   __pred);

template <class _ForwardIter, class _Predicate>
_ForwardIter
stable_partition(_ForwardIter __first, _ForwardIter __last, _Predicate __pred);

// sort() and its auxiliary functions.
namespace priv {

template <class _Size>
inline _Size __lg(_Size __n) {
  _Size __k;
  for (__k = 0; __n != 1; __n >>= 1) ++__k;
  return __k;
}

}

template <class _RandomAccessIter>
void sort(_RandomAccessIter __first, _RandomAccessIter __last);
template <class _RandomAccessIter, class _Compare>
void sort(_RandomAccessIter __first, _RandomAccessIter __last, _Compare __comp);

// stable_sort() and its auxiliary functions.
template <class _RandomAccessIter>
void stable_sort(_RandomAccessIter __first,
                 _RandomAccessIter __last);

template <class _RandomAccessIter, class _Compare>
void stable_sort(_RandomAccessIter __first,
                 _RandomAccessIter __last, _Compare __comp);

// partial_sort, partial_sort_copy, and auxiliary functions.

template <class _RandomAccessIter>
void partial_sort(_RandomAccessIter __first, _RandomAccessIter __middle,
                  _RandomAccessIter __last);

template <class _RandomAccessIter, class _Compare>
void partial_sort(_RandomAccessIter __first,_RandomAccessIter __middle,
                  _RandomAccessIter __last, _Compare __comp);

template <class _InputIter, class _RandomAccessIter>
_RandomAccessIter
partial_sort_copy(_InputIter __first, _InputIter __last,
                  _RandomAccessIter __result_first, _RandomAccessIter __result_last);

template <class _InputIter, class _RandomAccessIter, class _Compare>
_RandomAccessIter
partial_sort_copy(_InputIter __first, _InputIter __last,
                  _RandomAccessIter __result_first,
                  _RandomAccessIter __result_last, _Compare __comp);

// nth_element() and its auxiliary functions.
template <class _RandomAccessIter>
void nth_element(_RandomAccessIter __first, _RandomAccessIter __nth,
                 _RandomAccessIter __last);

template <class _RandomAccessIter, class _Compare>
void nth_element(_RandomAccessIter __first, _RandomAccessIter __nth,
                 _RandomAccessIter __last, _Compare __comp);

// auxiliary class for lower_bound, etc.
namespace priv {

template <class _T1, class _T2>
struct __less_2 {
  bool operator() (const _T1& __x, const _T2& __y) const { return __x < __y ; }
};

template <class _T1, class _T2>
__less_2<_T1,_T2> __less2(_T1*, _T2* ) { return __less_2<_T1, _T2>(); }


}

// Binary search (lower_bound, upper_bound, equal_range, binary_search).
template <class _ForwardIter, class _Tp>
inline _ForwardIter lower_bound(_ForwardIter __first, _ForwardIter __last,
                                   const _Tp& __val) {
  
  return ::std::priv:: __lower_bound(__first, __last, __val,
                                  ::std::priv:: __less2((typename ::std::iterator_traits< _ForwardIter > ::value_type*)0, (_Tp*)0),
                                  ::std::priv:: __less2((_Tp*)0, (typename ::std::iterator_traits< _ForwardIter > ::value_type*)0),
                                  (typename ::std::iterator_traits< _ForwardIter > ::difference_type*)0);
}

template <class _ForwardIter, class _Tp, class _Compare>
inline _ForwardIter lower_bound(_ForwardIter __first, _ForwardIter __last,
                                const _Tp& __val, _Compare __comp) {
  
  return ::std::priv:: __lower_bound(__first, __last, __val, __comp, __comp,
                                  (typename ::std::iterator_traits< _ForwardIter > ::difference_type*)0);
}

namespace priv {

template <class _ForwardIter, class _Tp, class _Compare1, class _Compare2, class _Distance>
_ForwardIter __upper_bound(_ForwardIter __first, _ForwardIter __last, const _Tp& __val,
                           _Compare1 __comp1, _Compare2 __comp2, _Distance*);

}

template <class _ForwardIter, class _Tp>
inline _ForwardIter upper_bound(_ForwardIter __first, _ForwardIter __last,
                                const _Tp& __val) {
  
  return ::std::priv:: __upper_bound(__first, __last, __val,
                                  ::std::priv:: __less2((typename ::std::iterator_traits< _ForwardIter > ::value_type*)0, (_Tp*)0),
                                  ::std::priv:: __less2((_Tp*)0, (typename ::std::iterator_traits< _ForwardIter > ::value_type*)0),
                                  (typename ::std::iterator_traits< _ForwardIter > ::difference_type*)0);
}

template <class _ForwardIter, class _Tp, class _Compare>
inline _ForwardIter upper_bound(_ForwardIter __first, _ForwardIter __last,
                                const _Tp& __val, _Compare __comp) {
  
  return ::std::priv:: __upper_bound(__first, __last, __val, __comp, __comp,
                                  (typename ::std::iterator_traits< _ForwardIter > ::difference_type*)0);
}

namespace priv {

template <class _ForwardIter, class _Tp, class _Compare1, class _Compare2, class _Distance>
pair<_ForwardIter, _ForwardIter>
__equal_range(_ForwardIter __first, _ForwardIter __last, const _Tp& __val,
              _Compare1 __comp1, _Compare2 __comp2, _Distance*);

}

template <class _ForwardIter, class _Tp>
inline pair<_ForwardIter, _ForwardIter>
equal_range(_ForwardIter __first, _ForwardIter __last, const _Tp& __val) {
  
  return ::std::priv:: __equal_range(__first, __last, __val,
                                  ::std::priv:: __less2((typename ::std::iterator_traits< _ForwardIter > ::value_type*)0, (_Tp*)0),
                                  ::std::priv:: __less2((_Tp*)0, (typename ::std::iterator_traits< _ForwardIter > ::value_type*)0),
                                  (typename ::std::iterator_traits< _ForwardIter > ::difference_type*)0);
}

template <class _ForwardIter, class _Tp, class _Compare>
inline pair<_ForwardIter, _ForwardIter>
equal_range(_ForwardIter __first, _ForwardIter __last, const _Tp& __val,
            _Compare __comp) {
  
  return ::std::priv:: __equal_range(__first, __last, __val, __comp, __comp,
                                  (typename ::std::iterator_traits< _ForwardIter > ::difference_type*)0);
}

template <class _ForwardIter, class _Tp>
inline bool binary_search(_ForwardIter __first, _ForwardIter __last,
                   const _Tp& __val) {
  
  _ForwardIter __i = ::std::priv:: __lower_bound(__first, __last, __val,
                                              ::std::priv:: __less2((typename ::std::iterator_traits< _ForwardIter > ::value_type*)0, (_Tp*)0),
                                              ::std::priv:: __less2((_Tp*)0, (typename ::std::iterator_traits< _ForwardIter > ::value_type*)0),
                                              (typename ::std::iterator_traits< _ForwardIter > ::difference_type*)0);
  return __i != __last && !(__val < *__i);
}

template <class _ForwardIter, class _Tp, class _Compare>
inline bool binary_search(_ForwardIter __first, _ForwardIter __last,
                          const _Tp& __val,
                          _Compare __comp) {
  
  _ForwardIter __i = ::std::priv:: __lower_bound(__first, __last, __val, __comp, __comp,
                                              (typename ::std::iterator_traits< _ForwardIter > ::difference_type*)0);
  return __i != __last && !__comp(__val, *__i);
}

// merge, with and without an explicitly supplied comparison function.

template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter merge(_InputIter1 __first1, _InputIter1 __last1,
                  _InputIter2 __first2, _InputIter2 __last2,
                  _OutputIter __result);

template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter merge(_InputIter1 __first1, _InputIter1 __last1,
                  _InputIter2 __first2, _InputIter2 __last2,
                  _OutputIter __result, _Compare __comp);


// inplace_merge and its auxiliary functions.


template <class _BidirectionalIter>
void inplace_merge(_BidirectionalIter __first,
                   _BidirectionalIter __middle,
                   _BidirectionalIter __last) ;

template <class _BidirectionalIter, class _Compare>
void inplace_merge(_BidirectionalIter __first,
                   _BidirectionalIter __middle,
                   _BidirectionalIter __last, _Compare __comp);

// Set algorithms: includes, set_union, set_intersection, set_difference,
// set_symmetric_difference.  All of these algorithms have the precondition
// that their input ranges are sorted and the postcondition that their output
// ranges are sorted.

template <class _InputIter1, class _InputIter2>
bool includes(_InputIter1 __first1, _InputIter1 __last1,
              _InputIter2 __first2, _InputIter2 __last2);

template <class _InputIter1, class _InputIter2, class _Compare>
bool includes(_InputIter1 __first1, _InputIter1 __last1,
              _InputIter2 __first2, _InputIter2 __last2, _Compare __comp);

template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter set_union(_InputIter1 __first1, _InputIter1 __last1,
                      _InputIter2 __first2, _InputIter2 __last2,
                      _OutputIter __result);

template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter set_union(_InputIter1 __first1, _InputIter1 __last1,
                      _InputIter2 __first2, _InputIter2 __last2,
                      _OutputIter __result, _Compare __comp);

template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter set_intersection(_InputIter1 __first1, _InputIter1 __last1,
                             _InputIter2 __first2, _InputIter2 __last2,
                             _OutputIter __result);

template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter set_intersection(_InputIter1 __first1, _InputIter1 __last1,
                             _InputIter2 __first2, _InputIter2 __last2,
                             _OutputIter __result, _Compare __comp);



template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter set_difference(_InputIter1 __first1, _InputIter1 __last1,
                           _InputIter2 __first2, _InputIter2 __last2,
                           _OutputIter __result);

template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter set_difference(_InputIter1 __first1, _InputIter1 __last1,
                           _InputIter2 __first2, _InputIter2 __last2,
                           _OutputIter __result, _Compare __comp);

template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter
set_symmetric_difference(_InputIter1 __first1, _InputIter1 __last1,
                         _InputIter2 __first2, _InputIter2 __last2,
                         _OutputIter __result);


template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter
set_symmetric_difference(_InputIter1 __first1, _InputIter1 __last1,
                         _InputIter2 __first2, _InputIter2 __last2,
                         _OutputIter __result,
                         _Compare __comp);


// min_element and max_element, with and without an explicitly supplied
// comparison function.

template <class _ForwardIter>
_ForwardIter max_element(_ForwardIter __first, _ForwardIter __last);
template <class _ForwardIter, class _Compare>
_ForwardIter max_element(_ForwardIter __first, _ForwardIter __last,
                            _Compare __comp);

template <class _ForwardIter>
_ForwardIter min_element(_ForwardIter __first, _ForwardIter __last);

template <class _ForwardIter, class _Compare>
_ForwardIter min_element(_ForwardIter __first, _ForwardIter __last,
                            _Compare __comp);

// next_permutation and prev_permutation, with and without an explicitly
// supplied comparison function.

template <class _BidirectionalIter>
bool next_permutation(_BidirectionalIter __first, _BidirectionalIter __last);

template <class _BidirectionalIter, class _Compare>
bool next_permutation(_BidirectionalIter __first, _BidirectionalIter __last,
                      _Compare __comp);


template <class _BidirectionalIter>
bool prev_permutation(_BidirectionalIter __first, _BidirectionalIter __last);


template <class _BidirectionalIter, class _Compare>
bool prev_permutation(_BidirectionalIter __first, _BidirectionalIter __last,
                      _Compare __comp);

// is_heap, a predicate testing whether or not a range is
// a heap.  This function is an extension, not part of the C++
// standard.

template <class _RandomAccessIter>
bool is_heap(_RandomAccessIter __first, _RandomAccessIter __last);

template <class _RandomAccessIter, class _StrictWeakOrdering>
bool is_heap(_RandomAccessIter __first, _RandomAccessIter __last,
             _StrictWeakOrdering __comp);

// is_sorted, a predicated testing whether a range is sorted in
// nondescending order.  This is an extension, not part of the C++
// standard.
namespace priv {

template <class _ForwardIter, class _StrictWeakOrdering>
bool __is_sorted(_ForwardIter __first, _ForwardIter __last,
                 _StrictWeakOrdering __comp);

}
template <class _ForwardIter>
inline bool is_sorted(_ForwardIter __first, _ForwardIter __last) {
  return ::std::priv:: __is_sorted(__first, __last,
                                ::std::priv:: __less((typename ::std::iterator_traits< _ForwardIter > ::value_type*)0));
}

template <class _ForwardIter, class _StrictWeakOrdering>
inline bool is_sorted(_ForwardIter __first, _ForwardIter __last,
                      _StrictWeakOrdering __comp) {
  return ::std::priv:: __is_sorted(__first, __last, __comp);
}

}

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */



/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

/* NOTE: This is an internal header file, included by other STL headers.
 *   You should not attempt to use it directly.
 */




/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

/* NOTE: This is an internal header file, included by other STL headers.
 *   You should not attempt to use it directly.
 */




/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

/* NOTE: This is an internal header file, included by other STL headers.
 *   You should not attempt to use it directly.
 */



/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */




// eMbedded Visual C++ .NET unfortunately uses _INC_NEW for both <new.h> and <new>
// we undefine the symbol to get the stuff in the SDK's <new>


/******************************************************************************
*                                                             \  ___  /       *
* Edison Design Group C++ Runtime                               /   \         *
*                                                            - | \^/ | -      *
* Copyright 1992-2011 Edison Design Group, Inc.                 \   /         *
*                                                             /  | |  \       *
*                                                                [_]          *
*                                                                             *
******************************************************************************/
/*
Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all source code forms.  The name of Edison Design
Group, Inc. may not be used to endorse or promote products derived
from this software without specific prior written permission.
THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
Any use of this software is at the user's own risk.
*/
/*
new -- Include file for C++ default operator new (see ARM 12.5).
*/


/*****************************************************************************/
/* stddef.h   v16.12.0                                                       */
/*                                                                           */
/* Copyright (c) 1993-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


using std::ptrdiff_t;
using std::size_t;
/*using std::wchar_t;*/

#pragma diag_push
#pragma CHECK_MISRA("-19.15") /* code outside guard; see below comment */

/*-----------------------------------------------------------------------*/
/* Define _win_t, for compiling GCC libraries with the TI compiler.      */
/* GCC's library (newlib) expects wint_t to be defined here, in stddef.h,*/
/* which is arguably incorrect, but we go along for compatibility.       */
/* This is outside the _STDDEF guard in case this file has already       */
/* been included without __need_wint_t.                                  */
/*-----------------------------------------------------------------------*/

#pragma diag_pop
/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 */

// This header exists solely for portability.  Normally it just includes
// the native header <exception>.




/* If we are here it means that we are in an include called 
 * from the native lib which means that we can simply forward this
 * call to the native exception header:
 */
/******************************************************************************
*                                                             \  ___  /       *
* Edison Design Group C++ Runtime                               /   \         *
*                                                            - | \^/ | -      *
* Copyright 1995-2011 Edison Design Group, Inc.                 \   /         *
*                                                             /  | |  \       *
*                                                                [_]          *
*                                                                             *
******************************************************************************/
/*
Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all source code forms.  The name of Edison Design
Group, Inc. may not be used to endorse or promote products derived
from this software without specific prior written permission.
THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
Any use of this software is at the user's own risk.
*/
/*
exception -- Include file for exception handling (see 18.6)
*/

/* This lets users disable the EDG supplied exception classes. */

namespace std {
  class exception {
  public:
    exception() throw();
    exception(const exception&) throw();
    exception& operator=(const exception&) throw();
    virtual ~exception() throw();
    virtual const char* what() const throw();
  };

  /*
  If bool is not supported, use a typedef for bool.
  */
  typedef bool __bool;

  class bad_exception : public exception {
  public:
    bad_exception() throw();
    bad_exception(const bad_exception&) throw();
    bad_exception& operator=(const bad_exception&) throw();
    virtual ~bad_exception() throw();
    virtual const char* what() const throw();
  };

  typedef void (*terminate_handler)();
  extern terminate_handler set_terminate(terminate_handler) throw();

  typedef void (*unexpected_handler)();
  extern unexpected_handler set_unexpected(unexpected_handler) throw();

  /* unexpected and terminate are in the WP definition of exception.h.
     It is not clear why. */
  void terminate();
  void unexpected();

  extern __bool uncaught_exception() throw();

}  /* namespace std */





/******************************************************************************
*                                                             \  ___  /       *
* Edison Design Group C++ Runtime                               /   \         *
*                                                            - | \^/ | -      *
* Copyright 1995-2011 Edison Design Group, Inc.                 \   /         *
*                                                             /  | |  \       *
*                                                                [_]          *
*                                                                             *
******************************************************************************/




// Local Variables:
// mode:C++
// End:

/* If not already defined, define a macro that expands to the namespace
   containing the standard library. */


namespace std {

/* This lets users disable the EDG supplied exception classes. */

  class bad_alloc : public exception {
  public:
    bad_alloc() throw();
    bad_alloc(const bad_alloc&) throw();
    bad_alloc& operator=(const bad_alloc&) throw();
    virtual ~bad_alloc() throw();
    virtual const char* what() const throw();
  };


  typedef void (*new_handler)();
  new_handler set_new_handler(new_handler) throw();
  struct nothrow_t { };
  // Declaration of object nothrow to permit the use of the placement new
  // syntax: new (nothrow) T;
  const nothrow_t nothrow = {};

}  /* namespace std */



/* Normal operator new. */
void *operator new(size_t) throw(std::bad_alloc);

/* Normal operator delete. */
void operator delete(void*) throw ();

/* Nothrow version of operator new. */
void *operator new(size_t, const std::nothrow_t&) throw();

/* Nothrow version of operator delete. */
void operator delete(void*, const std::nothrow_t&) throw();

/* Placement new. */
void *operator new(size_t, void*) throw();

/* Placement delete. */
void operator delete(void*, void*) throw();


/* Array new. */
void *operator new[](size_t) throw(std::bad_alloc);

/* Array delete. */
void operator delete[](void*) throw ();

/* Placement array new. */
void *operator new[](size_t, void*) throw();

/* Placement array delete. */
void operator delete[](void*, void*) throw();

/* Nothrow version of array new. */
void *operator new[](size_t,
                     const std::nothrow_t&) throw();

/* Nothrow version of array delete. */
void operator delete[](void*,
                       const std::nothrow_t&) throw();


/******************************************************************************
*                                                             \  ___  /       *
* Edison Design Group C++ Runtime                               /   \         *
*                                                            - | \^/ | -      *
* Copyright 1992-2011 Edison Design Group, Inc.                 \   /         *
*                                                             /  | |  \       *
*                                                                [_]          *
*                                                                             *
******************************************************************************/






namespace std {

inline void*  __stl_new(size_t __n)   { return ::operator new(__n); }
inline void   __stl_delete(void* __p) { ::operator delete(__p); }
}


/*
 * Local Variables:
 * mode:C++
 * End:
 */




namespace std {

template <class _Tp>
inline void __destroy_aux(_Tp* __pointer, const __false_type& /*_Trivial_destructor*/)
{ __pointer->~_Tp(); }

template <class _Tp>
inline void __destroy_aux(_Tp*, const __true_type& /*_Trivial_destructor*/) {}

template <class _Tp>
inline void _Destroy(_Tp* __pointer) {
  typedef typename __type_traits<_Tp>::has_trivial_destructor _Trivial_destructor;
  __destroy_aux(__pointer, _Trivial_destructor());
}

template <class _Tp>
inline void _Destroy_Moved(_Tp* __pointer) {
  typedef typename __move_traits<_Tp>::complete _Trivial_destructor;
  __destroy_aux(__pointer, _Trivial_destructor());
}


template <class _T1>
inline void _Construct_aux (_T1* __p, const __false_type&) {
  new(__p) _T1();
}

template <class _T1>
inline void _Construct_aux (_T1* __p, const __true_type&) {
  // We use binary copying for POD types since it results
  // in a considerably better code at least on MSVC.
  *__p = _T1();
}

template <class _T1>
inline void _Construct(_T1* __p) {
  _Construct_aux (__p, _Is_POD(__p)._Answer());
}

template <class _Tp>
inline void _Copy_Construct_aux(_Tp* __p, const _Tp& __val, const __false_type&) {
  new(__p) _Tp(__val);
}

template <class _Tp>
inline void _Copy_Construct_aux(_Tp* __p, const _Tp& __val, const __true_type&) {
  // We use binary copying for POD types since it results
  // in a considerably better code at least on MSVC.
  *__p = __val;
}

template <class _Tp>
inline void _Copy_Construct(_Tp* __p, const _Tp& __val) {
  _Copy_Construct_aux(__p, __val, _Is_POD(__p)._Answer());
}

template <class _T1, class _T2>
inline void _Param_Construct_aux(_T1* __p, const _T2& __val, const __false_type&) {
  new(__p) _T1(__val);
}

template <class _T1, class _T2>
inline void _Param_Construct_aux(_T1* __p, const _T2& __val, const __true_type&) {
  // We use binary copying for POD types since it results
  // in a considerably better code at least on MSVC.
  *__p = _T1(__val);
}

template <class _T1, class _T2>
inline void _Param_Construct(_T1* __p, const _T2& __val) {
  _Param_Construct_aux(__p, __val, _Is_POD(__p)._Answer());
}

template <class _T1, class _T2>
inline void _Move_Construct_Aux(_T1* __p, _T2& __val, const __false_type& /*_IsPOD*/) {
  new(__p) _T1(::std::priv:: _AsMoveSource(__val));
}

template <class _T1, class _T2>
inline void _Move_Construct_Aux(_T1* __p, _T2& __val, const __true_type& /*_IsPOD*/) {
  // We use binary copying for POD types since it results
  // in a considerably better code at least on MSVC.
  *__p = _T1(__val);
}

template <class _T1, class _T2>
inline void _Move_Construct(_T1* __p, _T2& __val) {
  _Move_Construct_Aux(__p, __val, _Is_POD(__p)._Answer());
}


template <class _ForwardIterator, class _Tp>
inline void
__destroy_range_aux(_ForwardIterator __first, _ForwardIterator __last, _Tp*, const __false_type& /*_Trivial_destructor*/) {
  for ( ; __first != __last; ++__first) {
    __destroy_aux(&(*__first), __false_type());
  }
}

template <class _ForwardIterator, class _Tp>
inline void
__destroy_range_aux(_ForwardIterator, _ForwardIterator, _Tp*, const __true_type& /*_Trivial_destructor*/) {}

template <class _ForwardIterator, class _Tp>
inline void
__destroy_range(_ForwardIterator __first, _ForwardIterator __last, _Tp *__ptr) {
  typedef typename __type_traits<_Tp>::has_trivial_destructor _Trivial_destructor;
  __destroy_range_aux(__first, __last, __ptr, _Trivial_destructor());
}

template <class _ForwardIterator>
inline void _Destroy_Range(_ForwardIterator __first, _ForwardIterator __last) {
  __destroy_range(__first, __last, (typename ::std::iterator_traits< _ForwardIterator > ::value_type*)0);
}

inline void _Destroy_Range(char*, char*) {}
inline void _Destroy_Range(wchar_t*, wchar_t*) {}
inline void _Destroy_Range(const wchar_t*, const wchar_t*) {}

template <class _ForwardIterator, class _Tp>
inline void
__destroy_mv_srcs(_ForwardIterator __first, _ForwardIterator __last, _Tp *__ptr) {
  typedef typename __move_traits<_Tp>::complete _CompleteMove;
  __destroy_range_aux(__first, __last, __ptr, _CompleteMove());
}

template <class _ForwardIterator>
inline void _Destroy_Moved_Range(_ForwardIterator __first, _ForwardIterator __last)
{ __destroy_mv_srcs(__first, __last, (typename ::std::iterator_traits< _ForwardIterator > ::value_type*)0); }



// --------------------------------------------------
// Old names from the HP STL.

template <class _T1, class _T2>
inline void construct(_T1* __p, const _T2& __val) {_Param_Construct(__p, __val); }
template <class _T1>
inline void construct(_T1* __p) { ::std::_Construct(__p); }
template <class _Tp>
inline void destroy(_Tp* __pointer) {  ::std::_Destroy(__pointer); }
template <class _ForwardIterator>
inline void destroy(_ForwardIterator __first, _ForwardIterator __last) { ::std::_Destroy_Range(__first, __last); }

}


// Local Variables:
// mode:C++
// End:

namespace std {

namespace priv {

// uninitialized_copy

template <class _InputIter, class _OutputIter, class _Distance>
inline _OutputIter __ucopy(_InputIter __first, _InputIter __last,
                           _OutputIter __result, _Distance*) {
  _OutputIter __cur = __result;
   {
    for ( ; __first != __last; ++__first, ++__cur)
      _Param_Construct(&*__cur, *__first);
    return __cur;
  }
  
  
}

template <class _InputIter, class _OutputIter, class _Distance>
inline _OutputIter __ucopy(_InputIter __first, _InputIter __last,
                           _OutputIter __result, const input_iterator_tag &, _Distance* __d)
{ return __ucopy(__first, __last, __result, __d); }


template <class _RandomAccessIter, class _OutputIter, class _Distance>
inline _OutputIter __ucopy(_RandomAccessIter __first, _RandomAccessIter __last,
                           _OutputIter __result, const random_access_iterator_tag &, _Distance*) {
  _OutputIter __cur = __result;
   {
    for (_Distance __n = __last - __first; __n > 0; --__n) {
      _Param_Construct(&*__cur, *__first);
      ++__first;
      ++__cur;
    }
    return __cur;
  }
  
  
}

//Used internaly
template <class _RandomAccessIter, class _OutputIter>
inline _OutputIter __ucopy(_RandomAccessIter __first, _RandomAccessIter __last, _OutputIter __result)
{ return __ucopy(__first, __last, __result, random_access_iterator_tag(), (ptrdiff_t*)0); }

inline void*
__ucopy_trivial(const void* __first, const void* __last, void* __result) {
  //dums: this version can use memcpy (__copy_trivial can't)
  return (__last == __first) ? __result :
    ((char*)memcpy(__result, __first, ((const char*)__last - (const char*)__first))) +
    ((const char*)__last - (const char*)__first);
}

template <class _InputIter, class _OutputIter>
inline _OutputIter __ucopy_ptrs(_InputIter __first, _InputIter __last, _OutputIter __result,
                                const __false_type& /*TrivialUCopy*/)
{ return __ucopy(__first, __last, __result, random_access_iterator_tag(), (ptrdiff_t*)0); }

template <class _InputIter, class _OutputIter>
inline _OutputIter __ucopy_ptrs(_InputIter __first, _InputIter __last, _OutputIter __result,
                                const __true_type& /*TrivialUCopy*/) {
  // we know they all pointers, so this cast is OK
  //  return (_OutputIter)__copy_trivial(&(*__first), &(*__last), &(*__result));
  return (_OutputIter)__ucopy_trivial(__first, __last, __result);
}

template <class _InputIter, class _OutputIter>
inline _OutputIter __ucopy_aux(_InputIter __first, _InputIter __last, _OutputIter __result,
                               const __true_type& /*BothPtrType*/) {
  return __ucopy_ptrs(__first, __last, __result,
                      _UseTrivialUCopy((typename ::std::iterator_traits< _InputIter > ::value_type*)0,
                                       (typename ::std::iterator_traits< _OutputIter > ::value_type*)0)._Answer());
}

template <class _InputIter, class _OutputIter>
inline _OutputIter __ucopy_aux(_InputIter __first, _InputIter __last, _OutputIter __result,
                               const __false_type& /*BothPtrType*/) {
  return __ucopy(__first, __last, __result,
                 typename ::std::iterator_traits< _InputIter > ::iterator_category(),
                 (typename ::std::iterator_traits< _InputIter > ::difference_type*)0);
}

}

template <class _InputIter, class _ForwardIter>
inline _ForwardIter
uninitialized_copy(_InputIter __first, _InputIter __last, _ForwardIter __result)
{ return ::std::priv:: __ucopy_aux(__first, __last, __result, _BothPtrType< _InputIter, _ForwardIter>::_Answer()); }

inline char*
uninitialized_copy(const char* __first, const char* __last, char* __result)
{ return  (char*)::std::priv:: __ucopy_trivial(__first, __last, __result); }

inline wchar_t*
uninitialized_copy(const wchar_t* __first, const wchar_t* __last, wchar_t* __result)
{ return  (wchar_t*)::std::priv:: __ucopy_trivial (__first, __last, __result); }

// uninitialized_copy_n (not part of the C++ standard)
namespace priv {

template <class _InputIter, class _Size, class _ForwardIter>
inline
pair<_InputIter, _ForwardIter>
__ucopy_n(_InputIter __first, _Size __count, _ForwardIter __result,
          const input_iterator_tag &) {
  _ForwardIter __cur = __result;
   {
    for ( ; __count > 0 ; --__count, ++__first, ++__cur)
      _Param_Construct(&*__cur, *__first);
    return pair<_InputIter, _ForwardIter>(__first, __cur);
  }
  
  
}


template <class _RandomAccessIter, class _Size, class _ForwardIter>
inline pair<_RandomAccessIter, _ForwardIter>
__ucopy_n(_RandomAccessIter __first, _Size __count, _ForwardIter __result,
                       const random_access_iterator_tag &) {
  _RandomAccessIter __last = __first + __count;
  return pair<_RandomAccessIter, _ForwardIter>(__last, uninitialized_copy(__first, __last, __result));
}

// This is used internally in <rope> , which is extension itself.
template <class _InputIter, class _Size, class _ForwardIter>
inline pair<_InputIter, _ForwardIter>
__ucopy_n(_InputIter __first, _Size __count, _ForwardIter __result)
{ return ::std::priv:: __ucopy_n(__first, __count, __result, typename ::std::iterator_traits< _InputIter > ::iterator_category()); }


}

template <class _InputIter, class _Size, class _ForwardIter>
inline pair<_InputIter, _ForwardIter>
uninitialized_copy_n(_InputIter __first, _Size __count, _ForwardIter __result)
{ return ::std::priv:: __ucopy_n(__first, __count, __result); }

namespace priv {


template <class _ForwardIter, class _Tp, class _Distance>
inline void __ufill(_ForwardIter __first, _ForwardIter __last, const _Tp& __x, _Distance*) {
  _ForwardIter __cur = __first;
   {
    for ( ; __cur != __last; ++__cur)
      _Param_Construct(&*__cur, __x);
  }
  
}

template <class _ForwardIter, class _Tp, class _Distance>
inline void __ufill(_ForwardIter __first, _ForwardIter __last,
                    const _Tp& __x, const input_iterator_tag &, _Distance* __d)
{ __ufill(__first, __last, __x, __d); }


template <class _ForwardIter, class _Tp, class _Distance>
inline void __ufill(_ForwardIter __first, _ForwardIter __last,
                    const _Tp& __x, const random_access_iterator_tag &, _Distance*) {
  _ForwardIter __cur = __first;
   {
    for (_Distance __n = __last - __first; __n > 0; --__n, ++__cur)
      _Param_Construct(&*__cur, __x);
  }
  
}

}

template <class _ForwardIter, class _Tp>
inline void uninitialized_fill(_ForwardIter __first, _ForwardIter __last,  const _Tp& __x) {
  ::std::priv:: __ufill(__first, __last, __x,
                     typename ::std::iterator_traits< _ForwardIter > ::iterator_category(),
                     (typename ::std::iterator_traits< _ForwardIter > ::difference_type*)0);
}

// Specialization: for one-byte types we can use memset.
inline void uninitialized_fill(unsigned char* __first, unsigned char* __last,
                               const unsigned char& __val) {
  unsigned char __tmp = __val;
  memset(__first, __tmp, __last - __first);
}
inline void uninitialized_fill(signed char* __first, signed char* __last,
                               const signed char& __val) {
  signed char __tmp = __val;
  memset(__first, static_cast<unsigned char>(__tmp), __last - __first);
}
inline void uninitialized_fill(char* __first, char* __last, const char& __val) {
  char __tmp = __val;
  memset(__first, static_cast<unsigned char>(__tmp), __last - __first);
}

namespace priv {

template <class _ForwardIter, class _Size, class _Tp>
inline _ForwardIter __ufill_n(_ForwardIter __first, _Size __n, const _Tp& __x) {
  _ForwardIter __cur = __first;
   {
    for ( ; __n > 0; --__n, ++__cur)
      _Param_Construct(&*__cur, __x);
  }
  
  return __cur;
}

template <class _ForwardIter, class _Size, class _Tp>
inline _ForwardIter __ufill_n(_ForwardIter __first, _Size __n, const _Tp& __x,
                              const input_iterator_tag &)
{ return __ufill_n(__first, __n, __x); }


template <class _ForwardIter, class _Size, class _Tp>
inline _ForwardIter __uninitialized_fill_n(_ForwardIter __first, _Size __n, const _Tp& __x) {
  _ForwardIter __last = __first + __n;
  __ufill(__first, __last, __x, random_access_iterator_tag(), (ptrdiff_t*)0);
  return __last;
}

template <class _ForwardIter, class _Size, class _Tp>
inline _ForwardIter __ufill_n(_ForwardIter __first, _Size __n, const _Tp& __x,
                              const random_access_iterator_tag &)
{ return __uninitialized_fill_n(__first, __n, __x); }

/* __uninitialized_init is an internal algo to init a range with a value
 * built using default constructor. It is only called with pointer as
 * iterator.
 */
template <class _ForwardIter, class _Size, class _Tp>
inline _ForwardIter __uinit_aux_aux(_ForwardIter __first, _Size __n, const _Tp& __val,
                                    const __false_type& /*_HasDefaultZero*/)
{ return __uninitialized_fill_n(__first, __n, __val); }

template <class _ForwardIter, class _Size, class _Tp>
inline _ForwardIter __uinit_aux_aux(_ForwardIter __first, _Size __n, const _Tp& /* __val */,
                                    const __true_type& /*_HasDefaultZero*/) {
  memset((unsigned char*)__first, 0, __n * sizeof(_Tp));
  return __first + __n;
}

template <class _ForwardIter, class _Size, class _Tp>
inline _ForwardIter __uinit_aux(_ForwardIter __first, _Size __n, const _Tp&,
                                const __true_type& /*_TrivialInit*/)
{ return __first + __n; }

template <class _ForwardIter, class _Size, class _Tp>
inline _ForwardIter __uinit_aux(_ForwardIter __first, _Size __n, const _Tp& __val,
                                const __false_type& /*_TrivialInit*/)
{ return __uinit_aux_aux(__first, __n, __val, _HasDefaultZeroValue(__first)._Answer()); }

template <class _ForwardIter, class _Size, class _Tp>
inline _ForwardIter __uninitialized_init(_ForwardIter __first, _Size __n, const _Tp& __val)
{ return __uinit_aux(__first, __n, __val, _UseTrivialInit(__first)._Answer()); }

}

template <class _ForwardIter, class _Size, class _Tp>
inline void
uninitialized_fill_n(_ForwardIter __first, _Size __n, const _Tp& __x)
{ ::std::priv:: __ufill_n(__first, __n, __x, typename ::std::iterator_traits< _ForwardIter > ::iterator_category()); }

// Extensions: __uninitialized_copy_copy, __uninitialized_copy_fill,
// __uninitialized_fill_copy.

// __uninitialized_copy_copy
// Copies [first1, last1) into [result, result + (last1 - first1)), and
//  copies [first2, last2) into
//  [result + (last1 - first1), result + (last1 - first1) + (last2 - first2)).

namespace priv {

template <class _InputIter1, class _InputIter2, class _ForwardIter>
inline _ForwardIter
__uninitialized_copy_copy(_InputIter1 __first1, _InputIter1 __last1,
                          _InputIter2 __first2, _InputIter2 __last2,
                          _ForwardIter __result) {
  _ForwardIter __new_result = uninitialized_copy(__first1, __last1, __result);
   {
    return uninitialized_copy(__first2, __last2, __new_result);
  }
  
  
}

// __uninitialized_fill_copy
// Fills [result, mid) with x, and copies [first, last) into
//  [mid, mid + (last - first)).
template <class _ForwardIter, class _Tp, class _InputIter>
inline _ForwardIter
__uninitialized_fill_copy(_ForwardIter __result, _ForwardIter __mid, const _Tp& __x,
                          _InputIter __first, _InputIter __last) {
  uninitialized_fill(__result, __mid, __x);
   {
    return uninitialized_copy(__first, __last, __mid);
  }
  
  
}

// __uninitialized_copy_fill
// Copies [first1, last1) into [first2, first2 + (last1 - first1)), and
//  fills [first2 + (last1 - first1), last2) with x.
template <class _Iter, class _Tp>
inline void
__uninitialized_copy_fill(_Iter __first1, _Iter __last1, _Iter __first2, _Iter __last2,
                          const _Tp& __x) {
  _Iter __mid2 = uninitialized_copy(__first1, __last1, __first2);
   {
    uninitialized_fill(__mid2, __last2, __x);
  }
  
}

/* __uninitialized_move:
 * This function is used internaly and only with pointers as iterators.
 */
template <class _InputIter, class _ForwardIter, class _TrivialUCpy>
inline _ForwardIter
__uninitialized_move(_InputIter __first, _InputIter __last, _ForwardIter __result,
                     _TrivialUCpy __trivial_ucpy, const __false_type& /*_Movable*/)
{ return __ucopy_ptrs(__first, __last, __result, __trivial_ucpy); }

template <class _InputIter, class _ForwardIter, class _TrivialUCpy>
inline
_ForwardIter
__uninitialized_move(_InputIter __first, _InputIter __last, _ForwardIter __result,
                     _TrivialUCpy , const __true_type& /*_Movable*/) {
  //Move constructor should not throw so we do not need to take care of exceptions here.
  for (ptrdiff_t __n = __last - __first ; __n > 0; --__n) {
    _Move_Construct(&*__result, *__first);
    ++__first; ++__result;
  }
  return __result;
}

}

}


// Local Variables:
// mode:C++
// End:

namespace std {

template <class _Tp>
pair<_Tp*, ptrdiff_t>  
__get_temporary_buffer(ptrdiff_t __len, _Tp*);


template <class _Tp>
inline pair<_Tp*, ptrdiff_t>   get_temporary_buffer(ptrdiff_t __len) {
  return __get_temporary_buffer(__len, (_Tp*) 0);
}

// This overload is not required by the standard; it is an extension.
// It is supported for backward compatibility with the HP STL, and
// because not all compilers support the language feature (explicit
// function template arguments) that is required for the standard
// version of get_temporary_buffer.
template <class _Tp>
inline pair<_Tp*, ptrdiff_t>  
get_temporary_buffer(ptrdiff_t __len, _Tp*) {
  return __get_temporary_buffer(__len, (_Tp*) 0);
}

template <class _Tp>
inline void   return_temporary_buffer(_Tp* __p) {
// SunPro brain damage
  free((char*)__p);
}

template <class _ForwardIterator, class _Tp>
class _Temporary_buffer {
private:
  ptrdiff_t  _M_original_len;
  ptrdiff_t  _M_len;
  _Tp*       _M_buffer;

  void _M_allocate_buffer() {
    _M_original_len = _M_len;
    _M_buffer = 0;

    if (_M_len > (ptrdiff_t)((32767) / sizeof(_Tp)))
      _M_len = (32767) / sizeof(_Tp);

    while (_M_len > 0) {
      _M_buffer = (_Tp*) malloc(_M_len * sizeof(_Tp));
      if (_M_buffer)
        break;
      _M_len /= 2;
    }
  }

  void _M_initialize_buffer(const _Tp&, const __true_type&) {}
  void _M_initialize_buffer(const _Tp& val, const __false_type&) {
    uninitialized_fill_n(_M_buffer, _M_len, val);
  }

public:
  ptrdiff_t size() const { return _M_len; }
  ptrdiff_t requested_size() const { return _M_original_len; }
  _Tp* begin() { return _M_buffer; }
  _Tp* end() { return _M_buffer + _M_len; }

  _Temporary_buffer(_ForwardIterator __first, _ForwardIterator __last) {
    // Workaround for a __type_traits bug in the pre-7.3 compiler.
    typedef typename __type_traits<_Tp>::has_trivial_default_constructor  _Trivial;
     {
      _M_len = ::std::distance(__first, __last);
      _M_allocate_buffer();
      if (_M_len > 0)
        _M_initialize_buffer(*__first, _Trivial());
    }
    
  }

  ~_Temporary_buffer() {
    ::std::_Destroy_Range(_M_buffer, _M_buffer + _M_len);
    free(_M_buffer);
  }

private:
  // Disable copy constructor and assignment operator.
  _Temporary_buffer(const _Temporary_buffer<_ForwardIterator, _Tp>&) {}
  void operator=(const _Temporary_buffer<_ForwardIterator, _Tp>&) {}
};


// Class temporary_buffer is not part of the standard.  It is an extension.

template <class _ForwardIterator,
          class _Tp
                    = typename iterator_traits<_ForwardIterator>::value_type
         >
struct temporary_buffer : public _Temporary_buffer<_ForwardIterator, _Tp>
{
  temporary_buffer(_ForwardIterator __first, _ForwardIterator __last)
    : _Temporary_buffer<_ForwardIterator, _Tp>(__first, __last) {}
  ~temporary_buffer() {}
};


}

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


namespace std {

template <class _Tp>
pair<_Tp*, ptrdiff_t> 
__get_temporary_buffer(ptrdiff_t __len, _Tp*)
{
  if (__len > ptrdiff_t((32767) / sizeof(_Tp)))
    __len = (32767) / sizeof(_Tp);

  while (__len > 0) {
    _Tp* __tmp = (_Tp*) malloc((size_t)__len * sizeof(_Tp));
    if (__tmp != 0)
      return pair<_Tp*, ptrdiff_t>(__tmp, __len);
    __len /= 2;
  }

  return pair<_Tp*, ptrdiff_t>((_Tp*)0, 0);
}
}


// Local Variables:
// mode:C++
// End:


// Local Variables:
// mode:C++
// End:

namespace std {

namespace priv {

template <class _BidirectionalIter, class _Distance, class _Compare>
void __merge_without_buffer(_BidirectionalIter __first,
                            _BidirectionalIter __middle,
                            _BidirectionalIter __last,
                            _Distance __len1, _Distance __len2,
                            _Compare __comp);


template <class _BidirectionalIter1, class _BidirectionalIter2,
          class _BidirectionalIter3, class _Compare>
_BidirectionalIter3 __merge_backward(_BidirectionalIter1 __first1,
                                     _BidirectionalIter1 __last1,
                                     _BidirectionalIter2 __first2,
                                     _BidirectionalIter2 __last2,
                                     _BidirectionalIter3 __result,
                                     _Compare __comp);

template <class _Tp>
inline
const _Tp& __median(const _Tp& __a, const _Tp& __b, const _Tp& __c) {
  if (__a < __b)
    if (__b < __c)
      return __b;
    else if (__a < __c)
      return __c;
    else
      return __a;
  else if (__a < __c)
    return __a;
  else if (__b < __c)
    return __c;
  else
    return __b;
}

template <class _Tp, class _Compare>
inline
const _Tp&
__median(const _Tp& __a, const _Tp& __b, const _Tp& __c, _Compare __comp) {
  if (__comp(__a, __b)) {
    
    if (__comp(__b, __c)) {
      
      return __b;
    }
    else if (__comp(__a, __c)) {
      
      return __c;
    }
    else
      return __a;
  }
  else if (__comp(__a, __c)) {
    
    return __a;
  }
  else if (__comp(__b, __c)) {
    
    return __c;
  }
  else
    return __b;
}

}

template <class _ForwardIter1, class _ForwardIter2>
_ForwardIter1 search(_ForwardIter1 __first1, _ForwardIter1 __last1,
                     _ForwardIter2 __first2, _ForwardIter2 __last2) {
  
  
  // Test for empty ranges
  if (__first1 == __last1 || __first2 == __last2)
    return __first1;

  // Test for a pattern of length 1.
  _ForwardIter2 __p1(__first2);

  if ( ++__p1 == __last2 )
    return find(__first1, __last1, *__first2);

  // General case.

  for ( ; ; ) { // __first1 != __last1 will be checked in find below
    __first1 = find(__first1, __last1, *__first2);
    if (__first1 == __last1)
      return __last1;

    _ForwardIter2 __p = __p1;
    _ForwardIter1 __current = __first1;
    if (++__current == __last1)
      return __last1;

    while (*__current == *__p) {
      if (++__p == __last2)
        return __first1;
      if (++__current == __last1)
        return __last1;
    }

    ++__first1;
  }
}

namespace priv {

template <class _RandomAccessIter, class _Integer, class _Tp,
          class _BinaryPred, class _Distance>
_RandomAccessIter __search_n(_RandomAccessIter __first, _RandomAccessIter __last,
                             _Integer __count, const _Tp& __val, _BinaryPred __pred,
                             _Distance*, const random_access_iterator_tag &)
{
  _Distance __tailSize = __last - __first;
  const _Distance __pattSize = __count;
  const _Distance __skipOffset = __pattSize - 1;
  _RandomAccessIter __backTrack;
  _Distance __remainder, __prevRemainder;

  for ( _RandomAccessIter __lookAhead = __first + __skipOffset; __tailSize >= __pattSize; __lookAhead += __pattSize ) { // the main loop...
    //__lookAhead here is always pointing to the last element of next possible match.
    __tailSize -= __pattSize;

    while ( !__pred(*__lookAhead, __val) ) { // the skip loop...
      if (__tailSize < __pattSize)
        return __last;

      __lookAhead += __pattSize;
      __tailSize -= __pattSize;
    }

    if ( __skipOffset == 0 ) {
      return (__lookAhead - __skipOffset); //Success
    }

    __remainder = __skipOffset;

    for (__backTrack = __lookAhead; __pred(*--__backTrack, __val); ) {
      if (--__remainder == 0)
        return (__lookAhead - __skipOffset); //Success
    }

    if (__remainder > __tailSize)
      return __last; //failure

    __lookAhead += __remainder;
    __tailSize -= __remainder;

    while ( __pred(*__lookAhead, __val) ) {
      __prevRemainder = __remainder;
      __backTrack = __lookAhead;

      do {
        if (--__remainder == 0)
          return (__lookAhead - __skipOffset); //Success
      } while (__pred(*--__backTrack, __val));

      //adjust remainder for next comparison
      __remainder += __pattSize - __prevRemainder;

      if (__remainder > __tailSize)
        return __last; //failure

      __lookAhead += __remainder;
      __tailSize -= __remainder;
    }

    //__lookAhead here is always pointing to the element of the last mismatch.
  }

  return __last; //failure
}

template <class _ForwardIter, class _Integer, class _Tp,
          class _Distance, class _BinaryPred>
_ForwardIter __search_n(_ForwardIter __first, _ForwardIter __last,
                        _Integer __count, const _Tp& __val, _BinaryPred __pred,
                        _Distance*, const forward_iterator_tag &) {
  for (; (__first != __last) && !__pred(*__first, __val); ++__first) {}
  while (__first != __last) {
    _Integer __n = __count - 1;
    _ForwardIter __i = __first;
    ++__i;
    while (__i != __last && __n != 0 && __pred(*__i, __val)) {
      ++__i;
      --__n;
    }
    if (__n == 0)
      return __first;
    else if (__i != __last)
      for (__first = ++__i; (__first != __last) && !__pred(*__first, __val); ++__first) {}
    else
      break;
  }
  return __last;
}

}

// search_n.  Search for __count consecutive copies of __val.
template <class _ForwardIter, class _Integer, class _Tp>
_ForwardIter search_n(_ForwardIter __first, _ForwardIter __last,
                      _Integer __count, const _Tp& __val) {
  
  if (__count <= 0)
    return __first;
  if (__count == 1)
    //We use find when __count == 1 to use potential find overload.
    return find(__first, __last, __val);
  return ::std::priv:: __search_n(__first, __last, __count, __val, equal_to<_Tp>(),
                               (typename ::std::iterator_traits< _ForwardIter > ::difference_type*)0,
                               typename ::std::iterator_traits< _ForwardIter > ::iterator_category());
}

template <class _ForwardIter, class _Integer, class _Tp, class _BinaryPred>
_ForwardIter search_n(_ForwardIter __first, _ForwardIter __last,
                      _Integer __count, const _Tp& __val,
                      _BinaryPred __binary_pred) {
  
  if (__count <= 0)
    return __first;
  return ::std::priv:: __search_n(__first, __last, __count, __val, __binary_pred,
                               (typename ::std::iterator_traits< _ForwardIter > ::difference_type*)0,
                               typename ::std::iterator_traits< _ForwardIter > ::iterator_category());
}

template <class _ForwardIter1, class _ForwardIter2>
_ForwardIter1
find_end(_ForwardIter1 __first1, _ForwardIter1 __last1,
         _ForwardIter2 __first2, _ForwardIter2 __last2) {
  
  
  return ::std::priv:: __find_end(__first1, __last1, __first2, __last2,
                               typename ::std::iterator_traits< _ForwardIter1 > ::iterator_category(),
                               typename ::std::iterator_traits< _ForwardIter2 > ::iterator_category(),
                               ::std::priv:: __equal_to((typename ::std::iterator_traits< _ForwardIter1 > ::value_type*)0)
    );
}

// unique and unique_copy
namespace priv {

template <class _InputIterator, class _OutputIterator, class _BinaryPredicate,
          class _Tp>
inline _OutputIterator
__unique_copy(_InputIterator __first, _InputIterator __last,
              _OutputIterator __result,
              _BinaryPredicate __binary_pred, _Tp*) {
  _Tp __val = *__first;
  *__result = __val;
  while (++__first != __last)
    if (!__binary_pred(__val, *__first)) {
      __val = *__first;
      *++__result = __val;
    }
  return ++__result;
}

template <class _InputIter, class _OutputIter, class _BinaryPredicate>
inline _OutputIter
__unique_copy(_InputIter __first, _InputIter __last,_OutputIter __result,
              _BinaryPredicate __binary_pred, const output_iterator_tag &) {
  return ::std::priv:: __unique_copy(__first, __last, __result, __binary_pred,
                                  (typename ::std::iterator_traits< _InputIter > ::value_type*)0);
}

template <class _InputIter, class _ForwardIter, class _BinaryPredicate>
inline _ForwardIter
__unique_copy(_InputIter __first, _InputIter __last, _ForwardIter __result,
              _BinaryPredicate __binary_pred, const forward_iterator_tag &) {
  *__result = *__first;
  while (++__first != __last)
    if (!__binary_pred(*__result, *__first)) *++__result = *__first;
  return ++__result;
}


}

template <class _InputIter, class _OutputIter>
_OutputIter
unique_copy(_InputIter __first, _InputIter __last, _OutputIter __result) {
  
  if (__first == __last) return __result;
  return ::std::priv:: __unique_copy(__first, __last, __result,
                                  ::std::priv:: __equal_to((typename ::std::iterator_traits< _InputIter > ::value_type*)0),
                                  typename ::std::iterator_traits< _OutputIter > ::iterator_category());
}

template <class _InputIter, class _OutputIter, class _BinaryPredicate>
_OutputIter
unique_copy(_InputIter __first, _InputIter __last,_OutputIter __result,
            _BinaryPredicate __binary_pred) {
  
  if (__first == __last) return __result;
  return ::std::priv:: __unique_copy(__first, __last, __result, __binary_pred,
                                  typename ::std::iterator_traits< _OutputIter > ::iterator_category());
}

// rotate and rotate_copy, and their auxiliary functions
namespace priv {

template <class _ForwardIter, class _Distance>
_ForwardIter __rotate_aux(_ForwardIter __first,
                          _ForwardIter __middle,
                          _ForwardIter __last,
                          _Distance*,
                          const forward_iterator_tag &) {
  if (__first == __middle)
    return __last;
  if (__last  == __middle)
    return __first;

  _ForwardIter __first2 = __middle;
  do {
    ::std::swap(*__first++, *__first2++);
    if (__first == __middle)
      __middle = __first2;
  } while (__first2 != __last);

  _ForwardIter __new_middle = __first;

  __first2 = __middle;

  while (__first2 != __last) {
    ::std::swap (*__first++, *__first2++);
    if (__first == __middle)
      __middle = __first2;
    else if (__first2 == __last)
      __first2 = __middle;
  }

  return __new_middle;
}

template <class _BidirectionalIter, class _Distance>
_BidirectionalIter __rotate_aux(_BidirectionalIter __first,
                                _BidirectionalIter __middle,
                                _BidirectionalIter __last,
                                _Distance*,
                                const bidirectional_iterator_tag &) {
  if (__first == __middle)
    return __last;
  if (__last  == __middle)
    return __first;

  ::std::priv:: __reverse(__first,  __middle, bidirectional_iterator_tag());
  ::std::priv:: __reverse(__middle, __last,   bidirectional_iterator_tag());

  while (__first != __middle && __middle != __last)
    ::std::swap(*__first++, *--__last);

  if (__first == __middle) {
    ::std::priv:: __reverse(__middle, __last,   bidirectional_iterator_tag());
    return __last;
  }
  else {
    ::std::priv:: __reverse(__first,  __middle, bidirectional_iterator_tag());
    return __first;
  }
}

// rotate and rotate_copy, and their auxiliary functions
template <class _EuclideanRingElement>
inline
_EuclideanRingElement __gcd(_EuclideanRingElement __m,
                            _EuclideanRingElement __n) {
  while (__n != 0) {
    _EuclideanRingElement __t = __m % __n;
    __m = __n;
    __n = __t;
  }
  return __m;
}

template <class _RandomAccessIter, class _Distance, class _Tp>
_RandomAccessIter __rotate_aux(_RandomAccessIter __first,
                               _RandomAccessIter __middle,
                               _RandomAccessIter __last,
                               _Distance *, _Tp *) {

  _Distance __n = __last   - __first;
  _Distance __k = __middle - __first;
  _Distance __l = __n - __k;
  _RandomAccessIter __result = __first + (__last - __middle);

  if (__k == 0)  /* __first == middle */
    return __last;

  if (__k == __l) {
    ::std::swap_ranges(__first, __middle, __middle);
    return __result;
  }

  _Distance __d = ::std::priv:: __gcd(__n, __k);

  for (_Distance __i = 0; __i < __d; __i++) {
    _Tp __tmp = *__first;
    _RandomAccessIter __p = __first;

    if (__k < __l) {
      for (_Distance __j = 0; __j < __l/__d; __j++) {
        if (__p > __first + __l) {
          *__p = *(__p - __l);
          __p -= __l;
        }

        *__p = *(__p + __k);
        __p += __k;
      }
    }

    else {
      for (_Distance __j = 0; __j < __k/__d - 1; __j ++) {
        if (__p < __last - __k) {
          *__p = *(__p + __k);
          __p += __k;
        }

        *__p = * (__p - __l);
        __p -= __l;
      }
    }

    *__p = __tmp;
    ++__first;
  }

  return __result;
}

template <class _RandomAccessIter, class _Distance>
inline _RandomAccessIter
__rotate_aux(_RandomAccessIter __first, _RandomAccessIter __middle, _RandomAccessIter __last,
             _Distance * __dis, const random_access_iterator_tag &) {
  return ::std::priv:: __rotate_aux(__first, __middle, __last,
                                 __dis, (typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0);
}

template <class _ForwardIter>
_ForwardIter
__rotate(_ForwardIter __first, _ForwardIter __middle, _ForwardIter __last) {
  
  
  return __rotate_aux(__first, __middle, __last,
                      (typename ::std::iterator_traits< _ForwardIter > ::difference_type*)0,
                      typename ::std::iterator_traits< _ForwardIter > ::iterator_category());
}

}

template <class _ForwardIter>
void rotate(_ForwardIter __first, _ForwardIter __middle, _ForwardIter __last) {
  ::std::priv:: __rotate(__first, __middle, __last);
}

// Return a random number in the range [0, __n).  This function encapsulates
// whether we're using rand (part of the standard C library) or lrand48
// (not standard, but a much better choice whenever it's available).
namespace priv {

template <class _Distance>
inline _Distance __random_number(_Distance __n) {
  return rand() % __n;
}

}

template <class _RandomAccessIter>
void random_shuffle(_RandomAccessIter __first,
                    _RandomAccessIter __last) {
  
  if (__first == __last) return;
  for (_RandomAccessIter __i = __first + 1; __i != __last; ++__i)
    iter_swap(__i, __first + ::std::priv:: __random_number((__i - __first) + 1));
}

template <class _RandomAccessIter, class _RandomNumberGenerator>
void random_shuffle(_RandomAccessIter __first, _RandomAccessIter __last,
                    _RandomNumberGenerator &__rand) {
  
  if (__first == __last) return;
  for (_RandomAccessIter __i = __first + 1; __i != __last; ++__i)
    iter_swap(__i, __first + __rand((__i - __first) + 1));
}

// random_sample and random_sample_n (extensions, not part of the standard).
template <class _ForwardIter, class _OutputIter, class _Distance>
_OutputIter random_sample_n(_ForwardIter __first, _ForwardIter __last,
                            _OutputIter __out_ite, const _Distance __n) {
  
  _Distance __remaining = ::std::distance(__first, __last);
  _Distance __m = (min) (__n, __remaining);

  while (__m > 0) {
    if (::std::priv:: __random_number(__remaining) < __m) {
      *__out_ite = *__first;
      ++__out_ite;
      --__m;
    }

    --__remaining;
    ++__first;
  }
  return __out_ite;
}


template <class _ForwardIter, class _OutputIter, class _Distance,
          class _RandomNumberGenerator>
_OutputIter random_sample_n(_ForwardIter __first, _ForwardIter __last,
                            _OutputIter __out_ite, const _Distance __n,
                            _RandomNumberGenerator& __rand) {
  
  _Distance __remaining = ::std::distance(__first, __last);
  _Distance __m = (min) (__n, __remaining);

  while (__m > 0) {
    if (__rand(__remaining) < __m) {
      *__out_ite = *__first;
      ++__out_ite;
      --__m;
    }

    --__remaining;
    ++__first;
  }
  return __out_ite;
}

namespace priv {

template <class _InputIter, class _RandomAccessIter, class _Distance>
_RandomAccessIter __random_sample(_InputIter __first, _InputIter __last,
                                  _RandomAccessIter __out_ite,
                                  const _Distance __n) {
  _Distance __m = 0;
  _Distance __t = __n;
  for ( ; __first != __last && __m < __n; ++__m, ++__first)
    __out_ite[__m] = *__first;

  while (__first != __last) {
    ++__t;
    _Distance __M = __random_number(__t);
    if (__M < __n)
      __out_ite[__M] = *__first;
    ++__first;
  }

  return __out_ite + __m;
}

template <class _InputIter, class _RandomAccessIter,
          class _RandomNumberGenerator, class _Distance>
_RandomAccessIter __random_sample(_InputIter __first, _InputIter __last,
                                  _RandomAccessIter __out_ite,
                                  _RandomNumberGenerator& __rand,
                                  const _Distance __n) {
  _Distance __m = 0;
  _Distance __t = __n;
  for ( ; __first != __last && __m < __n; ++__m, ++__first)
    __out_ite[__m] = *__first;

  while (__first != __last) {
    ++__t;
    _Distance __M = __rand(__t);
    if (__M < __n)
      __out_ite[__M] = *__first;
    ++__first;
  }

  return __out_ite + __m;
}

}

template <class _InputIter, class _RandomAccessIter>
_RandomAccessIter
random_sample(_InputIter __first, _InputIter __last,
              _RandomAccessIter __out_first, _RandomAccessIter __out_last) {
  
  
  return ::std::priv:: __random_sample(__first, __last,
                                    __out_first, __out_last - __out_first);
}

template <class _InputIter, class _RandomAccessIter, class _RandomNumberGenerator>
_RandomAccessIter
random_sample(_InputIter __first, _InputIter __last,
              _RandomAccessIter __out_first, _RandomAccessIter __out_last,
              _RandomNumberGenerator& __rand) {
  
  
  return ::std::priv:: __random_sample(__first, __last,
                                    __out_first, __rand,
                                    __out_last - __out_first);
}


// partition, stable_partition, and their auxiliary functions
namespace priv {

template <class _ForwardIter, class _Predicate>
inline _ForwardIter __partition(_ForwardIter __first,
                                           _ForwardIter __last,
                                           _Predicate   __pred,
                                           const forward_iterator_tag &) {
  if (__first == __last) return __first;

  while (__pred(*__first))
    if (++__first == __last) return __first;

  _ForwardIter __next = __first;

  while (++__next != __last) {
    if (__pred(*__next)) {
      ::std::swap(*__first, *__next);
      ++__first;
    }
  }
  return __first;
}

template <class _BidirectionalIter, class _Predicate>
inline _BidirectionalIter __partition(_BidirectionalIter __first,
                                                 _BidirectionalIter __last,
                                                 _Predicate __pred,
                                                 const bidirectional_iterator_tag &) {
  for (;;) {
    for (;;) {
      if (__first == __last)
        return __first;
      else if (__pred(*__first))
        ++__first;
      else
        break;
    }
    --__last;
    for (;;) {
      if (__first == __last)
        return __first;
      else if (!__pred(*__last))
        --__last;
      else
        break;
    }
    iter_swap(__first, __last);
    ++__first;
  }
}


}

template <class _ForwardIter, class _Predicate>
_ForwardIter partition(_ForwardIter __first, _ForwardIter __last, _Predicate   __pred) {
  
  return ::std::priv:: __partition(__first, __last, __pred, typename ::std::iterator_traits< _ForwardIter > ::iterator_category());
}


/* __pred_of_first: false if we know that __pred(*__first) is false,
 *                  true when we don't know the result of __pred(*__first).
 * __not_pred_of_before_last: true if we know that __pred(*--__last) is true,
 *                            false when we don't know the result of __pred(*--__last).
 */
namespace priv {

template <class _ForwardIter, class _Predicate, class _Distance>
_ForwardIter __inplace_stable_partition(_ForwardIter __first,
                                        _ForwardIter __last,
                                        _Predicate __pred, _Distance __len,
                                        bool __pred_of_first, bool __pred_of_before_last) {
  if (__len == 1)
    return (__pred_of_first && (__pred_of_before_last || __pred(*__first))) ? __last : __first;
  _ForwardIter __middle = __first;
  _Distance __half_len = __len / 2;
  ::std::advance(__middle, __half_len);
  return ::std::priv:: __rotate(::std::priv:: __inplace_stable_partition(__first, __middle, __pred, __half_len, __pred_of_first, false),
                             __middle,
                             ::std::priv:: __inplace_stable_partition(__middle, __last, __pred, __len - __half_len, true, __pred_of_before_last));
}

template <class _ForwardIter, class _Pointer, class _Predicate,
          class _Distance>
_ForwardIter __stable_partition_adaptive(_ForwardIter __first,
                                         _ForwardIter __last,
                                         _Predicate __pred, _Distance __len,
                                         _Pointer __buffer, _Distance __buffer_size,
                                         bool __pred_of_first, bool __pred_of_before_last) {
  if (__len <= __buffer_size) {
    _ForwardIter __result1 = __first;
    _Pointer __result2 = __buffer;
    if ((__first != __last) && (!__pred_of_first || __pred(*__first))) {
      *__result2 = *__first;
      ++__result2; ++__first; --__len;
    }
    for (; __first != __last ; ++__first, --__len) {
      if (((__len == 1) && (__pred_of_before_last || __pred(*__first))) ||
          ((__len != 1) && __pred(*__first))){
        *__result1 = *__first;
        ++__result1;
      }
      else {
        *__result2 = *__first;
        ++__result2;
      }
    }
    ::std::copy(__buffer, __result2, __result1);
    return __result1;
  }
  else {
    _ForwardIter __middle = __first;
    _Distance __half_len = __len / 2;
    ::std::advance(__middle, __half_len);
    return ::std::priv:: __rotate(::std::priv:: __stable_partition_adaptive(__first, __middle, __pred,
                                                                      __half_len, __buffer, __buffer_size,
                                                                      __pred_of_first, false),
                               __middle,
                               ::std::priv:: __stable_partition_adaptive(__middle, __last, __pred,
                                                                      __len - __half_len, __buffer, __buffer_size,
                                                                      true, __pred_of_before_last));
  }
}

template <class _ForwardIter, class _Predicate, class _Tp, class _Distance>
inline _ForwardIter
__stable_partition_aux_aux(_ForwardIter __first, _ForwardIter __last,
                           _Predicate __pred, _Tp*, _Distance*, bool __pred_of_before_last) {
  _Temporary_buffer<_ForwardIter, _Tp> __buf(__first, __last);
      //*TY 06/01/2000 - they forget to call dtor for _Temporary_buffer if no try/catch block is present
  return (__buf.size() > 0) ?
    __stable_partition_adaptive(__first, __last, __pred,
                                _Distance(__buf.requested_size()),
                                __buf.begin(), _Distance(__buf.size()),
                                false, __pred_of_before_last)  :
    __inplace_stable_partition(__first, __last, __pred,
                               _Distance(__buf.requested_size()),
                               false, __pred_of_before_last);
    //*TY 06/01/2000 - they forget to call dtor for _Temporary_buffer if no try/catch block is present
}

template <class _ForwardIter, class _Predicate>
_ForwardIter
__stable_partition_aux(_ForwardIter __first, _ForwardIter __last, _Predicate __pred,
                       const forward_iterator_tag &) {
  return __stable_partition_aux_aux(__first, __last, __pred,
                                    (typename ::std::iterator_traits< _ForwardIter > ::value_type*)0,
                                    (typename ::std::iterator_traits< _ForwardIter > ::difference_type*)0, false);
}

template <class _BidirectIter, class _Predicate>
_BidirectIter
__stable_partition_aux(_BidirectIter __first, _BidirectIter __last, _Predicate __pred,
                       const bidirectional_iterator_tag &) {
  for (--__last;;) {
    if (__first == __last)
      return __first;
    else if (!__pred(*__last))
      --__last;
    else
      break;
  }
  ++__last;
  //Here we know that __pred(*--__last) is true
  return __stable_partition_aux_aux(__first, __last, __pred,
                                    (typename ::std::iterator_traits< _BidirectIter > ::value_type*)0,
                                    (typename ::std::iterator_traits< _BidirectIter > ::difference_type*)0, true);
}


}

template <class _ForwardIter, class _Predicate>
_ForwardIter
stable_partition(_ForwardIter __first, _ForwardIter __last, _Predicate __pred) {
  
  for (;;) {
    if (__first == __last)
      return __first;
    else if (__pred(*__first))
      ++__first;
    else
      break;
  }
  return ::std::priv:: __stable_partition_aux(__first, __last, __pred,
                                           typename ::std::iterator_traits< _ForwardIter > ::iterator_category());
}

namespace priv {

template <class _RandomAccessIter, class _Tp, class _Compare>
_RandomAccessIter __unguarded_partition(_RandomAccessIter __first,
                                        _RandomAccessIter __last,
                                        _Tp __pivot, _Compare __comp) {
  for (;;) {
    while (__comp(*__first, __pivot)) {
      
      ++__first;
    }
    --__last;
    while (__comp(__pivot, *__last)) {
      
      --__last;
    }
    if (!(__first < __last))
      return __first;
    iter_swap(__first, __last);
    ++__first;
  }
}

// sort() and its auxiliary functions.

template <class _RandomAccessIter, class _Tp, class _Compare>
void __unguarded_linear_insert(_RandomAccessIter __last, _Tp __val,
                               _Compare __comp) {
  _RandomAccessIter __next = __last;
  --__next;
  while (__comp(__val, *__next)) {
    
    *__last = *__next;
    __last = __next;
    --__next;
  }
  *__last = __val;
}

template <class _RandomAccessIter, class _Tp, class _Compare>
inline void __linear_insert(_RandomAccessIter __first,
                            _RandomAccessIter __last, _Tp __val, _Compare __comp) {
  //*TY 12/26/1998 - added __val as a paramter
  //  _Tp __val = *__last;        //*TY 12/26/1998 - __val supplied by caller
  if (__comp(__val, *__first)) {
    
    copy_backward(__first, __last, __last + 1);
    *__first = __val;
  }
  else
    __unguarded_linear_insert(__last, __val, __comp);
}

template <class _RandomAccessIter, class _Tp, class _Compare>
void __insertion_sort(_RandomAccessIter __first,
                      _RandomAccessIter __last,
                      _Tp *, _Compare __comp) {
  if (__first == __last) return;
  for (_RandomAccessIter __i = __first + 1; __i != __last; ++__i)
    __linear_insert<_RandomAccessIter, _Tp, _Compare>(__first, __i, *__i, __comp);  //*TY 12/26/1998 - supply *__i as __val
}

template <class _RandomAccessIter, class _Tp, class _Compare>
void __unguarded_insertion_sort_aux(_RandomAccessIter __first,
                                    _RandomAccessIter __last,
                                    _Tp*, _Compare __comp) {
  for (_RandomAccessIter __i = __first; __i != __last; ++__i)
    __unguarded_linear_insert<_RandomAccessIter, _Tp, _Compare>(__i, *__i, __comp);
}

template <class _RandomAccessIter, class _Compare>
inline void __unguarded_insertion_sort(_RandomAccessIter __first,
                                       _RandomAccessIter __last,
                                       _Compare __comp) {
  __unguarded_insertion_sort_aux(__first, __last, (typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0, __comp);
}

template <class _RandomAccessIter, class _Compare>
void __final_insertion_sort(_RandomAccessIter __first,
                            _RandomAccessIter __last, _Compare __comp) {
  if (__last - __first > 16) {
    __insertion_sort(__first, __first + 16, (typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0, __comp);
    __unguarded_insertion_sort(__first + 16, __last, __comp);
  }
  else
    __insertion_sort(__first, __last, (typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0, __comp);
}

template <class _RandomAccessIter, class _Tp, class _Size, class _Compare>
void __introsort_loop(_RandomAccessIter __first,
                      _RandomAccessIter __last, _Tp*,
                      _Size __depth_limit, _Compare __comp) {
  while (__last - __first > 16) {
    if (__depth_limit == 0) {
      partial_sort(__first, __last, __last, __comp);
      return;
    }
    --__depth_limit;
    _RandomAccessIter __cut =
      __unguarded_partition(__first, __last,
                            _Tp(__median(*__first,
                                         *(__first + (__last - __first)/2),
                                         *(__last - 1), __comp)),
       __comp);
    __introsort_loop(__cut, __last, (_Tp*) 0, __depth_limit, __comp);
    __last = __cut;
  }
}

}

template <class _RandomAccessIter>
void sort(_RandomAccessIter __first, _RandomAccessIter __last) {
  
  if (__first != __last) {
    ::std::priv:: __introsort_loop(__first, __last,
                                (typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0,
                                ::std::priv:: __lg(__last - __first) * 2,
                                ::std::priv:: __less((typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0));
    ::std::priv:: __final_insertion_sort(__first, __last,
                                      ::std::priv:: __less((typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0));
  }
}

template <class _RandomAccessIter, class _Compare>
void sort(_RandomAccessIter __first, _RandomAccessIter __last, _Compare __comp) {
  
  if (__first != __last) {
    ::std::priv:: __introsort_loop(__first, __last,
                                (typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0,
                                ::std::priv:: __lg(__last - __first) * 2, __comp);
    ::std::priv:: __final_insertion_sort(__first, __last, __comp);
  }
}

// stable_sort() and its auxiliary functions.
namespace priv {

template <class _RandomAccessIter, class _Compare>
void __inplace_stable_sort(_RandomAccessIter __first,
                           _RandomAccessIter __last, _Compare __comp) {
  if (__last - __first < 15) {
    __insertion_sort(__first, __last, (typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0, __comp);
    return;
  }
  _RandomAccessIter __middle = __first + (__last - __first) / 2;
  __inplace_stable_sort(__first, __middle, __comp);
  __inplace_stable_sort(__middle, __last, __comp);
  __merge_without_buffer(__first, __middle, __last,
                         __middle - __first,
                         __last - __middle,
                         __comp);
}

template <class _RandomAccessIter1, class _RandomAccessIter2,
          class _Distance, class _Compare>
void __merge_sort_loop(_RandomAccessIter1 __first,
                       _RandomAccessIter1 __last,
                       _RandomAccessIter2 __result, _Distance __step_size,
                       _Compare __comp) {
  _Distance __two_step = 2 * __step_size;

  while (__last - __first >= __two_step) {
    __result = merge(__first, __first + __step_size,
                     __first + __step_size, __first + __two_step,
                     __result,
                     __comp);
    __first += __two_step;
  }
  __step_size = (min) (_Distance(__last - __first), __step_size);

  merge(__first, __first + __step_size,
        __first + __step_size, __last,
        __result,
        __comp);
}

#  pragma diag_suppress 179 /* Declared but not referenced */
const int __stl_chunk_size = 7;

template <class _RandomAccessIter, class _Distance, class _Compare>
void __chunk_insertion_sort(_RandomAccessIter __first,
                            _RandomAccessIter __last,
                            _Distance __chunk_size, _Compare __comp) {
  while (__last - __first >= __chunk_size) {
    __insertion_sort(__first, __first + __chunk_size,
                     (typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0, __comp);
    __first += __chunk_size;
  }
  __insertion_sort(__first, __last, (typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0, __comp);
}

template <class _RandomAccessIter, class _Pointer, class _Distance,
          class _Compare>
void __merge_sort_with_buffer(_RandomAccessIter __first,
                              _RandomAccessIter __last, _Pointer __buffer,
                              _Distance*, _Compare __comp) {
  _Distance __len = __last - __first;
  _Pointer __buffer_last = __buffer + __len;

  _Distance __step_size = __stl_chunk_size;
  __chunk_insertion_sort(__first, __last, __step_size, __comp);

  while (__step_size < __len) {
    __merge_sort_loop(__first, __last, __buffer, __step_size, __comp);
    __step_size *= 2;
    __merge_sort_loop(__buffer, __buffer_last, __first, __step_size, __comp);
    __step_size *= 2;
  }
}

template <class _BidirectionalIter1, class _BidirectionalIter2,
          class _Distance>
_BidirectionalIter1 __rotate_adaptive(_BidirectionalIter1 __first,
                                      _BidirectionalIter1 __middle,
                                      _BidirectionalIter1 __last,
                                      _Distance __len1, _Distance __len2,
                                      _BidirectionalIter2 __buffer,
                                      _Distance __buffer_size) {
  if (__len1 > __len2 && __len2 <= __buffer_size) {
    _BidirectionalIter2 __buffer_end = ::std::copy(__middle, __last, __buffer);
    ::std::copy_backward(__first, __middle, __last);
    return ::std::copy(__buffer, __buffer_end, __first);
  }
  else if (__len1 <= __buffer_size) {
    _BidirectionalIter2 __buffer_end = ::std::copy(__first, __middle, __buffer);
    ::std::copy(__middle, __last, __first);
    return ::std::copy_backward(__buffer, __buffer_end, __last);
  }
  else
    return ::std::priv:: __rotate(__first, __middle, __last);
}

template <class _BidirectionalIter, class _Distance, class _Pointer,
          class _Compare>
void __merge_adaptive(_BidirectionalIter __first,
                      _BidirectionalIter __middle,
                      _BidirectionalIter __last,
                      _Distance __len1, _Distance __len2,
                      _Pointer __buffer, _Distance __buffer_size,
                      _Compare __comp) {
  if (__len1 <= __len2 && __len1 <= __buffer_size) {
    _Pointer __buffer_end = ::std::copy(__first, __middle, __buffer);
    ::std::merge(__buffer, __buffer_end, __middle, __last, __first, __comp);
  }
  else if (__len2 <= __buffer_size) {
    _Pointer __buffer_end = ::std::copy(__middle, __last, __buffer);
    ::std::priv:: __merge_backward(__first, __middle, __buffer, __buffer_end, __last,
                                __comp);
  }
  else {
    _BidirectionalIter __first_cut = __first;
    _BidirectionalIter __second_cut = __middle;
    _Distance __len11 = 0;
    _Distance __len22 = 0;
    if (__len1 > __len2) {
      __len11 = __len1 / 2;
      ::std::advance(__first_cut, __len11);
      __second_cut = ::std::lower_bound(__middle, __last, *__first_cut, __comp);
      __len22 += ::std::distance(__middle, __second_cut);
    }
    else {
      __len22 = __len2 / 2;
      ::std::advance(__second_cut, __len22);
      __first_cut = ::std::upper_bound(__first, __middle, *__second_cut, __comp);
      __len11 += ::std::distance(__first, __first_cut);
    }
    _BidirectionalIter __new_middle =
      __rotate_adaptive(__first_cut, __middle, __second_cut, __len1 - __len11,
                        __len22, __buffer, __buffer_size);
    __merge_adaptive(__first, __first_cut, __new_middle, __len11,
                     __len22, __buffer, __buffer_size, __comp);
    __merge_adaptive(__new_middle, __second_cut, __last, __len1 - __len11,
                     __len2 - __len22, __buffer, __buffer_size, __comp);
  }
}

template <class _RandomAccessIter, class _Pointer, class _Distance,
          class _Compare>
void __stable_sort_adaptive(_RandomAccessIter __first,
                            _RandomAccessIter __last, _Pointer __buffer,
                            _Distance __buffer_size, _Compare __comp) {
  _Distance __len = (__last - __first + 1) / 2;
  _RandomAccessIter __middle = __first + __len;
  if (__len > __buffer_size) {
    __stable_sort_adaptive(__first, __middle, __buffer, __buffer_size,
                           __comp);
    __stable_sort_adaptive(__middle, __last, __buffer, __buffer_size,
                           __comp);
  }
  else {
    __merge_sort_with_buffer(__first, __middle, __buffer, (_Distance*)0,
                               __comp);
    __merge_sort_with_buffer(__middle, __last, __buffer, (_Distance*)0,
                               __comp);
  }
  __merge_adaptive(__first, __middle, __last, _Distance(__middle - __first),
                   _Distance(__last - __middle), __buffer, __buffer_size,
                   __comp);
}

template <class _RandomAccessIter, class _Tp, class _Distance, class _Compare>
void __stable_sort_aux(_RandomAccessIter __first,
                       _RandomAccessIter __last, _Tp*, _Distance*,
                       _Compare __comp) {
  _Temporary_buffer<_RandomAccessIter, _Tp> buf(__first, __last);
  if (buf.begin() == 0)
    __inplace_stable_sort(__first, __last, __comp);
  else
    __stable_sort_adaptive(__first, __last, buf.begin(),
                           _Distance(buf.size()),
                           __comp);
}

}

template <class _RandomAccessIter>
void stable_sort(_RandomAccessIter __first,
                 _RandomAccessIter __last) {
  
  ::std::priv:: __stable_sort_aux(__first, __last,
                               (typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0,
                               (typename ::std::iterator_traits< _RandomAccessIter > ::difference_type*)0,
                               ::std::priv:: __less((typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0));
}

template <class _RandomAccessIter, class _Compare>
void stable_sort(_RandomAccessIter __first,
                 _RandomAccessIter __last, _Compare __comp) {
  
  ::std::priv:: __stable_sort_aux(__first, __last,
                               (typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0,
                               (typename ::std::iterator_traits< _RandomAccessIter > ::difference_type*)0,
                               __comp);
}

// partial_sort, partial_sort_copy, and auxiliary functions.
namespace priv {

template <class _RandomAccessIter, class _Tp, class _Compare>
void __partial_sort(_RandomAccessIter __first, _RandomAccessIter __middle,
                    _RandomAccessIter __last, _Tp*, _Compare __comp) {
  make_heap(__first, __middle, __comp);
  for (_RandomAccessIter __i = __middle; __i < __last; ++__i) {
    if (__comp(*__i, *__first)) {
      
      __pop_heap(__first, __middle, __i, _Tp(*__i), __comp,
                 (typename ::std::iterator_traits< _RandomAccessIter > ::difference_type*)0);
    }
  }
  sort_heap(__first, __middle, __comp);
}

}

template <class _RandomAccessIter>
void partial_sort(_RandomAccessIter __first,_RandomAccessIter __middle,
                  _RandomAccessIter __last) {
  
  
  ::std::priv:: __partial_sort(__first, __middle, __last, (typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0,
                            ::std::priv:: __less((typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0));
}

template <class _RandomAccessIter, class _Compare>
void partial_sort(_RandomAccessIter __first,_RandomAccessIter __middle,
                  _RandomAccessIter __last, _Compare __comp) {
  
  
  ::std::priv:: __partial_sort(__first, __middle, __last, (typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0, __comp);
}

namespace priv {

template <class _InputIter, class _RandomAccessIter, class _Compare,
          class _Distance, class _Tp>
_RandomAccessIter __partial_sort_copy(_InputIter __first,
                                      _InputIter __last,
                                      _RandomAccessIter __result_first,
                                      _RandomAccessIter __result_last,
                                      _Compare __comp, _Distance*, _Tp*) {
  if (__result_first == __result_last) return __result_last;
  _RandomAccessIter __result_real_last = __result_first;
  while(__first != __last && __result_real_last != __result_last) {
    *__result_real_last = *__first;
    ++__result_real_last;
    ++__first;
  }
  make_heap(__result_first, __result_real_last, __comp);
  while (__first != __last) {
    if (__comp(*__first, *__result_first)) {
      
      __adjust_heap(__result_first, _Distance(0),
                    _Distance(__result_real_last - __result_first),
                    _Tp(*__first),
                    __comp);
    }
    ++__first;
  }
  sort_heap(__result_first, __result_real_last, __comp);
  return __result_real_last;
}

}

template <class _InputIter, class _RandomAccessIter>
_RandomAccessIter
partial_sort_copy(_InputIter __first, _InputIter __last,
                  _RandomAccessIter __result_first, _RandomAccessIter __result_last) {
  
  
  return ::std::priv:: __partial_sort_copy(__first, __last, __result_first, __result_last,
                                        ::std::priv:: __less((typename ::std::iterator_traits< _InputIter > ::value_type*)0),
                                        (typename ::std::iterator_traits< _RandomAccessIter > ::difference_type*)0,
                                        (typename ::std::iterator_traits< _InputIter > ::value_type*)0);
}

template <class _InputIter, class _RandomAccessIter, class _Compare>
_RandomAccessIter
partial_sort_copy(_InputIter __first, _InputIter __last,
                  _RandomAccessIter __result_first,
                  _RandomAccessIter __result_last, _Compare __comp) {
  
  
  return ::std::priv:: __partial_sort_copy(__first, __last, __result_first, __result_last,
                                        __comp,
                                        (typename ::std::iterator_traits< _RandomAccessIter > ::difference_type*)0,
                                        (typename ::std::iterator_traits< _InputIter > ::value_type*)0);
}

// nth_element() and its auxiliary functions.
namespace priv {

template <class _RandomAccessIter, class _Tp, class _Compare>
void __nth_element(_RandomAccessIter __first, _RandomAccessIter __nth,
                   _RandomAccessIter __last, _Tp*, _Compare __comp) {
  while (__last - __first > 3) {
    _RandomAccessIter __cut =
      __unguarded_partition(__first, __last,
                            _Tp(__median(*__first,
                                         *(__first + (__last - __first)/2),
                                         *(__last - 1),
                                         __comp)),
                            __comp);
    if (__cut <= __nth)
      __first = __cut;
    else
      __last = __cut;
  }
  __insertion_sort(__first, __last, (typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0, __comp);
}

}

template <class _RandomAccessIter>
void nth_element(_RandomAccessIter __first, _RandomAccessIter __nth,
                 _RandomAccessIter __last) {
  
  
  ::std::priv:: __nth_element(__first, __nth, __last, (typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0,
                           ::std::priv:: __less((typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0));
}

template <class _RandomAccessIter, class _Compare>
void nth_element(_RandomAccessIter __first, _RandomAccessIter __nth,
                 _RandomAccessIter __last, _Compare __comp) {
  
  
  ::std::priv:: __nth_element(__first, __nth, __last, (typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0, __comp);
}

// Binary search (lower_bound, upper_bound, equal_range, binary_search).
namespace priv {

template <class _ForwardIter, class _Tp,
          class _Compare1, class _Compare2, class _Distance>
_ForwardIter __upper_bound(_ForwardIter __first, _ForwardIter __last, const _Tp& __val,
                           _Compare1 __comp1, _Compare2 __comp2, _Distance*) {
  _Distance __len = ::std::distance(__first, __last);
  _Distance __half;

  while (__len > 0) {
    __half = __len >> 1;
    _ForwardIter __middle = __first;
    ::std::advance(__middle, __half);
    if (__comp2(__val, *__middle)) {
      
      __len = __half;
    }
    else {
      __first = __middle;
      ++__first;
      __len = __len - __half - 1;
    }
  }
  return __first;
}

template <class _ForwardIter, class _Tp,
          class _Compare1, class _Compare2, class _Distance>
pair<_ForwardIter, _ForwardIter>
__equal_range(_ForwardIter __first, _ForwardIter __last, const _Tp& __val,
              _Compare1 __comp1, _Compare2 __comp2, _Distance* __dist) {
  _Distance __len = ::std::distance(__first, __last);
  _Distance __half;

  while (__len > 0) {
    __half = __len >> 1;
    _ForwardIter __middle = __first;
    ::std::advance(__middle, __half);
    if (__comp1(*__middle, __val)) {
      
      __first = __middle;
      ++__first;
      __len = __len - __half - 1;
    }
    else if (__comp2(__val, *__middle)) {
      
      __len = __half;
    }
    else {
      _ForwardIter __left = ::std::priv:: __lower_bound(__first, __middle, __val, __comp1, __comp2, __dist);
      //Small optim: If lower_bound haven't found an equivalent value
      //there is no need to call upper_bound.
      if (__comp1(*__left, __val)) {
        
        return pair<_ForwardIter, _ForwardIter>(__left, __left);
      }
      ::std::advance(__first, __len);
      _ForwardIter __right = ::std::priv:: __upper_bound(++__middle, __first, __val, __comp1, __comp2, __dist);
      return pair<_ForwardIter, _ForwardIter>(__left, __right);
    }
  }
  return pair<_ForwardIter, _ForwardIter>(__first, __first);
}

}

template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter merge(_InputIter1 __first1, _InputIter1 __last1,
                  _InputIter2 __first2, _InputIter2 __last2,
                  _OutputIter __result) {
  
  
  while (__first1 != __last1 && __first2 != __last2) {
    if (*__first2 < *__first1) {
      *__result = *__first2;
      ++__first2;
    }
    else {
      *__result = *__first1;
      ++__first1;
    }
    ++__result;
  }
  return ::std::copy(__first2, __last2, ::std::copy(__first1, __last1, __result));
}

template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter merge(_InputIter1 __first1, _InputIter1 __last1,
                  _InputIter2 __first2, _InputIter2 __last2,
                  _OutputIter __result, _Compare __comp) {
  
  
  while (__first1 != __last1 && __first2 != __last2) {
    if (__comp(*__first2, *__first1)) {
      
      *__result = *__first2;
      ++__first2;
    }
    else {
      *__result = *__first1;
      ++__first1;
    }
    ++__result;
  }
  return ::std::copy(__first2, __last2, ::std::copy(__first1, __last1, __result));
}

namespace priv {

template <class _BidirectionalIter, class _Distance, class _Compare>
void __merge_without_buffer(_BidirectionalIter __first,
                            _BidirectionalIter __middle,
                            _BidirectionalIter __last,
                            _Distance __len1, _Distance __len2,
                            _Compare __comp) {
  if (__len1 == 0 || __len2 == 0)
    return;
  if (__len1 + __len2 == 2) {
    if (__comp(*__middle, *__first)) {
      
      iter_swap(__first, __middle);
    }
    return;
  }
  _BidirectionalIter __first_cut = __first;
  _BidirectionalIter __second_cut = __middle;
  _Distance __len11 = 0;
  _Distance __len22 = 0;
  if (__len1 > __len2) {
    __len11 = __len1 / 2;
    ::std::advance(__first_cut, __len11);
    __second_cut = ::std::lower_bound(__middle, __last, *__first_cut, __comp);
    __len22 += ::std::distance(__middle, __second_cut);
  }
  else {
    __len22 = __len2 / 2;
    ::std::advance(__second_cut, __len22);
    __first_cut = ::std::upper_bound(__first, __middle, *__second_cut, __comp);
    __len11 += ::std::distance(__first, __first_cut);
  }
  _BidirectionalIter __new_middle
    = ::std::priv:: __rotate(__first_cut, __middle, __second_cut);
  __merge_without_buffer(__first, __first_cut, __new_middle, __len11, __len22,
                         __comp);
  __merge_without_buffer(__new_middle, __second_cut, __last, __len1 - __len11,
                         __len2 - __len22, __comp);
}

template <class _BidirectionalIter1, class _BidirectionalIter2,
          class _BidirectionalIter3, class _Compare>
_BidirectionalIter3 __merge_backward(_BidirectionalIter1 __first1,
                                     _BidirectionalIter1 __last1,
                                     _BidirectionalIter2 __first2,
                                     _BidirectionalIter2 __last2,
                                     _BidirectionalIter3 __result,
                                     _Compare __comp) {
  if (__first1 == __last1)
    return copy_backward(__first2, __last2, __result);
  if (__first2 == __last2)
    return copy_backward(__first1, __last1, __result);
  --__last1;
  --__last2;
  for (;;) {
    if (__comp(*__last2, *__last1)) {
      
      *--__result = *__last1;
      if (__first1 == __last1)
        return copy_backward(__first2, ++__last2, __result);
      --__last1;
    }
    else {
      *--__result = *__last2;
      if (__first2 == __last2)
        return copy_backward(__first1, ++__last1, __result);
      --__last2;
    }
  }
}

template <class _BidirectionalIter, class _Tp,
          class _Distance, class _Compare>
inline void __inplace_merge_aux(_BidirectionalIter __first,
                                _BidirectionalIter __middle,
                                _BidirectionalIter __last, _Tp*, _Distance*,
                                _Compare __comp) {
  _Distance __len1 = ::std::distance(__first, __middle);
  _Distance __len2 = ::std::distance(__middle, __last);

  _Temporary_buffer<_BidirectionalIter, _Tp> __buf(__first, __last);
  if (__buf.begin() == 0)
    __merge_without_buffer(__first, __middle, __last, __len1, __len2, __comp);
  else
    __merge_adaptive(__first, __middle, __last, __len1, __len2,
                     __buf.begin(), _Distance(__buf.size()),
                     __comp);
}

}

template <class _BidirectionalIter>
void inplace_merge(_BidirectionalIter __first,
                   _BidirectionalIter __middle,
                   _BidirectionalIter __last) {
  
  
  if (__first == __middle || __middle == __last)
    return;
  ::std::priv:: __inplace_merge_aux(__first, __middle, __last,
                                 (typename ::std::iterator_traits< _BidirectionalIter > ::value_type*)0, (typename ::std::iterator_traits< _BidirectionalIter > ::difference_type*)0,
                                 ::std::priv:: __less((typename ::std::iterator_traits< _BidirectionalIter > ::value_type*)0));
}

template <class _BidirectionalIter, class _Compare>
void inplace_merge(_BidirectionalIter __first,
                   _BidirectionalIter __middle,
                   _BidirectionalIter __last, _Compare __comp) {
  
  
  if (__first == __middle || __middle == __last)
    return;
  ::std::priv:: __inplace_merge_aux(__first, __middle, __last,
                                 (typename ::std::iterator_traits< _BidirectionalIter > ::value_type*)0, (typename ::std::iterator_traits< _BidirectionalIter > ::difference_type*)0,
                                 __comp);
}

namespace priv {

template <class _InputIter1, class _InputIter2, class _Compare>
bool __includes(_InputIter1 __first1, _InputIter1 __last1,
                _InputIter2 __first2, _InputIter2 __last2, _Compare __comp) {
  
  
  while (__first1 != __last1 && __first2 != __last2)
    if (__comp(*__first2, *__first1)) {
      
      return false;
    }
    else if (__comp(*__first1, *__first2))
      ++__first1;
    else
      ++__first1, ++__first2;

  return __first2 == __last2;
}

}

template <class _InputIter1, class _InputIter2, class _Compare>
bool includes(_InputIter1 __first1, _InputIter1 __last1,
              _InputIter2 __first2, _InputIter2 __last2, _Compare __comp) {
  return ::std::priv:: __includes(__first1, __last1, __first2, __last2, __comp);
}

template <class _InputIter1, class _InputIter2>
bool includes(_InputIter1 __first1, _InputIter1 __last1,
              _InputIter2 __first2, _InputIter2 __last2) {
  return ::std::priv:: __includes(__first1, __last1, __first2, __last2,
                               ::std::priv:: __less((typename ::std::iterator_traits< _InputIter1 > ::value_type*)0));
}

namespace priv {

template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter __set_union(_InputIter1 __first1, _InputIter1 __last1,
                        _InputIter2 __first2, _InputIter2 __last2,
                        _OutputIter __result, _Compare __comp) {
  
  
  while (__first1 != __last1 && __first2 != __last2) {
    if (__comp(*__first1, *__first2)) {
      
      *__result = *__first1;
      ++__first1;
    }
    else if (__comp(*__first2, *__first1)) {
      
      *__result = *__first2;
      ++__first2;
    }
    else {
      *__result = *__first1;
      ++__first1;
      ++__first2;
    }
    ++__result;
  }
  return ::std::copy(__first2, __last2, ::std::copy(__first1, __last1, __result));
}

}

template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter set_union(_InputIter1 __first1, _InputIter1 __last1,
                      _InputIter2 __first2, _InputIter2 __last2,
                      _OutputIter __result) {
  return ::std::priv:: __set_union(__first1, __last1, __first2, __last2, __result,
                                ::std::priv:: __less((typename ::std::iterator_traits< _InputIter1 > ::value_type*)0));
}

template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter set_union(_InputIter1 __first1, _InputIter1 __last1,
                      _InputIter2 __first2, _InputIter2 __last2,
                      _OutputIter __result, _Compare __comp) {
  return ::std::priv:: __set_union(__first1, __last1, __first2, __last2, __result, __comp);
}

namespace priv {

template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter __set_intersection(_InputIter1 __first1, _InputIter1 __last1,
                               _InputIter2 __first2, _InputIter2 __last2,
                               _OutputIter __result, _Compare __comp) {
  
  
  while (__first1 != __last1 && __first2 != __last2)
    if (__comp(*__first1, *__first2)) {
      
      ++__first1;
    }
    else if (__comp(*__first2, *__first1))
      ++__first2;
    else {
      *__result = *__first1;
      ++__first1;
      ++__first2;
      ++__result;
    }
  return __result;
}

}

template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter set_intersection(_InputIter1 __first1, _InputIter1 __last1,
                             _InputIter2 __first2, _InputIter2 __last2,
                             _OutputIter __result) {
  return ::std::priv:: __set_intersection(__first1, __last1, __first2, __last2, __result,
                                       ::std::priv:: __less((typename ::std::iterator_traits< _InputIter1 > ::value_type*)0));
}

template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter set_intersection(_InputIter1 __first1, _InputIter1 __last1,
                             _InputIter2 __first2, _InputIter2 __last2,
                             _OutputIter __result, _Compare __comp) {
  return ::std::priv:: __set_intersection(__first1, __last1, __first2, __last2, __result, __comp);
}

namespace priv {

template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter __set_difference(_InputIter1 __first1, _InputIter1 __last1,
                             _InputIter2 __first2, _InputIter2 __last2,
                             _OutputIter __result, _Compare __comp) {
  
  
  while (__first1 != __last1 && __first2 != __last2)
    if (__comp(*__first1, *__first2)) {
      
      *__result = *__first1;
      ++__first1;
      ++__result;
    }
    else if (__comp(*__first2, *__first1))
      ++__first2;
    else {
      ++__first1;
      ++__first2;
    }
  return ::std::copy(__first1, __last1, __result);
}

}

template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter set_difference(_InputIter1 __first1, _InputIter1 __last1,
                           _InputIter2 __first2, _InputIter2 __last2,
                           _OutputIter __result) {
  return ::std::priv:: __set_difference(__first1, __last1, __first2, __last2, __result,
                                     ::std::priv:: __less((typename ::std::iterator_traits< _InputIter1 > ::value_type*)0));
}

template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter set_difference(_InputIter1 __first1, _InputIter1 __last1,
                           _InputIter2 __first2, _InputIter2 __last2,
                           _OutputIter __result, _Compare __comp) {
  return ::std::priv:: __set_difference(__first1, __last1, __first2, __last2, __result, __comp);
}

namespace priv {

template <class _InputIter1, class _InputIter2, class _OutputIter, class _Compare>
_OutputIter
__set_symmetric_difference(_InputIter1 __first1, _InputIter1 __last1,
                           _InputIter2 __first2, _InputIter2 __last2,
                           _OutputIter __result, _Compare __comp) {
  
  
  while (__first1 != __last1 && __first2 != __last2) {
    if (__comp(*__first1, *__first2)) {
      
      *__result = *__first1;
      ++__first1;
      ++__result;
    }
    else if (__comp(*__first2, *__first1)) {
      *__result = *__first2;
      ++__first2;
      ++__result;
    }
    else {
      ++__first1;
      ++__first2;
    }
  }
  return ::std::copy(__first2, __last2, ::std::copy(__first1, __last1, __result));
}

}

template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter
set_symmetric_difference(_InputIter1 __first1, _InputIter1 __last1,
                         _InputIter2 __first2, _InputIter2 __last2,
                         _OutputIter __result) {
  return ::std::priv:: __set_symmetric_difference(__first1, __last1, __first2, __last2, __result,
                                               ::std::priv:: __less((typename ::std::iterator_traits< _InputIter1 > ::value_type*)0));
}

template <class _InputIter1, class _InputIter2, class _OutputIter, class _Compare>
_OutputIter
set_symmetric_difference(_InputIter1 __first1, _InputIter1 __last1,
                         _InputIter2 __first2, _InputIter2 __last2,
                         _OutputIter __result,
                         _Compare __comp) {
  return ::std::priv:: __set_symmetric_difference(__first1, __last1, __first2, __last2, __result, __comp);
}

// min_element and max_element, with and without an explicitly supplied
// comparison function.

template <class _ForwardIter>
_ForwardIter max_element(_ForwardIter __first, _ForwardIter __last) {
  
  if (__first == __last) return __first;
  _ForwardIter __result = __first;
  while (++__first != __last)
    if (*__result < *__first) {
      
      __result = __first;
    }
  return __result;
}

template <class _ForwardIter, class _Compare>
_ForwardIter max_element(_ForwardIter __first, _ForwardIter __last,
                         _Compare __comp) {
  
  if (__first == __last) return __first;
  _ForwardIter __result = __first;
  while (++__first != __last) {
    if (__comp(*__result, *__first)) {
      
      __result = __first;
    }
  }
  return __result;
}

template <class _ForwardIter>
_ForwardIter min_element(_ForwardIter __first, _ForwardIter __last) {
  
  if (__first == __last) return __first;
  _ForwardIter __result = __first;
  while (++__first != __last)
    if (*__first < *__result) {
      
      __result = __first;
    }
  return __result;
}

template <class _ForwardIter, class _Compare>
_ForwardIter min_element(_ForwardIter __first, _ForwardIter __last,
                         _Compare __comp) {
  
  if (__first == __last) return __first;
  _ForwardIter __result = __first;
  while (++__first != __last) {
    if (__comp(*__first, *__result)) {
      
      __result = __first;
    }
  }
  return __result;
}

// next_permutation and prev_permutation, with and without an explicitly
// supplied comparison function.
namespace priv {

template <class _BidirectionalIter, class _Compare>
bool __next_permutation(_BidirectionalIter __first, _BidirectionalIter __last,
                        _Compare __comp) {
  
  if (__first == __last)
    return false;
  _BidirectionalIter __i = __first;
  ++__i;
  if (__i == __last)
    return false;
  __i = __last;
  --__i;

  for(;;) {
    _BidirectionalIter __ii = __i;
    --__i;
    if (__comp(*__i, *__ii)) {
      
      _BidirectionalIter __j = __last;
      while (!__comp(*__i, *--__j)) {}
      iter_swap(__i, __j);
      reverse(__ii, __last);
      return true;
    }
    if (__i == __first) {
      reverse(__first, __last);
      return false;
    }
  }
}

}

template <class _BidirectionalIter>
bool next_permutation(_BidirectionalIter __first, _BidirectionalIter __last) {
  
  return ::std::priv:: __next_permutation(__first, __last,
                                       ::std::priv:: __less((typename ::std::iterator_traits< _BidirectionalIter > ::value_type*)0));
}

template <class _BidirectionalIter, class _Compare>
bool next_permutation(_BidirectionalIter __first, _BidirectionalIter __last,
                      _Compare __comp) {
  
  return ::std::priv:: __next_permutation(__first, __last, __comp);
}

namespace priv {

template <class _BidirectionalIter, class _Compare>
bool __prev_permutation(_BidirectionalIter __first, _BidirectionalIter __last,
                        _Compare __comp) {
  if (__first == __last)
    return false;
  _BidirectionalIter __i = __first;
  ++__i;
  if (__i == __last)
    return false;
  __i = __last;
  --__i;

  for(;;) {
    _BidirectionalIter __ii = __i;
    --__i;
    if (__comp(*__ii, *__i)) {
      
      _BidirectionalIter __j = __last;
      while (!__comp(*--__j, *__i)) {}
      iter_swap(__i, __j);
      reverse(__ii, __last);
      return true;
    }
    if (__i == __first) {
      reverse(__first, __last);
      return false;
    }
  }
}

}

template <class _BidirectionalIter>
bool prev_permutation(_BidirectionalIter __first, _BidirectionalIter __last) {
  
  return ::std::priv:: __prev_permutation(__first, __last,
                                       ::std::priv:: __less((typename ::std::iterator_traits< _BidirectionalIter > ::value_type*)0));
}

template <class _BidirectionalIter, class _Compare>
bool prev_permutation(_BidirectionalIter __first, _BidirectionalIter __last,
                      _Compare __comp) {
  
  return ::std::priv:: __prev_permutation(__first, __last, __comp);
}


// is_heap, a predicate testing whether or not a range is
// a heap.  This function is an extension, not part of the C++
// standard.
namespace priv {

template <class _RandomAccessIter, class _Distance, class _StrictWeakOrdering>
bool __is_heap(_RandomAccessIter __first, _StrictWeakOrdering __comp,
               _Distance __n) {
  _Distance __parent = 0;
  for (_Distance __child = 1; __child < __n; ++__child) {
    if (__comp(__first[__parent], __first[__child])) {
      
      return false;
    }
    if ((__child & 1) == 0)
      ++__parent;
  }
  return true;
}

}

template <class _RandomAccessIter>
bool is_heap(_RandomAccessIter __first, _RandomAccessIter __last) {
  
  return ::std::priv:: __is_heap(__first, ::std::priv:: __less((typename ::std::iterator_traits< _RandomAccessIter > ::value_type*)0), __last - __first);
}

template <class _RandomAccessIter, class _StrictWeakOrdering>
bool is_heap(_RandomAccessIter __first, _RandomAccessIter __last,
             _StrictWeakOrdering __comp) {
  
  return ::std::priv:: __is_heap(__first, __comp, __last - __first);
}


namespace priv {

template <class _ForwardIter, class _StrictWeakOrdering>
bool __is_sorted(_ForwardIter __first, _ForwardIter __last,
                 _StrictWeakOrdering __comp) {
  
  if (__first == __last)
    return true;

  _ForwardIter __next = __first;
  for (++__next; __next != __last; __first = __next, ++__next) {
    if (__comp(*__next, *__first)) {
      
      return false;
    }
  }

  return true;
}

}

}


// Local Variables:
// mode:C++
// End:


// Local Variables:
// mode:C++
// End:



/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/* NOTE : this header has no guards and is MEANT for multiple inclusion!
 * If you are using "header protection" option with your compiler,
 * please also find #pragma which disables it and put it here, to
 * allow reentrancy of this header.
 */


/* If the platform provides any specific epilog actions,
 * like #pragmas, do include platform-specific prolog file
 */

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> by Texas Instruments.   */
/******************************************************************************/

/*========================================== */






/*
# if defined (_STLP_XXX) && ! defined ( __STL_XXX )
#  define __STL_XXX _STLP_XXX
# endif
*/

/* 5.0 -> 4.6 compatibility section */

/* provide a uniform way to access full functionality */






// Local Variables:
// mode:C++
// End:
/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1997-1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/* NOTE : this header has no guards and is MEANT for multiple inclusion!
 * If you are using "header protection" option with your compiler,
 * please also find #pragma which disables it and put it here, to
 * allow reentrancy of this header.
 */

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/* NOTE : this header has no guards and is MEANT for multiple inclusion!
 * If you are using "header protection" option with your compiler,
 * please also find #pragma which disables it and put it here, to
 * allow reentrancy of this header.
 */





/* If the platform provides any specific prolog actions,
 * like #pragmas, do include platform-specific prolog file */

/* Get all debug things, potentially only empty macros if none of
 * the debug features available in user config file is activated. */
 /* Thanks to _STLP_OUTERMOST_HEADER_ID we hide _debug.h when C standard
  * headers are included as some platforms (Win32) include C standard headers
  * in an 'extern "C"' scope which do not accept the templates exposed
  * in _debug.h. */

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1997-1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

/* NOTE: This is an internal header file, included by other STL headers.
 *   You should not attempt to use it directly.
 */








namespace std {

// Malloc-based allocator.  Typically slower than default alloc below.
// Typically thread-safe and more storage efficient.

typedef void (* __oom_handler_type)();

class  __malloc_alloc {
public:
  // this one is needed for proper simple_alloc wrapping
  typedef char value_type;
  static void*  allocate(size_t __n)
  ;

  static void  deallocate(void* __p, size_t /* __n */) { free((char*)__p); }
  static __oom_handler_type  set_malloc_handler(__oom_handler_type __f);
};

// New-based allocator.  Typically slower than default alloc below.
// Typically thread-safe and more storage efficient.
class  __new_alloc {
public:
  // this one is needed for proper simple_alloc wrapping
  typedef char value_type;
  static void*  allocate(size_t __n) { return __stl_new(__n); }
  static void  deallocate(void* __p, size_t) { __stl_delete(__p); }
};

// Allocator adaptor to check size arguments for debugging.
// Reports errors using assert.  Checking can be disabled with
// NDEBUG, but it's far better to just use the underlying allocator
// instead when no checking is desired.
// There is some evidence that this can confuse Purify.
// This adaptor can only be applied to raw allocators

template <class _Alloc>
class __debug_alloc : public _Alloc {
public:
  typedef _Alloc __allocator_type;
  typedef typename _Alloc::value_type value_type;
private:
  struct __alloc_header {
    size_t __magic: 16;
    size_t __type_size:16;
    unsigned long _M_size;
  }; // that is 8 bytes for sure
  // Sunpro CC has bug on enums, so extra_before/after set explicitly
  enum __attribute__((__packed__)) { __pad = 8, __magic = 0xdeba, __deleted_magic = 0xdebd,
         __shred_byte = 0xA3 };

  enum __attribute__((__packed__)) { __extra_before = 16, __extra_after = 8 };
  // Size of space used to store size.  Note
  // that this must be large enough to preserve
  // alignment.
  static size_t  __extra_before_chunk() {
    return (long)__extra_before / sizeof(value_type) +
      (size_t)((long)__extra_before % sizeof(value_type) > 0);
  }
  static size_t  __extra_after_chunk() {
    return (long)__extra_after / sizeof(value_type) +
      (size_t)((long)__extra_after % sizeof(value_type) > 0);
  }
public:
  __debug_alloc() {}
  ~__debug_alloc() {}
  static void*  allocate(size_t);
  static void  deallocate(void *, size_t);
};

enum __attribute__((__packed__)) { _MAX_BYTES = 32 * sizeof(void*) };

// Default node allocator.
// With a reasonable compiler, this should be roughly as fast as the
// original STL class-specific allocators, but with less fragmentation.
class  __node_alloc {
  static void *  _M_allocate(size_t& __n);
  /* __p may not be 0 */
  static void  _M_deallocate(void *__p, size_t __n);

public:
  // this one is needed for proper simple_alloc wrapping
  typedef char value_type;
  /* __n must be > 0      */
  static void*  allocate(size_t& __n)
  { return (__n > (size_t)_MAX_BYTES) ? __stl_new(__n) : _M_allocate(__n); }
  /* __p may not be 0 */
  static void  deallocate(void *__p, size_t __n)
  { if (__n > (size_t)_MAX_BYTES) __stl_delete(__p); else _M_deallocate(__p, __n); }
};




/* macro to convert the allocator for initialization
 * not using MEMBER_TEMPLATE_CLASSES as it should work given template constructor  */
/* if _STLP_NO_TEMPLATE_CONVERSIONS is set, the member template constructor is
 * not used implicitly to convert allocator parameter, so let us do it explicitly */
/* else convert, but only if partial specialization works, since else
 * Container::allocator_type won't be different */

// Another allocator adaptor: _Alloc_traits.  This serves two
// purposes.  First, make it possible to write containers that can use
// either SGI-style allocators or standard-conforming allocator.

// The fully general version.
template <class _Tp, class _Allocator>
struct _Alloc_traits {
  typedef _Allocator _Orig;
  typedef typename _Allocator::template rebind<_Tp> _Rebind_type;
  typedef typename _Rebind_type::other  allocator_type;
  static allocator_type create_allocator(const _Orig& __a)
  { return allocator_type(__a); }
};

typedef __new_alloc __alloc_type;

typedef __alloc_type __sgi_alloc;

typedef __sgi_alloc __single_client_alloc;
typedef __sgi_alloc __multithreaded_alloc;

// This implements allocators as specified in the C++ standard.
//
// Note that standard-conforming allocators use many language features
// that are not yet widely implemented.  In particular, they rely on
// member templates, partial specialization, partial ordering of function
// templates, the typename keyword, and the use of the template keyword
// to refer to a template member of a dependent type.

/*
template <class _Tp>
struct _AllocatorAux {
  typedef _Tp*       pointer;
  typedef const _Tp* const_pointer;
  typedef _Tp&       reference;
  typedef const _Tp& const_reference;

  pointer address(reference __x) const {return &__x;}
  const_pointer address(const_reference __x) const { return &__x; }
};

template <class _Tp>
struct _AllocatorAux<const _Tp> {
  typedef _Tp*       pointer;
  typedef const _Tp* const_pointer;
  typedef _Tp&       reference;
  typedef const _Tp& const_reference;

  const_pointer address(const_reference __x) const { return &__x; }
};
*/

template <class _Tp>
class allocator //: public _AllocatorAux<_Tp>
/* A small helper struct to recognize STLport allocator implementation
 * from any user specialization one.
 */
                : public __stlport_class<allocator<_Tp> >
{
public:
  typedef _Tp        value_type;
  typedef _Tp*       pointer;
  typedef const _Tp* const_pointer;
  typedef _Tp&       reference;
  typedef const _Tp& const_reference;
  typedef size_t     size_type;
  typedef ptrdiff_t  difference_type;
  template <class _Tp1> struct rebind {
    typedef allocator<_Tp1> other;
  };
  allocator()  {}
  template <class _Tp1> allocator(const allocator<_Tp1>&)  {}
  allocator(const allocator<_Tp>&)  {}
  allocator(__move_source<allocator<_Tp> > src)  {}
  ~allocator()  {}
  pointer address(reference __x) const {return &__x;}
  const_pointer address(const_reference __x) const { return &__x; }
  // __n is permitted to be 0.  The C++ standard says nothing about what the return value is when __n == 0.
  _Tp* allocate(size_type __n, const void* = 0) {
    if (__n > max_size()) {
      puts("out of memory\n"); exit(1);
    }
    if (__n != 0) {
      size_type __buf_size = __n * sizeof(value_type);
      _Tp* __ret = reinterpret_cast<_Tp* >(__sgi_alloc::allocate(__buf_size));
      return __ret;
    }

    return 0;
  }
  // __p is permitted to be a null pointer, only if n==0.
  void deallocate(pointer __p, size_type __n) {
    
    if (__p != 0) {
      __sgi_alloc::deallocate((void*)__p, __n * sizeof(value_type));
    }
  }
  // backwards compatibility
  void deallocate(pointer __p) const {  if (__p != 0) __sgi_alloc::deallocate((void*)__p, sizeof(value_type)); }
  size_type max_size() const   { return size_t(-1) / sizeof(value_type); }
  void construct(pointer __p, const_reference __val) { ::std::_Copy_Construct(__p, __val); }
  void destroy(pointer __p) { ::std::_Destroy(__p); }

  _Tp* _M_allocate(size_type __n, size_type& __allocated_n) {
    if (__n > max_size()) {
      puts("out of memory\n"); exit(1);
    }

    if (__n != 0) {
      size_type __buf_size = __n * sizeof(value_type);
      _Tp* __ret = reinterpret_cast<_Tp* >(__sgi_alloc::allocate(__buf_size));
      __allocated_n = __buf_size / sizeof(value_type);
      return __ret;
    }

    return 0;
  }
};

template< >
class  allocator<void> {
public:
  typedef size_t      size_type;
  typedef ptrdiff_t   difference_type;
  typedef void*       pointer;
  typedef const void* const_pointer;
  typedef void        value_type;
  template <class _Tp1> struct rebind {
    typedef allocator<_Tp1> other;
  };
};

template <class _T1, class _T2>
inline bool  operator==(const allocator<_T1>&, const allocator<_T2>&) 
{ return true; }
template <class _T1, class _T2>
inline bool  operator!=(const allocator<_T1>&, const allocator<_T2>&) 
{ return false; }


namespace priv {

template <class _Tp>
struct __alloc_type_traits {
  typedef typename _IsSTLportClass<allocator<_Tp> >::_Ret _STLportAlloc;
  //The default allocator implementation which is recognize thanks to the
  //__stlport_class inheritance is a stateless object so:
  typedef _STLportAlloc has_trivial_default_constructor;
  typedef _STLportAlloc has_trivial_copy_constructor;
  typedef _STLportAlloc has_trivial_assignment_operator;
  typedef _STLportAlloc has_trivial_destructor;
  typedef _STLportAlloc is_POD_type;
};

}

template <class _Tp>
struct __type_traits<allocator<_Tp> > : ::std::priv:: __alloc_type_traits<_Tp> {};




template <class _Tp, class _Alloc>
inline typename _Alloc_traits<_Tp, _Alloc>::allocator_type  
__stl_alloc_create(const _Alloc& __a, const _Tp*) {
  typedef typename _Alloc::template rebind<_Tp>::other _Rebound_type;
  return _Rebound_type(__a);
}

namespace priv {

// inheritance is being used for EBO optimization
template <class _Value, class _Tp, class _MaybeReboundAlloc>
class _STLP_alloc_proxy : public _MaybeReboundAlloc {
private:
  typedef _MaybeReboundAlloc _Base;
  typedef typename _Base::size_type size_type;
  typedef _STLP_alloc_proxy<_Value, _Tp, _MaybeReboundAlloc> _Self;
public:
  _Value _M_data;

  _STLP_alloc_proxy (const _MaybeReboundAlloc& __a, _Value __p) :
    _MaybeReboundAlloc(__a), _M_data(__p) {}

  _STLP_alloc_proxy (__move_source<_Self> src) :
    _Base(::std::priv:: _AsMoveSource(src.get()._M_base())),
    _M_data(::std::priv:: _AsMoveSource(src.get()._M_data)) {}

  _Base& _M_base()
  { return *this; }

private:
  /* Following are helper methods to detect stateless allocators and avoid
   * swap in this case. For some compilers (VC6) it is a workaround for a
   * compiler bug in the Empty Base class Optimization feature, for others
   * it is a small optimization or nothing if no EBO. */
  void _M_swap_alloc(_Self&, const __true_type& /*_IsStateless*/)
  {}

  void _M_swap_alloc(_Self& __x, const __false_type& /*_IsStateless*/) {
    _MaybeReboundAlloc &__base_this = *this;
    _MaybeReboundAlloc &__base_x = __x;
    ::std::swap(__base_this, __base_x);
  }

public:
  void _M_swap_alloc(_Self& __x) {
    typedef typename _IsStateless<_MaybeReboundAlloc>::_Ret _StatelessAlloc;
    _M_swap_alloc(__x, _StatelessAlloc());
  }

  /* We need to define the following swap implementation for allocator with state
   * as those allocators might have implement a special swap function to correctly
   * move datas from an instance to the oher, _STLP_alloc_proxy should not break
   * this mecanism. */
  void swap(_Self& __x) {
    _M_swap_alloc(__x);
    ::std::swap(_M_data, __x._M_data);
  }

  _Tp* allocate(size_type __n, size_type& __allocated_n) {
    typedef typename _IsSTLportClass<_MaybeReboundAlloc>::_Ret _STLportAlloc;
    return allocate(__n, __allocated_n, _STLportAlloc());
  }

  // Unified interface to perform allocate()/deallocate() with limited
  // language support
  //Expose Standard allocate overload (using expression do not work for some compilers (Borland))
  _Tp* allocate(size_type __n)
  { return _Base::allocate(__n); }
private:
  _Tp* allocate(size_type __n, size_type& __allocated_n, const __true_type& /*STLport allocator*/)
  { return _Base::_M_allocate(__n, __allocated_n); }

  _Tp* allocate(size_type __n, size_type& __allocated_n, const __false_type& /*STLport allocator*/)
  { __allocated_n = __n; return allocate(__n); }
};


}
}

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */



namespace std {

template <class _Alloc>
void *  __debug_alloc<_Alloc>::allocate(size_t __n) {
  size_t __total_extra = __extra_before_chunk() + __extra_after_chunk();
  size_t __real_n = __n + __total_extra;
  if (__real_n < __n) {
    //It means that we rolled on size_t, __n must be very large:
    puts("out of memory\n"); exit(1);
  }
  __alloc_header *__result = (__alloc_header *)__allocator_type::allocate(__real_n);
  memset((char*)__result, __shred_byte, __real_n * sizeof(value_type));
  __result->__magic = __magic;
  __result->__type_size = sizeof(value_type);
  __result->_M_size = (unsigned long)__n;
  return ((char*)__result) + (long)__extra_before;
}

template <class _Alloc>
void  
__debug_alloc<_Alloc>::deallocate(void *__p, size_t __n) {
  __alloc_header * __real_p = (__alloc_header*)((char *)__p -(long)__extra_before);
  // check integrity
  
  
  
  
  // check pads on both sides
  unsigned char* __tmp;
  for (__tmp = (unsigned char*)(__real_p + 1); __tmp < (unsigned char*)__p; ++__tmp) {
    
  }

  size_t __real_n = __n + __extra_before_chunk() + __extra_after_chunk();

  for (__tmp= ((unsigned char*)__p) + __n * sizeof(value_type);
       __tmp < ((unsigned char*)__real_p) + __real_n ; ++__tmp) {
    
  }

  // that may be unfortunate, just in case
  __real_p->__magic = __deleted_magic;
  memset((char*)__p, __shred_byte, __n * sizeof(value_type));
  __allocator_type::deallocate(__real_p, __real_n);
}

}


// Local Variables:
// mode:C++
// End:


// Local Variables:
// mode:C++
// End:


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/



// This file provides forward declarations of the most important I/O
// classes.  Note that almost all of those classes are class templates,
// with default template arguments.  According to the C++ standard,
// if a class template is declared more than once in the same scope
// then only one of those declarations may have default arguments.

// <iosfwd> contains the same declarations as other headers, and including
// both <iosfwd> and (say) <iostream> is permitted.  This means that only
// one header may contain those default template arguments.

// In this implementation, the declarations in <iosfwd> contain default
// template arguments.  All of the other I/O headers include <iosfwd>.

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


// Define char_traits






/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */



/*-
 * Copyright (c)1999 Citrus Project,
 * All rights reserved.
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: release/10.0.0/include/wchar.h 247411 2013-02-27 19:50:46Z jhb $
 */

/*-
 * Copyright (c) 1999, 2000 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Julian Coleman.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *	$NetBSD: wchar.h,v 1.8 2000/12/22 05:31:42 itojun Exp $
 */


/*****************************************************************************/
/* STDIO.H v16.12.0                                                          */
/*                                                                           */
/* Copyright (c) 1993-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/



/*****************************************************************************/
/* stddef.h   v16.12.0                                                       */
/*                                                                           */
/* Copyright (c) 1993-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/



#pragma diag_push
#pragma CHECK_MISRA("-19.15") /* code outside guard; see below comment */

/*-----------------------------------------------------------------------*/
/* Define _win_t, for compiling GCC libraries with the TI compiler.      */
/* GCC's library (newlib) expects wint_t to be defined here, in stddef.h,*/
/* which is arguably incorrect, but we go along for compatibility.       */
/* This is outside the _STDDEF guard in case this file has already       */
/* been included without __need_wint_t.                                  */
/*-----------------------------------------------------------------------*/

#pragma diag_pop

extern "C" namespace std {




typedef int _Mbstatet;

typedef _Mbstatet mbstate_t;
struct tm;

typedef int wint_t;


 wint_t   btowc   (int);
 wint_t   fgetwc  (FILE *);
 wint_t   fputwc  (wchar_t, FILE *);
 int      fwide   (FILE *, int);
 size_t   mbrtowc (wchar_t * __restrict,
                               const char * __restrict,
                               size_t,
                               mbstate_t * __restrict);
 wint_t   ungetwc (wint_t, FILE *);
 size_t   wcrtomb (char * __restrict,
                               wchar_t,
                               mbstate_t * __restrict);
 int      wcscmp  (const wchar_t *, const wchar_t *);
 size_t   wcslen  (const wchar_t *);
 int      wcsncmp (const wchar_t *, const wchar_t*, size_t);
 wchar_t *wcsncpy (wchar_t * __restrict,
                               const wchar_t * __restrict,
                               size_t);
 int      wctob   (wint_t);
 wchar_t *wmemchr (const wchar_t *, wchar_t, size_t);
 int      wmemcmp (const wchar_t *, const wchar_t*, size_t);
 wchar_t *wmemcpy (wchar_t * __restrict,
                               const wchar_t * __restrict,
                               size_t);
 wchar_t *wmemmove(wchar_t *, const wchar_t *, size_t);
 wchar_t *wmemset (wchar_t *, wchar_t, size_t);



}

using std::mbstate_t;
using std::wint_t;




/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */











namespace std {

template <class _Tp> class allocator;


typedef long streamoff;

typedef ptrdiff_t streamsize;

// Class fpos, which represents a position within a file.  (The C++
// standard calls for it to be defined in <ios>.  This implementation
// moves it to <iosfwd>, which is included by <ios>.)
template <class _StateT> class fpos {
public:                         // From table 88 of the C++ standard.
  fpos(streamoff __pos) : _M_pos(__pos), _M_st(_StateT()) {}
  fpos() : _M_pos(0), _M_st(_StateT()) {}

  operator streamoff() const { return _M_pos; }

  bool operator==(const fpos& __y) const
  { return _M_pos == __y._M_pos; }
  bool operator!=(const fpos& __y) const
  { return _M_pos != __y._M_pos; }

  fpos& operator+=(streamoff __off) {
    _M_pos += __off;
    return *this;
  }
  fpos& operator-=(streamoff __off) {
    _M_pos -= __off;
    return *this;
  }

  fpos operator+(streamoff __off) {
    fpos __tmp(*this);
    __tmp += __off;
    return __tmp;
  }
  fpos operator-(streamoff __off) {
    fpos __tmp(*this);
    __tmp -= __off;
    return __tmp;
  }

public:                         // Manipulation of the state member.
  _StateT state() const { return _M_st; }
  void state(_StateT __st) { _M_st = __st; }
private:
  streamoff _M_pos;
  _StateT _M_st;
};

typedef fpos<mbstate_t> streampos;
typedef fpos<mbstate_t> wstreampos;

// Class __char_traits_base.
template <class _CharT, class _IntT>
class __char_traits_base {
public:
  typedef _CharT char_type;
  typedef _IntT int_type;
  typedef streamoff off_type;
  typedef streampos pos_type;
  typedef mbstate_t state_type;

  static void  assign(char_type& __c1, const char_type& __c2) { __c1 = __c2; }
  static bool  eq(const char_type& __c1, const char_type& __c2)
  { return __c1 == __c2; }
  static bool  lt(const char_type& __c1, const char_type& __c2)
  { return __c1 < __c2; }

  static int  compare(const char_type* __s1, const char_type* __s2, size_t __n) {
    for (size_t __i = 0; __i < __n; ++__i)
      if (!eq(__s1[__i], __s2[__i]))
        return __s1[__i] < __s2[__i] ? -1 : 1;
    return 0;
  }

  static size_t  length(const char_type* __s) {
    const char_type _NullChar = char_type();
    size_t __i(0);
    for (; !eq(__s[__i], _NullChar); ++__i) {}
    return __i;
  }

  static const char_type*  find(const char_type* __s, size_t __n, const char_type& __c) {
    for ( ; __n > 0 ; ++__s, --__n)
      if (eq(*__s, __c))
        return __s;
    return 0;
  }

  static char_type*  move(char_type* __s1, const char_type* __s2, size_t _Sz)
  { return (_Sz == 0 ? __s1 : (char_type*)memmove(__s1, __s2, _Sz * sizeof(char_type))); }

  static char_type*  copy(char_type* __s1, const char_type* __s2, size_t __n) {
    return (__n == 0 ? __s1 :
      (char_type*)memcpy(__s1, __s2, __n * sizeof(char_type)));
  }

  static char_type*  assign(char_type* __s, size_t __n, char_type __c) {
    for (size_t __i = 0; __i < __n; ++__i)
      __s[__i] = __c;
    return __s;
  }

  static int_type  not_eof(const int_type& __c)
  { return !eq_int_type(__c, eof()) ? __c : static_cast<int_type>(0); }

  static char_type  to_char_type(const int_type& __c)
  { return (char_type)__c; }

  static int_type  to_int_type(const char_type& __c)
  { return (int_type)__c; }

  static bool  eq_int_type(const int_type& __c1, const int_type& __c2)
  { return __c1 == __c2; }

  static int_type  eof()
  { return (int_type)-1; }
};

// Generic char_traits class.  Note that this class is provided only
//  as a base for explicit specialization; it is unlikely to be useful
//  as is for any particular user-defined type.  In particular, it
//  *will not work* for a non-POD type.

template <class _CharT>
class char_traits
  : public __char_traits_base<_CharT, _CharT> {};

// Specialization for char.

template< >
class  char_traits<char>
  : public __char_traits_base<char, int>,
    public __stlport_class<char_traits<char> > {
public:
  typedef char char_type;
  typedef int int_type;
  typedef streamoff off_type;
  typedef streampos pos_type;
  typedef mbstate_t state_type;

  static char  to_char_type(const int& __c)
  { return (char)(unsigned char)__c; }

  static int  to_int_type(const char& __c)
  { return (unsigned char)__c; }

  static int  compare(const char* __s1, const char* __s2, size_t __n)
  { return memcmp(__s1, __s2, __n); }

  static size_t  length(const char* __s)
  { return strlen(__s); }

  static void  assign(char& __c1, const char& __c2)
  { __c1 = __c2; }

  static char*  assign(char* __s, size_t __n, char __c) {
    memset(__s, __c, __n);
    return __s;
  }
};

// Specialization for wchar_t.
template< >
class  char_traits<wchar_t>
  : public __char_traits_base<wchar_t, wint_t> {
public:
  static wchar_t*  move(wchar_t* __dest, const wchar_t* __src, size_t __n)
  { return wmemmove(__dest, __src, __n); }

  static wchar_t*  copy(wchar_t* __dest, const wchar_t* __src, size_t __n)
  { return wmemcpy(__dest, __src, __n); }

  static int  compare(const wchar_t* __s1, const wchar_t* __s2, size_t __n)
  { return wmemcmp(__s1, __s2, __n); }

  static wchar_t*  assign(wchar_t* __s, size_t __n, wchar_t __c)
  { return wmemset(__s, __c, __n); }

  static size_t  length(const wchar_t* __s)
  { return wcslen(__s); }

  static void  assign(wchar_t& __c1, const wchar_t& __c2)
  { __c1 = __c2; }
};

}


// Local Variables:
// mode:C++
// End:

namespace std {

class ios_base;

template <class _CharT, class _Traits = char_traits<_CharT> >
class basic_ios;

template <class _CharT, class _Traits = char_traits<_CharT> >
class basic_streambuf;

template <class _CharT, class _Traits = char_traits<_CharT> >
class basic_istream;

template <class _CharT, class _Traits = char_traits<_CharT> >
class basic_ostream;

template <class _CharT, class _Traits = char_traits<_CharT> >
class basic_iostream;

template <class _CharT, class _Traits = char_traits<_CharT>,
          class _Allocator = allocator<_CharT> >
class basic_stringbuf;

template <class _CharT, class _Traits = char_traits<_CharT>,
          class _Allocator = allocator<_CharT> >
class basic_istringstream;

template <class _CharT, class _Traits = char_traits<_CharT>,
          class _Allocator = allocator<_CharT> >
class basic_ostringstream;

template <class _CharT, class _Traits = char_traits<_CharT>,
          class _Allocator = allocator<_CharT> >
class basic_stringstream;

template <class _CharT, class _Traits = char_traits<_CharT> >
class basic_filebuf;

template <class _CharT, class _Traits = char_traits<_CharT> >
class basic_ifstream;

template <class _CharT, class _Traits = char_traits<_CharT> >
class basic_ofstream;

template <class _CharT, class _Traits = char_traits<_CharT> >
class basic_fstream;

template <class _CharT, class _Traits = char_traits<_CharT> >
class istreambuf_iterator;

template <class _CharT, class _Traits = char_traits<_CharT> >
class ostreambuf_iterator;

typedef basic_ios<char, char_traits<char> >    ios;

typedef basic_ios<wchar_t, char_traits<wchar_t> > wios;

// Forward declaration of class locale, and of the most important facets.
class locale;
template <class _Facet>
inline const _Facet& use_facet(const locale&);

template <class _CharT> class ctype;
template <class _CharT> class ctype_byname;
template <class _CharT> class collate;
template <class _CharT> class collate_byname;

template< > class ctype<char>;
template< > class ctype_byname<char>;
template< > class collate<char>;
template< > class collate_byname<char>;

template< > class ctype<wchar_t>;
template< > class ctype_byname<wchar_t>;
template< > class collate<wchar_t>;
template< > class collate_byname<wchar_t>;

// Typedefs for ordinary (narrow-character) streams.
//_STLP_TEMPLATE_NULL class basic_streambuf<char, char_traits<char> >;

typedef basic_istream<char, char_traits<char> >  istream;
typedef basic_ostream<char, char_traits<char> >  ostream;
typedef basic_iostream<char, char_traits<char> > iostream;
typedef basic_streambuf<char,char_traits<char> > streambuf;

typedef basic_stringbuf<char, char_traits<char>, allocator<char> >     stringbuf;
typedef basic_istringstream<char, char_traits<char>, allocator<char> > istringstream;
typedef basic_ostringstream<char, char_traits<char>, allocator<char> > ostringstream;
typedef basic_stringstream<char, char_traits<char>, allocator<char> >  stringstream;

typedef basic_filebuf<char, char_traits<char> >  filebuf;
typedef basic_ifstream<char, char_traits<char> > ifstream;
typedef basic_ofstream<char, char_traits<char> > ofstream;
typedef basic_fstream<char, char_traits<char> >  fstream;

// Typedefs for wide-character streams.
typedef basic_streambuf<wchar_t, char_traits<wchar_t> > wstreambuf;
typedef basic_istream<wchar_t, char_traits<wchar_t> >   wistream;
typedef basic_ostream<wchar_t, char_traits<wchar_t> >   wostream;
typedef basic_iostream<wchar_t, char_traits<wchar_t> >  wiostream;

typedef basic_stringbuf<wchar_t, char_traits<wchar_t>, allocator<wchar_t> >     wstringbuf;
typedef basic_istringstream<wchar_t, char_traits<wchar_t>, allocator<wchar_t> > wistringstream;
typedef basic_ostringstream<wchar_t, char_traits<wchar_t>, allocator<wchar_t> > wostringstream;
typedef basic_stringstream<wchar_t, char_traits<wchar_t>, allocator<wchar_t> >  wstringstream;

typedef basic_filebuf<wchar_t, char_traits<wchar_t> >  wfilebuf;
typedef basic_ifstream<wchar_t, char_traits<wchar_t> > wifstream;
typedef basic_ofstream<wchar_t, char_traits<wchar_t> > wofstream;
typedef basic_fstream<wchar_t, char_traits<wchar_t> >  wfstream;

}


// Local Variables:
// mode:C++
// End:

namespace std {

template <class _CharT,
          class _Traits = char_traits<_CharT>,
          class _Alloc = allocator<_CharT> >
class basic_string;

typedef basic_string<char, char_traits<char>, allocator<char> > string;

typedef basic_string<wchar_t, char_traits<wchar_t>, allocator<wchar_t> > wstring;

namespace priv {

//This function limits header dependency between exception and string
//implementation. It is implemented in _string.h
const char*  __get_c_string(const string& __str);

}

}


// Local Variables:
// mode:C++
// End:





/*
 * Copyright (c) 2003
 * Francois Dumont
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


namespace std {

namespace priv {

/*char wrapper to simulate basic_string*/
template <class _CharT>
struct __char_wrapper {
  typedef const _CharT& const_reference;

  __char_wrapper(_CharT __val) : _Val(__val) {}

  _CharT getValue() const { return _Val; }
  size_t size() const { return 1; }

  const_reference operator[] (size_t __n) const {
    //To avoid a check on __n we use this strange implementation
    return (&_Val)[__n];
  }

private:
  _CharT _Val;
};

/*C string wrapper to simulate basic_string*/
template <class _CharT>
struct __cstr_wrapper {
  typedef const _CharT& const_reference;

  __cstr_wrapper(const _CharT *__cstr, size_t __size) :
    _CStr(__cstr), _Size(__size) {}

  const _CharT* c_str() const { return _CStr; }

  size_t size() const { return _Size; }

  const_reference operator[] (size_t __n) const { return _CStr[__n]; }

private:
  const _CharT *_CStr;
  size_t _Size;
};

/*basic_string wrapper to ensure that we only store a reference to the original string and not copy it*/
template <class _CharT, class _Traits, class _Alloc>
struct __bstr_wrapper {
  typedef const _CharT& const_reference;
  typedef basic_string<_CharT, _Traits, _Alloc> _BString;

  __bstr_wrapper (_BString const& __s) :
    _BStr(__s) {}

  size_t size() const { return _BStr.size(); }

  const_reference operator[] (size_t __n) const { return _BStr[__n]; }

  _BString const& b_str() const { return _BStr; }

private:
  _BString const& _BStr;
};

struct __on_left {};
struct __on_right {};

template <class _CharT, class _Traits, class _Alloc,
          class _Left, class _Right,
          class _StorageDirection>
class __bstr_sum {
public:
  typedef basic_string<_CharT, _Traits, _Alloc> _BString;
  typedef typename _BString::const_reference const_reference;
  typedef typename _BString::const_iterator const_iterator;
  typedef typename _BString::const_reverse_iterator const_reverse_iterator;
  typedef typename _BString::size_type size_type;
  typedef typename _BString::allocator_type allocator_type;
  typedef __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDirection> _Self;

  __bstr_sum (_Left const& lhs, _Right const& rhs) :
    _lhs(lhs), _rhs(rhs) {}

  _Left const& getLhs() const { return _lhs; }
  _Right const& getRhs() const { return _rhs; }

  allocator_type get_allocator() const { return _M_get_storage(false).get_allocator(); }

  const_iterator begin() const { return _M_get_storage().begin(); }
  const_iterator end()   const { return _M_get_storage().end(); }
  const_reverse_iterator rbegin() const { return _M_get_storage().rbegin(); }
  const_reverse_iterator rend()   const { return _M_get_storage().rend(); }

  size_type size() const { return _lhs.size() + _rhs.size(); }
  size_type length() const { return size(); }

  size_t max_size() const { return _M_get_storage().max_size(); }
  size_type capacity() const { return size(); }
  bool empty() const { return size() == 0; }

  const_reference operator[](size_t __n) const
  { return (__n < _lhs.size())?_lhs[__n]:_rhs[__n - _lhs.size()]; }

  const_reference at(size_type __n) const
  { return _M_get_storage().at(__n); }

  //operator +=
  typedef __bstr_sum<_CharT, _Traits, _Alloc, _Self, __bstr_wrapper<_CharT, _Traits, _Alloc>, __on_left> _BStrOnLeft;
  _BStrOnLeft operator += (const _BString& __s) { return append(__s); }

  typedef __bstr_sum<_CharT, _Traits, _Alloc, _Self, __cstr_wrapper<_CharT>, __on_left> _CStrOnLeft;
  _CStrOnLeft operator += (const _CharT* __s) { return append(__s); }

  typedef __bstr_sum<_CharT, _Traits, _Alloc, _Self, __char_wrapper<_CharT>, __on_left> _CharOnLeft;
  _CharOnLeft operator += (_CharT __c) { return _CharOnLeft(*this, __c); }

  //append
  _BStrOnLeft append (const _BString& __s)
  { return _BStrOnLeft(*this, __s); }
  _BString& append(const _BString& __s, size_type __pos, size_type __n)
  { return _M_get_storage().append(__s, __pos, __n); }
  _CStrOnLeft append(const _CharT* __s) {
    const size_type __n = _Traits::length(__s);
    return _CStrOnLeft(*this, __cstr_wrapper<_CharT>(__s, __n));
  }
  _CStrOnLeft append(const _CharT* __s, size_type __n)
  { return _CStrOnLeft(*this, __cstr_wrapper<_CharT>(__s, __n)); }
  _BString& append(size_type __n, _CharT __c)
  {return _M_get_storage().append(__n, __c);}
  template <class _InputIter>
  _BString& append(_InputIter __first, _InputIter __last)
  {return _M_get_storage().append(__first, __last);}

  //assign
  _BString& assign(const _BString& __s) {return _M_get_storage().assign(__s);}
  _BString& assign(const _BString& __s, size_type __pos, size_type __n) {return _M_get_storage().assign(__s, __pos, __n);}
  _BString& assign(const _CharT* __s, size_type __n) {return _M_get_storage().assign(__s, __n);}
  _BString& assign(const _CharT* __s) {return _M_get_storage().assign(__s); }
  _BString& assign(size_type __n, _CharT __c) {return _M_get_storage().assign(__n, __c);}

  //insert
  _BString& insert(size_type __pos, const _BString& __s) {return _M_get_storage().insert(__pos, __s);}
  _BString& insert(size_type __pos, const _BString& __s, size_type __beg, size_type __n)
  {return _M_get_storage().insert(__pos, __s, __beg, __n);}
  _BString& insert(size_type __pos, const _CharT* __s, size_type __n) {return _M_get_storage().insert(__pos, __s, __n);}
  _BString& insert(size_type __pos, const _CharT* __s) {return _M_get_storage().insert(__pos, __s);}
  _BString& insert(size_type __pos, size_type __n, _CharT __c) {return _M_get_storage().insert(__pos, __n, __c);}

  //erase
  _BString& erase(size_type __pos = 0, size_type __n =_BString::npos) {return _M_get_storage().erase(__pos, __n);}

  //replace
  _BString& replace(size_type __pos, size_type __n, const _BString& __s)
  {return _M_get_storage().replace(__pos, __n, __s);}
  _BString& replace(size_type __pos1, size_type __n1, const _BString& __s, size_type __pos2, size_type __n2)
  {return _M_get_storage().replace(__pos1, __n1, __s, __pos2, __n2);}
  _BString& replace(size_type __pos, size_type __n1, const _CharT* __s, size_type __n2)
  {return _M_get_storage().replace(__pos, __n1, __s, __n2);}
  _BString& replace(size_type __pos, size_type __n1, const _CharT* __s)
  {return _M_get_storage().replace(__pos, __n1, __s);}
  _BString& replace(size_type __pos, size_type __n1, size_type __n2, _CharT __c)
  {return _M_get_storage().replace(__pos, __n1, __n2, __c);}

  size_type copy(_CharT* __s, size_type __n, size_type __pos = 0) const
  {return _M_get_storage().copy(__s, __n, __pos);}

  void swap(_BString& __s)
  {_M_get_storage().swap(__s);}

  const _CharT* c_str() const { return _M_get_storage().c_str(); }
  const _CharT* data()  const { return _M_get_storage().data(); }

  //find family
  size_type find(const _BString& __s, size_type __pos = 0) const { return _M_get_storage().find(__s, __pos); }
  size_type find(const _CharT* __s, size_type __pos = 0) const { return _M_get_storage().find(__s, __pos); }
  size_type find(const _CharT* __s, size_type __pos, size_type __n) const { return _M_get_storage().find(__s, __pos, __n); }
  size_type find(_CharT __c, size_type __pos = 0) const { return _M_get_storage().find(__c, __pos); }

  size_type rfind(const _BString& __s, size_type __pos = _BString::npos) const { return _M_get_storage().rfind(__s, __pos); }
  size_type rfind(const _CharT* __s, size_type __pos = _BString::npos) const { return _M_get_storage().rfind(__s, __pos); }
  size_type rfind(const _CharT* __s, size_type __pos, size_type __n) const { return _M_get_storage().rfind(__s, __pos, __n); }
  size_type rfind(_CharT __c, size_type __pos = _BString::npos) const { return _M_get_storage().rfind(__c, __pos); }

  size_type find_first_of(const _BString& __s, size_type __pos = 0) const
  { return _M_get_storage().find_first_of(__s, __pos); }
  size_type find_first_of(const _CharT* __s, size_type __pos = 0) const
  { return _M_get_storage().find_first_of(__s, __pos); }
  size_type find_first_of(const _CharT* __s, size_type __pos, size_type __n) const
  { return _M_get_storage().find_first_of(__s, __pos, __n); }
  size_type find_first_of(_CharT __c, size_type __pos = 0) const
  { return _M_get_storage().find(__c, __pos); }

  size_type find_last_of(const _BString& __s, size_type __pos = _BString::npos) const
  { return _M_get_storage().find_last_of(__s, __pos); }
  size_type find_last_of(const _CharT* __s, size_type __pos = _BString::npos) const
  { return _M_get_storage().find_last_of(__s, __pos); }
  size_type find_last_of(const _CharT* __s, size_type __pos, size_type __n) const
  { return _M_get_storage().find_last_of(__s, __pos, __n); }
  size_type find_last_of(_CharT __c, size_type __pos = _BString::npos) const
  { return _M_get_storage().rfind(__c, __pos); }

  size_type find_first_not_of(const _BString& __s, size_type __pos = 0) const
  { return _M_get_storage().find_first_not_of(__s, __pos); }
  size_type find_first_not_of(const _CharT* __s, size_type __pos = 0) const
  { return _M_get_storage().find_first_not_of(__s, __pos); }
  size_type find_first_not_of(const _CharT* __s, size_type __pos, size_type __n) const
  { return _M_get_storage().find_first_not_of(__s, __pos, __n); }
  size_type find_first_not_of(_CharT __c, size_type __pos = 0) const
  { return _M_get_storage().find_first_not_of(__c, __pos); }

  size_type find_last_not_of(const _BString& __s, size_type __pos = _BString::npos) const
  { return _M_get_storage().find_last_not_of(__s, __pos); }
  size_type find_last_not_of(const _CharT* __s, size_type __pos =_BString:: npos) const
  { return _M_get_storage().find_last_not_of(__s, __pos); }
  size_type find_last_not_of(const _CharT* __s, size_type __pos, size_type __n) const
  { return _M_get_storage().find_last_not_of(__s, __pos, __n); }
  size_type find_last_not_of(_CharT __c, size_type __pos = _BString::npos) const
  { return _M_get_storage().find_last_not_of(__c, __pos); }

  _BString substr(size_type __pos = 0, size_type __n = _BString::npos) const
  { return _M_get_storage().substr(__pos, __n); }

  //compare
  int compare(const _BString& __s) const
  { return _M_get_storage().compare(__s); }
  int compare(size_type __pos1, size_type __n1, const _Self& __s) const
  { return _M_get_storage().compare(__pos1, __n1, __s); }
  int compare(size_type __pos1, size_type __n1, const _Self& __s, size_type __pos2, size_type __n2) const
  { return _M_get_storage().compare(__pos1, __n1, __s, __pos2, __n2); }
  int compare(const _CharT* __s) const
  { return _M_get_storage().compare(__s); }
  int compare(size_type __pos1, size_type __n1, const _CharT* __s) const
  { return _M_get_storage().compare(__pos1, __n1, __s); }
  int compare(size_type __pos1, size_type __n1, const _CharT* __s, size_type __n2) const
  { return _M_get_storage().compare(__pos1, __n1, __s, __n2); }

  //Returns the underlying basic_string representation of the template expression
  //The non const method will always initialise it.
  _BString& _M_get_storage()
  { return _rhs._M_get_storage(*this, _StorageDirection()); }

  template <class _Lhs, class _Rhs, class _StorageDir>
  _BString& _M_get_storage(__bstr_sum<_CharT, _Traits, _Alloc, _Lhs, _Rhs, _StorageDir>  const& __ref,
                           __on_left const& /*StorageDir*/)
  { return _lhs._M_get_storage(__ref); }

  template <class _Lhs, class _Rhs, class _StorageDir>
  _BString& _M_get_storage(__bstr_sum<_CharT, _Traits, _Alloc, _Lhs, _Rhs, _StorageDir>  const& __ref,
                           __on_right const& /*StorageDir*/)
  { return _rhs._M_get_storage(__ref); }

  template <class _Lhs, class _Rhs, class _StorageDir>
  _BString& _M_get_storage(__bstr_sum<_CharT, _Traits, _Alloc, _Lhs, _Rhs, _StorageDir>  const& __ref)
  { return _M_get_storage(__ref, _StorageDirection()); }

  //The const method can be invoked without initialising the basic_string so avoiding dynamic allocation.
  _BString const& _M_get_storage(bool __do_init = true) const
  { return _M_get_storage(*this, __do_init, _StorageDirection()); }

  template <class _Lhs, class _Rhs, class _StorageDir>
  _BString const& _M_get_storage(__bstr_sum<_CharT, _Traits, _Alloc, _Lhs, _Rhs, _StorageDir>  const& __ref,
                                 bool __do_init, __on_left const& /*StorageDir*/) const
  { return _lhs._M_get_storage(__ref, __do_init); }

  template <class _Lhs, class _Rhs, class _StorageDir>
  _BString const& _M_get_storage(__bstr_sum<_CharT, _Traits, _Alloc, _Lhs, _Rhs, _StorageDir>  const& __ref,
                                 bool __do_init, __on_right const& /*StorageDir*/) const
  { return _rhs._M_get_storage(__ref, __do_init); }

  template <class _Lhs, class _Rhs, class _StorageDir>
  _BString const& _M_get_storage(__bstr_sum<_CharT, _Traits, _Alloc, _Lhs, _Rhs, _StorageDir>  const& __ref,
                                 bool __do_init) const
  { return _M_get_storage(__ref, __do_init, _StorageDirection()); }

private:
  _Left  _lhs;
  _Right _rhs;
};

/*
 * For this operator we choose to use the right part as the storage part
 */
template <class _CharT, class _Traits, class _Alloc,
          class _Lh1, class _Rh1, class _StoreDir1,
          class _Lh2, class _Rh2, class _StoreDir2>
inline __bstr_sum<_CharT, _Traits, _Alloc,
                  __bstr_sum<_CharT, _Traits, _Alloc, _Lh1, _Rh1, _StoreDir1>,
                  __bstr_sum<_CharT, _Traits, _Alloc, _Lh2, _Rh2, _StoreDir2>,
                  __on_right> 
operator + (const __bstr_sum<_CharT, _Traits, _Alloc, _Lh1, _Rh1, _StoreDir1> &__lhs,
            const __bstr_sum<_CharT, _Traits, _Alloc, _Lh2, _Rh2, _StoreDir2> &__rhs) {
  return __bstr_sum<_CharT, _Traits, _Alloc,
                    __bstr_sum<_CharT, _Traits, _Alloc, _Lh1, _Rh1, _StoreDir1>,
                    __bstr_sum<_CharT, _Traits, _Alloc, _Lh2, _Rh2, _StoreDir2>,
                    __on_right>(__lhs, __rhs);
}

template <class _CharT, class _Traits, class _Alloc,
          class _Lh1, class _Rh1, class _StoreDir1,
          class _Lh2, class _Rh2, class _StoreDir2>
inline bool 
operator == (const __bstr_sum<_CharT, _Traits, _Alloc, _Lh1, _Rh1, _StoreDir1> &__lhs,
             const __bstr_sum<_CharT, _Traits, _Alloc, _Lh2, _Rh2, _StoreDir2> &__rhs)
{ return (__lhs.size() == __rhs.size()) && (__lhs._M_get_storage() == __rhs._M_get_storage()); }

template <class _CharT, class _Traits, class _Alloc,
          class _Lh1, class _Rh1, class _StoreDir1,
          class _Lh2, class _Rh2, class _StoreDir2>
inline bool 
operator < (const __bstr_sum<_CharT, _Traits, _Alloc, _Lh1, _Rh1, _StoreDir1> &__lhs,
            const __bstr_sum<_CharT, _Traits, _Alloc, _Lh2, _Rh2, _StoreDir2> &__rhs)
{ return __lhs._M_get_storage() < __rhs._M_get_storage(); }


template <class _CharT, class _Traits, class _Alloc,
          class _Lh1, class _Rh1, class _StoreDir1,
          class _Lh2, class _Rh2, class _StoreDir2>
inline bool 
operator != (const __bstr_sum<_CharT, _Traits, _Alloc, _Lh1, _Rh1, _StoreDir1> &__lhs,
             const __bstr_sum<_CharT, _Traits, _Alloc, _Lh2, _Rh2, _StoreDir2> &__rhs)
{ return !(__lhs == __rhs); }

template <class _CharT, class _Traits, class _Alloc,
          class _Lh1, class _Rh1, class _StoreDir1,
          class _Lh2, class _Rh2, class _StoreDir2>
inline bool 
operator > (const __bstr_sum<_CharT, _Traits, _Alloc, _Lh1, _Rh1, _StoreDir1> &__lhs,
            const __bstr_sum<_CharT, _Traits, _Alloc, _Lh2, _Rh2, _StoreDir2> &__rhs)
{ return __rhs < __lhs; }

template <class _CharT, class _Traits, class _Alloc,
          class _Lh1, class _Rh1, class _StoreDir1,
          class _Lh2, class _Rh2, class _StoreDir2>
inline bool 
operator <= (const __bstr_sum<_CharT, _Traits, _Alloc, _Lh1, _Rh1, _StoreDir1> &__lhs,
             const __bstr_sum<_CharT, _Traits, _Alloc, _Lh2, _Rh2, _StoreDir2> &__rhs)
{ return !(__rhs < __lhs); }

template <class _CharT, class _Traits, class _Alloc,
          class _Lh1, class _Rh1, class _StoreDir1,
          class _Lh2, class _Rh2, class _StoreDir2>
inline bool 
operator >= (const __bstr_sum<_CharT, _Traits, _Alloc, _Lh1, _Rh1, _StoreDir1> &__lhs,
             const __bstr_sum<_CharT, _Traits, _Alloc, _Lh2, _Rh2, _StoreDir2> &__rhs)
{ return !(__lhs < __rhs); }



/*
 * This class will be used to simulate a temporary string that is required for
 * a call to the c_str method on the __bstr_sum class.
 */

template <class _CharT, class _Traits, class _Alloc>
struct __sum_storage_elem {
  typedef __sum_storage_elem<_CharT, _Traits, _Alloc> _Self;
  typedef basic_string<_CharT, _Traits, _Alloc> _BString;

  __sum_storage_elem(_Alloc __alloc) : _M_init(false), _M_storage(__alloc)
  {}

  template <class _Left, class _Right, class _StorageDir>
  void _M_Init(__bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>  const& __ref) const {
    if (!_M_init) {
      _M_storage = __ref;
      _M_init = true;
    }
  }

  template <class _Left, class _Right, class _StorageDir>
  _BString const& _M_get_storage(__bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>  const& __ref,
                                 bool __do_init) const {
    if (__do_init) {
      _M_Init(__ref);
    }
    return _M_storage;
  }
  template <class _Left, class _Right, class _StorageDir>
  _BString& _M_get_storage(__bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>  const& __ref) {
    _M_Init(__ref);
    return _M_storage;
  }

  size_t size() const { return 0; }
  _CharT const& operator[](size_t __n) const
  { return static_cast<_CharT* >(0)[__n]; }

private:
  mutable bool _M_init;
  mutable basic_string<_CharT, _Traits, _Alloc> _M_storage;
};

}

}



/*
 * Standard C++ string class.  This class has performance
 * characteristics very much like vector<>, meaning, for example, that
 * it does not perform reference-count or copy-on-write, and that
 * concatenation of two strings is an O(N) operation.

 * There are three reasons why basic_string is not identical to
 * vector.
 * First, basic_string always stores a null character at the end;
 * this makes it possible for c_str to be a fast operation.
 * Second, the C++ standard requires basic_string to copy elements
 * using char_traits<>::assign, char_traits<>::copy, and
 * char_traits<>::move.  This means that all of vector<>'s low-level
 * operations must be rewritten.  Third, basic_string<> has a lot of
 * extra functions in its interface that are convenient but, strictly
 * speaking, redundant.
 */

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> by Texas Instruments.   */
/******************************************************************************/

/*
 * Copyright (c) 1997-1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2003
 * Francois Dumont
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


// ------------------------------------------------------------
// Class _String_base.

// _String_base is a helper class that makes it it easier to write an
// exception-safe version of basic_string.  The constructor allocates,
// but does not initialize, a block of memory.  The destructor
// deallocates, but does not destroy elements within, a block of
// memory.  The destructor assumes that _M_start either is null, or else
// points to a block of memory that was allocated using _String_base's
// allocator and whose size is _M_end_of_storage - _M_start_of_storage._M_data.

namespace std {

namespace priv {

template <class _Tp, class _Alloc>
class _String_base {
    typedef _String_base<_Tp, _Alloc> _Self;
protected:
  
public:
  //dums: Some compiler(MSVC6) require it to be public not simply protected!
  enum __attribute__((__packed__)) {_DEFAULT_SIZE = 4 * sizeof( void * )};
  //This is needed by the full move framework
  typedef _Alloc allocator_type;
  typedef _STLP_alloc_proxy<_Tp*, _Tp, allocator_type> _AllocProxy;
  typedef size_t size_type;
private:
  union _Buffers {
    _Tp*  _M_end_of_storage;
    _Tp   _M_static_buf[_DEFAULT_SIZE];
  } _M_buffers;
protected:
  bool _M_using_static_buf() const
  { return (_M_start_of_storage._M_data == _M_buffers._M_static_buf); }
  _Tp const* _M_Start() const { return _M_start_of_storage._M_data; }
  _Tp* _M_Start() { return _M_start_of_storage._M_data; }
  _Tp const* _M_End() const
  { return _M_using_static_buf() ? _M_buffers._M_static_buf + _DEFAULT_SIZE : _M_buffers._M_end_of_storage; }
  _Tp* _M_End()
  { return _M_using_static_buf() ? _M_buffers._M_static_buf + _DEFAULT_SIZE : _M_buffers._M_end_of_storage; }
  size_type _M_capacity() const
  { return _M_using_static_buf() ? _DEFAULT_SIZE : _M_buffers._M_end_of_storage - _M_start_of_storage._M_data; }
  size_type _M_rest() const
  { return  _M_using_static_buf() ? _DEFAULT_SIZE - (_M_finish - _M_buffers._M_static_buf) : _M_buffers._M_end_of_storage - _M_finish; }

  _Tp*    _M_finish;
  _AllocProxy _M_start_of_storage;

  _Tp const* _M_Finish() const {return _M_finish;}
  _Tp* _M_Finish() {return _M_finish;}

  // Precondition: 0 < __n <= max_size().
  void _M_allocate_block(size_t __n = _DEFAULT_SIZE);
  void _M_deallocate_block() {
    if (!_M_using_static_buf() && (_M_start_of_storage._M_data != 0))
      _M_start_of_storage.deallocate(_M_start_of_storage._M_data, _M_buffers._M_end_of_storage - _M_start_of_storage._M_data);
  }

  size_t max_size() const {
    const size_type __string_max_size = size_type(-1) / sizeof(_Tp);
    typename allocator_type::size_type __alloc_max_size = _M_start_of_storage.max_size();
    return (min)(__alloc_max_size, __string_max_size) - 1;
  }

  _String_base(const allocator_type& __a)
    : _M_finish(_M_buffers._M_static_buf), _M_start_of_storage(__a, _M_buffers._M_static_buf)
    {}

  _String_base(const allocator_type& __a, size_t __n)
    : _M_finish(_M_buffers._M_static_buf), _M_start_of_storage(__a, _M_buffers._M_static_buf) {
      _M_allocate_block(__n);
    }

  void _M_move_src (_Self &src) {
    if (src._M_using_static_buf()) {
      _M_buffers = src._M_buffers;
      _M_finish = _M_buffers._M_static_buf + (src._M_finish - src._M_start_of_storage._M_data);
      _M_start_of_storage._M_data = _M_buffers._M_static_buf;
    }
    else {
      _M_start_of_storage._M_data = src._M_start_of_storage._M_data;
      _M_finish = src._M_finish;
      _M_buffers._M_end_of_storage = src._M_buffers._M_end_of_storage;
      src._M_start_of_storage._M_data = 0;
    }
  }

  _String_base(__move_source<_Self> src)
    : _M_start_of_storage(__move_source<_AllocProxy>(src.get()._M_start_of_storage)) {
      _M_move_src(src.get());
    }

  ~_String_base() { _M_deallocate_block(); }

  void _M_reset(_Tp *__start, _Tp *__finish, _Tp *__end_of_storage) {
    _M_buffers._M_end_of_storage = __end_of_storage;
    _M_finish = __finish;
    _M_start_of_storage._M_data = __start;
  }

  void _M_swap(_Self &__s) {
    if (_M_using_static_buf()) {
      if (__s._M_using_static_buf()) {
        ::std::swap(_M_buffers, __s._M_buffers);
        _Tp *__tmp = _M_finish;
        _M_finish = _M_start_of_storage._M_data + (__s._M_finish - __s._M_start_of_storage._M_data);
        __s._M_finish = __s._M_buffers._M_static_buf + (__tmp - _M_start_of_storage._M_data);
        //We need to swap _M_start_of_storage for allocators with state:
        _M_start_of_storage.swap(__s._M_start_of_storage);
        _M_start_of_storage._M_data = _M_buffers._M_static_buf;
        __s._M_start_of_storage._M_data = __s._M_buffers._M_static_buf;
      } else {
        __s._M_swap(*this);
        return;
      }
    }
    else if (__s._M_using_static_buf()) {
      _Tp *__tmp = _M_start_of_storage._M_data;
      _Tp *__tmp_finish = _M_finish;
      _Tp *__tmp_end_data = _M_buffers._M_end_of_storage;
      _M_buffers = __s._M_buffers;
      //We need to swap _M_start_of_storage for allocators with state:
      _M_start_of_storage.swap(__s._M_start_of_storage);
      _M_start_of_storage._M_data = _M_buffers._M_static_buf;
      _M_finish = _M_buffers._M_static_buf + (__s._M_finish - __s._M_buffers._M_static_buf);
      __s._M_buffers._M_end_of_storage = __tmp_end_data;
      __s._M_start_of_storage._M_data = __tmp;
      __s._M_finish = __tmp_finish;
    }
    else {
      ::std::swap(_M_buffers._M_end_of_storage, __s._M_buffers._M_end_of_storage);
      _M_start_of_storage.swap(__s._M_start_of_storage);
      ::std::swap(_M_finish, __s._M_finish);
    }
  }

  void  _M_throw_length_error() const;
  void  _M_throw_out_of_range() const;
};


}

}


/*
 * Local Variables:
 * mode:C++
 * End:
 */

namespace std {

// ------------------------------------------------------------
// Class basic_string.

// Class invariants:
// (1) [start, finish) is a valid range.
// (2) Each iterator in [start, finish) points to a valid object
//     of type value_type.
// (3) *finish is a valid object of type value_type; when
//     value_type is not a POD it is value_type().
// (4) [finish + 1, end_of_storage) is a valid range.
// (5) Each iterator in [finish + 1, end_of_storage) points to
//     unininitialized memory.

// Note one important consequence: a string of length n must manage
// a block of memory whose size is at least n + 1.

namespace priv {
struct _String_reserve_t {};
}




template <class _CharT, class _Traits, class _Alloc>
class basic_string : private ::std::priv:: _String_base<_CharT,_Alloc>
{
private:                        // Private members inherited from base.
  typedef ::std::priv:: _String_base<_CharT,_Alloc> _Base;
  typedef basic_string<_CharT, _Traits, _Alloc> _Self;

public:
  typedef _CharT value_type;
  typedef _Traits traits_type;

  typedef value_type* pointer;
  typedef const value_type* const_pointer;
  typedef value_type& reference;
  typedef const value_type& const_reference;
  typedef typename _Base::size_type size_type;
  typedef ptrdiff_t difference_type;
  typedef random_access_iterator_tag _Iterator_category;

  typedef const value_type* const_iterator;
  typedef value_type*       iterator;

  typedef ::std::reverse_iterator<const_iterator> const_reverse_iterator; typedef ::std::reverse_iterator<iterator> reverse_iterator;

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 2005
 * Francois Dumont
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 */

/* This header contains npos definition used in basic_string and rope
 * implementation. It do not have to be guarded as files including it
 * are already guarded and it has sometimes to be included several times.
 */

  static const size_t npos = ~(size_t)0;

  typedef ::std::priv:: _String_reserve_t _Reserve_t;

public:                         // Constructor, destructor, assignment.
  typedef typename _Base::allocator_type allocator_type;

  allocator_type get_allocator() const
  { return (const allocator_type&)this->_M_start_of_storage; }

  explicit basic_string(const allocator_type& __a = allocator_type())
      : ::std::priv:: _String_base<_CharT,_Alloc>(__a, _Base::_DEFAULT_SIZE)
  { _M_terminate_string(); }

  basic_string(_Reserve_t, size_t __n,
               const allocator_type& __a = allocator_type())
    : ::std::priv:: _String_base<_CharT,_Alloc>(__a, __n + 1)
  { _M_terminate_string(); }

  basic_string(const _Self&);

  basic_string(const _Self& __s, size_type __pos, size_type __n = npos,
               const allocator_type& __a = allocator_type())
    : ::std::priv:: _String_base<_CharT,_Alloc>(__a) {
    if (__pos > __s.size())
      this->_M_throw_out_of_range();
    else
      _M_range_initialize(__s._M_Start() + __pos,
                          __s._M_Start() + __pos + (min) (__n, __s.size() - __pos));
  }

  basic_string(const _CharT* __s, size_type __n,
               const allocator_type& __a = allocator_type())
    : ::std::priv:: _String_base<_CharT,_Alloc>(__a) {
      
      _M_range_initialize(__s, __s + __n);
    }

  basic_string(const _CharT* __s,
               const allocator_type& __a = allocator_type());

  basic_string(size_type __n, _CharT __c,
               const allocator_type& __a = allocator_type())
    : ::std::priv:: _String_base<_CharT,_Alloc>(__a, __n + 1) {
    this->_M_finish = ::std::priv:: __uninitialized_fill_n(this->_M_Start(), __n, __c);
    _M_terminate_string();
  }

  basic_string(__move_source<_Self> src)
    : ::std::priv:: _String_base<_CharT,_Alloc>(__move_source<_Base>(src.get())) {}

  // Check to see if _InputIterator is an integer type.  If so, then
  // it can't be an iterator.
  template <class _InputIterator>
  basic_string(_InputIterator __f, _InputIterator __l,
               const allocator_type & __a = allocator_type())
    : ::std::priv:: _String_base<_CharT,_Alloc>(__a) {
    typedef typename _IsIntegral<_InputIterator>::_Ret _Integral;
    _M_initialize_dispatch(__f, __l, _Integral());
  }

private:
  size_type _M_compute_next_size(size_type __n) {
    const size_type __size = size();
    if (__n > max_size() - __size)
      this->_M_throw_length_error();
    size_type __len = __size + (max)(__n, __size) + 1;
    if (__len > max_size() || __len < __size)
      __len = max_size(); // overflow
    return __len;
  }

  template <class _InputIter>
  void _M_range_initialize(_InputIter __f, _InputIter __l,
                           const input_iterator_tag &__tag) {
    this->_M_allocate_block();
    _M_construct_null(this->_M_Finish());
    _M_appendT(__f, __l, __tag);
  }

  template <class _ForwardIter>
  void _M_range_initialize(_ForwardIter __f, _ForwardIter __l,
                           const forward_iterator_tag &) {
    difference_type __n = ::std::distance(__f, __l);
    this->_M_allocate_block(__n + 1);
    this->_M_finish = uninitialized_copy(__f, __l, this->_M_Start());
    this->_M_terminate_string();
  }

  template <class _InputIter>
  void _M_range_initializeT(_InputIter __f, _InputIter __l) {
    _M_range_initialize(__f, __l, typename ::std::iterator_traits< _InputIter > ::iterator_category());
  }

  template <class _Integer>
  void _M_initialize_dispatch(_Integer __n, _Integer __x, const __true_type& /*_Integral*/) {
    this->_M_allocate_block(__n + 1);
    this->_M_finish = ::std::priv:: __uninitialized_fill_n(this->_M_Start(), __n, __x);
    this->_M_terminate_string();
  }

  template <class _InputIter>
  void _M_initialize_dispatch(_InputIter __f, _InputIter __l, const __false_type& /*_Integral*/) {
    _M_range_initializeT(__f, __l);
  }

public:
  _Self& operator=(const _Self& __s) {
    if (&__s != this)
      _M_assign(__s._M_Start(), __s._M_Finish());
    return *this;
  }

  _Self& operator=(const _CharT* __s) {
    
    return _M_assign(__s, __s + traits_type::length(__s));
  }

  _Self& operator=(_CharT __c)
  { return assign(static_cast<size_type>(1), __c); }

private:
  static _CharT  _M_null()
  { return _CharT(); }

private:                     // Helper functions used by constructors
                                   // and elsewhere.
  void _M_construct_null(_CharT* __p) const
  { ::std::_Construct(__p); }
  void _M_terminate_string()
  { _M_construct_null(this->_M_Finish()); }
  bool _M_inside(const _CharT* __s) const {
    
    return (__s >= this->_M_Start()) && (__s < this->_M_Finish());
  }

  void _M_range_initialize(const _CharT* __f, const _CharT* __l) {
     
    ptrdiff_t __n = __l - __f;
    this->_M_allocate_block(__n + 1);
    this->_M_finish = uninitialized_copy(__f, __l, this->_M_Start());
    _M_terminate_string();
  }

public:                         // Iterators.
  iterator begin()             { return this->_M_Start(); }
  iterator end()               { return this->_M_Finish(); }
  const_iterator begin() const { return this->_M_Start(); }
  const_iterator end()   const { return this->_M_Finish(); }

  reverse_iterator rbegin()
  { return reverse_iterator(this->_M_Finish()); }
  reverse_iterator rend()
  { return reverse_iterator(this->_M_Start()); }
  const_reverse_iterator rbegin() const
  { return const_reverse_iterator(this->_M_Finish()); }
  const_reverse_iterator rend()   const
  { return const_reverse_iterator(this->_M_Start()); }

public:                         // Size, capacity, etc.
  size_type size() const     { return this->_M_Finish() - this->_M_Start(); }
  size_type length() const   { return size(); }
  size_type max_size() const { return _Base::max_size(); }

  void resize(size_type __n, _CharT __c) {
    if (__n <= size())
      erase(begin() + __n, end());
    else
      append(__n - size(), __c);
  }

  void resize(size_type __n) { resize(__n, _M_null()); }

private:
  void _M_reserve(size_type);
public:
  void reserve(size_type = 0);

  size_type capacity() const
  { return this->_M_capacity() - 1; }

  void clear() {
    if (!empty()) {
      _Traits::assign(*(this->_M_Start()), _M_null());
      this->_M_finish = this->_M_Start();
    }
  }

  bool empty() const { return this->_M_Start() == this->_M_Finish(); }

public:                         // Element access.

  const_reference operator[](size_type __n) const
  { return *(this->_M_Start() + __n); }
  reference operator[](size_type __n)
  { return *(this->_M_Start() + __n); }

  const_reference at(size_type __n) const {
    if (__n >= size())
      this->_M_throw_out_of_range();
    return *(this->_M_Start() + __n);
  }

  reference at(size_type __n) {
    if (__n >= size())
      this->_M_throw_out_of_range();
    return *(this->_M_Start() + __n);
  }

public:                         // Append, operator+=, push_back.

  _Self& operator+=(const _Self& __s) { return append(__s); }
  _Self& operator+=(const _CharT* __s) {  return append(__s); }
  _Self& operator+=(_CharT __c) { push_back(__c); return *this; }

private:
  _Self& _M_append(const _CharT* __first, const _CharT* __last);

  template <class _InputIter>
  _Self& _M_appendT(_InputIter __first, _InputIter __last,
                    const input_iterator_tag &) {
    for ( ; __first != __last ; ++__first)
      push_back(*__first);
    return *this;
  }

  template <class _ForwardIter>
  _Self& _M_appendT(_ForwardIter __first, _ForwardIter __last,
                    const forward_iterator_tag &) {
    if (__first != __last) {
      size_type __n = static_cast<size_type>(::std::distance(__first, __last));
      if (__n >= this->_M_rest()) {
        size_type __len = _M_compute_next_size(__n);
        pointer __new_start = this->_M_start_of_storage.allocate(__len, __len);
        pointer __new_finish = uninitialized_copy(this->_M_Start(), this->_M_Finish(), __new_start);
        __new_finish = uninitialized_copy(__first, __last, __new_finish);
        _M_construct_null(__new_finish);
        this->_M_deallocate_block();
        this->_M_reset(__new_start, __new_finish, __new_start + __len);
      }
      else {
        _Traits::assign(*this->_M_finish, *__first++);
        uninitialized_copy(__first, __last, this->_M_Finish() + 1);
        _M_construct_null(this->_M_Finish() + __n);
        this->_M_finish += __n;
      }
    }
    return *this;
  }

  template <class _Integer>
  _Self& _M_append_dispatch(_Integer __n, _Integer __x, const __true_type& /*Integral*/)
  { return append((size_type) __n, (_CharT) __x); }

  template <class _InputIter>
  _Self& _M_append_dispatch(_InputIter __f, _InputIter __l, const __false_type& /*Integral*/)
  { return _M_appendT(__f, __l, typename ::std::iterator_traits< _InputIter > ::iterator_category()); }

public:
  // Check to see if _InputIterator is an integer type.  If so, then
  // it can't be an iterator.
  template <class _InputIter>
  _Self& append(_InputIter __first, _InputIter __last) {
    typedef typename _IsIntegral<_InputIter>::_Ret _Integral;
    return _M_append_dispatch(__first, __last, _Integral());
  }

public:
  _Self& append(const _Self& __s)
  { return _M_append(__s._M_Start(), __s._M_Finish()); }

  _Self& append(const _Self& __s,
                size_type __pos, size_type __n) {
    if (__pos > __s.size())
      this->_M_throw_out_of_range();
    return _M_append(__s._M_Start() + __pos,
                     __s._M_Start() + __pos + (min) (__n, __s.size() - __pos));
  }

  _Self& append(const _CharT* __s, size_type __n)
  {  return _M_append(__s, __s+__n); }
  _Self& append(const _CharT* __s)
  {  return _M_append(__s, __s + traits_type::length(__s)); }
  _Self& append(size_type __n, _CharT __c);

public:
  void push_back(_CharT __c) {
    if (this->_M_rest() == 1 )
      _M_reserve(_M_compute_next_size(1));
    _M_construct_null(this->_M_Finish() + 1);
    _Traits::assign(*(this->_M_Finish()), __c);
    ++this->_M_finish;
  }

  void pop_back() {
    _Traits::assign(*(this->_M_Finish() - 1), _M_null());
    --this->_M_finish;
  }

public:                         // Assign
  _Self& assign(const _Self& __s)
  { return _M_assign(__s._M_Start(), __s._M_Finish()); }

  _Self& assign(const _Self& __s,
                size_type __pos, size_type __n) {
    if (__pos > __s.size())
      this->_M_throw_out_of_range();
    return _M_assign(__s._M_Start() + __pos,
                     __s._M_Start() + __pos + (min) (__n, __s.size() - __pos));
  }

  _Self& assign(const _CharT* __s, size_type __n)
  {  return _M_assign(__s, __s + __n); }

  _Self& assign(const _CharT* __s)
  {  return _M_assign(__s, __s + _Traits::length(__s)); }

  _Self& assign(size_type __n, _CharT __c);

private:
  _Self& _M_assign(const _CharT* __f, const _CharT* __l);

  // Helper functions for assign.
  template <class _Integer>
  _Self& _M_assign_dispatch(_Integer __n, _Integer __x, const __true_type& /*_Integral*/)
  { return assign((size_type) __n, (_CharT) __x); }

  template <class _InputIter>
  _Self& _M_assign_dispatch(_InputIter __f, _InputIter __l, const __false_type& /*_Integral*/) {
    pointer __cur = this->_M_Start();
    while (__f != __l && __cur != this->_M_Finish()) {
      _Traits::assign(*__cur, *__f);
      ++__f;
      ++__cur;
    }
    if (__f == __l)
      erase(__cur, this->end());
    else
      _M_appendT(__f, __l, typename ::std::iterator_traits< _InputIter > ::iterator_category());
    return *this;
  }

public:
  // Check to see if _InputIterator is an integer type.  If so, then
  // it can't be an iterator.
  template <class _InputIter>
  _Self& assign(_InputIter __first, _InputIter __last) {
    typedef typename _IsIntegral<_InputIter>::_Ret _Integral;
    return _M_assign_dispatch(__first, __last, _Integral());
  }

public:                         // Insert
  _Self& insert(size_type __pos, const _Self& __s) {
    if (__pos > size())
      this->_M_throw_out_of_range();
    if (__s.size() > max_size() - size())
      this->_M_throw_length_error();
    _M_insert(begin() + __pos, __s._M_Start(), __s._M_Finish(), &__s == this);
    return *this;
  }

  _Self& insert(size_type __pos, const _Self& __s,
                size_type __beg, size_type __n) {
    if (__pos > size() || __beg > __s.size())
      this->_M_throw_out_of_range();
    size_type __len = (min) (__n, __s.size() - __beg);
    if (__len > max_size() - size())
      this->_M_throw_length_error();
    _M_insert(begin() + __pos,
              __s._M_Start() + __beg, __s._M_Start() + __beg + __len, &__s == this);
    return *this;
  }
  _Self& insert(size_type __pos, const _CharT* __s, size_type __n) {
    
    if (__pos > size())
      this->_M_throw_out_of_range();
    if (__n > max_size() - size())
      this->_M_throw_length_error();
    _M_insert(begin() + __pos, __s, __s + __n, _M_inside(__s));
    return *this;
  }

  _Self& insert(size_type __pos, const _CharT* __s) {
    
    if (__pos > size())
      this->_M_throw_out_of_range();
    size_type __len = _Traits::length(__s);
    if (__len > max_size() - size())
      this->_M_throw_length_error();
    _M_insert(this->_M_Start() + __pos, __s, __s + __len, _M_inside(__s));
    return *this;
  }

  _Self& insert(size_type __pos, size_type __n, _CharT __c) {
    if (__pos > size())
      this->_M_throw_out_of_range();
    if (__n > max_size() - size())
      this->_M_throw_length_error();
    insert(begin() + __pos, __n, __c);
    return *this;
  }

  iterator insert(iterator __p, _CharT __c) {
    
    if (__p == end()) {
      push_back(__c);
      return this->_M_Finish() - 1;
    }
    else
      return _M_insert_aux(__p, __c);
  }

  void insert(iterator __p, size_t __n, _CharT __c);

private:  // Helper functions for insert.
  void _M_insert(iterator __p, const _CharT* __first, const _CharT* __last, bool __self_ref);

  pointer _M_insert_aux(pointer, _CharT);

  void _M_copy(const _CharT* __f, const _CharT* __l, _CharT* __res) {
     
    
    _Traits::copy(__res, __f, __l - __f);
  }

  void _M_move(const _CharT* __f, const _CharT* __l, _CharT* __res) {
     
    _Traits::move(__res, __f, __l - __f);
  }

  template <class _ForwardIter>
  void _M_insert_overflow(iterator __pos, _ForwardIter __first, _ForwardIter __last,
                          size_type __n) {
    size_type __len = _M_compute_next_size(__n);
    pointer __new_start = this->_M_start_of_storage.allocate(__len, __len);
    pointer __new_finish = uninitialized_copy(this->_M_Start(), __pos, __new_start);
    __new_finish = uninitialized_copy(__first, __last, __new_finish);
    __new_finish = uninitialized_copy(__pos, this->_M_Finish(), __new_finish);
    _M_construct_null(__new_finish);
    this->_M_deallocate_block();
    this->_M_reset(__new_start, __new_finish, __new_start + __len);
  }

  template <class _InputIter>
  void _M_insertT(iterator __p, _InputIter __first, _InputIter __last,
                  const input_iterator_tag &) {
    for ( ; __first != __last; ++__first) {
      __p = insert(__p, *__first);
      ++__p;
    }
  }

  template <class _ForwardIter>
  void _M_insertT(iterator __pos, _ForwardIter __first, _ForwardIter __last,
                  const forward_iterator_tag &) {
    if (__first != __last) {
      size_type __n = ::std::distance(__first, __last);
      if (__n < this->_M_rest()) {
        const size_type __elems_after = this->_M_finish - __pos;
        if (__elems_after >= __n) {
          uninitialized_copy((this->_M_Finish() - __n) + 1, this->_M_Finish() + 1, this->_M_Finish() + 1);
          this->_M_finish += __n;
          _Traits::move(__pos + __n, __pos, (__elems_after - __n) + 1);
          _M_copyT(__first, __last, __pos);
        }
        else {
          pointer __old_finish = this->_M_Finish();
          _ForwardIter __mid = __first;
          ::std::advance(__mid, __elems_after + 1);
          ::std::uninitialized_copy(__mid, __last, this->_M_Finish() + 1);
          this->_M_finish += __n - __elems_after;
          uninitialized_copy(__pos, __old_finish + 1, this->_M_Finish());
          this->_M_finish += __elems_after;
          _M_copyT(__first, __mid, __pos);
        }
      }
      else {
        _M_insert_overflow(__pos, __first, __last, __n);
      }
    }
  }

  template <class _Integer>
  void _M_insert_dispatch(iterator __p, _Integer __n, _Integer __x,
                          const __true_type& /*Integral*/)
  { insert(__p, (size_type) __n, (_CharT) __x); }

  template <class _InputIter>
  void _M_insert_dispatch(iterator __p, _InputIter __first, _InputIter __last,
                          const __false_type&/*Integral*/) {
    
    /* We are forced to do a temporary string to avoid the self referencing issue. */
    const _Self __self(__first, __last, get_allocator());
    _M_insertT(__p, __self.begin(), __self.end(), forward_iterator_tag());
  }

  template <class _InputIterator>
  void _M_copyT(_InputIterator __first, _InputIterator __last, pointer __result) {
    
    for ( ; __first != __last; ++__first, ++__result)
      _Traits::assign(*__result, *__first);
  }

  void _M_copyT(const _CharT* __f, const _CharT* __l, _CharT* __res) {
     
    
    _Traits::copy(__res, __f, __l - __f);
  }
public:
  // Check to see if _InputIterator is an integer type.  If so, then
  // it can't be an iterator.
  template <class _InputIter>
  void insert(iterator __p, _InputIter __first, _InputIter __last) {
    if (__p > this->end())
    {
        this->_M_throw_out_of_range();
    }
    typedef typename _IsIntegral<_InputIter>::_Ret _Integral;
    _M_insert_dispatch(__p, __first, __last, _Integral());
  }

public:
  void insert(iterator __p, const _CharT* __f, const _CharT* __l) {
     
    _M_insert(__p, __f, __l, _M_inside(__f));
  }

public:                         // Erase.
  _Self& erase(size_type __pos = 0, size_type __n = npos) {
    if (__pos > size())
      this->_M_throw_out_of_range();
    erase(begin() + __pos, begin() + __pos + (min) (__n, size() - __pos));
    return *this;
  }

  iterator erase(iterator __pos) {
    // The move includes the terminating _CharT().
    _Traits::move(__pos, __pos + 1, this->_M_Finish() - __pos);
    --this->_M_finish;
    return __pos;
  }

  iterator erase(iterator __first, iterator __last) {
    if (__first != __last) {
      // The move includes the terminating _CharT().
      traits_type::move(__first, __last, (this->_M_Finish() - __last) + 1);
      this->_M_finish = this->_M_Finish() - (__last - __first);
    }
    return __first;
  }

public:                         // Replace.  (Conceptually equivalent
                                // to erase followed by insert.)
  _Self& replace(size_type __pos, size_type __n, const _Self& __s) {
    const size_type __size = size();
    if (__pos > __size)
      this->_M_throw_out_of_range();
    const size_type __len = (min) (__n, __size - __pos);
    if (__s.size() > max_size() - (__size - __len))
      this->_M_throw_length_error();
    return _M_replace(begin() + __pos, begin() + __pos + __len,
                      __s._M_Start(), __s._M_Finish(), &__s == this);
  }

  _Self& replace(size_type __pos1, size_type __n1, const _Self& __s,
                 size_type __pos2, size_type __n2) {
    const size_type __size1 = size();
    const size_type __size2 = __s.size();
    if (__pos1 > __size1 || __pos2 > __size2)
      this->_M_throw_out_of_range();
    const size_type __len1 = (min) (__n1, __size1 - __pos1);
    const size_type __len2 = (min) (__n2, __size2 - __pos2);
    if (__len2 > max_size() - (__size1 - __len1))
      this->_M_throw_length_error();
    return _M_replace(begin() + __pos1, begin() + __pos1 + __len1,
                      __s._M_Start() + __pos2, __s._M_Start() + __pos2 + __len2, &__s == this);
  }

  _Self& replace(size_type __pos, size_type __n1,
                 const _CharT* __s, size_type __n2) {
    
    const size_type __size = size();
    if (__pos > __size)
      this->_M_throw_out_of_range();
    const size_type __len = (min) (__n1, __size - __pos);
    if (__n2 > max_size() - (__size - __len))
      this->_M_throw_length_error();
    return _M_replace(begin() + __pos, begin() + __pos + __len,
                      __s, __s + __n2, _M_inside(__s));
  }

  _Self& replace(size_type __pos, size_type __n1, const _CharT* __s) {
    
    return replace(__pos, __n1, __s, _Traits::length(__s));
  }

  _Self& replace(size_type __pos, size_type __n1,
                 size_type __n2, _CharT __c) {
    const size_type __size = size();
    if (__pos > __size)
      this->_M_throw_out_of_range();
    const size_type __len = (min) (__n1, __size - __pos);
    if (__n2 > max_size() - (__size - __len))
      this->_M_throw_length_error();
    return replace(begin() + __pos, begin() + __pos + __len, __n2, __c);
  }

  _Self& replace(iterator __first, iterator __last, const _Self& __s) {
    
    return _M_replace(__first, __last, __s._M_Start(), __s._M_Finish(), &__s == this);
  }

  _Self& replace(iterator __first, iterator __last,
                 const _CharT* __s, size_type __n) {
    
    
    if (__s != 0 && __n == this->npos)
        this->_M_throw_length_error();
    return _M_replace(__first, __last, __s, __s + __n, _M_inside(__s));
  }

  _Self& replace(iterator __first, iterator __last,
                 const _CharT* __s) {
    
    
    return _M_replace(__first, __last, __s, __s + _Traits::length(__s), _M_inside(__s));
  }

  _Self& replace(iterator __first, iterator __last, size_type __n, _CharT __c);

private:                        // Helper functions for replace.
  _Self& _M_replace(iterator __first, iterator __last,
                    const _CharT* __f, const _CharT* __l, bool __self_ref);

  template <class _Integer>
  _Self& _M_replace_dispatch(iterator __first, iterator __last,
                             _Integer __n, _Integer __x, const __true_type& /*IsIntegral*/) {
     
    return replace(__first, __last, (size_type) __n, (_CharT) __x);
  }

  template <class _InputIter>
  _Self& _M_replace_dispatch(iterator __first, iterator __last,
                             _InputIter __f, _InputIter __l, const __false_type& /*IsIntegral*/) {
     
    /* We are forced to do a temporary string to avoid the self referencing issue. */
    const _Self __self(__f, __l, get_allocator());
    return _M_replace(__first, __last, __self._M_Start(), __self._M_Finish(), false);
  }

public:
  // Check to see if _InputIter is an integer type.  If so, then
  // it can't be an iterator.
  template <class _InputIter>
  _Self& replace(iterator __first, iterator __last,
                 _InputIter __f, _InputIter __l) {
    
    typedef typename _IsIntegral<_InputIter>::_Ret _Integral;
    return _M_replace_dispatch(__first, __last, __f, __l,  _Integral());
  }

public:
  _Self& replace(iterator __first, iterator __last,
                 const _CharT* __f, const _CharT* __l) {
    
     
    return _M_replace(__first, __last, __f, __l, _M_inside(__f));
  }

public:                         // Other modifier member functions.

  size_type copy(_CharT* __s, size_type __n, size_type __pos = 0) const {
    
    if (__pos > size())
      this->_M_throw_out_of_range();
    const size_type __len = (min) (__n, size() - __pos);
    _Traits::copy(__s, this->_M_Start() + __pos, __len);
    return __len;
  }

  void swap(_Self& __s) { this->_M_swap(__s); }

public:                         // Conversion to C string.

  const _CharT* c_str() const { return this->_M_Start(); }
  const _CharT* data()  const { return this->_M_Start(); }

public: // find.
  size_type find(const _Self& __s, size_type __pos = 0) const
  { return find(__s._M_Start(), __pos, __s.size()); }

  size_type find(const _CharT* __s, size_type __pos = 0) const
  {  return find(__s, __pos, _Traits::length(__s)); }

  size_type find(const _CharT* __s, size_type __pos, size_type __n) const;

  // WIE: Versant schema compiler 5.2.2 ICE workaround
  size_type find(_CharT __c) const { return find(__c, 0); }
  size_type find(_CharT __c, size_type __pos /* = 0 */) const;

public: // rfind.
  size_type rfind(const _Self& __s, size_type __pos = npos) const
  { return rfind(__s._M_Start(), __pos, __s.size()); }

  size_type rfind(const _CharT* __s, size_type __pos = npos) const
  {  return rfind(__s, __pos, _Traits::length(__s)); }

  size_type rfind(const _CharT* __s, size_type __pos, size_type __n) const;
  size_type rfind(_CharT __c, size_type __pos = npos) const;

public: // find_first_of
  size_type find_first_of(const _Self& __s, size_type __pos = 0) const
  { return find_first_of(__s._M_Start(), __pos, __s.size()); }

  size_type find_first_of(const _CharT* __s, size_type __pos = 0) const
  {  return find_first_of(__s, __pos, _Traits::length(__s)); }

  size_type find_first_of(const _CharT* __s, size_type __pos, size_type __n) const;

  size_type find_first_of(_CharT __c, size_type __pos = 0) const
  { return find(__c, __pos); }

public: // find_last_of
  size_type find_last_of(const _Self& __s, size_type __pos = npos) const
  { return find_last_of(__s._M_Start(), __pos, __s.size()); }

  size_type find_last_of(const _CharT* __s, size_type __pos = npos) const
  {  return find_last_of(__s, __pos, _Traits::length(__s)); }

  size_type find_last_of(const _CharT* __s, size_type __pos, size_type __n) const;

  size_type find_last_of(_CharT __c, size_type __pos = npos) const
  { return rfind(__c, __pos); }

public: // find_first_not_of
  size_type find_first_not_of(const _Self& __s, size_type __pos = 0) const
  { return find_first_not_of(__s._M_Start(), __pos, __s.size()); }

  size_type find_first_not_of(const _CharT* __s, size_type __pos = 0) const
  {  return find_first_not_of(__s, __pos, _Traits::length(__s)); }

  size_type find_first_not_of(const _CharT* __s, size_type __pos, size_type __n) const;

  size_type find_first_not_of(_CharT __c, size_type __pos = 0) const;

public: // find_last_not_of
  size_type find_last_not_of(const _Self& __s, size_type __pos = npos) const
  { return find_last_not_of(__s._M_Start(), __pos, __s.size()); }

  size_type find_last_not_of(const _CharT* __s, size_type __pos = npos) const
  {  return find_last_not_of(__s, __pos, _Traits::length(__s)); }

  size_type find_last_not_of(const _CharT* __s, size_type __pos, size_type __n) const;

  size_type find_last_not_of(_CharT __c, size_type __pos = npos) const;

public: // Substring.
  _Self substr(size_type __pos = 0, size_type __n = npos) const
  { return _Self(*this, __pos, __n, get_allocator()); }

public: // Compare
  int compare(const _Self& __s) const
  { return _M_compare(this->_M_Start(), this->_M_Finish(), __s._M_Start(), __s._M_Finish()); }

  int compare(size_type __pos1, size_type __n1, const _Self& __s) const {
    if (__pos1 > size())
      this->_M_throw_out_of_range();
    return _M_compare(this->_M_Start() + __pos1,
                      this->_M_Start() + __pos1 + (min) (__n1, size() - __pos1),
                      __s._M_Start(), __s._M_Finish());
  }

  int compare(size_type __pos1, size_type __n1, const _Self& __s,
              size_type __pos2, size_type __n2) const {
    if (__pos1 > size() || __pos2 > __s.size())
      this->_M_throw_out_of_range();
    return _M_compare(this->_M_Start() + __pos1,
                      this->_M_Start() + __pos1 + (min) (__n1, size() - __pos1),
                      __s._M_Start() + __pos2,
                      __s._M_Start() + __pos2 + (min) (__n2, __s.size() - __pos2));
  }

  int compare(const _CharT* __s) const {
    
    return _M_compare(this->_M_Start(), this->_M_Finish(), __s, __s + _Traits::length(__s));
  }

  int compare(size_type __pos1, size_type __n1, const _CharT* __s) const {
    
    if (__pos1 > size())
      this->_M_throw_out_of_range();
    return _M_compare(this->_M_Start() + __pos1,
                      this->_M_Start() + __pos1 + (min) (__n1, size() - __pos1),
                      __s, __s + _Traits::length(__s));
  }

  int compare(size_type __pos1, size_type __n1, const _CharT* __s, size_type __n2) const {
    
    if (__pos1 > size())
      this->_M_throw_out_of_range();
    return _M_compare(this->_M_Start() + __pos1,
                      this->_M_Start() + __pos1 + (min) (__n1, size() - __pos1),
                      __s, __s + __n2);
  }

public: // Helper functions for compare.
  static int  _M_compare(const _CharT* __f1, const _CharT* __l1,
                                   const _CharT* __f2, const _CharT* __l2) {
    const ptrdiff_t __n1 = __l1 - __f1;
    const ptrdiff_t __n2 = __l2 - __f2;
    const int cmp = _Traits::compare(__f1, __f2, (min) (__n1, __n2));
    return cmp != 0 ? cmp : (__n1 < __n2 ? -1 : (__n1 > __n2 ? 1 : 0));
  }
/*
 * Copyright (c) 2003
 * Francois Dumont
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

/*
 * All the necessary methods used for template expressions with basic_string
 * This file do not have to be macro guarded as it is only used in the _string.h
 * file and it is a part of the basic_string definition.
 */

public:
  template <class _Left, class _Right, class _StorageDir>
  basic_string(::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir> const& __s)
    : ::std::priv:: _String_base<_CharT,_Alloc>(__s . get_allocator(), __s . size() + 1)
  { _M_append_sum(__s); }

  template <class _Left, class _Right, class _StorageDir>
  basic_string(::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir> const& __s,
               size_type __pos, size_type __n = npos,
               const allocator_type& __a = allocator_type())
    : ::std::priv:: _String_base<_CharT,_Alloc>(__a, (__pos <= __s . size()) ? ((min) (__n, __s . size() - __pos)) : 0 + 1) {
    size_type __size = __s.size();
    if (__pos > __size)
      this->_M_throw_out_of_range();
    else
      _M_append_sum_pos(__s, __pos, (min) (__n, __size - __pos));
  }

private:
  _CharT* _M_append_fast(::std::priv:: __char_wrapper<_CharT> __c, _CharT *__buf) {
    ::std::_Copy_Construct(__buf, __c.getValue());
    return __buf + 1;
  }
  _CharT* _M_append_fast(_CharT const* __s, size_type __s_size, _CharT *__buf)
  { return uninitialized_copy(__s, __s + __s_size, __buf); }
  _CharT* _M_append_fast(::std::priv:: __cstr_wrapper<_CharT> const& __s, _CharT *__buf)
  { return _M_append_fast(__s.c_str(), __s.size(), __buf); }
  _CharT* _M_append_fast(::std::priv:: __bstr_wrapper<_CharT, _Traits, _Alloc> __s, _CharT *__buf)
  { return _M_append_fast(__s.b_str(), __buf); }
  _CharT* _M_append_fast(_Self const& __s, _CharT *__buf)
  { return _M_append_fast(__s.data(), __s.size(), __buf); }
  _CharT* _M_append_fast(::std::priv:: __sum_storage_elem<_CharT, _Traits, _Alloc> const&, _CharT *__buf)
  { return __buf; }
  template <class _Left, class _Right, class _StorageDir>
  _CharT* _M_append_fast(::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir> const& __s, _CharT *__buf)
  { return _M_append_fast(__s.getRhs(), _M_append_fast(__s.getLhs(), __buf)); }

  _CharT* _M_append_fast_pos(::std::priv:: __char_wrapper<_CharT> __c, _CharT *__buf, size_type /*__pos*/, size_type __n) {
    if (__n == 0)
      return __buf;
    ::std::_Copy_Construct(__buf, __c.getValue());
    return __buf + 1;
  }
  _CharT* _M_append_fast_pos(_CharT const* __s, size_type __s_size, _CharT *__buf,
                             size_type __pos, size_type __n)
  { return uninitialized_copy(__s + __pos, __s + __pos + (min)(__n, __s_size - __pos), __buf); }
  _CharT* _M_append_fast_pos(::std::priv:: __cstr_wrapper<_CharT> const& __s, _CharT *__buf,
                             size_type __pos, size_type __n)
  { return _M_append_fast_pos(__s.c_str(), __s.size(), __buf, __pos, __n); }
  _CharT* _M_append_fast_pos(::std::priv:: __bstr_wrapper<_CharT, _Traits, _Alloc> __s, _CharT *__buf,
                             size_type __pos, size_type __n)
  { return _M_append_fast_pos(__s.b_str(), __buf, __pos, __n); }
  _CharT* _M_append_fast_pos(_Self const& __s, _CharT *__buf,
                             size_type __pos, size_type __n)
  { return _M_append_fast_pos(__s.data(), __s.size(), __buf, __pos, __n); }
  _CharT* _M_append_fast_pos(::std::priv:: __sum_storage_elem<_CharT, _Traits, _Alloc> const&, _CharT *__buf,
                             size_type, size_type)
  { return __buf; }

  template <class _Left, class _Right, class _StorageDir>
  _CharT* _M_append_fast_pos(::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir> const& __s,
                             _CharT *__buf, size_type __pos, size_type __n) {
    if (__n == 0) {
      return __buf;
    }
    size_type __lhs_size = __s.getLhs().size();
    if (__pos < __lhs_size) {
      if (__n < (__lhs_size - __pos)) {
        return _M_append_fast_pos(__s.getLhs(), __buf, __pos, __n);
      } else {
        return _M_append_fast_pos(__s.getRhs(), _M_append_fast_pos(__s.getLhs(), __buf, __pos, __n),
                                  0, __n - (__lhs_size - __pos));
      }
    } else {
      return _M_append_fast_pos(__s.getRhs(), __buf, __pos - __lhs_size, __n);
    }
  }

  template <class _Left, class _Right, class _StorageDir>
  _Self& _M_append_sum (::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir> const& __s) {
    size_type __s_size = __s.size();
    if (__s_size == 0)
      return *this;
    const size_type __old_size = this->size();
    if (__s_size > this->max_size() || __old_size > (this->max_size() - __s_size))
      this->_M_throw_length_error();
    if (__old_size + __s_size > this->capacity()) {
      const size_type __len = __old_size + (max)(__old_size, __s_size) + 1;
      pointer __new_start = this->_M_start_of_storage.allocate(__len);
      pointer __new_finish = uninitialized_copy(this->_M_Start(), this->_M_Finish(), __new_start);
      __new_finish = this->_M_append_fast(__s, __new_finish);
      this->_M_construct_null(__new_finish);
      this->_M_deallocate_block();
      this->_M_reset(__new_start, __new_finish, __new_start + __len);
    }
    else {
      _M_append_sum_no_overflow(__s, 0, __s_size);
    }
    return *this;
  }

  template <class _Left, class _Right, class _StorageDir>
  _Self& _M_append_sum_pos(::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir> const& __s,
                           size_type __pos, size_type __n) {
    size_type __s_size = (min)(__s.size() - __pos, __n);
    if (__s_size == 0)
      return *this;
    const size_type __old_size = this->size();
    if (__s_size > this->max_size() || __old_size > (this->max_size() - __s_size))
      this->_M_throw_length_error();
    if (__old_size + __s_size > this->capacity()) {
      const size_type __len = __old_size + (max)(__old_size, __s_size) + 1;
      pointer __new_start = this->_M_start_of_storage.allocate(__len);
      pointer __new_finish = uninitialized_copy(this->_M_Start(), this->_M_Finish(), __new_start);
      __new_finish = _M_append_fast_pos(__s, __new_finish, __pos, __s_size);
      this->_M_construct_null(__new_finish);
      this->_M_deallocate_block();
      this->_M_reset(__new_start, __new_finish, __new_start + __len);
    }
    else {
      _M_append_sum_no_overflow(__s, __pos, __s_size);
    }
    return *this;
  }

  template <class _Left, class _Right, class _StorageDir>
  void _M_append_sum_no_overflow(::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir> const& __s,
                                 size_type __pos, size_type __n) {
    pointer __finish = this->_M_Finish();
    _M_append_fast_pos(__s, __finish + 1, __pos + 1, __n - 1);
    this->_M_construct_null(__finish + __n);
    _Traits::assign(*this->_M_finish, __s[__pos]);
    this->_M_finish += __n;
  }
};





}



namespace std {

// ------------------------------------------------------------
// Non-member functions.
// Swap.
template <class _CharT, class _Traits, class _Alloc>
inline void 
swap(basic_string<_CharT,_Traits,_Alloc>& __x,
     basic_string<_CharT,_Traits,_Alloc>& __y)
{ __x.swap(__y); }

template <class _CharT, class _Traits, class _Alloc>
struct __move_traits<basic_string<_CharT, _Traits, _Alloc> > {
  typedef __true_type implemented;
  //Completness depends on the allocator:
  typedef typename __move_traits<_Alloc>::complete complete;
};
/*#else
 * There is no need to specialize for string and wstring in this case
 * as the default __move_traits will already tell that string is movable
 * but not complete. We cannot define it as complete as nothing guaranty
 * that the STLport user hasn't specialized std::allocator for char or
 * wchar_t.
 */

namespace priv {

template <class _CharT, class _Traits, class _Alloc>
void  _S_string_copy(const basic_string<_CharT,_Traits,_Alloc>& __s,
                               _CharT* __buf, size_t __n);


inline const char* 
__get_c_string(const string& __str) { return __str.c_str(); }

}

}

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 2003
 * Francois Dumont
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


namespace std {


// addition with basic_string
template <class _CharT, class _Traits, class _Alloc>
inline ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc,
                             ::std::priv:: __bstr_wrapper<_CharT,_Traits,_Alloc>,
                             ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc,
                                                   ::std::priv:: __bstr_wrapper<_CharT,_Traits,_Alloc>,
                                                   ::std::priv:: __sum_storage_elem<_CharT, _Traits, _Alloc>,
                                                   ::std::priv:: __on_right>,
                             ::std::priv:: __on_right> 
operator+(const basic_string<_CharT,_Traits,_Alloc>& __lhs,
          const basic_string<_CharT,_Traits,_Alloc>& __rhs) {
  typedef ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, ::std::priv:: __bstr_wrapper<_CharT,_Traits,_Alloc>,
                                                         ::std::priv:: __sum_storage_elem<_CharT, _Traits, _Alloc>,
                                                         ::std::priv:: __on_right> __root_type;
  __root_type __root(__rhs, ::std::priv:: __sum_storage_elem<_CharT, _Traits, _Alloc>(__lhs.get_allocator()));
  return ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, ::std::priv:: __bstr_wrapper<_CharT,_Traits,_Alloc>,
                                                        __root_type,
                                                        ::std::priv:: __on_right>(__lhs, __root);
}

template <class _CharT, class _Traits, class _Alloc, class _Left, class _Right, class _StorageDir>
inline ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc,
                             ::std::priv:: __bstr_wrapper<_CharT,_Traits,_Alloc>,
                             ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>,
                             ::std::priv:: __on_right> 
operator+(const basic_string<_CharT,_Traits,_Alloc>& __lhs,
          const ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>& __rhs) {
  return ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, ::std::priv:: __bstr_wrapper<_CharT,_Traits,_Alloc>,
                                                        ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>,
                                                        ::std::priv:: __on_right>(__lhs, __rhs);
}

template <class _CharT, class _Traits, class _Alloc, class _Left, class _Right, class _StorageDir>
inline ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc,
                             ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>,
                             ::std::priv:: __bstr_wrapper<_CharT,_Traits,_Alloc>,
                             ::std::priv:: __on_left> 
operator+(const ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>& __lhs,
          const basic_string<_CharT,_Traits,_Alloc>& __rhs) {
  return ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>,
                                                        ::std::priv:: __bstr_wrapper<_CharT,_Traits,_Alloc>,
                                                        ::std::priv:: __on_left>(__lhs, __rhs);
}

// addition with C string
template <class _CharT, class _Traits, class _Alloc>
inline ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc,
                             ::std::priv:: __bstr_wrapper<_CharT,_Traits,_Alloc>,
                             ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc,
                                                   ::std::priv:: __cstr_wrapper<_CharT>,
                                                   ::std::priv:: __sum_storage_elem<_CharT, _Traits, _Alloc>,
                                                   ::std::priv:: __on_right>,
                             ::std::priv:: __on_right> 
operator+(const basic_string<_CharT,_Traits,_Alloc>& __x,
          const _CharT* __s) {
  const size_t __n = _Traits::length(__s);
  typedef ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, ::std::priv:: __cstr_wrapper<_CharT>,
                                                         ::std::priv:: __sum_storage_elem<_CharT, _Traits, _Alloc>,
                                                         ::std::priv:: __on_right> __root_type;
  __root_type __root(::std::priv:: __cstr_wrapper<_CharT>(__s, __n), ::std::priv:: __sum_storage_elem<_CharT, _Traits, _Alloc>(__x.get_allocator()));
  return ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, ::std::priv:: __bstr_wrapper<_CharT,_Traits,_Alloc>,
                                                        __root_type, ::std::priv:: __on_right>(__x, __root);
}

template <class _CharT, class _Traits, class _Alloc>
inline ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc,
                             ::std::priv:: __cstr_wrapper<_CharT>,
                             ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc,
                                                   ::std::priv:: __bstr_wrapper<_CharT,_Traits,_Alloc>,
                                                   ::std::priv:: __sum_storage_elem<_CharT, _Traits, _Alloc>,
                                                   ::std::priv:: __on_right>,
                             ::std::priv:: __on_right> 
operator+(const _CharT* __s,
          const basic_string<_CharT,_Traits,_Alloc>& __y) {
  const size_t __n = _Traits::length(__s);
  typedef ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, ::std::priv:: __bstr_wrapper<_CharT,_Traits,_Alloc>,
                                                         ::std::priv:: __sum_storage_elem<_CharT, _Traits, _Alloc>,
                                                         ::std::priv:: __on_right> __root_type;
  __root_type __root(__y, ::std::priv:: __sum_storage_elem<_CharT, _Traits, _Alloc>(__y.get_allocator()));
  return ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, ::std::priv:: __cstr_wrapper<_CharT>,
                                                        __root_type,
                                                        ::std::priv:: __on_right>(::std::priv:: __cstr_wrapper<_CharT>(__s, __n), __root);
}

template <class _CharT, class _Traits, class _Alloc, class _Left, class _Right, class _StorageDir>
inline ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc,
                             ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>,
                             ::std::priv:: __cstr_wrapper<_CharT>,
                             ::std::priv:: __on_left> 
operator+(const ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>& __x,
          const _CharT* __s) {
  const size_t __n = _Traits::length(__s);
  return ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>,
                                                        ::std::priv:: __cstr_wrapper<_CharT>,
                                                        ::std::priv:: __on_left>(__x, ::std::priv:: __cstr_wrapper<_CharT>(__s, __n));
}

template <class _CharT, class _Traits, class _Alloc, class _Left, class _Right, class _StorageDir>
inline ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc,
                             ::std::priv:: __cstr_wrapper<_CharT>,
                             ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>,
                             ::std::priv:: __on_right> 
operator+(const _CharT* __s,
          const ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>& __y) {
  const size_t __n = _Traits::length(__s);
  return ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, ::std::priv:: __cstr_wrapper<_CharT>,
                                                        ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>,
                                                        ::std::priv:: __on_right>(::std::priv:: __cstr_wrapper<_CharT>(__s, __n), __y);
}

// addition with char
template <class _CharT, class _Traits, class _Alloc>
inline ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc,
                             ::std::priv:: __bstr_wrapper<_CharT,_Traits,_Alloc>,
                             ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc,
                                                   ::std::priv:: __char_wrapper<_CharT>,
                                                   ::std::priv:: __sum_storage_elem<_CharT, _Traits, _Alloc>,
                                                   ::std::priv:: __on_right>,
                             ::std::priv:: __on_right> 
operator+(const basic_string<_CharT,_Traits,_Alloc>& __x, const _CharT __c) {
  typedef ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, ::std::priv:: __char_wrapper<_CharT>,
                                                         ::std::priv:: __sum_storage_elem<_CharT, _Traits, _Alloc>,
                                                         ::std::priv:: __on_right> __root_type;
  __root_type __root(__c, ::std::priv:: __sum_storage_elem<_CharT, _Traits, _Alloc>(__x.get_allocator()));
  return ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, ::std::priv:: __bstr_wrapper<_CharT,_Traits,_Alloc>,
                                                        __root_type, ::std::priv:: __on_right>(__x, __root);
}

template <class _CharT, class _Traits, class _Alloc>
inline ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc,
                             ::std::priv:: __char_wrapper<_CharT>,
                             ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc,
                                                   ::std::priv:: __bstr_wrapper<_CharT,_Traits,_Alloc>,
                                                   ::std::priv:: __sum_storage_elem<_CharT, _Traits, _Alloc>,
                                                   ::std::priv:: __on_right>,
                             ::std::priv:: __on_right> 
operator+(const _CharT __c, const basic_string<_CharT,_Traits,_Alloc>& __x) {
  typedef ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, ::std::priv:: __bstr_wrapper<_CharT,_Traits,_Alloc>,
                                                         ::std::priv:: __sum_storage_elem<_CharT, _Traits, _Alloc>,
                                                         ::std::priv:: __on_right> __root_type;
  __root_type __root(__x, ::std::priv:: __sum_storage_elem<_CharT, _Traits, _Alloc>(__x.get_allocator()));
  return ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, ::std::priv:: __char_wrapper<_CharT>,
                                                        __root_type, ::std::priv:: __on_right>(__c, __root);
}

template <class _CharT, class _Traits, class _Alloc, class _Left, class _Right, class _StorageDir>
inline ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc,
                             ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>,
                             ::std::priv:: __char_wrapper<_CharT>,
                             ::std::priv:: __on_left> 
operator+(const ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>& __x, const _CharT __c) {
  return ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>,
                                                        ::std::priv:: __char_wrapper<_CharT>, ::std::priv:: __on_left>(__x, __c);
}

template <class _CharT, class _Traits, class _Alloc, class _Left, class _Right, class _StorageDir>
inline ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, ::std::priv:: __char_wrapper<_CharT>,
                                                      ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>,
                                                      ::std::priv:: __on_right> 
operator+(const _CharT __c, const ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>& __x) {
  return ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, ::std::priv:: __char_wrapper<_CharT>,
                                                        ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>,
                                                        ::std::priv:: __on_right>(__c, __x);
}


// Operator== and operator!=

template <class _CharT, class _Traits, class _Alloc>
inline bool 
operator==(const basic_string<_CharT,_Traits,_Alloc>& __x,
           const basic_string<_CharT,_Traits,_Alloc>& __y) {
  return __x.size() == __y.size() && _Traits::compare(__x.data(), __y.data(), __x.size()) == 0;
}

template <class _CharT, class _Traits, class _Alloc, class _Lhs, class _Rhs, class _StoreDir>
inline bool 
operator==(const ::std::priv:: __bstr_sum<_CharT,_Traits,_Alloc,_Lhs,_Rhs,_StoreDir>& __x,
           const basic_string<_CharT,_Traits,_Alloc>& __y) {
  return __x.size() == __y.size() && _Traits::compare(__x.data(), __y.data(), __x.size()) == 0;
}

template <class _CharT, class _Traits, class _Alloc, class _Lhs, class _Rhs, class _StoreDir>
inline bool 
operator==(const basic_string<_CharT,_Traits,_Alloc>& __x,
           const ::std::priv:: __bstr_sum<_CharT,_Traits,_Alloc,_Lhs,_Rhs,_StoreDir>& __y) {
  return __x.size() == __y.size() && _Traits::compare(__x.data(), __y.data(), __x.size()) == 0;
}


template <class _CharT, class _Traits, class _Alloc>
inline bool 
operator==(const _CharT* __s,
           const basic_string<_CharT,_Traits,_Alloc>& __y) {
  
  size_t __n = _Traits::length(__s);
  return __n == __y.size() && _Traits::compare(__s, __y.data(), __n) == 0;
}

template <class _CharT, class _Traits, class _Alloc>
inline bool 
operator==(const basic_string<_CharT,_Traits,_Alloc>& __x,
           const _CharT* __s) {
  
  size_t __n = _Traits::length(__s);
  return __x.size() == __n && _Traits::compare(__x.data(), __s, __n) == 0;
}

template <class _CharT, class _Traits, class _Alloc, class _Lhs, class _Rhs, class _StoreDir>
inline bool 
operator==(const _CharT* __s,
           const ::std::priv:: __bstr_sum<_CharT,_Traits,_Alloc,_Lhs,_Rhs,_StoreDir>& __y) {
  
  size_t __n = _Traits::length(__s);
  return __n == __y.size() && _Traits::compare(__s, __y.data(), __n) == 0;
}

template <class _CharT, class _Traits, class _Alloc, class _Lhs, class _Rhs, class _StoreDir>
inline bool 
operator==(const ::std::priv:: __bstr_sum<_CharT,_Traits,_Alloc,_Lhs,_Rhs,_StoreDir>& __x,
           const _CharT* __s) {
  
  size_t __n = _Traits::length(__s);
  return __x.size() == __n && _Traits::compare(__x.data(), __s, __n) == 0;
}

// Operator< (and also >, <=, and >=).

template <class _CharT, class _Traits, class _Alloc>
inline bool 
operator<(const basic_string<_CharT,_Traits,_Alloc>& __x,
          const basic_string<_CharT,_Traits,_Alloc>& __y) {
  return basic_string<_CharT,_Traits,_Alloc> ::_M_compare(__x.begin(), __x.end(),
                                                          __y.begin(), __y.end()) < 0;
}

template <class _CharT, class _Traits, class _Alloc, class _Lhs, class _Rhs, class _StoreDir>
inline bool 
operator<(const ::std::priv:: __bstr_sum<_CharT,_Traits,_Alloc,_Lhs,_Rhs,_StoreDir>& __x,
          const basic_string<_CharT,_Traits,_Alloc>& __y) {
  return basic_string<_CharT,_Traits,_Alloc> ::_M_compare(__x.begin(), __x.end(),
                                                          __y.begin(), __y.end()) < 0;
}

template <class _CharT, class _Traits, class _Alloc, class _Lhs, class _Rhs, class _StoreDir>
inline bool 
operator<(const basic_string<_CharT,_Traits,_Alloc>& __x,
          const ::std::priv:: __bstr_sum<_CharT,_Traits,_Alloc,_Lhs,_Rhs,_StoreDir>& __y) {
  return basic_string<_CharT,_Traits,_Alloc> ::_M_compare(__x.begin(), __x.end(),
                                                          __y.begin(), __y.end()) < 0;
}

template <class _CharT, class _Traits, class _Alloc>
inline bool 
operator<(const _CharT* __s,
          const basic_string<_CharT,_Traits,_Alloc>& __y) {
  
  size_t __n = _Traits::length(__s);
  return basic_string<_CharT,_Traits,_Alloc> ::_M_compare(__s, __s + __n,
                                                          __y.begin(), __y.end()) < 0;
}

template <class _CharT, class _Traits, class _Alloc>
inline bool 
operator<(const basic_string<_CharT,_Traits,_Alloc>& __x,
          const _CharT* __s) {
  
  size_t __n = _Traits::length(__s);
  return basic_string<_CharT,_Traits,_Alloc> ::_M_compare(__x.begin(), __x.end(),
                                                          __s, __s + __n) < 0;
}

template <class _CharT, class _Traits, class _Alloc, class _Lhs, class _Rhs, class _StoreDir>
inline bool 
operator<(const _CharT* __s,
          const ::std::priv:: __bstr_sum<_CharT,_Traits,_Alloc,_Lhs,_Rhs,_StoreDir>& __y) {
  
  size_t __n = _Traits::length(__s);
  return basic_string<_CharT,_Traits,_Alloc> ::_M_compare(__s, __s + __n,
                                                          __y.begin(), __y.end()) < 0;
}

template <class _CharT, class _Traits, class _Alloc, class _Lhs, class _Rhs, class _StoreDir>
inline bool 
operator<(const ::std::priv:: __bstr_sum<_CharT,_Traits,_Alloc,_Lhs,_Rhs,_StoreDir>& __x,
          const _CharT* __s) {
  
  size_t __n = _Traits::length(__s);
  return basic_string<_CharT,_Traits,_Alloc> ::_M_compare(__x.begin(), __x.end(),
                                                          __s, __s + __n) < 0;
}


/* Only defined if _STLP_USE_SEPARATE_RELOPS_NAMESPACE is defined otherwise
 * it might introduce ambiguity with pure template relational operators
 * from rel_ops namespace.
 */
template <class _CharT, class _Traits, class _Alloc>
inline bool 
operator!=(const basic_string<_CharT,_Traits,_Alloc>& __x,
           const basic_string<_CharT,_Traits,_Alloc>& __y)
{ return !(__x == __y); }

template <class _CharT, class _Traits, class _Alloc>
inline bool 
operator>(const basic_string<_CharT,_Traits,_Alloc>& __x,
          const basic_string<_CharT,_Traits,_Alloc>& __y)
{ return __y < __x; }

template <class _CharT, class _Traits, class _Alloc>
inline bool 
operator<=(const basic_string<_CharT,_Traits,_Alloc>& __x,
           const basic_string<_CharT,_Traits,_Alloc>& __y)
{ return !(__y < __x); }

template <class _CharT, class _Traits, class _Alloc>
inline bool 
operator>=(const basic_string<_CharT,_Traits,_Alloc>& __x,
           const basic_string<_CharT,_Traits,_Alloc>& __y)
{ return !(__x < __y); }

template <class _CharT, class _Traits, class _Alloc, class _Lhs, class _Rhs, class _StoreDir>
inline bool 
operator!=(const ::std::priv:: __bstr_sum<_CharT,_Traits,_Alloc,_Lhs,_Rhs,_StoreDir>& __x,
           const basic_string<_CharT,_Traits,_Alloc>& __y)
{ return !(__x==__y); }

template <class _CharT, class _Traits, class _Alloc, class _Lhs, class _Rhs, class _StoreDir>
inline bool 
operator!=(const basic_string<_CharT,_Traits,_Alloc>& __x,
           const ::std::priv:: __bstr_sum<_CharT,_Traits,_Alloc,_Lhs,_Rhs,_StoreDir>& __y)
{ return !(__x==__y); }


template <class _CharT, class _Traits, class _Alloc>
inline bool 
operator!=(const _CharT* __s,
           const basic_string<_CharT,_Traits,_Alloc>& __y) {
  
  return !(__s == __y);
}

template <class _CharT, class _Traits, class _Alloc>
inline bool 
operator!=(const basic_string<_CharT,_Traits,_Alloc>& __x,
           const _CharT* __s) {
  
  return !(__x == __s);
}

template <class _CharT, class _Traits, class _Alloc, class _Lhs, class _Rhs, class _StoreDir>
inline bool 
operator!=(const _CharT* __s,
           const ::std::priv:: __bstr_sum<_CharT,_Traits,_Alloc,_Lhs,_Rhs,_StoreDir>& __y) {
  
  return !(__s == __y);
}

template <class _CharT, class _Traits, class _Alloc, class _Lhs, class _Rhs, class _StoreDir>
inline bool 
operator!=(const ::std::priv:: __bstr_sum<_CharT,_Traits,_Alloc,_Lhs,_Rhs,_StoreDir>& __x,
           const _CharT* __s) {
  
  return !(__x == __s);
}

template <class _CharT, class _Traits, class _Alloc>
inline bool 
operator>(const _CharT* __s,
          const basic_string<_CharT,_Traits,_Alloc>& __y) {
  
  return __y < __s;
}

template <class _CharT, class _Traits, class _Alloc>
inline bool 
operator>(const basic_string<_CharT,_Traits,_Alloc>& __x,
          const _CharT* __s) {
  
  return __s < __x;
}

template <class _CharT, class _Traits, class _Alloc, class _Lhs, class _Rhs, class _StoreDir>
inline bool 
operator>(const _CharT* __s,
          const ::std::priv:: __bstr_sum<_CharT,_Traits,_Alloc,_Lhs,_Rhs,_StoreDir>& __y) {
  
  return __y < __s;
}

template <class _CharT, class _Traits, class _Alloc, class _Lhs, class _Rhs, class _StoreDir>
inline bool 
operator>(const ::std::priv:: __bstr_sum<_CharT,_Traits,_Alloc,_Lhs,_Rhs,_StoreDir>& __x,
          const _CharT* __s) {
  
  return __s < __x;
}

template <class _CharT, class _Traits, class _Alloc>
inline bool 
operator<=(const _CharT* __s,
           const basic_string<_CharT,_Traits,_Alloc>& __y) {
  
  return !(__y < __s);
}

template <class _CharT, class _Traits, class _Alloc>
inline bool 
operator<=(const basic_string<_CharT,_Traits,_Alloc>& __x,
           const _CharT* __s) {
  
  return !(__s < __x);
}

template <class _CharT, class _Traits, class _Alloc, class _Lhs, class _Rhs, class _StoreDir>
inline bool 
operator<=(const _CharT* __s,
           const ::std::priv:: __bstr_sum<_CharT,_Traits,_Alloc,_Lhs,_Rhs,_StoreDir>& __y) {
  
  return !(__y < __s);
}

template <class _CharT, class _Traits, class _Alloc, class _Lhs, class _Rhs, class _StoreDir>
inline bool 
operator<=(const ::std::priv:: __bstr_sum<_CharT,_Traits,_Alloc,_Lhs,_Rhs,_StoreDir>& __x,
           const _CharT* __s) {
  
  return !(__s < __x);
}

template <class _CharT, class _Traits, class _Alloc>
inline bool 
operator>=(const _CharT* __s,
           const basic_string<_CharT,_Traits,_Alloc>& __y) {
  
  return !(__s < __y);
}

template <class _CharT, class _Traits, class _Alloc>
inline bool 
operator>=(const basic_string<_CharT,_Traits,_Alloc>& __x,
           const _CharT* __s) {
  
  return !(__x < __s);
}

template <class _CharT, class _Traits, class _Alloc, class _Lhs, class _Rhs, class _StoreDir>
inline bool 
operator>=(const _CharT* __s,
           const ::std::priv:: __bstr_sum<_CharT,_Traits,_Alloc,_Lhs,_Rhs,_StoreDir>& __y) {
  
  return !(__s < __y);
}

template <class _CharT, class _Traits, class _Alloc, class _Lhs, class _Rhs, class _StoreDir>
inline bool 
operator>=(const ::std::priv:: __bstr_sum<_CharT,_Traits,_Alloc,_Lhs,_Rhs,_StoreDir>& __x,
           const _CharT* __s) {
  
  return !(__x < __s);
}

}



/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 */



/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Silicon Graphics makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 */

// WARNING: This is an internal header file, included by other C++
// standard library headers.  You should not attempt to use this header
// file directly.



// This file contains a few small adapters that allow a character
// traits class to be used as a function object.

namespace std {

namespace priv {

template <class _Traits>
struct _Eq_traits
  : public binary_function<typename _Traits::char_type,
                           typename _Traits::char_type,
                           bool> {
  bool operator()(const typename _Traits::char_type& __x,
                  const typename _Traits::char_type& __y) const
  { return _Traits::eq(__x, __y); }
};

template <class _Traits>
struct _Eq_char_bound
  : public unary_function<typename _Traits::char_type, bool> {
  typename _Traits::char_type __val;
  _Eq_char_bound(typename _Traits::char_type __c) : __val(__c) {}
  bool operator()(const typename _Traits::char_type& __x) const
  { return _Traits::eq(__x, __val); }
};

template <class _Traits>
struct _Neq_char_bound
  : public unary_function<typename _Traits::char_type, bool>
{
  typename _Traits::char_type __val;
  _Neq_char_bound(typename _Traits::char_type __c) : __val(__c) {}
  bool operator()(const typename _Traits::char_type& __x) const
  { return !_Traits::eq(__x, __val); }
};

template <class _Traits>
struct _Eq_int_bound
  : public unary_function<typename _Traits::char_type, bool> {
  typename _Traits::int_type __val;

  _Eq_int_bound(typename _Traits::int_type __c) : __val(__c) {}
  bool operator()(const typename _Traits::char_type& __x) const
  { return _Traits::eq_int_type(_Traits::to_int_type(__x), __val); }
};


}

}


// Local Variables:
// mode:C++
// End:

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996-1998
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

/* NOTE: This is an internal header file, included by other STL headers.
 *   You should not attempt to use it directly.
 */




namespace std {

template <class _Tp>
struct not_equal_to : public binary_function<_Tp, _Tp, bool> {
  bool operator()(const _Tp& __x, const _Tp& __y) const { return __x != __y; }
};

template <class _Tp>
struct greater : public binary_function<_Tp, _Tp, bool> {
  bool operator()(const _Tp& __x, const _Tp& __y) const { return __x > __y; }
};

template <class _Tp>
struct greater_equal : public binary_function<_Tp, _Tp, bool> {
  bool operator()(const _Tp& __x, const _Tp& __y) const { return __x >= __y; }
};

template <class _Tp>
struct less_equal : public binary_function<_Tp, _Tp, bool> {
  bool operator()(const _Tp& __x, const _Tp& __y) const { return __x <= __y; }
};

template <class _Tp>
struct divides : public binary_function<_Tp, _Tp, _Tp> {
  _Tp operator()(const _Tp& __x, const _Tp& __y) const { return __x / __y; }
};

template <class _Tp>
struct modulus : public binary_function<_Tp, _Tp, _Tp> {
  _Tp operator()(const _Tp& __x, const _Tp& __y) const { return __x % __y; }
};

template <class _Tp>
struct negate : public unary_function<_Tp, _Tp> {
  _Tp operator()(const _Tp& __x) const { return -__x; }
};

template <class _Tp>
struct logical_and : public binary_function<_Tp, _Tp, bool> {
  bool operator()(const _Tp& __x, const _Tp& __y) const { return __x && __y; }
};

template <class _Tp>
struct logical_or : public binary_function<_Tp, _Tp,bool> {
  bool operator()(const _Tp& __x, const _Tp& __y) const { return __x || __y; }
};

template <class _Tp>
struct logical_not : public unary_function<_Tp, bool> {
  bool operator()(const _Tp& __x) const { return !__x; }
};

// identity_element (not part of the C++ standard).
template <class _Tp> inline _Tp identity_element(plus<_Tp>) {  return _Tp(0); }
template <class _Tp> inline _Tp identity_element(multiplies<_Tp>) { return _Tp(1); }


template <class _Predicate>
class unary_negate
    : public unary_function<typename _Predicate::argument_type, bool> {
  typedef unary_function<typename _Predicate::argument_type, bool> _Base;
public:
  typedef typename _Base::argument_type argument_type;
private:
  typedef typename __call_traits<argument_type>::const_param_type _ArgParamType;
protected:
  _Predicate _M_pred;
public:
  explicit unary_negate(const _Predicate& __x) : _M_pred(__x) {}
  bool operator()(_ArgParamType __x) const {
    return !_M_pred(__x);
  }
};

template <class _Predicate>
inline unary_negate<_Predicate>
not1(const _Predicate& __pred) {
  return unary_negate<_Predicate>(__pred);
}

template <class _Predicate>
class binary_negate
    : public binary_function<typename _Predicate::first_argument_type,
                             typename _Predicate::second_argument_type,
                             bool> {
  typedef binary_function<typename _Predicate::first_argument_type,
                          typename _Predicate::second_argument_type,
                          bool> _Base;
public:
  typedef typename _Base::first_argument_type first_argument_type;
  typedef typename _Base::second_argument_type second_argument_type;
private:
  typedef typename __call_traits<first_argument_type>::const_param_type _FstArgParamType;
  typedef typename __call_traits<second_argument_type>::const_param_type _SndArgParamType;
protected:
  _Predicate _M_pred;
public:
  explicit binary_negate(const _Predicate& __x) : _M_pred(__x) {}
  bool operator()(_FstArgParamType __x, _SndArgParamType __y) const {
    return !_M_pred(__x, __y);
  }
};

template <class _Predicate>
inline binary_negate<_Predicate>
not2(const _Predicate& __pred) {
  return binary_negate<_Predicate>(__pred);
}

/******************************************************************************/
/* The standard name (20.3.6.1) for _M_value, below, is value.                */
/******************************************************************************/

template <class _Operation>
class binder1st :
    public unary_function<typename _Operation::second_argument_type,
                          typename _Operation::result_type > {
  typedef unary_function<typename _Operation::second_argument_type,
                         typename _Operation::result_type > _Base;
public:
  typedef typename _Base::argument_type argument_type;
  typedef typename _Base::result_type result_type;
private:
  typedef typename __call_traits<argument_type>::param_type _ArgParamType;
  typedef typename __call_traits<argument_type>::const_param_type _ConstArgParamType;
  typedef typename __call_traits<typename _Operation::first_argument_type>::const_param_type _ValueParamType;
protected:
  //op is a Standard name (20.3.6.1), do no make it STLport naming convention compliant.
  _Operation op;
  typename _Operation::first_argument_type value;
public:
  binder1st(const _Operation& __x, _ValueParamType __y)
    : op(__x), value(__y) {}

  result_type operator()(_ConstArgParamType __x) const
  { return op(value, __x); }
  // DR 109 Missing binders for non-const sequence elements
  result_type operator()(_ArgParamType __x) const
  { return op(value, __x); }
};


template <class _Operation, class _Tp>
inline binder1st<_Operation>
bind1st(const _Operation& __fn, const _Tp& __x) {
  typedef typename _Operation::first_argument_type _Arg1_type;
  return binder1st<_Operation>(__fn, _Arg1_type(__x));
}

template <class _Operation>
class binder2nd
  : public unary_function<typename _Operation::first_argument_type,
                          typename _Operation::result_type> {
  typedef unary_function<typename _Operation::first_argument_type,
                         typename _Operation::result_type> _Base;
public:
  typedef typename _Base::argument_type argument_type;
  typedef typename _Base::result_type result_type;
private:
  typedef typename __call_traits<argument_type>::param_type _ArgParamType;
  typedef typename __call_traits<argument_type>::const_param_type _ConstArgParamType;
  typedef typename __call_traits<typename _Operation::second_argument_type>::const_param_type _ValueParamType;
protected:
  //op is a Standard name (20.3.6.3), do no make it STLport naming convention compliant.
  _Operation op;
  typename _Operation::second_argument_type value;
public:
  binder2nd(const _Operation& __x, _ValueParamType __y)
      : op(__x), value(__y) {}

  result_type operator()(_ConstArgParamType __x) const
  { return op(__x, value); }
  // DR 109 Missing binders for non-const sequence elements
  result_type operator()(_ArgParamType __x) const
  { return op(__x, value); }
};

template <class _Operation, class _Tp>
inline binder2nd<_Operation>
bind2nd(const _Operation& __fn, const _Tp& __x) {
  typedef typename _Operation::second_argument_type _Arg2_type;
  return binder2nd<_Operation>(__fn, _Arg2_type(__x));
}

// unary_compose and binary_compose (extensions, not part of the standard).

template <class _Operation1, class _Operation2>
class unary_compose :
  public unary_function<typename _Operation2::argument_type,
                        typename _Operation1::result_type> {
  typedef unary_function<typename _Operation2::argument_type,
                         typename _Operation1::result_type> _Base;
public:
  typedef typename _Base::argument_type argument_type;
  typedef typename _Base::result_type result_type;
private:
  typedef typename __call_traits<argument_type>::const_param_type _ArgParamType;
protected:
  _Operation1 _M_fn1;
  _Operation2 _M_fn2;
public:
  unary_compose(const _Operation1& __x, const _Operation2& __y)
    : _M_fn1(__x), _M_fn2(__y) {}

  result_type operator()(_ArgParamType __x) const {
    return _M_fn1(_M_fn2(__x));
  }
};

template <class _Operation1, class _Operation2>
inline unary_compose<_Operation1,_Operation2>
compose1(const _Operation1& __fn1, const _Operation2& __fn2) {
  return unary_compose<_Operation1,_Operation2>(__fn1, __fn2);
}

template <class _Operation1, class _Operation2, class _Operation3>
class binary_compose :
    public unary_function<typename _Operation2::argument_type,
                          typename _Operation1::result_type> {
  typedef unary_function<typename _Operation2::argument_type,
                         typename _Operation1::result_type> _Base;
public:
  typedef typename _Base::argument_type argument_type;
  typedef typename _Base::result_type result_type;
private:
  typedef typename __call_traits<argument_type>::const_param_type _ArgParamType;
protected:
  _Operation1 _M_fn1;
  _Operation2 _M_fn2;
  _Operation3 _M_fn3;
public:
  binary_compose(const _Operation1& __x, const _Operation2& __y,
                 const _Operation3& __z)
    : _M_fn1(__x), _M_fn2(__y), _M_fn3(__z) { }

  result_type operator()(_ArgParamType __x) const {
    return _M_fn1(_M_fn2(__x), _M_fn3(__x));
  }
};

template <class _Operation1, class _Operation2, class _Operation3>
inline binary_compose<_Operation1, _Operation2, _Operation3>
compose2(const _Operation1& __fn1, const _Operation2& __fn2,
         const _Operation3& __fn3) {
  return binary_compose<_Operation1,_Operation2,_Operation3>(__fn1, __fn2, __fn3);
}

// identity is an extension: it is not part of the standard.
template <class _Tp> struct identity : public ::std::priv:: _Identity<_Tp> {};
// select1st and select2nd are extensions: they are not part of the standard.
template <class _Pair> struct select1st : public ::std::priv:: _Select1st<_Pair> {};
template <class _Pair> struct select2nd : public ::std::priv:: _Select2nd<_Pair> {};

template <class _Arg1, class _Arg2>
struct project1st : public ::std::priv:: _Project1st<_Arg1, _Arg2> {};

template <class _Arg1, class _Arg2>
struct project2nd : public ::std::priv:: _Project2nd<_Arg1, _Arg2> {};


// constant_void_fun, constant_unary_fun, and constant_binary_fun are
// extensions: they are not part of the standard.  (The same, of course,
// is true of the helper functions constant0, constant1, and constant2.)

namespace priv {

template <class _Result>
struct _Constant_void_fun {
  typedef _Result result_type;
  result_type _M_val;

  _Constant_void_fun(const result_type& __v) : _M_val(__v) {}
  const result_type& operator()() const { return _M_val; }
};

}

template <class _Result>
struct constant_void_fun : public ::std::priv:: _Constant_void_fun<_Result> {
  constant_void_fun(const _Result& __v)
    : ::std::priv:: _Constant_void_fun<_Result>(__v) {}
};

template <class _Result, class _Argument = _Result >
struct constant_unary_fun : public ::std::priv:: _Constant_unary_fun<_Result, _Argument> {
  constant_unary_fun(const _Result& __v)
    : ::std::priv:: _Constant_unary_fun<_Result, _Argument>(__v) {}
};

template <class _Result, class _Arg1 = _Result, class _Arg2 = _Arg1 >
struct constant_binary_fun
  : public ::std::priv:: _Constant_binary_fun<_Result, _Arg1, _Arg2> {
  constant_binary_fun(const _Result& __v)
    : ::std::priv:: _Constant_binary_fun<_Result, _Arg1, _Arg2>(__v) {}
};

template <class _Result>
inline constant_void_fun<_Result> constant0(const _Result& __val) {
  return constant_void_fun<_Result>(__val);
}

template <class _Result>
inline constant_unary_fun<_Result,_Result> constant1(const _Result& __val) {
  return constant_unary_fun<_Result,_Result>(__val);
}

template <class _Result>
inline constant_binary_fun<_Result,_Result,_Result>
constant2(const _Result& __val) {
  return constant_binary_fun<_Result,_Result,_Result>(__val);
}

// subtractive_rng is an extension: it is not part of the standard.
// Note: this code assumes that int is 32 bits.
class subtractive_rng : public unary_function<unsigned long, unsigned long> {
private:
  unsigned long _M_table[55];
  unsigned long _M_index1;
  unsigned long _M_index2;
public:
  unsigned long operator()(unsigned long __limit) {
    _M_index1 = (_M_index1 + 1) % 55;
    _M_index2 = (_M_index2 + 1) % 55;
    _M_table[_M_index1] = _M_table[_M_index1] - _M_table[_M_index2];
    return _M_table[_M_index1] % __limit;
  }

  void _M_initialize(unsigned long __seed) {
    unsigned long __k = 1;
    _M_table[54] = __seed;
    unsigned long __i;
    for (__i = 0; __i < 54; __i++) {
        unsigned long __ii = (21 * (__i + 1) % 55) - 1;
        _M_table[__ii] = __k;
        __k = __seed - __k;
        __seed = _M_table[__ii];
    }
    for (int __loop = 0; __loop < 4; __loop++) {
        for (__i = 0; __i < 55; __i++)
            _M_table[__i] = _M_table[__i] - _M_table[(1 + __i + 30) % 55];
    }
    _M_index1 = 0;
    _M_index2 = 31;
  }

  subtractive_rng(unsigned int __seed) { _M_initialize(__seed); }
  subtractive_rng() { _M_initialize(161803398ul); }
};


}

/*
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996-1998
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2000
 * Pavel Kuznetsov
 *
 * Copyright (c) 2001
 * Meridian'93
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

/* NOTE: This is an internal header file, included by other STL headers.
 *   You should not attempt to use it directly.
 */

// This file has noo macro protection as it is meant to be included several times
// from other header.
// Adaptor function objects: pointers to member functions.

// There are a total of 16 = 2^4 function objects in this family.
//  (1) Member functions taking no arguments vs member functions taking
//       one argument.
//  (2) Call through pointer vs call through reference.
//  (3) Member function with void return type vs member function with
//      non-void return type.
//  (4) Const vs non-const member function.

// Note that choice (3) is nothing more than a workaround: according
//  to the draft, compilers should handle void and non-void the same way.
//  This feature is not yet widely implemented, though.  You can only use
//  member functions returning void if your compiler supports partial
//  specialization.

// All of this complexity is in the function objects themselves.  You can
//  ignore it by using the helper function mem_fun and mem_fun_ref,
//  which create whichever type of adaptor is appropriate.

namespace std {

//This implementation will only be used if needed, that is to say when there is the return void bug
//and when there is no partial template specialization

template <class _Ret, class _Tp>
class mem_fun_t : public unary_function<_Tp*,_Ret> {
  typedef _Ret (_Tp::*__fun_type)(void);
public:
  explicit mem_fun_t(__fun_type __pf) : _M_f(__pf) {}
  _Ret operator()(_Tp* __p) const { return (__p->*_M_f)(); }
private:
  __fun_type _M_f;
};

template <class _Ret, class _Tp>
class const_mem_fun_t : public unary_function<const _Tp*,_Ret> {
  typedef _Ret (_Tp::*__fun_type)(void) const;
public:
  explicit const_mem_fun_t(__fun_type __pf) : _M_f(__pf) {}
  _Ret operator()(const _Tp* __p) const { return (__p->*_M_f)(); }
private:
  __fun_type _M_f;
};

template <class _Ret, class _Tp>
class mem_fun_ref_t : public unary_function<_Tp,_Ret> {
  typedef _Ret (_Tp::*__fun_type)(void);
public:
  explicit mem_fun_ref_t(__fun_type __pf) : _M_f(__pf) {}
  _Ret operator()(_Tp& __r) const { return (__r.*_M_f)(); }
private:
  __fun_type _M_f;
};

template <class _Ret, class _Tp>
class const_mem_fun_ref_t : public unary_function<_Tp,_Ret> {
  typedef _Ret (_Tp::*__fun_type)(void) const;
public:
  explicit const_mem_fun_ref_t(__fun_type __pf) : _M_f(__pf) {}
  _Ret operator()(const _Tp& __r) const { return (__r.*_M_f)(); }
private:
  __fun_type _M_f;
};

template <class _Ret, class _Tp, class _Arg>
class mem_fun1_t : public binary_function<_Tp*,_Arg,_Ret> {
  typedef _Ret (_Tp::*__fun_type)(_Arg);
public:
  explicit mem_fun1_t(__fun_type __pf) : _M_f(__pf) {}
  _Ret operator()(_Tp* __p, _Arg __x) const { return (__p->*_M_f)(__x); }
private:
  __fun_type _M_f;
};

template <class _Ret, class _Tp, class _Arg>
class const_mem_fun1_t : public binary_function<const _Tp*,_Arg,_Ret> {
  typedef _Ret (_Tp::*__fun_type)(_Arg) const;
public:
  explicit const_mem_fun1_t(__fun_type __pf) : _M_f(__pf) {}
  _Ret operator()(const _Tp* __p, _Arg __x) const
    { return (__p->*_M_f)(__x); }
private:
  __fun_type _M_f;
};

template <class _Ret, class _Tp, class _Arg>
class mem_fun1_ref_t : public binary_function<_Tp,_Arg,_Ret> {
  typedef _Ret (_Tp::*__fun_type)(_Arg);
public:
  explicit mem_fun1_ref_t(__fun_type __pf) : _M_f(__pf) {}
  _Ret operator()(_Tp& __r, _Arg __x) const { return (__r.*_M_f)(__x); }
private:
  __fun_type _M_f;
};

template <class _Ret, class _Tp, class _Arg>
class const_mem_fun1_ref_t : public binary_function<_Tp,_Arg,_Ret> {
  typedef _Ret (_Tp::*__fun_type)(_Arg) const;
public:
  explicit const_mem_fun1_ref_t(__fun_type __pf) : _M_f(__pf) {}
  _Ret operator()(const _Tp& __r, _Arg __x) const { return (__r.*_M_f)(__x); }
private:
  __fun_type _M_f;
};

template <class _Arg, class _Result>
class pointer_to_unary_function : public unary_function<_Arg, _Result> {
protected:
  _Result (*_M_ptr)(_Arg);
public:
  pointer_to_unary_function() {}
  explicit pointer_to_unary_function(_Result (*__x)(_Arg)) : _M_ptr(__x) {}
  _Result operator()(_Arg __x) const { return _M_ptr(__x); }
};

template <class _Arg1, class _Arg2, class _Result>
class pointer_to_binary_function :
  public binary_function<_Arg1,_Arg2,_Result> {
protected:
    _Result (*_M_ptr)(_Arg1, _Arg2);
public:
    pointer_to_binary_function() {}
    explicit pointer_to_binary_function(_Result (*__x)(_Arg1, _Arg2))
      : _M_ptr(__x) {}
    _Result operator()(_Arg1 __x, _Arg2 __y) const {
      return _M_ptr(__x, __y);
    }
};



// Mem_fun adaptor helper functions.  There are only two:
//  mem_fun and mem_fun_ref.  (mem_fun1 and mem_fun1_ref
//  are provided for backward compatibility, but they are no longer
//  part of the C++ standard.)

template <class _Result, class _Tp>
inline mem_fun_t<_Result,_Tp>
mem_fun(_Result (_Tp::*__f)()) { return mem_fun_t<_Result,_Tp>(__f); }

template <class _Result, class _Tp>
inline const_mem_fun_t<_Result,_Tp>
mem_fun(_Result (_Tp::*__f)() const)  { return const_mem_fun_t<_Result,_Tp>(__f); }

template <class _Result, class _Tp>
inline mem_fun_ref_t<_Result,_Tp>
mem_fun_ref(_Result (_Tp::*__f)())  { return mem_fun_ref_t<_Result,_Tp>(__f); }

template <class _Result, class _Tp>
inline const_mem_fun_ref_t<_Result,_Tp>
mem_fun_ref(_Result (_Tp::*__f)() const)  { return const_mem_fun_ref_t<_Result,_Tp>(__f); }

template <class _Result, class _Tp, class _Arg>
inline mem_fun1_t<_Result,_Tp,_Arg>
mem_fun(_Result (_Tp::*__f)(_Arg)) { return mem_fun1_t<_Result,_Tp,_Arg>(__f); }

template <class _Result, class _Tp, class _Arg>
inline const_mem_fun1_t<_Result,_Tp,_Arg>
mem_fun(_Result (_Tp::*__f)(_Arg) const) { return const_mem_fun1_t<_Result,_Tp,_Arg>(__f); }

template <class _Result, class _Tp, class _Arg>
inline mem_fun1_ref_t<_Result,_Tp,_Arg>
mem_fun_ref(_Result (_Tp::*__f)(_Arg)) { return mem_fun1_ref_t<_Result,_Tp,_Arg>(__f); }

template <class _Result, class _Tp, class _Arg>
inline const_mem_fun1_ref_t<_Result,_Tp,_Arg>
mem_fun_ref(_Result (_Tp::*__f)(_Arg) const) { return const_mem_fun1_ref_t<_Result,_Tp,_Arg>(__f); }

//  mem_fun1 and mem_fun1_ref are no longer part of the C++ standard,
//  but they are provided for backward compatibility.
template <class _Result, class _Tp, class _Arg>
inline mem_fun1_t<_Result,_Tp,_Arg>
mem_fun1(_Result (_Tp::*__f)(_Arg)) { return mem_fun1_t<_Result,_Tp,_Arg>(__f); }

template <class _Result, class _Tp, class _Arg>
inline const_mem_fun1_t<_Result,_Tp,_Arg>
mem_fun1(_Result (_Tp::*__f)(_Arg) const) { return const_mem_fun1_t<_Result,_Tp,_Arg>(__f); }

template <class _Result, class _Tp, class _Arg>
inline mem_fun1_ref_t<_Result,_Tp,_Arg>
mem_fun1_ref(_Result (_Tp::*__f)(_Arg)) { return mem_fun1_ref_t<_Result,_Tp,_Arg>(__f); }

template <class _Result, class _Tp, class _Arg>
inline const_mem_fun1_ref_t<_Result,_Tp,_Arg>
mem_fun1_ref(_Result (_Tp::*__f)(_Arg) const) { return const_mem_fun1_ref_t<_Result,_Tp,_Arg>(__f); }



template <class _Arg, class _Result>
inline pointer_to_unary_function<_Arg, _Result>
ptr_fun(_Result (*__f)(_Arg))
{ return pointer_to_unary_function<_Arg, _Result>(__f); }

template <class _Arg1, class _Arg2, class _Result>
inline pointer_to_binary_function<_Arg1,_Arg2,_Result>
ptr_fun(_Result (*__f)(_Arg1, _Arg2))
{ return pointer_to_binary_function<_Arg1,_Arg2,_Result>(__f); }

}


// Local Variables:
// mode:C++
// End:



namespace std {

namespace priv {

// A helper class to use a char_traits as a function object.
template <class _Traits>
struct _Not_within_traits : public unary_function<typename _Traits::char_type, bool> {
  typedef typename _Traits::char_type _CharT;
  const _CharT* _M_first;
  const _CharT* _M_last;

  _Not_within_traits(const _CharT* __f, const _CharT* __l)
    : _M_first(__f), _M_last(__l) {}

  bool operator()(const _CharT& __x) const {
    return find_if(_M_first, _M_last,
                   ::std::priv:: _Eq_char_bound<_Traits>(__x)) == _M_last;
  }
};

template <class _InputIter, class _CharT, class _Traits>
inline _InputIter __str_find_first_of_aux(_InputIter __first1, _InputIter __last1,
                                          const _CharT* __first2, const _CharT* __last2,
                                          _Traits*, const __true_type& /* _STLportTraits */)
{ return __find_first_of(__first1, __last1, __first2, __last2); }

template <class _InputIter, class _CharT, class _Traits>
inline _InputIter __str_find_first_of_aux(_InputIter __first1, _InputIter __last1,
                                          const _CharT* __first2, const _CharT* __last2,
                                          _Traits*, const __false_type& /* _STLportTraits */)
{ return __find_first_of(__first1, __last1, __first2, __last2, ::std::priv:: _Eq_traits<_Traits>()); }

template <class _InputIter, class _CharT, class _Traits>
inline _InputIter __str_find_first_of(_InputIter __first1, _InputIter __last1,
                                      const _CharT* __first2, const _CharT* __last2,
                                      _Traits* __traits) {
  typedef typename _IsSTLportClass<_Traits>::_Ret _STLportTraits;
  return __str_find_first_of_aux(__first1, __last1, __first2, __last2, __traits, _STLportTraits());
}

template <class _InputIter, class _CharT, class _Traits>
inline _InputIter __str_find_first_not_of_aux3(_InputIter __first1, _InputIter __last1,
                                               const _CharT* __first2, const _CharT* __last2,
                                               _Traits* /* __traits */, const __true_type& __useStrcspnLikeAlgo)
{ return __find_first_of_aux2(__first1, __last1, __first2, __last2, __first2, not1(_Identity<bool>()), __useStrcspnLikeAlgo); }

template <class _InputIter, class _CharT, class _Traits>
inline _InputIter __str_find_first_not_of_aux3(_InputIter __first1, _InputIter __last1,
                                               const _CharT* __first2, const _CharT* __last2,
                                               _Traits* /* __traits */, const __false_type& /* _UseStrcspnLikeAlgo */)
{ return ::std::find_if(__first1, __last1, ::std::priv:: _Not_within_traits<_Traits>(__first2, __last2)); }

template <class _InputIter, class _CharT, class _Tp, class _Traits>
inline _InputIter __str_find_first_not_of_aux2(_InputIter __first1, _InputIter __last1,
                                               const _CharT* __first2, const _CharT* __last2,
                                               _Tp* __pt, _Traits* __traits) {
  typedef typename _IsIntegral<_Tp>::_Ret _IsIntegral;
  typedef typename _IsCharLikeType<_CharT>::_Ret _IsCharLike;
  typedef typename _Land2<_IsIntegral, _IsCharLike>::_Ret _UseStrcspnLikeAlgo;
  return __str_find_first_not_of_aux3(__first1, __last1, __first2, __last2, __traits, _UseStrcspnLikeAlgo());
}

template <class _InputIter, class _CharT, class _Traits>
inline _InputIter __str_find_first_not_of_aux1(_InputIter __first1, _InputIter __last1,
                                               const _CharT* __first2, const _CharT* __last2,
                                               _Traits* __traits, const __true_type& /* _STLportTraits */)
{ return __str_find_first_not_of_aux2(__first1, __last1, __first2, __last2,
                                      (typename ::std::iterator_traits< _InputIter > ::value_type*)0, __traits); }

template <class _InputIter, class _CharT, class _Traits>
inline _InputIter __str_find_first_not_of_aux1(_InputIter __first1, _InputIter __last1,
                                               const _CharT* __first2, const _CharT* __last2,
                                               _Traits*, const __false_type& /* _STLportTraits */)
{ return ::std::find_if(__first1, __last1, ::std::priv:: _Not_within_traits<_Traits>(__first2, __last2)); }

template <class _InputIter, class _CharT, class _Traits>
inline _InputIter __str_find_first_not_of(_InputIter __first1, _InputIter __last1,
                                          const _CharT* __first2, const _CharT* __last2,
                                          _Traits* __traits) {
  typedef typename _IsSTLportClass<_Traits>::_Ret _STLportTraits;
  return __str_find_first_not_of_aux1(__first1, __last1, __first2, __last2, __traits, _STLportTraits());
}

// ------------------------------------------------------------
// Non-inline declarations.

}

// Change the string's capacity so that it is large enough to hold
//  at least __res_arg elements, plus the terminating _CharT().  Note that,
//  if __res_arg < capacity(), this member function may actually decrease
//  the string's capacity.
template <class _CharT, class _Traits, class _Alloc>
void basic_string<_CharT,_Traits,_Alloc>::reserve(size_type __res_arg) {
  if (__res_arg > max_size())
    this->_M_throw_length_error();

  size_type __n = (max)(__res_arg, size()) + 1;
  if (__n < this->_M_capacity())
    return;

  _M_reserve(__n);
}

template <class _CharT, class _Traits, class _Alloc>
void basic_string<_CharT,_Traits,_Alloc>::_M_reserve(size_type __n) {
  pointer __new_start = this->_M_start_of_storage.allocate(__n, __n);
  pointer __new_finish = ::std::priv:: __ucopy(this->_M_Start(), this->_M_Finish(), __new_start);
  _M_construct_null(__new_finish);
  this->_M_deallocate_block();
  this->_M_reset(__new_start, __new_finish, __new_start + __n);
}

template <class _CharT, class _Traits, class _Alloc>
basic_string<_CharT,_Traits,_Alloc>&
basic_string<_CharT,_Traits,_Alloc>::append(size_type __n, _CharT __c) {
  if (__n > 0) {
    if (__n > max_size() - size())
      this->_M_throw_length_error();
    if (__n >= this->_M_rest())
      _M_reserve(_M_compute_next_size(__n));
    ::std::priv:: __uninitialized_fill_n(this->_M_finish + 1, __n - 1, __c);
    _M_construct_null(this->_M_finish + __n);
    _Traits::assign(*end(), __c);
    this->_M_finish += __n;
  }
  return *this;
}

template <class _CharT, class _Traits, class _Alloc>
basic_string<_CharT, _Traits, _Alloc>&
basic_string<_CharT, _Traits, _Alloc>::_M_append(const _CharT* __first, const _CharT* __last) {
  if (__first != __last) {
    size_type __n = static_cast<size_type>(__last - __first);
    if (__n >= this->_M_rest()) {
      size_type __len = _M_compute_next_size(__n);
      pointer __new_start = this->_M_start_of_storage.allocate(__len, __len);
      pointer __new_finish = ::std::priv:: __ucopy(this->_M_Start(), this->_M_Finish(), __new_start);
      __new_finish = ::std::priv:: __ucopy(__first, __last, __new_finish);
      _M_construct_null(__new_finish);
      this->_M_deallocate_block();
      this->_M_reset(__new_start, __new_finish, __new_start + __len);
    }
    else {
      const _CharT* __f1 = __first;
      ++__f1;
      ::std::priv:: __ucopy(__f1, __last, this->_M_finish + 1);
      _M_construct_null(this->_M_finish + __n);
      _Traits::assign(*end(), *__first);
      this->_M_finish += __n;
    }
  }
  return *this;
}

template <class _CharT, class _Traits, class _Alloc>
basic_string<_CharT,_Traits,_Alloc>&
basic_string<_CharT,_Traits,_Alloc>::assign(size_type __n, _CharT __c) {
  if (__n <= size()) {
    _Traits::assign(this->_M_Start(), __n, __c);
    erase(begin() + __n, end());
  }
  else {
    if (__n < capacity()) {
      _Traits::assign(this->_M_Start(), size(), __c);
      append(__n - size(), __c);
    }
    else {
      _Self __str(__n, __c);
      this->swap(__str);
    }
  }
  return *this;
}

template <class _CharT, class _Traits, class _Alloc>
basic_string<_CharT,_Traits,_Alloc>&
basic_string<_CharT,_Traits,_Alloc>::_M_assign(const _CharT* __f, const _CharT* __l) {
  ptrdiff_t __n = __l - __f;
  if (static_cast<size_type>(__n) <= size()) {
    _Traits::copy(this->_M_Start(), __f, __n);
    erase(begin() + __n, end());
  }
  else {
    _Traits::copy(this->_M_Start(), __f, size());
    _M_append(__f + size(), __l);
  }
  return *this;
}

template <class _CharT, class _Traits, class _Alloc>
_CharT* basic_string<_CharT,_Traits,_Alloc> ::_M_insert_aux(_CharT* __p,
                                                            _CharT __c) {
  pointer __new_pos = __p;
  if (this->_M_rest() > 1 ) {
    _M_construct_null(this->_M_finish + 1);
    _Traits::move(__p + 1, __p, this->_M_finish - __p);
    _Traits::assign(*__p, __c);
    ++this->_M_finish;
  }
  else {
    size_type __len = _M_compute_next_size(1);
    pointer __new_start = this->_M_start_of_storage.allocate(__len, __len);
    __new_pos = ::std::priv:: __ucopy(this->_M_Start(), __p, __new_start);
    _Traits::assign(*__new_pos, __c);
    pointer __new_finish = __new_pos + 1;
    __new_finish = ::std::priv:: __ucopy(__p, this->_M_finish, __new_finish);
    _M_construct_null(__new_finish);
    this->_M_deallocate_block();
    this->_M_reset(__new_start, __new_finish, __new_start + __len);
  }
  return __new_pos;
}

template <class _CharT, class _Traits, class _Alloc>
void basic_string<_CharT,_Traits,_Alloc>::insert(iterator __pos,
                                                 size_t __n, _CharT __c) {
  if (__n != 0) {
    if (this->_M_rest() > __n) {
      const size_type __elems_after = this->_M_finish - __pos;
      pointer __old_finish = this->_M_finish;
      if (__elems_after >= __n) {
        ::std::priv:: __ucopy((this->_M_finish - __n) + 1, this->_M_finish + 1, this->_M_finish + 1);
        this->_M_finish += __n;
        _Traits::move(__pos + __n, __pos, (__elems_after - __n) + 1);
        _Traits::assign(__pos, __n, __c);
      }
      else {
        ::std::priv:: __uninitialized_fill_n(this->_M_finish + 1, __n - __elems_after - 1, __c);
        this->_M_finish += __n - __elems_after;
        ::std::priv:: __ucopy(__pos, __old_finish + 1, this->_M_finish);
        this->_M_finish += __elems_after;
        _Traits::assign(__pos, __elems_after + 1, __c);
      }
    }
    else {
      size_type __len = _M_compute_next_size(__n);
      pointer __new_start = this->_M_start_of_storage.allocate(__len, __len);
      pointer __new_finish = ::std::priv:: __ucopy(this->_M_Start(), __pos, __new_start);
      __new_finish = ::std::priv:: __uninitialized_fill_n(__new_finish, __n, __c);
      __new_finish = ::std::priv:: __ucopy(__pos, this->_M_finish, __new_finish);
      _M_construct_null(__new_finish);
      this->_M_deallocate_block();
      this->_M_reset(__new_start, __new_finish, __new_start + __len);
    }
  }
}

template <class _CharT, class _Traits, class _Alloc>
void basic_string<_CharT,_Traits,_Alloc>::_M_insert(iterator __pos,
                                                    const _CharT* __first, const _CharT* __last,
                                                    bool __self_ref) {
  //this version has to take care about the auto referencing
  if (__first != __last) {
    const size_t __n = __last - __first;
    if (this->_M_rest() > __n) {
      const size_t __elems_after = this->_M_finish - __pos;
      pointer __old_finish = this->_M_finish;
      if (__elems_after >= __n) {
        ::std::priv:: __ucopy((this->_M_finish - __n) + 1, this->_M_finish + 1, this->_M_finish + 1);
        this->_M_finish += __n;
        _Traits::move(__pos + __n, __pos, (__elems_after - __n) + 1);
        if (!__self_ref || __last < __pos) {
          _M_copy(__first, __last, __pos);
        }
        else {
          //We have to check that the source buffer hasn't move
          if (__first >= __pos) {
            //The source buffer has move
            __first += __n;
            __last += __n;
            _M_copy(__first, __last, __pos);
          }
          else {
            //The source buffer hasn't move, it has been duplicated
            _M_move(__first, __last, __pos);
          }
        }
      }
      else {
        const_iterator __mid = __first;
        __mid += __elems_after + 1;
        ::std::priv:: __ucopy(__mid, __last, this->_M_finish + 1);
        this->_M_finish += __n - __elems_after;
        ::std::priv:: __ucopy(__pos, __old_finish + 1, this->_M_finish);
        this->_M_finish += __elems_after;
        if (!__self_ref)
          _M_copy(__first, __mid, __pos);
        else
          _M_move(__first, __mid, __pos);
      }
    }
    else {
      size_type __len = _M_compute_next_size(__n);
      pointer __new_start = this->_M_start_of_storage.allocate(__len, __len);
      pointer __new_finish = ::std::priv:: __ucopy(this->_M_Start(), __pos, __new_start);
      __new_finish = ::std::priv:: __ucopy(__first, __last, __new_finish);
      __new_finish = ::std::priv:: __ucopy(__pos, this->_M_finish, __new_finish);
      _M_construct_null(__new_finish);
      this->_M_deallocate_block();
      this->_M_reset(__new_start, __new_finish, __new_start + __len);
    }
  }
}

template <class _CharT, class _Traits, class _Alloc>
basic_string<_CharT,_Traits,_Alloc>&
basic_string<_CharT,_Traits,_Alloc> ::replace(iterator __first, iterator __last,
                                              size_type __n, _CharT __c) {
  size_type __len = (size_type)(__last - __first);

  if (__len >= __n) {
    _Traits::assign(__first, __n, __c);
    erase(__first + __n, __last);
  }
  else {
    _Traits::assign(__first, __len, __c);
    insert(__last, __n - __len, __c);
  }
  return *this;
}

template <class _CharT, class _Traits, class _Alloc>
basic_string<_CharT,_Traits,_Alloc>&
basic_string<_CharT,_Traits,_Alloc> ::_M_replace(iterator __first, iterator __last,
                                                 const _CharT* __f, const _CharT* __l,
                                                 bool __self_ref) {
  const ptrdiff_t       __n = __l - __f;
  const difference_type __len = __last - __first;
  if (__len >= __n) {
    if (!__self_ref || __l < __first || __f >= __last)
      _M_copy(__f, __l, __first);
    else
      _M_move(__f, __l, __first);
    erase(__first + __n, __last);
  } else if (!__self_ref || (__f >= __last) || (__l <= __first)) { // no overlap
    const_iterator __m = __f + __len;
    _M_copy(__f, __m, __first);
    _M_insert(__last, __m, __l, __self_ref );
  } else if (__f < __first) { // we have to take care of overlaping
    const_iterator __m = __f + __len;
    // We have to deal with possible reallocation because we do insert first.
    const difference_type __off_dest = __first - this->begin();
    const difference_type __off_src = __f - this->begin();
    _M_insert(__last, __m, __l, true);
    _Traits::move(begin() + __off_dest, begin() + __off_src, __len);
  } else {
    const_iterator __m = __f + __len;
    _Traits::move(__first, __f, __len);
    _M_insert(__last, __m, __l, true);
  }
  return *this;
}

template <class _CharT, class _Traits, class _Alloc>
typename basic_string<_CharT,_Traits,_Alloc> ::size_type basic_string<_CharT,_Traits,_Alloc>::find( const _CharT* __s, size_type __pos,
                                                         size_type __n) const
{
  const size_t __len = size();
  if (__pos >= __len || __pos + __n > __len) {
    if ( __n == 0 && __pos <= __len ) { // marginal case
      return __pos;
    }
    return npos;
  }

  const_pointer __result =
    ::std::search(this->_M_Start() + __pos, this->_M_Finish(),
                      __s, __s + __n, ::std::priv:: _Eq_traits<_Traits>());
  return __result != this->_M_Finish() ? __result - this->_M_Start() : npos;
}

template <class _CharT, class _Traits, class _Alloc>
typename basic_string<_CharT,_Traits,_Alloc> ::size_type basic_string<_CharT,_Traits,_Alloc>::find(_CharT __c, size_type __pos) const
{
  if (__pos >= size()) { /*__pos + 1 > size()*/
    return npos;
  }

  const_pointer __result =
    ::std::find_if(this->_M_Start() + __pos, this->_M_Finish(),
                       ::std::priv:: _Eq_char_bound<_Traits>(__c));
  return __result != this->_M_Finish() ? __result - this->_M_Start() : npos;
}

template <class _CharT, class _Traits, class _Alloc>
typename basic_string<_CharT,_Traits,_Alloc> ::size_type basic_string<_CharT,_Traits,_Alloc>::rfind(const _CharT* __s, size_type __pos,
                                                         size_type __n) const
{
  const size_type __len = size();
  if ( __len < __n ) {
    return npos;
  }
  const_pointer __last = this->_M_Start() + (min)( __len - __n, __pos) + __n;
  if ( __n == 0 ) { // marginal case
    return __last - this->_M_Start();
  }
  const_pointer __result = ::std::find_end(this->_M_Start(), __last,
                                               __s, __s + __n, ::std::priv:: _Eq_traits<_Traits>());
  return __result != __last ? __result - this->_M_Start() : npos;
}

template <class _CharT, class _Traits, class _Alloc>
typename basic_string<_CharT,_Traits,_Alloc> ::size_type basic_string<_CharT,_Traits,_Alloc>::rfind(_CharT __c, size_type __pos) const
{
  const size_type __len = size();
  if ( __len < 1 ) {
    return npos;
  }
  const_iterator __last = begin() + (min)(__len - 1, __pos) + 1;
  const_reverse_iterator __rresult =
    ::std::find_if(const_reverse_iterator(__last), rend(),
                       ::std::priv:: _Eq_char_bound<_Traits>(__c));
  return __rresult != rend() ? (__rresult.base() - 1) - begin() : npos;
}

template <class _CharT, class _Traits, class _Alloc> typename basic_string<_CharT,_Traits,_Alloc> ::size_type
basic_string<_CharT,_Traits,_Alloc> ::find_first_of(const _CharT* __s, size_type __pos,
                                                    size_type __n) const {
  if (__pos >= size()) /*__pos + 1 > size()*/
    return npos;
  else {
    const_iterator __result = ::std::priv:: __str_find_first_of(begin() + __pos, end(),
                                                             __s, __s + __n,
                                                             static_cast<_Traits* >(0));
    return __result != end() ? __result - begin() : npos;
  }
}

template <class _CharT, class _Traits, class _Alloc>
 typename basic_string<_CharT,_Traits,_Alloc> ::size_type
basic_string<_CharT,_Traits,_Alloc> ::find_last_of(const _CharT* __s, size_type __pos,
                                                   size_type __n) const
{
  const size_type __len = size();
  if ( __len < 1 ) {
    return npos;
  }
  const const_iterator __last = begin() + (min)(__len - 1, __pos) + 1;
  const const_reverse_iterator __rresult =
    ::std::priv:: __str_find_first_of(const_reverse_iterator(__last), rend(),
                                   __s, __s + __n,
                                   static_cast<_Traits* >(0));
  return __rresult != rend() ? (__rresult.base() - 1) - begin() : npos;
}


template <class _CharT, class _Traits, class _Alloc> typename basic_string<_CharT,_Traits,_Alloc> ::size_type
basic_string<_CharT,_Traits,_Alloc> ::find_first_not_of(const _CharT* __s, size_type __pos,
                                                        size_type __n) const {
  typedef typename _Traits::char_type _CharType;
  if (__pos >= size()) /*__pos + 1 >= size()*/
    return npos;
  else {
    const_pointer __result = ::std::priv:: __str_find_first_not_of(this->_M_Start() + __pos, this->_M_Finish(),
                                                                static_cast<const _CharType* >(__s),
                                                                static_cast<const _CharType* >(__s) + __n,
                                                                static_cast<_Traits* >(0));
    return __result != this->_M_finish ? __result - this->_M_Start() : npos;
  }
}

template <class _CharT, class _Traits, class _Alloc> typename basic_string<_CharT,_Traits,_Alloc> ::size_type
basic_string<_CharT,_Traits,_Alloc> ::find_first_not_of(_CharT __c, size_type __pos) const {
  if (1 > size())
    return npos;
  else {
    const_pointer __result = ::std::find_if(this->_M_Start() + __pos, this->_M_Finish(),
                                                ::std::priv:: _Neq_char_bound<_Traits>(__c));
    return __result != this->_M_finish ? __result - this->_M_Start() : npos;
  }
}

template <class _CharT, class _Traits, class _Alloc>
typename basic_string<_CharT,_Traits,_Alloc> ::size_type
basic_string<_CharT,_Traits,_Alloc>::find_last_not_of(const _CharT* __s, size_type __pos, size_type __n) const
{
  typedef typename _Traits::char_type _CharType;
  const size_type __len = size();
  if ( __len < 1 ) {
    return npos;
  }
  const_iterator __last = begin() + (min)(__len - 1, __pos) + 1;
  const_reverse_iterator __rlast = const_reverse_iterator(__last);
  const_reverse_iterator __rresult =
    ::std::priv:: __str_find_first_not_of(__rlast, rend(),
                                       static_cast<const _CharType* >(__s),
                                       static_cast<const _CharType* >(__s) + __n,
                                       static_cast<_Traits* >(0));
  return __rresult != rend() ? (__rresult.base() - 1) - begin() : npos;
}

template <class _CharT, class _Traits, class _Alloc>
typename basic_string<_CharT,_Traits,_Alloc> ::size_type
basic_string<_CharT, _Traits, _Alloc>::find_last_not_of(_CharT __c, size_type __pos) const
{
  const size_type __len = size();
  if ( __len < 1 ) {
    return npos;
  }
  const_iterator __last = begin() + (min)(__len - 1, __pos) + 1;
  const_reverse_iterator __rlast = const_reverse_iterator(__last);
  const_reverse_iterator __rresult =
    ::std::find_if(__rlast, rend(),
                       ::std::priv:: _Neq_char_bound<_Traits>(__c));
  return __rresult != rend() ? (__rresult.base() - 1) - begin() : npos;
}

namespace priv {

template <class _CharT, class _Traits, class _Alloc>
void  _S_string_copy(const basic_string<_CharT,_Traits,_Alloc>& __s,
                               _CharT* __buf, size_t __n) {
  if (__n > 0) {
    __n = (min) (__n - 1, __s.size());
    ::std::copy(__s.begin(), __s.begin() + __n, __buf);
    __buf[__n] = _CharT();
  }
}

}

}

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Silicon Graphics makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 */


// A few places in the STL throw range errors, using standard exception
// classes defined in <stdexcept>.  This header file provides functions
// to throw those exception objects.

// _STLP_DONT_THROW_RANGE_ERRORS is a hook so that users can disable
// this exception throwing.

// For the STLport iostreams, only declaration here, definition is in the lib

namespace std {
void    __stl_throw_runtime_error(const char* __msg);
void    __stl_throw_range_error(const char* __msg);
void    __stl_throw_out_of_range(const char* __msg);
void    __stl_throw_length_error(const char* __msg);
void    __stl_throw_invalid_argument(const char* __msg);
void    __stl_throw_overflow_error(const char* __msg);

}



// Local Variables:
// mode:C++
// End:

namespace std {

namespace priv {

// _String_base methods
template <class _Tp, class _Alloc>
void _String_base<_Tp,_Alloc>::_M_throw_length_error() const
{ __stl_throw_length_error("basic_string"); }

template <class _Tp, class _Alloc>
void _String_base<_Tp, _Alloc>::_M_throw_out_of_range() const
{ __stl_throw_out_of_range("basic_string"); }

template <class _Tp, class _Alloc>
void _String_base<_Tp, _Alloc>::_M_allocate_block(size_t __n) {
  if ((__n <= (max_size() + 1)) && (__n > 0)) {
    if (__n > _DEFAULT_SIZE) {
      this->_M_start_of_storage._M_data = _M_start_of_storage.allocate(__n, __n);
      this->_M_finish = this->_M_start_of_storage._M_data;
      this->_M_buffers._M_end_of_storage = this->_M_start_of_storage._M_data + __n;
    }
  } else {
    this->_M_throw_length_error();
  }
}

}


template <class _CharT, class _Traits, class _Alloc>
basic_string<_CharT, _Traits, _Alloc>::basic_string(const _CharT* __s,
                                                    const allocator_type& __a)
  : ::std::priv:: _String_base<_CharT,_Alloc>(__a) {
  
  _M_range_initialize(__s, __s + traits_type::length(__s));
}

template <class _CharT, class _Traits, class _Alloc>
basic_string<_CharT, _Traits, _Alloc>::basic_string(const basic_string<_CharT, _Traits, _Alloc> & __s)
  : ::std::priv:: _String_base<_CharT,_Alloc>(__s.get_allocator())
{ _M_range_initialize(__s._M_Start(), __s._M_Finish()); }


template <class _CharT, class _Traits, class _Alloc>
const size_t basic_string<_CharT, _Traits, _Alloc>::npos;

}



// Local Variables:
// mode:C++
// End:


/*
 * Local Variables:
 * mode:C++
 * End:
 */

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1997-1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1996-1998
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Silicon Graphics makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Hewlett-Packard Company makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 */

/* NOTE: This is an internal header file, included by other STL headers.
 *   You should not attempt to use it directly.
 */



namespace std {

template <class _Key> struct hash { };

namespace priv {

inline size_t __stl_hash_string(const char* __s) {
  
  unsigned long __h = 0;
  for ( ; *__s; ++__s)
    __h = 5*__h + *__s;

  return size_t(__h);
}

}

template< >
struct hash<char*> {
  size_t operator()(const char* __s) const {
    
    return ::std::priv:: __stl_hash_string(__s);
  }
};

template< >
struct hash<const char*> {
  size_t operator()(const char* __s) const {
    
    return ::std::priv:: __stl_hash_string(__s);
  }
};

template< > struct hash<char> {
  size_t operator()(char __x) const { return __x; }
};
template< > struct hash<unsigned char> {
  size_t operator()(unsigned char __x) const { return __x; }
};
template< > struct hash<signed char> {
  size_t operator()(unsigned char __x) const { return __x; }
};
template< > struct hash<short> {
  size_t operator()(short __x) const { return __x; }
};
template< > struct hash<unsigned short> {
  size_t operator()(unsigned short __x) const { return __x; }
};
template< > struct hash<int> {
  size_t operator()(int __x) const { return __x; }
};

template< > struct hash<unsigned int> {
  size_t operator()(unsigned int __x) const { return __x; }
};

template< > struct hash<long> {
  size_t operator()(long __x) const { return __x; }
};
template< > struct hash<unsigned long> {
  size_t operator()(unsigned long __x) const { return __x; }
};

template< > struct hash<long long> {
  size_t operator()(long long x) const { return (size_t)x; }
};
template< > struct hash<unsigned long long> {
  size_t operator()(unsigned long long x) const { return (size_t)x; }
};

template< >
struct hash<void *>
{
    union __vp {
        size_t s;
        void  *p;
    };

    size_t operator()(void *__x) const
      {
        __vp vp;
        vp.p = __x;
        return vp.s;
      }
};

}


// Local Variables:
// mode:C++
// End:


namespace std {

template <class _CharT, class _Traits, class _Alloc>
inline size_t
__stl_string_hash(const basic_string<_CharT,_Traits,_Alloc>& __s) {
  unsigned long __h = 0;
  size_t __len = __s.size();
  const _CharT* __data = __s.data();
  for ( size_t __i = 0; __i < __len; ++__i)
    __h = /* 5 *__h */(__h << 2) + __h + __data[__i];
  return size_t(__h);
}

template <class _CharT, class _Traits, class _Alloc>
struct hash<basic_string<_CharT,_Traits,_Alloc> > {
  size_t operator()(const basic_string<_CharT,_Traits,_Alloc>& __s) const
    { return __stl_string_hash(__s); }
};


}


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1997-1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */



/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */



/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 */

// The header <exception> contains low-level functions that interact
// with a compiler's exception-handling mechanism.  It is assumed to
// be supplied with the compiler, rather than with the library, because
// it is inherently tied very closely to the compiler itself.

// On platforms where <exception> does not exist, this header defines
// an exception base class.  This is *not* a substitute for everything
// in <exception>, but it suffices to support a bare minimum of STL
// functionality.











       /******************************************************************/
       /* Provide a full definition of string on inclusion of stdexcept. */
       /******************************************************************/


namespace std {

/* We disable the 4275 warning for
 *  - WinCE where there are only static version of the native C++ runtime.
 *  - The MSVC compilers when the STLport user wants to make an STLport dll linked to
 *    the static C++ native runtime. In this case the std::exception base class is no more
 *    exported from native dll but is used as a base class for the exported __Named_exception
 *    class.
 */


class  __Named_exception : public exception {
public:
  __Named_exception(const string& __str);
  __Named_exception(const __Named_exception&);
  __Named_exception& operator = (const __Named_exception&);

  const char* what() const ;
  ~__Named_exception() ;

private:
  enum __attribute__((__packed__)) { _S_bufsize = 256 };
  char _M_static_name[_S_bufsize];
  char *_M_name;
};



}




/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */
// WARNING: This is an internal header file, included by other C++
// standard library headers.  You should not attempt to use this header
// file directly.





/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1997-1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

// WARNING: This is an internal header file, included by other C++
// standard library headers.  You should not attempt to use this header
// file directly.



// Supported threading models are native SGI, pthreads, uithreads
// (similar to pthreads, but based on an earlier draft of the Posix
// threads standard), and Win32 threads.  Uithread support by Jochen
// Schlick, 1999, and Solaris threads generalized to them.



// On SUN and Mac OS X gcc, zero-initialization works just fine...

using std::size_t;

/* This header defines the following atomic operation that platform should
 * try to support as much as possible. Atomic operation are exposed as macro
 * in order to easily test for their existance. They are:
 * __stl_atomic_t _STLP_ATOMIC_INCREMENT(volatile __stl_atomic_t* __ptr) :
 * increment *__ptr by 1 and returns the new value
 * __stl_atomic_t _STLP_ATOMIC_DECREMENT(volatile __stl_atomic_t* __ptr) :
 * decrement  *__ptr by 1 and returns the new value
 * __stl_atomic_t _STLP_ATOMIC_EXCHANGE(volatile __stl_atomic_t* __target, __stl_atomic_t __val) :
 * assign __val to *__target and returns former *__target value
 * void* _STLP_ATOMIC_EXCHANGE_PTR(void* volatile* __target, void* __ptr) :
 * assign __ptr to *__target and returns former *__target value
 */

/* no threads */
/* We do not grant other atomic operations as they are useless if STLport do not have
 * to be thread safe
 */
typedef size_t __stl_atomic_t;


namespace std {


// Locking class.  Note that this class *does not have a constructor*.
// It must be initialized either statically, with _STLP_MUTEX_INITIALIZER,
// or dynamically, by explicitly calling the _M_initialize member function.
// (This is similar to the ways that a pthreads mutex can be initialized.)
// There are explicit member functions for acquiring and releasing the lock.

// There is no constructor because static initialization is essential for
// some uses, and only a class aggregate (see section 8.5.1 of the C++
// standard) can be initialized that way.  That means we must have no
// constructors, no base classes, no virtual functions, and no private or
// protected members.

// For non-static cases, clients should use  _STLP_mutex.

struct  _STLP_mutex_base {

  inline void _M_initialize() {}
  inline void _M_destroy() {}
  inline void _M_acquire_lock() {}
  inline void _M_release_lock() {}
};

// Locking class.  The constructor initializes the lock, the destructor destroys it.
// Well - behaving class, does not need static initializer

class  _STLP_mutex : public _STLP_mutex_base {
  public:
    inline _STLP_mutex () { _M_initialize(); }
    inline ~_STLP_mutex () { _M_destroy(); }
  private:
    _STLP_mutex(const _STLP_mutex&);
    void operator=(const _STLP_mutex&);
};

// A locking class that uses _STLP_STATIC_MUTEX.  The constructor takes
// a reference to an _STLP_STATIC_MUTEX, and acquires a lock.  The destructor
// releases the lock.
// It's not clear that this is exactly the right functionality.
// It will probably change in the future.

struct  _STLP_auto_lock {
  _STLP_auto_lock(_STLP_mutex_base& __lock) : _M_lock(__lock)
  { _M_lock._M_acquire_lock(); }
  ~_STLP_auto_lock()
  { _M_lock._M_release_lock(); }

private:
  _STLP_mutex_base& _M_lock;
  void operator=(const _STLP_auto_lock&);
  _STLP_auto_lock(const _STLP_auto_lock&);
};

/*
 * Class _Refcount_Base provides a type, __stl_atomic_t, a data member,
 * _M_ref_count, and member functions _M_incr and _M_decr, which perform
 * atomic preincrement/predecrement.  The constructor initializes
 * _M_ref_count.
 */
class  _Refcount_Base {
  // The data member _M_ref_count
   __stl_atomic_t _M_ref_count;


  public:
  // Constructor
  _Refcount_Base(__stl_atomic_t __n) : _M_ref_count(__n) {}

  // _M_incr and _M_decr
  __stl_atomic_t _M_incr() { return ++_M_ref_count; }
  __stl_atomic_t _M_decr() { return --_M_ref_count; }
};

/* Atomic swap on __stl_atomic_t
 * This is guaranteed to behave as though it were atomic only if all
 * possibly concurrent updates use _Atomic_swap.
 * In some cases the operation is emulated with a lock.
 * Idem for _Atomic_swap_ptr
 */
/* Helper struct to handle following cases:
 * - on platforms where sizeof(__stl_atomic_t) == sizeof(void*) atomic
 *   exchange can be done on pointers
 * - on platform without atomic operation swap is done in a critical section,
 *   portable but inefficient.
 */
template <int __use_ptr_atomic_swap>
class _Atomic_swap_struct {
public:

  static __stl_atomic_t _S_swap( __stl_atomic_t* __p, __stl_atomic_t __q) {
  /* no threads */
  __stl_atomic_t __result = *__p;
  *__p = __q;
  return __result;
  }

  static void* _S_swap_ptr(void* * __p, void* __q) {
  /* no thread */
  void *__result = *__p;
  *__p = __q;
  return __result;
  }
};

template< >
class _Atomic_swap_struct<0> {
public:

  static __stl_atomic_t _S_swap( __stl_atomic_t* __p, __stl_atomic_t __q) {
  /* no threads */
  __stl_atomic_t __result = *__p;
  *__p = __q;
  return __result;
  }

  static void* _S_swap_ptr(void* * __p, void* __q) {
  /* no thread */
  void *__result = *__p;
  *__p = __q;
  return __result;
  }
};


inline __stl_atomic_t  _Atomic_swap( __stl_atomic_t * __p, __stl_atomic_t __q) {
  const int __use_ptr_atomic_swap = sizeof(__stl_atomic_t) == sizeof(void*);
  return _Atomic_swap_struct<__use_ptr_atomic_swap>::_S_swap(__p, __q);
}

inline void*  _Atomic_swap_ptr(void* * __p, void* __q) {
  const int __use_ptr_atomic_swap = sizeof(__stl_atomic_t) == sizeof(void*);
  return _Atomic_swap_struct<__use_ptr_atomic_swap>::_S_swap_ptr(__p, __q);
}



}

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 *
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */




namespace std {




}


// Local Variables:
// mode:C++
// End:


// Local Variables:
// mode:C++
// End:



/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/




namespace std {

template <class _CharT, class _InputIter = istreambuf_iterator<_CharT, char_traits<_CharT> > >
class money_get;

template <class _CharT, class _OutputIter = ostreambuf_iterator<_CharT, char_traits<_CharT> > >
class money_put;

template <class _CharT, class _InputIter = istreambuf_iterator<_CharT, char_traits<_CharT> > >
class num_get;

template <class _CharT, class _OutputIter = ostreambuf_iterator<_CharT, char_traits<_CharT> > >
class num_put;

template <class _Ch, class _InIt = istreambuf_iterator<_Ch, char_traits<_Ch> > >
class time_get;

template <class _Ch, class _OutIt = ostreambuf_iterator<_Ch, char_traits<_Ch> > >
class time_put;

}


namespace std {

class _Locale_impl;        // Forward declaration of opaque type.
class locale;

template <class _CharT, class _Traits, class _Alloc>
bool __locale_do_operator_call(const locale& __loc,
                               const basic_string<_CharT, _Traits, _Alloc>& __x,
                               const basic_string<_CharT, _Traits, _Alloc>& __y);

 _Locale_impl *  _get_Locale_impl( _Locale_impl *locimpl );
 _Locale_impl *  _copy_Nameless_Locale_impl( _Locale_impl *locimpl );

namespace priv {

template <class _Facet>
bool _HasFacet(const locale& __loc, const _Facet* __facet) ;

template <class _Facet>
_Facet* _UseFacet(const locale& __loc, const _Facet* __facet);

template <class _Facet>
void _InsertFacet(locale& __loc, _Facet* __facet);

}


class  locale {
public:
  // types:
  class  facet : protected _Refcount_Base {
  protected:
    /* Here we filter __init_count user value to 0 or 1 because __init_count is a
     * size_t instance and _Refcount_Base use __stl_atomic_t instances that might
     * have lower sizeof and generate roll issues. 1 is enough to keep the facet
     * alive when required. */
    explicit facet(size_t __init_count = 0) : _Refcount_Base( __init_count == 0 ? 0 : 1 ) {}
    virtual ~facet();
    friend class locale;
    friend class _Locale_impl;
    friend facet *  _get_facet( facet * );
    friend void  _release_facet( facet *& );

  private:                        // Invalidate assignment and copying.
    facet(const facet& ) /* : _Refcount_Base(1) {} */;
    void operator=(const facet&);
  };

  class
   id {
  public:
    size_t _M_index;
    static size_t _S_max;
  };

  typedef int category;
  static const  category none = 0x000;
  static const  category collate = 0x010;
  static const  category ctype = 0x020;
  static const  category monetary = 0x040;
  static const  category numeric = 0x100;
  static const  category time = 0x200;
  static const  category messages = 0x400;
  static const  category all = collate | ctype | monetary | numeric | time | messages;

  // construct/copy/destroy:
  locale() ;
  locale(const locale&) ;
  explicit locale(const char *);
  locale(const locale&, const char*, category);

  template <class _Facet>
  locale(const locale& __loc, _Facet* __f) {
    if ( __f != 0 ) {
      this->_M_impl = _get_Locale_impl( _copy_Nameless_Locale_impl( __loc._M_impl ) );
      ::std::priv:: _InsertFacet(*this, __f);
    } else {
      this->_M_impl = _get_Locale_impl( __loc._M_impl );
    }
  }

protected:
  // those are for internal use
  locale(_Locale_impl*);

public:
  locale(const locale&, const locale&, category);
  const locale& operator=(const locale&) ;

   ~locale() ;

public:
  template <class _Facet>
  locale combine(const locale& __loc) const {
    _Facet *__facet = 0;
    if (! ::std::priv:: _HasFacet(__loc, __facet))
      _M_throw_on_combine_error(__loc.name());

    return locale(*this, ::std::priv:: _UseFacet(__loc, __facet));
  }

  // locale operations:
  string name() const;

  bool operator==(const locale&) const;
  bool operator!=(const locale&) const;

  template <class _CharT, class _Traits, class _Alloc>
  bool operator()(const basic_string<_CharT, _Traits, _Alloc>& __x,
                  const basic_string<_CharT, _Traits, _Alloc>& __y) const
  { return __locale_do_operator_call(*this, __x, __y); }

  // global locale objects:
  static locale  global(const locale&);
  static const locale&  classic();

//protected:                         // Helper functions for locale globals.
  facet* _M_get_facet(const id&) const;
  // same, but throws
  facet* _M_use_facet(const id&) const;
  static void   _M_throw_on_combine_error(const string& name);
  static void   _M_throw_on_null_name();
  static void   _M_throw_on_creation_failure(int __err_code,
                                                                            const char* name, const char* facet);

//protected:                        // More helper functions.
  void _M_insert(facet* __f, id& __id);

  // friends:
  friend class _Locale_impl;

protected:                        // Data members
  _Locale_impl* _M_impl;
  _Locale_impl* _M_get_impl() const { return _M_impl; }
};


//----------------------------------------------------------------------
// locale globals

template <class _Facet>
inline const _Facet&
use_facet(const locale& __loc)
{
  _Facet *__facet = 0;
  return *(::std::priv:: _UseFacet(__loc, __facet));
}

template <class _Facet>
inline bool has_facet(const locale& __loc) 
{
  _Facet *__facet = 0;
  return ::std::priv:: _HasFacet(__loc, __facet);
}


namespace priv {

/* _GetFacetId is a helper function that allow delaying access to
 * facet id static instance in the library source code to avoid
 * the other static instances that many compilers are generating
 * in all dynamic library or executable when instanciating facet
 * template class.
 */
template <class _Facet>
inline locale::id& _GetFacetId(const _Facet*)
{ return _Facet::id; }

 locale::id&  _GetFacetId(const money_get<char, istreambuf_iterator<char, char_traits<char> > >*);
 locale::id&  _GetFacetId(const money_put<char, ostreambuf_iterator<char, char_traits<char> > >*);
 locale::id&  _GetFacetId(const num_get<char, istreambuf_iterator<char, char_traits<char> > >*);
 locale::id&  _GetFacetId(const num_put<char, ostreambuf_iterator<char, char_traits<char> > >*);
 locale::id&  _GetFacetId(const time_get<char, istreambuf_iterator<char, char_traits<char> > >*);
 locale::id&  _GetFacetId(const time_put<char, ostreambuf_iterator<char, char_traits<char> > >*);

 locale::id&  _GetFacetId(const money_get<wchar_t, istreambuf_iterator<wchar_t, char_traits<wchar_t> > >*);
 locale::id&  _GetFacetId(const money_put<wchar_t, ostreambuf_iterator<wchar_t, char_traits<wchar_t> > >*);
 locale::id&  _GetFacetId(const num_get<wchar_t, istreambuf_iterator<wchar_t, char_traits<wchar_t> > >*);
 locale::id&  _GetFacetId(const num_put<wchar_t, ostreambuf_iterator<wchar_t, char_traits<wchar_t> > >*);
 locale::id&  _GetFacetId(const time_get<wchar_t, istreambuf_iterator<wchar_t, char_traits<wchar_t> > >*);
 locale::id&  _GetFacetId(const time_put<wchar_t, ostreambuf_iterator<wchar_t, char_traits<wchar_t> > >*);

template <class _Facet>
inline bool _HasFacet(const locale& __loc, const _Facet* __facet) 
{ return (__loc._M_get_facet(_GetFacetId(__facet)) != 0); }

template <class _Facet>
inline _Facet* _UseFacet(const locale& __loc, const _Facet* __facet)
{ return static_cast<_Facet* >(__loc . _M_use_facet(_GetFacetId(__facet))); }

template <class _Facet>
inline void _InsertFacet(locale& __loc, _Facet* __facet)
{ __loc._M_insert(__facet, _GetFacetId(__facet)); }

}

}


// Local Variables:
// mode:C++
// End:



namespace std {

// ----------------------------------------------------------------------

// Class ios_base.  This is the base class of the ios hierarchy, which
// includes basic_istream and basic_ostream.  Classes in the ios
// hierarchy are actually quite simple: they are just glorified
// wrapper classes.  They delegate buffering and physical character
// manipulation to the streambuf classes, and they delegate most
// formatting tasks to a locale.

class  ios_base {
public:

  class  failure : public __Named_exception {
  public:
    explicit failure(const string&);
    virtual ~failure() ;
  };

  typedef int fmtflags;
  typedef int iostate;
  typedef int openmode;
  typedef int seekdir;

  typedef fmtflags fmt_flags;

  // Formatting flags.
  static const  int left = 0x0001;
  static const  int right = 0x0002;
  static const  int internal = 0x0004;
  static const  int dec = 0x0008;
  static const  int hex = 0x0010;
  static const  int oct = 0x0020;
  static const  int fixed = 0x0040;
  static const  int scientific = 0x0080;
  static const  int boolalpha = 0x0100;
  static const  int showbase = 0x0200;
  static const  int showpoint = 0x0400;
  static const  int showpos = 0x0800;
  static const  int skipws = 0x1000;
  static const  int unitbuf = 0x2000;
  static const  int uppercase = 0x4000;
  static const  int adjustfield = left | right | internal;
  static const  int basefield = dec | hex | oct;
  static const  int floatfield = scientific | fixed;

  // State flags.
  static const  int goodbit = 0x00;
  static const  int badbit = 0x01;
  static const  int eofbit = 0x02;
  static const  int failbit = 0x04;

  // Openmode flags.
  static const  int __default_mode = 0x0; /* implementation detail */
  static const  int app = 0x01;
  static const  int ate = 0x02;
  static const  int binary = 0x04;
  static const  int in = 0x08;
  static const  int out = 0x10;
  static const  int trunc = 0x20;

  // Seekdir flags
  static const  int beg = 0x01;
  static const  int cur = 0x02;
  static const  int end = 0x04;

public:                         // Flag-manipulation functions.
  fmtflags flags() const { return _M_fmtflags; }
  fmtflags flags(fmtflags __flags) {
    fmtflags __tmp = _M_fmtflags;
    _M_fmtflags = __flags;
    return __tmp;
  }

  fmtflags setf(fmtflags __flag) {
    fmtflags __tmp = _M_fmtflags;
    _M_fmtflags |= __flag;
    return __tmp;
  }
  fmtflags setf(fmtflags __flag, fmtflags __mask) {
    fmtflags __tmp = _M_fmtflags;
    _M_fmtflags &= ~__mask;
    _M_fmtflags |= __flag & __mask;
    return __tmp;
  }
  void unsetf(fmtflags __mask) { _M_fmtflags &= ~__mask; }

  streamsize precision() const { return _M_precision; }
  streamsize precision(streamsize __newprecision) {
    streamsize __tmp = _M_precision;
    _M_precision = __newprecision;
    return __tmp;
  }

  streamsize width() const { return _M_width; }
  streamsize width(streamsize __newwidth) {
    streamsize __tmp = _M_width;
    _M_width = __newwidth;
    return __tmp;
  }

public:                         // Locales
  locale imbue(const locale&);
  locale getloc() const { return _M_locale; }

public:                         // Auxiliary storage.
  static int  xalloc();
  long&  iword(int __index);
  void*& pword(int __index);

public:                         // Destructor.
  virtual ~ios_base();

public:                         // Callbacks.
  enum __attribute__((__packed__)) event { erase_event, imbue_event, copyfmt_event };
  typedef void (*event_callback)(event, ios_base&, int __index);
  void register_callback(event_callback __fn, int __index);

public:                         // This member function affects only
                                // the eight predefined ios objects:
                                // cin, cout, etc.
  static bool  sync_with_stdio(bool __sync = true);

public:                         // The C++ standard requires only that these
                                // member functions be defined in basic_ios.
                                // We define them in the non-template
                                // base class to avoid code duplication.
  operator void*() const { return !fail() ? (void*) const_cast<ios_base* >(this) : (void*) 0; }
  bool operator!() const { return fail(); }

  iostate rdstate() const { return _M_iostate; }

  bool good() const { return _M_iostate == 0; }
  bool eof() const { return (_M_iostate & eofbit) != 0; }
  bool fail() const { return (_M_iostate & (failbit | badbit)) != 0; }
  bool bad() const { return (_M_iostate & badbit) != 0; }

public:                         // Special init types for cin/cout/cerr/clog
  enum __attribute__((__packed__)) _SpecialInitType { _NoInit };


protected:                      // The functional protected interface.

  // Copies the state of __x to *this.  This member function makes it
  // possible to implement basic_ios::copyfmt without having to expose
  // ios_base's private data members.  Does not copy _M_exception_mask
  // or _M_iostate.
  void _M_copy_state(const ios_base& __x);

  void _M_setstate_nothrow(iostate __state) { _M_iostate |= __state; }
  void _M_clear_nothrow(iostate __state) { _M_iostate = __state; }
  iostate _M_get_exception_mask() const { return _M_exception_mask; }
  void _M_set_exception_mask(iostate __mask) { _M_exception_mask = __mask; }
  void _M_check_exception_mask() {
    if (_M_iostate & _M_exception_mask)
      _M_throw_failure();
  }

  void _M_invoke_callbacks(event);
  void  _M_throw_failure();

  ios_base();                   // Default constructor.
  ios_base(_SpecialInitType __i) { /* Do nothing */ }

protected:                        // Initialization of the I/O system
  static void  _S_initialize();
  static void  _S_uninitialize();
  static  bool _S_is_synced;

private:                        // Invalidate the copy constructor and
                                // assignment operator.
  ios_base(const ios_base&);
  void operator=(const ios_base&);

private:                        // Data members.

  fmtflags _M_fmtflags;         // Flags
  iostate _M_iostate;
  openmode _M_openmode;
  seekdir _M_seekdir;
  iostate _M_exception_mask;

  streamsize _M_precision;
  streamsize _M_width;

  locale _M_locale;

  pair<event_callback, int>* _M_callbacks;
  size_t _M_num_callbacks;      // Size of the callback array.
  size_t _M_callback_index;     // Index of the next available callback;
                                // initially zero.

  long* _M_iwords;              // Auxiliary storage.  The count is zero
  size_t _M_num_iwords;         // if and only if the pointer is null.

  void** _M_pwords;
  size_t _M_num_pwords;

public:
  // ----------------------------------------------------------------------
  // Nested initializer class.  This is an implementation detail, but it's
  // prescribed by the standard.  The static initializer object (on
  // implementations where such a thing is required) is declared in
  // <iostream>
  class  Init
  {
    public:
      Init();
      ~Init();
    private:
      static  long _S_count;
      friend class ios_base;
  };

  friend class Init;

public:
  //  31.6  Old iostreams members                         [depr.ios.members]
  typedef iostate  io_state;
  typedef openmode open_mode;
  typedef seekdir  seek_dir;
  typedef ::std::streamoff  streamoff;
  typedef ::std::streampos  streampos;
};

// ----------------------------------------------------------------------
// ios_base manipulator functions, from section 27.4.5 of the C++ standard.
// All of them are trivial one-line wrapper functions.

// fmtflag manipulators, section 27.4.5.1
inline ios_base&  boolalpha(ios_base& __s)
  { __s.setf(ios_base::boolalpha); return __s;}

inline ios_base&  noboolalpha(ios_base& __s)
  { __s.unsetf(ios_base::boolalpha); return __s;}

inline ios_base&  showbase(ios_base& __s)
  { __s.setf(ios_base::showbase); return __s;}

inline ios_base&  noshowbase(ios_base& __s)
  { __s.unsetf(ios_base::showbase); return __s;}

inline ios_base&  showpoint(ios_base& __s)
  { __s.setf(ios_base::showpoint); return __s;}

inline ios_base&  noshowpoint(ios_base& __s)
  { __s.unsetf(ios_base::showpoint); return __s;}

inline ios_base&  showpos(ios_base& __s)
  { __s.setf(ios_base::showpos); return __s;}

inline ios_base&  noshowpos(ios_base& __s)
  { __s.unsetf(ios_base::showpos); return __s;}

inline ios_base&  skipws(ios_base& __s)
  { __s.setf(ios_base::skipws); return __s;}

inline ios_base&  noskipws(ios_base& __s)
  { __s.unsetf(ios_base::skipws); return __s;}

inline ios_base&  uppercase(ios_base& __s)
  { __s.setf(ios_base::uppercase); return __s;}

inline ios_base&  nouppercase(ios_base& __s)
  { __s.unsetf(ios_base::uppercase); return __s;}

inline ios_base&  unitbuf(ios_base& __s)
  { __s.setf(ios_base::unitbuf); return __s;}

inline ios_base&  nounitbuf(ios_base& __s)
  { __s.unsetf(ios_base::unitbuf); return __s;}


// adjustfield manipulators, section 27.4.5.2
inline ios_base&  internal(ios_base& __s)
  { __s.setf(ios_base::internal, ios_base::adjustfield); return __s; }

inline ios_base&  left(ios_base& __s)
  { __s.setf(ios_base::left, ios_base::adjustfield); return __s; }

inline ios_base&  right(ios_base& __s)
  { __s.setf(ios_base::right, ios_base::adjustfield); return __s; }

// basefield manipulators, section 27.4.5.3
inline ios_base&  dec(ios_base& __s)
  { __s.setf(ios_base::dec, ios_base::basefield); return __s; }

inline ios_base&  hex(ios_base& __s)
  { __s.setf(ios_base::hex, ios_base::basefield); return __s; }

inline ios_base&  oct(ios_base& __s)
  { __s.setf(ios_base::oct, ios_base::basefield); return __s; }


// floatfield manipulators, section 27.4.5.3
inline ios_base&  fixed(ios_base& __s)
  { __s.setf(ios_base::fixed, ios_base::floatfield); return __s; }

inline ios_base&  scientific(ios_base& __s)
  { __s.setf(ios_base::scientific, ios_base::floatfield); return __s; }

}


// Local Variables:
// mode:C++
// End:


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */
// WARNING: This is an internal header file, included by other C++
// standard library headers.  You should not attempt to use this header
// file directly.


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


/*
 * Implementation dependent definitions.
 * Beware: This header is not a purely internal header, it is also included
 * from the outside world when building the STLport library. So this header
 * should not reference internal headers (stlport/stl/_*.h) directly.
 */

/*
 * GENERAL FRAMEWORK
 */

/*
 * Opaque types, implementation (if there is one) depends
 * on platform localisation API.
 */
struct _Locale_ctype;
struct _Locale_codecvt;
struct _Locale_numeric;
struct _Locale_time;
struct _Locale_collate;
struct _Locale_monetary;
struct _Locale_messages;

/*
  Bitmask macros.
*/

/*
 * For narrow characters, we expose the lookup table interface.
 */

/* Default values based on C++ Standard 22.2.1.
 * Under Windows the localisation implementation take care of mapping its
 * mask values to those internal values. For other platforms without real
 * localization support we are free to use the most suitable values.*/




namespace std {

class  ctype_base {
public:
  enum __attribute__((__packed__)) mask {
    space   = 0x0001,
    print   = 0x0002,
    cntrl   = 0x0004,
    upper   = 0x0008,
    lower   = 0x0010,
    alpha   = 0x0020,
    digit   = 0x0040,
    punct   = 0x0080,
    xdigit  = 0x0100,
    alnum   = alpha | digit,
    graph   = alnum | punct
  };
};

// ctype<> template

template <class charT> class ctype {};
template <class charT> class ctype_byname {};

//ctype specializations

template< >
class  ctype<char> : public locale::facet, public ctype_base {
    friend class ctype<wchar_t>;
public:

  typedef char char_type;

  explicit ctype(const mask* __tab = 0, bool __del = false, size_t __refs = 0);
  bool is(mask __m, char __c) const
  { return ((*(_M_ctype_table+(unsigned char)__c)) & __m) != 0; }

  const char* is(const char* __low, const char* __high, mask* __vec) const {
    for (const char* __p = __low;__p != __high; ++__p, ++__vec) {
      *__vec = _M_ctype_table[(unsigned char)*__p];
    }
    return __high;
  }

  const char* scan_is(mask __m, const char* __low, const char* __high) const;
  const char* scan_not(mask __m, const char* __low, const char* __high) const;

  char        (toupper)(char __c) const { return do_toupper(__c); }
  const char* (toupper)(char* __low, const char* __high) const {
    return do_toupper(__low, __high);
  }

  char        (tolower)(char __c) const { return do_tolower(__c); }
  const char* (tolower)(char* __low, const char* __high) const {
    return do_tolower(__low, __high);
  }

  char        widen(char __c) const { return do_widen(__c); }
  const char* widen(const char* __low, const char* __high, char* __to) const {
    return do_widen(__low, __high, __to);
  }

  char        narrow(char __c, char __dfault) const {
    return do_narrow(__c, __dfault);
  }
  const char* narrow(const char* __low, const char* __high,
                     char __dfault, char* __to) const {
    return do_narrow(__low, __high, __dfault, __to);
  }

  static   locale::id id;
  static const  size_t table_size = 256;

protected:
  const mask* table() const  { return _M_ctype_table; }
  static const mask*  classic_table() ;

  ~ctype();

  virtual char        do_toupper(char __c) const;
  virtual char        do_tolower(char __c) const;
  virtual const char* do_toupper(char* __low, const char* __high) const;
  virtual const char* do_tolower(char* __low, const char* __high) const;
  virtual char        do_widen(char __c) const;
  virtual const char* do_widen(const char* __low, const char* __high,
                               char* __to) const;
  virtual char        do_narrow(char __c, char /* dfault */ ) const;
  virtual const char* do_narrow(const char* __low, const char* __high,
                                char /* dfault */, char* __to) const;
private:
  struct _Is_mask {
    mask __m;
    _Is_mask(mask __x): __m(__x) {}
   bool operator()(char __c) {return (__m & (unsigned char) __c) != 0;}
  };

protected:
  const mask* _M_ctype_table;
private:
  bool _M_delete;
};

template< >
class  ctype_byname<char>: public ctype<char> {
  friend class _Locale_impl;
public:
  explicit ctype_byname(const char*, size_t = 0);

protected:
/*****************************************************************************/
/* 22.2.1.4 of the C++ 98 standard declares ~ctype_byname as protected.      */
/*****************************************************************************/
  ~ctype_byname();

public:
  virtual char        do_toupper(char __c) const;
  virtual char        do_tolower(char __c) const;

  virtual const char* do_toupper(char*, const char*) const;
  virtual const char* do_tolower(char*, const char*) const;

private:
  ctype_byname(_Locale_ctype* __ctype)
    : _M_ctype(__ctype)
  { _M_init(); }

  void _M_init();

  //explicitely defined as private to avoid warnings:
  typedef ctype_byname<char> _Self;
  ctype_byname(_Self const&);
  _Self& operator = (_Self const&);

  mask _M_byname_table[table_size];
  _Locale_ctype* _M_ctype;
};

template< >
class  ctype<wchar_t> : public locale::facet, public ctype_base {
public:
  typedef wchar_t char_type;

  explicit ctype(size_t __refs = 0) : locale::facet(__refs) {}

  bool is(mask __m, wchar_t __c) const
    { return do_is(__m, __c); }

  const wchar_t* is(const wchar_t* __low, const wchar_t* __high,
                    mask* __vec) const
    { return do_is(__low, __high, __vec); }

  const wchar_t* scan_is(mask __m,
                         const wchar_t* __low, const wchar_t* __high) const
    { return do_scan_is(__m, __low, __high); }

  const wchar_t* scan_not (mask __m,
                           const wchar_t* __low, const wchar_t* __high) const
    { return do_scan_not(__m, __low, __high); }

  wchar_t (toupper)(wchar_t __c) const { return do_toupper(__c); }
  const wchar_t* (toupper)(wchar_t* __low, const wchar_t* __high) const
    { return do_toupper(__low, __high); }

  wchar_t (tolower)(wchar_t __c) const { return do_tolower(__c); }
  const wchar_t* (tolower)(wchar_t* __low, const wchar_t* __high) const
    { return do_tolower(__low, __high); }

  wchar_t widen(char __c) const { return do_widen(__c); }
  const char* widen(const char* __low, const char* __high,
                    wchar_t* __to) const
    { return do_widen(__low, __high, __to); }

  char narrow(wchar_t __c, char __dfault) const
    { return do_narrow(__c, __dfault); }
  const wchar_t* narrow(const wchar_t* __low, const wchar_t* __high,
                        char __dfault, char* __to) const
    { return do_narrow(__low, __high, __dfault, __to); }

  static   locale::id id;

protected:
  ~ctype();

  virtual bool           do_is(mask __m, wchar_t __c) const;
  virtual const wchar_t* do_is(const wchar_t*, const wchar_t*, mask*) const;
  virtual const wchar_t* do_scan_is(mask,
                                    const wchar_t*, const wchar_t*) const;
  virtual const wchar_t* do_scan_not(mask,
                                     const wchar_t*, const wchar_t*) const;
  virtual wchar_t do_toupper(wchar_t __c) const;
  virtual const wchar_t* do_toupper(wchar_t*, const wchar_t*) const;
  virtual wchar_t do_tolower(wchar_t c) const;
  virtual const wchar_t* do_tolower(wchar_t*, const wchar_t*) const;
  virtual wchar_t do_widen(char c) const;
  virtual const char* do_widen(const char*, const char*, wchar_t*) const;
  virtual char  do_narrow(wchar_t __c, char __dfault) const;
  virtual const wchar_t* do_narrow(const wchar_t*, const wchar_t*,
                                   char, char*) const;
};

template< >
class  ctype_byname<wchar_t>: public ctype<wchar_t> {
  friend class _Locale_impl;
public:
  explicit ctype_byname(const char* __name, size_t __refs = 0);

protected:
  ~ctype_byname();

  virtual bool           do_is(mask __m, wchar_t __c) const;
  virtual const wchar_t* do_is(const wchar_t*, const wchar_t*, mask*) const;
  virtual const wchar_t* do_scan_is(mask,
                                    const wchar_t*, const wchar_t*) const;
  virtual const wchar_t* do_scan_not(mask,
                                     const wchar_t*, const wchar_t*) const;
  virtual wchar_t do_toupper(wchar_t __c) const;
  virtual const wchar_t* do_toupper(wchar_t*, const wchar_t*) const;
  virtual wchar_t do_tolower(wchar_t c) const;
  virtual const wchar_t* do_tolower(wchar_t*, const wchar_t*) const;

private:
  ctype_byname(_Locale_ctype* __ctype)
    : _M_ctype(__ctype) {}

  //explicitely defined as private to avoid warnings:
  typedef ctype_byname<wchar_t> _Self;
  ctype_byname(_Self const&);
  _Self& operator = (_Self const&);

  _Locale_ctype* _M_ctype;
};


}


// Local Variables:
// mode:C++
// End:


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */
// WARNING: This is an internal header file, included by other C++
// standard library headers.  You should not attempt to use this header
// file directly.






namespace std {

//----------------------------------------------------------------------
// numpunct facets

template <class _CharT> class numpunct {};
template <class _CharT> class numpunct_byname {};
template <class _Ch, class _InIt> class num_get;

template< >
class  numpunct<char> : public locale::facet {
public:
  typedef char               char_type;
  typedef string             string_type;

  explicit numpunct(size_t __refs = 0)
    : locale::facet(__refs) {}

  char decimal_point() const { return do_decimal_point(); }
  char thousands_sep() const { return do_thousands_sep(); }
  string grouping() const { return do_grouping(); }
  string truename() const { return do_truename(); }
  string falsename() const { return do_falsename(); }

  static   locale::id id;

protected:
  ~numpunct();

  virtual char do_decimal_point() const;
  virtual char do_thousands_sep() const;
  virtual string do_grouping() const;
  virtual string do_truename() const;
  virtual string do_falsename()  const;
};


template< >
class  numpunct<wchar_t> : public locale::facet {
public:
  typedef wchar_t               char_type;
  typedef wstring               string_type;

  explicit numpunct(size_t __refs = 0)
    : locale::facet(__refs) {}

  wchar_t decimal_point() const { return do_decimal_point(); }
  wchar_t thousands_sep() const { return do_thousands_sep(); }
  string grouping() const { return do_grouping(); }
  wstring truename() const { return do_truename(); }
  wstring falsename() const { return do_falsename(); }

  static   locale::id id;

protected:
  ~numpunct();

  virtual wchar_t do_decimal_point() const;
  virtual wchar_t do_thousands_sep() const;
  virtual string do_grouping() const;
  virtual wstring do_truename() const;
  virtual wstring do_falsename()  const;
};


template< >
class  numpunct_byname<char> : public numpunct<char> {
  friend class _Locale_impl;
public:
  typedef char                char_type;
  typedef string              string_type;

  explicit numpunct_byname(const char* __name, size_t __refs = 0);

protected:

  ~numpunct_byname();

  virtual char   do_decimal_point() const;
  virtual char   do_thousands_sep() const;
  virtual string do_grouping()      const;
  virtual string do_truename()      const;
  virtual string do_falsename()     const;

private:
  numpunct_byname(_Locale_numeric *__numeric)
    : _M_numeric(__numeric) {}

  //explicitely defined as private to avoid warnings:
  typedef numpunct_byname<char> _Self;
  numpunct_byname(_Self const&);
  _Self& operator = (_Self const&);

  _Locale_numeric* _M_numeric;
};

template< >
class  numpunct_byname<wchar_t>: public numpunct<wchar_t> {
  friend class _Locale_impl;
public:
  typedef wchar_t               char_type;
  typedef wstring               string_type;

  explicit numpunct_byname(const char* __name, size_t __refs = 0);

protected:
  ~numpunct_byname();

  virtual wchar_t   do_decimal_point() const;
  virtual wchar_t   do_thousands_sep() const;
  virtual string do_grouping() const;
  virtual wstring do_truename() const;
  virtual wstring do_falsename() const;

private:
  numpunct_byname(_Locale_numeric *__numeric)
    : _M_numeric(__numeric) {}

  //explicitely defined as private to avoid warnings:
  typedef numpunct_byname<wchar_t> _Self;
  numpunct_byname(_Self const&);
  _Self& operator = (_Self const&);

  _Locale_numeric* _M_numeric;
};


}


// Local Variables:
// mode:C++
// End:


namespace std {

// ----------------------------------------------------------------------

// Class basic_ios, a subclass of ios_base.  The only important difference
// between the two is that basic_ios is a class template, parameterized
// by the character type.  ios_base exists to factor out all of the
// common properties that don't depend on the character type.

// The second template parameter, _Traits, defaults to char_traits<_CharT>.
// The default is declared in header <iosfwd>, and it isn't declared here
// because C++ language rules do not allow it to be declared twice.

template <class _CharT, class _Traits>
class basic_ios : public ios_base {
  friend class ios_base;
public:                         // Synonyms for types.
  typedef _CharT                     char_type;
  typedef typename _Traits::int_type int_type;
  typedef typename _Traits::pos_type pos_type;
  typedef typename _Traits::off_type off_type;
  typedef _Traits                    traits_type;

public:                         // Constructor, destructor.
  explicit basic_ios(basic_streambuf<_CharT, _Traits>* __streambuf);
  explicit basic_ios(ios_base::_SpecialInitType __i) :
    ios_base(__i) { /* Do nothing */ };
  virtual ~basic_ios() {}

public:                         // Members from clause 27.4.4.2
  basic_ostream<_CharT, _Traits>* tie() const {
    return _M_tied_ostream;
  }
  basic_ostream<_CharT, _Traits>*
  tie(basic_ostream<char_type, traits_type>* __new_tied_ostream) {
    basic_ostream<char_type, traits_type>* __tmp = _M_tied_ostream;
    _M_tied_ostream = __new_tied_ostream;
    return __tmp;
  }

  basic_streambuf<_CharT, _Traits>* rdbuf() const
    { return _M_streambuf; }

  basic_streambuf<_CharT, _Traits>*
  rdbuf(basic_streambuf<char_type, traits_type>*);

  // Copies __x's state to *this.
  basic_ios<_CharT, _Traits>& copyfmt(const basic_ios<_CharT, _Traits>& __x);

  char_type fill() const { return _M_fill; }
  char_type fill(char_type __fill) {
    char_type __tmp(_M_fill);
    _M_fill = __fill;
    return __tmp;
  }

public:                         // Members from 27.4.4.3.  These four functions
                                // can almost be defined in ios_base.

  void clear(iostate __state = goodbit) {
    _M_clear_nothrow(this->rdbuf() ? __state : iostate(__state|ios_base::badbit));
    _M_check_exception_mask();
  }
  void setstate(iostate __state) { this->clear(rdstate() | __state); }

  iostate exceptions() const { return this->_M_get_exception_mask(); }
  void exceptions(iostate __mask) {
    this->_M_set_exception_mask(__mask);
    this->clear(this->rdstate());
  }

public:                         // Locale-related member functions.
  locale imbue(const locale&);

  inline char narrow(_CharT, char) const ;
  inline _CharT widen(char) const;

  // Helper function that makes testing for EOF more convenient.
  static bool  _S_eof(int_type __c) {
    const int_type __eof = _Traits::eof();
    return _Traits::eq_int_type(__c, __eof);
  }

protected:
  // Cached copy of the curent locale's ctype facet.  Set by init() and imbue().
  const ctype<char_type>* _M_cached_ctype;

public:
  // Equivalent to &use_facet< Facet >(getloc()), but faster.
  const ctype<char_type>* _M_ctype_facet() const { return _M_cached_ctype; }

protected:
  basic_ios();

  void init(basic_streambuf<_CharT, _Traits>* __streambuf);

public:

  // Helper function used in istream and ostream.  It is called only from
  // a catch clause.
  void _M_handle_exception(ios_base::iostate __flag);

private:                        // Data members
  char_type _M_fill;            // The fill character, used for padding.

  basic_streambuf<_CharT, _Traits>* _M_streambuf;
  basic_ostream<_CharT, _Traits>*   _M_tied_ostream;

};


template <class _CharT, class _Traits>
inline char
basic_ios<_CharT, _Traits>::narrow(_CharT __c, char __default) const
{ return _M_ctype_facet()->narrow(__c, __default); }

template <class _CharT, class _Traits>
inline _CharT
basic_ios<_CharT, _Traits>::widen(char __c) const
{ return _M_ctype_facet()->widen(__c); }

template< >
inline char
basic_ios<char, char_traits<char> >::narrow(char __c, char) const
{
  return __c;
}

template< >
inline char
basic_ios<char, char_traits<char> >::widen(char __c) const
{
  return __c;
}


}

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


namespace std {

//----------------------------------------------------------------------
// Class basic_streambuf<>, the base class of the streambuf hierarchy.

// A basic_streambuf<> manages an input (get) area and an output (put)
// area.  Each is described by three pointers: a beginning, an end, and a
// current position.  basic_streambuf<> contains some very simple member
// functions that manipulate those six pointers, but almost all of the real
// functionality gets delegated to protected virtual member functions.
// All of the public member functions are inline, and most of the protected
// member functions are virtual.

// Although basic_streambuf<> is not abstract, it is useful only as a base
// class.  Its virtual member functions have default definitions such that
// reading from a basic_streambuf<> will always yield EOF, and writing to a
// basic_streambuf<> will always fail.

// The second template parameter, _Traits, defaults to char_traits<_CharT>.
// The default is declared in header <iosfwd>, and it isn't declared here
// because C++ language rules do not allow it to be declared twice.

template <class _CharT, class _Traits>
class basic_streambuf {
  friend class basic_istream<_CharT, _Traits>;
  friend class basic_ostream<_CharT, _Traits>;

public:                         // Typedefs.
  typedef _CharT                     char_type;
  typedef typename _Traits::int_type int_type;
  typedef typename _Traits::pos_type pos_type;
  typedef typename _Traits::off_type off_type;
  typedef _Traits                    traits_type;

private:                        // Data members.

  char_type* _M_gbegin;         // Beginning of get area
  char_type* _M_gnext;          // Current position within the get area
  char_type* _M_gend;           // End of get area

  char_type* _M_pbegin;         // Beginning of put area
  char_type* _M_pnext;          // Current position within the put area
  char_type* _M_pend;           // End of put area

  locale _M_locale;             // The streambuf's locale object

public:                         // Destructor.
  virtual ~basic_streambuf();

protected:                      // The default constructor.
  basic_streambuf()
  ;

protected:                      // Protected interface to the get area.
  char_type* eback() const { return _M_gbegin; } // Beginning
  char_type* gptr()  const { return _M_gnext; }  // Current position
  char_type* egptr() const { return _M_gend; }   // End

  void gbump(int __n) { _M_gnext += __n; }
  void setg(char_type* __gbegin, char_type* __gnext, char_type* __gend) {
    _M_gbegin = __gbegin;
    _M_gnext  = __gnext;
    _M_gend   = __gend;
  }

public:
  // An alternate public interface to the above functions
  // which allows us to avoid using templated friends which
  // are not supported on some compilers.
  char_type* _M_eback() const { return eback(); }
  char_type* _M_gptr()  const { return gptr(); }
  char_type* _M_egptr() const { return egptr(); }
  void _M_gbump(int __n)      { gbump(__n); }
  void _M_setg(char_type* __gbegin, char_type* __gnext, char_type* __gend)
  { this->setg(__gbegin, __gnext, __gend); }

protected:                      // Protected interface to the put area

  char_type* pbase() const { return _M_pbegin; } // Beginning
  char_type* pptr()  const { return _M_pnext; }  // Current position
  char_type* epptr() const { return _M_pend; }   // End

  void pbump(int __n) { _M_pnext += __n; }
  void setp(char_type* __pbegin, char_type* __pend) {
    _M_pbegin = __pbegin;
    _M_pnext  = __pbegin;
    _M_pend   = __pend;
  }

protected:                      // Virtual buffer management functions.

  virtual basic_streambuf<_CharT, _Traits>* setbuf(char_type*, streamsize);

  // Alters the stream position, using an integer offset.  In this
  // class seekoff does nothing; subclasses are expected to override it.
  virtual pos_type seekoff(off_type, ios_base::seekdir,
                           ios_base::openmode = ios_base::in | ios_base::out);

  // Alters the stream position, using a previously obtained streampos.  In
  // this class seekpos does nothing; subclasses are expected to override it.
  virtual pos_type
  seekpos(pos_type, ios_base::openmode = ios_base::in | ios_base::out);

  // Synchronizes (i.e. flushes) the buffer.  All subclasses are expected to
  // override this virtual member function.
  virtual int sync();


public:                         // Buffer management.
  basic_streambuf<_CharT, _Traits>* pubsetbuf(char_type* __s, streamsize __n)
  { return this->setbuf(__s, __n); }

  pos_type pubseekoff(off_type __offset, ios_base::seekdir __way,
                      ios_base::openmode __mod = ios_base::in | ios_base::out)
  { return this->seekoff(__offset, __way, __mod); }

  pos_type pubseekpos(pos_type __sp,
                      ios_base::openmode __mod = ios_base::in | ios_base::out)
  { return this->seekpos(__sp, __mod); }

  int pubsync() { return this->sync(); }

protected:                      // Virtual get area functions, as defined in
                                // 17.5.2.4.3 and 17.5.2.4.4 of the standard.
  // Returns a lower bound on the number of characters that we can read,
  // with underflow, before reaching end of file.  (-1 is a special value:
  // it means that underflow will fail.)  Most subclasses should probably
  // override this virtual member function.
  virtual streamsize showmanyc();

  // Reads up to __n characters.  Return value is the number of
  // characters read.
  virtual streamsize xsgetn(char_type* __s, streamsize __n);

  // Called when there is no read position, i.e. when gptr() is null
  // or when gptr() >= egptr().  Subclasses are expected to override
  // this virtual member function.
  virtual int_type underflow();

  // Similar to underflow(), but used for unbuffered input.  Most
  // subclasses should probably override this virtual member function.
  virtual int_type uflow();

  // Called when there is no putback position, i.e. when gptr() is null
  // or when gptr() == eback().  All subclasses are expected to override
  // this virtual member function.
  virtual int_type pbackfail(int_type = traits_type::eof());

protected:                      // Virtual put area functions, as defined in
                                // 27.5.2.4.5 of the standard.

  // Writes up to __n characters.  Return value is the number of characters
  // written.
  virtual streamsize xsputn(const char_type* __s, streamsize __n);

  // Extension: writes up to __n copies of __c.  Return value is the number
  // of characters written.
  virtual streamsize _M_xsputnc(char_type __c, streamsize __n);

  // Called when there is no write position.  All subclasses are expected to
  // override this virtual member function.
  virtual int_type overflow(int_type = traits_type::eof());

public:                         // Public members for writing characters.
  // Write a single character.
  int_type sputc(char_type __c) {
    return ((_M_pnext < _M_pend) ? _Traits::to_int_type(*_M_pnext++ = __c)
      : this->overflow(_Traits::to_int_type(__c)));
  }

  // Write __n characters.
  streamsize sputn(const char_type* __s, streamsize __n)
  { return this->xsputn(__s, __n); }

  // Extension: write __n copies of __c.
  streamsize _M_sputnc(char_type __c, streamsize __n)
  { return this->_M_xsputnc(__c, __n); }

private:                        // Helper functions.
  int_type _M_snextc_aux();

public:                         // Public members for reading characters.
  streamsize in_avail() {
    return (_M_gnext < _M_gend) ? (_M_gend - _M_gnext) : this->showmanyc();
  }

  // Advance to the next character and return it.
  int_type snextc() {
  return ( _M_gend - _M_gnext > 1 ?
             _Traits::to_int_type(*++_M_gnext) :
             this->_M_snextc_aux());
  }

  // Return the current character and advance to the next.
  int_type sbumpc() {
    return _M_gnext < _M_gend ? _Traits::to_int_type(*_M_gnext++)
      : this->uflow();
  }

  // Return the current character without advancing to the next.
  int_type sgetc() {
    return _M_gnext < _M_gend ? _Traits::to_int_type(*_M_gnext)
      : this->underflow();
  }

  streamsize sgetn(char_type* __s, streamsize __n)
  { return this->xsgetn(__s, __n); }

  int_type sputbackc(char_type __c) {
    return ((_M_gbegin < _M_gnext) && _Traits::eq(__c, *(_M_gnext - 1)))
      ? _Traits::to_int_type(*--_M_gnext)
      : this->pbackfail(_Traits::to_int_type(__c));
  }

  int_type sungetc() {
    return (_M_gbegin < _M_gnext)
      ? _Traits::to_int_type(*--_M_gnext)
      : this->pbackfail();
  }

protected:                      // Virtual locale functions.

  // This is a hook, called by pubimbue() just before pubimbue()
  // sets the streambuf's locale to __loc.  Note that imbue should
  // not (and cannot, since it has no access to streambuf's private
  // members) set the streambuf's locale itself.
  virtual void imbue(const locale&);

public:                         // Locale-related functions.
  locale pubimbue(const locale&);
  locale getloc() const { return _M_locale; }

  void stossc() { this->sbumpc(); }
};


}

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


namespace std {
//----------------------------------------------------------------------
// Non-inline basic_streambuf<> member functions.

template <class _CharT, class _Traits>
basic_streambuf<_CharT, _Traits>::basic_streambuf()
  : _M_gbegin(0), _M_gnext(0), _M_gend(0),
    _M_pbegin(0), _M_pnext(0), _M_pend(0),
    _M_locale() {
  //  _M_lock._M_initialize();
}

template <class _CharT, class _Traits>
basic_streambuf<_CharT, _Traits>::~basic_streambuf()
{}

template <class _CharT, class _Traits>
locale
basic_streambuf<_CharT, _Traits>::pubimbue(const locale& __loc) {
  this->imbue(__loc);
  locale __tmp = _M_locale;
  _M_locale = __loc;
  return __tmp;
}

template <class _CharT, class _Traits>
streamsize
basic_streambuf<_CharT, _Traits>::xsgetn(_CharT* __s, streamsize __n) {
  streamsize __result = 0;
  const int_type __eof = _Traits::eof();

  while (__result < __n) {
    if (_M_gnext < _M_gend) {
      size_t __chunk = (min) (static_cast<size_t>(_M_gend - _M_gnext),
                              static_cast<size_t>(__n - __result));
      _Traits::copy(__s, _M_gnext, __chunk);
      __result += __chunk;
      __s += __chunk;
      _M_gnext += __chunk;
    }
    else {
      int_type __c = this->sbumpc();
      if (!_Traits::eq_int_type(__c, __eof)) {
        *__s = _Traits::to_char_type(__c);
        ++__result;
        ++__s;
      }
      else
        break;
    }
  }

  return __result;
}

template <class _CharT, class _Traits>
streamsize
basic_streambuf<_CharT, _Traits>::xsputn(const _CharT* __s, streamsize __n)
{
  streamsize __result = 0;
  const int_type __eof = _Traits::eof();

  while (__result < __n) {
    if (_M_pnext < _M_pend) {
      size_t __chunk = (min) (static_cast<size_t>(_M_pend - _M_pnext),
                           static_cast<size_t>(__n - __result));
      _Traits::copy(_M_pnext, __s, __chunk);
      __result += __chunk;
      __s += __chunk;
      _M_pnext += __chunk;
    }

    else if (!_Traits::eq_int_type(this->overflow(_Traits::to_int_type(*__s)),
                                   __eof)) {
      ++__result;
      ++__s;
    }
    else
      break;
  }
  return __result;
}

template <class _CharT, class _Traits>
streamsize
basic_streambuf<_CharT, _Traits>::_M_xsputnc(_CharT __c, streamsize __n)
{
  streamsize __result = 0;
  const int_type __eof = _Traits::eof();

  while (__result < __n) {
    if (_M_pnext < _M_pend) {
      size_t __chunk = (min) (static_cast<size_t>(_M_pend - _M_pnext),
                           static_cast<size_t>(__n - __result));
      _Traits::assign(_M_pnext, __chunk, __c);
      __result += __chunk;
      _M_pnext += __chunk;
    }

    else if (!_Traits::eq_int_type(this->overflow(_Traits::to_int_type(__c)),
                                   __eof))
      ++__result;
    else
      break;
  }
  return __result;
}

template <class _CharT, class _Traits>
typename basic_streambuf<_CharT, _Traits>::int_type
basic_streambuf<_CharT, _Traits>::_M_snextc_aux()
{
  int_type __eof = _Traits::eof();
  if (_M_gend == _M_gnext)
    return _Traits::eq_int_type(this->uflow(), __eof) ? __eof : this->sgetc();
  else {
    _M_gnext = _M_gend;
    return this->underflow();
  }
}

template <class _CharT, class _Traits>
typename basic_streambuf<_CharT, _Traits>::int_type
basic_streambuf<_CharT, _Traits>::pbackfail(int_type) {
 return _Traits::eof();
}

template <class _CharT, class _Traits>
typename basic_streambuf<_CharT, _Traits>::int_type
basic_streambuf<_CharT, _Traits>::overflow(int_type) {
  return _Traits::eof();
}

template <class _CharT, class _Traits>
typename basic_streambuf<_CharT, _Traits>::int_type
basic_streambuf<_CharT, _Traits>::uflow() {
    return ( _Traits::eq_int_type(this->underflow(),_Traits::eof()) ?
             _Traits::eof() :
             _Traits::to_int_type(*_M_gnext++));
}

template <class _CharT, class _Traits>
typename basic_streambuf<_CharT, _Traits>::int_type
basic_streambuf<_CharT, _Traits>::underflow()
{ return _Traits::eof(); }

template <class _CharT, class _Traits>
streamsize
basic_streambuf<_CharT, _Traits>::showmanyc()
{ return 0; }

template <class _CharT, class _Traits>
void
basic_streambuf<_CharT, _Traits>::imbue(const locale&) {}

template <class _CharT, class _Traits>
int
basic_streambuf<_CharT, _Traits>::sync() { return 0; }

template <class _CharT, class _Traits>
typename basic_streambuf<_CharT, _Traits>::pos_type
basic_streambuf<_CharT, _Traits>::seekpos(pos_type, ios_base::openmode)
{ return pos_type(-1); }

template <class _CharT, class _Traits>
typename basic_streambuf<_CharT, _Traits>::pos_type
basic_streambuf<_CharT, _Traits>::seekoff(off_type, ios_base::seekdir,
                                          ios_base::openmode)
{ return pos_type(-1); }

template <class _CharT, class _Traits>
basic_streambuf<_CharT, _Traits>*
basic_streambuf<_CharT, _Traits>:: setbuf(char_type*, streamsize)
{ return this; }

}


// Local Variables:
// mode:C++
// End:


// Local Variables:
// mode:C++
// End:


namespace std {

// basic_ios<>'s non-inline member functions

// Public constructor, taking a streambuf.
template <class _CharT, class _Traits>
basic_ios<_CharT, _Traits>
  ::basic_ios(basic_streambuf<_CharT, _Traits>* __streambuf)
    : ios_base(), _M_cached_ctype(0),
      _M_fill(_CharT()), _M_streambuf(0), _M_tied_ostream(0) {
  basic_ios<_CharT, _Traits>::init(__streambuf);
}

template <class _CharT, class _Traits>
basic_streambuf<_CharT, _Traits>*
basic_ios<_CharT, _Traits>::rdbuf(basic_streambuf<_CharT, _Traits>* __buf) {
  basic_streambuf<_CharT, _Traits>* __tmp = _M_streambuf;
  _M_streambuf = __buf;
  this->clear();
  return __tmp;
}

template <class _CharT, class _Traits>
basic_ios<_CharT, _Traits>&
basic_ios<_CharT, _Traits>::copyfmt(const basic_ios<_CharT, _Traits>& __x) {
  _M_invoke_callbacks(erase_event);
  _M_copy_state(__x);           // Inherited from ios_base.
  _M_cached_ctype = __x._M_cached_ctype;
  _M_fill = __x._M_fill;
  _M_tied_ostream = __x._M_tied_ostream;
  _M_invoke_callbacks(copyfmt_event);
  this->_M_set_exception_mask(__x.exceptions());
  return *this;
}

template <class _CharT, class _Traits>
locale basic_ios<_CharT, _Traits>::imbue(const locale& __loc) {
  locale __tmp = ios_base::imbue(__loc);
   {
    if (_M_streambuf)
      _M_streambuf->pubimbue(__loc);

    // no throwing here
    _M_cached_ctype = &use_facet<ctype<char_type> >(__loc);
  }
  if (false) {
    __tmp = ios_base::imbue(__tmp);
    _M_handle_exception(ios_base::failbit);
  }
  return __tmp;
}

// Protected constructor and initialization functions. The default
// constructor creates an uninitialized basic_ios, and init() initializes
// all of the members to the values in Table 89 of the C++ standard.

template <class _CharT, class _Traits>
basic_ios<_CharT, _Traits>::basic_ios()
  : ios_base(),
    _M_fill(_CharT()), _M_streambuf(0), _M_tied_ostream(0)
{}

template <class _CharT, class _Traits>
void
basic_ios<_CharT, _Traits>::init(basic_streambuf<_CharT, _Traits>* __sb)
{
  this->rdbuf(__sb);
  this->imbue(locale());
  this->tie(0);
  this->_M_set_exception_mask(ios_base::goodbit);
  this->_M_clear_nothrow(__sb != 0 ? ios_base::goodbit : ios_base::badbit);
  ios_base::flags(ios_base::skipws | ios_base::dec);
  ios_base::width(0);
  ios_base::precision(6);
  this->fill(widen(' '));
  // We don't need to worry about any of the three arrays: they are
  // initialized correctly in ios_base's constructor.
}

// This is never called except from within a catch clause.
template <class _CharT, class _Traits>
void basic_ios<_CharT, _Traits>::_M_handle_exception(ios_base::iostate __flag)
{
  this->_M_setstate_nothrow(__flag);
  if (this->_M_get_exception_mask() & __flag)
    {};
}

}


// Local Variables:
// mode:C++
// End:


// Local Variables:
// mode:C++
// End:


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */
// WARNING: This is an internal header file, included by other C++
// standard library headers.  You should not attempt to use this header
// file directly.




namespace std {

namespace priv {

template<class _CharT, class _Traits>
extern basic_streambuf<_CharT, _Traits>*  __get_ostreambuf(basic_ostream<_CharT, _Traits>&);

}

// The default template argument is declared in iosfwd
template <class _CharT, class _Traits>
class ostreambuf_iterator :
  public iterator<output_iterator_tag, void, void, void, void> {
public:
  typedef _CharT                           char_type;
  typedef _Traits                          traits_type;
  typedef typename _Traits::int_type       int_type;
  typedef basic_streambuf<_CharT, _Traits> streambuf_type;
  typedef basic_ostream<_CharT, _Traits>   ostream_type;

  typedef output_iterator_tag              iterator_category;
  typedef void                             value_type;
  typedef void                             difference_type;
  typedef void                             pointer;
  typedef void                             reference;

public:
  ostreambuf_iterator(streambuf_type* __buf)  : _M_buf(__buf), _M_ok(__buf!=0) {}
  //  ostreambuf_iterator(ostream_type& __o) _STLP_NOTHROW : _M_buf(__get_ostreambuf(__o)), _M_ok(_M_buf != 0) {}
  inline ostreambuf_iterator(ostream_type& __o) ;

  ostreambuf_iterator<_CharT, _Traits>& operator=(char_type __c) {
    _M_ok = _M_ok && !traits_type::eq_int_type(_M_buf->sputc(__c),
                                               traits_type::eof());
    return *this;
  }

  ostreambuf_iterator<_CharT, _Traits>& operator*()     { return *this; }
  ostreambuf_iterator<_CharT, _Traits>& operator++()    { return *this; }
  ostreambuf_iterator<_CharT, _Traits>& operator++(int) { return *this; }

  bool failed() const { return !_M_ok; }

private:
  streambuf_type* _M_buf;
  bool _M_ok;
};

template <class _CharT, class _Traits>
inline ostreambuf_iterator<_CharT, _Traits>::ostreambuf_iterator(basic_ostream<_CharT, _Traits>& __o) 
  : _M_buf(::std::priv:: __get_ostreambuf(__o)), _M_ok(_M_buf != 0) {}



}


// Local Variables:
// mode:C++
// End:



namespace std {


namespace priv {

template <class _CharT, class _Traits>
bool __init_bostr(basic_ostream<_CharT, _Traits>& __str);

}

//----------------------------------------------------------------------
// class basic_ostream<>

template <class _CharT, class _Traits>
class basic_ostream : virtual public basic_ios<_CharT, _Traits> {
  typedef basic_ostream<_CharT, _Traits> _Self;


public:                         // Types
  typedef _CharT                     char_type;
  typedef typename _Traits::int_type int_type;
  typedef typename _Traits::pos_type pos_type;
  typedef typename _Traits::off_type off_type;
  typedef _Traits                    traits_type;
  typedef basic_ios<_CharT, _Traits> _Basic_ios;

public:                         // Constructor and destructor.
  explicit basic_ostream(basic_streambuf<_CharT, _Traits>* __buf);
  explicit basic_ostream(ios_base::_SpecialInitType __i) :
    basic_ios<_CharT, _Traits>(__i) { /* Do nothing */ }
  ~basic_ostream();

public:                         // Hooks for manipulators.
  typedef basic_ios<_CharT, _Traits>& ( *__ios_fn)(basic_ios<_CharT, _Traits>&);
  typedef ios_base& ( *__ios_base_fn)(ios_base&);
  typedef _Self& ( *__ostream_fn)(_Self&);
  _Self& operator<< (__ostream_fn __f) { return __f(*this); }
  _Self & operator<< (__ios_base_fn __f) { __f(*this); return *this; }
  _Self& operator<< (__ios_fn __ff) { __ff(*this); return *this; }

private:
  bool _M_copy_buffered(basic_streambuf<_CharT, _Traits>* __from,
                        basic_streambuf<_CharT, _Traits>* __to);
  bool _M_copy_unbuffered(basic_streambuf<_CharT, _Traits>* __from,
                          basic_streambuf<_CharT, _Traits>* __to);

public:
  void _M_put_char(_CharT __c);

  void _M_put_nowiden(const _CharT* __s);
  void _M_put_widen(const char* __s);
  bool _M_put_widen_aux(const char* __s, streamsize __n);

public:                         // Unformatted output.
  _Self& put(char_type __c);
  _Self& write(const char_type* __s, streamsize __n);

public:                         // Formatted output.
  // Formatted output from a streambuf.
  _Self& operator<<(basic_streambuf<_CharT, _Traits>* __buf);
  // this is needed for compiling with option char = unsigned
  _Self& operator<<(unsigned char __x) { _M_put_char(__x); return *this; }
  _Self& operator<<(short __x);
  _Self& operator<<(unsigned short __x);
  _Self& operator<<(int __x);
  _Self& operator<<(unsigned int __x);
  _Self& operator<<(long __x);
  _Self& operator<<(unsigned long __x);
  _Self& operator<< (long long __x);
  _Self& operator<< (unsigned long long __x);
  _Self& operator<<(float __x);
  _Self& operator<<(double __x);
  _Self& operator<<(long double __x);
  _Self& operator<<(const void* __x);
  _Self& operator<<(bool __x);

public:                         // Buffer positioning and manipulation.
  _Self& flush() {
    if (this->rdbuf())
      if (this->rdbuf()->pubsync() == -1)
        this->setstate(ios_base::badbit);
    return *this;
  }

  pos_type tellp() {
    return this->rdbuf() && !this->fail()
      ? this->rdbuf()->pubseekoff(0, ios_base::cur, ios_base::out)
      : pos_type(-1);
  }

  _Self& seekp(pos_type __pos) {
    if (this->rdbuf() && !this->fail()) {
      if (this->rdbuf()->pubseekpos(__pos, ios_base::out) == pos_type(-1)) {
        this->setstate(ios_base::failbit);
      }
    }
    return *this;
  }

  _Self& seekp(off_type __off, ios_base::seekdir __dir) {
    if (this->rdbuf() && !this->fail())
      this->rdbuf()->pubseekoff(__off, __dir, ios_base::out);
    return *this;
  }

    class sentry {
      typedef sentry _Self;
    private:
      basic_ostream<_CharT, _Traits>& _M_str;
      //      basic_streambuf<_CharT, _Traits>* _M_buf;
      bool _M_ok;
    public:
      explicit sentry(basic_ostream<_CharT, _Traits>& __str)
        : _M_str(__str), /* _M_buf(__str.rdbuf()), */ _M_ok(::std::priv:: __init_bostr(__str))
      {}

      ~sentry() {
        if (_M_str.flags() & ios_base::unitbuf)
            _M_str.flush();
      }

      operator bool() const { return _M_ok; }
    private:                        // Disable assignment and copy constructor.
      //Implementation is here only to avoid warning with some compilers.
      sentry(const _Self& __s) : _M_str(__s._M_str) {}
      _Self& operator=(const _Self&) { return *this; }
    };
  // close basic_ostream class definition here
};


namespace priv {

// Helper functions for istream<>::sentry constructor.
template <class _CharT, class _Traits>
bool __init_bostr(basic_ostream<_CharT, _Traits>& __str) {
  if (__str.good()) {
    // boris : check if this is needed !
    if (!__str.rdbuf())
      __str.setstate(ios_base::badbit);
    if (__str.tie())
      __str.tie()->flush();
    return __str.good();
  }
  else
    return false;
}

template <class _CharT, class _Traits>
inline basic_streambuf<_CharT, _Traits>* 
__get_ostreambuf(basic_ostream<_CharT, _Traits>& __St)
{ return __St.rdbuf(); }

}

// Non-member functions.
template <class _CharT, class _Traits>
inline basic_ostream<_CharT, _Traits>& 
operator<<(basic_ostream<_CharT, _Traits>& __os, _CharT __c){
  __os._M_put_char(__c);
  return __os;
}

template <class _CharT, class _Traits>
inline basic_ostream<_CharT, _Traits>& 
operator<<(basic_ostream<_CharT, _Traits>& __os, const _CharT* __s) {
  __os._M_put_nowiden(__s);
  return __os;
}


// also for compilers who might use that
template <class _CharT, class _Traits>
inline basic_ostream<_CharT, _Traits>& 
operator<<(basic_ostream<_CharT, _Traits>& __os, char __c) {
  __os._M_put_char(__os.widen(__c));
  return __os;
}

template <class _Traits>
inline basic_ostream<char, _Traits>& 
operator<<(basic_ostream<char, _Traits>& __os, char __c) {
  __os._M_put_char(__c);
  return __os;
}

template <class _Traits>
inline basic_ostream<char, _Traits>& 
operator<<(basic_ostream<char, _Traits>& __os, signed char __c) {
  __os._M_put_char(__c);
  return __os;
}

template <class _Traits>
inline basic_ostream<char, _Traits>& 
operator<<(basic_ostream<char, _Traits>& __os, unsigned char __c) {
  __os._M_put_char(__c);
  return __os;
}

template <class _CharT, class _Traits>
inline basic_ostream<_CharT, _Traits>& 
operator<<(basic_ostream<_CharT, _Traits>& __os, const char* __s) {
  __os._M_put_widen(__s);
  return __os;
}

template <class _Traits>
inline basic_ostream<char, _Traits>& 
operator<<(basic_ostream<char, _Traits>& __os, const char* __s) {
  __os._M_put_nowiden(__s);
  return __os;
}

template <class _Traits>
inline basic_ostream<char, _Traits>& 
operator<<(basic_ostream<char, _Traits>& __os, const signed char* __s) {
  __os._M_put_nowiden(reinterpret_cast<const char* >(__s));
  return __os;
}

template <class _Traits>
inline basic_ostream<char, _Traits>&
operator<<(basic_ostream<char, _Traits>& __os, const unsigned char* __s) {
  __os._M_put_nowiden(reinterpret_cast<const char* >(__s));
  return __os;
}

//----------------------------------------------------------------------
// basic_ostream manipulators.

template <class _CharT, class _Traits>
inline basic_ostream<_CharT, _Traits>& 
endl(basic_ostream<_CharT, _Traits>& __os) {
  __os.put(__os.widen('\n'));
  __os.flush();
  return __os;
}

template <class _CharT, class _Traits>
inline basic_ostream<_CharT, _Traits>& 
ends(basic_ostream<_CharT, _Traits>& __os) {
  __os.put(_CharT());
  return __os;
}

template <class _CharT, class _Traits>
inline basic_ostream<_CharT, _Traits>& 
flush(basic_ostream<_CharT, _Traits>& __os) {
  __os.flush();
  return __os;
}

}

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */
// WARNING: This is an internal header file, included by other C++
// standard library headers.  You should not attempt to use this header
// file directly.






/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 2004
 * Francois Dumont
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

 /*
  * This is an internal string for the STLport own iostream implementation.
  * The only diference rely on the allocator used to instanciate the basic_string.
  * Its goals is to improve performance limitating the number of dynamic allocation
  * that could occur when requesting a big float ouput for instance. This allocator
  * is not standard conformant as it has an internal state (the static buffer)
  */





namespace std {

namespace priv {

template <class _CharT>
class __iostring_allocator : public allocator<_CharT> {
public:
  enum __attribute__((__packed__)) { _STR_SIZE = 256 };

private:
  enum __attribute__((__packed__)) { _BUF_SIZE = _STR_SIZE + 1 };
  typedef allocator<_CharT> _Base;
  _CharT _M_static_buf[_BUF_SIZE];

public:
  typedef typename _Base::size_type size_type;
  typedef typename _Base::pointer pointer;
  template <class _Tp1> struct rebind {
    typedef __iostring_allocator<_Tp1> other;
  };

  _CharT* allocate(size_type __n, const void* __ptr = 0) {
    if (__n > _BUF_SIZE) {
      return _Base::allocate(__n, __ptr);
    }
    return _M_static_buf;
  }
  void deallocate(pointer __p, size_type __n) {
    if (__p != _M_static_buf) _Base::deallocate(__p, __n);
  }
};


template <class _CharT>
struct __basic_iostring : public basic_string<_CharT, char_traits<_CharT>, __iostring_allocator<_CharT> > {
  /*
   * A consequence of the non standard conformant allocator is that a string using it
   * must always be presized to the allocator static buffer size because the basic_string implementation
   * do not manage an allocator returning always the same memory adress as long as the
   * requested memory block size is under a certain value.
   */
  typedef __basic_iostring<_CharT> _Self;
  typedef basic_string<_CharT, char_traits<_CharT>, __iostring_allocator<_CharT> > _Base;
  typedef typename _Base::_Reserve_t _Reserve_t;

  __basic_iostring() : _Base(_Reserve_t(), __iostring_allocator<_CharT>::_STR_SIZE)
  {}

  _Self& operator=(const _CharT* __s) {
    _Base::operator=(__s);
    return *this;
  }
};

typedef __basic_iostring<char> __iostring;

typedef __basic_iostring<wchar_t> __iowstring;



}

}



namespace std {

//----------------------------------------------------------------------
// num_put facet

template <class _CharT, class _OutputIter>
class num_put: public locale::facet {
public:
  typedef _CharT      char_type;
  typedef _OutputIter iter_type;

  explicit num_put(size_t __refs = 0) : locale::facet(__refs) {}

  iter_type put(iter_type __s, ios_base& __f, char_type __fill,
                bool __val) const {
    return do_put(__s, __f, __fill, __val);
  }
  iter_type put(iter_type __s, ios_base& __f, char_type __fill,
               long __val) const {
    return do_put(__s, __f, __fill, __val);
  }

  iter_type put(iter_type __s, ios_base& __f, char_type __fill,
                unsigned long __val) const {
    return do_put(__s, __f, __fill, __val);
  }

  iter_type put(iter_type __s, ios_base& __f, char_type __fill,
                long long __val) const {
    return do_put(__s, __f, __fill, __val);
  }

  iter_type put(iter_type __s, ios_base& __f, char_type __fill,
                unsigned long long __val) const {
    return do_put(__s, __f, __fill, __val);
  }

  iter_type put(iter_type __s, ios_base& __f, char_type __fill,
                double __val) const {
    return do_put(__s, __f, __fill, (double)__val);
  }

  iter_type put(iter_type __s, ios_base& __f, char_type __fill,
                long double __val) const {
    return do_put(__s, __f, __fill, __val);
  }

  iter_type put(iter_type __s, ios_base& __f, char_type __fill,
                const void * __val) const {
    return do_put(__s, __f, __fill, __val);
  }

  static  locale::id id;

protected:
  ~num_put() {}
  virtual _OutputIter do_put(_OutputIter __s, ios_base& __f, _CharT __fill, bool __val) const;
  virtual _OutputIter do_put(_OutputIter __s, ios_base& __f, _CharT __fill, long __val) const;
  virtual _OutputIter do_put(_OutputIter __s, ios_base& __f, _CharT __fill, unsigned long __val) const;
  virtual _OutputIter do_put(_OutputIter __s, ios_base& __f, _CharT __fill, double __val) const;
  virtual _OutputIter do_put(_OutputIter __s, ios_base& __f, _CharT __fill, long double __val) const;

  virtual _OutputIter do_put(_OutputIter __s, ios_base& __f, _CharT __fill, long long __val) const;
  virtual _OutputIter do_put(_OutputIter __s, ios_base& __f, _CharT __fill,
                           unsigned long long __val) const ;
  virtual _OutputIter do_put(_OutputIter __s, ios_base& __f, _CharT __fill, const void* __val) const;
};



namespace priv {

template <class _Integer>
char* 
__write_integer_backward(char* __buf, ios_base::fmtflags __flags, _Integer __x);

/*
 * Returns the position on the right of the digits that has to be considered
 * for the application of the grouping policy.
 */
extern size_t  __write_float(__iostring&, ios_base::fmtflags, int, double);
extern size_t  __write_float(__iostring&, ios_base::fmtflags, int, long double);

/*
 * Gets the digits of the integer part.
 */
void  __get_floor_digits(__iostring&, long double);

template <class _CharT>
void  __get_money_digits(::std::priv:: __basic_iostring<_CharT> &, ios_base&, long double);

extern void  __convert_float_buffer(__iostring const&, __iowstring&, const ctype<wchar_t>&, wchar_t, bool = true);
extern void  __adjust_float_buffer(__iostring&, char);

extern char* 
__write_integer(char* buf, ios_base::fmtflags flags, long x);

extern ptrdiff_t  __insert_grouping(char* first, char* last, const string&, char, char, char, int);
extern void  __insert_grouping(__iostring&, size_t, const string&, char, char, char, int);
extern ptrdiff_t  __insert_grouping(wchar_t*, wchar_t*, const string&, wchar_t, wchar_t, wchar_t, int);
extern void  __insert_grouping(__iowstring&, size_t, const string&, wchar_t, wchar_t, wchar_t, int);

}


}

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */


/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

/* NOTE: This may be not portable code. Parts of numeric_limits<> are
 * inherently machine-dependent.  At present this file is suitable
 * for the MIPS, SPARC, Alpha and ia32 architectures.
 */



/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */



// Borland defines some implementation constants in std:: namespace,
// we do not want to import them.
/*****************************************************************************/
/* float.h    v16.12.0                                                       */
/*                                                                           */
/* Copyright (c) 1993-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/

/********************************************************************/
/*    KEY:  FLT_     - APPLIES TO TYPE FLOAT                        */
/*          DBL_     - APPLIES TO TYPE DOUBLE                       */
/*          LDBL_    - APPLIES TO TYPE LONG DOUBLE                  */
/********************************************************************/

#pragma diag_push
#pragma CHECK_MISRA("-20.1") /* standard headers must define standard names */









#pragma diag_pop




// Local Variables:
// mode:C++
// End:


namespace std {

enum __attribute__((__packed__)) float_round_style {
  round_indeterminate       = -1,
  round_toward_zero         =  0,
  round_to_nearest          =  1,
  round_toward_infinity     =  2,
  round_toward_neg_infinity =  3
};

enum __attribute__((__packed__)) float_denorm_style {
  denorm_indeterminate = -1,
  denorm_absent        =  0,
  denorm_present       =  1
};

namespace priv {

/* Dinkumware expects for an argument to be given to the constructor
 * for __number below in their validation. */

// Base class for all specializations of numeric_limits.
template <class __number>
class _Numeric_limits_base {
public:

  static __number ( min)()  { return __number(0); }
  static __number ( max)()  { return __number(0); }

  static const  int digits = 0;
  static const  int digits10 = 0;
  static const  int radix = 0;
  static const  int min_exponent = 0;
  static const  int min_exponent10 = 0;
  static const  int max_exponent = 0;
  static const  int max_exponent10 = 0;

  static const  float_denorm_style has_denorm = denorm_absent;
  static const  float_round_style round_style = round_toward_zero;

  static const  bool is_specialized = false;
  static const  bool is_signed = false;
  static const  bool is_integer = false;
  static const  bool is_exact = false;
  static const  bool has_infinity = false;
  static const  bool has_quiet_NaN = false;
  static const  bool has_signaling_NaN = false;
  static const  bool has_denorm_loss = false;
  static const  bool is_iec559 = false;
  static const  bool is_bounded = false;
  static const  bool is_modulo = false;
  static const  bool traps = false;
  static const  bool tinyness_before = false;

  static __number  epsilon()      { return __number(0); }
  static __number  round_error()  { return __number(0); }

  static __number  infinity()       { return __number(0); }
  static __number  quiet_NaN()      { return __number(0); }
  static __number  signaling_NaN()  { return __number(0); }
  static __number  denorm_min()     { return __number(0); }
};


// Base class for integers.


template <class _Int,
          _Int __imin,
          _Int __imax,
          int __idigits, bool __ismod>
class _Integer_limits : public _Numeric_limits_base<_Int> {
public:

  static _Int ( min) ()  { return (_Int)__imin; }
  static _Int ( max) ()  { return (_Int)__imax; }

  static const  int digits = (__idigits < 0) ? ((int)((sizeof(_Int) * (8))) - ((__imin == 0) ? 0 : 1)) : (__idigits);
  static const  int digits10 = (digits * 301UL) / 1000;
  static const  int radix = 2;
  static const  bool is_specialized = true;
  static const  bool is_signed = (__imin != 0);
  static const  bool is_integer = true;
  static const  bool is_exact = true;
  static const  bool is_bounded = true;
  static const  bool is_modulo = __ismod;
};


// Base class for floating-point numbers.
template <class __number,
         int __Digits, int __Digits10,
         int __MinExp, int __MaxExp,
         int __MinExp10, int __MaxExp10,
         bool __IsIEC559,
         float_denorm_style __DenormStyle,
         float_round_style __RoundStyle>
class _Floating_limits : public _Numeric_limits_base<__number> {
public:

  static const  int digits = __Digits;
  static const  int digits10 = __Digits10;
  static const  int radix = 2;
  static const  int min_exponent = __MinExp;
  static const  int max_exponent = __MaxExp;
  static const  int min_exponent10 = __MinExp10;
  static const  int max_exponent10 = __MaxExp10;

  static const  float_denorm_style has_denorm = __DenormStyle;
  static const  float_round_style round_style = __RoundStyle;

  static const  bool is_specialized = true;
  static const  bool is_signed = true;

  static const  bool has_infinity = true;
  static const  bool has_quiet_NaN = true;
  static const  bool has_signaling_NaN = true;

  static const  bool is_iec559 = __IsIEC559 && has_infinity && has_quiet_NaN && has_signaling_NaN && (has_denorm == denorm_present);
  static const  bool has_denorm_loss = false;
  static const  bool is_bounded = true;
  static const  bool traps = true;
  static const  bool tinyness_before = false;
};

}

// Class numeric_limits

// The unspecialized class.

template<class _Tp>
class numeric_limits : public ::std::priv:: _Numeric_limits_base<_Tp> {};

// Specializations for all built-in integral types.

template< >
class numeric_limits<bool>
  : public ::std::priv:: _Integer_limits<bool, false, true, 1, false>
{};

template< >
class numeric_limits<char>
  : public ::std::priv:: _Integer_limits<char, 0, (255), -1, true>
{};

template< >
class numeric_limits<signed char>
  : public ::std::priv:: _Integer_limits<signed char, (-127-1), 127, -1, true>
{};

template< >
class numeric_limits<unsigned char>
  : public ::std::priv:: _Integer_limits<unsigned char, 0, 255, -1, true>
{};


template< >
class numeric_limits<wchar_t>
  : public ::std::priv:: _Integer_limits<wchar_t, 0, 0xffffu, -1, true>
{};


template< >
class numeric_limits<short>
  : public ::std::priv:: _Integer_limits<short, (-32767-1), 32767, -1, true>
{};

template< >
class numeric_limits<unsigned short>
  : public ::std::priv:: _Integer_limits<unsigned short, 0, 65535u, -1, true>
{};


template< >
class numeric_limits<int>
  : public ::std::priv:: _Integer_limits<int, ((-32767-1)), (32767), -1, true>
{};

template< >
class numeric_limits<unsigned int>
  : public ::std::priv:: _Integer_limits<unsigned int, 0, (65535u), -1, true>
{};

template< >
class numeric_limits<long>
  : public ::std::priv:: _Integer_limits<long, (-2147483647-1), 2147483647, -1, true>
{};

template< >
class numeric_limits<unsigned long>
  : public ::std::priv:: _Integer_limits<unsigned long, 0, 4294967295U, -1, true>
{};




template< >
class numeric_limits<long long>
  : public ::std::priv:: _Integer_limits<long long, (-0x7fffffffffffffffLL-1LL), 0x7fffffffffffffffLL, -1, true>
{};

template< >
class numeric_limits<unsigned long long>
  : public ::std::priv:: _Integer_limits<unsigned long long, 0, 0xffffffffffffffffULL, -1, true>
{};


namespace priv {

// Specializations for all built-in floating-point types.
template <class __dummy>
class _LimG {
public:
  static float  get_F_inf();
  static float  get_F_qNaN();
  static float  get_F_sNaN();
  static float  get_F_denormMin();
  static double  get_D_inf();
  static double  get_D_qNaN();
  static double  get_D_sNaN();
  static double  get_D_denormMin();

  static long double  get_LD_inf();
  static long double  get_LD_qNaN();
  static long double  get_LD_sNaN();
  static long double  get_LD_denormMin();
};



/*****************************************************************************/
/* Subnormals are not fully supported.                                       */
/*****************************************************************************/

/* If compiler do not expose thanks to some macro its status regarding
 * denormalized floating point numbers, we consider that denormalization
 * is present. Unit tests will tell us if compiler do not support them. */



}

template< >
class numeric_limits<float>
  : public ::std::priv:: _Floating_limits<float,
                                       24,   // Binary digits of precision
                                       6,        // Decimal digits of precision
                                       (-125),    // Minimum exponent
                                       128,    // Maximum exponent
                                       (-37), // Minimum base 10 exponent
                                       38, // Maximum base 10 exponent
                                       true,
                                       denorm_absent,
                                       round_to_nearest> {
public:
  static float ( min) ()  { return 1.175494351E-38F; }
  static float  denorm_min() 
  { return denorm_absent ? ::std::priv:: _LimG<bool>::get_F_denormMin() : 1.175494351E-38F; }
  static float ( max) ()  { return 3.402823466E+38F; }
  static float  epsilon()  { return 1.192092896E-07F; }
  static float  round_error()  { return 0.5f; } // Units: ulps.
  static  float  infinity()  { return ::std::priv:: _LimG<bool>::get_F_inf(); }
  static  float  quiet_NaN()  { return ::std::priv:: _LimG<bool>::get_F_qNaN(); }
  static  float  signaling_NaN()  { return ::std::priv:: _LimG<bool>::get_F_sNaN(); }
};


template< >
class numeric_limits<double>
  : public ::std::priv:: _Floating_limits<double,
                                       53,   // Binary digits of precision
                                       15,        // Decimal digits of precision
                                       (-1021),    // Minimum exponent
                                       1024,    // Maximum exponent
                                       (-307), // Minimum base 10 exponent
                                       308, // Maximum base 10 exponent
                                       true,
                                       denorm_absent,
                                       round_to_nearest> {
public:
  static double ( min)()  { return 2.2250738585072014E-308; }
  static double  denorm_min() 
  { return denorm_absent ? ::std::priv:: _LimG<bool>::get_D_denormMin() : 2.2250738585072014E-308; }
  static double ( max)()  { return 1.7976931348623157E+308; }
  static double  epsilon()  { return 2.2204460492503131E-16; }
  static double  round_error()  { return 0.5; } // Units: ulps.
  static  double  infinity()  { return ::std::priv:: _LimG<bool>::get_D_inf(); }
  static  double  quiet_NaN()  { return ::std::priv:: _LimG<bool>::get_D_qNaN(); }
  static  double  signaling_NaN()  { return ::std::priv:: _LimG<bool>::get_D_sNaN(); }
};


template< >
class numeric_limits<long double>
  : public ::std::priv:: _Floating_limits<long double,
                                       53,  // Binary digits of precision
                                       15,       // Decimal digits of precision
                                       (-1021),   // Minimum exponent
                                       1024,   // Maximum exponent
                                       (-307),// Minimum base 10 exponent
                                       308,// Maximum base 10 exponent
                                       false,          // do not conform to iec559
                                       denorm_absent,
                                       round_to_nearest> {
public:
  static long double ( min) ()  { return 2.2250738585072014E-308L; }
  static long double  denorm_min() 
  { return denorm_absent ? ::std::priv:: _LimG<bool>::get_LD_denormMin() : 2.2250738585072014E-308L; }
  static const  bool is_iec559 = false;
  static long double ( max) ()  { return 1.7976931348623157E+308L; }
  static long double  epsilon()  { return 2.2204460492503131E-16L; }
  static long double  round_error()  { return 0.5l; }
  static long double  infinity() 
  //For MSVC, long double is nothing more than an alias for double.
  { return ::std::priv:: _LimG<bool>::get_LD_inf(); }
  static long double  quiet_NaN() 
  { return ::std::priv:: _LimG<bool>::get_LD_qNaN(); }
  static long double  signaling_NaN() 
  { return ::std::priv:: _LimG<bool>::get_LD_sNaN(); }
};


// We write special values (Inf and NaN) as bit patterns and
// cast the the appropriate floating-point types.
}

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1998,1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */



//==========================================================
//  numeric_limits static members
//==========================================================

namespace std {

namespace priv {



template <class __number> const bool _Numeric_limits_base<__number> :: is_specialized;
template <class __number> const int _Numeric_limits_base<__number> :: digits;
template <class __number> const int _Numeric_limits_base<__number> :: digits10;
template <class __number> const bool _Numeric_limits_base<__number> :: is_signed;
template <class __number> const bool _Numeric_limits_base<__number> :: is_integer;
template <class __number> const bool _Numeric_limits_base<__number> :: is_exact;
template <class __number> const int _Numeric_limits_base<__number> :: radix;
template <class __number> const int _Numeric_limits_base<__number> :: min_exponent;
template <class __number> const int _Numeric_limits_base<__number> :: max_exponent;
template <class __number> const int _Numeric_limits_base<__number> :: min_exponent10;
template <class __number> const int _Numeric_limits_base<__number> :: max_exponent10;
template <class __number> const bool _Numeric_limits_base<__number> :: has_infinity;
template <class __number> const bool _Numeric_limits_base<__number> :: has_quiet_NaN;
template <class __number> const bool _Numeric_limits_base<__number> :: has_signaling_NaN;
template <class __number> const float_denorm_style _Numeric_limits_base<__number> :: has_denorm;
template <class __number> const bool _Numeric_limits_base<__number> :: has_denorm_loss;
template <class __number> const bool _Numeric_limits_base<__number> :: is_iec559;
template <class __number> const bool _Numeric_limits_base<__number> :: is_bounded;
template <class __number> const bool _Numeric_limits_base<__number> :: is_modulo;
template <class __number> const bool _Numeric_limits_base<__number> :: traps;
template <class __number> const bool _Numeric_limits_base<__number> :: tinyness_before;
template <class __number> const float_round_style _Numeric_limits_base<__number> :: round_style;



template <class _Int, _Int __imin, _Int __imax, int __idigits, bool __ismod> const bool _Integer_limits<_Int, __imin, __imax, __idigits, __ismod> :: is_specialized;
template <class _Int, _Int __imin, _Int __imax, int __idigits, bool __ismod> const int _Integer_limits<_Int, __imin, __imax, __idigits, __ismod> :: digits;
template <class _Int, _Int __imin, _Int __imax, int __idigits, bool __ismod> const int _Integer_limits<_Int, __imin, __imax, __idigits, __ismod> :: digits10;
template <class _Int, _Int __imin, _Int __imax, int __idigits, bool __ismod> const bool _Integer_limits<_Int, __imin, __imax, __idigits, __ismod> :: is_signed;
template <class _Int, _Int __imin, _Int __imax, int __idigits, bool __ismod> const bool _Integer_limits<_Int, __imin, __imax, __idigits, __ismod> :: is_integer;
template <class _Int, _Int __imin, _Int __imax, int __idigits, bool __ismod> const bool _Integer_limits<_Int, __imin, __imax, __idigits, __ismod> :: is_exact;
template <class _Int, _Int __imin, _Int __imax, int __idigits, bool __ismod> const int _Integer_limits<_Int, __imin, __imax, __idigits, __ismod> :: radix;
template <class _Int, _Int __imin, _Int __imax, int __idigits, bool __ismod> const bool _Integer_limits<_Int, __imin, __imax, __idigits, __ismod> :: is_bounded;
template <class _Int, _Int __imin, _Int __imax, int __idigits, bool __ismod> const bool _Integer_limits<_Int, __imin, __imax, __idigits, __ismod> :: is_modulo;



template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: is_specialized;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const int _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: digits;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const int _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: digits10;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: is_signed;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const int _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: radix;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const int _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: min_exponent;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const int _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: max_exponent;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const int _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: min_exponent10;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const int _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: max_exponent10;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: has_infinity;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: has_quiet_NaN;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: has_signaling_NaN;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const float_denorm_style _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: has_denorm;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: has_denorm_loss;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: is_iec559;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: is_bounded;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: traps;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: tinyness_before;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const float_round_style _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle> :: round_style;





/* The following code has been extracted from the boost libraries (www.boost.org) and
 * adapted with the STLport portability macros. Advantage on previous technique is that
 * computation of infinity and NaN values is only based on big/little endianess, compiler
 * float, double or long double representation is taken into account thanks to the sizeof
 * operator. */
template<class _Number, unsigned short _Word>
struct float_helper {
  union _WordsNumber {
    unsigned short _Words[8];
    _Number _num;
  };
  static _Number get_word_higher()  {
    _WordsNumber __tmp = {  _Word, 0, 0, 0, 0, 0, 0, 0  };
    return __tmp._num;
  } 
  static _Number get_word_lower()  {
    _WordsNumber __tmp = {  0, 0, 0, 0, 0, 0, 0, 0  };
    __tmp._Words[(sizeof(_Number) >= 12 ? 10 : sizeof(_Number)) / sizeof(unsigned short) - 1] = _Word;
    return __tmp._num;
  }
  static _Number get_from_last_word()  {
    return get_word_lower();
  }
  static _Number get_from_first_word()  {
    return get_word_higher();
  }
};

template<class _Number, unsigned short _Word1, unsigned short _Word2>
struct float_helper2 {
  union _WordsNumber {
    unsigned short _Words[8];
    _Number _num;
  };
  //static _Number get_word_higher() _STLP_NOTHROW {
  //  _WordsNumber __tmp = { _STLP_ADDITIONAL_OPEN_BRACKET _Word1, _Word2, 0, 0, 0, 0, 0, 0 _STLP_ADDITIONAL_CLOSE_BRACKET };
  //  return __tmp._num;
  //} 
  static _Number get_word_lower()  {
    _WordsNumber __tmp = {  0, 0, 0, 0, 0, 0, 0, 0  };
    __tmp._Words[(sizeof(_Number) >= 12 ? 10 : sizeof(_Number)) / sizeof(unsigned short) - 2] = _Word1;
    __tmp._Words[(sizeof(_Number) >= 12 ? 10 : sizeof(_Number)) / sizeof(unsigned short) - 1] = _Word2;
    return __tmp._num;
  }
  static _Number get_from_last_word()  {
//#    if defined (_STLP_BIG_ENDIAN)
//    return get_word_higher();
//#    else /* _STLP_LITTLE_ENDIAN */
    return get_word_lower();
//#    endif
  }
};

/* Former values kept in case moving to boost code has introduce a regression on
 * some platform. */

template <class __dummy>
float  _LimG<__dummy>::get_F_inf() {
  typedef float_helper<float, 0x7f80u> _FloatHelper;
  return _FloatHelper::get_from_last_word();
}
template <class __dummy>
float  _LimG<__dummy>::get_F_qNaN() {
  typedef float_helper<float, 0x7f81u> _FloatHelper;
  return _FloatHelper::get_from_last_word();
}
template <class __dummy>
float  _LimG<__dummy>::get_F_sNaN() {
  typedef float_helper<float, 0x7fc1u> _FloatHelper;
  return _FloatHelper::get_from_last_word();
}
template <class __dummy>
float  _LimG<__dummy>::get_F_denormMin() {
  typedef float_helper<float, 0x0001u> _FloatHelper;
  return _FloatHelper::get_from_first_word();
}

template <int __use_double_limits>
class _NumericLimitsAccess;

template< >
class _NumericLimitsAccess<1> {
public:
  static double get_inf() {
    typedef float_helper<double, 0x7ff0u> _FloatHelper;
    return _FloatHelper::get_from_last_word();
  }
  static double get_qNaN() {
    typedef float_helper<double, 0x7ff1u> _FloatHelper;
    return _FloatHelper::get_from_last_word();
  }
  static double get_sNaN() {
    typedef float_helper<double, 0x7ff9u> _FloatHelper;
    return _FloatHelper::get_from_last_word();
  }
};

template <class __dummy>
double  _LimG<__dummy>::get_D_inf()
{ return _NumericLimitsAccess<1>::get_inf(); }
template <class __dummy>
double  _LimG<__dummy>::get_D_qNaN()
{ return _NumericLimitsAccess<1>::get_qNaN(); }
template <class __dummy>
double  _LimG<__dummy>::get_D_sNaN()
{ return _NumericLimitsAccess<1>::get_sNaN(); }
template <class __dummy>
double  _LimG<__dummy>::get_D_denormMin() {
  typedef float_helper<double, 0x0001u> _FloatHelper;
  return _FloatHelper::get_from_first_word();
}

template< >
class _NumericLimitsAccess<0> {
public:
  static long double get_inf() {
    typedef float_helper2<long double, 0x8000u, 0x7fffu> _FloatHelper;
    return _FloatHelper::get_from_last_word();
  }
  static long double get_qNaN() {
    typedef float_helper2<long double, 0xc000u, 0x7fffu> _FloatHelper;
    return _FloatHelper::get_from_last_word();
  }
  static long double get_sNaN() {
    typedef float_helper2<long double, 0x9000u, 0x7fffu> _FloatHelper;
    return _FloatHelper::get_from_last_word();
  }
};

template <class __dummy>
long double  _LimG<__dummy>::get_LD_inf() {
  const int __use_double_limits = sizeof(double) == sizeof(long double) ? 1 : 0;
  return _NumericLimitsAccess<__use_double_limits>::get_inf();
}
template <class __dummy>
long double  _LimG<__dummy>::get_LD_qNaN() {
  const int __use_double_limits = sizeof(double) == sizeof(long double) ? 1 : 0;
  return _NumericLimitsAccess<__use_double_limits>::get_qNaN();
}
template <class __dummy>
long double  _LimG<__dummy>::get_LD_sNaN() {
  const int __use_double_limits = sizeof(double) == sizeof(long double) ? 1 : 0;
  return _NumericLimitsAccess<__use_double_limits>::get_sNaN();
}
template <class __dummy>
long double  _LimG<__dummy>::get_LD_denormMin() {
  typedef float_helper<long double, 0x0001u> _FloatHelper;
  return _FloatHelper::get_from_first_word();
}



}

}



// Local Variables:
// mode:C++
// End:

namespace std {

namespace priv {

// __do_put_float and its helper functions.  Strategy: write the output
// to a buffer of char, transform the buffer to _CharT, and then copy
// it to the output.

//----------------------------------------------------------------------
// num_put facet

template <class _CharT, class _OutputIter>
_OutputIter  
__copy_float_and_fill(const _CharT* __first, const _CharT* __last,
                      _OutputIter __oi,
                      ios_base::fmtflags __flags,
                      streamsize __width, _CharT __fill,
                      _CharT __xplus, _CharT __xminus) {
  if (__width <= __last - __first)
    return ::std::copy(__first, __last, __oi);
  else {
    streamsize __pad = __width - (__last - __first);
    ios_base::fmtflags __dir = __flags & ios_base::adjustfield;

    if (__dir == ios_base::left) {
      __oi = ::std::copy(__first, __last, __oi);
      return ::std::priv:: __fill_n(__oi, __pad, __fill);
    }
    else if (__dir == ios_base::internal && __first != __last &&
             (*__first == __xplus || *__first == __xminus)) {
      *__oi++ = *__first++;
      __oi = ::std::priv:: __fill_n(__oi, __pad, __fill);
      return ::std::copy(__first, __last, __oi);
    }
    else {
      __oi = ::std::priv:: __fill_n(__oi, __pad, __fill);
      return ::std::copy(__first, __last, __oi);
    }
  }
}

// Helper routine for wchar_t
template <class _OutputIter>
_OutputIter  
__put_float(__iostring &__str, _OutputIter __oi,
            ios_base& __f, wchar_t __fill,
            wchar_t __decimal_point, wchar_t __sep,
            size_t __group_pos, const string& __grouping) {
  const ctype<wchar_t>& __ct = use_facet<ctype<wchar_t> >(__f.getloc());

  __iowstring __wbuf;
  __convert_float_buffer(__str, __wbuf, __ct, __decimal_point);

  if (!__grouping.empty()) {
    __insert_grouping(__wbuf, __group_pos, __grouping,
                      __sep, __ct.widen('+'), __ct.widen('-'), 0);
  }

  return __copy_float_and_fill(__wbuf.data(), __wbuf.data() + __wbuf.size(), __oi,
                               __f.flags(), __f.width(0), __fill, __ct.widen('+'), __ct.widen('-'));
}

// Helper routine for char
template <class _OutputIter>
_OutputIter  
__put_float(__iostring &__str, _OutputIter __oi,
            ios_base& __f, char __fill,
            char __decimal_point, char __sep,
            size_t __group_pos, const string& __grouping) {
  if ((__group_pos < __str.size()) && (__str[__group_pos] == '.')) {
    __str[__group_pos] = __decimal_point;
  }

  if (!__grouping.empty()) {
    __insert_grouping(__str, __group_pos,
                      __grouping, __sep, '+', '-', 0);
  }

  return __copy_float_and_fill(__str.data(), __str.data() + __str.size(), __oi,
                               __f.flags(), __f.width(0), __fill, '+', '-');
}

template <class _CharT, class _OutputIter, class _Float>
_OutputIter 
__do_put_float(_OutputIter __s, ios_base& __f,
                _CharT __fill, _Float __x) {
  __iostring __buf;

  size_t __group_pos = __write_float(__buf, __f.flags(), (int)__f.precision(), __x);

  const numpunct<_CharT>& __np = use_facet<numpunct<_CharT> >(__f.getloc());
  return __put_float(__buf, __s, __f, __fill,
                     __np.decimal_point(), __np.thousands_sep(),
                     __group_pos, __np.grouping());
}

inline void __get_money_digits_aux (__iostring &__buf, ios_base &, long double __x)
{ __get_floor_digits(__buf, __x); }

inline void __get_money_digits_aux (__iowstring &__wbuf, ios_base &__f, long double __x) {
  __iostring __buf;
  __get_floor_digits(__buf, __x);

  const ctype<wchar_t>& __ct = use_facet<ctype<wchar_t> >(__f.getloc());
  __convert_float_buffer(__buf, __wbuf, __ct, wchar_t(0), false);
}

template <class _CharT>
void  __get_money_digits(::std::priv:: __basic_iostring<_CharT> &__buf, ios_base& __f, long double __x)
{ __get_money_digits_aux(__buf, __f, __x); }

// _M_do_put_integer and its helper functions.

template <class _CharT, class _OutputIter>
_OutputIter 
__copy_integer_and_fill(const _CharT* __buf, ptrdiff_t __len,
                        _OutputIter __oi,
                        ios_base::fmtflags __flg, streamsize __wid, _CharT __fill,
                        _CharT __xplus, _CharT __xminus) {
  if (__len >= __wid)
    return ::std::copy(__buf, __buf + __len, __oi);
  else {
    //casting numeric_limits<ptrdiff_t>::max to streamsize only works is ptrdiff_t is signed or streamsize representation
    //is larger than ptrdiff_t one.
    typedef char __static_assert[(sizeof(streamsize) > sizeof(ptrdiff_t)) || ((sizeof(streamsize) == sizeof(ptrdiff_t)) && numeric_limits<ptrdiff_t> ::is_signed) ? 1 : -1];
    ptrdiff_t __pad = static_cast<ptrdiff_t>((min) (static_cast<streamsize>((numeric_limits<ptrdiff_t> ::max)()), static_cast<streamsize>(__wid - __len)));
    ios_base::fmtflags __dir = __flg & ios_base::adjustfield;

    if (__dir == ios_base::left) {
      __oi = ::std::copy(__buf, __buf + __len, __oi);
      return ::std::priv:: __fill_n(__oi, __pad, __fill);
    }
    else if (__dir == ios_base::internal && __len != 0 &&
             (__buf[0] == __xplus || __buf[0] == __xminus)) {
      *__oi++ = __buf[0];
      __oi = __fill_n(__oi, __pad, __fill);
      return ::std::copy(__buf + 1, __buf + __len, __oi);
    }
    else if (__dir == ios_base::internal && __len >= 2 &&
             (__flg & ios_base::showbase) &&
             (__flg & ios_base::basefield) == ios_base::hex) {
      *__oi++ = __buf[0];
      *__oi++ = __buf[1];
      __oi = __fill_n(__oi, __pad, __fill);
      return ::std::copy(__buf + 2, __buf + __len, __oi);
    }
    else {
      __oi = __fill_n(__oi, __pad, __fill);
      return ::std::copy(__buf, __buf + __len, __oi);
    }
  }
}

// Helper function for wchar_t
template <class _OutputIter>
_OutputIter 
__put_integer(char* __buf, char* __iend, _OutputIter __s,
              ios_base& __f,
              ios_base::fmtflags __flags, wchar_t __fill) {
  locale __loc = __f.getloc();
  const ctype<wchar_t>& __ct = use_facet<ctype<wchar_t> >(__loc);

  wchar_t __xplus  = __ct.widen('+');
  wchar_t __xminus = __ct.widen('-');

  wchar_t __wbuf[64];
  __ct.widen(__buf, __iend, __wbuf);
  ptrdiff_t __len = __iend - __buf;
  wchar_t* __eend = __wbuf + __len;

  const numpunct<wchar_t>& __np = use_facet<numpunct<wchar_t> >(__loc);
  const string& __grouping = __np.grouping();

  if (!__grouping.empty()) {
    int __basechars;
    if (__flags & ios_base::showbase)
      switch (__flags & ios_base::basefield) {
        case ios_base::hex: __basechars = 2; break;
        case ios_base::oct: __basechars = 1; break;
        default: __basechars = 0;
      }
    else
      __basechars = 0;

    __len = __insert_grouping(__wbuf, __eend, __grouping, __np.thousands_sep(),
                              __xplus, __xminus, __basechars);
  }

  return __copy_integer_and_fill((wchar_t*)__wbuf, __len, __s,
                                 __flags, __f.width(0), __fill, __xplus, __xminus);
}

// Helper function for char
template <class _OutputIter>
_OutputIter 
__put_integer(char* __buf, char* __iend, _OutputIter __s,
              ios_base& __f, ios_base::fmtflags __flags, char __fill) {
  char __grpbuf[64];
  ptrdiff_t __len = __iend - __buf;

  const numpunct<char>& __np = use_facet<numpunct<char> >(__f.getloc());
  const string& __grouping = __np.grouping();

  if (!__grouping.empty()) {
    int __basechars;
    if (__flags & ios_base::showbase)
      switch (__flags & ios_base::basefield) {
        case ios_base::hex: __basechars = 2; break;
        case ios_base::oct: __basechars = 1; break;
        default: __basechars = 0;
      }
    else
      __basechars = 0;

     // make sure there is room at the end of the buffer
     // we pass to __insert_grouping
    ::std::copy(__buf, __iend, (char *) __grpbuf);
    __buf = __grpbuf;
    __iend = __grpbuf + __len;
    __len = __insert_grouping(__buf, __iend, __grouping, __np.thousands_sep(),
                              '+', '-', __basechars);
  }

  return __copy_integer_and_fill(__buf, __len, __s, __flags, __f.width(0), __fill, '+', '-');
}

typedef long long __max_int_t;
typedef unsigned long long __umax_int_t;

 const char*  __hex_char_table_lo();
 const char*  __hex_char_table_hi();

template <class _Integer>
inline char* 
__write_decimal_backward(char* __ptr, _Integer __x, ios_base::fmtflags __flags, const __true_type& /* is_signed */) {
  const bool __negative = __x < 0 ;
  __max_int_t __temp = __x;
  __umax_int_t __utemp = __negative?-__temp:__temp;

  for (; __utemp != 0; __utemp /= 10)
    *--__ptr = (char)((int)(__utemp % 10) + '0');
  // put sign if needed or requested
  if (__negative)
    *--__ptr = '-';
  else if (__flags & ios_base::showpos)
    *--__ptr = '+';
  return __ptr;
}

template <class _Integer>
inline char* 
__write_decimal_backward(char* __ptr, _Integer __x, ios_base::fmtflags __flags, const __false_type& /* is_signed */) {
  for (; __x != 0; __x /= 10)
    *--__ptr = (char)((int)(__x % 10) + '0');
  // put sign if requested
  if (__flags & ios_base::showpos)
    *--__ptr = '+';
  return __ptr;
}

template <class _Integer>
char* 
__write_integer_backward(char* __buf, ios_base::fmtflags __flags, _Integer __x) {
  char* __ptr = __buf;

  if (__x == 0) {
    *--__ptr = '0';
    if ((__flags & ios_base::showpos) && ((__flags & (ios_base::oct | ios_base::hex)) == 0))
      *--__ptr = '+';
    // oct or hex base shall not be added to the 0 value (see '#' flag in C formating strings)
  }
  else {
    switch (__flags & ios_base::basefield) {
      case ios_base::oct:
        {
          __umax_int_t __temp = __x;
          // if the size of integer is less than 8, clear upper part
          if ( sizeof(__x) < 8  && sizeof(__umax_int_t) >= 8 )
            __temp &= 0xFFFFFFFF;

          for (; __temp != 0; __temp >>=3)
            *--__ptr = (char)((((unsigned)__temp)& 0x7) + '0');

          // put leading '0' if showbase is set
          if (__flags & ios_base::showbase)
            *--__ptr = '0';
        }
        break;
      case ios_base::hex:
        {
          const char* __table_ptr = (__flags & ios_base::uppercase) ?
            __hex_char_table_hi() : __hex_char_table_lo();
          __umax_int_t __temp = __x;
          // if the size of integer is less than 8, clear upper part
          if ( sizeof(__x) < 8  && sizeof(__umax_int_t) >= 8 )
            __temp &= 0xFFFFFFFF;

          for (; __temp != 0; __temp >>=4)
            *--__ptr = __table_ptr[((unsigned)__temp & 0xF)];

          if (__flags & ios_base::showbase) {
            *--__ptr = __table_ptr[16];
            *--__ptr = '0';
          }
        }
        break;
      //case ios_base::dec:
      default:
        {
          typedef typename __bool2type<numeric_limits<_Integer>::is_signed>::_Ret _IsSigned;
          __ptr = __write_decimal_backward(__ptr, __x, __flags, _IsSigned());
        }
        break;
    }
  }

  // return pointer to beginning of the string
  return __ptr;
}

template <class _CharT, class _OutputIter, class _Integer>
_OutputIter 
__do_put_integer(_OutputIter __s, ios_base& __f, _CharT __fill, _Integer __x) {
  // buffer size = number of bytes * number of digit necessary in the smallest Standard base (base 8, 3 digits/byte)
  //               plus the longest base representation '0x'
  // Do not use __buf_size to define __buf static buffer, some compilers (HP aCC) do not accept const variable as
  // the specification of a static buffer size.
  char __buf[sizeof(_Integer) * 3 + 2];
  const ptrdiff_t __buf_size = sizeof(__buf) / sizeof(char);
  ios_base::fmtflags __flags = __f.flags();
  char* __ibeg = __write_integer_backward((char*)__buf + __buf_size, __flags, __x);
  return __put_integer(__ibeg, (char*)__buf + __buf_size, __s, __f, __flags, __fill);
}

template <class _CharT, class _OutputIter>
_OutputIter 
__do_put_bool(_OutputIter __s, ios_base& __f, _CharT __fill, bool __x) {
  const numpunct<_CharT>& __np = use_facet<numpunct<_CharT> >(__f.getloc());

  basic_string<_CharT, char_traits<_CharT>, allocator<_CharT> > __str = __x ? __np.truename() : __np.falsename();

  streamsize __wid = __f.width(0);
  if (__str.size() >= static_cast<size_t>(__wid))
    return ::std::copy(__str.begin(), __str.end(), __s);
  else {
    streamsize __pad = __wid - __str.size();
    ios_base::fmtflags __dir = __f.flags() & ios_base::adjustfield;

    if (__dir == ios_base::left) {
      __s = ::std::copy(__str.begin(), __str.end(), __s);
      return __fill_n(__s, __pad, __fill);
    }
    else /* covers right and internal padding */ {
      __s = __fill_n(__s, __pad, __fill);
      return ::std::copy(__str.begin(), __str.end(), __s);
    }
  }
}
}

//
// num_put<>
//

template <class _CharT, class _OutputIterator>
locale::id num_put<_CharT, _OutputIterator>::id;

template <class _CharT, class _OutputIter>
_OutputIter
num_put<_CharT, _OutputIter>::do_put(_OutputIter __s, ios_base& __f, _CharT __fill,
                                     bool __val) const {
  if (!(__f.flags() & ios_base::boolalpha))
    // 22.2.2.2.2.23: shall return do_put for int and not directly __do_put_integer.
    return do_put(__s, __f, __fill, static_cast<long>(__val));

  return ::std::priv:: __do_put_bool(__s, __f, __fill, __val);
}

template <class _CharT, class _OutputIter>
_OutputIter
num_put<_CharT, _OutputIter>::do_put(_OutputIter __s, ios_base& __f, _CharT __fill,
                                     long __val) const
{ return ::std::priv:: __do_put_integer(__s, __f, __fill, __val); }

template <class _CharT, class _OutputIter>
_OutputIter
num_put<_CharT, _OutputIter>::do_put(_OutputIter __s, ios_base& __f, _CharT __fill,
                                     unsigned long __val) const
{ return ::std::priv:: __do_put_integer(__s, __f, __fill, __val); }

template <class _CharT, class _OutputIter>
_OutputIter
num_put<_CharT, _OutputIter>::do_put(_OutputIter __s, ios_base& __f, _CharT __fill,
                                     double __val) const
{ return ::std::priv:: __do_put_float(__s, __f, __fill, __val); }

template <class _CharT, class _OutputIter>
_OutputIter
num_put<_CharT, _OutputIter>::do_put(_OutputIter __s, ios_base& __f, _CharT __fill,
                                     long double __val) const
{ return ::std::priv:: __do_put_float(__s, __f, __fill, __val); }

template <class _CharT, class _OutputIter>
_OutputIter
num_put<_CharT, _OutputIter>::do_put(_OutputIter __s, ios_base& __f, _CharT __fill,
                                     long long __val) const
{ return ::std::priv:: __do_put_integer(__s, __f, __fill, __val); }

template <class _CharT, class _OutputIter>
_OutputIter
num_put<_CharT, _OutputIter>::do_put(_OutputIter __s, ios_base& __f, _CharT __fill,
                                     unsigned long long __val) const
{ return ::std::priv:: __do_put_integer(__s, __f, __fill, __val); }


// 22.2.2.2.2 Stage 1: "For conversion from void* the specifier is %p."
// This is not clear and I'm really don't follow this (below).
template <class _CharT, class _OutputIter>
_OutputIter
num_put<_CharT, _OutputIter>::do_put(_OutputIter __s, ios_base& __f, _CharT /*__fill*/,
                                     const void* __val) const {
  const ctype<_CharT>& __c_type = use_facet<ctype<_CharT> >(__f.getloc());
  ios_base::fmtflags __save_flags = __f.flags();

  __f.setf(ios_base::hex, ios_base::basefield);
  __f.setf(ios_base::showbase);
  __f.setf(ios_base::internal, ios_base::adjustfield);
  __f.width((sizeof(void*) * 2) + 2); // digits in pointer type plus '0x' prefix
  if ( __val == 0 ) {
    // base ('0x') not shown for null, but I really want to type it
    // for pointer. Print it first in this case.
    const char* __table_ptr = (__save_flags & ios_base::uppercase) ?
            ::std::priv:: __hex_char_table_hi() : ::std::priv:: __hex_char_table_lo();
    *(__s++) = __c_type.widen( '0' );
    *(__s++) = __c_type.widen( __table_ptr[16] );
    __f.width((sizeof(void*) * 2)); // digits in pointer type
  } else {
    __f.width((sizeof(void*) * 2) + 2); // digits in pointer type plus '0x' prefix
  }
  _OutputIter result =
    ( sizeof(void*) == sizeof(unsigned long) ) ?
    ::std::priv:: __do_put_integer(__s, __f, __c_type.widen('0'), reinterpret_cast<unsigned long>(__val))
      : /* ( sizeof(void*) == sizeof(unsigned _STLP_LONG_LONG) ) ? */
    ::std::priv:: __do_put_integer(__s, __f, __c_type.widen('0'), reinterpret_cast<unsigned long long>(__val))
        ;
  __f.flags(__save_flags);
  return result;
}

}


// Local Variables:
// mode:C++
// End:


// Local Variables:
// mode:C++
// End:

namespace std {

//----------------------------------------------------------------------
// Definitions of non-inline member functions.

// Constructor, destructor

template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>::basic_ostream(basic_streambuf<_CharT, _Traits>* __buf)
    : basic_ios<_CharT, _Traits>() {
  this->init(__buf);
}

template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>::~basic_ostream()
{}

// Output directly from a streambuf.
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>&
basic_ostream<_CharT, _Traits>::operator<<(basic_streambuf<_CharT, _Traits>* __from) {
  sentry __sentry(*this);
  if (__sentry) {
    if (__from) {
      bool __any_inserted = __from->gptr() != __from->egptr()
        ? this->_M_copy_buffered(__from, this->rdbuf())
        : this->_M_copy_unbuffered(__from, this->rdbuf());
      if (!__any_inserted)
        this->setstate(ios_base::failbit);
    }
    else
      this->setstate(ios_base::badbit);
  }

  return *this;
}

// Helper functions for the streambuf version of operator<<.  The
// exception-handling code is complicated because exceptions thrown
// while extracting characters are treated differently than exceptions
// thrown while inserting characters.

template <class _CharT, class _Traits>
bool basic_ostream<_CharT, _Traits>
  ::_M_copy_buffered(basic_streambuf<_CharT, _Traits>* __from,
                     basic_streambuf<_CharT, _Traits>* __to) {
  bool __any_inserted = false;

  while (__from->egptr() != __from->gptr()) {
    const ptrdiff_t __avail = __from->egptr() - __from->gptr();

    streamsize __nwritten;
     {
      __nwritten = __to->sputn(__from->gptr(), __avail);
      __from->gbump((int)__nwritten);
    }
    if (false) {
      this->_M_handle_exception(ios_base::badbit);
      return __any_inserted;
    }

    if (__nwritten == __avail) {
       {
        if (this->_S_eof(__from->sgetc()))
          return true;
        else
          __any_inserted = true;
      }
      if (false) {
        this->_M_handle_exception(ios_base::failbit);
        return false;
      }
    }
    else if (__nwritten != 0)
      return true;
    else
      return __any_inserted;
  }

  // No characters are in the buffer, but we aren't at EOF.  Switch to
  // unbuffered mode.
  return __any_inserted || this->_M_copy_unbuffered(__from, __to);
}

/*
 * Helper struct (guard) to put back a character in a streambuf
 * whenever an exception or an eof occur.
 */
template <class _CharT, class _Traits>
struct _SPutBackC {
  typedef basic_streambuf<_CharT, _Traits> _StreamBuf;
  typedef typename _StreamBuf::int_type int_type;
  _SPutBackC(_StreamBuf *pfrom)
    : __pfrom(pfrom), __c(0), __do_guard(false) {}
  ~_SPutBackC() {
    if (__do_guard) {
      __pfrom->sputbackc(_Traits::to_char_type(__c));
    }
  }

  void guard(int_type c) {
    __c = c;
    __do_guard = true;
  }
  void release() {
    __do_guard = false;
  }

private:
  _StreamBuf *__pfrom;
  int_type __c;
  bool __do_guard;
};

template <class _CharT, class _Traits>
bool basic_ostream<_CharT, _Traits>
  ::_M_copy_unbuffered(basic_streambuf<_CharT, _Traits>* __from,
                       basic_streambuf<_CharT, _Traits>* __to) {
  typedef _SPutBackC<_CharT, _Traits> _SPutBackCGuard;
  bool __any_inserted = false;
  int_type __c;

   {
    _SPutBackCGuard __cguard(__from);
    for (;;) {
       {
        __c = __from->sbumpc();
      }
      if (false) {
        this->_M_handle_exception(ios_base::failbit);
        break;
      }

      if (this->_S_eof(__c))
        break;

      __cguard.guard(__c);
      if (this->_S_eof(__to->sputc(_Traits::to_char_type(__c))))
        break;

      __cguard.release();
      __any_inserted = true;
    }
  }
  if (false) {
    this->_M_handle_exception(ios_base::badbit);
  }
  return __any_inserted;
}

namespace priv {

// Helper function for numeric output.
template <class _CharT, class _Traits, class _Number>
basic_ostream<_CharT, _Traits>&  
__put_num(basic_ostream<_CharT, _Traits>& __os, _Number __x) {
  typedef typename basic_ostream<_CharT, _Traits>::sentry _Sentry;
  _Sentry __sentry(__os);
  bool __failed = true;

  if (__sentry) {
     {
      typedef num_put<_CharT, ostreambuf_iterator<_CharT, _Traits> > _NumPut;
      __failed = (use_facet<_NumPut>(__os.getloc())).put(ostreambuf_iterator<_CharT, _Traits>(__os.rdbuf()),
                                                         __os, __os.fill(),
                                                         __x).failed();
    }
    if (false) {
      __os._M_handle_exception(ios_base::badbit);
    }
  }
  if (__failed)
    __os.setstate(ios_base::badbit);
  return __os;
}

}

/*
 * In the following operators we try to limit code bloat by limiting the
 * number of __put_num instanciations.
 */
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(short __x) {
  typedef char __static_assert[sizeof(short) <= sizeof(long) ? 1 : -1];
  long __tmp = ((this->flags() & _Basic_ios::basefield) != ios_base::dec) ?
                  static_cast<long>(static_cast<unsigned short>(__x)): __x;
  return ::std::priv:: __put_num(*this, __tmp);
}

template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(unsigned short __x) {
  typedef char __static_assert[sizeof(unsigned short) <= sizeof(unsigned long) ? 1 : -1];
  return ::std::priv:: __put_num(*this, static_cast<unsigned long>(__x));
}

template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(int __x) {
  typedef char __static_assert[sizeof(int) <= sizeof(long) ? 1 : -1];
  long __tmp = ((this->flags() & _Basic_ios::basefield) != ios_base::dec) ?
                  static_cast<long>(static_cast<unsigned int>(__x)): __x;
  return ::std::priv:: __put_num(*this, __tmp);
}

template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(unsigned int __x) {
  typedef char __static_assert[sizeof(unsigned int) <= sizeof(unsigned long) ? 1 : -1];
  return ::std::priv:: __put_num(*this,  static_cast<unsigned long>(__x));
}

template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(long __x)
{ return ::std::priv:: __put_num(*this,  __x); }

template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(unsigned long __x)
{ return ::std::priv:: __put_num(*this,  __x); }

template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<< (long long __x)
{ return ::std::priv:: __put_num(*this,  __x); }

template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<< (unsigned long long __x)
{ return ::std::priv:: __put_num(*this,  __x); }

template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(float __x)
{ return ::std::priv:: __put_num(*this,  static_cast<double>(__x)); }

template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(double __x)
{ return ::std::priv:: __put_num(*this,  __x); }

template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(long double __x)
{ return ::std::priv:: __put_num(*this,  __x); }

template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(const void* __x)
{ return ::std::priv:: __put_num(*this,  __x); }

template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(bool __x)
{ return ::std::priv:: __put_num(*this,  __x); }

template <class _CharT, class _Traits>
void basic_ostream<_CharT, _Traits>::_M_put_char(_CharT __c) {
  sentry __sentry(*this);
  if (__sentry) {
    bool __failed = true;
     {
      streamsize __npad = this->width() > 0 ? this->width() - 1 : 0;
      //      if (__npad <= 1)
      if (__npad == 0)
        __failed = this->_S_eof(this->rdbuf()->sputc(__c));
      else if ((this->flags() & ios_base::adjustfield) == ios_base::left) {
        __failed = this->_S_eof(this->rdbuf()->sputc(__c));
        __failed = __failed ||
                   this->rdbuf()->_M_sputnc(this->fill(), __npad) != __npad;
      }
      else {
        __failed = this->rdbuf()->_M_sputnc(this->fill(), __npad) != __npad;
        __failed = __failed || this->_S_eof(this->rdbuf()->sputc(__c));
      }

      this->width(0);
    }
    if (false) {
      this->_M_handle_exception(ios_base::badbit);
    }

    if (__failed)
      this->setstate(ios_base::badbit);
  }
}

template <class _CharT, class _Traits>
void basic_ostream<_CharT, _Traits>::_M_put_nowiden(const _CharT* __s) {
  sentry __sentry(*this);
  if (__sentry) {
    bool __failed = true;
    streamsize __n = _Traits::length(__s);
    streamsize __npad = this->width() > __n ? this->width() - __n : 0;

     {
      if (__npad == 0)
        __failed = this->rdbuf()->sputn(__s, __n) != __n;
      else if ((this->flags() & ios_base::adjustfield) == ios_base::left) {
        __failed = this->rdbuf()->sputn(__s, __n) != __n;
        __failed = __failed ||
                   this->rdbuf()->_M_sputnc(this->fill(), __npad) != __npad;
      }
      else {
        __failed = this->rdbuf()->_M_sputnc(this->fill(), __npad) != __npad;
        __failed = __failed || this->rdbuf()->sputn(__s, __n) != __n;
      }

      this->width(0);
    }
    if (false) {
      this->_M_handle_exception(ios_base::badbit);
    }

    if (__failed)
      this->setstate(ios_base::failbit);
  }
}

template <class _CharT, class _Traits>
void basic_ostream<_CharT, _Traits>::_M_put_widen(const char* __s) {
  sentry __sentry(*this);
  if (__sentry) {
    bool __failed = true;
    streamsize __n = char_traits<char>::length(__s);
    streamsize __npad = this->width() > __n ? this->width() - __n : 0;

     {
      if (__npad == 0)
        __failed = !this->_M_put_widen_aux(__s, __n);
      else if ((this->flags() & ios_base::adjustfield) == ios_base::left) {
        __failed = !this->_M_put_widen_aux(__s, __n);
        __failed = __failed ||
                   this->rdbuf()->_M_sputnc(this->fill(), __npad) != __npad;
      }
      else {
        __failed = this->rdbuf()->_M_sputnc(this->fill(), __npad) != __npad;
        __failed = __failed || !this->_M_put_widen_aux(__s, __n);
      }

      this->width(0);
    }
    if (false) {
      this->_M_handle_exception(ios_base::badbit);
    }

    if (__failed)
      this->setstate(ios_base::failbit);
  }
}

template <class _CharT, class _Traits>
bool basic_ostream<_CharT, _Traits>::_M_put_widen_aux(const char* __s,
                                                      streamsize __n) {
  basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();

  for ( ; __n > 0 ; --__n)
    if (this->_S_eof(__buf->sputc(this->widen(*__s++))))
      return false;
  return true;
}

// Unformatted output of a single character.
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>&
basic_ostream<_CharT, _Traits>::put(char_type __c) {
  sentry __sentry(*this);
  bool __failed = true;

  if (__sentry) {
     {
      __failed = this->_S_eof(this->rdbuf()->sputc(__c));
    }
    if (false) {
      this->_M_handle_exception(ios_base::badbit);
    }
  }

  if (__failed)
    this->setstate(ios_base::badbit);

  return *this;
}

// Unformatted output of a single character.
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>&
basic_ostream<_CharT, _Traits>::write(const char_type* __s, streamsize __n) {
  sentry __sentry(*this);
  bool __failed = true;

  if (__sentry) {
     {
      __failed = this->rdbuf()->sputn(__s, __n) != __n;
    }
    if (false) {
      this->_M_handle_exception(ios_base::badbit);
    }
  }

  if (__failed)
    this->setstate(ios_base::badbit);

  return *this;
}

}


// Local Variables:
// mode:C++
// End:


// Local Variables:
// mode:C++
// End:

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

// this block is included by _ostream.h, we include it here to lower #include level



/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */
// WARNING: This is an internal header file, included by other C++
// standard library headers.  You should not attempt to use this header
// file directly.





namespace std {

// defined in _istream.h
template <class _CharT, class _Traits>
extern basic_streambuf<_CharT, _Traits>*  _M_get_istreambuf(basic_istream<_CharT, _Traits>& ) ;

// We do not read any characters until operator* is called. operator* calls sgetc
// unless the iterator is unchanged from the last call in which case a cached value is
// used. Calls to operator++ use sbumpc.

template<class _CharT, class _Traits>
class istreambuf_iterator :
  public iterator<input_iterator_tag, _CharT, typename _Traits::off_type, _CharT*, _CharT&>
{
public:
  typedef _CharT                           char_type;
  typedef _Traits                          traits_type;
  typedef typename _Traits::int_type       int_type;
  typedef basic_streambuf<_CharT, _Traits> streambuf_type;
  typedef basic_istream<_CharT, _Traits>   istream_type;

  typedef input_iterator_tag               iterator_category;
  typedef _CharT                           value_type;
  typedef typename _Traits::off_type       difference_type;
  typedef const _CharT*                    pointer;
  typedef const _CharT&                    reference;

public:
  istreambuf_iterator(streambuf_type* __p = 0) { this->_M_init(__p); }
  //  istreambuf_iterator(basic_istream<_CharT, _Traits>& __is) { this->_M_init(_M_get_istreambuf(__is)); }
  inline istreambuf_iterator(basic_istream<_CharT, _Traits>& __is);

  char_type operator*() const { this->_M_getc(); return _M_c; }
  istreambuf_iterator<_CharT, _Traits>& operator++() {
    _M_buf->sbumpc();
    _M_have_c = false;
    return *this;
  }
  istreambuf_iterator<_CharT, _Traits>  operator++(int);

  bool equal(const istreambuf_iterator<_CharT, _Traits>& __i) const {
    if (this->_M_buf)
      this->_M_getc();
    if (__i._M_buf)
      __i._M_getc();
    return this->_M_eof == __i._M_eof;
  }

private:
  void _M_init(streambuf_type* __p) {
    _M_buf = __p;
    _M_eof = (__p == 0);
    _M_have_c = false;
  }

  void _M_getc() const {
    if (_M_have_c)
      return;
    int_type __c = _M_buf->sgetc();
    _M_c = traits_type::to_char_type(__c);
    _M_eof = traits_type::eq_int_type(__c, traits_type::eof());
    _M_have_c = true;
  }

private:
  streambuf_type* _M_buf;
  mutable _CharT _M_c;
  mutable bool _M_eof;
  mutable bool _M_have_c;
};

template<class _CharT, class _Traits>
inline istreambuf_iterator<_CharT, _Traits>::istreambuf_iterator(basic_istream<_CharT, _Traits>& __is)
{ this->_M_init(_M_get_istreambuf(__is)); }

template<class _CharT, class _Traits>
inline bool  operator==(const istreambuf_iterator<_CharT, _Traits>& __x,
                                  const istreambuf_iterator<_CharT, _Traits>& __y) {
  return __x.equal(__y);
}


template<class _CharT, class _Traits>
inline bool  operator!=(const istreambuf_iterator<_CharT, _Traits>& __x,
                                  const istreambuf_iterator<_CharT, _Traits>& __y) {
  return !__x.equal(__y);
}




template <class _CharT, class _Traits>
istreambuf_iterator<_CharT, _Traits>
istreambuf_iterator<_CharT, _Traits>::operator++(int) {
  _M_getc(); // __tmp should avoid any future actions under
  // underlined buffer---during call of operator *()
  // (due to buffer for *this and __tmp are the same).
  istreambuf_iterator<_CharT, _Traits> __tmp = *this;
  _M_buf->sbumpc();
  _M_have_c = false;
  return __tmp;
}

}


// Local Variables:
// mode:C++
// End:


                                // to be used as function objects.
namespace std {


struct _No_Skip_WS {};        // Dummy class used by sentry.

template <class _CharT, class _Traits>
bool _M_init_skip(basic_istream<_CharT, _Traits>& __istr);
template <class _CharT, class _Traits>
bool _M_init_noskip(basic_istream<_CharT, _Traits>& __istr);

//----------------------------------------------------------------------
// Class basic_istream, a class that performs formatted input through
// a stream buffer.

// The second template parameter, _Traits, defaults to char_traits<_CharT>.
// The default is declared in header <iosfwd>, and it isn't declared here
// because C++ language rules do not allow it to be declared twice.

template <class _CharT, class _Traits>
class basic_istream : virtual public basic_ios<_CharT, _Traits> {
  typedef basic_istream<_CharT, _Traits> _Self;


public:
                         // Types
  typedef _CharT                     char_type;
  typedef typename _Traits::int_type int_type;
  typedef typename _Traits::pos_type pos_type;
  typedef typename _Traits::off_type off_type;
  typedef _Traits                    traits_type;
  typedef basic_ios<_CharT, _Traits>     _Basic_ios;

  typedef basic_ios<_CharT, _Traits>& ( *__ios_fn)(basic_ios<_CharT, _Traits>&);
  typedef ios_base& ( *__ios_base_fn)(ios_base&);
  typedef _Self& ( *__istream_fn)(_Self&);

public:                         // Constructor and destructor.
  explicit basic_istream(basic_streambuf<_CharT, _Traits>* __buf) :
    basic_ios<_CharT, _Traits>(), _M_gcount(0) {
    this->init(__buf);
  }
  explicit basic_istream(ios_base::_SpecialInitType __i) :
    basic_ios<_CharT, _Traits>(__i) { /* Do nothing */ }
  ~basic_istream() {};

public:                         // Nested sentry class.

public:                         // Hooks for manipulators.  The arguments are
                                // function pointers.
  _Self& operator>> (__istream_fn __f) { return __f(*this); }
  _Self& operator>> (__ios_fn __f) {  __f(*this); return *this; }
  _Self& operator>> (__ios_base_fn __f) { __f(*this); return *this; }

public:                         // Formatted input of numbers.
  _Self& operator>> (short& __val);
  _Self& operator>> (int& __val);
  _Self& operator>> (unsigned short& __val);
  _Self& operator>> (unsigned int& __val);
  _Self& operator>> (long& __val);
  _Self& operator>> (unsigned long& __val);
  _Self& operator>> (long long& __val);
  _Self& operator>> (unsigned long long& __val);
  _Self& operator>> (float& __val);
  _Self& operator>> (double& __val);
  _Self& operator>> (long double& __val);
  _Self& operator>> (bool& __val);
  _Self& operator>> (void*& __val);

public:                         // Copying characters into a streambuf.
  _Self& operator>>(basic_streambuf<_CharT, _Traits>*);

public:                         // Unformatted input.
  streamsize gcount() const { return _M_gcount; }
  int_type peek();

public:                         // get() for single characters
  int_type get();
  _Self& get(char_type& __c);

public:                         // get() for character arrays.
  _Self& get(char_type* __s, streamsize __n, char_type __delim);
  _Self& get(char_type* __s, streamsize __n)
    { return get(__s, __n, this->widen('\n')); }

public:                         // get() for streambufs
  _Self& get(basic_streambuf<_CharT, _Traits>& __buf,
                     char_type __delim);
  _Self& get(basic_streambuf<_CharT, _Traits>& __buf)
    { return get(__buf, this->widen('\n')); }

public:                         // getline()
  _Self& getline(char_type* __s, streamsize __n, char_type delim);
  _Self& getline(char_type* __s, streamsize __n)
    { return getline(__s, __n, this->widen('\n')); }

public:                         // read(), readsome(), ignore()
  _Self& ignore();
  _Self& ignore(streamsize __n);
  _Self& ignore(streamsize __n, int_type __delim);

  _Self& read(char_type* __s, streamsize __n);
  streamsize readsome(char_type* __s, streamsize __n);

public:                         // putback
  _Self& putback(char_type __c);
  _Self& unget();

public:                         // Positioning and buffer control.
  int sync();

  pos_type tellg();
  _Self& seekg(pos_type __pos);
  _Self& seekg(off_type, ios_base::seekdir);

public:                         // Helper functions for non-member extractors.
  void _M_formatted_get(_CharT& __c);
  void _M_formatted_get(_CharT* __s);
  void _M_skip_whitespace(bool __set_failbit);

private:                        // Number of characters extracted by the
  streamsize _M_gcount;         // most recent unformatted input function.

public:

  class sentry {
    typedef sentry _Self;

  private:
    const bool _M_ok;
    //    basic_streambuf<_CharT, _Traits>* _M_buf;

  public:
    typedef _Traits traits_type;

    explicit sentry(basic_istream<_CharT, _Traits>& __istr,
                    bool __noskipws = false) :
      _M_ok((__noskipws || !(__istr.flags() & ios_base::skipws)) ? _M_init_noskip(__istr) : _M_init_skip(__istr) )
      /* , _M_buf(__istr.rdbuf()) */
      {}

    // Calling this constructor is the same as calling the previous one with
    // __noskipws = true, except that it doesn't require a runtime test.
    sentry(basic_istream<_CharT, _Traits>& __istr, _No_Skip_WS) : /* _M_buf(__istr.rdbuf()), */
      _M_ok(_M_init_noskip(__istr)) {}

    ~sentry() {}

    operator bool() const { return _M_ok; }

  private:                        // Disable assignment and copy constructor.
    //Implementation is here only to avoid warning with some compilers.
    sentry(const _Self&) : _M_ok(false) {}
    _Self& operator=(const _Self&) { return *this; }
  };

  // close basic_istream class definition here
};


// Non-member character and string extractor functions.
template <class _CharT, class _Traits>
inline basic_istream<_CharT, _Traits>& 
operator>>(basic_istream<_CharT, _Traits>& __in_str, _CharT& __c) {
  __in_str._M_formatted_get(__c);
  return __in_str;
}

template <class _Traits>
inline basic_istream<char, _Traits>& 
operator>>(basic_istream<char, _Traits>& __in_str, unsigned char& __c) {
  __in_str._M_formatted_get(reinterpret_cast<char& >(__c));
  return __in_str;
}

template <class _Traits>
inline basic_istream<char, _Traits>& 
operator>>(basic_istream<char, _Traits>& __in_str, signed char& __c) {
  __in_str._M_formatted_get(reinterpret_cast<char& >(__c));
  return __in_str;
}

template <class _CharT, class _Traits>
inline basic_istream<_CharT, _Traits>& 
operator>>(basic_istream<_CharT, _Traits>& __in_str, _CharT* __s) {
  __in_str._M_formatted_get(__s);
  return __in_str;
}

template <class _Traits>
inline basic_istream<char, _Traits>& 
operator>>(basic_istream<char, _Traits>& __in_str, unsigned char* __s) {
  __in_str._M_formatted_get(reinterpret_cast<char* >(__s));
  return __in_str;
}

template <class _Traits>
inline basic_istream<char, _Traits>& 
operator>>(basic_istream<char, _Traits>& __in_str, signed char* __s) {
  __in_str._M_formatted_get(reinterpret_cast<char* >(__s));
  return __in_str;
}

//----------------------------------------------------------------------
// istream manipulator.
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& 
ws(basic_istream<_CharT, _Traits>& __istr) {
  if (!__istr.eof()) {
    typedef typename basic_istream<_CharT, _Traits>::sentry      _Sentry;
    _Sentry __sentry(__istr, _No_Skip_WS()); // Don't skip whitespace.
    if (__sentry)
      __istr._M_skip_whitespace(false);
  }
  return __istr;
}

// Helper functions for istream<>::sentry constructor.
template <class _CharT, class _Traits>
inline bool _M_init_skip(basic_istream<_CharT, _Traits>& __istr) {
  if (__istr.good()) {
    if (__istr.tie())
      __istr.tie()->flush();

    __istr._M_skip_whitespace(true);
  }

  if (!__istr.good()) {
    __istr.setstate(ios_base::failbit);
    return false;
  } else
    return true;
}

template <class _CharT, class _Traits>
inline bool _M_init_noskip(basic_istream<_CharT, _Traits>& __istr) {
  if (__istr.good()) {
    if (__istr.tie())
      __istr.tie()->flush();

    if (!__istr.rdbuf())
      __istr.setstate(ios_base::badbit);
  }
  else
    __istr.setstate(ios_base::failbit);
  return __istr.good();
}

//----------------------------------------------------------------------
// Class iostream.
template <class _CharT, class _Traits>
class basic_iostream
  : public basic_istream<_CharT, _Traits>,
    public basic_ostream<_CharT, _Traits>
{
public:
  typedef basic_ios<_CharT, _Traits> _Basic_ios;

  explicit basic_iostream(basic_streambuf<_CharT, _Traits>* __buf);
  virtual ~basic_iostream();
};


template <class _CharT, class _Traits>
basic_streambuf<_CharT, _Traits>*  _M_get_istreambuf(basic_istream<_CharT, _Traits>& __istr)
{ return __istr.rdbuf(); }

}

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */



/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */
// WARNING: This is an internal header file, included by other C++
// standard library headers.  You should not attempt to use this header
// file directly.









namespace std {

//----------------------------------------------------------------------
// num_get facets

template <class _CharT, class _InputIter>
class num_get: public locale::facet {
public:
  typedef _CharT     char_type;
  typedef _InputIter iter_type;

  explicit num_get(size_t __refs = 0): locale::facet(__refs) {}

  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, bool& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }


  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, long& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }

  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, unsigned short& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }

  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, unsigned int& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }

  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, unsigned long& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }

  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, long long& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }

  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, unsigned long long& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }

  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, float& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }

  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, double& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }

  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, long double& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }

  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, void*& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }

  static  locale::id id;

protected:
  ~num_get() {}

  typedef string               string_type;
  typedef ctype<_CharT>        _Ctype;
  typedef numpunct<_CharT>     _Numpunct;

  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, bool& __val) const;

  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, long& __val) const;
  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, unsigned short& __val) const;
  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, unsigned int& __val) const;
  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, unsigned long& __val) const;


  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, float& __val) const;
  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, double& __val) const;
  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, void*& __p) const;

  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, long double& __val) const;

  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, long long& __val) const;
  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, unsigned long long& __val) const;

};




namespace priv {

 bool  __valid_grouping(const char*, const char*, const char*, const char*);

template <class _InputIter, class _Integer, class _CharT>
bool 
__get_decimal_integer(_InputIter& __first, _InputIter& __last, _Integer& __val, _CharT*);

bool   __get_fdigit(wchar_t&, const wchar_t*);
bool   __get_fdigit_or_sep(wchar_t&, wchar_t, const wchar_t*);

inline void  
_Initialize_get_float(const ctype<char>&,
                       char& Plus, char& Minus,
                       char& pow_e, char& pow_E,
                       char*) {
  Plus = '+';
  Minus = '-';
  pow_e = 'e';
  pow_E = 'E';
}

void   _Initialize_get_float(const ctype<wchar_t>&,
                                                     wchar_t&, wchar_t&, wchar_t&, wchar_t&, wchar_t*);
void   __string_to_float(const __iostring&, float&);
void   __string_to_float(const __iostring&, double&);
void   __string_to_float(const __iostring&, long double&);

}



}

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/*
 * Copyright (c) 1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1999
 * Boris Fomitchev
 *
 * Copyright (c) 2014-2014 Texas Instruments Incorporated
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */



namespace std {

namespace priv {

 unsigned char  __digit_val_table(unsigned);
 const char*  __narrow_atoms();

// __do_get_integer, __do_get_float and its helper functions.

inline bool  __get_fdigit(char __c, const char*)
{ return __c >= '0' && __c <= '9'; }

inline bool  __get_fdigit_or_sep(char& __c, char __sep, const char *__digits) {
  if (__c == __sep) {
    __c = ',' ;
    return true ;
  }
  else
    return  __get_fdigit(__c, __digits);
}

inline int 
__get_digit_from_table(unsigned __index)
{ return (__index > 127 ? 0xFF : __digit_val_table(__index)); }

template <class _InputIter, class _CharT>
int
__get_base_or_zero(_InputIter& __in_ite, _InputIter& __end,
                   ios_base::fmtflags __flags, const ctype<_CharT>& __c_type) {
  _CharT __atoms[5];
  __c_type.widen(__narrow_atoms(), __narrow_atoms() + 5, __atoms);

  bool __negative = false;
  _CharT __c = *__in_ite;

  if (__c == __atoms[1] /* __xminus_char */ ) {
    __negative = true;
    ++__in_ite;
  }
  else if (__c == __atoms[0] /* __xplus_char */ )
    ++__in_ite;

  int __base;
  int __valid_zero = 0;

  ios_base::fmtflags __basefield = __flags & ios_base::basefield;

  switch (__basefield) {
  case ios_base::oct:
    __base = 8;
    break;
  case ios_base::dec:
    __base = 10;
    break;
  case ios_base::hex:
    __base = 16;
    if (__in_ite != __end && *__in_ite == __atoms[2] /* __zero_char */ ) {
      ++__in_ite;
      if (__in_ite != __end &&
          (*__in_ite == __atoms[3] /* __x_char */ || *__in_ite == __atoms[4] /* __X_char */ ))
        ++__in_ite;
      else
        __valid_zero = 1; // That zero is valid by itself.
    }
    break;
  default:
    if (__in_ite != __end && *__in_ite == __atoms[2] /* __zero_char */ ) {
      ++__in_ite;
      if (__in_ite != __end &&
          (*__in_ite == __atoms[3] /* __x_char */ || *__in_ite == __atoms[4] /* __X_char */ )) {
        ++__in_ite;
        __base = 16;
      }
      else
        {
          __base = 8;
          __valid_zero = 1; // That zero is still valid by itself.
        }
    }
    else
      __base = 10;
    break;
  }
  return (__base << 2) | ((int)__negative << 1) | __valid_zero;
}


template <class _InputIter, class _Integer, class _CharT>
bool 
__get_integer(_InputIter& __first, _InputIter& __last,
              int __base, _Integer& __val,
              int __got, bool __is_negative, _CharT __separator, const string& __grouping, const __true_type& /*_IsSigned*/) {
  bool __ovflow = false;
  _Integer __result = 0;
  bool __is_group = !__grouping.empty();
  char __group_sizes[64];
  char __current_group_size = 0;
  char* __group_sizes_end = __group_sizes;

  _Integer __over_base = (numeric_limits<_Integer>::min)() / static_cast<_Integer>(__base);

   for ( ; __first != __last ; ++__first) {

     const _CharT __c = *__first;

     if (__is_group && __c == __separator) {
       *__group_sizes_end++ = __current_group_size;
       __current_group_size = 0;
       continue;
     }

     int __n = __get_digit_from_table(__c);

     if (__n >= __base)
       break;

     ++__got;
     ++__current_group_size;

     if (__result < __over_base)
       __ovflow = true;  // don't need to keep accumulating
     else {
       _Integer __next = static_cast<_Integer>(__base * __result - __n);
       if (__result != 0)
         __ovflow = __ovflow || __next >= __result;
       __result = __next;
     }
   }

   if (__is_group && __group_sizes_end != __group_sizes) {
     *__group_sizes_end++ = __current_group_size;
   }

   // fbp : added to not modify value if nothing was read
   if (__got > 0) {
       __val = __ovflow ? __is_negative ? (numeric_limits<_Integer>::min)()
                                        : (numeric_limits<_Integer>::max)()
                        : __is_negative ? __result
                                        : static_cast<_Integer>(-__result);
   }
  // overflow is being treated as failure
  return ((__got > 0) && !__ovflow) &&
          (__is_group == 0 ||
           __valid_grouping(__group_sizes, __group_sizes_end,
                            __grouping.data(), __grouping.data()+ __grouping.size()));
}

template <class _InputIter, class _Integer, class _CharT>
bool 
__get_integer(_InputIter& __first, _InputIter& __last,
              int __base, _Integer& __val,
              int __got, bool __is_negative, _CharT __separator, const string& __grouping, const __false_type& /*_IsSigned*/) {
  bool __ovflow = false;
  _Integer __result = 0;
  bool __is_group = !__grouping.empty();
  char __group_sizes[64];
  char __current_group_size = 0;
  char* __group_sizes_end = __group_sizes;

  _Integer  __over_base = (numeric_limits<_Integer>::max)() / static_cast<_Integer>(__base);

  for ( ; __first != __last ; ++__first) {

    const _CharT __c = *__first;

    if (__is_group && __c == __separator) {
      *__group_sizes_end++ = __current_group_size;
      __current_group_size = 0;
      continue;
    }

    int __n = __get_digit_from_table(__c);

    if (__n >= __base)
      break;

    ++__got;
    ++__current_group_size;

    if (__result > __over_base)
      __ovflow = true;  //don't need to keep accumulating
    else {
      _Integer __next = static_cast<_Integer>(__base * __result + __n);
      if (__result != 0)
        __ovflow = __ovflow || __next <= __result;
        __result = __next;
      }
  }

  if (__is_group && __group_sizes_end != __group_sizes) {
      *__group_sizes_end++ = __current_group_size;
  }

  // fbp : added to not modify value if nothing was read
  if (__got > 0) {
      __val = __ovflow ? (numeric_limits<_Integer>::max)()
                       : (__is_negative ? static_cast<_Integer>(-__result)
                                        : __result);
  }

  // overflow is being treated as failure
  return ((__got > 0) && !__ovflow) &&
          (__is_group == 0 ||
           __valid_grouping(__group_sizes, __group_sizes_end,
                            __grouping.data(), __grouping.data()+ __grouping.size()));
}


template <class _InputIter, class _Integer, class _CharT>
bool 
__get_decimal_integer(_InputIter& __first, _InputIter& __last, _Integer& __val, _CharT* /*dummy*/) {
  string __grp;
  //Here there is no grouping so separator is not important, we just pass the default character.
  return __get_integer(__first, __last, 10, __val, 0, false, _CharT() /*separator*/, __grp, __false_type());
}

template <class _InputIter, class _Integer, class _CharT>
_InputIter 
__do_get_integer(_InputIter& __in_ite, _InputIter& __end, ios_base& __str,
                 ios_base::iostate& __err, _Integer& __val, _CharT* /*__pc*/) {
  locale __loc = __str.getloc();
  const ctype<_CharT>& __ctype = use_facet<ctype<_CharT> >(__loc);

  typedef typename __bool2type<numeric_limits<_Integer>::is_signed>::_Ret _IsSigned;

    /* Missing check for beginning == end */
    int __base_or_zero = 0;
    int __got = 0;
    if (__in_ite != __end)
    {
        __base_or_zero = __get_base_or_zero(__in_ite, __end, __str.flags(), __ctype);
        __got = __base_or_zero & 1;
    }

  bool __result;

  if (__in_ite == __end) {      // We may have already read a 0.  If so,

    if (__got > 0) {       // the result is 0 even if we're at eof.
      __val = 0;
      __result = true;
    }
    else
      __result = false;
  }
  else {
    const numpunct<_CharT>& __np = use_facet<numpunct<_CharT> >(__loc);
    const bool __negative = (__base_or_zero & 2) != 0;
    const int __base = __base_or_zero >> 2;

    __result = __get_integer(__in_ite, __end, __base,  __val, __got, __negative, __np.thousands_sep(), __np.grouping(), _IsSigned());
  }

  __err = static_cast<ios_base::iostate>(__result ? ios_base::goodbit : ios_base::failbit);

  if (__in_ite == __end)
    __err |= ios_base::eofbit;
  return __in_ite;
}

// __read_float and its helper functions.
template <class _InputIter, class _CharT>
_InputIter  
__copy_sign(_InputIter __first, _InputIter __last, __iostring& __v,
            _CharT __xplus, _CharT __xminus) {
  if (__first != __last) {
    _CharT __c = *__first;
    if (__c == __xplus)
      ++__first;
    else if (__c == __xminus) {
      __v.push_back('-');
      ++__first;
    }
  }
  return __first;
}


template <class _InputIter, class _CharT>
bool 
__copy_digits(_InputIter& __first, _InputIter __last,
              __iostring& __v, const _CharT* __digits) {
  bool __ok = false;

  for ( ; __first != __last; ++__first) {
    _CharT __c = *__first;
    if (__get_fdigit(__c, __digits)) {
      __v.push_back((char)__c);
      __ok = true;
    }
    else
      break;
  }
  return __ok;
}

template <class _InputIter, class _CharT>
bool 
__copy_grouped_digits(_InputIter& __first, _InputIter __last,
                      __iostring& __v, const _CharT * __digits,
                      _CharT __sep, const string& __grouping,
                      bool& __grouping_ok) {
  bool __ok = false;
  char __group_sizes[64];
  char*__group_sizes_end = __group_sizes;
  char __current_group_size = 0;

  for ( ; __first != __last; ++__first) {
    _CharT __c = *__first;
    bool __tmp = __get_fdigit_or_sep(__c, __sep, __digits);
    if (__tmp) {
      if (__c == ',') {
        *__group_sizes_end++ = __current_group_size;
        __current_group_size = 0;
      }
      else {
        __ok = true;
        __v.push_back((char)__c);
        ++__current_group_size;
      }
    }
    else
      break;
  }

  if (__group_sizes_end != __group_sizes)
    *__group_sizes_end++ = __current_group_size;
  __grouping_ok = __valid_grouping(__group_sizes, __group_sizes_end, __grouping.data(), __grouping.data() + __grouping.size());
  return __ok;
}


template <class _InputIter, class _CharT>
bool 
__read_float(__iostring& __buf, _InputIter& __in_ite, _InputIter& __end,
             const ctype<_CharT> &__ct, const numpunct<_CharT> &__numpunct) {
  // Create a string, copying characters of the form
  // [+-]? [0-9]* .? [0-9]* ([eE] [+-]? [0-9]+)?

  string __grouping = __numpunct.grouping();
  bool __digits_before_dot /* = false */;
  bool __digits_after_dot = false;
  bool __ok;

  bool   __grouping_ok = true;

  _CharT __dot = __numpunct.decimal_point();
  _CharT __sep = __numpunct.thousands_sep();

  _CharT __digits[10];
  _CharT __xplus;
  _CharT __xminus;

  _CharT __pow_e;
  _CharT __pow_E;

  _Initialize_get_float(__ct, __xplus, __xminus, __pow_e, __pow_E, __digits);

  // Get an optional sign
  __in_ite = __copy_sign(__in_ite, __end, __buf, __xplus, __xminus);

  // Get an optional string of digits.
  if (!__grouping.empty())
    __digits_before_dot = __copy_grouped_digits(__in_ite, __end, __buf, __digits,
                                                __sep, __grouping, __grouping_ok);
  else
    __digits_before_dot = __copy_digits(__in_ite, __end, __buf, __digits);

  // Get an optional decimal point, and an optional string of digits.
  if (__in_ite != __end && *__in_ite == __dot) {
    __buf.push_back('.');
    ++__in_ite;
    __digits_after_dot = __copy_digits(__in_ite, __end, __buf, __digits);
  }

  // There have to be some digits, somewhere.
  __ok = __digits_before_dot || __digits_after_dot;

  // Get an optional exponent.
  if (__ok && __in_ite != __end && (*__in_ite == __pow_e || *__in_ite == __pow_E)) {
    __buf.push_back('e');
    ++__in_ite;
    __in_ite = __copy_sign(__in_ite, __end, __buf, __xplus, __xminus);
    __ok = __copy_digits(__in_ite, __end, __buf, __digits);
    // If we have an exponent then the sign
    // is optional but the digits aren't.
  }

  return __ok;
}

template <class _InputIter, class _Float, class _CharT>
_InputIter 
__do_get_float(_InputIter& __in_ite, _InputIter& __end, ios_base& __str,
               ios_base::iostate& __err, _Float& __val, _CharT* /*__pc*/) {
  locale __loc = __str.getloc();
  const ctype<_CharT> &__ctype = use_facet<ctype<_CharT> >(__loc);
  const numpunct<_CharT> &__numpunct = use_facet<numpunct<_CharT> >(__loc);

  __iostring __buf ;
  bool __ok = __read_float(__buf, __in_ite, __end, __ctype, __numpunct);
  if (__ok) {
    __string_to_float(__buf, __val);
    __err = ios_base::goodbit;
  }
  else {
    __err = ios_base::failbit;
  }
  if (__in_ite == __end)
    __err |= ios_base::eofbit;
  return __in_ite;
}

template <class _InputIter, class _CharT>
_InputIter 
__do_get_alphabool(_InputIter& __in_ite, _InputIter& __end, ios_base& __str,
                   ios_base::iostate& __err, bool& __x, _CharT* /*__pc*/) {
  const numpunct<_CharT>& __np = use_facet<numpunct<_CharT> >(__str.getloc());
  const basic_string<_CharT, char_traits<_CharT>, allocator<_CharT> > __truename  = __np.truename();
  const basic_string<_CharT, char_traits<_CharT>, allocator<_CharT> > __falsename = __np.falsename();
  bool __true_ok  = true;
  bool __false_ok = true;

  size_t __n = 0;
  for ( ; __in_ite != __end; ++__in_ite) {
    _CharT __c = *__in_ite;
    __true_ok  = __true_ok  && (__c == __truename[__n]);
    __false_ok = __false_ok && (__c == __falsename[__n]);
    ++__n;

    if ((!__true_ok && !__false_ok) ||
        (__true_ok  && __n >= __truename.size()) ||
        (__false_ok && __n >= __falsename.size())) {
      ++__in_ite;
      break;
    }
  }
  if (__true_ok  && __n < __truename.size())  __true_ok  = false;
  if (__false_ok && __n < __falsename.size()) __false_ok = false;

  if (__true_ok || __false_ok) {
    __err = ios_base::goodbit;
    __x = __true_ok;
  }
  else
    __err = ios_base::failbit;

  if (__in_ite == __end)
    __err |= ios_base::eofbit;

  return __in_ite;
}

}

//
// num_get<>, num_put<>
//

template <class _CharT, class _InputIterator>
locale::id num_get<_CharT, _InputIterator>::id;

template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end,
                                    ios_base& __s, ios_base::iostate& __err, bool& __x) const {
  if (__s.flags() & ios_base::boolalpha) {
    return ::std::priv:: __do_get_alphabool(__in_ite, __end, __s, __err, __x, (_CharT*)0);
  }
  else {
    long __lx;
    _InputIter __tmp = ::std::priv:: __do_get_integer(__in_ite, __end, __s, __err, __lx, (_CharT*)0 );
    if (!(__err & ios_base::failbit)) {
      if (__lx == 0)
        __x = false;
      else if (__lx == 1)
        __x = true;
      else
        __err |= ios_base::failbit;
    }
    return __tmp;
  }
}


template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err, long& __val) const
{ return ::std::priv:: __do_get_integer(__in_ite, __end, __str, __err, __val, (_CharT*)0 ); }

template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err,
                                    unsigned short& __val) const
{ return ::std::priv:: __do_get_integer(__in_ite, __end, __str, __err, __val, (_CharT*)0 ); }

template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err,
                                    unsigned int& __val) const
{ return ::std::priv:: __do_get_integer(__in_ite, __end, __str, __err, __val, (_CharT*)0 ); }

template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err,
                                    unsigned long& __val) const
{ return ::std::priv:: __do_get_integer(__in_ite, __end, __str, __err, __val, (_CharT*)0 ); }

template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err,
                                    float& __val) const
{ return ::std::priv:: __do_get_float(__in_ite, __end, __str, __err, __val, (_CharT*)0 ); }

template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err,
                                    double& __val) const
{ return ::std::priv:: __do_get_float(__in_ite, __end, __str, __err, __val, (_CharT*)0 ); }

template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err,
                                    long double& __val) const
{ return ::std::priv:: __do_get_float(__in_ite, __end, __str, __err, __val, (_CharT*)0 ); }

template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err,
                                    void*& __p) const {
  unsigned long long __val;
  iter_type __tmp = ::std::priv:: __do_get_integer(__in_ite, __end, __str, __err, __val, (_CharT*)0 );
  if (!(__err & ios_base::failbit))
#  pragma diag_suppress 1107 /* Conversion from integer to smaller pointer */
    __p = reinterpret_cast<void* >(__val);
  return __tmp;
}

template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err,
                                    long long& __val) const
{ return ::std::priv:: __do_get_integer(__in_ite, __end, __str, __err, __val, (_CharT*)0 ); }

template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err,
                                    unsigned long long& __val) const
{ return ::std::priv:: __do_get_integer(__in_ite, __end, __str, __err, __val, (_CharT*)0 ); }

}


// Local Variables:
// mode:C++
// End:


// Local Variables:
// mode:C++
// End:



namespace std {

//----------------------------------------------------------------------
// Function object structs used by some member functions.

namespace priv {

template <class _Traits>
struct _Is_not_wspace {
  typedef typename _Traits::char_type argument_type;
  typedef bool                        result_type;

  const ctype<argument_type>* _M_ctype;

  _Is_not_wspace(const ctype<argument_type>* __c_type) : _M_ctype(__c_type) {}
  bool operator()(argument_type __c) const
    { return !_M_ctype->is(ctype_base::space, __c); }
};

template <class _Traits>
struct _Is_wspace_null {
  typedef typename _Traits::char_type argument_type;
  typedef bool                        result_type;

  const ctype<argument_type>* _M_ctype;

  _Is_wspace_null(const ctype<argument_type>* __c_type) : _M_ctype(__c_type) {}
  bool operator()(argument_type __c) const {
    return _Traits::eq(__c, argument_type()) ||
           _M_ctype->is(ctype_base::space, __c);
  }
};

template <class _Traits>
struct _Scan_for_wspace {
  typedef typename _Traits::char_type  char_type;
  typedef char_type*                   first_argument_type;
  typedef char_type*                   second_argument_type;
  typedef char_type*                   result_type;

  const ctype<char_type>* _M_ctype;

  _Scan_for_wspace(const ctype<char_type>* __ctype) : _M_ctype(__ctype) {}
  const char_type*
  operator()(const char_type* __first, const char_type* __last) const {
    return _M_ctype->scan_is(ctype_base::space, __first, __last);
  }
};

template <class _Traits>
struct _Scan_wspace_null {
  typedef typename _Traits::char_type  char_type;
  typedef char_type*                   first_argument_type;
  typedef char_type*                   second_argument_type;
  typedef char_type*                   result_type;

  const ctype<char_type>* _M_ctype;

  _Scan_wspace_null(const ctype<char_type>* __c_type) : _M_ctype(__c_type) {}
  const char_type*
  operator()(const char_type* __first, const char_type* __last) const {
    __last = find_if(__first, __last,
                     _Eq_char_bound<_Traits>(char_type()));
    return _M_ctype->scan_is(ctype_base::space, __first, __last);
  }
};

template <class _Traits>
struct _Scan_for_not_wspace {
  typedef typename _Traits::char_type  char_type;
  typedef char_type*                   first_argument_type;
  typedef char_type*                   second_argument_type;
  typedef char_type*                   result_type;

  const ctype<char_type>* _M_ctype;

  _Scan_for_not_wspace(const ctype<char_type>* __c_type) : _M_ctype(__c_type) {}
  const char_type*
  operator()(const char_type* __first, const char_type* __last) const {
    return _M_ctype->scan_not(ctype_base::space, __first, __last);
  }
};

template <class _Traits>
struct _Scan_for_char_val {
  typedef typename _Traits::char_type char_type;
  typedef char_type*                  first_argument_type;
  typedef char_type*                  second_argument_type;
  typedef char_type*                  result_type;

  char_type _M_val;

  _Scan_for_char_val(char_type __val) : _M_val(__val) {}

  const char_type*
  operator()(const char_type* __first, const char_type* __last) const {
    return find_if(__first, __last, _Eq_char_bound<_Traits>(_M_val));
  }
};

template <class _Traits>
struct _Scan_for_int_val {
  typedef typename _Traits::char_type char_type;
  typedef typename _Traits::int_type  int_type;
  typedef char_type*                  first_argument_type;
  typedef char_type*                  second_argument_type;
  typedef char_type*                  result_type;

  int_type _M_val;

  _Scan_for_int_val(int_type __val) : _M_val(__val) {}

  const char_type*
  operator()(const char_type* __first, const char_type* __last) const {
    return find_if(__first, __last,
                   _Eq_int_bound<_Traits>(_M_val));
  }
};

// Helper function: try to push back a character to a streambuf,
// return true if the pushback succeeded.  Does not throw.

template <class _CharT, class _Traits>
bool 
__pushback(basic_streambuf<_CharT, _Traits>* __buf, _CharT __c) {
  bool ret;
   {
    const typename _Traits::int_type __eof = _Traits::eof();
    ret = !_Traits::eq_int_type(__buf->sputbackc(__c), __eof);
  }
  if (false) {
    ret = false;
  }
  return ret;
}

//----------------------------------------------------------------------
// Definitions of basic_istream<>'s noninline member functions.

// Helper function for formatted input of numbers.
template <class _CharT, class _Traits, class _Number>
ios_base::iostate 
__get_num(basic_istream<_CharT, _Traits>& __that, _Number& __val) {
  typedef typename basic_istream<_CharT, _Traits>::sentry _Sentry;
  ios_base::iostate __err = 0;
  _Sentry __sentry( __that );     // Skip whitespace.
  if (__sentry) {
    typedef num_get<_CharT, istreambuf_iterator<_CharT, _Traits> > _Num_get;
     {
      // Do not remove additional parenthesis around use_facet instanciation, some compilers (VC6)
      // require it when building the library.
      (use_facet<_Num_get>(__that.getloc())).get(istreambuf_iterator<_CharT, _Traits>(__that.rdbuf()),
                                               0, __that, __err, __val);
    }
    if (false) {
      __that._M_handle_exception(ios_base::badbit);
    }
    if (__err) __that.setstate(__err);
  }
  return __err;
}

}

template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (short& __val) {
  long __lval;
  ::std::priv:: __get_num(*this, __lval);
  if ( this->fail() ) {
    return *this;
  }
  short __tmp = static_cast<short>(__lval);
  unsigned short __uval = static_cast<unsigned short>(__lval);
  // check if we lose digits
  //    if ((__val != __lval) && ((unsigned short)__val != __lval))
  if ((__tmp != __lval) && ((long)__uval != __lval))
    this->setstate(ios_base::failbit);
  else
    __val = __tmp;
  return *this;
}

template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (int& __val) {
  long __lval;
  ::std::priv:: __get_num(*this, __lval);
  if ( this->fail() ) {
    return *this;
  }
  int __tmp = __lval;
  unsigned int __uval = __lval;
  // check if we lose digits
  //    if ((__val != __lval) && ((unsigned int)__val != __lval))
  if ((__tmp != __lval) && ((long)__uval != __lval))
    this->setstate(ios_base::failbit);
  else
    __val = __tmp;
  return *this;
}

template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (unsigned short& __val) {
  ::std::priv:: __get_num(*this, __val);
  return *this;
}

template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (unsigned int& __val) {
  ::std::priv:: __get_num(*this, __val);
  return *this;
}

template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (long& __val) {
  ::std::priv:: __get_num(*this, __val);
  return *this;
}

template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (unsigned long& __val) {
  ::std::priv:: __get_num(*this, __val);
  return *this;
}

template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (long long& __val) {
  ::std::priv:: __get_num(*this, __val);
  return *this;
}

template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (unsigned long long& __val) {
  ::std::priv:: __get_num(*this, __val);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (float& __val) {
  ::std::priv:: __get_num(*this, __val);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (double& __val) {
  ::std::priv:: __get_num(*this, __val);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (long double& __val) {
  ::std::priv:: __get_num(*this, __val);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (bool& __val) {
  ::std::priv:: __get_num(*this, __val);
  return *this;
}

template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (void*& __val) {
  ::std::priv:: __get_num(*this, __val);
  return *this;
}

// Unformatted input

template <class _CharT, class _Traits>
typename basic_istream<_CharT, _Traits> ::int_type
basic_istream<_CharT, _Traits>::peek() {
  typename _Traits::int_type __tmp = _Traits::eof();

  this->_M_gcount = 0;
  sentry __sentry(*this, _No_Skip_WS());

  if (__sentry) {
     {
      __tmp = this->rdbuf()->sgetc();
    }
    if (false) {
      this->_M_handle_exception(ios_base::badbit);
    }
    if (this->_S_eof(__tmp))
      this->setstate(ios_base::eofbit);
  }

  return __tmp;
}


template <class _CharT, class _Traits>
typename basic_istream<_CharT, _Traits> ::int_type
basic_istream<_CharT, _Traits>::get() {
  typename _Traits::int_type __tmp = _Traits::eof();
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;

  if (__sentry) {
     {
      __tmp = this->rdbuf()->sbumpc();
    }
    if (false) {
      this->_M_handle_exception(ios_base::badbit);
    }

    if (!this->_S_eof(__tmp))
      this->_M_gcount = 1;
  }

  if (_M_gcount == 0)
    this->setstate(ios_base::eofbit | ios_base::failbit);

  return __tmp;
}

template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>::get(_CharT& __c) {
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;

  if (__sentry) {
    typename _Traits::int_type __tmp = _Traits::eof();
     {
      __tmp = this->rdbuf()->sbumpc();
    }
    if (false) {
      this->_M_handle_exception(ios_base::badbit);
    }

    if (!this->_S_eof(__tmp)) {
      this->_M_gcount = 1;
      __c = _Traits::to_char_type(__tmp);
    }
  }

  if (this->_M_gcount == 0)
    this->setstate(ios_base::eofbit | ios_base::failbit);

  return *this;
}


// Read characters and discard them.  The standard specifies a single
// function with two arguments, each with a default.  We instead use
// three overloded functions, because it's possible to implement the
// first two more efficiently than the fully general third version.
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::ignore() {
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;

  if (__sentry) {
    int_type __c;
     {
      __c = this->rdbuf()->sbumpc();
    }
    if (false) {
      this->_M_handle_exception(ios_base::badbit);
      return *this;
    }

    if (!this->_S_eof(__c))
      this->_M_gcount = 1;
    else
      this->setstate(ios_base::eofbit);
  }

  return *this;
}

// Putback

template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>::putback(_CharT __c) {
  this->_M_gcount = 0;
  sentry __sentry(*this, _No_Skip_WS());

  if (__sentry) {
    typename _Traits::int_type __tmp = _Traits::eof();
    basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
//    if (!__buf || this->_S_eof(__buf->sputbackc(__c)))
    if (__buf) {
       {
        __tmp = __buf->sputbackc(__c);
      }
      if (false) {
        this->_M_handle_exception(ios_base::badbit);
      }
    }
    if (this->_S_eof(__tmp))
      this->setstate(ios_base::badbit);
  }
  else
    this->setstate(ios_base::failbit);

  return *this;
}

template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::unget() {
  this->_M_gcount = 0;

  sentry __sentry(*this, _No_Skip_WS());

  if (__sentry) {
    basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
    //     if (!__buf || _Traits::eq_int_type(__buf->sungetc(), _Traits::eof()))
    if (__buf) {
       {
        if (this->_S_eof(__buf->sungetc()))
          this->setstate(ios_base::badbit);
      }
      if (false) {
        this->_M_handle_exception(ios_base::badbit);
      }
    } else
      this->setstate(ios_base::badbit);
  }
  else
    this->setstate(ios_base::failbit);

  return *this;
}

// Positioning and buffer control.

template <class _CharT, class _Traits>
int basic_istream<_CharT, _Traits>::sync() {
  sentry __sentry(*this, _No_Skip_WS());

  basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
  if (__buf) {
    if (__buf->pubsync() == -1) {
      this->setstate(ios_base::badbit);
      return -1;
    }
    else
      return 0;
  }
  else
    return -1;
}

template <class _CharT, class _Traits>
typename basic_istream<_CharT, _Traits> ::pos_type
basic_istream<_CharT, _Traits>::tellg() {
  sentry __sentry(*this, _No_Skip_WS());

  basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
  return (__buf && !this->fail()) ? __buf->pubseekoff(0, ios_base::cur, ios_base::in)
    : pos_type(-1);
}

template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>::seekg(pos_type __pos) {
  sentry __sentry(*this, _No_Skip_WS());

  basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
  if (!this->fail() && __buf) {
    if (__buf->pubseekpos(__pos, ios_base::in) == pos_type(-1)) {
      this->setstate(ios_base::failbit);
    }
  }
  return *this;
}

template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>::seekg(off_type __off, ios_base::seekdir __dir) {
  sentry __sentry(*this, _No_Skip_WS());

  basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
  if (!this->fail() && __buf)
    __buf->pubseekoff(__off, __dir, ios_base::in);
  return *this;
}

// Formatted input of characters and character arrays.

template <class _CharT, class _Traits>
void basic_istream<_CharT, _Traits>::_M_formatted_get(_CharT& __c) {
//  typename _Traits::int_type __tmp = _Traits::eof();

  sentry __sentry(*this); // Skip whitespace.

  if (__sentry) {
    typename _Traits::int_type __tmp;// = _Traits::eof();

     {
      __tmp = this->rdbuf()->sbumpc();
    }
    if (false) {
      this->_M_handle_exception(ios_base::badbit);
      return;
    }

    if (!this->_S_eof(__tmp))
      __c = _Traits::to_char_type(__tmp);
    else
      this->setstate(ios_base::eofbit | ios_base::failbit);
  }
}


//---------------------------------------------------------------------------
// istream's helper functions.

// A generic function for unbuffered input.  We stop when we reach EOF,
// or when we have extracted _Num characters, or when the function object
// __is_delim return true.  In the last case, it extracts the character
// for which __is_delim is true, if and only if __extract_delim is true.
// It appends a null character to the end of the string; this means that
// it may store up to _Num + 1 characters.
//
// __is_getline governs two corner cases: reading _Num characters without
// encountering delim or eof (in which case failbit is set if __is_getline
// is true); and reading _Num characters where the _Num+1'st character is
// eof (in which case eofbit is set if __is_getline is true).
//
// It is assumed that __is_delim never throws.
//
// Return value is the number of characters extracted, including the
// delimiter if it is extracted.  Note that the number of characaters
// extracted isn't necessarily the same as the number stored.

namespace priv {

template < class _CharT, class _Traits, class _Is_Delim>
streamsize 
__read_unbuffered(basic_istream<_CharT, _Traits>* __that, basic_streambuf<_CharT, _Traits>* __buf,
                  streamsize _Num, _CharT* __s,
                  _Is_Delim __is_delim,
                  bool __extract_delim, bool __append_null,
                  bool __is_getline)
{
  streamsize __n = 0;
  ios_base::iostate __status = 0;

  typedef typename basic_istream<_CharT, _Traits>::int_type int_type;
  // The operations that can potentially throw are sbumpc, snextc, and sgetc.
   {
    for (;;) {
      if (__n == _Num) {
        if (__is_getline) // didn't find delimiter as one of the _Num chars
          __status |= ios_base::failbit;
        break;
      }
      int_type __c = __buf->sbumpc(); // sschwarz

      if (__that->_S_eof(__c)) {
        if (__n < _Num || __is_getline)
          __status |= ios_base::eofbit;
        break;
      } else if (__is_delim(_Traits::to_char_type(__c))) {
        if (__extract_delim) { // Extract and discard current character.
          ++__n;
        } else if ( !__pushback(__buf, _Traits::to_char_type(__c)) ) { // leave delimiter
          __status |= ios_base::failbit;
        }
        break;
      }
      // regular character
      *__s++ = _Traits::to_char_type(__c);
      ++__n;
    }
  }
  if (false) {
    __that->_M_handle_exception(ios_base::badbit);
    *__s = _CharT();
    return __n;
  }

  if (__append_null)
    *__s =  _CharT();
  if (__status)
    __that->setstate(__status);    // This might throw.
  return __n;
}

// Much like __read_unbuffered, but with one additional function object:
// __scan_delim(first, last) returns the first pointer p in [first, last)
// such that __is_delim(p) is true.

template < class _CharT, class _Traits, class _Is_Delim, class _Scan_Delim>
streamsize 
__read_buffered(basic_istream<_CharT, _Traits>* __that, basic_streambuf<_CharT, _Traits>* __buf,
                 streamsize _Num, _CharT* __s,
                 _Is_Delim __is_delim, _Scan_Delim __scan_delim,
                 bool __extract_delim, bool __append_null,
                 bool __is_getline) {
  streamsize __n = 0;
  ios_base::iostate __status = 0;
  bool __done    = false;

   {
    while (__buf->_M_egptr() != __buf->_M_gptr() && !__done) {
      const _CharT* __first = __buf->_M_gptr();
      const _CharT* __last  = __buf->_M_egptr();
      //casting numeric_limits<ptrdiff_t>::max to streamsize only works is ptrdiff_t is signed or streamsize representation
      //is larger than ptrdiff_t one.
      typedef char __static_assert[(sizeof(streamsize) > sizeof(ptrdiff_t)) || ((sizeof(streamsize) == sizeof(ptrdiff_t)) && numeric_limits<ptrdiff_t> ::is_signed) ? 1 : -1];
      ptrdiff_t __request = static_cast<ptrdiff_t>((min) (static_cast<streamsize>((numeric_limits<ptrdiff_t> ::max)()), _Num - __n));

      const _CharT* __p  = __scan_delim(__first, __last);
      ptrdiff_t __chunk = (min) (ptrdiff_t(__p - __first), __request);
      _Traits::copy(__s, __first, __chunk);
      __s += __chunk;
      __n += __chunk;
      __buf->_M_gbump((int)__chunk);

      // We terminated by finding delim.
      if (__p != __last && __p - __first <= __request) {
        if (__extract_delim) {
          __n += 1;
          __buf->_M_gbump(1);
        }
        __done = true;
      }

      // We terminated by reading all the characters we were asked for.
      else if (__n == _Num) {

        // Find out if we have reached eof.  This matters for getline.
        if (__is_getline) {
          if (__chunk == __last - __first) {
            if (__that->_S_eof(__buf->sgetc()))
              __status |= ios_base::eofbit;
          }
          else
            __status |= ios_base::failbit;
        }
        __done   = true;
      }

      // The buffer contained fewer than _Num - __n characters.  Either we're
      // at eof, or we should refill the buffer and try again.
      else {
        if (__that->_S_eof(__buf->sgetc())) {
          __status |= ios_base::eofbit;
          __done = true;
        }
      }
    } // Close the while loop.
  }
  if (false) {
    __that->_M_handle_exception(ios_base::badbit);
    __done = true;
  }

  if (__done) {
    if (__append_null)
        *__s =  _CharT();
    if (__status != 0)
      __that->setstate(__status);   // This might throw.
    return __n;
  }

  // If execution has reached this point, then we have an empty buffer but
  // we have not reached eof.  What that means is that the streambuf has
  // decided to switch from buffered to unbuffered input.  We switch to
  // to __read_unbuffered.

  return __n + __read_unbuffered(__that,  __buf, _Num - __n, __s, __is_delim,
                                 __extract_delim,__append_null,__is_getline);
}

}

template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>::get(_CharT* __s, streamsize __n,
                                    _CharT __delim) {
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;

  if (__sentry) {
    if (__n > 0) {
      basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();

      if (__buf->egptr() != __buf->gptr())
        this->_M_gcount =
          ::std::priv:: __read_buffered(this,  __buf, __n - 1, __s,
                                     ::std::priv:: _Eq_char_bound<_Traits>(__delim),
                                     ::std::priv:: _Scan_for_char_val<_Traits>(__delim),
                                     false, true, false);
      else
        this->_M_gcount =
          ::std::priv:: __read_unbuffered(this,  __buf, __n - 1, __s,
                                       ::std::priv:: _Eq_char_bound<_Traits>(__delim),
                                       false, true, false);
    }
  }

  if (this->_M_gcount == 0)
    this->setstate(ios_base::failbit);

  return *this;
}

// Getline is essentially identical to get, except that it extracts
// the delimiter.
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>::getline(_CharT* __s, streamsize __n,
                                        _CharT __delim) {
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;

  if (__sentry) {
    if (__n > 0) {
      basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
      this->_M_gcount = __buf->egptr() != __buf->gptr()
        ? ::std::priv:: __read_buffered(this,  __buf, __n - 1, __s,
                                     ::std::priv:: _Eq_char_bound<_Traits>(__delim),
                                     ::std::priv:: _Scan_for_char_val<_Traits>(__delim),
                                     true, true, true)
        : ::std::priv:: __read_unbuffered(this,  __buf, __n - 1, __s,
                                       ::std::priv:: _Eq_char_bound<_Traits>(__delim),
                                       true, true, true);
    }
  }

  if (this->_M_gcount == 0)
    this->setstate(ios_base::failbit);

  return *this;
}

// Read n characters.  We don't look for any delimiter, and we don't
// put in a terminating null character.
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>::read(char_type* __s, streamsize __n) {
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;

  if (__sentry && !this->eof()) {
    basic_streambuf<_CharT, _Traits>*__buf = this->rdbuf();
    if (__buf->gptr() != __buf->egptr())
      _M_gcount
        = ::std::priv:: __read_buffered(this,  __buf, __n, __s,
                                     ::std::priv:: _Constant_unary_fun<bool, int_type>(false),
                                     ::std::priv:: _Project2nd<const _CharT*, const _CharT*>(),
                                     false, false, false);
    else
      _M_gcount
        = ::std::priv:: __read_unbuffered(this,  __buf, __n, __s,
                                       ::std::priv:: _Constant_unary_fun<bool, int_type>(false),
                                       false, false, false);
  }
  else
    this->setstate(ios_base::failbit);

  if (this->eof())
    this->setstate(ios_base::eofbit | ios_base::failbit);

  return *this;
}


// Read n or fewer characters.  We don't look for any delimiter, and
// we don't put in a terminating null character.
template <class _CharT, class _Traits>
streamsize
basic_istream<_CharT, _Traits>::readsome(char_type* __s, streamsize __nmax) {
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;

  if (__sentry && !this->eof() && __nmax >= 0) {

    basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
    streamsize __avail = __buf->in_avail();

    // fbp : isn't full-blown setstate required here ?
    if (__avail == -1)
      this->_M_setstate_nothrow(ios_base::eofbit);

    else if (__avail != 0) {

      if (__buf->gptr() != __buf->egptr())
        _M_gcount
          = ::std::priv:: __read_buffered(this,  __buf, (min) (__avail, __nmax), __s,
                                       ::std::priv:: _Constant_unary_fun<bool, int_type>(false),
                                       ::std::priv:: _Project2nd<const _CharT*, const _CharT*>(),
                                       false, false, false);
      else
        _M_gcount
          = ::std::priv:: __read_unbuffered(this,  __buf, (min) (__avail, __nmax), __s,
                                         ::std::priv:: _Constant_unary_fun<bool, int_type>(false),
                                         false, false, false);
    }
  }
  else {
    // fbp : changed so that failbit is set only there, to pass Dietmar's test
    if (this->eof())
      this->setstate(ios_base::eofbit | ios_base::failbit);
    else
      this->setstate(ios_base::failbit);
  }

  //  if (this->eof())
  //    this->setstate(ios_base::eofbit | ios_base::failbit);

  return _M_gcount;
}

template <class _CharT, class _Traits>
void basic_istream<_CharT, _Traits>::_M_formatted_get(_CharT* __s) {
  sentry __sentry(*this); // Skip whitespace.

  if (__sentry) {
    basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
    streamsize __nmax = this->width() > 0
      ? this->width() - 1
      : ((numeric_limits<streamsize>::max)() / sizeof(_CharT)) - 1;

    streamsize __n = __buf->gptr() != __buf->egptr()
      ? ::std::priv:: __read_buffered(this,  __buf, __nmax, __s,
                                   ::std::priv:: _Is_wspace_null<_Traits>(this->_M_ctype_facet()),
                                   ::std::priv:: _Scan_wspace_null<_Traits>(this->_M_ctype_facet()),
                                   false, true, false)
      : ::std::priv:: __read_unbuffered(this,  __buf, __nmax, __s,
                                     ::std::priv:: _Is_wspace_null<_Traits>(this->_M_ctype_facet()),
                                     false, true, false);
    if (__n == 0)
      this->setstate(ios_base::failbit);
  }
  this->width(0);
}

// A generic unbuffered function for ignoring characters.  We stop
// when we reach EOF, or when the function object __is_delim returns
// true.  In the last case, it extracts the character for which
// __is_delim is true, if and only if __extract_delim is true.

template < class _CharT, class _Traits, class _Is_Delim>
void 
_M_ignore_unbuffered(basic_istream<_CharT, _Traits>* __that,
                     basic_streambuf<_CharT, _Traits>* __buf,
                     _Is_Delim __is_delim,
                     bool __extract_delim, bool __set_failbit) {
  bool __done = false;
  ios_base::iostate __status = 0;
  typedef typename basic_istream<_CharT, _Traits>::int_type int_type;

   {
    while (!__done) {
      int_type __c = __buf->sbumpc();

      if (__that->_S_eof(__c)) {
        __done = true;
        __status |= __set_failbit ? ios_base::eofbit | ios_base::failbit
                                  : ios_base::eofbit;
      }

      else if (__is_delim(_Traits::to_char_type(__c))) {
        __done = true;
        if (!__extract_delim)
          if (__that->_S_eof(__buf->sputbackc(_Traits::to_char_type(__c))))
            __status |= ios_base::failbit;
      }
    }
  }
  if (false) {
    __that->_M_handle_exception(ios_base::badbit);
  }

  __that->setstate(__status);
}

// A generic buffered function for ignoring characters.  Much like
// _M_ignore_unbuffered, but with one additional function object:
// __scan_delim(first, last) returns the first pointer p in [first,
// last) such that __is_delim(p) is true.

template < class _CharT, class _Traits, class _Is_Delim, class _Scan_Delim>
void 
_M_ignore_buffered(basic_istream<_CharT, _Traits>* __that,
                   basic_streambuf<_CharT, _Traits>* __buf,
                   _Is_Delim __is_delim, _Scan_Delim __scan_delim,
                   bool __extract_delim, bool __set_failbit) {
  bool __at_eof      = false;
  bool __found_delim = false;

   {
    while (__buf->_M_egptr() != __buf->_M_gptr() && !__at_eof && !__found_delim) {
      const _CharT* __p = __scan_delim(__buf->_M_gptr(), __buf->_M_egptr());
      __buf->_M_gbump((int)(__p - __buf->_M_gptr()));

      if (__p != __buf->_M_egptr()) { // We found delim, so we're done.
        if (__extract_delim)
          __buf->_M_gbump(1);
        __found_delim = true;
      }

      else                         // No delim.  Try to refil the buffer.
        __at_eof = __that->_S_eof(__buf->sgetc());
    }                              // Close the while loop.
  }
  if (false) {
    __that->_M_handle_exception(ios_base::badbit);
    return;
  }

  if (__at_eof) {
    __that->setstate(__set_failbit ? ios_base::eofbit | ios_base::failbit
                                   : ios_base::eofbit);
    return;
  }
  if (__found_delim)
    return;

  // If execution has reached this point, then we have an empty buffer but
  // we have not reached eof.  What that means is that the streambuf has
  // decided to switch from a buffered to an unbuffered mode.  We switch
  // to _M_ignore_unbuffered.
  _M_ignore_unbuffered(__that,  __buf, __is_delim, __extract_delim, __set_failbit);
}

// Overloaded versions of _M_ignore_unbuffered and _M_ignore_unbuffered
// with an explicit count _Num.  Return value is the number of
// characters extracted.
//
// The function object __max_chars takes two arguments, _Num and __n
// (the latter being the number of characters we have already read),
// and returns the maximum number of characters to read from the buffer.
// We parameterize _M_ignore_buffered so that we can use it for both
// bounded and unbounded input; for the former the function object should
// be minus<>, and for the latter it should return a constant maximum value.

template < class _CharT, class _Traits, class _Max_Chars, class _Is_Delim>
streamsize 
_M_ignore_unbuffered(basic_istream<_CharT, _Traits>* __that,
                     basic_streambuf<_CharT, _Traits>* __buf,
                     streamsize _Num, _Max_Chars __max_chars,
                     _Is_Delim __is_delim,
                     bool __extract_delim, bool __set_failbit) {
  streamsize __n = 0;
  ios_base::iostate __status = 0;
  typedef typename basic_istream<_CharT, _Traits>::int_type int_type;

   {
    while (__max_chars(_Num, __n) > 0) {
      int_type __c = __buf->sbumpc();

      if (__that->_S_eof(__c)) {
        __status |= __set_failbit ? ios_base::eofbit | ios_base::failbit
                                  : ios_base::eofbit;
        break;
      }

      else if (__is_delim(_Traits::to_char_type(__c))) {
        if (__extract_delim)
          ++__n;
        else if (__that->_S_eof(__buf->sputbackc(_Traits::to_char_type(__c))))
          __status |= ios_base::failbit;

        break;
      }
      // fbp : added counter increment to pass Dietmar's test
      ++__n;
    }
  }
  if (false) {
    __that->_M_handle_exception(ios_base::badbit);
  }

  if (__status)
    __that->setstate(__status);   // This might throw.
  return __n;
}

template < class _CharT, class _Traits, class _Max_Chars, class _Is_Delim, class _Scan_Delim>
streamsize 
_M_ignore_buffered(basic_istream<_CharT, _Traits>* __that,
                   basic_streambuf<_CharT, _Traits>* __buf,
                   streamsize _Num,
                   _Max_Chars __max_chars,
                   _Is_Delim __is_delim, _Scan_Delim __scan_delim,
                   bool __extract_delim, bool __set_failbit) {
  streamsize __n = 0;
  bool __at_eof = false;
  bool __done   = false;

   {
    while (__buf->_M_egptr() != __buf->_M_gptr() && !__done) {
      ptrdiff_t __avail = __buf->_M_egptr() - __buf->_M_gptr();
      streamsize __m = __max_chars(_Num, __n);

      if (__avail >= __m) {       // We have more characters than we need.
        const _CharT* __last = __buf->_M_gptr() + static_cast<ptrdiff_t>(__m);
        const _CharT* __p = __scan_delim(__buf->_M_gptr(), __last);
        ptrdiff_t __chunk = __p - __buf->_M_gptr();
        __n += __chunk;
        __buf->_M_gbump((int)__chunk);

        if (__extract_delim && __p != __last) {
          __n += 1;
          __buf->_M_gbump(1);
        }

        __done = true;
      }

      else {
        const _CharT* __p = __scan_delim(__buf->_M_gptr(), __buf->_M_egptr());
        ptrdiff_t __chunk = __p - __buf->_M_gptr();
        __n += __chunk;
        __buf->_M_gbump((int)__chunk);

        if (__p != __buf->_M_egptr()) { // We found delim.
          if (__extract_delim) {
            __n += 1;
            __buf->_M_gbump(1);
          }

          __done = true;
        }

        // We didn't find delim.  Try to refill the buffer.
        else if (__that->_S_eof(__buf->sgetc())) {
          __done   = true;
          __at_eof = true;
        }
      }
    } // Close the while loop.
  }
  if (false) {
    __that->_M_handle_exception(ios_base::badbit);
    return __n;
  }

  if (__at_eof)
    __that->setstate(__set_failbit ? ios_base::eofbit | ios_base::failbit
                                   : ios_base::eofbit);

  if (__done)
    return __n;

  // If execution has reached this point, then we have an empty buffer but
  // we have not reached eof.  What that means is that the streambuf has
  // decided to switch from buffered to unbuffered input.  We switch to
  // to _M_ignore_unbuffered.

  return __n + _M_ignore_unbuffered(__that,  __buf, _Num, __max_chars,
                                    __is_delim, __extract_delim, __set_failbit);
}


template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>::ignore(streamsize __n) {
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;

  if (__sentry) {
    basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
    typedef ::std::priv:: _Constant_unary_fun<bool, int_type> _Const_bool;
    typedef ::std::priv:: _Constant_binary_fun<streamsize, streamsize, streamsize> _Const_streamsize;
    const streamsize __maxss = (numeric_limits<streamsize>::max)();

    if (__n == (numeric_limits<int>::max)()) {
      if (__buf->gptr() != __buf->egptr())
        _M_gcount = _M_ignore_buffered(this,  __buf,
                                       __maxss, _Const_streamsize(__maxss),
                                       _Const_bool(false),
                                       ::std::priv:: _Project2nd<const _CharT*, const _CharT*>(),
                                       false, false);
      else
        _M_gcount = _M_ignore_unbuffered(this,  __buf,
                                         __maxss, _Const_streamsize(__maxss),
                                         _Const_bool(false), false, false);
    }
    else {
      if (__buf->gptr() != __buf->egptr())
        _M_gcount = _M_ignore_buffered(this,  __buf,
                                       __n, minus<streamsize>(),
                                       _Const_bool(false),
                                       ::std::priv:: _Project2nd<const _CharT*, const _CharT*>(),
                                       false, false);
      else
        _M_gcount = _M_ignore_unbuffered(this,  __buf, __n, minus<streamsize>(),
                                         _Const_bool(false), false, false);
    }
  }

  return *this;
}

template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>::ignore(streamsize __n, int_type __delim) {
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;

  if (__sentry) {
    basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
    typedef ::std::priv:: _Constant_unary_fun<bool, int_type> _Const_bool;
    typedef ::std::priv:: _Constant_binary_fun<streamsize, streamsize, streamsize>
      _Const_streamsize;
    const streamsize __maxss = (numeric_limits<streamsize>::max)();

    if (__n == (numeric_limits<int>::max)()) {
      if (__buf->gptr() != __buf->egptr())
        _M_gcount = _M_ignore_buffered(this,  __buf,
                                       __maxss, _Const_streamsize(__maxss),
                                       ::std::priv:: _Eq_int_bound<_Traits>(__delim),
                                       ::std::priv:: _Scan_for_int_val<_Traits>(__delim),
                                       true, false);
      else
        _M_gcount = _M_ignore_unbuffered(this,  __buf,
                                         __maxss, _Const_streamsize(__maxss),
                                         ::std::priv:: _Eq_int_bound<_Traits>(__delim),
                                         true, false);
    }
    else {
      if (__buf->gptr() != __buf->egptr())
        _M_gcount = _M_ignore_buffered(this,  __buf,
                                       __n, minus<streamsize>(),
                                       ::std::priv:: _Eq_int_bound<_Traits>(__delim),
                                       ::std::priv:: _Scan_for_int_val<_Traits>(__delim),
                                       true, false);
      else
        _M_gcount = _M_ignore_unbuffered(this,  __buf, __n, minus<streamsize>(),
                                         ::std::priv:: _Eq_int_bound<_Traits>(__delim),
                                         true, false);
    }
  }

  return *this;
}

// This member function does not construct a sentry object, because
// it is called from sentry's constructor.
template <class _CharT, class _Traits>
void basic_istream<_CharT, _Traits>::_M_skip_whitespace(bool __set_failbit) {
  basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
  if (!__buf)
    this->setstate(ios_base::badbit);
  else if (__buf->gptr() != __buf->egptr())
    _M_ignore_buffered(this,  __buf,
                       ::std::priv:: _Is_not_wspace<_Traits>(this->_M_ctype_facet()),
                       ::std::priv:: _Scan_for_not_wspace<_Traits>(this->_M_ctype_facet()),
                       false, __set_failbit);
  else
    _M_ignore_unbuffered(this,  __buf,
                         ::std::priv:: _Is_not_wspace<_Traits>(this->_M_ctype_facet()),
                         false, __set_failbit);
}


// This is a very simple loop that reads characters from __src and puts
// them into __dest.  It looks complicated because of the (standard-
// mandated) exception handling policy.
//
// We stop when we get an exception, when we fail to insert into the
// output streambuf, or when __is_delim is true.

namespace priv {

template < class _CharT, class _Traits, class _Is_Delim>
streamsize 
__copy_unbuffered(basic_istream<_CharT, _Traits>* __that, basic_streambuf<_CharT, _Traits>* __src,
                  basic_streambuf<_CharT, _Traits>* __dest,
                  _Is_Delim __is_delim,
                  bool __extract_delim, bool __rethrow) {
  streamsize __extracted = 0;
  ios_base::iostate __status = 0;
  typedef typename basic_istream<_CharT, _Traits>::int_type int_type;
  int_type __c;

   {
    for (;;) {
      // Get a character. If there's an exception, catch and (maybe) rethrow it.
      __c = __src->sbumpc();

      // If we failed to get a character, then quit.
      if (__that->_S_eof(__c)) {
        __status |= ios_base::eofbit;
        break;
      }
      // If it's the delimiter, then quit.
      else if (__is_delim(_Traits::to_char_type(__c))) {
        if (!__extract_delim && !__pushback(__src, _Traits::to_char_type(__c)))
          __status |= ios_base::failbit;
        break;
      }
      else {
        // Try to put the character in the output streambuf.
        bool __failed = false;
         {
          if (!__that->_S_eof(__dest->sputc(_Traits::to_char_type(__c))))
            ++__extracted;
          else
            __failed = true;
        }
        if (false) {
          __failed = true;
        }

        // If we failed to put the character in the output streambuf, then
        // try to push it back to the input streambuf.
        if (__failed && !__pushback(__src, _Traits::to_char_type(__c)))
          __status |= ios_base::failbit;

        // fbp : avoiding infinite loop in io-27-6-1-2-3.exp
        if (__failed)
          break;
      }

    } /* for (;;) */

  }
  // fbp : this try/catch moved here in reasonable assumption
  // __is_delim never throw (__pushback is guaranteed not to)
  if (false) {
    // See 27.6.1.2.3, paragraph 13.
    if (__rethrow && __extracted == 0)
      __that->_M_handle_exception(ios_base::failbit);
  }
  __that->setstate(__status);
  return __extracted;
}

// Buffered copying from one streambuf to another.  We copy the characters
// in chunks, rather than one at a time.  We still have to worry about all
// of the error conditions we checked in __copy_unbuffered, plus one more:
// the streambuf might decide to switch from a buffered to an unbuffered mode.

template < class _CharT, class _Traits, class _Is_Delim, class _Scan_Delim>
streamsize 
__copy_buffered(basic_istream<_CharT, _Traits>* __that, basic_streambuf<_CharT, _Traits>* __src,
                basic_streambuf<_CharT, _Traits>* __dest,
                _Scan_Delim __scan_delim, _Is_Delim __is_delim,
                bool __extract_delim, bool __rethrow) {
  streamsize __extracted = 0;
  ios_base::iostate __status = 0;
  typedef typename basic_istream<_CharT, _Traits>::int_type int_type;
  //Borland compiler generates a warning if assignment because value is never used:
  int_type __c /*= _Traits::eof()*/;
  _CharT* __first = __src->_M_gptr();
  ptrdiff_t __avail = __src->_M_egptr() - __first;
  // fbp : introduced to move catch/try blocks out of the loop
  bool __do_handle_exceptions = false;

   {
    for (;;) {
      const _CharT* __last = __scan_delim(__first, __src->_M_egptr());

      // Try to copy the entire input buffer to the output buffer.
      streamsize __n = __dest->sputn(__first, __extract_delim && __last != __src->_M_egptr()
                                     ? (__last - __first) + 1
                                     : (__last - __first));
      __src->_M_gbump((int)__n);
      __extracted += __n;

      // from this on, catch() will call _M_handle_exceptions()
      __do_handle_exceptions = true;

      if (__n < __avail)          // We found the delimiter, or else failed to
        break;                    // copy some characters.

      __c = __src->sgetc();

      // Three possibilities: we succeeded in refilling the buffer, or
      // we got EOF, or the streambuf has switched to unbuffered mode.
      __first = __src->_M_gptr();
      __avail = __src->_M_egptr() - __first;

      if (__avail > 0)
        {}  // dwa 1/16/00 -- suppress a Metrowerks warning
      else if (__that->_S_eof(__c)) {
        __status |= ios_base::eofbit;
        break;
      }
      else {
        return __extracted + __copy_unbuffered(__that,  __src, __dest, __is_delim,
                                                __extract_delim, __rethrow);
      }

      __do_handle_exceptions = false;
    }
  }

  if (false) {
    // See 27.6.1.2.3, paragraph 13.
    if (__rethrow && __do_handle_exceptions &&  __extracted == 0)
      __that->_M_handle_exception(ios_base::failbit);
  }

  if (__status)
    __that->setstate(__status);   // This might throw.
  return __extracted;
}

}

template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>
  ::get(basic_streambuf<_CharT, _Traits>& __dest, _CharT __delim) {
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;

  if (__sentry) {
    basic_streambuf<_CharT, _Traits>* __src = this->rdbuf();

    if (__src)
      this->_M_gcount = __src->egptr() != __src->gptr()
        ? ::std::priv:: __copy_buffered(this,  __src, &__dest,
                                     ::std::priv:: _Scan_for_char_val<_Traits>(__delim),
                                     ::std::priv:: _Eq_char_bound<_Traits>(__delim),
                                     false, false)
        : ::std::priv:: __copy_unbuffered(this,  __src, &__dest,
                                       ::std::priv:: _Eq_char_bound<_Traits>(__delim),
                                       false, false);
  }

  if (this->_M_gcount == 0)
    this->setstate(ios_base::failbit);

  return *this;
}

// Copying characters into a streambuf.
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>
  ::operator>>(basic_streambuf<_CharT, _Traits>* __dest) {
  streamsize __n = 0;
  typedef typename basic_istream<_CharT, _Traits>::sentry _Sentry;
  _Sentry __sentry(*this);
  if (__sentry) {
    basic_streambuf<_CharT, _Traits>* __src = this->rdbuf();
    if (__src && __dest)
      __n = __src->egptr() != __src->gptr()
        ? ::std::priv:: __copy_buffered(this,  __src, __dest,
                                     ::std::priv:: _Project2nd<const _CharT*, const _CharT*>(),
                                     ::std::priv:: _Constant_unary_fun<bool, int_type>(false),
                                     false, true)
        : ::std::priv:: __copy_unbuffered(this,  __src, __dest,
                                       ::std::priv:: _Constant_unary_fun<bool, int_type>(false),
                                       false, true);
  }

  if (__n == 0)
    this->setstate(ios_base::failbit);

  return *this;
}

// ----------------------------------------------------------------
// basic_iostream<> class
// ----------------------------------------------------------------

template <class _CharT, class _Traits>
basic_iostream<_CharT, _Traits>
  ::basic_iostream(basic_streambuf<_CharT, _Traits>* __buf)
    : basic_ios<_CharT, _Traits>(),
      basic_istream<_CharT, _Traits>(__buf),
      basic_ostream<_CharT, _Traits>(__buf) {
  this->init(__buf);
}

template <class _CharT, class _Traits>
basic_iostream<_CharT, _Traits>::~basic_iostream()
{}

}



// Local Variables:
// mode:C++
// End:


// Local Variables:
// mode:C++
// End:

// I/O.
namespace std {

template <class _CharT, class _Traits, class _Alloc>
basic_ostream<_CharT, _Traits>& 
operator<<(basic_ostream<_CharT, _Traits>& __os,
           const basic_string<_CharT,_Traits,_Alloc>& __s);


template <class _CharT, class _Traits, class _Alloc, class _Left, class _Right, class _StorageDir>
basic_ostream<_CharT, _Traits>& 
operator<<(basic_ostream<_CharT, _Traits>& __os,
           const ::std::priv:: __bstr_sum<_CharT, _Traits, _Alloc, _Left, _Right, _StorageDir>& __sum) {
  basic_string<_CharT, _Traits, _Alloc> __tmp(__sum);
  return __os << __tmp;
}


template <class _CharT, class _Traits, class _Alloc>
basic_istream<_CharT, _Traits>&  
operator>>(basic_istream<_CharT, _Traits>& __is,
           basic_string<_CharT,_Traits,_Alloc>& __s);

template <class _CharT, class _Traits, class _Alloc>
basic_istream<_CharT, _Traits>& 
getline(basic_istream<_CharT, _Traits>& __is,
        basic_string<_CharT,_Traits,_Alloc>& __s,
        _CharT __delim);


template <class _CharT, class _Traits, class _Alloc>
inline basic_istream<_CharT, _Traits>& 
getline(basic_istream<_CharT, _Traits>& __is,
        basic_string<_CharT,_Traits,_Alloc>& __s) {
  return getline(__is, __s, __is.widen('\n'));
}

}

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/




namespace std {

template <class _CharT, class _Traits>
bool 
__stlp_string_fill(basic_ostream<_CharT, _Traits>& __os,
                   basic_streambuf<_CharT, _Traits>* __buf,
                   streamsize __n) {
  _CharT __f = __os.fill();
  for (streamsize __i = 0; __i < __n; ++__i) {
    if (_Traits::eq_int_type(__buf->sputc(__f), _Traits::eof()))
      return false;
  }
  return true;
}


template <class _CharT, class _Traits, class _Alloc>
basic_ostream<_CharT, _Traits>& 
operator << (basic_ostream<_CharT, _Traits>& __os,
             const basic_string<_CharT,_Traits,_Alloc>& __s) {
  typedef basic_ostream<_CharT, _Traits> __ostream;
  typedef typename basic_string<_CharT, _Traits, _Alloc>::size_type size_type;

  // The hypothesis of this implementation is that size_type is unsigned:
  typedef char __static_assert[static_cast<size_type>(-1) > 0 ? 1 : -1];

  typename __ostream::sentry __sentry(__os);
  bool __ok = false;

  if (__sentry) {
    __ok = true;
    size_type __n = __s.size();
    const bool __left = (__os.flags() & __ostream::left) != 0;
    const streamsize __w = __os.width(0);
    basic_streambuf<_CharT, _Traits>* __buf = __os.rdbuf();

    const bool __need_pad = (((sizeof(streamsize) > sizeof(size_t)) && (static_cast<streamsize>(__n) < __w)) ||
                             ((sizeof(streamsize) <= sizeof(size_t)) && (__n < static_cast<size_t>(__w))));
    streamsize __pad_len = __need_pad ? __w - __n : 0;

    if (!__left)
      __ok = __stlp_string_fill(__os, __buf, __pad_len);

    __ok = __ok && (__buf->sputn(__s.data(), streamsize(__n)) == streamsize(__n));

    if (__left)
      __ok = __ok && __stlp_string_fill(__os, __buf, __pad_len);
  }

  if (!__ok)
    __os.setstate(__ostream::failbit);

  return __os;
}

template <class _CharT, class _Traits, class _Alloc>
basic_istream<_CharT, _Traits>& 
operator >> (basic_istream<_CharT, _Traits>& __is,
             basic_string<_CharT,_Traits, _Alloc>& __s) {
  typedef basic_istream<_CharT, _Traits> __istream;
  typedef typename basic_string<_CharT, _Traits, _Alloc>::size_type size_type;

  // The hypothesis of this implementation is that size_type is unsigned:
  typedef char __static_assert[static_cast<size_type>(-1) > 0 ? 1 : -1];

  typename __istream::sentry __sentry(__is);

  if (__sentry) {
    basic_streambuf<_CharT, _Traits>* __buf = __is.rdbuf();
    typedef ctype<_CharT> _C_type;

    const locale& __loc = __is.getloc();
    const _C_type& _Ctype = use_facet<_C_type>(__loc);
    __s.clear();
    streamsize __width = __is.width(0);
    size_type __n;
    if (__width <= 0)
      __n = __s.max_size();
    /* __width can only overflow size_type if sizeof(streamsize) > sizeof(size_type)
     * because here we know that __width is positive and the stattic assertion check
     * that size_type is unsigned.
     */
    else if (sizeof(streamsize) > sizeof(size_type) &&
             (__width > static_cast<streamsize>(__s . max_size())))
      __n = 0;
    else {
      __n = static_cast<size_type>(__width);
      __s.reserve(__n);
    }

    while (__n-- > 0) {
      typename _Traits::int_type __c1 = __buf->sbumpc();
      if (_Traits::eq_int_type(__c1, _Traits::eof())) {
        __is.setstate(__istream::eofbit);
        break;
      }
      else {
        _CharT __c = _Traits::to_char_type(__c1);

        if (_Ctype.is(_C_type::space, __c)) {
          if (_Traits::eq_int_type(__buf->sputbackc(__c), _Traits::eof()))
            __is.setstate(__istream::failbit);
          break;
        }
        else
          __s.push_back(__c);
      }
    }

    // If we have read no characters, then set failbit.
    if (__s.empty())
      __is.setstate(__istream::failbit);
  }
  else
    __is.setstate(__istream::failbit);

  return __is;
}

template <class _CharT, class _Traits, class _Alloc>
basic_istream<_CharT, _Traits>& 
getline(basic_istream<_CharT, _Traits>& __is,
        basic_string<_CharT,_Traits,_Alloc>& __s,
        _CharT __delim) {
  typedef basic_istream<_CharT, _Traits> __istream;
  typedef typename basic_string<_CharT, _Traits, _Alloc>::size_type size_type;
  size_type __nread = 0;
  typename basic_istream<_CharT, _Traits>::sentry __sentry(__is, true);
  if (__sentry) {
    basic_streambuf<_CharT, _Traits>* __buf = __is.rdbuf();
    __s.clear();

    while (__nread < __s.max_size()) {
      int __c1 = __buf->sbumpc();
      if (_Traits::eq_int_type(__c1, _Traits::eof())) {
        __is.setstate(__istream::eofbit);
        break;
      }
      else {
        ++__nread;
        _CharT __c = _Traits::to_char_type(__c1);
        if (!_Traits::eq(__c, __delim))
          __s.push_back(__c);
        else
          break;              // Character is extracted but not appended.
      }
    }
  }
  if (__nread == 0 || __nread >= __s.max_size())
    __is.setstate(__istream::failbit);

  return __is;
}

}


// Local Variables:
// mode:C++
// End:



/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> and modified by         */
/* Texas Instruments.                                                         */
/******************************************************************************/

/* NOTE : this header has no guards and is MEANT for multiple inclusion!
 * If you are using "header protection" option with your compiler,
 * please also find #pragma which disables it and put it here, to
 * allow reentrancy of this header.
 */


/* If the platform provides any specific epilog actions,
 * like #pragmas, do include platform-specific prolog file
 */

/******************************************************************************/
/* This file was taken from STLport <www.stlport.org> by Texas Instruments.   */
/******************************************************************************/

/*========================================== */






/*
# if defined (_STLP_XXX) && ! defined ( __STL_XXX )
#  define __STL_XXX _STLP_XXX
# endif
*/

/* 5.0 -> 4.6 compatibility section */

/* provide a uniform way to access full functionality */






// Local Variables:
// mode:C++
// End:

/*
 * The MySensors Arduino library handles the wireless radio link and protocol
 * between your home built sensors/actuators and HA controller of choice.
 * The sensors forms a self healing radio network with optional repeaters. Each
 * repeater and gateway builds a routing tables in EEPROM which keeps track of the
 * network topology allowing messages to be routed to nodes.
 *
 * Created by Henrik Ekblad <henrik.ekblad@mysensors.org>
 * Copyright (C) 2013-2016 Sensnology AB
 * Full contributor list: https://github.com/mysensors/Arduino/graphs/contributors
 *
 * Documentation: http://www.mysensors.org
 * Support Forum: http://forum.mysensors.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 */


/**
 * Indication type
 */
typedef enum {
    INDICATION_TX = 0,                        //!< Sent a message.
    INDICATION_RX,                            //!< Received a message.
                                             
    INDICATION_GW_TX,                         //!< Gateway transmit message.
    INDICATION_GW_RX,                         //!< Gateway receive message.
                                             
    INDICATION_FIND_PARENT,                   //!< Start finding parent node.
    INDICATION_GOT_PARENT,                    //!< Found parent node.
    INDICATION_REQ_NODEID,                    //!< Request node ID.
    INDICATION_GOT_NODEID,                    //!< Got a node ID.
    INDICATION_REQ_REGISTRATION,              //!< Request node registration.
    INDICATION_GOT_REGISTRATION,              //!< Got registration reponse.
    INDICATION_REBOOT,                        //!< Rebooting node.
    INDICATION_PRESENT,                       //!< Presenting node to gateway.
    INDICATION_CLEAR_ROUTING,                 //!< Clear rrouting table requested.
    INDICATION_SLEEP,                         //!< Node goes to sleep.
    INDICATION_WAKEUP,                        //!< Node just woke from sleep.
    INDICATION_FW_UPDATE_START,               //!< Start of OTA firmware update process.
    INDICATION_FW_UPDATE_RX,                  //!< Received a piece of firmware data.

    INDICATION_ERR_START = 100,
    INDICATION_ERR_TX,                        //!< Failed to transmit message.
	INDICATION_ERR_TRANSPORT_FAILURE,		  //!< Transport failure.
    INDICATION_ERR_INIT_TRANSPORT,            //!< MySensors transport hardware (radio) init failure.
    INDICATION_ERR_FIND_PARENT,               //!< Failed to find parent node.
    INDICATION_ERR_GET_NODEID,                //!< Failed to receive node ID.
    INDICATION_ERR_SIGN,                      //!< Error signing.
    INDICATION_ERR_VERSION,                   //!< Protocol version mismatch.
    INDICATION_ERR_NET_FULL,                  //!< Network full. All node ID's are taken.
    INDICATION_ERR_INIT_GWTRANSPORT,          //!< Gateway transport hardware init failure.
    INDICATION_ERR_LOCKED,                    //!< Node is locked.
    INDICATION_ERR_FW_FLASH_INIT,             //!< Firmware update flash initialisation failure.
    INDICATION_ERR_FW_TIMEOUT,                //!< Firmware update timeout.
    INDICATION_ERR_FW_CHECKSUM,               //!< Firmware update checksum mismatch.
    INDICATION_ERR_END
} indication_t;

/**
 * Function which is called when something changes about the internal state of MySensors.
 * @param ind  Event indication of what happened.
 */
void setIndication( const indication_t ind );

/**
 * Allow user to define their own indication handler.
 */
void indication( const indication_t ) __attribute__((weak));





/*****************************************************************************/
/* string.h   v16.12.0                                                       */
/*                                                                           */
/* Copyright (c) 1993-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


#pragma diag_push

/* using declarations must occur outside header guard to support including both
   C and C++-wrapped version of header; see _CPP_STYLE_HEADER check */
/* this code is for C++ mode only and thus also not relevant for MISRA */
#pragma CHECK_MISRA("-19.15")

using std::size_t;
using std::strlen;
using std::strcpy;
using std::strncpy;
using std::strcat;
using std::strncat;
using std::strchr;
using std::strrchr;
using std::strcmp;
using std::strncmp;
using std::strcoll;
using std::strxfrm;
using std::strpbrk;
using std::strspn;
using std::strcspn;
using std::strstr;
using std::strtok;
using std::strerror;
using std::strdup;
using std::memmove;
using std::memcpy;
using std::memcmp;
using std::memchr;
using std::memset;



#pragma diag_pop


/// @brief The command field (message-type) defines the overall properties of a message
typedef enum {
	C_PRESENTATION			= 0,	//!< Sent by a node when they present attached sensors. This is usually done in presentation() at startup.
	C_SET					= 1,	//!< This message is sent from or to a sensor when a sensor value should be updated.
	C_REQ					= 2,	//!< Requests a variable value (usually from an actuator destined for controller).
	C_INTERNAL				= 3,	//!< Internal MySensors messages (also include common messages provided/generated by the library).
	C_STREAM				= 4		//!< For firmware and other larger chunks of data that need to be divided into pieces.
} mysensor_command;

/// @brief Type of sensor (used when presenting sensors)
typedef enum {
	S_DOOR					= 0,	//!< Door sensor, V_TRIPPED, V_ARMED
	S_MOTION				= 1,	//!< Motion sensor, V_TRIPPED, V_ARMED 
	S_SMOKE					= 2,	//!< Smoke sensor, V_TRIPPED, V_ARMED
	S_BINARY				= 3,	//!< Binary light or relay, V_STATUS, V_WATT
	S_LIGHT					= 3,	//!< \deprecated Same as S_BINARY, **** DEPRECATED, DO NOT USE ****
	S_DIMMER				= 4,	//!< Dimmable light or fan device, V_STATUS (on/off), V_PERCENTAGE (dimmer level 0-100), V_WATT 
	S_COVER					= 5,	//!< Blinds or window cover, V_UP, V_DOWN, V_STOP, V_PERCENTAGE (open/close to a percentage)
	S_TEMP					= 6,	//!< Temperature sensor, V_TEMP
	S_HUM					= 7,	//!< Humidity sensor, V_HUM
	S_BARO					= 8,	//!< Barometer sensor, V_PRESSURE, V_FORECAST
	S_WIND					= 9,	//!< Wind sensor, V_WIND, V_GUST
	S_RAIN					= 10,	//!< Rain sensor, V_RAIN, V_RAINRATE
	S_UV					= 11,	//!< Uv sensor, V_UV
	S_WEIGHT				= 12,	//!< Personal scale sensor, V_WEIGHT, V_IMPEDANCE
	S_POWER					= 13,	//!< Power meter, V_WATT, V_KWH, V_VAR, V_VA, V_POWER_FACTOR
	S_HEATER				= 14,	//!< Header device, V_HVAC_SETPOINT_HEAT, V_HVAC_FLOW_STATE, V_TEMP
	S_DISTANCE				= 15,	//!< Distance sensor, V_DISTANCE
	S_LIGHT_LEVEL			= 16,	//!< Light level sensor, V_LIGHT_LEVEL (uncalibrated in percentage),  V_LEVEL (light level in lux)
	S_ARDUINO_NODE			= 17,	//!< Used (internally) for presenting a non-repeating Arduino node
	S_ARDUINO_REPEATER_NODE	= 18,	//!< Used (internally) for presenting a repeating Arduino node 
	S_LOCK					= 19,	//!< Lock device, V_LOCK_STATUS
	S_IR					= 20,	//!< IR device, V_IR_SEND, V_IR_RECEIVE
	S_WATER					= 21,	//!< Water meter, V_FLOW, V_VOLUME
	S_AIR_QUALITY			= 22,	//!< Air quality sensor, V_LEVEL
	S_CUSTOM				= 23,	//!< Custom sensor 
	S_DUST					= 24,	//!< Dust sensor, V_LEVEL
	S_SCENE_CONTROLLER		= 25,	//!< Scene controller device, V_SCENE_ON, V_SCENE_OFF. 
	S_RGB_LIGHT				= 26,	//!< RGB light. Send color component data using V_RGB. Also supports V_WATT 
	S_RGBW_LIGHT			= 27,	//!< RGB light with an additional White component. Send data using V_RGBW. Also supports V_WATT
	S_COLOR_SENSOR			= 28,	//!< Color sensor, send color information using V_RGB
	S_HVAC					= 29,	//!< Thermostat/HVAC device. V_HVAC_SETPOINT_HEAT, V_HVAC_SETPOINT_COLD, V_HVAC_FLOW_STATE, V_HVAC_FLOW_MODE, V_TEMP
	S_MULTIMETER			= 30,	//!< Multimeter device, V_VOLTAGE, V_CURRENT, V_IMPEDANCE 
	S_SPRINKLER				= 31,	//!< Sprinkler, V_STATUS (turn on/off), V_TRIPPED (if fire detecting device)
	S_WATER_LEAK			= 32,	//!< Water leak sensor, V_TRIPPED, V_ARMED
	S_SOUND					= 33,	//!< Sound sensor, V_TRIPPED, V_ARMED, V_LEVEL (sound level in dB)
	S_VIBRATION				= 34,	//!< Vibration sensor, V_TRIPPED, V_ARMED, V_LEVEL (vibration in Hz)
	S_MOISTURE				= 35,	//!< Moisture sensor, V_TRIPPED, V_ARMED, V_LEVEL (water content or moisture in percentage?) 
	S_INFO					= 36,	//!< LCD text device / Simple information device on controller, V_TEXT
	S_GAS					= 37,	//!< Gas meter, V_FLOW, V_VOLUME
	S_GPS					= 38,	//!< GPS Sensor, V_POSITION
	S_WATER_QUALITY			= 39	//!< V_TEMP, V_PH, V_ORP, V_EC, V_STATUS 
} mysensor_sensor;

/// @brief Type of sensor data (for set/req/ack messages)
typedef enum {
	V_TEMP					= 0,	//!< S_TEMP. Temperature S_TEMP, S_HEATER, S_HVAC
	V_HUM					= 1,	//!< S_HUM. Humidity
	V_STATUS				= 2,	//!< S_BINARY, S_DIMMER, S_SPRINKLER, S_HVAC, S_HEATER. Used for setting/reporting binary (on/off) status. 1=on, 0=off  
	V_LIGHT					= 2,	//!< \deprecated Same as V_STATUS, **** DEPRECATED, DO NOT USE ****
	V_PERCENTAGE			= 3,	//!< S_DIMMER. Used for sending a percentage value 0-100 (%). 
	V_DIMMER				= 3,	//!< \deprecated Same as V_PERCENTAGE, **** DEPRECATED, DO NOT USE **** 
	V_PRESSURE				= 4,	//!< S_BARO. Atmospheric Pressure
	V_FORECAST				= 5,	//!< S_BARO. Whether forecast. string of "stable", "sunny", "cloudy", "unstable", "thunderstorm" or "unknown"
	V_RAIN					= 6,	//!< S_RAIN. Amount of rain
	V_RAINRATE				= 7,	//!< S_RAIN. Rate of rain
	V_WIND					= 8,	//!< S_WIND. Wind speed
	V_GUST					= 9,	//!< S_WIND. Gust
	V_DIRECTION				= 10,	//!< S_WIND. Wind direction 0-360 (degrees)
	V_UV					= 11,	//!< S_UV. UV light level
	V_WEIGHT				= 12,	//!< S_WEIGHT. Weight(for scales etc)
	V_DISTANCE				= 13,	//!< S_DISTANCE. Distance
	V_IMPEDANCE				= 14,	//!< S_MULTIMETER, S_WEIGHT. Impedance value
	V_ARMED					= 15,	//!< S_DOOR, S_MOTION, S_SMOKE, S_SPRINKLER. Armed status of a security sensor. 1 = Armed, 0 = Bypassed
	V_TRIPPED				= 16,	//!< S_DOOR, S_MOTION, S_SMOKE, S_SPRINKLER, S_WATER_LEAK, S_SOUND, S_VIBRATION, S_MOISTURE. Tripped status of a security sensor. 1 = Tripped, 0
	V_WATT					= 17,	//!< S_POWER, S_BINARY, S_DIMMER, S_RGB_LIGHT, S_RGBW_LIGHT. Watt value for power meters
	V_KWH					= 18,	//!< S_POWER. Accumulated number of KWH for a power meter
	V_SCENE_ON				= 19,	//!< S_SCENE_CONTROLLER. Turn on a scene
	V_SCENE_OFF				= 20,	//!< S_SCENE_CONTROLLER. Turn of a scene
	V_HVAC_FLOW_STATE		= 21,	//!< S_HEATER, S_HVAC. HVAC flow state ("Off", "HeatOn", "CoolOn", or "AutoChangeOver") 
	V_HEATER				= 21,	//!< \deprecated Same as V_HVAC_FLOW_STATE, **** DEPRECATED, DO NOT USE ****
	V_HVAC_SPEED			= 22,	//!< S_HVAC, S_HEATER. HVAC/Heater fan speed ("Min", "Normal", "Max", "Auto") 
	V_LIGHT_LEVEL			= 23,	//!< S_LIGHT_LEVEL. Uncalibrated light level. 0-100%. Use V_LEVEL for light level in lux
	V_VAR1					= 24,	//!< VAR1 
	V_VAR2					= 25,	//!< VAR2 
	V_VAR3					= 26,	//!< VAR3
	V_VAR4					= 27,	//!< VAR4
	V_VAR5					= 28,	//!< VAR5
	V_UP					= 29,	//!< S_COVER. Window covering. Up
	V_DOWN					= 30,	//!< S_COVER. Window covering. Down
	V_STOP					= 31,	//!< S_COVER. Window covering. Stop
	V_IR_SEND				= 32,	//!< S_IR. Send out an IR-command
	V_IR_RECEIVE			= 33,	//!< S_IR. This message contains a received IR-command
	V_FLOW					= 34,	//!< S_WATER. Flow of water (in meter)
	V_VOLUME				= 35,	//!< S_WATER. Water volume
	V_LOCK_STATUS			= 36,	//!< S_LOCK. Set or get lock status. 1=Locked, 0=Unlocked
	V_LEVEL					= 37,	//!< S_DUST, S_AIR_QUALITY, S_SOUND (dB), S_VIBRATION (hz), S_LIGHT_LEVEL (lux)
	V_VOLTAGE				= 38,	//!< S_MULTIMETER 
	V_CURRENT				= 39,	//!< S_MULTIMETER
	V_RGB					= 40,	//!< S_RGB_LIGHT, S_COLOR_SENSOR. Sent as ASCII hex: RRGGBB (RR=red, GG=green, BB=blue component)
	V_RGBW					= 41,	//!< S_RGBW_LIGHT. Sent as ASCII hex: RRGGBBWW (WW=white component)
	V_ID					= 42,	//!< Used for sending in sensors hardware ids (i.e. OneWire DS1820b). 
	V_UNIT_PREFIX			= 43,	//!< Allows sensors to send in a string representing the unit prefix to be displayed in GUI, not parsed by controller! E.g. cm, m, km, inch.
	V_HVAC_SETPOINT_COOL	= 44,	//!< S_HVAC. HVAC cool setpoint (Integer between 0-100)
	V_HVAC_SETPOINT_HEAT	= 45,	//!< S_HEATER, S_HVAC. HVAC/Heater setpoint (Integer between 0-100)
	V_HVAC_FLOW_MODE		= 46,	//!< S_HVAC. Flow mode for HVAC ("Auto", "ContinuousOn", "PeriodicOn")
	V_TEXT					= 47,	//!< S_INFO. Text message to display on LCD or controller device
	V_CUSTOM				= 48,	//!< Custom messages used for controller/inter node specific commands, preferably using S_CUSTOM device type.
	V_POSITION				= 49,	//!< GPS position and altitude. Payload: latitude;longitude;altitude(m). E.g. "55.722526;13.017972;18"
	V_IR_RECORD				= 50,	//!< Record IR codes S_IR for playback
	V_PH					= 51,	//!< S_WATER_QUALITY, water PH
    V_ORP					= 52,	//!< S_WATER_QUALITY, water ORP : redox potential in mV
    V_EC					= 53,	//!< S_WATER_QUALITY, water electric conductivity μS/cm (microSiemens/cm)
    V_VAR					= 54,	//!< S_POWER, Reactive power: volt-ampere reactive (var)
    V_VA					= 55,	//!< S_POWER, Apparent power: volt-ampere (VA)
    V_POWER_FACTOR			= 56,	//!< S_POWER, Ratio of real power to apparent power: floating point value in the range [-1,..,1]
} mysensor_data;


/// @brief Type of internal messages (for internal messages)
typedef enum {
	I_BATTERY_LEVEL			= 0,	//!< Battery level
	I_TIME					= 1,	//!< Time
	I_VERSION				= 2,	//!< Version
	I_ID_REQUEST			= 3,	//!< ID request
	I_ID_RESPONSE			= 4,	//!< ID response
	I_INCLUSION_MODE		= 5,	//!< Inclusion mode
	I_CONFIG				= 6,	//!< Config
	I_FIND_PARENT			= 7,	//!< Find parent
	I_FIND_PARENT_RESPONSE	= 8,	//!< Find parent response
	I_LOG_MESSAGE			= 9,	//!< Log message
	I_CHILDREN				= 10,	//!< Children
	I_SKETCH_NAME			= 11,	//!< Sketch name
	I_SKETCH_VERSION		= 12,	//!< Sketch version
	I_REBOOT				= 13,	//!< Reboot request
	I_GATEWAY_READY			= 14,	//!< Gateway ready
	I_SIGNING_PRESENTATION	= 15,	//!< Provides signing related preferences (first byte is preference version)
	I_NONCE_REQUEST			= 16,	//!< Request for a nonce
	I_NONCE_RESPONSE		= 17,	//!< Payload is nonce data
	I_HEARTBEAT				= 18,	//!< Heartbeat request
	I_PRESENTATION			= 19,	//!< Presentation message
	I_DISCOVER				= 20,	//!< Discover request
	I_DISCOVER_RESPONSE		= 21,	//!< Discover response
	I_HEARTBEAT_RESPONSE	= 22,	//!< Heartbeat response
	I_LOCKED				= 23,	//!< Node is locked (reason in string-payload)
	I_PING					= 24,	//!< Ping sent to node, payload incremental hop counter
	I_PONG					= 25,	//!< In return to ping, sent back to sender, payload incremental hop counter
	I_REGISTRATION_REQUEST	= 26,	//!< Register request to GW
	I_REGISTRATION_RESPONSE	= 27,	//!< Register response from GW
	I_DEBUG					= 28	//!< Debug message
} mysensor_internal;


/// @brief Type of data stream  (for streamed message)
typedef enum {
	ST_FIRMWARE_CONFIG_REQUEST	= 0,	//!< Request new FW, payload contains current FW details
	ST_FIRMWARE_CONFIG_RESPONSE	= 1,	//!< New FW details to initiate OTA FW update
	ST_FIRMWARE_REQUEST			= 2,	//!< Request FW block
	ST_FIRMWARE_RESPONSE		= 3,	//!< Response FW block
	ST_SOUND					= 4,	//!< Sound
	ST_IMAGE					= 5		//!< Image
} mysensor_stream;

/// @brief Type of payload
typedef enum {
	P_STRING				= 0,	//!< Payload type is string
	P_BYTE					= 1,	//!< Payload type is byte
	P_INT16					= 2,	//!< Payload type is INT16
	P_UINT16				= 3,	//!< Payload type is UINT16
	P_LONG32				= 4,	//!< Payload type is INT32
	P_ULONG32				= 5,	//!< Payload type is UINT32
	P_CUSTOM				= 6,	//!< Payload type is binary
	P_FLOAT32				= 7		//!< Payload type is float32
} mysensor_payload;





// Getters/setters for special bit fields in header








// internal access for special fields






class MyMessage
{
private:
	char* getCustomString(char *buffer) const;

public:
	// Constructors
	MyMessage();

	MyMessage(uint8_t sensor, uint8_t type);

	char i2h(uint8_t i) const;

	/**
	 * If payload is something else than P_STRING you can have the payload value converted
	 * into string representation by supplying a buffer with the minimum size of
	 * 2*MAX_PAYLOAD+1. This is to be able to fit hex-conversion of a full binary payload.
	 */
	char* getStream(char *buffer) const;
	char* getString(char *buffer) const;
	const char* getString() const;
	void* getCustom() const;
	bool getBool() const;
	uint8_t getByte() const;
	float getFloat() const;
	int16_t getInt() const;
	uint16_t getUInt() const;
	int32_t getLong() const;
	uint32_t getULong() const;

	// Getter for command type
	uint8_t getCommand() const;

	// Getter for ack-flag. True if this is an ack message.
	bool isAck() const;

	// Setters for building message "on the fly"
	MyMessage& setType(uint8_t type);
	MyMessage& setSensor(uint8_t sensor);
	MyMessage& setDestination(uint8_t destination);

	// Setters for payload
	MyMessage& set(void* payload, uint8_t length);
	MyMessage& set(const char* value);
	MyMessage& set(float value, uint8_t decimals);
	MyMessage& set(bool value);
	MyMessage& set(uint8_t value);
	MyMessage& set(uint32_t value);
	MyMessage& set(int32_t value);
	MyMessage& set(uint16_t value);
	MyMessage& set(int16_t value);

	uint8_t last;            	 // 8 bit - Id of last node this message passed
	uint8_t sender;          	 // 8 bit - Id of sender node (origin)
	uint8_t destination;     	 // 8 bit - Id of destination node

	uint8_t version_length;		 // 2 bit - Protocol version
			                     // 1 bit - Signed flag
			                     // 5 bit - Length of payload
	uint8_t command_ack_payload; // 3 bit - Command type
	                             // 1 bit - Request an ack - Indicator that receiver should send an ack back.
								 // 1 bit - Is ack messsage - Indicator that this is the actual ack message.
	                             // 3 bit - Payload data type
	uint8_t type;            	 // 8 bit - Type varies depending on command
	uint8_t sensor;          	 // 8 bit - Id of sensor that this message concerns.

	// Each message can transfer a payload. We add one extra byte for string
	// terminator \0 to be "printable" this is not transferred OTA
	// This union is used to simplify the construction of the binary data types transferred.
	union {
		uint8_t bValue;
		uint16_t uiValue;
		int16_t iValue;
		uint32_t ulValue;
		int32_t lValue;
		struct { // Float messages
			float fValue;
			uint8_t fPrecision;   // Number of decimals when serializing
		};
		struct {  // Presentation messages
			uint8_t version; 	  // Library version
   		    uint8_t sensorType;   // Sensor type hint for controller, see table above
		};
		char data[(32 - 7) + 1];
	} __attribute__((packed));
} __attribute__((packed));

/** @}*/
/*****************************************************************************/
/* STDIO.H v16.12.0                                                          */
/*                                                                           */
/* Copyright (c) 1993-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/

using std::size_t;
using std::FILE;
using std::fpos_t;
using std::_ftable;
using std::__TI_tmpnams;
using std::remove;
using std::rename;
using std::tmpfile;
using std::tmpnam;
using std::fclose;
using std::fopen;
using std::freopen;
using std::setbuf;
using std::setvbuf;
using std::fflush;
using std::fprintf;
using std::fscanf;
using std::printf;
using std::scanf;
using std::sprintf;
using std::snprintf;
using std::sscanf;
using std::vfprintf;
using std::vprintf;
using std::vsprintf;
using std::vsnprintf;
using std::fgetc;
using std::fgets;
using std::fputc;
using std::fputs;
using std::getc;
using std::getchar;
using std::gets;
using std::putc;
using std::putchar;
using std::puts;
using std::ungetc;
using std::fread;
using std::fwrite;
using std::fgetpos;
using std::fseek;
using std::fsetpos;
using std::ftell;
using std::rewind;
using std::clearerr;
using std::feof;
using std::ferror;
using std::perror;



/*****************************************************************************/
/* stdlib.h   v16.12.0                                                       */
/*                                                                           */
/* Copyright (c) 1993-2016 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


#pragma diag_push

/* using declarations must occur outside header guard to support including both
   C and C++-wrapped version of header; see _CPP_STYLE_HEADER check */
/* this code is for C++ mode only and thus also not relevant for MISRA */
#pragma CHECK_MISRA("-19.15")

using std::div_t;
using std::ldiv_t;
using std::lldiv_t;
using std::size_t;
using std::abs;
using std::labs;
using std::atoi;
using std::atol;
using std::llabs;
using std::atoll;
using std::atof;
using std::strtol;
using std::strtoul;
using std::strtoll;
using std::strtoull;
using std::strtof;
using std::strtod;
using std::strtold;
using std::rand;
using std::srand;
using std::calloc;
using std::malloc;
using std::realloc;
using std::free;
using std::memalign;
using std::abort;
using std::atexit;
using std::bsearch;
using std::qsort;
using std::exit;
using std::div;
using std::ldiv;
using std::lldiv;
using std::getenv;
using std::system;
using std::mblen;
using std::mbtowc;
using std::wctomb;
using std::mbstowcs;
using std::wcstombs;

#pragma diag_pop

#pragma diag_push

/* C2000-specific additions to header implemented with #include */
#pragma CHECK_MISRA("-19.1")
#pragma CHECK_MISRA("-19.15")


#pragma diag_pop


//My Code


//My code

MyMessage::MyMessage() {
	destination = 0; // Gateway is default destination
}

MyMessage::MyMessage(uint8_t _sensor, uint8_t _type) {
	destination = 0; // Gateway is default destination
	sensor = _sensor;
	type = _type;
}

bool MyMessage::isAck() const {
	return ((bool)( ((command_ack_payload)>>(4)) & ( ( 1<<(1) )-1 ) ));
}

uint8_t MyMessage::getCommand() const {
	return ((uint8_t)( ((command_ack_payload)>>(0)) & ( ( 1<<(3) )-1 ) ));
}

/* Getters for payload converted to desired form */
void* MyMessage::getCustom() const {
	return (void *)data;
}

const char* MyMessage::getString() const {
	uint8_t payloadType = (uint8_t)( ((command_ack_payload)>>(5)) & ( ( 1<<(3) )-1 ) );
	if (payloadType == P_STRING) {
		return data;
	} else {
		return 0;
	}
}

// handles single character hex (0 - 15)
char MyMessage::i2h(uint8_t i) const {
	uint8_t k = i & 0x0F;
	if (k <= 9)
		return '0' + k;
	else
		return 'A' + k - 10;
}

char* MyMessage::getCustomString(char *buffer) const {
	for (uint8_t i = 0; i < ((uint8_t)( ((version_length)>>(3)) & ( ( 1<<(5) )-1 ) )); i++)
	{
		buffer[i * 2] = i2h(data[i] >> 4);
		buffer[(i * 2) + 1] = i2h(data[i]);
	}
	buffer[((uint8_t)( ((version_length)>>(3)) & ( ( 1<<(5) )-1 ) )) * 2] = '\0';
	return buffer;
}

char* MyMessage::getStream(char *buffer) const {
	uint8_t cmd = ((uint8_t)( ((command_ack_payload)>>(0)) & ( ( 1<<(3) )-1 ) ));
	if ((cmd == C_STREAM) && (buffer != 0)) {
		return getCustomString(buffer);
	} else {
		return 0;
	}
}

/*char* MyMessage::getString(char *buffer) const {
	uint8_t payloadType = miGetPayloadType();
	if (buffer != NULL) {
		if (payloadType == P_STRING) {
			strncpy(buffer, data, miGetLength());
			buffer[miGetLength()] = 0;
		} else if (payloadType == P_BYTE) {
			itoa(bValue, buffer, 10);
		} else if (payloadType == P_INT16) {
			itoa(iValue, buffer, 10);
		} else if (payloadType == P_UINT16) {
			utoa(uiValue, buffer, 10);
		} else if (payloadType == P_LONG32) {
			ltoa(lValue, buffer, 10);
		} else if (payloadType == P_ULONG32) {
			ultoa(ulValue, buffer, 10);
		} else if (payloadType == P_FLOAT32) {
			dtostrf(fValue,2,min(fPrecision, 8),buffer);
		} else if (payloadType == P_CUSTOM) {
			return getCustomString(buffer);
		}
		return buffer;
	} else {
		return NULL;
	}
}*/

bool MyMessage::getBool() const {
	return getByte();
}

uint8_t MyMessage::getByte() const {
	if ((uint8_t)( ((command_ack_payload)>>(5)) & ( ( 1<<(3) )-1 ) ) == P_BYTE) {
		return data[0];
	} else if ((uint8_t)( ((command_ack_payload)>>(5)) & ( ( 1<<(3) )-1 ) ) == P_STRING) {
		return atoi(data);
	} else {
		return 0;
	}
}


float MyMessage::getFloat() const {
	if ((uint8_t)( ((command_ack_payload)>>(5)) & ( ( 1<<(3) )-1 ) ) == P_FLOAT32) {
		return fValue;
	} else if ((uint8_t)( ((command_ack_payload)>>(5)) & ( ( 1<<(3) )-1 ) ) == P_STRING) {
		return atof(data);
	} else {
		return 0;
	}
}

int32_t MyMessage::getLong() const {
	if ((uint8_t)( ((command_ack_payload)>>(5)) & ( ( 1<<(3) )-1 ) ) == P_LONG32) {
		return lValue;
	} else if ((uint8_t)( ((command_ack_payload)>>(5)) & ( ( 1<<(3) )-1 ) ) == P_STRING) {
		return atol(data);
	} else {
		return 0;
	}
}

uint32_t MyMessage::getULong() const {
	if ((uint8_t)( ((command_ack_payload)>>(5)) & ( ( 1<<(3) )-1 ) ) == P_ULONG32) {
		return ulValue;
	} else if ((uint8_t)( ((command_ack_payload)>>(5)) & ( ( 1<<(3) )-1 ) ) == P_STRING) {
		return atol(data);
	} else {
		return 0;
	}
}

int16_t MyMessage::getInt() const {
	if ((uint8_t)( ((command_ack_payload)>>(5)) & ( ( 1<<(3) )-1 ) ) == P_INT16) { 
		return iValue;
	} else if ((uint8_t)( ((command_ack_payload)>>(5)) & ( ( 1<<(3) )-1 ) ) == P_STRING) {
		return atoi(data);
	} else {
		return 0;
	}
}

uint16_t MyMessage::getUInt() const {
	if ((uint8_t)( ((command_ack_payload)>>(5)) & ( ( 1<<(3) )-1 ) ) == P_UINT16) { 
		return uiValue;
	} else if ((uint8_t)( ((command_ack_payload)>>(5)) & ( ( 1<<(3) )-1 ) ) == P_STRING) {
		return atoi(data);
	} else {
		return 0;
	}

}

MyMessage& MyMessage::setType(uint8_t _type) {
	type = _type;
	return *this;
}

MyMessage& MyMessage::setSensor(uint8_t _sensor) {
	sensor = _sensor;
	return *this;
}

MyMessage& MyMessage::setDestination(uint8_t _destination) {
	destination = _destination;
	return *this;
}

// Set payload
MyMessage& MyMessage::set(void* value, uint8_t length) {
	( command_ack_payload= ((command_ack_payload) &~ ( ( ( 1<<(3) )-1 )<<(5) )) | ( ((P_CUSTOM)&( ( 1<<(3) )-1 )) << (5) ) );
	( version_length= ((version_length) &~ ( ( ( 1<<(5) )-1 )<<(3) )) | ( ((length)&( ( 1<<(5) )-1 )) << (3) ) );
	memcpy(data, value, (((length) < ((32 - 7))) ? (length) : ((32 - 7))));
	return *this;
}

MyMessage& MyMessage::set(const char* value) {
	uint8_t length = value == 0 ? 0 : (((strlen(value)) < ((32 - 7))) ? (strlen(value)) : ((32 - 7)));
	( version_length= ((version_length) &~ ( ( ( 1<<(5) )-1 )<<(3) )) | ( ((length)&( ( 1<<(5) )-1 )) << (3) ) );
	( command_ack_payload= ((command_ack_payload) &~ ( ( ( 1<<(3) )-1 )<<(5) )) | ( ((P_STRING)&( ( 1<<(3) )-1 )) << (5) ) );
	if (length) {		
		strncpy(data, value, length);
	}
	// null terminate string
	data[length] = 0;
	return *this;
}

MyMessage& MyMessage::set(bool value) {
	( version_length= ((version_length) &~ ( ( ( 1<<(5) )-1 )<<(3) )) | ( ((1)&( ( 1<<(5) )-1 )) << (3) ) );
	( command_ack_payload= ((command_ack_payload) &~ ( ( ( 1<<(3) )-1 )<<(5) )) | ( ((P_BYTE)&( ( 1<<(3) )-1 )) << (5) ) );
	data[0] = value;
	return *this;
}

MyMessage& MyMessage::set(uint8_t value) {
	( version_length= ((version_length) &~ ( ( ( 1<<(5) )-1 )<<(3) )) | ( ((1)&( ( 1<<(5) )-1 )) << (3) ) );
	( command_ack_payload= ((command_ack_payload) &~ ( ( ( 1<<(3) )-1 )<<(5) )) | ( ((P_BYTE)&( ( 1<<(3) )-1 )) << (5) ) );
	data[0] = value;
	return *this;
}

MyMessage& MyMessage::set(float value, uint8_t decimals) {
	( version_length= ((version_length) &~ ( ( ( 1<<(5) )-1 )<<(3) )) | ( ((5)&( ( 1<<(5) )-1 )) << (3) ) ); // 32 bit float + persi
	( command_ack_payload= ((command_ack_payload) &~ ( ( ( 1<<(3) )-1 )<<(5) )) | ( ((P_FLOAT32)&( ( 1<<(3) )-1 )) << (5) ) );
	fValue=value;
	fPrecision = decimals;
	return *this;
}

MyMessage& MyMessage::set(uint32_t value) {
	( command_ack_payload= ((command_ack_payload) &~ ( ( ( 1<<(3) )-1 )<<(5) )) | ( ((P_ULONG32)&( ( 1<<(3) )-1 )) << (5) ) );
	( version_length= ((version_length) &~ ( ( ( 1<<(5) )-1 )<<(3) )) | ( ((4)&( ( 1<<(5) )-1 )) << (3) ) );
	ulValue = value;
	return *this;
}

MyMessage& MyMessage::set(int32_t value) {
	( command_ack_payload= ((command_ack_payload) &~ ( ( ( 1<<(3) )-1 )<<(5) )) | ( ((P_LONG32)&( ( 1<<(3) )-1 )) << (5) ) );
	( version_length= ((version_length) &~ ( ( ( 1<<(5) )-1 )<<(3) )) | ( ((4)&( ( 1<<(5) )-1 )) << (3) ) );
	lValue = value;
	return *this;
}

MyMessage& MyMessage::set(uint16_t value) {
	( command_ack_payload= ((command_ack_payload) &~ ( ( ( 1<<(3) )-1 )<<(5) )) | ( ((P_UINT16)&( ( 1<<(3) )-1 )) << (5) ) );
	( version_length= ((version_length) &~ ( ( ( 1<<(5) )-1 )<<(3) )) | ( ((2)&( ( 1<<(5) )-1 )) << (3) ) );
	uiValue = value;
	return *this;
}

MyMessage& MyMessage::set(int16_t value) {
	( command_ack_payload= ((command_ack_payload) &~ ( ( ( 1<<(3) )-1 )<<(5) )) | ( ((P_INT16)&( ( 1<<(3) )-1 )) << (5) ) );
	( version_length= ((version_length) &~ ( ( ( 1<<(5) )-1 )<<(3) )) | ( ((2)&( ( 1<<(5) )-1 )) << (3) ) );
	iValue = value;
	return *this;
}
