/*
 *
 */

#ifndef LN1DEMO_SRC_MISC_H_
#define LN1DEMO_SRC_MISC_H_

#include "HL_hal_stdtypes.h"

#define ASCII_NULL   0
#define ASCII_LF    10
#define ASCII_CR    13

typedef enum {
  PROCB,
  NAVB,
  ACTB
} PmId_T;
#define PmId_First PROCB
#define PmId_Last  ACTB
#define PmId_Range ((PmId_Last - PmId_First) + 1)

PmId_T PmId;

void getBoardIdentification(void); /* Requires gio to be initialized */

uint32 Prng (volatile uint32 *Seed);

/*
 * All the beneath requires sci to be initialized as these interact with the terminal on sci1.
 */

void Puts(const char *const str);

void PutH64(const uint64 val);
void PutH32(const uint32 val);
void PutH16(const uint16 val);
void PutH8 (const uint8 val);

void Gets(char *const str);

void DumpB8(uint8 *ptr, int len);

void DumpErrors(void);

#endif /* LN1DEMO_SRC_MISC_H_ */
