#ifndef NMLV_MESSAGES_H_
#define NMLV_MESSAGES_H_

// enum di raccordo tra lato application e lato ftte
typedef enum {
  NMLV_TRIGGERED_MESSAGE,
  FNC_ACTB_COMMAND_EV,
  FNC_ACTB_COMMAND_TVC,
  FNC_NAV_RECEIVE_DATA
} nmlv_message_name_t;

/*FNC_NAV_Receive payload Structure */
typedef struct FNC_NAV_Receive_data_payload
{
    uint64 attmes_phy; /* Destination MAC Address */
    uint64 attmes_psi; /*Source MAC Address. */
    uint64 attmes_theta; /* TPID is fixed to "0x8100" for VLAN Tagged frame */
    uint64 posmes_x; /* PCP + CFI + VID */
    uint64 posmes_y; /* Destination MAC Address */
    uint64 posmes_z; /*Source MAC Address. */
    uint64 vccpf_x; /* TPID is fixed to "0x8100" for VLAN Tagged frame */
    uint64 vccpf_y; /* PCP + CFI + VID */
    uint64 vccpf_z; /* PCP + CFI + VID */
}FNC_NAV_Receive_data_payload_t;

/*FNC_ACTB_Command_EV payload Structure */
typedef struct FNC_ACTB_Command_EV_payload
{
    uint8 activationByte;
}FNC_ACTB_Command_EV_payload_t;

/*FNC_ACTB_Command_TVC payload Structure */
typedef struct FNC_ACTB_Command_TVC_payload
{
    uint8  flags; /* Destination MAC Address */
    uint32 ema_a; /*Source MAC Address. */
    uint32 ema_b; /* TPID is fixed to "0x8100" for VLAN Tagged frame */
}FNC_ACTB_Command_TVC_payload_t;

#endif /* NMLV_MESSAGES_H_ */
