
#include "bl_Controller.h"
#include <hw_gpio.h>
#include <hw_prcm.h>
#include <hw_aon_pmctl.h>
#include <hw_wdt.h>
#include "bl_Global.h"

#pragma SET_CODE_SECTION(".bl_text")

//************************************************************************************************
Tbl_Controller::Tbl_Controller(Tbl_Global& aGlobal) :
//Das Objekt wird ja auf dem Stack erzeugt. Daher mssen alle Varibalen initialisiert werden
    Global(aGlobal),
    pI2CDriver(0),
    mnByteLeftInFrame(0),
    mFrameBufferIndex(0),
    mFrameState(eWaitForLength1),
    mDoReset(false),
    mForEEprom(false),
    mAllDone(false)
{
    Tbl_I2CDriver I2CDriver(Global);
    pI2CDriver = &I2CDriver;
    //Nun noch fr zwei Sekunden auf ein Kabelupdate warten
    uint32_t StartTick = Global.HW.actTickValue();
    do
    {
        pI2CDriver->checkForInterrupts();
        if (pI2CDriver->newFrameReceived)
        {
            if (checkReceivedI2CFrame())
                StartTick -= Global.HW.TickToMs(10000);  //Das beendet die while Schleife
            pI2CDriver->nBytesReceived = 0;
            pI2CDriver->newFrameReceived = false;
        }
        if (Global.HW.delta_ms(StartTick)>2000)
        {
            Global.HW.SignalPoint(1);
            StartTick = Global.HW.actTickValue();
        }
    }
    while (true);  //Global.HW.delta_ms(StartTick)<10000);
    //HWREG(WDT_BASE + WDT_O_LOAD) = 0;
    //Global.HW.SignalPoint(5);

}

//************************************************************************************************
Tbl_Controller::~Tbl_Controller()
{
}

//************************************************************************************************
//true: nicht weiter auf Daten warten
bool Tbl_Controller::checkReceivedI2CFrame()
{
    if (pI2CDriver->nBytesReceived == 1)
    {
        if (pI2CDriver->ReceivedBytes[0] == 67)   //67 ist das Zeichen 'C'
        {
            pI2CDriver->nBytesReceived = 0;
            pI2CDriver->newFrameReceived = false;
            nI2CFrame = 1;
            nCesFrame = 0;
            sendDeviceDetails();
            return false;
        }
    }
    return false;
}

//************************************************************************************************
void Tbl_Controller::sendDeviceDetails()
{
    pI2CDriver->ToTransmitBytes[0] = 1;
    pI2CDriver->ToTransmitBytes[1] = 2;
    pI2CDriver->ToTransmitBytes[2] = 3;
    pI2CDriver->ToTransmitBytes[3] = 4;
    pI2CDriver->ToTransmitBytes[4] = 5;
    pI2CDriver->allBytesTransmitted = false;
    pI2CDriver->nBytesToTransmit = 5;  //Das Setzen dieses Wertes startet die bertragung

    mFrameState = eWaitForLength1;
    receiveCesFile();

    Global.HW.SignalPoint(1);
}

//************************************************************************************************
void Tbl_Controller::receiveCesFile()
{
    mAllDone = false;
    mDoReset = false;
    mCodeReceived = false;
    uint32_t StartTick = Global.HW.actTickValue();
    do
    {
        pI2CDriver->checkForInterrupts();
        if (pI2CDriver->newFrameReceived)
        {
            nI2CFrame++;
            for(int i=0; (mAllDone == false) && (i < pI2CDriver->nBytesReceived); i++)
                OneFrameByteReceived(pI2CDriver->ReceivedBytes[i]);
            pI2CDriver->nBytesReceived = 0;
            pI2CDriver->newFrameReceived = false;

            if (mAllDone)
            {
                return;
            }
            //mFrameState ist nicht der Zustand des I2C Frames sondern des Frames in der CES Datei
            StartTick = Global.HW.actTickValue();
        }
    }
    while (Global.HW.delta_ms(StartTick)<1000);
}

//************************************************************************************************
void Tbl_Controller::OneFrameByteReceived(uint8_t aByte)
{
}


#pragma SET_CODE_SECTION()

