
#ifndef BL_CONTROLLER_H_
#define BL_CONTROLLER_H_

#include "bl_Hw.h"
#include "bl_I2CDriver.h"

//Forward Declaration der Global Klasse. Es kann kein include benutzt werden,
//da bl_Global.h diese Header Datei inkludiert
class Tbl_Global;

#define BLC_FRAME_SIZE 532

class Tbl_Controller
{
public:
    Tbl_Controller(Tbl_Global& aGlobal);
    ~Tbl_Controller();

private:

    enum eFrameState
    {
        eWaitForLength1,
        eWaitForLength2,
        eWaitForByte,
        eCorrectlyTaken,
        eCrcError,
        eWrongSignature,
        eUnknownCmdFound,
        eInvalidAddressValue,
        eDecryptError,
        eTooLessBytesForCmd,
        eParsingError,
        eInvalidParameterLength,
        eInvalidParameter,
        eInternalError,
    };
    bool checkReceivedI2CFrame();
    void sendDeviceDetails();
    void receiveCesFile();
    void sendFrameAnswer();
    void OneFrameByteReceived(uint8_t aByte);
    void checkReceivedFrame();
    void handleFrame();
    void handleEraseAllCommand(uint32_t& i);
    void handleWriteCommand(uint32_t& i);

    Tbl_Global& Global;
    Tbl_I2CDriver* pI2CDriver;

    uint8_t  mFrameBuffer[BLC_FRAME_SIZE];
    uint32_t mnByteLeftInFrame;
    uint32_t mFrameBufferIndex;
    eFrameState mFrameState;
    bool mDoReset;
    bool mForEEprom;
    bool mAllDone;
    bool mCodeReceived;

    uint32_t nI2CFrame;
    uint32_t nCesFrame;
};

#endif /* BL_CONTROLLER_H_ */
