
#ifndef BL_HW_H_
#define BL_HW_H_

#include <stdint.h>
#include <stdbool.h>
#include <hw_memmap.h>
#include <hw_types.h>
#include <hw_gpt.h>

class Tbl_Hw
{
public:
    Tbl_Hw();
    ~Tbl_Hw();

    inline uint32_t actTickValue()
    {
        return HWREG(GPT0_NONBUF_BASE + GPT_O_TAR);
    };

    inline uint32_t TickToMs(uint32_t aTickValue)
    {
        return aTickValue * 48000;
    }

    void waitTicks(uint32_t nTicks);
    inline void wait_us(uint32_t nuSek)
    {
        waitTicks(nuSek * 48);
    }
    inline void wait_ms(uint32_t nmSek)
    {
        waitTicks(nmSek * 48000);
    }

    inline uint32_t delta_ms(uint32_t startTickValue)
    {
        return (actTickValue()-startTickValue) / 48000;
    }


    void signalError(uint32_t ErrorNumber);
    void doReset();

    void switchRedOn();
    void switchRedOff();
    void switchGreenOn();
    void switchGreenOff();
    void switchBlueOn();
    void switchBlueOff();
    void switchBeeperOn();
    void switchBeeperOff();

    void SignalPoint(int nSignals);

    uint32_t mMisoPin;
    uint32_t mMosiPin;
    uint32_t mSpiClockPin;
    uint32_t mExtFlashChipSelPin;
    bool mAtProgrammingAdapter;

private:
    uint32_t mRedPin;
    bool mRedIsActiveHigh;
    uint32_t mGreenPin;
    bool mGreenIsActiveHigh;
    uint32_t mBluePin;
    bool mBlueIsActiveHigh;
    uint32_t mBeeperPin;
    bool mBeeperSupported;

    void HwInit();
    void waitInit();
    void LedInit();
    void BeeperInit();
};

#endif /* BL_HW_H_ */
