
#ifndef BL_I2CDRIVER_H_
#define BL_I2CDRIVER_H_

//Forward Declaration der Global Klasse. Es kann kein include benutzt werden,
//da bl_Global.h diese Header Datei inkludiert
class Tbl_Global;

#include <stdint.h>
#include <stdbool.h>

class Tbl_I2CDriver
{
public:
    Tbl_I2CDriver(Tbl_Global& aGlobal);
    ~Tbl_I2CDriver();

    static const uint32_t MaxRxBytes = 200;
    static const uint32_t MaxTxBytes = 20;

    void checkForInterrupts();
    uint8_t ReceivedBytes[MaxRxBytes];
    uint32_t nBytesReceived;
    bool newFrameReceived;

    uint8_t ToTransmitBytes[MaxTxBytes];
    uint32_t nBytesToTransmit;  //Das Setzten des Werte aktiviert die bertragung
    uint32_t nBytesAlreadyTransmitted;
    bool allBytesTransmitted;
private:
    Tbl_Global& Global;
    bool ignoreThisFrame;
    bool nothingToSend;

};

#endif /* BL_I2CDRIVER_H_ */
