/*
 *  ======== ti_dmm_application_policy.c ========
 *  Configured DMM module definitions
 *
 *  DO NOT EDIT - This file is generated for the CC1352R1F3RGZ
 *  by the SysConfig tool.
 */

#include <ti_dmm_application_policy.h>

/***** Defines *****/

//! \brief Stack role policy indexes
#define BLE_STACK_POLICY_IDX 0
#define CUSTOM1_STACK_POLICY_IDX 1

DMMPolicy_Policy DMMPolicy_ApplicationPolicy[] = {
    // DMM Policy 0
    {
        // BLE Peripheral Policy
        .appState[BLE_STACK_POLICY_IDX] = {
            .state = DMMPOLICY_APPSTATE_BLE,
            .weight = 50,
            .timingConstraint = DMMPOLICY_TIME_RESERVED,
            .pause = DMMPOLICY_NOT_PAUSED,
            .appliedActivity =  DMMPOLICY_APPLIED_ACTIVITY_NONE,
        },
        // Custom 1 Policy
        .appState[CUSTOM1_STACK_POLICY_IDX] = {
            .state = DMMPOLICY_APPSTATE_BLE,
            .weight = 0,
            .timingConstraint = DMMPOLICY_TIME_RESERVED,
            .pause = DMMPOLICY_NOT_PAUSED,
            .appliedActivity =  DMMPOLICY_APPLIED_ACTIVITY_NONE,
        },
        //Balanced Mode Policy
        .balancedMode = DMMPOLICY_BALANCED_NONE,
    },
};

DMMPolicy_PolicyTable DMMPolicy_ApplicationPolicyTable = {
    //Stack Roles
    .stackRole[BLE_STACK_POLICY_IDX] = DMMPolicy_StackRole_BlePeripheral,
    .stackRole[CUSTOM1_STACK_POLICY_IDX] = DMMPolicy_StackRole_reserved1,
    //Policy table
    .policy = DMMPolicy_ApplicationPolicy,
    // Index Table for future use
    .indexTable = NULL,
};

//! \brief The application policy table size
uint32_t DMMPolicy_ApplicationPolicySize = (sizeof(DMMPolicy_ApplicationPolicy) / sizeof(DMMPolicy_Policy));
