
#include <stdio.h>
#include "init.h"

void OnTargetConnect(void)
{
    printf("\tTarget Connected.\n");
    printf("\t---------------------------------------------\n");

    PSC_All_On();
    Core_300MHz_mDDR_150MHz();

    Wake_DSP();
}

void Wake_DSP(void)
{
    PSC0_LPSC_enableCore(1, LPSC_DSP);

    printf("\tDSP Wake Complete.\n");
    printf("\t---------------------------------------------\n");
}

void Set_Core_456MHz(void) {
    device_PLL0(0,18,0,0,1,11,5);
    printf("\tPLL0 init done for Core:456MHz, EMIFA:38MHz\n");
}
void Set_Core_300MHz(void) {
    device_PLL0(0,24,1,0,1,11,5);
    printf("\tPLL0 init done for Core:300MHz, EMIFA:25MHz\n");
}
void Set_Core_200MHz(void) {
    device_PLL0(0,24,2,0,1,7,3);
    printf("\tPLL0 init done for Core:200MHz, EMIFA:25MHz\n");
}
void Set_Core_100MHz(void) {
    device_PLL0(0,24,5,0,1,3,1);
    printf("\tPLL0 init done for Core:100MHz, EMIFA:25MHz\n");
}

void Set_DDRPLL_150MHz(void) {
    device_PLL1(24,1,0,1,2);
    printf("\tPLL1 init done for DDR:150MHz\n");
}
void Set_DDRPLL_132MHz(void) {
    device_PLL1(21,1,0,1,2);
    printf("\tPLL1 init done for DDR:132MHz\n");
}
void Set_DDRPLL_126MHz(void) {
    device_PLL1(20,1,0,1,2);
    printf("\tPLL1 init done for DDR:126MHz\n");
}
void Set_DDRPLL_102MHz(void) {
    device_PLL1(16,1,0,1,2);
    printf("\tPLL1 init done for DDR:102MHz\n");
}

void Set_DDR2_150MHz(void) {
    printf("\tDDR initialization is in progress....\n");
    Set_DDRPLL_150MHz();
    DEVICE_DDRConfig(DDR2, 150);
    printf("\tDDR2 init for 150 MHz is done\n");
}

void Set_DDR2_132MHz(void) {
    printf("\tDDR initialization is in progress....\n");
    Set_DDRPLL_132MHz();
    DEVICE_DDRConfig(DDR2, 132);
    printf("\tDDR2 init for 132 MHz is done\n");
}

void Set_DDR2_126MHz(void) {
    printf("\tDDR initialization is in progress....\n");
    Set_DDRPLL_126MHz();
    DEVICE_DDRConfig(DDR2, 126);
    printf("\tDDR2 init for 126 MHz is done\n");
}

void Set_DDR2_102MHz(void) {
    printf("\tDDR initialization is in progress....\n");
    Set_DDRPLL_102MHz();
    DEVICE_DDRConfig(DDR2, 102);
    printf("\tDDR init for 102 MHz is done\n");
}

void Core_456MHz_mDDR_150MHz(void) {
    Set_Core_456MHz();
    Set_DDR2_150MHz();
    printf("\t---------------------------------------------\n");
}

void Core_300MHz_mDDR_150MHz(void) {
    Set_Core_300MHz();
    Set_DDR2_150MHz();
    printf("\t---------------------------------------------\n");
}

void Core_300MHz_mDDR_132MHz(void) {
    Set_Core_300MHz();
    Set_DDR2_132MHz();
    printf("\t---------------------------------------------\n");
}

void Core_300MHz_mDDR_126MHz(void) {
    Set_Core_300MHz();
    Set_DDR2_126MHz();
    printf("\t---------------------------------------------\n");
}

void Core_300MHz_mDDR_102MHz(void) {
    Set_Core_300MHz();
    Set_DDR2_102MHz();
    printf("\t---------------------------------------------\n");
}

void Core_200MHz_mDDR_126MHz(void) {
    Set_Core_200MHz();
    Set_DDR2_126MHz();
    printf("\t---------------------------------------------\n");
}

void Core_100MHz_mDDR_102MHz(void) {
    Set_Core_100MHz();
    Set_DDR2_102MHz();
    printf("\t---------------------------------------------\n");
}

void PSC_All_On(void) {
    // PSC0
    PSC0_LPSC_enable(0, LPSC_EDMA_CC0);
    PSC0_LPSC_enable(0, LPSC_EDMA_TC0);
    PSC0_LPSC_enable(0, LPSC_EDMA_TC1);
    PSC0_LPSC_enable(0, LPSC_EMIFA);
    PSC0_LPSC_enable(0, LPSC_SPI0);
    PSC0_LPSC_enable(0, LPSC_MMCSD0);
    PSC0_LPSC_enable(0, LPSC_ARM_AINTC);
    PSC0_LPSC_enable(0, LPSC_ARM_RAMROM);
    PSC0_LPSC_enable(0, LPSC_UART0);
    PSC0_LPSC_enable(0, LPSC_SCR0);
    PSC0_LPSC_enable(0, LPSC_SCR1);
    PSC0_LPSC_enable(0, LPSC_SCR2);

    // PSC1
    PSC1_LPSC_enable(0, LPSC_EDMA_CC1);
    PSC1_LPSC_enable(0, LPSC_USB20);
    PSC1_LPSC_enable(0, LPSC_USB11);
    CFGCHIP2 = 0x09F2;  //Enable USB clock, PHY_PLLON, glue logic mux(USB2 ref clk input)
    PSC1_LPSC_enable(0, LPSC_GPIO);
    PSC1_LPSC_enable(0, LPSC_UHPI);
    PSC1_LPSC_enable(0, LPSC_EMAC);
    PSC1_LPSC_enable(0, LPSC_MCASP0);
    PSC1_LPSC_force(LPSC_SATA);
    PSC1_LPSC_enable(0, LPSC_SATA);
    PSC1_LPSC_enable(0, LPSC_VPIF);
    PSC1_LPSC_enable(0, LPSC_SPI1);
    PSC1_LPSC_enable(0, LPSC_I2C1);
    PSC1_LPSC_enable(0, LPSC_UART1);
    PSC1_LPSC_enable(0, LPSC_UART2);
    PSC1_LPSC_enable(0, LPSC_MCBSP0);
    PSC1_LPSC_enable(0, LPSC_MCBSP1);
    PSC1_LPSC_enable(0, LPSC_LCDC);
    PSC1_LPSC_enable(0, LPSC_EPWM);
    PSC1_LPSC_enable(0, LPSC_MMCSD1);
    PSC1_LPSC_enable(0, LPSC_UPP);
    PSC1_LPSC_enable(0, LPSC_ECAP);
    PSC1_LPSC_enable(0, LPSC_EDMA_TC2);
    PSC1_LPSC_enable(0, LPSC_SCR_F0);
    PSC1_LPSC_enable(0, LPSC_SCR_F1);
    PSC1_LPSC_enable(0, LPSC_SCR_F2);
    PSC1_LPSC_enable(0, LPSC_SCR_F6);
    PSC1_LPSC_enable(0, LPSC_SCR_F7);
    PSC1_LPSC_enable(0, LPSC_SCR_F8);
    PSC1_LPSC_enable(0, LPSC_BR_F7);
    PSC1_LPSC_enable(0, LPSC_SHARED_RAM);

    printf("\tPSC Enable Complete.\n");
    printf("\t---------------------------------------------\n");
}

void EMIFA_NAND_PINMUX(void) {
    PSC0_LPSC_enable(0, LPSC_EMIFA);
    PINMUX7        = (PINMUX7 & ~0x00FF0FF0) | 0x00110110;
    PINMUX8        = 0x11111111;
    PINMUX9        = 0x11111111;
    PINMUX12       = (PINMUX12 & ~0x0FF00000) | 0x01100000;
    EMIFA_ACFG3   |= 0x1;
    EMIFA_NANDFCR  = (EMIFA_NANDFCR & ~0x30) | 0x12;

    printf("\tEMIFA Pins Configured for NAND.\n");
    printf("\t---------------------------------------------\n");
}

/**************************************************************************************************************************************************
   Device_PLL0 init:

   CLKMODE -  0---->On Chip Oscilator  1---->External Oscilator
   PLL0_SYSCLK1 - Fixed ratio /1
   PLL0_SYSCLK2 - Fixed ratio /2
   PLL0_SYSCLK3 - Variable Divider (EMIFA)
   PLL0_SYSCLK4 - Fixed ratio /4
   PLL0_SYSCLK5 - Not used -- do nothing
   PLL0_SYSCLK6 - Fixed ratio /1
   PLL0_SYSCLK7 - Variable Divider (RMII)
******************************************************************************************************************************************************/
void device_PLL0(unsigned int CLKMODE, unsigned int PLLM, unsigned int POSTDIV,unsigned int PLLDIV1, unsigned int PLLDIV2, unsigned int PLLDIV3, unsigned int PLLDIV7 ) {

    unsigned int i=0;

    /* Clear PLL lock bit */
    CFGCHIP0 &= ~(0x00000010);

    /* Set PLLENSRC '0',bit 5, PLL Enable(PLLEN) selection is controlled through MMR */
    PLL0_PLLCTL &= ~(0x00000020);

    /* PLLCTL.EXTCLKSRC bit 9 should be left at 0 for Freon */
    PLL0_PLLCTL &= ~(0x00000200);

    /* Set PLLEN=0 to put in bypass mode*/
    PLL0_PLLCTL &= ~(0x00000001);

    /*wait for 4 cycles to allow PLLEN mux switches properly to bypass clock*/
    for(i=0; i<PLLEN_MUX_SWITCH; i++) {;}

    /* Select the Clock Mode bit 8 as External Clock or On Chip Oscilator*/
    PLL0_PLLCTL &= 0xFFFFFEFF;
    PLL0_PLLCTL |= (CLKMODE << 8);

    /*Clear PLLRST bit to reset the PLL */
    PLL0_PLLCTL &= ~(0x00000008);

    /* Disable the PLL output*/
    PLL0_PLLCTL |= (0x00000010);

    /* PLL initialization sequence
    Power up the PLL by setting PWRDN bit set to 0 */
    PLL0_PLLCTL &= ~(0x00000002);

    /* Enable the PLL output*/
    PLL0_PLLCTL &= ~(0x00000010);

    /*PLL stabilisation time- take out this step , not required here when PLL in bypassmode*/
    for(i=0; i<PLL_STABILIZATION_TIME; i++) {;}

    /*Program the required multiplier value in PLLM*/
    PLL0_PLLM    = PLLM;

    /*If desired to scale all the SYSCLK frequencies of a given PLLC, program the POSTDIV ratio*/
    PLL0_POSTDIV = 0x8000 | POSTDIV;

    /*Check for the GOSTAT bit in PLLSTAT to clear to 0 to indicate that no GO operation is currently in progress*/
    while(PLL0_PLLSTAT & 0x1==1){}

    /*Program the RATIO field in PLLDIVx with the desired divide factors. In addition, make sure in this step you leave the PLLDIVx.DxEN bits set so clocks are still enabled (default).*/
    PLL0_PLLDIV1 = 0x8000 | PLLDIV1;             // Fixed Ratio /1
    PLL0_PLLDIV2 = 0x8000 | PLLDIV2;             // Fixed Ratio /2
    PLL0_PLLDIV4 = 0x8000 | (((PLLDIV1+1)*4)-1); // Fixed Ratio /4
    PLL0_PLLDIV6 = 0x8000 | PLLDIV1;             // Fixed Ratio /1
    PLL0_PLLDIV3 = 0x8000 | PLLDIV3;             // Variable Ratio (EMIF)
    PLL0_PLLDIV7 = 0x8000 | PLLDIV7;             // Variable Ratio (RMII)


    /*Set the GOSET bit in PLLCMD to 1 to initiate a new divider transition.*/
    PLL0_PLLCMD |= 0x1;

    /*Wait for the GOSTAT bit in PLLSTAT to clear to 0 (completion of phase alignment).*/
    while(PLL0_PLLSTAT & 0x1==1) { }

    /*Wait for PLL to reset properly.*/
    for(i=0; i<PLL_RESET_TIME_CNT; i++) {;}

    /*Set the PLLRST bit in PLLCTL to 1 to bring the PLL out of reset*/
    PLL0_PLLCTL |= 0x8;

    /*Wait for PLL to lock.*/
    for(i=0; i<PLL_LOCK_TIME_CNT; i++) {;}

    /*Set the PLLEN bit in PLLCTL to 1 to remove the PLL from bypass mode*/
    PLL0_PLLCTL |=  0x1;
}


/**********************************************************************************
DDR PLL1 init:

***********************************************************************************/

void device_PLL1(unsigned int PLLM,unsigned int POSTDIV,unsigned int PLLDIV1, unsigned int PLLDIV2, unsigned int PLLDIV3 ) {

    unsigned int i=0;

    /* Clear PLL lock bit */
    CFGCHIP3 &= ~(0x00000020);

    /* Set PLLENSRC '0',bit 5, PLL Enable(PLLEN) selection is controlled through MMR */
    PLL1_PLLCTL &= ~(0x00000020);

    /* PLLCTL.EXTCLKSRC bit 9 should be left at 0 for Freon */
    PLL1_PLLCTL &= ~(0x00000200);

    /* Set PLLEN=0 to put in bypass mode*/
    PLL1_PLLCTL &= ~(0x00000001);

    /*wait for 4 cycles to allow PLLEN mux switches properly to bypass clock*/
    for(i=0; i<PLLEN_MUX_SWITCH; i++) {;}

    /*Clear PLLRST bit to reset the PLL */
    PLL1_PLLCTL &= ~(0x00000008);

    /* Disable the PLL output*/
    PLL1_PLLCTL |= (0x00000010);

    /* PLL initialization sequence
    Power up the PLL by setting PWRDN bit set to 0 */
    PLL1_PLLCTL &= ~(0x00000002);

    /* Enable the PLL output*/
    PLL1_PLLCTL &= ~(0x00000010);

    /*PLL stabilisation time- take out this step , not required here when PLL in bypassmode*/
    for(i=0; i<PLL_STABILIZATION_TIME; i++) {;}

    /*Program the required multiplier value in PLLM*/
    PLL1_PLLM    = PLLM;

    /*If desired to scale all the SYSCLK frequencies of a given PLLC, program the POSTDIV ratio*/
    PLL1_POSTDIV = 0x8000 | POSTDIV;

    /*Check for the GOSTAT bit in PLLSTAT to clear to 0 to indicate that no GO operation is currently in progress*/
    while(PLL1_PLLSTAT & 0x1==1){}

    /*Program the RATIO field in PLLDIVx with the desired divide factors. In addition, make sure in this step you leave the PLLDIVx.DxEN bits set so clocks are still enabled (default).*/
    PLL1_PLLDIV1 = 0x8000 | PLLDIV1;   // DDR frequency (aka 2X_CLK)
    PLL1_PLLDIV2 = 0x8000 | PLLDIV2;   // Optional CFGCHIP3[ASYNC3_CLKSRC] clock source
    PLL1_PLLDIV3 = 0x8000 | PLLDIV3;   // Optional PLL0 clock source

    /*Set the GOSET bit in PLLCMD to 1 to initiate a new divider transition.*/
    PLL1_PLLCMD |= 0x1;

    /*Wait for the GOSTAT bit in PLLSTAT to clear to 0 (completion of phase alignment).*/
    while(PLL1_PLLSTAT & 0x1==1) { }

    /*Wait for PLL to reset properly */
    for(i=0; i<PLL_RESET_TIME_CNT; i++) {;}

    /*Set the PLLRST bit in PLLCTL to 1 to bring the PLL out of reset*/
    PLL1_PLLCTL |= 0x8;

    /*Wait for PLL to lock. See PLL spec for PLL lock time*/
    for(i=0; i<PLL_LOCK_TIME_CNT; i++) {;}

    /*Set the PLLEN bit in PLLCTL to 1 to remove the PLL from bypass mode*/
    PLL1_PLLCTL |=  0x1;
}

/**********************************************************************************
Device Kick Unlock:
    Kick0 register + data (unlock)
    Kick1 register + data (unlock)
***********************************************************************************/
void DEVICE_kickUnlock(void) {
    KICK0R = 0x83e70b13;  // Kick0 register + data (unlock)
    KICK1R = 0x95a4f1e0;  // Kick1 register + data (unlock)
    printf("\tKICK Unlocked.\n");
    printf("\t---------------------------------------------\n");
 }


/**********************************************************************************
  PSC Common functions :

***********************************************************************************/
/*Force module state without handshaking */
void PSC1_LPSC_force(unsigned int LPSC_num) {
    *(unsigned int*) (PSC1_MDCTL+4*LPSC_num) = (*(unsigned int*) (PSC1_MDCTL+4*LPSC_num) | 0x80000000);
}

/*SyncReset Function for PSC1*/
void PSC1_LPSC_SyncReset(unsigned int PD, unsigned int LPSC_num) {
    unsigned int j;

    if( (*(unsigned int*)(PSC1_MDSTAT+4 * LPSC_num) & 0x1F) != 0x1 ) {
      *(unsigned int*) (PSC1_MDCTL+4*LPSC_num) = (*(unsigned int*) (PSC1_MDCTL+4*LPSC_num) & 0xFFFFFFE0) | 0x0001;
      PSC1_PTCMD = 0x1<<PD;

      j = 0;
      /*Wait for power state transition to finish*/
      while( (PSC1_PTSTAT & (0x1<<PD) ) !=0) {
        if( j++ > PSC_TIMEOUT ) {
          printf("\tPSC1 Sync Reset Transition Timeout on Domain %d, LPSC %d\n",PD,LPSC_num);
          break;
        }
      }

      j = 0;
      while( (*(unsigned int*)(PSC1_MDSTAT+4 * LPSC_num) & 0x1F) !=0x1) {
        if( j++ > PSC_TIMEOUT ) {
          printf("\tPSC1 Sync Reset Verify Timeout on Domain %d, LPSC %d\n",PD,LPSC_num);
          break;
        }
      }
    }
}

/*Enable Function for PSC1*/
void PSC1_LPSC_enable(unsigned int PD, unsigned int LPSC_num) {
    unsigned int j;

    if( (*(unsigned int*)(PSC1_MDSTAT+4 * LPSC_num) & 0x1F) != 0x3 ) {
      *(unsigned int*) (PSC1_MDCTL+4*LPSC_num) = (*(unsigned int*) (PSC1_MDCTL+4*LPSC_num) & 0xFFFFFFE0) | 0x0003;
      PSC1_PTCMD = 0x1<<PD;

      j = 0;
      /*Wait for power state transition to finish*/
      while( (PSC1_PTSTAT & (0x1<<PD) ) !=0) {
        if( j++ > PSC_TIMEOUT ) {
          printf("\tPSC1 Enable Transition Timeout on Domain %d, LPSC %d\n",PD,LPSC_num);
          break;
        }
      }

      j = 0;
      while( (*(unsigned int*)(PSC1_MDSTAT+4 * LPSC_num) & 0x1F) !=0x3) {
        if( j++ > PSC_TIMEOUT ) {
          printf("\tPSC1 Enable Verify Timeout on Domain %d, LPSC %d\n",PD,LPSC_num);
          break;
        }
      }
    }
}

/*LPSC Enable Function for ARM or DSP*/
void PSC0_LPSC_enableCore(unsigned int PD, unsigned int LPSC_num) {
    unsigned int j;

    if( (*(unsigned int*)(PSC0_MDSTAT+4 * LPSC_num) & 0x11F) != 0x103 ) {
      *(unsigned int*) (PSC0_MDCTL+4*LPSC_num) = (*(unsigned int*) (PSC0_MDCTL+4*LPSC_num) & 0xFFFFFEE0) | 0x0103;
      PSC0_PTCMD = 0x1<<PD;

      j = 0;
      /*Wait for power state transition to finish*/
      while( (PSC0_PTSTAT & (0x1<<PD) ) !=0) {
        if( j++ > PSC_TIMEOUT ) {
          printf("\tPSC0 Enable Core Transition Timeout on Domain %d, LPSC %d\n",PD,LPSC_num);
          break;
        }
      }

      j = 0;
      while( (*(unsigned int*)(PSC0_MDSTAT+4 * LPSC_num) & 0x11F) !=0x103) {
        if( j++ > PSC_TIMEOUT ) {
          printf("\tPSC0 Enable Core Verify Timeout on Domain %d, LPSC %d\n",PD,LPSC_num);
          break;
        }
      }
    }
}

/*SyncReset Function for PSC0*/
void PSC0_LPSC_SyncReset(unsigned int PD, unsigned int LPSC_num) {
    unsigned int j;

    if( (*(unsigned int*)(PSC0_MDSTAT+4 * LPSC_num) & 0x1F) != 0x1 ) {
      *(unsigned int*) (PSC0_MDCTL+4*LPSC_num) = (*(unsigned int*) (PSC0_MDCTL+4*LPSC_num) & 0xFFFFFFE0) | 0x0001;
      PSC0_PTCMD = 0x1<<PD;

      j = 0;
      /*Wait for power state transition to finish*/
      while( (PSC0_PTSTAT & (0x1<<PD) ) !=0) {
        if( j++ > PSC_TIMEOUT ) {
          printf("\tPSC0 Sync Reset Transition Timeout on Domain %d, LPSC %d\n",PD,LPSC_num);
          break;
        }
      }

      j = 0;
      while( (*(unsigned int*)(PSC0_MDSTAT+4 * LPSC_num) & 0x1F) !=0x1) {
        if( j++ > PSC_TIMEOUT ) {
          printf("\tPSC0 Sync Reset Verify Timeout on Domain %d, LPSC %d\n",PD,LPSC_num);
          break;
        }
      }
    }
}

/*Enable Function for PSC0*/
void PSC0_LPSC_enable(unsigned int PD, unsigned int LPSC_num) {
    unsigned int j;

    if( (*(unsigned int*)(PSC0_MDSTAT+4 * LPSC_num) & 0x1F) != 0x3 ) {
      *(unsigned int*) (PSC0_MDCTL+4*LPSC_num) = (*(unsigned int*) (PSC0_MDCTL+4*LPSC_num) & 0xFFFFFFE0) | 0x0003;
      PSC0_PTCMD = 0x1<<PD;

      j = 0;
      /*Wait for power state transition to finish*/
      while( (PSC0_PTSTAT & (0x1<<PD) ) !=0) {
        if( j++ > PSC_TIMEOUT ) {
          printf("\tPSC0 Enable Transition Timeout on Domain %d, LPSC %d\n",PD,LPSC_num);
          break;
        }
      }

      j = 0;
      while( (*(unsigned int*)(PSC0_MDSTAT+4 * LPSC_num) & 0x1F) !=0x3) {
        if( j++ > PSC_TIMEOUT ) {
          printf("\tPSC0 Enable Verify Timeout on Domain %d, LPSC %d\n",PD,LPSC_num);
          break;
        }
      }
    }
}


/**********************************************************************************
  DDR Configuration routine:
    1. DDR Enable
    2. VTP calibration
    3. Configure DDR
    4. Set to self-refresh, enable mclkstop and DDR Sync Reset
    5. Enable DDR and disable self-refresh

  int freq is MHz

  DDR2 = 0
  MDDR = 1

  A DDR configuration spreadsheet tool is located here:
    http://processors.wiki.ti.com/index.php/Programming_mDDR/DDR2_EMIF_on_OMAP-L1x/C674x

***********************************************************************************/

void DEVICE_DDRConfig(unsigned int ddr_type, unsigned int freq)
{
    unsigned int j;
    unsigned int tmp_SDCR;

    // Enable the Clock to EMIFDDR SDRAM
    PSC1_LPSC_enable(PD0, LPSC_DDR);

    // Begin VTP Calibration
    VTPIO_CTL &= ~0x00000040;       // Clear POWERDN
    VTPIO_CTL &= ~0x00000080;       // Clear LOCK
    VTPIO_CTL |=  0x00002000;       // Set CLKRZ in case it was cleared before (VTP looks for CLKRZ edge transition)
    VTPIO_CTL &= ~0x00002000;       // Clear CLKRZ (Use read-modify-write to ensure 1 VTP cycle wait for previous instruction)
    VTPIO_CTL |=  0x00002000;       // Set CLKRZ (Use read-modify-write to ensure 1 VTP cycle wait for previous instruction)

    j = 0;
    // Polling READY bit to see when VTP calibration is done
    while((VTPIO_CTL & 0x00008000) == 0) {
      if( j++ > VTP_TIMEOUT ) {
        printf("\tVTP Ready timeout\n");
        break;
      }
    }

    VTPIO_CTL |= 0x00000080;       // Set LOCK bit for static calibration mode
    VTPIO_CTL |= 0x00000040;       // Set POWERDN bit to power down VTP module
    // End VTP Calibration

    VTPIO_CTL |= 0x00004000;       // Set IOPWRDN to allow powerdown of input receivers when PWRDNEN is set

    // **********************************************************************************************
    // Setting based 1Gb DDR2 Samsung K4T1G164QF-BCF8
    // Config DDR timings
    DRPYC1R     = (0x0               << 8)   |  // Reserved
                  (0x1               << 7)   |  // EXT_STRBEN
                  (0x1               << 6)   |  // PWRDNEN
                  (0x0               << 3)   |  // Reserved
                  (0x4               << 0);     // RL
    // DRPYC1R Value = 0x000000C4

    if( DDR_DEBUG ) {
      // Configure EMIF with max timings for more slack
      // Try this if memory is not stable
      DRPYC1R  |=  0x7; // RL
    }

    EMIFDDR_SDCR |= 0x00800000; // Set BOOTUNLOCK

    // Settings depending on DDR2
      tmp_SDCR = (0x0               << 25)  |  // MSDRAMEN
                 (0x1               << 20);    // DDR2EN
      printf("\tUsing DDR2 settings\n");

    EMIFDDR_SDCR = tmp_SDCR                    |  // Settings that change depending on DDR2 or MDDR
                   (EMIFDDR_SDCR & 0xF0000000) |  // Reserved
                   (0x0               << 27)   |  // DDR2TERM1
                   (0x0               << 26)   |  // IBANK_POS
                   (0x0               << 24)   |  // DDRDRIVE1
                   (0x0               << 23)   |  // BOOTUNLOCK
                   (0x0               << 22)   |  // DDR2DDQS
                   (0x0               << 21)   |  // DDR2TERM0
                   (0x0               << 19)   |  // DDRDLL_DIS
                   (0x0               << 18)   |  // DDRDRIVE0
                   (0x1               << 17)   |  // DDREN
                   (0x1               << 16)   |  // SDRAMEN
                   (0x1               << 15)   |  // TIMUNLOCK
                   (0x1               << 14)   |  // NM
                   (0x0               << 12)   |  // Reserved
                   (0x4               << 9)    |  // CL
                   (0x0               << 7)    |  // Reserved
                   (0x3               << 4)    |  // IBANK
                   (0x0               << 3)    |  // Reserved
                   (0x2               << 0);      // PAGESIZE

    EMIFDDR_SDCR2   = 0x00000000; // IBANK_POS set to 0 so this register does not apply

    if( DDR_DEBUG ) {
      // Configure EMIF with max timings for more slack
      // Try this if memory is not stable

      EMIFDDR_SDTIMR1 = (0x7F << 25)             |  // tRFC
                        (0x07 << 22)             |  // tRP
                        (0x07 << 19)             |  // tRCD
                        (0x07 << 16)             |  // tWR
                        (0x1F << 11)             |  // tRAS
                        (0x1F << 6)              |  // tRC
                        (0x07 << 3)              |  // tRRD
                        (EMIFDDR_SDTIMR1 & 0x4)  |  // Reserved
                        (0x03 << 0);                // tWTR

      EMIFDDR_SDTIMR2 = (EMIFDDR_SDTIMR2 & 0x80000000)                       |  // Reserved
                        (((unsigned int) ((70000 / 3400) - 0.5))  << 27)   |  // tRASMAX (original 7812.5)
                        (0x3                                        << 25)   |  // tXP
                        (0x0                                        << 23)   |  // tODT (Not supported)
                        (0x7F                                       << 16)   |  // tXSNR
                        (0xFF                                       << 8)    |  // tXSRD
                        (0x07                                       << 5)    |  // tRTP (1 Cycle)
                        (0x1F                                       << 0);      // tCKE

      printf("\tDDR Timings Configured for Debug\n");
    }
    else {
      // Let float -> integer truncate handle minus 1; Safer to round up for timings
      EMIFDDR_SDTIMR1 = (((unsigned int) (127.5 * freq / 1000))  << 25)  |  // tRFC
                        (((unsigned int) (13.13 * freq / 1000))  << 22)  |  // tRP
                        (((unsigned int) (13.13 * freq / 1000))  << 19)  |  // tRCD
                        (((unsigned int) ( 15.0 * freq / 1000))  << 16)  |  // tWR
                        (((unsigned int) ( 45.0 * freq / 1000))  << 11)  |  // tRAS
                        (((unsigned int) (58.13 * freq / 1000))  << 6)   |  // tRC
                        (((unsigned int) (  7.5 * freq / 1000))  << 3)   |  // tRRD
                        (EMIFDDR_SDTIMR1 & 0x4)                          |  // Reserved
                        ((2 - 1)                                 << 0);     // tWTR

      EMIFDDR_SDTIMR2 = (EMIFDDR_SDTIMR2 & 0x80000000)                    |  // Reserved
                        (((unsigned int) ((70000 / 7800) - 1))   << 27)   |  // tRASMAX (original 3400)
                        ((0x3-1)                                 << 25)   |  // tXP (Should be 6-1 per MT46H64M16LFBF-6 datasheet, but field only goes up to 0b11)
                        (0x0                                     << 23)   |  // tODT (Not supported)
                        (((unsigned int) (137.5 * freq / 1000))  << 16)   |  // tXSNR (tXSR for mDDR)
                        ((200-1)                                 << 8)    |  // tXSRD (tXSR for mDDR)
                        ((2 - 1)                                 << 5)    |  // tRTP
                        ((3 - 1)                                 << 0);      // tCKE
    }

    EMIFDDR_SDCR    &= ~0x00008000; // Clear TIMUNLOCK

    // Let float -> integer truncate handle RR round-down; Safer to round down for refresh rate
    EMIFDDR_SDRCR   = (0x1                                  << 31)  |  // LPMODEN (Required for LPSC SyncReset/Enable)
                      (0x1                                  << 30)  |  // MCLKSTOPEN (Required for LPSC SyncReset/Enable)
                      (0x0                                  << 24)  |  // Reserved
                      (0x0                                  << 23)  |  // SR_PD
                      (0x0                                  << 16)  |  // Reserved
                      (((unsigned int) (7.8 * freq))        << 0);     // RR  (original 7.8125)

    // SyncReset the Clock to EMIFDDR SDRAM
    PSC1_LPSC_SyncReset(PD0, LPSC_DDR);

    // Enable the Clock to EMIFDDR SDRAM
    PSC1_LPSC_enable(PD0, LPSC_DDR);

    // Disable self-refresh
    EMIFDDR_SDRCR &= ~0xC0000000;

    EMIFDDR_PBBPR = 0x30;
}




