#include "DSP2803x_Device.h"
#include "DSP28x_Project.h"
#include "stdint.h"
#include "stdio.h"
#include "I2C2.h"
#include "math.h"

void delay(uint32_t m)
{
	uint32_t n;
	for(n=m;n>0;n--)
	{
		asm(" NOP");
	}
}
/* ʱ */
void I2C_delay(void)
{	  volatile int i = 30;
    while (i)
        i--;
}


void I2C_GPIO_init()   //GPIOĳʼ
{
	EALLOW;
	GpioCtrlRegs.GPAMUX1.bit.GPIO14 =0;
	GpioCtrlRegs.GPADIR.bit.GPIO14 = 1;
	GpioCtrlRegs.GPAPUD.bit.GPIO14 = 0;
	GpioCtrlRegs.GPAQSEL1.bit.GPIO14 = 2;

	GpioCtrlRegs.GPAMUX1.bit.GPIO15 = 0;
    GpioCtrlRegs.GPADIR.bit.GPIO15 = 1;
	GpioCtrlRegs.GPAPUD.bit.GPIO15 = 0;
    GpioCtrlRegs.GPAQSEL1.bit.GPIO15 = 2;
	EDIS;
}

void   SDAIN(void)
{
     EALLOW;
     GpioCtrlRegs.GPADIR.bit.GPIO14=0;
     EDIS;
}

void   SDAOUT(void)   //Ϊģʽ
{
     EALLOW;
     GpioCtrlRegs.GPADIR.bit.GPIO14=1;
     EDIS;
}

void   SCLIN(void)
{
     EALLOW;
     GpioCtrlRegs.GPADIR.bit.GPIO15=0;
     EDIS;
}

void   SCLOUT(void)   //Ϊģʽ
{
     EALLOW;
     GpioCtrlRegs.GPADIR.bit.GPIO15=1;
     EDIS;
}

void SDA_1()   //SDAź 1
{
	GpioDataRegs.GPASET.bit.GPIO14=1;
}

void SDA_0()   //SDAź 0
{
	GpioDataRegs.GPACLEAR.bit.GPIO14=1;
}

void SCL_1()   //SCLź 1
{
	GpioDataRegs.GPASET.bit.GPIO15=1;
}

void SCL_0()   //SCLź 0
{
	GpioDataRegs.GPACLEAR.bit.GPIO15=1;
}

void IOINIT(void)
{
	SDAOUT();
	SCLOUT();
	SDA_1();
	delay(10);
	SCL_1();
}


/* I2Cʼź */
u8 I2C_Start(void)
{
	SDAOUT();
	SCLOUT();
	SDA_1();
    SCL_1();
    I2C_delay();
	SDAIN();

    if (GpioDataRegs.GPADAT.bit.GPIO14!=1)
	{
        return false;
	}

    SDAOUT();
    SDA_0();
    I2C_delay();

    SDAIN();
    if (GpioDataRegs.GPADAT.bit.GPIO14==1)
	{
        return false;
	}

    SDAOUT();
    SDA_0();
    I2C_delay();

    return true;
}

/* I2Cֹͣź */
void I2C_Stop(void)
{
	SDAOUT();
	SCLOUT();
    SCL_0();
    I2C_delay();
    SDA_0();
    I2C_delay();
    SCL_1();
    I2C_delay();
    SDA_1();
    I2C_delay();
}

/* I2CӦź */
void I2C_Ack(void)
{
	SDAOUT();
	SCLOUT();
    SCL_0();
    I2C_delay();
    SDA_0();
    I2C_delay();
    SCL_1();
    I2C_delay();
    SCL_0();
    I2C_delay();
}

/* I2CӦ */
void I2C_NoAck(void)
{
	SDAOUT();
	SCLOUT();
    SCL_0();
    I2C_delay();
    SDA_1();
    I2C_delay();
    SCL_1();
    I2C_delay();
    SCL_0();
    I2C_delay();
}

/* I2ȴӦ */
u8 I2C_WaitAck(void)
{
	SDAOUT();
	SCLOUT();
    SCL_0();
    I2C_delay();
    SDA_1();
    I2C_delay();
    SCL_1();
    I2C_delay();

    SDAIN();
    if (GpioDataRegs.GPADAT.bit.GPIO14==1)
	{
        SCL_0();
        return false;
    }
    SCL_0();
    return true;
}


/* I2C8λ */
void I2C_SendByte(u8 byte)
{
	SDAOUT();
	SCLOUT();
    u8 i = 8;
    while (i--) 
	{
        SCL_0();
        I2C_delay();
        if (byte & 0x80)
        	SDA_1();
        else
        	SDA_0();
        byte <<= 1;
        I2C_delay();
        SCL_1();
        I2C_delay();
    }
    SCL_0();
	while (!I2C_WaitAck());
}

/* I2Cȡһ8λ */
u8 I2C_ReceiveByte(void)
{
    u8 i = 8;
    u8 byte = 0;

    SDAOUT();
    SCLOUT();
    SDA_1();
    while (i--) 
	{
        byte <<= 1;
        SCL_0();
        I2C_delay();
        SCL_1();
        I2C_delay();
    	SDAIN();
        if (GpioDataRegs.GPADAT.bit.GPIO14==1)
		{
            byte |= 0x01;
        }
    }
    SCL_0();
	I2C_NoAck();
    return byte;
}

u8 I2CWriteBuffer(u8 addr, u8 reg, u8 len, u8 * data)
{
    int i;

    if (!I2C_Start())
	{
        return false;
	}

    I2C_SendByte(0);  //I2C_SendByte(addr << 1 | I2C_Direction_Transmitter);//дַ

    if (!I2C_WaitAck())  //ȴӦ
	{
        I2C_Stop();
        return false;
    }

    I2C_SendByte(reg);
    I2C_WaitAck();
    for (i = 0; i < len; i++) 
	{
        I2C_SendByte(data[i]);

        if (!I2C_WaitAck()) 
		{
            I2C_Stop();
            return false;
        }
    }
    I2C_Stop();
    return true;
}

int I2Cwrite(u8 addr, u8 reg, u8 len, u8 * data)
{
	if (I2CWriteBuffer(addr, reg, len, data))
	{
		return true;
	}
	else
	{
		return false;
	}
}

int I2Cread(u8 addr, u8 reg, u8 len, u8 *buf)
{
	if (I2CRead(addr, reg, len, buf))
	{
		return true;
	}
	else
	{
		return false;
	}
}

u8 I2CWrite(u8 addr, u8 reg, u8 data)
{
    if (!I2C_Start())
	{
        return false;
	}

    I2C_SendByte(0);  //I2C_SendByte(addr << 1 | I2C_Direction_Transmitter);

    if (!I2C_WaitAck()) 
	{
        I2C_Stop();
        return false;
    }
    I2C_SendByte(reg);
    I2C_WaitAck();
    I2C_SendByte(data);
    I2C_WaitAck();
    I2C_Stop();
    return true;
}

u8 I2CRead(u8 addr, u8 reg, u8 len, u8 *buf)
{
    if (!I2C_Start())
	{
        return false;
	}

    I2C_SendByte(0);  //(addr << 1 | I2C_Direction_Transmitter);

    if (!I2C_WaitAck()) 
	{
        I2C_Stop();
        return false;
    }
    I2C_SendByte(reg);
    I2C_WaitAck();
    I2C_Start();
    I2C_SendByte(0);  //I2C_SendByte(addr << 1 | I2C_Direction_Receiver);
    I2C_WaitAck();
    while (len) 
	{
        *buf = I2C_ReceiveByte();
        if (len == 1)
		{
            I2C_NoAck();
		}
		else
		{
            I2C_Ack();
		}

        buf++;
        len--;
    }
    I2C_Stop();
    return true;
}

void I2C_Receive14Bytes(u8 *data_buffer)
{
	u8 i, j;
	u8 I2C_data;

	SDAOUT();
	SCLOUT();

	for (j = 0; j < 13; j++)
	{
		SDA_1();
		SCL_0();
		I2C_data = 0;
		
		for (i = 0; i < 8; i++)
		{
  			SCL_1();
  			I2C_delay(); 
  			I2C_data<<=1;
			SDAIN();
  			if (GpioDataRegs.GPADAT.bit.GPIO14==1)
			{	
				I2C_data |= 0x01;
			} 
  
  			SCL_0();
  			I2C_delay();         
		}
		data_buffer[j] = I2C_data;
		I2C_Ack();
	}

	SDAOUT();
	SDA_1();
	SCL_0();
	I2C_data = 0;

	for (i = 0; i < 8; i++)
	{
  		SCL_1();
  		I2C_delay(); 
  		I2C_data<<=1;
		SDAIN();
  		if (GpioDataRegs.GPADAT.bit.GPIO14==1)
		{
			I2C_data |= 0x01;
		} 
  
  		SCL_0();
  		I2C_delay();         
	}

	data_buffer[13] = I2C_data;
	I2C_NoAck();
}

void I2C_Receive6Bytes(u8 *data_buffer)
{
	u8 i, j;
	u8 I2C_data;

	SDAOUT();
	SCLOUT();
	for (j = 0; j < 5; j++)
	{
		SDA_1();
		SCL_0();
		I2C_data = 0;
		
		for (i = 0; i < 8; i++)
		{
  			SCL_1();
  			I2C_delay(); 
  			I2C_data<<=1;
			SDAIN();
  			if (GpioDataRegs.GPADAT.bit.GPIO14==1)
			{	
				I2C_data |= 0x01;
			} 
  
  			SCL_0();
  			I2C_delay();         
		}
		data_buffer[j] = I2C_data;
		I2C_Ack();
	}

	SDAOUT();
	SDA_1();
	SCL_0();
	I2C_data = 0;

	for (i = 0; i < 8; i++)
	{
  		SCL_1();
  		I2C_delay(); 
  		I2C_data<<=1;
		SDAIN();
  		if (GpioDataRegs.GPADAT.bit.GPIO14==1)
		{
			I2C_data |= 0x01;
		} 
  
  		SCL_0();
  		I2C_delay();         
	}

	data_buffer[5] = I2C_data;
	I2C_NoAck();
}
		
									 
