#include "DSP2803x_Device.h"
#include "DSP28x_Project.h"
#include "stdint.h"
#include "OV7725.h"
#include "SCCB.h"
#include "I2C2.h"

/* Ĵ */
Reg_Info Sensor_Config[] =
{
	{CLKRC,     0x00}, /* Clock Config:Internal clock/2  */
	{COM7,      0x40}, /* Resolution:QVGA Output Format:YUV */
    {HSTART,    0x3f}, /* Output Mode:Ƶʼ8λ,λHREF[54]*/
	{HSIZE,     0x50}, /* Default value */
	{VSTRT,     0x03}, /* Output ModeƵʼ߰λһλHREF[6] */
	{VSIZE,     0x78}, /* Default value */
	{HREF,      0x00}, /* Default  */
	{HOutSize,  0x50}, /* Horizontal Data Output Size MSBs (2 LSBs at register EXHCH[1:0])*/
	{VOutSize,  0x78}, /*  */
	{EXHCH,     0x00},

	/*DSP control*/
	{TGT_B,     0x7f},
	{FixGain,   0x09},
	{AWB_Ctrl0, 0xe0},
	{DSP_Ctrl1, 0xff},
	{DSP_Ctrl2, 0x20},
	{DSP_Ctrl3,	0x00},
	{DSP_Ctrl4, 0x00},

	/*AGC AEC AWB*/
	{COM8,		  0xf0},
	{COM4,		  0x81}, /*Pll AEC CONFIG*/
	{COM6,		  0xc5},
	{COM9,		  0x21},
	{BDBase,	  0xFF},
	{BDMStep,	  0x01},
	{AEW,		    0x34},
	{AEB,		    0x3c},
	{VPT,		    0xa1},
	{EXHCL,		  0x00},
	{AWBCtrl3,  0xaa},
	{COM8,		  0xff},
	{AWBCtrl1,  0x5d},

	{EDGE1,		  0x0a},
	{DNSOff,	  0x01},
	{EDGE2,		  0x01},
	{EDGE3,		  0x01},

	{MTX1,		  0x5f},
	{MTX2,		  0x53},
	{MTX3,		  0x11},
	{MTX4,		  0x1a},
	{MTX5,		  0x3d},
	{MTX6,		  0x5a},
	{MTX_Ctrl,  0x1e},

	{BRIGHT,	  0x00},
	{CNST,		  0x25},
	{USAT,		  0x65},
	{VSAT,		  0x65},
	{UVADJ0,	  0x81},
	{SDE,		    0x06},
	
    /*GAMMA config*/
	{GAM1,		  0x0c},
	{GAM2,		  0x16},
	{GAM3,		  0x2a},
	{GAM4,		  0x4e},
	{GAM5,		  0x61},
	{GAM6,		  0x6f},
	{GAM7,		  0x7b},
	{GAM8,		  0x86},
	{GAM9,		  0x8e},
	{GAM10,		  0x97},
	{GAM11,		  0xa4},
	{GAM12,		  0xaf},
	{GAM13,		  0xc5},
	{GAM14,		  0xd7},
	{GAM15,		  0xe8},
	{SLOP,		  0x20},

	{HUECOS,	  0x80},
	{HUESIN,	  0x80},
	{DSPAuto,	  0xff},
	{DM_LNL,	  0x00},
	{BDBase,	  0x99},
	{BDMStep,	  0x03},
	{LC_RADI,	  0x00},
	{LC_COEF,	  0x13},
	{LC_XC,		  0x08},
	{LC_COEFB,  0x14},
	{LC_COEFR,  0x17},
	{LC_CTR,	  0x05},
	
	{COM3,		  0xd0},/*Horizontal mirror image*/

	/*night mode auto frame rate control*/
	{COM5,		0xf5},	 /*ҹӻ£Զ֡ʣ֤նȻ*/
	//{COM5,		0x31},	/*ҹӻ֡ʲ*/
};

u8 OV7725_REG_NUM = sizeof(Sensor_Config)/sizeof(Sensor_Config[0]);	  /*ṹԱĿ*/

void FIFO_GPIO_Config(void)
{
	EALLOW;
	//
	/*GPIO10(FIFO_WEN--FIFOдʹ)*/
   	GpioCtrlRegs.GPAMUX1.bit.GPIO10 =0;
	GpioCtrlRegs.GPADIR.bit.GPIO10 =1;
   	GpioDataRegs.GPACLEAR.bit.GPIO10 =0;

   	/*GPIO4(FIFO_WRST--FIFOдλ)*/
	GpioCtrlRegs.GPAMUX1.bit.GPIO4 =0;
	GpioCtrlRegs.GPADIR.bit.GPIO4 =1;
   	GpioDataRegs.GPACLEAR.bit.GPIO4 =0;

	/*GPIO8(FIFO_RRST--FIFOλ) */
   	GpioCtrlRegs.GPAMUX1.bit.GPIO8 =0;
	GpioCtrlRegs.GPADIR.bit.GPIO8 =1;
   	GpioDataRegs.GPACLEAR.bit.GPIO8 =0;

   	//GPIO18(FIFO_OE--FIFOʹ)
	GpioCtrlRegs.GPAMUX2.bit.GPIO18 =0;
	GpioCtrlRegs.GPADIR.bit.GPIO18 =1;
   	GpioDataRegs.GPACLEAR.bit.GPIO18 =0;

   	/*GPIO12(FIFO_RCLK-FIFOʱ)*/
   	GpioCtrlRegs.GPAMUX1.bit.GPIO12 =0;
	GpioCtrlRegs.GPADIR.bit.GPIO12 =1;
   	GpioDataRegs.GPACLEAR.bit.GPIO12 =0;

   	//
   	/*(FIFO_DATA--FIFO)*/
   	GpioCtrlRegs.GPAMUX1.bit.GPIO5 =0;
	GpioCtrlRegs.GPADIR.bit.GPIO5 =0;
   	GpioDataRegs.GPACLEAR.bit.GPIO5 =0;

   	GpioCtrlRegs.GPAMUX1.bit.GPIO6 =0;
	GpioCtrlRegs.GPADIR.bit.GPIO6 =0;
   	GpioDataRegs.GPACLEAR.bit.GPIO6 =0;

   	GpioCtrlRegs.GPAMUX2.bit.GPIO16 =0;
	GpioCtrlRegs.GPADIR.bit.GPIO16 =0;
   	GpioDataRegs.GPACLEAR.bit.GPIO16 =0;

   	GpioCtrlRegs.GPAMUX2.bit.GPIO25 =0;
	GpioCtrlRegs.GPADIR.bit.GPIO25 =0;
   	GpioDataRegs.GPACLEAR.bit.GPIO25 =0;

   	GpioCtrlRegs.GPAMUX2.bit.GPIO17 =0;
	GpioCtrlRegs.GPADIR.bit.GPIO17 =0;
   	GpioDataRegs.GPACLEAR.bit.GPIO17 =0;

   	GpioCtrlRegs.GPAMUX1.bit.GPIO9 =0;
	GpioCtrlRegs.GPADIR.bit.GPIO9 =0;
   	GpioDataRegs.GPACLEAR.bit.GPIO9 =0;

   	GpioCtrlRegs.GPAMUX2.bit.GPIO26 =0;
	GpioCtrlRegs.GPADIR.bit.GPIO26 =0;
   	GpioDataRegs.GPACLEAR.bit.GPIO26 =0;

   	GpioCtrlRegs.GPAMUX2.bit.GPIO27 =0;
	GpioCtrlRegs.GPADIR.bit.GPIO27 =0;
   	GpioDataRegs.GPACLEAR.bit.GPIO27 =0;
	EDIS;

	FIFO_CS_L();	  					/*ʹFIFOʹ*/
    FIFO_WE_H();   						/*ʹFIFOд*/
}

int OV7725_Init(void)
{
	unsigned short i = 0, ERROR = 0, SUCCESS = 1;
	unsigned char Camera_IDCode = 0;
	
	if (0 == SCCB_WriteByte(OV7725_WriteAddr, 0x12, 0x80))   //SCCBĴλ
	{
		return ERROR;
	}
	
	if (0 == SCCB_ReadByte(OV7725_WriteAddr, &Camera_IDCode, 1, 0x0b))
	{
		return ERROR;
	}
	
	if (Camera_IDCode == OV7725_ID)
	{
		for (i = 0; i < OV7725_REG_NUM; i++)
		{
			if (0 == SCCB_WriteByte(OV7725_WriteAddr, Sensor_Config[i].Address, Sensor_Config[i].Value))
			{
				return ERROR;
			}
		}
	}
	else
	{
		return ERROR;
	}
	
	return SUCCESS;			
}

void VSYNC_GPIO_Configuration(void)
{
	EALLOW;
	GpioCtrlRegs.GPAMUX1.bit.GPIO7 = 0;
	GpioCtrlRegs.GPADIR.bit.GPIO7 = 0;
	GpioCtrlRegs.GPAQSEL1.bit.GPIO7 = 0;
	EDIS;
	
	EALLOW;
	GpioIntRegs.GPIOXINT1SEL.bit.GPIOSEL = 0x07;
	EDIS;
}

void VSYNC_EXTI_Configuration(void)
{
	XIntruptRegs.XINT1CR.bit.POLARITY = 0;
	XIntruptRegs.XINT1CR.bit.ENABLE = 1;
}

void VSYNC_NVIC_Configuration(void)
{
//    NVIC_InitTypeDef NVIC_InitStructure;
//    NVIC_PriorityGroupConfig(NVIC_PriorityGroup_1);
//    NVIC_InitStructure.NVIC_IRQChannel = EXTI0_IRQChannel;	//ⲿն
//    NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;//
//    NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
//    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;//ʹն
//    NVIC_Init(&NVIC_InitStructure);
}

void VSYNC_Init(void)
{
    VSYNC_GPIO_Configuration();
    VSYNC_EXTI_Configuration();
    VSYNC_NVIC_Configuration();
}

void PassInvalidPixel(void)
{
	FIFO_RCLK_L();
	FIFO_RCLK_H();
	FIFO_RCLK_L();
	FIFO_RCLK_H();
}

extern unsigned char Imag[Row][Col];
void Get_Imag(void)
{
	unsigned short i, j, k = 0, l = 0;
	unsigned short Camera_Data;

	for (i = 0; i <= (120+Row/2); i++)
	{
		if (i > (120-Row/2))
		{
			for (j = 0; j < 320; j++)
			{
				if ((j > (160-Col/2)) && (j <= (160+Col/2)))
				{
//					READ_FIFO_PIXEL(Camera_Data);
					Imag[k][l] = (u8)((Camera_Data & 0xff00)>>8);
					l++;
				}
				else
				{
					PassInvalidPixel();	
				}
			}
			k++;
			l = 0;
		}
		else
		{
			for (j = 0; j < 320; j++)
			{
				PassInvalidPixel();
			}			
		}
	}	
}


void Send_Image_String(unsigned char *putchar, unsigned int num)
{
	unsigned int i = 0;

  	SciaRegs.SCITXBUF = 0x00;
	while(SciaRegs.SCIRXBUF.all == 0);
	SciaRegs.SCITXBUF = 0xff;
	while(SciaRegs.SCIRXBUF.all == 0);
	SciaRegs.SCITXBUF = 0x01;
	while(SciaRegs.SCIRXBUF.all == 0);
	SciaRegs.SCITXBUF = 0x00;
	while(SciaRegs.SCIRXBUF.all == 0);
	for(i=0;i<num;i++)
  	{
  		SciaRegs.SCITXBUF = putchar[i];
  		while(SciaRegs.SCIRXBUF.all == 0);
  	}
}
