#include "DSP2803x_Device.h"
#include "DSP28x_Project.h"
#include "stdint.h"
#include "SCCB.h"
#include "I2C2.h"

extern SDA_1(), SDA_0(), SCL_1(), SCL_0(),SDAIN(),SDAOUT(),SCLIN(),SCLOUT();

void SCCB_delay(void)
{
    volatile int i = 400;
    while (i)
        i--;
}

u8 SCCB_Start(void)
{
	SDAOUT();
	SCLOUT();
    SDA_1();
    SCL_1();
    SCCB_delay();
	SDAIN();

    if (GpioDataRegs.GPADAT.bit.GPIO14 != 1)
	{
        return false;
	}
    SDAOUT();
    SDA_0();
    SCCB_delay();

    SDAIN();
    if (GpioDataRegs.GPADAT.bit.GPIO14 == 1)
	{
        return false;
	}
    SDAOUT();
    SDA_0();
    SCCB_delay();

    return true;
}

void SCCB_Stop(void)
{
	SDAOUT();
	SCLOUT();
    SCL_0();
    SCCB_delay();
    SDA_0();
    SCCB_delay();
    SCL_1();
    SCCB_delay();
    SDA_1();
    SCCB_delay();
}

void SCCB_Ack(void)
{
	SDAOUT();
	SCLOUT();
    SCL_0();
    SCCB_delay();
    SDA_0();
    SCCB_delay();
    SCL_1();
    SCCB_delay();
    SCL_0();
    SCCB_delay();
}

void SCCB_NoAck(void)
{
	SDAOUT();
	SCLOUT();
    SCL_0();
    SCCB_delay();
    SDA_1();
    SCCB_delay();
    SCL_1();
    SCCB_delay();
    SCL_0();
    SCCB_delay();
}

u8 SCCB_WaitAck(void)
{
	SDAOUT();
	SCLOUT();
    SCL_0();
    SCCB_delay();
    SDA_1();
    SCCB_delay();
    SCL_1();
    SCCB_delay();

    SDAIN();
    if (GpioDataRegs.GPADAT.bit.GPIO14 == 1)
	{
        SCL_0();
        return false;
    }
    SCL_0();
    return true;
}

void SCCB_SendByte(u8 byte)
{
	SDAOUT();
	SCLOUT();
    u8 i = 8;
    while (i--) 
	{
        SCL_0();
        SCCB_delay();
        if (byte & 0x80)
            SDA_1();
        else
            SDA_0();
        byte <<= 1;
        SCCB_delay();
        SCL_1();
        SCCB_delay();
    }
    SCL_0();
}

u8 SCCB_ReceiveByte(void)
{
    u8 i = 8;
    u8 byte = 0;

    SDAOUT();
    SCLOUT();
    SDA_1();
    while (i--) 
	{
        byte <<= 1;
        SCL_0();
        SCCB_delay();
        SCL_1();
        SCCB_delay();
        SDAIN();
        if (GpioDataRegs.GPADAT.bit.GPIO14 == 1)
		{
            byte |= 0x01;
        }
    }
    SCL_0();

    return byte;
}

int SCCB_WriteByte(unsigned char Dev_Adr, unsigned char Reg_Adr, unsigned char Byte)
{
	if (!SCCB_Start())
	{
		return 0;
	}
	SCCB_SendByte(Dev_Adr);

	if (!SCCB_WaitAck())
	{
		SCCB_Stop();
		return 0;		
	}
	SCCB_SendByte(Reg_Adr);
    SCCB_WaitAck();	
    SCCB_SendByte(Byte);
    SCCB_WaitAck();   
    SCCB_Stop();
	return 1;
}

int SCCB_ReadByte(unsigned char Dev_Adr, unsigned char *pBuffer, unsigned short length, unsigned char Reg_Adr)
{
	if (!SCCB_Start())
	{
		return 0;
	}
	SCCB_SendByte(Dev_Adr);
	if (!SCCB_WaitAck())
	{
		SCCB_Stop();
		return 0;		
	}
	SCCB_SendByte(Reg_Adr);
    SCCB_WaitAck();	
    SCCB_Stop();	
	
	if (!SCCB_Start())
	{
		return 0;
	}
	SCCB_SendByte(Dev_Adr+1);
	if (!SCCB_WaitAck())
	{
		SCCB_Stop();
		return 0;		
	}

	while (length)
	{
		*pBuffer = SCCB_ReceiveByte();
		if (1 == length)
		{
			SCCB_NoAck();
		}
		else
		{
			SCCB_Ack();
		}
		pBuffer++;
		length--;	
	}
	SCCB_Stop();

	return 1;		
}
