#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File
#include "SCCB.h"
#include "I2C2.h"
#include "OV7725.h"


unsigned int StartCamera = 0, OV7725_VSYNC = 0,neww=0;
unsigned char Imag[Row][Col]={0};

__interrupt void xint1_isr(void);


void main(void)
{
	   InitSysCtrl();

	   DINT;

	   InitPieCtrl();

	   IER = 0x0000;
	   IFR = 0x0000;

	   InitPieVectTable();
//	   EnableInterrupts();



	   EALLOW;	// This is needed to write to EALLOW protected registers
	   PieVectTable.XINT1 = &xint1_isr;
	   EDIS;   // This is needed to disable write to EALLOW protected registers

	   PieCtrlRegs.PIECTRL.bit.ENPIE = 1;          // Enable the PIE block
	   PieCtrlRegs.PIEIER1.bit.INTx4 = 1;
	   IER |= M_INT1;                              // Enable CPU INT1
	   EINT;

	   VSYNC_Init();
	   StartCamera = 0, OV7725_VSYNC = 0,neww=0;

	   I2C_GPIO_init();
	   IOINIT();
//	   InitSciaGpio();
	   FIFO_GPIO_Config();

	   OV7725_Init();
//	   ERTM;


        for(;;)
        {

        	StartCamera = 0, OV7725_VSYNC = 0,neww=0;
        }
}


__interrupt void xint1_isr(void)
{

	if( OV7725_VSYNC == 0 && StartCamera == 1)
	{
		FIFO_WRST_L(); 	                      //ʹFIFOд(fromͷ)ָ븴λ
		FIFO_WE_H();	                        //ʹFIFOд

		OV7725_VSYNC = 1;
		FIFO_WE_H();                          //ʹFIFOд
		FIFO_WRST_H();                        //ʹFIFOд(fromͷ)ָ˶
	}
	else if( OV7725_VSYNC == 1 )
	{
		FIFO_WE_L();                          //ʹFIFOдͣ
		OV7725_VSYNC = 2;
	}
	if (2 == OV7725_VSYNC)
	{
		FIFO_PREPARE;  			/*FIFO׼*/
		Get_Imag();
		Send_Image_String(&Imag[0][0], Row*Col);
		OV7725_VSYNC = 0;
		StartCamera = 1;
	}

		// Acknowledge this interrupt to get more from group 1
		PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
}


