/*----------------------------------------------------------------------------*/
/* sys_link.cmd                                                               */
/*                                                                            */
/* 
* Copyright (C) 2009-2016 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

/*                                                                            */
/*----------------------------------------------------------------------------*/
/* USER CODE BEGIN (0) */
/* USER CODE END */


/*----------------------------------------------------------------------------*/
/* Linker Settings                                                            */
--retain="*(.intvecs)"


MEMORY
{
    VECTORS    (X)   : origin=0x00000000 length=0x00000020
    FLASH_API  (RX)  : origin=0x00000020 length=0x000014E0   //create a region for flash operation related objects
    FLASH0     (RX)  : origin=0x00001500 length=0x002FEB00   //LS31x and RM48 Flash size is 0x300000
    SRAM       (RW)  : origin=0x08002000 length=0x0002D000
    STACK      (RW)  : origin=0x08000000 length=0x00002000
}
SECTIONS
{
   .intvecs : {} > VECTORS

   /* Place the outputsectionflashAPI".  It is composed of the input sections:  */
   /* Fapi_UserDefinedFunctions.obj, bl_flash.obj, and F021_API_CortexR4_BE.lib  */
   /* It has two different allocations. It allocated to FLASH_API for loading, and allocated to SRAM for running. */
   /* This output section is placed in the output file so that, when the program is loaded, */
   /* it is in the FLASH_API memory range. Sometime during system execution, before anything in flashAPI is used, */
   /* the application copies it from FLASH_API to SRAM. Note this copy is not done automatically. */
   /* I must be taken in the application code. Any other section that uses flashAPI (either calls its functions or */
   /* refers to its data) acts as if flashAPI is already in SRAM. The LOAD_START etc. statements establish symbols */
   /* that are used to implement the copy. The value of the symbol api_load is the starting load address. */
   /* Likewise, api_end has the ending load address, and api_run has the starting run address. */
   /* api_size is the size */
   flashAPI :
   {
     Fapi_UserDefinedFunctions.obj (.text)
     bl_flash.obj (.text)
     --library= ..\lib\F021_API_CortexR4_LE.lib (.text)
   } load = FLASH_API, run = SRAM, LOAD_START(api_load), LOAD_END(api_end), RUN_START(api_run), SIZE(api_size)

   .text  > FLASH0
   .const > FLASH0
   .cinit > FLASH0
   .pinit > FLASH0
   .data  > SRAM
   .bss   > SRAM
}
