/*
 * Task_AES.c
 *
 *  Created on: 2017. 6. 5.
 *      Author: Mirae
 */


 //Free RTOS
#include "FreeRTOS.h"
#include "task.h"
#include <msp430.h>
/* Demo includes. */
#include "partest.h"
#include "inc/hw_memmap.h"
/* TI includes. */
#include "driverlib.h"

#include "crc.h"

#define mainTASK_LED                        ( 0 )
#define EnergyConsumption_CRC 30
#define Priority_CRC 3

static void TaskCRC(void * pvParam);
 
void vEnergyTask_CRC(void)
{
	 xTaskCreateEnergy(TaskCRC,//태스크를 실행할 함수 포인터
     "TaskCRC",//태스크 이름
     1024,//스택 크기  word
     ( void * ) NULL,//태스크의 매개변수
     Priority_CRC,//우선순위
     NULL,
     EnergyConsumption_CRC,
     "A",
     1000,
     50);//태스크 핸들
}

static void TaskCRC(void * pvParam)
{   
	while(1)
	{
		uint16_t crcSeed = 0xBEEF;
        uint16_t data[] = {0x0123,
                           0x4567,
                           0x8910,
                           0x1112,
                           0x1314};
        uint16_t crcResult;
        uint8_t i;

        //Stop WDT
        WDT_A_hold(WDT_A_BASE);

        //Set P1.0 as an output
        GPIO_setAsOutputPin(
            GPIO_PORT_P1,
            GPIO_PIN0);

        /*
         * Disable the GPIO power-on default high-impedance mode to activate
         * previously configured port settings
         */
        PMM_unlockLPM5();

        //Set the CRC seed
        CRC_setSeed(CRC_BASE,
                    crcSeed);

        for(i = 0; i < 5; i++)
        {
            //Add all of the values into the CRC signature
            CRC_set16BitData(CRC_BASE,
                             data[i]);
        }

        //Save the current CRC signature checksum to be compared for later
        crcResult = CRC_getResult(CRC_BASE);

        //*** Test the CRC ***//

        //Reset the CRC Signature and set the same seed
        CRC_setSeed(CRC_BASE,
                    crcSeed);

        for(i = 0; i < 5; i++)
        {
            //Add all of the values into the CRC signature
            CRC_set16BitData(CRC_BASE,
                             data[i]);
        }

        //Compare the 2 CRC Resulting Signature Checksums
        if(crcResult == CRC_getResult(CRC_BASE))
        {
            //set P1.0
            GPIO_setOutputHighOnPin(
                GPIO_PORT_P1,
                GPIO_PIN0);
        }

        //Enter LPM4, interrupts enabled
        __bis_SR_register(LPM4_bits);
        __no_operation();

		vTaskDelay(100);
	}
}
