// MyFFT_Include.h (Created by FFTDesigner - Version 3.70)

/******************************************************************************

COPYRIGHT.  This software is Copyright  2011 RHDC Services Ltd.

        !  DO NOT EDIT THIS FILE AS IT MAY BE OVERWRITTEN BY
        THE DESIGNER RESULTING IN YOUR CHANGES BEING LOST  !

DISTRIBUTION.  This software may NOT be distributed to a third party without
prior written approval of the copyright holder. Please see the FFT Designer
End User Licence Agreement for details about distribution in object-code form.

DISCLAIMER.  This software is provided "AS IS", without express or implied
warranty.  In no event shall the copyright holder, author(s) or provider(s)
of this software be held liable for any damages arising from its use.

        FFTLength ................................ 8
        WindowType ............................... Kaiser
        WindowLoss (dB) .......................... 8.27
        Equivalent Noise Bandwidth ENBW (Bins) ... 2.052
        Incoherent Power Gain .................... 0.3056
        Coherent Power Gain ...................... 0.1489
        WindowAlpha .............................. 3
        Language ................................. MSP430 Extended C
        Algorithm ................................ Integer (16 Bit)
        Use Shift Division ....................... True
        Use Direct MPY32 Access .................. True

NOTE. When option "Use Direct MPY32 Access" is True, this software will make
direct use of the MPY32 hardware multiplier module including its configuration
registers as well as the operand and result registers.  Therefore, if any ISR
needs to be active whilst the FFT methods are in use, they must comply with
either (a) or (b) below.

   (a). They must not use the MPY32 hardware multiplier module.
   (b). They must perform a full MPY32 context save and restore.

Refer to section "32-Bit Hardware Multiplier", sub-section "Using Interrupts"
of the MSP430x5xx User Guide for more details.

******************************************************************************/

/* FIXED-WIDTH INTEGERS.  Where required, this algorithm uses the C99 standard
fixed-width integer types defined by include <stdint.h>. Fixed-width types are
essential to ensure arithmetic results exactly match the designer's simulation
and the pre-calculated values in the test harness.

Note. If your compiler does not include stdint.h (i.e. is not C99 compliant),
however is otherwise compliant, create a file stdint.h in your project folder
containing typedefs for int16_t & int32_t to map them onto appropriate size
storage types. Refer to the C99 standard for more details. */

#if __STDC_VERSION__ >= 199901L
#include <stdint.h> // Compiler include file containing fixed-width typedefs
#else
#include "stdint.h" // Project include file containing fixed-width typedefs
#endif

#ifndef MyFFT_WorkspaceTypedef
typedef int16_t MyFFT_Workspace_t; // 16 Bit fixed-width integer
#define MyFFT_WorkspaceTypedef
#endif

#define __int16 int
#define __int32 long

#define O9F\
17F86D76A6E\
6FE90FB7A06\
AA2EE2D0235\
DCF33DFB508\
F7FB97B13FA\
5213967FEF4\
E6F0216C6EA\
868F7D861C3\
A89CC58194A\
40E408CA904\
E8334779EA5\
FC2B3634C1C\
EDD49F7BA2A\
9C96EAA5F12\
C24494802DC\
E8527304271\
DE37F44154F\
BD1 MyFFT_W\
orkspace_t
#define O13\
A3ACBBB0D74\
C3A9161089C\
ACF4B1CC57A\
9CFB73764BF\
DCF82C82A48\
D4AEBB3052A\
D3024870A5A\
2F4A285FBAE\
9848DE05334\
4918D209C7D\
D08D14EAD45\
9A5750D5019\
6F3668BDF22\
AAE72908446\
DE2A1F35982\
73B9C07F5DC\
4950D988E72\
3B8 unsigne\
d int
#define OFA\
7153F7ED1CB\
6C0FCF2FFB2\
FAC217481F1\
C052E67EB81\
6D571D13C2A\
5904A323F10\
2B0E1E40BA5\
4E9578FC33C\
A23DB66283C\
896B30C13A5\
9BE53C16FFC\
0CEADBBC2F9\
BB00CE9C45B\
C0BF9FA0495\
7C08BD82B16\
57B6B838B89\
5147E701D8B\
112 int
#define O0F\
5264038205E\
DFB1AC05FBB\
0E8C5E940F2\
B43DC96B0C1\
4A26FAB08C9\
E1EAD7B77E6\
AE4B36856A7\
52E05125DDA\
3B38B76F4FF\
B33883656FE\
DD832A631C3\
E11DB092D98\
ADB7790B526\
5E09775A30D\
4DD2D8CD6B0\
904DCAD1062\
1EB0C7FDABB\
B2B long
#define O90\
1889F4F34F8\
CA18AC2F53D\
1FED346E74C\
E529B80BCAD\
D54E78A260B\
7CD15E7C2E2\
4EE1963722F\
989A8F52F91\
F93C2353BCF\
4658418B051\
89979F5BCCC\
1B0823BBB7D\
EE35B15137C\
E93E3F725EF\
5D4786129E8\
663869EA9F9\
38F8044168B\
427 while
#define O66\
80DBA00F3A8\
8F66F8029A9\
3D71D93CE26\
23C120B5553\
83FA670D193\
F9155215B4A\
DBCF27E353F\
7F4E6B6F5E8\
18352F5DF7F\
8DBBF160E24\
AE939D554EB\
3D149061DE2\
0FDC92914B9\
25442405947\
350CC38887B\
043896DEB73\
CBD35267739\
78D const
#define O7E\
E270DCBFA89\
D6F05D7C5E7\
ADC3A4A5A79\
FDD8EC1012F\
AE0F7EB0632\
1230B3D90B8\
1ABEC1967AF\
60231D9F822\
64324442638\
9C8A4589A1A\
803C140B8AB\
D576CBE8945\
33DC8C377B3\
6141ED2F670\
8C87874EF96\
D4E6B2FE9EC\
23A6BBFFD65\
281 MyFFT_i\
nput_buffer\
_start
#define OBF\
07270A938F2\
DBEC02CFA13\
4DEAD5B60FF\
037867ED6B1\
9312989B2F3\
2B1C5ABFF07\
695A6E234A7\
00E776D9D0F\
7309D16093E\
8DCE0699105\
AC1480632BC\
57251FB0944\
F996ED191F4\
AAF92032B5B\
1D09FCC70C8\
8F7F5CD3681\
7D722A64159\
63D MyFFT_i\
nput_buffer\
_end
#define OED\
EC6D3C90903\
C7345407E9B\
375032311AF\
398CA074953\
7E3F8B4795D\
269370BC9C7\
83B675CF117\
3296F2D1485\
D0BB403F583\
82CF960B131\
2179E4BF92B\
2CEFBA37951\
9C2F66A1323\
9D207A18F52\
4E8C8DE72A4\
E8A01A42E90\
9CF9AC81303\
502 MyFFT_R\
esultR
#define O15\
0AFDE42400D\
A1BDF4F7B5F\
6F27E1941FC\
EEE0174CCBF\
34CAC5DB17F\
6659308DCF7\
05FD783160E\
B3F50FA1AA2\
B9C7CFB5E38\
6A96FF59487\
B3E6C7FB629\
F0AC0C6EAD3\
1FAFFD742D7\
2EAB1F5721F\
48A371FF6C2\
47C5D837EB0\
5BDC969A9C9\
DDE MyFFT_R\
esultI
#define OE7\
26C2F50E078\
99DE24700DB\
8CDD35EC4C5\
B9919C34646\
2BFF299DBFE\
E9D479AC40F\
B07ADEB5114\
8D4B3516F8E\
5B633D1ACFF\
85C99957281\
AEF4A043427\
02C47222896\
4477E290DE9\
C88B961F7BF\
E607694D772\
C7A7A7324C5\
D8A65F894F5\
A96 MyFFT_w\
in
#define O2A\
E64F0D15370\
16DD813A04A\
A98B6D34B19\
6D5B8F89142\
4F3EFEF8ADE\
5CF1B0E5746\
831D37FD1D3\
8742FA42939\
C750E9AF359\
F97A7A97958\
74889F30C72\
08099914C20\
E044AFCA759\
01B164033DD\
36D2DD2C5E6\
D6F665D0940\
6FFF5F7B395\
2A9 MyFFT_t\
wr
#define OC5\
C0DAFA3C4FF\
6865CDE41F5\
61D6F6F5295\
DF224A51CD0\
5B5CED2843E\
E2777B9A332\
604DB6BB520\
EECEF310CDC\
C1AFCF49122\
BC216515BE4\
EABA486C37B\
037C668B548\
2902ABE82EE\
03A59DDCCC2\
DC85BE9C21A\
B30FDE368BD\
CC5CF417DEF\
608 MyFFT_t\
wi
#define OD6\
B7F28AD82C6\
29CEBDA096B\
0EAC802875F\
9D07CA1F8A7\
5E019B2078F\
C337283F2F5\
B95BC4A664C\
ABDC016D4FA\
0AB43B66668\
009DF9605A0\
6834AD00CA6\
3D020EDC5CC\
1DD7668D18E\
09D894835BE\
B681D67B3F8\
965C9BA0911\
427C647BFB8\
A4E MyFFT_I\
NPUT_LENGTH\

#define O06\
CD5E3A8084F\
DB7BFC2C165\
0C7B733DDF5\
080FC058B6D\
700DF0A4BB9\
CB30E163F76\
FE1C6769F9F\
4ED61233ADF\
4BDD7F5BECB\
3773D9C5E3F\
B91E4C6573C\
9890264DFDF\
7F7349773CA\
3CC6B19964B\
727907AB388\
7F7A9DABF92\
077CDB7C7A0\
874 MyFFT_L\
OG2BASE2OFN\

#define O68\
A2C02F1DB19\
C2A38F39189\
626623DBF8D\
756AB798125\
C4866396BB2\
A375ACB3803\
E4B18A9AC5A\
50F9BE96AED\
E875AAE4587\
78E2AC24F90\
416421F6EDD\
C7881179DCA\
D5189161487\
7F5DA086666\
32DC87B0699\
CC5E2AA39F1\
5605425A822\
207 MPY32CT\
L0
#define OB8\
B79213C36C2\
B1050347C74\
1328578BD1B\
0A9AFDA7783\
36542E31F3A\
21C1A4B89FC\
A3E39D4141D\
AB9F554C8E4\
6219E93324C\
0F42D7E5351\
A4B71643103\
146E2AA9933\
69D5F033D00\
F5D1DFF655B\
906631482D7\
7C52647A5F2\
1899DA4B776\
6DC MACS
#define O2E\
25C285356CB\
B0ED8785A13\
77027D79FFD\
CC4A243771A\
FCECB3B2DC4\
D2BADC475D9\
7F9B96FABEA\
AA3F653F3D0\
7DA29BC72B9\
5993B83FCFD\
61061060FB5\
B7E79FDDC50\
3A27D1ED924\
CECFB099722\
A7286E432F7\
722054A7648\
4B6649403EA\
72D MAC
#define O22\
F518A33FBB5\
0D3ADC353D2\
C22661CA9BC\
9FD756E10AF\
AFF10C3048B\
0A626F92BF1\
14A4979C74B\
F0B7B199FA1\
FD8880BB03C\
4CBBB535FEE\
813CC15ED31\
0668C484442\
92F69A1D5C2\
10AF0ECB9F4\
13DCEEA470D\
0DAADEB914A\
0E8DA043711\
D5C MPYS
#define O34\
C82D72B2EC6\
D3E1C4A3CEC\
D39A23FE3BB\
49583331A51\
EC233413F53\
F22958CBBF7\
C789708AB60\
B94DAC76090\
929DB16E8F7\
9DB639FDC3C\
61786E7AD15\
4AFA06E490C\
027B72783D1\
C5390725DD6\
EB1283330FE\
F6B75767684\
D476A8C3D9A\
58E OP2
#define O35\
C3A4FBFD3C3\
B02E8F91E11\
855E8844B3E\
42D03AC3F9F\
ED8AFC7C75B\
37CE7B7DC7E\
BEFDC7B9E70\
CCCD4702038\
65C80B8D954\
031558E9456\
2EDF5F2CD9B\
3DA8D1FBA13\
755AD774A15\
866076D5031\
028D40F37ED\
4723BC14A79\
EB6A580D658\
4EE RES1
#define OB0\
54FE6FCE2A4\
D56F2BB5D57\
6B7C5FB4B55\
04642199C40\
86DAC8F0DFC\
A1A9AAF2070\
BE980E8F035\
099A91C3E38\
1ED98A6B65F\
F1B264420FC\
674417CF213\
43005F1C8D9\
53A8A15D9FC\
1528EEC03C0\
547C7D9B57F\
517ACD511A1\
873242F25EA\
5C4 SUMEXT
#define MyF\
FT_PRIM00S \
O317004BE5E\
9EA73353787\
042F4F5C6AB\
897A0335B8D\
02C3A0A0BD5\
F8ED3754DB0\
DB109BF0DB3\
3E674E08093\
8F18600D274\
B33B7BC604F\
C9E9709BB7D\
B5AE80A7D39\
8D3E7BE9FCC\
38B091C887B\
592E104F875\
85371690C99\
E6168ECDE62\
ED5AE9
#define MyF\
FT_PRIM00W \
O71E1D9317B\
A148326A841\
86ACBB2EC03\
242994EF94A\
7EBF2A0F7D5\
BD0A84D11BC\
DD1183804A7\
A00FC972F35\
7716CD44FF4\
963614A813B\
0E97633FC2D\
E8DA7D9D9C3\
263DFE0A3D2\
58FA875C49E\
909FA033511\
E9EB4F61F3E\
6F30243FBC7\
0E7BE2
#define MyF\
FT_PRIM00R \
OB911ABE065\
09E3A5AD360\
F2DEEA6308F\
E8AB9B52463\
020C57C88D0\
872F452C7EB\
D07E709848C\
3284D7A590C\
2E3B9DA09F0\
E375959C3FA\
02A3258793F\
74F4E293739\
1605E0CD675\
5D048598491\
D6D0AEA677A\
8846EBF6675\
DFB7CD0DF93\
9FB1FF
#define MyF\
FT_PRIM00T \
O8DC8AE4771\
F8643A06B77\
7FAD145D1AE\
01520C9821B\
D766F0ACB3B\
FF6B6BD8E5E\
D06489B329D\
5ACAC0E949F\
33D745E69E3\
37FA2CA71E6\
9BF64FCEBA1\
C0F34E2CD64\
F63147A0220\
F514F1EB155\
4292944E01A\
2177EC1A974\
6DEC48CC11E\
AFBE50
#define O31\
7004BE5E9EA\
73353787042\
F4F5C6AB897\
A0335B8D02C\
3A0A0BD5F8E\
D3754DB0DB1\
09BF0DB33E6\
74E080938F1\
8600D274B33\
B7BC604FC9E\
9709BB7DB5A\
E80A7D398D3\
E7BE9FCC38B\
091C887B592\
E104F875853\
71690C99E61\
68ECDE62ED5\
AE9(OCCCF19\
0FE64225E53\
F4C9ACB046E\
0905CFB77AA\
7AD3700DB62\
47309A1E778\
C44DF60ADCD\
5E95C88D9F9\
879FC6AC4A9\
3EFF80F2E43\
14BA37905C8\
038F5D94457\
E4419FFA6DD\
C06A922B861\
54F0899F533\
F39FDA49CEE\
B45155AC43B\
5E15F187CC)\
O9F17F86D76\
A6E6FE90FB7\
A06AA2EE2D0\
235DCF33DFB\
508F7FB97B1\
3FA5213967F\
EF4E6F0216C\
6EA868F7D86\
1C3A89CC581\
94A40E408CA\
904E8334779\
EA5FC2B3634\
C1CEDD49F7B\
A2A9C96EAA5\
F12C2449480\
2DCE8527304\
271DE37F441\
54FBD1*O524\
77DCC9F26C2\
72FACE49FD7\
A76F138E142\
7147FF2845D\
798CECA0308\
88494843CDD\
C5F87782BAA\
830B5BE935A\
68E2CE0C3D8\
2A631659E8B\
7F73CBEB5B5\
D18FA035C55\
57C0873BF3A\
DD5A0B0B807\
17163349254\
DD947C1AFC2\
B4B2EBBBEF5\
50=OEDEC6D3\
C90903C7345\
407E9B37503\
2311AF398CA\
0749537E3F8\
B4795D26937\
0BC9C783B67\
5CF1173296F\
2D1485D0BB4\
03F58382CF9\
60B1312179E\
4BF92B2CEFB\
A379519C2F6\
6A13239D207\
A18F524E8C8\
DE72A4E8A01\
A42E909CF9A\
C81303502;O\
9F17F86D76A\
6E6FE90FB7A\
06AA2EE2D02\
35DCF33DFB5\
08F7FB97B13\
FA5213967FE\
F4E6F0216C6\
EA868F7D861\
C3A89CC5819\
4A40E408CA9\
04E8334779E\
A5FC2B3634C\
1CEDD49F7BA\
2A9C96EAA5F\
12C24494802\
DCE85273042\
71DE37F4415\
4FBD1*O27C7\
FF6ADF177AB\
F4D926903E8\
664593B0287\
B1699454CCF\
3B3846123E1\
F29A36452C0\
6743F454D25\
F368E4C84A0\
812C0B05062\
E2982FAA97B\
BFDFEB30886\
1C526A52B28\
FEE36C6A395\
BA372DE530A\
636ADB933FF\
3023C40D669\
42BDCB73298\
1=O150AFDE4\
2400DA1BDF4\
F7B5F6F27E1\
941FCEEE017\
4CCBF34CAC5\
DB17F665930\
8DCF705FD78\
3160EB3F50F\
A1AA2B9C7CF\
B5E386A96FF\
59487B3E6C7\
FB629F0AC0C\
6EAD31FAFFD\
742D72EAB1F\
5721F48A371\
FF6C247C5D8\
37EB05BDC96\
9A9C9DDE;O9\
F17F86D76A6\
E6FE90FB7A0\
6AA2EE2D023\
5DCF33DFB50\
8F7FB97B13F\
A5213967FEF\
4E6F0216C6E\
A868F7D861C\
3A89CC58194\
A40E408CA90\
4E8334779EA\
5FC2B3634C1\
CEDD49F7BA2\
A9C96EAA5F1\
2C24494802D\
CE852730427\
1DE37F44154\
FBD1*O79BEA\
59DA16BF471\
5C881AB501B\
21AC9DA25A8\
F04D99EFC78\
43486CDF187\
CE2FBF1A30E\
E9182D65553\
4F36E0D6D05\
9F2EFF06EA6\
AD4002072BF\
22F00EBC370\
90AD94895F0\
A61A04EEAD5\
9E9B9ADA8F7\
5AAFA36839F\
23610123B8D\
4B528635E17\
=OBF07270A9\
38F2DBEC02C\
FA134DEAD5B\
60FF037867E\
D6B19312989\
B2F32B1C5AB\
FF07695A6E2\
34A700E776D\
9D0F7309D16\
093E8DCE069\
9105AC14806\
32BC57251FB\
0944F996ED1\
91F4AAF9203\
2B5B1D09FCC\
70C88F7F5CD\
36817D722A6\
415963D;OFA\
7153F7ED1CB\
6C0FCF2FFB2\
FAC217481F1\
C052E67EB81\
6D571D13C2A\
5904A323F10\
2B0E1E40BA5\
4E9578FC33C\
A23DB66283C\
896B30C13A5\
9BE53C16FFC\
0CEADBBC2F9\
BB00CE9C45B\
C0BF9FA0495\
7C08BD82B16\
57B6B838B89\
5147E701D8B\
112 O37A450\
76F7115417A\
54AD5B0B188\
080D10943E9\
E6FB7CB9353\
5F6755F66E4\
AEF658334E3\
D907377FAB5\
115EA3AA7DF\
B588A85E692\
C130E776A99\
B61A13B8D1E\
486F8617E8A\
C9AF5BD7F68\
A53E0FA0BAB\
36587D6EC98\
9B7BF5CA91E\
CEB4122904=\
OD6B7F28AD8\
2C629CEBDA0\
96B0EAC8028\
75F9D07CA1F\
8A75E019B20\
78FC337283F\
2F5B95BC4A6\
64CABDC016D\
4FA0AB43B66\
668009DF960\
5A06834AD00\
CA63D020EDC\
5CC1DD7668D\
18E09D89483\
5BEB681D67B\
3F8965C9BA0\
911427C647B\
FB8A4E;O901\
889F4F34F8C\
A18AC2F53D1\
FED346E74CE\
529B80BCADD\
54E78A260B7\
CD15E7C2E24\
EE1963722F9\
89A8F52F91F\
93C2353BCF4\
658418B0518\
9979F5BCCC1\
B0823BBB7DE\
E35B15137CE\
93E3F725EF5\
D4786129E86\
63869EA9F93\
8F8044168B4\
27(O37A4507\
6F7115417A5\
4AD5B0B1880\
80D10943E9E\
6FB7CB93535\
F6755F66E4A\
EF658334E3D\
907377FAB51\
15EA3AA7DFB\
588A85E692C\
130E776A99B\
61A13B8D1E4\
86F8617E8AC\
9AF5BD7F68A\
53E0FA0BAB3\
6587D6EC989\
B7BF5CA91EC\
EB4122904--\
){*(O27C7FF\
6ADF177ABF4\
D926903E866\
4593B0287B1\
699454CCF3B\
3846123E1F2\
9A36452C067\
43F454D25F3\
68E4C84A081\
2C0B05062E2\
982FAA97BBF\
DFEB308861C\
526A52B28FE\
E36C6A395BA\
372DE530A63\
6ADB933FF30\
23C40D66942\
BDCB732981+\
+)=0;*(O524\
77DCC9F26C2\
72FACE49FD7\
A76F138E142\
7147FF2845D\
798CECA0308\
88494843CDD\
C5F87782BAA\
830B5BE935A\
68E2CE0C3D8\
2A631659E8B\
7F73CBEB5B5\
D18FA035C55\
57C0873BF3A\
DD5A0B0B807\
17163349254\
DD947C1AFC2\
B4B2EBBBEF5\
50++)=*(OCC\
CF190FE6422\
5E53F4C9ACB\
046E0905CFB\
77AA7AD3700\
DB6247309A1\
E778C44DF60\
ADCD5E95C88\
D9F9879FC6A\
C4A93EFF80F\
2E4314BA379\
05C8038F5D9\
4457E4419FF\
A6DDC06A922\
B86154F0899\
F533F39FDA4\
9CEEB45155A\
C43B5E15F18\
7CC++);if(O\
CCCF190FE64\
225E53F4C9A\
CB046E0905C\
FB77AA7AD37\
00DB6247309\
A1E778C44DF\
60ADCD5E95C\
88D9F9879FC\
6AC4A93EFF8\
0F2E4314BA3\
7905C8038F5\
D94457E4419\
FFA6DDC06A9\
22B86154F08\
99F533F39FD\
A49CEEB4515\
5AC43B5E15F\
187CC >=O79\
BEA59DA16BF\
4715C881AB5\
01B21AC9DA2\
5A8F04D99EF\
C7843486CDF\
187CE2FBF1A\
30EE9182D65\
5534F36E0D6\
D059F2EFF06\
EA6AD400207\
2BF22F00EBC\
37090AD9489\
5F0A61A04EE\
AD59E9B9ADA\
8F75AAFA368\
39F23610123\
B8D4B528635\
E17){OCCCF1\
90FE64225E5\
3F4C9ACB046\
E0905CFB77A\
A7AD3700DB6\
247309A1E77\
8C44DF60ADC\
D5E95C88D9F\
9879FC6AC4A\
93EFF80F2E4\
314BA37905C\
8038F5D9445\
7E4419FFA6D\
DC06A922B86\
154F0899F53\
3F39FDA49CE\
EB45155AC43\
B5E15F187CC\
=O7EE270DCB\
FA89D6F05D7\
C5E7ADC3A4A\
5A79FDD8EC1\
012FAE0F7EB\
06321230B3D\
90B81ABEC19\
67AF60231D9\
F8226432444\
26389C8A458\
9A1A803C140\
B8ABD576CBE\
894533DC8C3\
77B36141ED2\
F6708C87874\
EF96D4E6B2F\
E9EC23A6BBF\
FD65281;}}
#define OB9\
11ABE06509E\
3A5AD360F2D\
EEA6308FE8A\
B9B52463020\
C57C88D0872\
F452C7EBD07\
E709848C328\
4D7A590C2E3\
B9DA09F0E37\
5959C3FA02A\
3258793F74F\
4E293739160\
5E0CD6755D0\
48598491D6D\
0AEA677A884\
6EBF6675DFB\
7CD0DF939FB\
1FF  O13A3A\
CBBB0D74C3A\
9161089CACF\
4B1CC57A9CF\
B73764BFDCF\
82C82A48D4A\
EBB3052AD30\
24870A5A2F4\
A285FBAE984\
8DE05334491\
8D209C7DD08\
D14EAD459A5\
750D50196F3\
668BDF22AAE\
72908446DE2\
A1F3598273B\
9C07F5DC495\
0D988E723B8\
 O632A220EE\
0DA2F431731\
0B864B826AD\
CD45D456F33\
1150FC0C29D\
08A9D1267CC\
EDA6FCD4F18\
D794A34BDA4\
C8AADA86124\
6FC67CBD445\
5BFF95ADB45\
7DCBDC3E0B4\
1B10C690FE8\
3430DDB6D9E\
938DAE06E0E\
BF2D25AC9DB\
E9F93736AA1\
75B3D55,O92\
9D25287BAC8\
30F732DEE02\
A037432E9A9\
DA197E4DE1E\
72CB90DC0E7\
14A2A2C5ABB\
432A8154095\
9561860B145\
BB6D0EB55B8\
3FDD0ED6464\
68CA3C79F3E\
20CF315F1CB\
F3A055F0D0D\
B2D4CEB73D1\
500D382F10D\
48CDE64779C\
037BFD5A2B1\
016=0,O664B\
49AEEAD9F7C\
708BDC4DB15\
7B7CEDFCD2D\
B90DD537EFA\
9C6DBDB12B5\
A858249A4EF\
284DCB2E18D\
7FE8F87BC47\
615E8B22F38\
890B6865762\
8BF3580280E\
CFD80BA372D\
F2FC3254D1B\
B2E0FD0CFF4\
FFACE40692D\
16B87D38BBD\
5239DEF0A41\
0;O9F17F86D\
76A6E6FE90F\
B7A06AA2EE2\
D0235DCF33D\
FB508F7FB97\
B13FA521396\
7FEF4E6F021\
6C6EA868F7D\
861C3A89CC5\
8194A40E408\
CA904E83347\
79EA5FC2B36\
34C1CEDD49F\
7BA2A9C96EA\
A5F12C24494\
802DCE85273\
04271DE37F4\
4154FBD1 O9\
7B34ED7D996\
C9334F935D6\
21DE70EF035\
98542767498\
3E089407F4A\
9666651654C\
C0CFF1D87C0\
0C68F36ABA2\
985FDCDCBD0\
52832C65760\
80B69A5C137\
1EFECF429CE\
B02513CD0F5\
B059D2CF26D\
846C8C24296\
6B42786DBDC\
81802DA31F1\
EE0B,O67007\
B8D2D141B78\
0358DD4AC17\
1B496718986\
B5CD81A437E\
0AD9DA90B74\
2DF99878BE0\
25E25FCC23C\
23B4B3D7BFE\
7526956E46A\
B1D3FCBC306\
094C9644AC3\
1DBCBB9B1A9\
831F52B24DC\
487F19ADD1E\
9EB5C3EEE9A\
A593A8FF97E\
F4B8A64A777\
;for(O632A2\
20EE0DA2F43\
17310B864B8\
26ADCD45D45\
6F331150FC0\
C29D08A9D12\
67CCEDA6FCD\
4F18D794A34\
BDA4C8AADA8\
61246FC67CB\
D4455BFF95A\
DB457DCBDC3\
E0B41B10C69\
0FE83430DDB\
6D9E938DAE0\
6E0EBF2D25A\
C9DBE9F9373\
6AA175B3D55\
=1;O632A220\
EE0DA2F4317\
310B864B826\
ADCD45D456F\
331150FC0C2\
9D08A9D1267\
CCEDA6FCD4F\
18D794A34BD\
A4C8AADA861\
246FC67CBD4\
455BFF95ADB\
457DCBDC3E0\
B41B10C690F\
E83430DDB6D\
9E938DAE06E\
0EBF2D25AC9\
DBE9F93736A\
A175B3D55<O\
D6B7F28AD82\
C629CEBDA09\
6B0EAC80287\
5F9D07CA1F8\
A75E019B207\
8FC337283F2\
F5B95BC4A66\
4CABDC016D4\
FA0AB43B666\
68009DF9605\
A06834AD00C\
A63D020EDC5\
CC1DD7668D1\
8E09D894835\
BEB681D67B3\
F8965C9BA09\
11427C647BF\
B8A4E-1;O63\
2A220EE0DA2\
F4317310B86\
4B826ADCD45\
D456F331150\
FC0C29D08A9\
D1267CCEDA6\
FCD4F18D794\
A34BDA4C8AA\
DA861246FC6\
7CBD4455BFF\
95ADB457DCB\
DC3E0B41B10\
C690FE83430\
DDB6D9E938D\
AE06E0EBF2D\
25AC9DBE9F9\
3736AA175B3\
D55++){O664\
B49AEEAD9F7\
C708BDC4DB1\
57B7CEDFCD2\
DB90DD537EF\
A9C6DBDB12B\
5A858249A4E\
F284DCB2E18\
D7FE8F87BC4\
7615E8B22F3\
8890B686576\
28BF3580280\
ECFD80BA372\
DF2FC3254D1\
BB2E0FD0CFF\
4FFACE40692\
D16B87D38BB\
D5239DEF0A4\
10=OD6B7F28\
AD82C629CEB\
DA096B0EAC8\
02875F9D07C\
A1F8A75E019\
B2078FC3372\
83F2F5B95BC\
4A664CABDC0\
16D4FA0AB43\
B66668009DF\
9605A06834A\
D00CA63D020\
EDC5CC1DD76\
68D18E09D89\
4835BEB681D\
67B3F8965C9\
BA0911427C6\
47BFB8A4E/2\
;O901889F4F\
34F8CA18AC2\
F53D1FED346\
E74CE529B80\
BCADD54E78A\
260B7CD15E7\
C2E24EE1963\
722F989A8F5\
2F91F93C235\
3BCF4658418\
B05189979F5\
BCCC1B0823B\
BB7DEE35B15\
137CE93E3F7\
25EF5D47861\
29E8663869E\
A9F938F8044\
168B427(O66\
4B49AEEAD9F\
7C708BDC4DB\
157B7CEDFCD\
2DB90DD537E\
FA9C6DBDB12\
B5A858249A4\
EF284DCB2E1\
8D7FE8F87BC\
47615E8B22F\
38890B68657\
628BF358028\
0ECFD80BA37\
2DF2FC3254D\
1BB2E0FD0CF\
F4FFACE4069\
2D16B87D38B\
BD5239DEF0A\
410<=O929D2\
5287BAC830F\
732DEE02A03\
7432E9A9DA1\
97E4DE1E72C\
B90DC0E714A\
2A2C5ABB432\
A8154095956\
1860B145BB6\
D0EB55B83FD\
D0ED646468C\
A3C79F3E20C\
F315F1CBF3A\
055F0D0DB2D\
4CEB73D1500\
D382F10D48C\
DE64779C037\
BFD5A2B1016\
){O929D2528\
7BAC830F732\
DEE02A03743\
2E9A9DA197E\
4DE1E72CB90\
DC0E714A2A2\
C5ABB432A81\
54095956186\
0B145BB6D0E\
B55B83FDD0E\
D646468CA3C\
79F3E20CF31\
5F1CBF3A055\
F0D0DB2D4CE\
B73D1500D38\
2F10D48CDE6\
4779C037BFD\
5A2B1016=O9\
29D25287BAC\
830F732DEE0\
2A037432E9A\
9DA197E4DE1\
E72CB90DC0E\
714A2A2C5AB\
B432A815409\
59561860B14\
5BB6D0EB55B\
83FDD0ED646\
468CA3C79F3\
E20CF315F1C\
BF3A055F0D0\
DB2D4CEB73D\
1500D382F10\
D48CDE64779\
C037BFD5A2B\
1016-O664B4\
9AEEAD9F7C7\
08BDC4DB157\
B7CEDFCD2DB\
90DD537EFA9\
C6DBDB12B5A\
858249A4EF2\
84DCB2E18D7\
FE8F87BC476\
15E8B22F388\
90B68657628\
BF3580280EC\
FD80BA372DF\
2FC3254D1BB\
2E0FD0CFF4F\
FACE40692D1\
6B87D38BBD5\
239DEF0A410\
;O664B49AEE\
AD9F7C708BD\
C4DB157B7CE\
DFCD2DB90DD\
537EFA9C6DB\
DB12B5A8582\
49A4EF284DC\
B2E18D7FE8F\
87BC47615E8\
B22F38890B6\
8657628BF35\
80280ECFD80\
BA372DF2FC3\
254D1BB2E0F\
D0CFF4FFACE\
40692D16B87\
D38BBD5239D\
EF0A410>>=1\
;}O929D2528\
7BAC830F732\
DEE02A03743\
2E9A9DA197E\
4DE1E72CB90\
DC0E714A2A2\
C5ABB432A81\
54095956186\
0B145BB6D0E\
B55B83FDD0E\
D646468CA3C\
79F3E20CF31\
5F1CBF3A055\
F0D0DB2D4CE\
B73D1500D38\
2F10D48CDE6\
4779C037BFD\
5A2B1016+=O\
664B49AEEAD\
9F7C708BDC4\
DB157B7CEDF\
CD2DB90DD53\
7EFA9C6DBDB\
12B5A858249\
A4EF284DCB2\
E18D7FE8F87\
BC47615E8B2\
2F38890B686\
57628BF3580\
280ECFD80BA\
372DF2FC325\
4D1BB2E0FD0\
CFF4FFACE40\
692D16B87D3\
8BBD5239DEF\
0A410;if(O6\
32A220EE0DA\
2F4317310B8\
64B826ADCD4\
5D456F33115\
0FC0C29D08A\
9D1267CCEDA\
6FCD4F18D79\
4A34BDA4C8A\
ADA861246FC\
67CBD4455BF\
F95ADB457DC\
BDC3E0B41B1\
0C690FE8343\
0DDB6D9E938\
DAE06E0EBF2\
D25AC9DBE9F\
93736AA175B\
3D55<O929D2\
5287BAC830F\
732DEE02A03\
7432E9A9DA1\
97E4DE1E72C\
B90DC0E714A\
2A2C5ABB432\
A8154095956\
1860B145BB6\
D0EB55B83FD\
D0ED646468C\
A3C79F3E20C\
F315F1CBF3A\
055F0D0DB2D\
4CEB73D1500\
D382F10D48C\
DE64779C037\
BFD5A2B1016\
){O97B34ED7\
D996C9334F9\
35D621DE70E\
F0359854276\
74983E08940\
7F4A9666651\
654CC0CFF1D\
87C00C68F36\
ABA2985FDCD\
CBD052832C6\
576080B69A5\
C1371EFECF4\
29CEB02513C\
D0F5B059D2C\
F26D846C8C2\
42966B42786\
DBDC81802DA\
31F1EE0B=OE\
DEC6D3C9090\
3C7345407E9\
B375032311A\
F398CA07495\
37E3F8B4795\
D269370BC9C\
783B675CF11\
73296F2D148\
5D0BB403F58\
382CF960B13\
12179E4BF92\
B2CEFBA3795\
19C2F66A132\
39D207A18F5\
24E8C8DE72A\
4E8A01A42E9\
09CF9AC8130\
3502[O929D2\
5287BAC830F\
732DEE02A03\
7432E9A9DA1\
97E4DE1E72C\
B90DC0E714A\
2A2C5ABB432\
A8154095956\
1860B145BB6\
D0EB55B83FD\
D0ED646468C\
A3C79F3E20C\
F315F1CBF3A\
055F0D0DB2D\
4CEB73D1500\
D382F10D48C\
DE64779C037\
BFD5A2B1016\
];O67007B8D\
2D141B78035\
8DD4AC171B4\
96718986B5C\
D81A437E0AD\
9DA90B742DF\
99878BE025E\
25FCC23C23B\
4B3D7BFE752\
6956E46AB1D\
3FCBC306094\
C9644AC31DB\
CBB9B1A9831\
F52B24DC487\
F19ADD1E9EB\
5C3EEE9AA59\
3A8FF97EF4B\
8A64A777=O1\
50AFDE42400\
DA1BDF4F7B5\
F6F27E1941F\
CEEE0174CCB\
F34CAC5DB17\
F6659308DCF\
705FD783160\
EB3F50FA1AA\
2B9C7CFB5E3\
86A96FF5948\
7B3E6C7FB62\
9F0AC0C6EAD\
31FAFFD742D\
72EAB1F5721\
F48A371FF6C\
247C5D837EB\
05BDC969A9C\
9DDE[O929D2\
5287BAC830F\
732DEE02A03\
7432E9A9DA1\
97E4DE1E72C\
B90DC0E714A\
2A2C5ABB432\
A8154095956\
1860B145BB6\
D0EB55B83FD\
D0ED646468C\
A3C79F3E20C\
F315F1CBF3A\
055F0D0DB2D\
4CEB73D1500\
D382F10D48C\
DE64779C037\
BFD5A2B1016\
];OEDEC6D3C\
90903C73454\
07E9B375032\
311AF398CA0\
749537E3F8B\
4795D269370\
BC9C783B675\
CF1173296F2\
D1485D0BB40\
3F58382CF96\
0B1312179E4\
BF92B2CEFBA\
379519C2F66\
A13239D207A\
18F524E8C8D\
E72A4E8A01A\
42E909CF9AC\
81303502[O9\
29D25287BAC\
830F732DEE0\
2A037432E9A\
9DA197E4DE1\
E72CB90DC0E\
714A2A2C5AB\
B432A815409\
59561860B14\
5BB6D0EB55B\
83FDD0ED646\
468CA3C79F3\
E20CF315F1C\
BF3A055F0D0\
DB2D4CEB73D\
1500D382F10\
D48CDE64779\
C037BFD5A2B\
1016]=OEDEC\
6D3C90903C7\
345407E9B37\
5032311AF39\
8CA0749537E\
3F8B4795D26\
9370BC9C783\
B675CF11732\
96F2D1485D0\
BB403F58382\
CF960B13121\
79E4BF92B2C\
EFBA379519C\
2F66A13239D\
207A18F524E\
8C8DE72A4E8\
A01A42E909C\
F9AC8130350\
2[O632A220E\
E0DA2F43173\
10B864B826A\
DCD45D456F3\
31150FC0C29\
D08A9D1267C\
CEDA6FCD4F1\
8D794A34BDA\
4C8AADA8612\
46FC67CBD44\
55BFF95ADB4\
57DCBDC3E0B\
41B10C690FE\
83430DDB6D9\
E938DAE06E0\
EBF2D25AC9D\
BE9F93736AA\
175B3D55];O\
150AFDE4240\
0DA1BDF4F7B\
5F6F27E1941\
FCEEE0174CC\
BF34CAC5DB1\
7F6659308DC\
F705FD78316\
0EB3F50FA1A\
A2B9C7CFB5E\
386A96FF594\
87B3E6C7FB6\
29F0AC0C6EA\
D31FAFFD742\
D72EAB1F572\
1F48A371FF6\
C247C5D837E\
B05BDC969A9\
C9DDE[O929D\
25287BAC830\
F732DEE02A0\
37432E9A9DA\
197E4DE1E72\
CB90DC0E714\
A2A2C5ABB43\
2A815409595\
61860B145BB\
6D0EB55B83F\
DD0ED646468\
CA3C79F3E20\
CF315F1CBF3\
A055F0D0DB2\
D4CEB73D150\
0D382F10D48\
CDE64779C03\
7BFD5A2B101\
6]=O150AFDE\
42400DA1BDF\
4F7B5F6F27E\
1941FCEEE01\
74CCBF34CAC\
5DB17F66593\
08DCF705FD7\
83160EB3F50\
FA1AA2B9C7C\
FB5E386A96F\
F59487B3E6C\
7FB629F0AC0\
C6EAD31FAFF\
D742D72EAB1\
F5721F48A37\
1FF6C247C5D\
837EB05BDC9\
69A9C9DDE[O\
632A220EE0D\
A2F4317310B\
864B826ADCD\
45D456F3311\
50FC0C29D08\
A9D1267CCED\
A6FCD4F18D7\
94A34BDA4C8\
AADA861246F\
C67CBD4455B\
FF95ADB457D\
CBDC3E0B41B\
10C690FE834\
30DDB6D9E93\
8DAE06E0EBF\
2D25AC9DBE9\
F93736AA175\
B3D55];OEDE\
C6D3C90903C\
7345407E9B3\
75032311AF3\
98CA0749537\
E3F8B4795D2\
69370BC9C78\
3B675CF1173\
296F2D1485D\
0BB403F5838\
2CF960B1312\
179E4BF92B2\
CEFBA379519\
C2F66A13239\
D207A18F524\
E8C8DE72A4E\
8A01A42E909\
CF9AC813035\
02[O632A220\
EE0DA2F4317\
310B864B826\
ADCD45D456F\
331150FC0C2\
9D08A9D1267\
CCEDA6FCD4F\
18D794A34BD\
A4C8AADA861\
246FC67CBD4\
455BFF95ADB\
457DCBDC3E0\
B41B10C690F\
E83430DDB6D\
9E938DAE06E\
0EBF2D25AC9\
DBE9F93736A\
A175B3D55]=\
O97B34ED7D9\
96C9334F935\
D621DE70EF0\
35985427674\
983E089407F\
4A966665165\
4CC0CFF1D87\
C00C68F36AB\
A2985FDCDCB\
D052832C657\
6080B69A5C1\
371EFECF429\
CEB02513CD0\
F5B059D2CF2\
6D846C8C242\
966B42786DB\
DC81802DA31\
F1EE0B;O150\
AFDE42400DA\
1BDF4F7B5F6\
F27E1941FCE\
EE0174CCBF3\
4CAC5DB17F6\
659308DCF70\
5FD783160EB\
3F50FA1AA2B\
9C7CFB5E386\
A96FF59487B\
3E6C7FB629F\
0AC0C6EAD31\
FAFFD742D72\
EAB1F5721F4\
8A371FF6C24\
7C5D837EB05\
BDC969A9C9D\
DE[O632A220\
EE0DA2F4317\
310B864B826\
ADCD45D456F\
331150FC0C2\
9D08A9D1267\
CCEDA6FCD4F\
18D794A34BD\
A4C8AADA861\
246FC67CBD4\
455BFF95ADB\
457DCBDC3E0\
B41B10C690F\
E83430DDB6D\
9E938DAE06E\
0EBF2D25AC9\
DBE9F93736A\
A175B3D55]=\
O67007B8D2D\
141B780358D\
D4AC171B496\
718986B5CD8\
1A437E0AD9D\
A90B742DF99\
878BE025E25\
FCC23C23B4B\
3D7BFE75269\
56E46AB1D3F\
CBC306094C9\
644AC31DBCB\
B9B1A9831F5\
2B24DC487F1\
9ADD1E9EB5C\
3EEE9AA593A\
8FF97EF4B8A\
64A777;}}
#define MyF\
FT_WINDOW_M\
UL(O18D4C2A\
185F99D6541\
FF5D7A89656\
9A81C940554\
25633BBD39B\
D98AC574004\
4C232F1D72B\
43299C51072\
C9E7EEB536F\
E5657C0564A\
7C8FE88AD51\
9118A3C62EA\
B0D85CF5628\
02B5FB9B9B2\
995E59B35C7\
B18C62E5B17\
DE48DA3F34E\
55368E08F,O\
A7E617A3F79\
B5DA8D1533C\
161FBDF0CDB\
6C15F51D660\
C14F2FE8D3F\
8BC10643115\
34B996F9D87\
50D47A846B4\
41EBF83C57D\
43E795BDE67\
61616FED953\
8A259986DE3\
9F78ECE5DD3\
E8A3DAFFC67\
58DE80F07AC\
D684C19398A\
C4ADCBD15D9\
20289){O22F\
518A33FBB50\
D3ADC353D2C\
22661CA9BC9\
FD756E10AFA\
FF10C3048B0\
A626F92BF11\
4A4979C74BF\
0B7B199FA1F\
D8880BB03C4\
CBBB535FEE8\
13CC15ED310\
668C4844429\
2F69A1D5C21\
0AF0ECB9F41\
3DCEEA470D0\
DAADEB914A0\
E8DA043711D\
5C=*(O18D4C\
2A185F99D65\
41FF5D7A896\
569A81C9405\
5425633BBD3\
9BD98AC5740\
044C232F1D7\
2B43299C510\
72C9E7EEB53\
6FE5657C056\
4A7C8FE88AD\
519118A3C62\
EAB0D85CF56\
2802B5FB9B9\
B2995E59B35\
C7B18C62E5B\
17DE48DA3F3\
4E55368E08F\
);O34C82D72\
B2EC6D3E1C4\
A3CECD39A23\
FE3BB495833\
31A51EC2334\
13F53F22958\
CBBF7C78970\
8AB60B94DAC\
76090929DB1\
6E8F79DB639\
FDC3C61786E\
7AD154AFA06\
E490C027B72\
783D1C53907\
25DD6EB1283\
330FEF6B757\
67684D476A8\
C3D9A58E=*(\
OA7E617A3F7\
9B5DA8D1533\
C161FBDF0CD\
B6C15F51D66\
0C14F2FE8D3\
F8BC1064311\
534B996F9D8\
750D47A846B\
441EBF83C57\
D43E795BDE6\
761616FED95\
38A259986DE\
39F78ECE5DD\
3E8A3DAFFC6\
758DE80F07A\
CD684C19398\
AC4ADCBD15D\
920289);if(\
OB054FE6FCE\
2A4D56F2BB5\
D576B7C5FB4\
B5504642199\
C4086DAC8F0\
DFCA1A9AAF2\
070BE980E8F\
035099A91C3\
E381ED98A6B\
65FF1B26442\
0FC674417CF\
21343005F1C\
8D953A8A15D\
9FC1528EEC0\
3C0547C7D9B\
57F517ACD51\
1A1873242F2\
5EA5C4){O2E\
25C285356CB\
B0ED8785A13\
77027D79FFD\
CC4A243771A\
FCECB3B2DC4\
D2BADC475D9\
7F9B96FABEA\
AA3F653F3D0\
7DA29BC72B9\
5993B83FCFD\
61061060FB5\
B7E79FDDC50\
3A27D1ED924\
CECFB099722\
A7286E432F7\
722054A7648\
4B6649403EA\
72D=1;O34C8\
2D72B2EC6D3\
E1C4A3CECD3\
9A23FE3BB49\
583331A51EC\
233413F53F2\
2958CBBF7C7\
89708AB60B9\
4DAC7609092\
9DB16E8F79D\
B639FDC3C61\
786E7AD154A\
FA06E490C02\
7B72783D1C5\
390725DD6EB\
1283330FEF6\
B75767684D4\
76A8C3D9A58\
E=32767;}*(\
OA7E617A3F7\
9B5DA8D1533\
C161FBDF0CD\
B6C15F51D66\
0C14F2FE8D3\
F8BC1064311\
534B996F9D8\
750D47A846B\
441EBF83C57\
D43E795BDE6\
761616FED95\
38A259986DE\
39F78ECE5DD\
3E8A3DAFFC6\
758DE80F07A\
CD684C19398\
AC4ADCBD15D\
920289++)=O\
35C3A4FBFD3\
C3B02E8F91E\
11855E8844B\
3E42D03AC3F\
9FED8AFC7C7\
5B37CE7B7DC\
7EBEFDC7B9E\
70CCCD47020\
3865C80B8D9\
54031558E94\
562EDF5F2CD\
9B3DA8D1FBA\
13755AD774A\
15866076D50\
31028D40F37\
ED4723BC14A\
79EB6A580D6\
584EE;}
#define O71\
E1D9317BA14\
8326A84186A\
CBB2EC03242\
994EF94A7EB\
F2A0F7D5BD0\
A84D11BCDD1\
183804A7A00\
FC972F35771\
6CD44FF4963\
614A813B0E9\
7633FC2DE8D\
A7D9D9C3263\
DFE0A3D258F\
A875C49E909\
FA033511E9E\
B4F61F3E6F3\
0243FBC70E7\
BE2  O9F17F\
86D76A6E6FE\
90FB7A06AA2\
EE2D0235DCF\
33DFB508F7F\
B97B13FA521\
3967FEF4E6F\
0216C6EA868\
F7D861C3A89\
CC58194A40E\
408CA904E83\
34779EA5FC2\
B3634C1CEDD\
49F7BA2A9C9\
6EAA5F12C24\
494802DCE85\
27304271DE3\
7F44154FBD1\
 O6680DBA00\
F3A88F66F80\
29A93D71D93\
CE2623C120B\
555383FA670\
D193F915521\
5B4ADBCF27E\
353F7F4E6B6\
F5E818352F5\
DF7F8DBBF16\
0E24AE939D5\
54EB3D14906\
1DE20FDC929\
14B92544240\
5947350CC38\
887B043896D\
EB73CBD3526\
773978D*O9A\
17B7249FFE0\
9DD5CA6B40A\
CCD559DD757\
8432355496F\
DDCDF3E1542\
6D723C28C9E\
DA427D5654A\
0E7086FD998\
772443ED5CD\
BD64687840C\
DD4FA3287BD\
AE2674BE91B\
1D4B7435E6D\
D0350CC20EF\
DBE8A82A131\
23F660FDBBF\
66E40E520C5\
4BE=OE726C2\
F50E07899DE\
24700DB8CDD\
35EC4C5B991\
9C346462BFF\
299DBFEE9D4\
79AC40FB07A\
DEB51148D4B\
3516F8E5B63\
3D1ACFF85C9\
9957281AEF4\
A04342702C4\
72228964477\
E290DE9C88B\
961F7BFE607\
694D772C7A7\
A7324C5D8A6\
5F894F5A96;\
O9F17F86D76\
A6E6FE90FB7\
A06AA2EE2D0\
235DCF33DFB\
508F7FB97B1\
3FA5213967F\
EF4E6F0216C\
6EA868F7D86\
1C3A89CC581\
94A40E408CA\
904E8334779\
EA5FC2B3634\
C1CEDD49F7B\
A2A9C96EAA5\
F12C2449480\
2DCE8527304\
271DE37F441\
54FBD1*O524\
77DCC9F26C2\
72FACE49FD7\
A76F138E142\
7147FF2845D\
798CECA0308\
88494843CDD\
C5F87782BAA\
830B5BE935A\
68E2CE0C3D8\
2A631659E8B\
7F73CBEB5B5\
D18FA035C55\
57C0873BF3A\
DD5A0B0B807\
17163349254\
DD947C1AFC2\
B4B2EBBBEF5\
50=OEDEC6D3\
C90903C7345\
407E9B37503\
2311AF398CA\
0749537E3F8\
B4795D26937\
0BC9C783B67\
5CF1173296F\
2D1485D0BB4\
03F58382CF9\
60B1312179E\
4BF92B2CEFB\
A379519C2F6\
6A13239D207\
A18F524E8C8\
DE72A4E8A01\
A42E909CF9A\
C81303502;O\
FA7153F7ED1\
CB6C0FCF2FF\
B2FAC217481\
F1C052E67EB\
816D571D13C\
2A5904A323F\
102B0E1E40B\
A54E9578FC3\
3CA23DB6628\
3C896B30C13\
A59BE53C16F\
FC0CEADBBC2\
F9BB00CE9C4\
5BC0BF9FA04\
957C08BD82B\
1657B6B838B\
895147E701D\
8B112 O37A4\
5076F711541\
7A54AD5B0B1\
88080D10943\
E9E6FB7CB93\
535F6755F66\
E4AEF658334\
E3D907377FA\
B5115EA3AA7\
DFB588A85E6\
92C130E776A\
99B61A13B8D\
1E486F8617E\
8AC9AF5BD7F\
68A53E0FA0B\
AB36587D6EC\
989B7BF5CA9\
1ECEB412290\
4;O13A3ACBB\
B0D74C3A916\
1089CACF4B1\
CC57A9CFB73\
764BFDCF82C\
82A48D4AEBB\
3052AD30248\
70A5A2F4A28\
5FBAE9848DE\
053344918D2\
09C7DD08D14\
EAD459A5750\
D50196F3668\
BDF22AAE729\
08446DE2A1F\
3598273B9C0\
7F5DC4950D9\
88E723B8 O1\
92D3B73E1B6\
8CD440DA8C9\
27D45CFBADB\
F52D6D72840\
41D43FA0B4C\
73C17AB7243\
8F9A04A4E8E\
D79EE7B0E07\
63FE0B25AE0\
6F40754EE20\
5B75746206C\
4093328634F\
BEA7AFEF05E\
585B128E22B\
FF58DAA48A4\
6C60B6F0D58\
59053A1794F\
F83C=O68A2C\
02F1DB19C2A\
38F39189626\
623DBF8D756\
AB798125C48\
66396BB2A37\
5ACB3803E4B\
18A9AC5A50F\
9BE96AEDE87\
5AAE458778E\
2AC24F90416\
421F6EDDC78\
81179DCAD51\
891614877F5\
DA08666632D\
C87B0699CC5\
E2AA39F1560\
5425A822207\
;MPY32CTL0 \
|=MPYFRAC;O\
37A45076F71\
15417A54AD5\
B0B188080D1\
0943E9E6FB7\
CB93535F675\
5F66E4AEF65\
8334E3D9073\
77FAB5115EA\
3AA7DFB588A\
85E692C130E\
776A99B61A1\
3B8D1E486F8\
617E8AC9AF5\
BD7F68A53E0\
FA0BAB36587\
D6EC989B7BF\
5CA91ECEB41\
22904=OD6B7\
F28AD82C629\
CEBDA096B0E\
AC802875F9D\
07CA1F8A75E\
019B2078FC3\
37283F2F5B9\
5BC4A664CAB\
DC016D4FA0A\
B43B6666800\
9DF9605A068\
34AD00CA63D\
020EDC5CC1D\
D7668D18E09\
D894835BEB6\
81D67B3F896\
5C9BA091142\
7C647BFB8A4\
E/2;O901889\
F4F34F8CA18\
AC2F53D1FED\
346E74CE529\
B80BCADD54E\
78A260B7CD1\
5E7C2E24EE1\
963722F989A\
8F52F91F93C\
2353BCF4658\
418B0518997\
9F5BCCC1B08\
23BBB7DEE35\
B15137CE93E\
3F725EF5D47\
86129E86638\
69EA9F938F8\
044168B427(\
O37A45076F7\
115417A54AD\
5B0B188080D\
10943E9E6FB\
7CB93535F67\
55F66E4AEF6\
58334E3D907\
377FAB5115E\
A3AA7DFB588\
A85E692C130\
E776A99B61A\
13B8D1E486F\
8617E8AC9AF\
5BD7F68A53E\
0FA0BAB3658\
7D6EC989B7B\
F5CA91ECEB4\
122904--){M\
yFFT_WINDOW\
_MUL(O9A17B\
7249FFE09DD\
5CA6B40ACCD\
559DD757843\
2355496FDDC\
DF3E15426D7\
23C28C9EDA4\
27D5654A0E7\
086FD998772\
443ED5CDBD6\
4687840CDD4\
FA3287BDAE2\
674BE91B1D4\
B7435E6DD03\
50CC20EFDBE\
8A82A13123F\
660FDBBF66E\
40E520C54BE\
++,O52477DC\
C9F26C272FA\
CE49FD7A76F\
138E1427147\
FF2845D798C\
ECA03088849\
4843CDDC5F8\
7782BAA830B\
5BE935A68E2\
CE0C3D82A63\
1659E8B7F73\
CBEB5B5D18F\
A035C5557C0\
873BF3ADD5A\
0B0B8071716\
3349254DD94\
7C1AFC2B4B2\
EBBBEF550);\
}O37A45076F\
7115417A54A\
D5B0B188080\
D10943E9E6F\
B7CB93535F6\
755F66E4AEF\
658334E3D90\
7377FAB5115\
EA3AA7DFB58\
8A85E692C13\
0E776A99B61\
A13B8D1E486\
F8617E8AC9A\
F5BD7F68A53\
E0FA0BAB365\
87D6EC989B7\
BF5CA91ECEB\
4122904=OD6\
B7F28AD82C6\
29CEBDA096B\
0EAC802875F\
9D07CA1F8A7\
5E019B2078F\
C337283F2F5\
B95BC4A664C\
ABDC016D4FA\
0AB43B66668\
009DF9605A0\
6834AD00CA6\
3D020EDC5CC\
1DD7668D18E\
09D894835BE\
B681D67B3F8\
965C9BA0911\
427C647BFB8\
A4E/2;O9018\
89F4F34F8CA\
18AC2F53D1F\
ED346E74CE5\
29B80BCADD5\
4E78A260B7C\
D15E7C2E24E\
E1963722F98\
9A8F52F91F9\
3C2353BCF46\
58418B05189\
979F5BCCC1B\
0823BBB7DEE\
35B15137CE9\
3E3F725EF5D\
4786129E866\
3869EA9F938\
F8044168B42\
7(O37A45076\
F7115417A54\
AD5B0B18808\
0D10943E9E6\
FB7CB93535F\
6755F66E4AE\
F658334E3D9\
07377FAB511\
5EA3AA7DFB5\
88A85E692C1\
30E776A99B6\
1A13B8D1E48\
6F8617E8AC9\
AF5BD7F68A5\
3E0FA0BAB36\
587D6EC989B\
7BF5CA91ECE\
B4122904--)\
{MyFFT_WIND\
OW_MUL(--O9\
A17B7249FFE\
09DD5CA6B40\
ACCD559DD75\
78432355496\
FDDCDF3E154\
26D723C28C9\
EDA427D5654\
A0E7086FD99\
8772443ED5C\
DBD64687840\
CDD4FA3287B\
DAE2674BE91\
B1D4B7435E6\
DD0350CC20E\
FDBE8A82A13\
123F660FDBB\
F66E40E520C\
54BE,O52477\
DCC9F26C272\
FACE49FD7A7\
6F138E14271\
47FF2845D79\
8CECA030888\
494843CDDC5\
F87782BAA83\
0B5BE935A68\
E2CE0C3D82A\
631659E8B7F\
73CBEB5B5D1\
8FA035C5557\
C0873BF3ADD\
5A0B0B80717\
163349254DD\
947C1AFC2B4\
B2EBBBEF550\
);}O68A2C02\
F1DB19C2A38\
F3918962662\
3DBF8D756AB\
798125C4866\
396BB2A375A\
CB3803E4B18\
A9AC5A50F9B\
E96AEDE875A\
AE458778E2A\
C24F9041642\
1F6EDDC7881\
179DCAD5189\
1614877F5DA\
08666632DC8\
7B0699CC5E2\
AA39F156054\
25A822207=O\
192D3B73E1B\
68CD440DA8C\
927D45CFBAD\
BF52D6D7284\
041D43FA0B4\
C73C17AB724\
38F9A04A4E8\
ED79EE7B0E0\
763FE0B25AE\
06F40754EE2\
05B75746206\
C4093328634\
FBEA7AFEF05\
E585B128E22\
BFF58DAA48A\
46C60B6F0D5\
859053A1794\
FF83C;
#define O8D\
C8AE4771F86\
43A06B777FA\
D145D1AE015\
20C9821BD76\
6F0ACB3BFF6\
B6BD8E5ED06\
489B329D5AC\
AC0E949F33D\
745E69E337F\
A2CA71E69BF\
64FCEBA1C0F\
34E2CD64F63\
147A0220F51\
4F1EB155429\
2944E01A217\
7EC1A9746DE\
C48CC11EAFB\
E50  O13A3A\
CBBB0D74C3A\
9161089CACF\
4B1CC57A9CF\
B73764BFDCF\
82C82A48D4A\
EBB3052AD30\
24870A5A2F4\
A285FBAE984\
8DE05334491\
8D209C7DD08\
D14EAD459A5\
750D50196F3\
668BDF22AAE\
72908446DE2\
A1F3598273B\
9C07F5DC495\
0D988E723B8\
 OCD16519FF\
38F5E49AB28\
FE57CC3C8F4\
8DD71ADE44A\
185BBD46256\
834A887C2D6\
FEA00404CA2\
3576065E687\
37F967BA5E8\
B558AD6F161\
D8CDEEBF4A2\
4942B8FAA68\
ED0BE7002AA\
AA034FCC759\
38A557572B4\
B0EE14DDAE3\
B2000971A92\
054135A,O3A\
344C92A852B\
8277F76D9F9\
69459784937\
10A4CE69CB5\
F29582050D9\
97284B47350\
A69277B4F22\
ADF974D141E\
F72FEAB5EDC\
D425BF3EEBA\
28B58CF033A\
660E2B333CB\
45715CDBE03\
1E8BDD4CC39\
F2FDB398F81\
A24B86C33BB\
E9D119CDF48\
DF9=0,OCA87\
6C6A76C08D2\
1639006F9C2\
BF4FBB565D1\
15AF6674BDF\
C7EC6E33B7D\
26AEEA547AC\
701D847BF65\
CC83BF3A0A8\
0BF6CFC8C5E\
CB934828BA2\
C8CE1624A92\
ECC12D2DF25\
C8620E4B322\
F7E6F164F1C\
33A42F1F385\
D540EAF0610\
F6DC58A4CBB\
1;O13A3ACBB\
B0D74C3A916\
1089CACF4B1\
CC57A9CFB73\
764BFDCF82C\
82A48D4AEBB\
3052AD30248\
70A5A2F4A28\
5FBAE9848DE\
053344918D2\
09C7DD08D14\
EAD459A5750\
D50196F3668\
BDF22AAE729\
08446DE2A1F\
3598273B9C0\
7F5DC4950D9\
88E723B8 O0\
EB79A4DD100\
1EA67FE7A74\
B4B6158E705\
66A62D52493\
F5CD7DA622D\
63D93424B54\
50402ECCF32\
4AC4F03C410\
1C6FBA88879\
C3D89A01339\
EB74A4CFD6B\
23BEF8F3FF6\
7B14095931B\
391FE41A912\
7F682A3F759\
824E29334AD\
C8455955CBF\
F8E7=O06CD5\
E3A8084FDB7\
BFC2C1650C7\
B733DDF5080\
FC058B6D700\
DF0A4BB9CB3\
0E163F76FE1\
C6769F9F4ED\
61233ADF4BD\
D7F5BECB377\
3D9C5E3FB91\
E4C6573C989\
0264DFDF7F7\
349773CA3CC\
6B19964B727\
907AB3887F7\
A9DABF92077\
CDB7C7A0874\
,O01B61938B\
1242E257268\
9CFC5DF4875\
FED38D17490\
ED9722A5600\
5DF9CFEF9F9\
DF4F25B41E2\
DB1FD281853\
0EC8793EF85\
5DFCC4E761D\
25B72835835\
5664D8BFF0D\
CD52990047F\
EFAA08FE118\
D789B015198\
641B7A70B6F\
B546393DED3\
4C9946B=1,O\
7ED4E796A70\
5B72C535381\
44EAB6E6A7D\
EB22A047AFA\
190EA471AF8\
9E69409A298\
9881812576B\
82CEF3FE429\
FAF4FA750AD\
FE02E255F6D\
DE2ACEBD381\
456CE4D5CD0\
1E20DC6AE6F\
F1DBD9355C3\
23D36A6EE4A\
48C6547ECCA\
96A4E938928\
5AE86=OD6B7\
F28AD82C629\
CEBDA096B0E\
AC802875F9D\
07CA1F8A75E\
019B2078FC3\
37283F2F5B9\
5BC4A664CAB\
DC016D4FA0A\
B43B6666800\
9DF9605A068\
34AD00CA63D\
020EDC5CC1D\
D7668D18E09\
D894835BEB6\
81D67B3F896\
5C9BA091142\
7C647BFB8A4\
E/2;O9F17F8\
6D76A6E6FE9\
0FB7A06AA2E\
E2D0235DCF3\
3DFB508F7FB\
97B13FA5213\
967FEF4E6F0\
216C6EA868F\
7D861C3A89C\
C58194A40E4\
08CA904E833\
4779EA5FC2B\
3634C1CEDD4\
9F7BA2A9C96\
EAA5F12C244\
94802DCE852\
7304271DE37\
F44154FBD1 \
OC97D1DCFC4\
79E26E190FC\
6D6D13ECE63\
314E85C4506\
C81F8689F0F\
6C3C2398ED5\
3B2FB47656A\
5C6A2FA2792\
058EC47FA0A\
102C5657329\
E34AD5F72C5\
4B094B276FC\
68303A603F1\
D35EB4C8F6B\
D873D66AE39\
07E673315D1\
AAFE59947C0\
FBCF6B,OF20\
93A56679D28\
A5884649FA5\
0631D46639C\
DA5D15F6883\
F66D0A5C21F\
8B17C5EEE8A\
AAD5316F1C3\
7D742B7D0BC\
6DBEA679196\
9C4000AB8CC\
82931DD772A\
1098B19FBA2\
28DDBF130A4\
316AF460208\
67B4813EF64\
DC8CF3B4A55\
49CD6F9A23B\
96,O9B0809D\
02A5BA28A88\
EBDCE6915E1\
1F719BFF97A\
307E4EF54B2\
B0C7DEA4DA0\
315AD5CD2AC\
2A230D3AD70\
2C9A9ACD291\
42551731941\
12CEA25C09C\
DB834A64716\
FB3E6DC206C\
0A5CDBA13A4\
BAC6237FF87\
050A33974B3\
5C2F0031FC6\
445E9BAC0,O\
60EE115DAF8\
68CE866D044\
9FF86511B25\
4CD5D38B304\
EEB5E04D48F\
B9E16EC9EE5\
07E329BCA7C\
6A4D2CAE026\
FA8C1E42B0F\
20B69342289\
1B155A04857\
90FFF4888F7\
9D956F212AA\
2133EC7D259\
B298AA4FA99\
C36F642FAE4\
91FF69761DB\
31433;O9018\
89F4F34F8CA\
18AC2F53D1F\
ED346E74CE5\
29B80BCADD5\
4E78A260B7C\
D15E7C2E24E\
E1963722F98\
9A8F52F91F9\
3C2353BCF46\
58418B05189\
979F5BCCC1B\
0823BBB7DEE\
35B15137CE9\
3E3F725EF5D\
4786129E866\
3869EA9F938\
F8044168B42\
7(O0EB79A4D\
D1001EA67FE\
7A74B4B6158\
E70566A62D5\
2493F5CD7DA\
622D63D9342\
4B5450402EC\
CF324AC4F03\
C4101C6FBA8\
8879C3D89A0\
1339EB74A4C\
FD6B23BEF8F\
3FF67B14095\
931B391FE41\
A9127F682A3\
F759824E293\
34ADC845595\
5CBFF8E7--)\
{O2C8BD0EF1\
C44328CB3D4\
AF6546716D0\
479A7117BBF\
512EA125F91\
FA9BA3A0DB8\
69D947BB450\
A5272C37B07\
FB261151274\
A3A5D5605A1\
ACAA68EF685\
6237E684C71\
FA724AE2FD1\
A58B5AA418C\
E8501E05D7C\
710F39428A8\
2177623D20B\
4C24C22(O3A\
344C92A852B\
8277F76D9F9\
69459784937\
10A4CE69CB5\
F29582050D9\
97284B47350\
A69277B4F22\
ADF974D141E\
F72FEAB5EDC\
D425BF3EEBA\
28B58CF033A\
660E2B333CB\
45715CDBE03\
1E8BDD4CC39\
F2FDB398F81\
A24B86C33BB\
E9D119CDF48\
DF9,OCA876C\
6A76C08D216\
39006F9C2BF\
4FBB565D115\
AF6674BDFC7\
EC6E33B7D26\
AEEA547AC70\
1D847BF65CC\
83BF3A0A80B\
F6CFC8C5ECB\
934828BA2C8\
CE1624A92EC\
C12D2DF25C8\
620E4B322F7\
E6F164F1C33\
A42F1F385D5\
40EAF0610F6\
DC58A4CBB1)\
;O901889F4F\
34F8CA18AC2\
F53D1FED346\
E74CE529B80\
BCADD54E78A\
260B7CD15E7\
C2E24EE1963\
722F989A8F5\
2F91F93C235\
3BCF4658418\
B05189979F5\
BCCC1B0823B\
BB7DEE35B15\
137CE93E3F7\
25EF5D47861\
29E8663869E\
A9F938F8044\
168B427(O3A\
344C92A852B\
8277F76D9F9\
69459784937\
10A4CE69CB5\
F29582050D9\
97284B47350\
A69277B4F22\
ADF974D141E\
F72FEAB5EDC\
D425BF3EEBA\
28B58CF033A\
660E2B333CB\
45715CDBE03\
1E8BDD4CC39\
F2FDB398F81\
A24B86C33BB\
E9D119CDF48\
DF9--){O08F\
C8F6ED9A9F7\
C3808A5AD7C\
573E7E6E640\
5BB9A6277D7\
B8EF4003CD7\
E308FFBB66A\
620BD55E1D0\
0039A8801B6\
B6BF8665B19\
38695904534\
B4ECC718F11\
662941A2C5F\
666F34532AA\
E0D93DB8777\
FA8CA2FE530\
406B3FB0B4C\
1E2D014EB88\
5A(OCD16519\
FF38F5E49AB\
28FE57CC3C8\
F48DD71ADE4\
4A185BBD462\
56834A887C2\
D6FEA00404C\
A23576065E6\
8737F967BA5\
E8B558AD6F1\
61D8CDEEBF4\
A24942B8FAA\
68ED0BE7002\
AAAA034FCC7\
5938A557572\
B4B0EE14DDA\
E3B2000971A\
92054135A,O\
3A344C92A85\
2B8277F76D9\
F9694597849\
3710A4CE69C\
B5F29582050\
D997284B473\
50A69277B4F\
22ADF974D14\
1EF72FEAB5E\
DCD425BF3EE\
BA28B58CF03\
3A660E2B333\
CB45715CDBE\
031E8BDD4CC\
39F2FDB398F\
81A24B86C33\
BBE9D119CDF\
48DF9,OCA87\
6C6A76C08D2\
1639006F9C2\
BF4FBB565D1\
15AF6674BDF\
C7EC6E33B7D\
26AEEA547AC\
701D847BF65\
CC83BF3A0A8\
0BF6CFC8C5E\
CB934828BA2\
C8CE1624A92\
ECC12D2DF25\
C8620E4B322\
F7E6F164F1C\
33A42F1F385\
D540EAF0610\
F6DC58A4CBB\
1,O7ED4E796\
A705B72C535\
38144EAB6E6\
A7DEB22A047\
AFA190EA471\
AF89E69409A\
29898818125\
76B82CEF3FE\
429FAF4FA75\
0ADFE02E255\
F6DDE2ACEBD\
381456CE4D5\
CD01E20DC6A\
E6FF1DBD935\
5C323D36A6E\
E4A48C6547E\
CCA96A4E938\
9285AE86,O0\
1B61938B124\
2E2572689CF\
C5DF4875FED\
38D17490ED9\
722A56005DF\
9CFEF9F9DF4\
F25B41E2DB1\
FD2818530EC\
8793EF855DF\
CC4E761D25B\
72835835566\
4D8BFF0DCD5\
2990047FEFA\
A08FE118D78\
9B015198641\
B7A70B6FB54\
6393DED34C9\
946B);O1C9B\
A8B14077151\
6B468058D71\
D75D9CE7785\
5709BC727B3\
0EE4887F053\
B0E2123B276\
AB401AE5717\
19DCEAD0194\
BBD60BBD5F0\
B699716D5FB\
4E1594AB084\
92D22ED3C93\
0B7C2FF5E6D\
CE6FAE2830A\
32269FB1616\
3020733F830\
955DBF1F449\
1(OC97D1DCF\
C479E26E190\
FC6D6D13ECE\
63314E85C45\
06C81F8689F\
0F6C3C2398E\
D53B2FB4765\
6A5C6A2FA27\
92058EC47FA\
0A102C56573\
29E34AD5F72\
C54B094B276\
FC68303A603\
F1D35EB4C8F\
6BD873D66AE\
3907E673315\
D1AAFE59947\
C0FBCF6B,OE\
DEC6D3C9090\
3C7345407E9\
B375032311A\
F398CA07495\
37E3F8B4795\
D269370BC9C\
783B675CF11\
73296F2D148\
5D0BB403F58\
382CF960B13\
12179E4BF92\
B2CEFBA3795\
19C2F66A132\
39D207A18F5\
24E8C8DE72A\
4E8A01A42E9\
09CF9AC8130\
3502[OCD165\
19FF38F5E49\
AB28FE57CC3\
C8F48DD71AD\
E44A185BBD4\
6256834A887\
C2D6FEA0040\
4CA23576065\
E68737F967B\
A5E8B558AD6\
F161D8CDEEB\
F4A24942B8F\
AA68ED0BE70\
02AAAA034FC\
C75938A5575\
72B4B0EE14D\
DAE3B200097\
1A92054135A\
]);O1C9BA8B\
140771516B4\
68058D71D75\
D9CE7785570\
9BC727B30EE\
4887F053B0E\
2123B276AB4\
01AE571719D\
CEAD0194BBD\
60BBD5F0B69\
9716D5FB4E1\
594AB08492D\
22ED3C930B7\
C2FF5E6DCE6\
FAE2830A322\
69FB1616302\
0733F830955\
DBF1F4491(O\
F2093A56679\
D28A5884649\
FA50631D466\
39CDA5D15F6\
883F66D0A5C\
21F8B17C5EE\
E8AAAD5316F\
1C37D742B7D\
0BC6DBEA679\
1969C4000AB\
8CC82931DD7\
72A1098B19F\
BA228DDBF13\
0A4316AF460\
20867B4813E\
F64DC8CF3B4\
A5549CD6F9A\
23B96,O150A\
FDE42400DA1\
BDF4F7B5F6F\
27E1941FCEE\
E0174CCBF34\
CAC5DB17F66\
59308DCF705\
FD783160EB3\
F50FA1AA2B9\
C7CFB5E386A\
96FF59487B3\
E6C7FB629F0\
AC0C6EAD31F\
AFFD742D72E\
AB1F5721F48\
A371FF6C247\
C5D837EB05B\
DC969A9C9DD\
E[OCD16519F\
F38F5E49AB2\
8FE57CC3C8F\
48DD71ADE44\
A185BBD4625\
6834A887C2D\
6FEA00404CA\
23576065E68\
737F967BA5E\
8B558AD6F16\
1D8CDEEBF4A\
24942B8FAA6\
8ED0BE7002A\
AAA034FCC75\
938A557572B\
4B0EE14DDAE\
3B2000971A9\
2054135A]);\
O9B0809D02A\
5BA28A88EBD\
CE6915E11F7\
19BFF97A307\
E4EF54B2B0C\
7DEA4DA0315\
AD5CD2AC2A2\
30D3AD702C9\
A9ACD291425\
5173194112C\
EA25C09CDB8\
34A64716FB3\
E6DC206C0A5\
CDBA13A4BAC\
6237FF87050\
A33974B35C2\
F0031FC6445\
E9BAC0=OEDE\
C6D3C90903C\
7345407E9B3\
75032311AF3\
98CA0749537\
E3F8B4795D2\
69370BC9C78\
3B675CF1173\
296F2D1485D\
0BB403F5838\
2CF960B1312\
179E4BF92B2\
CEFBA379519\
C2F66A13239\
D207A18F524\
E8C8DE72A4E\
8A01A42E909\
CF9AC813035\
02[O3A344C9\
2A852B8277F\
76D9F969459\
78493710A4C\
E69CB5F2958\
2050D997284\
B47350A6927\
7B4F22ADF97\
4D141EF72FE\
AB5EDCD425B\
F3EEBA28B58\
CF033A660E2\
B333CB45715\
CDBE031E8BD\
D4CC39F2FDB\
398F81A24B8\
6C33BBE9D11\
9CDF48DF9];\
O60EE115DAF\
868CE866D04\
49FF86511B2\
54CD5D38B30\
4EEB5E04D48\
FB9E16EC9EE\
507E329BCA7\
C6A4D2CAE02\
6FA8C1E42B0\
F20B6934228\
91B155A0485\
790FFF4888F\
79D956F212A\
A2133EC7D25\
9B298AA4FA9\
9C36F642FAE\
491FF69761D\
B31433=O150\
AFDE42400DA\
1BDF4F7B5F6\
F27E1941FCE\
EE0174CCBF3\
4CAC5DB17F6\
659308DCF70\
5FD783160EB\
3F50FA1AA2B\
9C7CFB5E386\
A96FF59487B\
3E6C7FB629F\
0AC0C6EAD31\
FAFFD742D72\
EAB1F5721F4\
8A371FF6C24\
7C5D837EB05\
BDC969A9C9D\
DE[O3A344C9\
2A852B8277F\
76D9F969459\
78493710A4C\
E69CB5F2958\
2050D997284\
B47350A6927\
7B4F22ADF97\
4D141EF72FE\
AB5EDCD425B\
F3EEBA28B58\
CF033A660E2\
B333CB45715\
CDBE031E8BD\
D4CC39F2FDB\
398F81A24B8\
6C33BBE9D11\
9CDF48DF9];\
OB96C2DA702\
FB5F7A7880A\
44ED9E2B970\
02A38781200\
CE39AA97D90\
095B68B6E33\
86BBC10CE52\
FE34F09AD5C\
C59E3EEA1F4\
796D1336747\
0BD0DBC1E30\
F1C4C1A82BF\
CF62F871DCA\
5366FF9C2BD\
E46051E095F\
E63AC9DBE94\
E126E4366EE\
90642D(O2AE\
64F0D153701\
6DD813A04AA\
98B6D34B196\
D5B8F891424\
F3EFEF8ADE5\
CF1B0E57468\
31D37FD1D38\
742FA42939C\
750E9AF359F\
97A7A979587\
4889F30C720\
8099914C20E\
044AFCA7590\
1B164033DD3\
6D2DD2C5E6D\
6F665D09406\
FFF5F7B3952\
A9[OCA876C6\
A76C08D2163\
9006F9C2BF4\
FBB565D115A\
F6674BDFC7E\
C6E33B7D26A\
EEA547AC701\
D847BF65CC8\
3BF3A0A80BF\
6CFC8C5ECB9\
34828BA2C8C\
E1624A92ECC\
12D2DF25C86\
20E4B322F7E\
6F164F1C33A\
42F1F385D54\
0EAF0610F6D\
C58A4CBB1],\
O9B0809D02A\
5BA28A88EBD\
CE6915E11F7\
19BFF97A307\
E4EF54B2B0C\
7DEA4DA0315\
AD5CD2AC2A2\
30D3AD702C9\
A9ACD291425\
5173194112C\
EA25C09CDB8\
34A64716FB3\
E6DC206C0A5\
CDBA13A4BAC\
6237FF87050\
A33974B35C2\
F0031FC6445\
E9BAC0,OC5C\
0DAFA3C4FF6\
865CDE41F56\
1D6F6F5295D\
F224A51CD05\
B5CED2843EE\
2777B9A3326\
04DB6BB520E\
ECEF310CDCC\
1AFCF49122B\
C216515BE4E\
ABA486C37B0\
37C668B5482\
902ABE82EE0\
3A59DDCCC2D\
C85BE9C21AB\
30FDE368BDC\
C5CF417DEF6\
08[OCA876C6\
A76C08D2163\
9006F9C2BF4\
FBB565D115A\
F6674BDFC7E\
C6E33B7D26A\
EEA547AC701\
D847BF65CC8\
3BF3A0A80BF\
6CFC8C5ECB9\
34828BA2C8C\
E1624A92ECC\
12D2DF25C86\
20E4B322F7E\
6F164F1C33A\
42F1F385D54\
0EAF0610F6D\
C58A4CBB1],\
O60EE115DAF\
868CE866D04\
49FF86511B2\
54CD5D38B30\
4EEB5E04D48\
FB9E16EC9EE\
507E329BCA7\
C6A4D2CAE02\
6FA8C1E42B0\
F20B6934228\
91B155A0485\
790FFF4888F\
79D956F212A\
A2133EC7D25\
9B298AA4FA9\
9C36F642FAE\
491FF69761D\
B31433,OC97\
D1DCFC479E2\
6E190FC6D6D\
13ECE63314E\
85C4506C81F\
8689F0F6C3C\
2398ED53B2F\
B47656A5C6A\
2FA2792058E\
C47FA0A102C\
5657329E34A\
D5F72C54B09\
4B276FC6830\
3A603F1D35E\
B4C8F6BD873\
D66AE3907E6\
73315D1AAFE\
59947C0FBCF\
6B,OEDEC6D3\
C90903C7345\
407E9B37503\
2311AF398CA\
0749537E3F8\
B4795D26937\
0BC9C783B67\
5CF1173296F\
2D1485D0BB4\
03F58382CF9\
60B1312179E\
4BF92B2CEFB\
A379519C2F6\
6A13239D207\
A18F524E8C8\
DE72A4E8A01\
A42E909CF9A\
C81303502[O\
3A344C92A85\
2B8277F76D9\
F9694597849\
3710A4CE69C\
B5F29582050\
D997284B473\
50A69277B4F\
22ADF974D14\
1EF72FEAB5E\
DCD425BF3EE\
BA28B58CF03\
3A660E2B333\
CB45715CDBE\
031E8BDD4CC\
39F2FDB398F\
81A24B86C33\
BBE9D119CDF\
48DF9],OEDE\
C6D3C90903C\
7345407E9B3\
75032311AF3\
98CA0749537\
E3F8B4795D2\
69370BC9C78\
3B675CF1173\
296F2D1485D\
0BB403F5838\
2CF960B1312\
179E4BF92B2\
CEFBA379519\
C2F66A13239\
D207A18F524\
E8C8DE72A4E\
8A01A42E909\
CF9AC813035\
02[OCD16519\
FF38F5E49AB\
28FE57CC3C8\
F48DD71ADE4\
4A185BBD462\
56834A887C2\
D6FEA00404C\
A23576065E6\
8737F967BA5\
E8B558AD6F1\
61D8CDEEBF4\
A24942B8FAA\
68ED0BE7002\
AAAA034FCC7\
5938A557572\
B4B0EE14DDA\
E3B2000971A\
92054135A])\
;OB96C2DA70\
2FB5F7A7880\
A44ED9E2B97\
002A3878120\
0CE39AA97D9\
0095B68B6E3\
386BBC10CE5\
2FE34F09AD5\
CC59E3EEA1F\
4796D133674\
70BD0DBC1E3\
0F1C4C1A82B\
FCF62F871DC\
A5366FF9C2B\
DE46051E095\
FE63AC9DBE9\
4E126E4366E\
E90642D(O2A\
E64F0D15370\
16DD813A04A\
A98B6D34B19\
6D5B8F89142\
4F3EFEF8ADE\
5CF1B0E5746\
831D37FD1D3\
8742FA42939\
C750E9AF359\
F97A7A97958\
74889F30C72\
08099914C20\
E044AFCA759\
01B164033DD\
36D2DD2C5E6\
D6F665D0940\
6FFF5F7B395\
2A9[OCA876C\
6A76C08D216\
39006F9C2BF\
4FBB565D115\
AF6674BDFC7\
EC6E33B7D26\
AEEA547AC70\
1D847BF65CC\
83BF3A0A80B\
F6CFC8C5ECB\
934828BA2C8\
CE1624A92EC\
C12D2DF25C8\
620E4B322F7\
E6F164F1C33\
A42F1F385D5\
40EAF0610F6\
DC58A4CBB1]\
,O60EE115DA\
F868CE866D0\
449FF86511B\
254CD5D38B3\
04EEB5E04D4\
8FB9E16EC9E\
E507E329BCA\
7C6A4D2CAE0\
26FA8C1E42B\
0F20B693422\
891B155A048\
5790FFF4888\
F79D956F212\
AA2133EC7D2\
59B298AA4FA\
99C36F642FA\
E491FF69761\
DB31433,-OC\
5C0DAFA3C4F\
F6865CDE41F\
561D6F6F529\
5DF224A51CD\
05B5CED2843\
EE2777B9A33\
2604DB6BB52\
0EECEF310CD\
CC1AFCF4912\
2BC216515BE\
4EABA486C37\
B037C668B54\
82902ABE82E\
E03A59DDCCC\
2DC85BE9C21\
AB30FDE368B\
DCC5CF417DE\
F608[OCA876\
C6A76C08D21\
639006F9C2B\
F4FBB565D11\
5AF6674BDFC\
7EC6E33B7D2\
6AEEA547AC7\
01D847BF65C\
C83BF3A0A80\
BF6CFC8C5EC\
B934828BA2C\
8CE1624A92E\
CC12D2DF25C\
8620E4B322F\
7E6F164F1C3\
3A42F1F385D\
540EAF0610F\
6DC58A4CBB1\
],O9B0809D0\
2A5BA28A88E\
BDCE6915E11\
F719BFF97A3\
07E4EF54B2B\
0C7DEA4DA03\
15AD5CD2AC2\
A230D3AD702\
C9A9ACD2914\
25517319411\
2CEA25C09CD\
B834A64716F\
B3E6DC206C0\
A5CDBA13A4B\
AC6237FF870\
50A33974B35\
C2F0031FC64\
45E9BAC0,OF\
2093A56679D\
28A5884649F\
A50631D4663\
9CDA5D15F68\
83F66D0A5C2\
1F8B17C5EEE\
8AAAD5316F1\
C37D742B7D0\
BC6DBEA6791\
969C4000AB8\
CC82931DD77\
2A1098B19FB\
A228DDBF130\
A4316AF4602\
0867B4813EF\
64DC8CF3B4A\
5549CD6F9A2\
3B96,O150AF\
DE42400DA1B\
DF4F7B5F6F2\
7E1941FCEEE\
0174CCBF34C\
AC5DB17F665\
9308DCF705F\
D783160EB3F\
50FA1AA2B9C\
7CFB5E386A9\
6FF59487B3E\
6C7FB629F0A\
C0C6EAD31FA\
FFD742D72EA\
B1F5721F48A\
371FF6C247C\
5D837EB05BD\
C969A9C9DDE\
[O3A344C92A\
852B8277F76\
D9F96945978\
493710A4CE6\
9CB5F295820\
50D997284B4\
7350A69277B\
4F22ADF974D\
141EF72FEAB\
5EDCD425BF3\
EEBA28B58CF\
033A660E2B3\
33CB45715CD\
BE031E8BDD4\
CC39F2FDB39\
8F81A24B86C\
33BBE9D119C\
DF48DF9],O1\
50AFDE42400\
DA1BDF4F7B5\
F6F27E1941F\
CEEE0174CCB\
F34CAC5DB17\
F6659308DCF\
705FD783160\
EB3F50FA1AA\
2B9C7CFB5E3\
86A96FF5948\
7B3E6C7FB62\
9F0AC0C6EAD\
31FAFFD742D\
72EAB1F5721\
F48A371FF6C\
247C5D837EB\
05BDC969A9C\
9DDE[OCD165\
19FF38F5E49\
AB28FE57CC3\
C8F48DD71AD\
E44A185BBD4\
6256834A887\
C2D6FEA0040\
4CA23576065\
E68737F967B\
A5E8B558AD6\
F161D8CDEEB\
F4A24942B8F\
AA68ED0BE70\
02AAAA034FC\
C75938A5575\
72B4B0EE14D\
DAE3B200097\
1A92054135A\
]);OFD18E9A\
1B9FD1C722C\
5DAF40BCD32\
1EC8F7CA79E\
35992F32CA2\
838217B4325\
ACB6CD1C121\
152DD6D0A84\
B18A06C4183\
340D2670E30\
561FD634ED8\
CEFED8B5BD5\
5F99B5365B6\
186D49417A0\
04412BA36CA\
972721B526E\
8802C111CAE\
E46FD949F(O\
3A344C92A85\
2B8277F76D9\
F9694597849\
3710A4CE69C\
B5F29582050\
D997284B473\
50A69277B4F\
22ADF974D14\
1EF72FEAB5E\
DCD425BF3EE\
BA28B58CF03\
3A660E2B333\
CB45715CDBE\
031E8BDD4CC\
39F2FDB398F\
81A24B86C33\
BBE9D119CDF\
48DF9,OCA87\
6C6A76C08D2\
1639006F9C2\
BF4FBB565D1\
15AF6674BDF\
C7EC6E33B7D\
26AEEA547AC\
701D847BF65\
CC83BF3A0A8\
0BF6CFC8C5E\
CB934828BA2\
C8CE1624A92\
ECC12D2DF25\
C8620E4B322\
F7E6F164F1C\
33A42F1F385\
D540EAF0610\
F6DC58A4CBB\
1,O01B61938\
B1242E25726\
89CFC5DF487\
5FED38D1749\
0ED9722A560\
05DF9CFEF9F\
9DF4F25B41E\
2DB1FD28185\
30EC8793EF8\
55DFCC4E761\
D25B7283583\
55664D8BFF0\
DCD52990047\
FEFAA08FE11\
8D789B01519\
8641B7A70B6\
FB546393DED\
34C9946B);}\
OB3E490EAFA\
302E925F96E\
5FD45D6041E\
65A19996213\
64EEBC0DB1E\
0FDD2BC5041\
7D15DAE1139\
B6139F4EB8D\
287CFDBDEAA\
5E2C99E75BD\
9EC4EAB0DA3\
9513EAA5143\
2F9E826827E\
1BD1A266F40\
41B716BD5C0\
C3FE3D34430\
DC65689FD04\
F3973A(O7ED\
4E796A705B7\
2C53538144E\
AB6E6A7DEB2\
2A047AFA190\
EA471AF89E6\
9409A298988\
1812576B82C\
EF3FE429FAF\
4FA750ADFE0\
2E255F6DDE2\
ACEBD381456\
CE4D5CD01E2\
0DC6AE6FF1D\
BD9355C323D\
36A6EE4A48C\
6547ECCA96A\
4E9389285AE\
86,O01B6193\
8B1242E2572\
689CFC5DF48\
75FED38D174\
90ED9722A56\
005DF9CFEF9\
F9DF4F25B41\
E2DB1FD2818\
530EC8793EF\
855DFCC4E76\
1D25B728358\
355664D8BFF\
0DCD5299004\
7FEFAA08FE1\
18D789B0151\
98641B7A70B\
6FB546393DE\
D34C9946B);\
}
#define OCA\
21413D7250B\
460649EBDEF\
005A469AEC2\
C5F7345ADFD\
80BC3DD6AC3\
9E91023732A\
816B95882DE\
ED3030BFC26\
187E31E394D\
93CC5BA2452\
F1316632BA4\
5CED20AD2C6\
E75D77521C3\
03E22022805\
7ECDDDBA83A\
A37ACAFED61\
45F9D153D38\
70C
#define O08\
FC8F6ED9A9F\
7C3808A5AD7\
C573E7E6E64\
05BB9A6277D\
7B8EF4003CD\
7E308FFBB66\
A620BD55E1D\
00039A8801B\
6B6BF8665B1\
93869590453\
4B4ECC718F1\
1662941A2C5\
F666F34532A\
AE0D93DB877\
7FA8CA2FE53\
0406B3FB0B4\
C1E2D014EB8\
85A(OCD1651\
9FF38F5E49A\
B28FE57CC3C\
8F48DD71ADE\
44A185BBD46\
256834A887C\
2D6FEA00404\
CA23576065E\
68737F967BA\
5E8B558AD6F\
161D8CDEEBF\
4A24942B8FA\
A68ED0BE700\
2AAAA034FCC\
75938A55757\
2B4B0EE14DD\
AE3B2000971\
A92054135A,\
O3A344C92A8\
52B8277F76D\
9F969459784\
93710A4CE69\
CB5F2958205\
0D997284B47\
350A69277B4\
F22ADF974D1\
41EF72FEAB5\
EDCD425BF3E\
EBA28B58CF0\
33A660E2B33\
3CB45715CDB\
E031E8BDD4C\
C39F2FDB398\
F81A24B86C3\
3BBE9D119CD\
F48DF9,OCA8\
76C6A76C08D\
21639006F9C\
2BF4FBB565D\
115AF6674BD\
FC7EC6E33B7\
D26AEEA547A\
C701D847BF6\
5CC83BF3A0A\
80BF6CFC8C5\
ECB934828BA\
2C8CE1624A9\
2ECC12D2DF2\
5C8620E4B32\
2F7E6F164F1\
C33A42F1F38\
5D540EAF061\
0F6DC58A4CB\
B1,O7ED4E79\
6A705B72C53\
538144EAB6E\
6A7DEB22A04\
7AFA190EA47\
1AF89E69409\
A2989881812\
576B82CEF3F\
E429FAF4FA7\
50ADFE02E25\
5F6DDE2ACEB\
D381456CE4D\
5CD01E20DC6\
AE6FF1DBD93\
55C323D36A6\
EE4A48C6547\
ECCA96A4E93\
89285AE86,O\
01B61938B12\
42E2572689C\
FC5DF4875FE\
D38D17490ED\
9722A56005D\
F9CFEF9F9DF\
4F25B41E2DB\
1FD2818530E\
C8793EF855D\
FCC4E761D25\
B7283583556\
64D8BFF0DCD\
52990047FEF\
AA08FE118D7\
89B01519864\
1B7A70B6FB5\
46393DED34C\
9946B){OCA8\
76C6A76C08D\
21639006F9C\
2BF4FBB565D\
115AF6674BD\
FC7EC6E33B7\
D26AEEA547A\
C701D847BF6\
5CC83BF3A0A\
80BF6CFC8C5\
ECB934828BA\
2C8CE1624A9\
2ECC12D2DF2\
5C8620E4B32\
2F7E6F164F1\
C33A42F1F38\
5D540EAF061\
0F6DC58A4CB\
B1-=O7ED4E7\
96A705B72C5\
3538144EAB6\
E6A7DEB22A0\
47AFA190EA4\
71AF89E6940\
9A298988181\
2576B82CEF3\
FE429FAF4FA\
750ADFE02E2\
55F6DDE2ACE\
BD381456CE4\
D5CD01E20DC\
6AE6FF1DBD9\
355C323D36A\
6EE4A48C654\
7ECCA96A4E9\
389285AE86;\
OCD16519FF3\
8F5E49AB28F\
E57CC3C8F48\
DD71ADE44A1\
85BBD462568\
34A887C2D6F\
EA00404CA23\
576065E6873\
7F967BA5E8B\
558AD6F161D\
8CDEEBF4A24\
942B8FAA68E\
D0BE7002AAA\
A034FCC7593\
8A557572B4B\
0EE14DDAE3B\
2000971A920\
54135A=O3A3\
44C92A852B8\
277F76D9F96\
94597849371\
0A4CE69CB5F\
29582050D99\
7284B47350A\
69277B4F22A\
DF974D141EF\
72FEAB5EDCD\
425BF3EEBA2\
8B58CF033A6\
60E2B333CB4\
5715CDBE031\
E8BDD4CC39F\
2FDB398F81A\
24B86C33BBE\
9D119CDF48D\
F9-O01B6193\
8B1242E2572\
689CFC5DF48\
75FED38D174\
90ED9722A56\
005DF9CFEF9\
F9DF4F25B41\
E2DB1FD2818\
530EC8793EF\
855DFCC4E76\
1D25B728358\
355664D8BFF\
0DCD5299004\
7FEFAA08FE1\
18D789B0151\
98641B7A70B\
6FB546393DE\
D34C9946B;}
#define OFD\
18E9A1B9FD1\
C722C5DAF40\
BCD321EC8F7\
CA79E35992F\
32CA2838217\
B4325ACB6CD\
1C121152DD6\
D0A84B18A06\
C4183340D26\
70E30561FD6\
34ED8CEFED8\
B5BD55F99B5\
365B6186D49\
417A004412B\
A36CA972721\
B526E8802C1\
11CAEE46FD9\
49F(O3A344C\
92A852B8277\
F76D9F96945\
978493710A4\
CE69CB5F295\
82050D99728\
4B47350A692\
77B4F22ADF9\
74D141EF72F\
EAB5EDCD425\
BF3EEBA28B5\
8CF033A660E\
2B333CB4571\
5CDBE031E8B\
DD4CC39F2FD\
B398F81A24B\
86C33BBE9D1\
19CDF48DF9,\
OCA876C6A76\
C08D2163900\
6F9C2BF4FBB\
565D115AF66\
74BDFC7EC6E\
33B7D26AEEA\
547AC701D84\
7BF65CC83BF\
3A0A80BF6CF\
C8C5ECB9348\
28BA2C8CE16\
24A92ECC12D\
2DF25C8620E\
4B322F7E6F1\
64F1C33A42F\
1F385D540EA\
F0610F6DC58\
A4CBB1,O01B\
61938B1242E\
2572689CFC5\
DF4875FED38\
D17490ED972\
2A56005DF9C\
FEF9F9DF4F2\
5B41E2DB1FD\
2818530EC87\
93EF855DFCC\
4E761D25B72\
8358355664D\
8BFF0DCD529\
90047FEFAA0\
8FE118D789B\
015198641B7\
A70B6FB5463\
93DED34C994\
6B){if(OCA8\
76C6A76C08D\
21639006F9C\
2BF4FBB565D\
115AF6674BD\
FC7EC6E33B7\
D26AEEA547A\
C701D847BF6\
5CC83BF3A0A\
80BF6CFC8C5\
ECB934828BA\
2C8CE1624A9\
2ECC12D2DF2\
5C8620E4B32\
2F7E6F164F1\
C33A42F1F38\
5D540EAF061\
0F6DC58A4CB\
B1==0){OCA8\
76C6A76C08D\
21639006F9C\
2BF4FBB565D\
115AF6674BD\
FC7EC6E33B7\
D26AEEA547A\
C701D847BF6\
5CC83BF3A0A\
80BF6CFC8C5\
ECB934828BA\
2C8CE1624A9\
2ECC12D2DF2\
5C8620E4B32\
2F7E6F164F1\
C33A42F1F38\
5D540EAF061\
0F6DC58A4CB\
B1=OD6B7F28\
AD82C629CEB\
DA096B0EAC8\
02875F9D07C\
A1F8A75E019\
B2078FC3372\
83F2F5B95BC\
4A664CABDC0\
16D4FA0AB43\
B66668009DF\
9605A06834A\
D00CA63D020\
EDC5CC1DD76\
68D18E09D89\
4835BEB681D\
67B3F8965C9\
BA0911427C6\
47BFB8A4E/2\
;O3A344C92A\
852B8277F76\
D9F96945978\
493710A4CE6\
9CB5F295820\
50D997284B4\
7350A69277B\
4F22ADF974D\
141EF72FEAB\
5EDCD425BF3\
EEBA28B58CF\
033A660E2B3\
33CB45715CD\
BE031E8BDD4\
CC39F2FDB39\
8F81A24B86C\
33BBE9D119C\
DF48DF9-=O0\
1B61938B124\
2E2572689CF\
C5DF4875FED\
38D17490ED9\
722A56005DF\
9CFEF9F9DF4\
F25B41E2DB1\
FD2818530EC\
8793EF855DF\
CC4E761D25B\
72835835566\
4D8BFF0DCD5\
2990047FEFA\
A08FE118D78\
9B015198641\
B7A70B6FB54\
6393DED34C9\
946B;}}
#define OB3\
E490EAFA302\
E925F96E5FD\
45D6041E65A\
1999621364E\
EBC0DB1E0FD\
D2BC50417D1\
5DAE1139B61\
39F4EB8D287\
CFDBDEAA5E2\
C99E75BD9EC\
4EAB0DA3951\
3EAA51432F9\
E826827E1BD\
1A266F4041B\
716BD5C0C3F\
E3D34430DC6\
5689FD04F39\
73A(O7ED4E7\
96A705B72C5\
3538144EAB6\
E6A7DEB22A0\
47AFA190EA4\
71AF89E6940\
9A298988181\
2576B82CEF3\
FE429FAF4FA\
750ADFE02E2\
55F6DDE2ACE\
BD381456CE4\
D5CD01E20DC\
6AE6FF1DBD9\
355C323D36A\
6EE4A48C654\
7ECCA96A4E9\
389285AE86,\
O01B61938B1\
242E2572689\
CFC5DF4875F\
ED38D17490E\
D9722A56005\
DF9CFEF9F9D\
F4F25B41E2D\
B1FD2818530\
EC8793EF855\
DFCC4E761D2\
5B728358355\
664D8BFF0DC\
D52990047FE\
FAA08FE118D\
789B0151986\
41B7A70B6FB\
546393DED34\
C9946B){O7E\
D4E796A705B\
72C53538144\
EAB6E6A7DEB\
22A047AFA19\
0EA471AF89E\
69409A29898\
81812576B82\
CEF3FE429FA\
F4FA750ADFE\
02E255F6DDE\
2ACEBD38145\
6CE4D5CD01E\
20DC6AE6FF1\
DBD9355C323\
D36A6EE4A48\
C6547ECCA96\
A4E9389285A\
E86>>=1;O01\
B61938B1242\
E2572689CFC\
5DF4875FED3\
8D17490ED97\
22A56005DF9\
CFEF9F9DF4F\
25B41E2DB1F\
D2818530EC8\
793EF855DFC\
C4E761D25B7\
28358355664\
D8BFF0DCD52\
990047FEFAA\
08FE118D789\
B015198641B\
7A70B6FB546\
393DED34C99\
46B<<=1;}
#define O2C\
8BD0EF1C443\
28CB3D4AF65\
46716D0479A\
7117BBF512E\
A125F91FA9B\
A3A0DB869D9\
47BB450A527\
2C37B07FB26\
1151274A3A5\
D5605A1ACAA\
68EF6856237\
E684C71FA72\
4AE2FD1A58B\
5AA418CE850\
1E05D7C710F\
39428A82177\
623D20B4C24\
C22(O3A344C\
92A852B8277\
F76D9F96945\
978493710A4\
CE69CB5F295\
82050D99728\
4B47350A692\
77B4F22ADF9\
74D141EF72F\
EAB5EDCD425\
BF3EEBA28B5\
8CF033A660E\
2B333CB4571\
5CDBE031E8B\
DD4CC39F2FD\
B398F81A24B\
86C33BBE9D1\
19CDF48DF9,\
OCA876C6A76\
C08D2163900\
6F9C2BF4FBB\
565D115AF66\
74BDFC7EC6E\
33B7D26AEEA\
547AC701D84\
7BF65CC83BF\
3A0A80BF6CF\
C8C5ECB9348\
28BA2C8CE16\
24A92ECC12D\
2DF25C8620E\
4B322F7E6F1\
64F1C33A42F\
1F385D540EA\
F0610F6DC58\
A4CBB1){O3A\
344C92A852B\
8277F76D9F9\
69459784937\
10A4CE69CB5\
F29582050D9\
97284B47350\
A69277B4F22\
ADF974D141E\
F72FEAB5EDC\
D425BF3EEBA\
28B58CF033A\
660E2B333CB\
45715CDBE03\
1E8BDD4CC39\
F2FDB398F81\
A24B86C33BB\
E9D119CDF48\
DF9=OD6B7F2\
8AD82C629CE\
BDA096B0EAC\
802875F9D07\
CA1F8A75E01\
9B2078FC337\
283F2F5B95B\
C4A664CABDC\
016D4FA0AB4\
3B66668009D\
F9605A06834\
AD00CA63D02\
0EDC5CC1DD7\
668D18E09D8\
94835BEB681\
D67B3F8965C\
9BA0911427C\
647BFB8A4E;\
OCA876C6A76\
C08D2163900\
6F9C2BF4FBB\
565D115AF66\
74BDFC7EC6E\
33B7D26AEEA\
547AC701D84\
7BF65CC83BF\
3A0A80BF6CF\
C8C5ECB9348\
28BA2C8CE16\
24A92ECC12D\
2DF25C8620E\
4B322F7E6F1\
64F1C33A42F\
1F385D540EA\
F0610F6DC58\
A4CBB1=OD6B\
7F28AD82C62\
9CEBDA096B0\
EAC802875F9\
D07CA1F8A75\
E019B2078FC\
337283F2F5B\
95BC4A664CA\
BDC016D4FA0\
AB43B666680\
09DF9605A06\
834AD00CA63\
D020EDC5CC1\
DD7668D18E0\
9D894835BEB\
681D67B3F89\
65C9BA09114\
27C647BFB8A\
4E/2;}
#define OB9\
6C2DA702FB5\
F7A7880A44E\
D9E2B97002A\
38781200CE3\
9AA97D90095\
B68B6E3386B\
BC10CE52FE3\
4F09AD5CC59\
E3EEA1F4796\
D13367470BD\
0DBC1E30F1C\
4C1A82BFCF6\
2F871DCA536\
6FF9C2BDE46\
051E095FE63\
AC9DBE94E12\
6E4366EE906\
42D(O92A937\
FBF1C9FDE3A\
E35161876DF\
AEF737646CC\
6E341BD1E24\
4D3CFC429E2\
1470A1979F9\
3A393C85D90\
C2A36729174\
B0352A55F70\
9A92A63FCFF\
B7DDD524F71\
DA429334E70\
1901F2CDC13\
0C897D8F9E9\
B1B86C42A62\
A6C5F4C78DC\
2E84C832BA,\
OEE886CE2F8\
D6429242B17\
FDDACBDCBD3\
1CA14339ECD\
A63B3442CCF\
6F5CB019A52\
5AE6E8F3A83\
5D5532A43AF\
FE5B6F1BD47\
B5ECDDE5513\
C76F587877C\
0F4CA61B4D5\
7AF83F66BAC\
88FB1FC0313\
CB9D03C20C4\
2C71035EA55\
37A78A57281\
1BCA80,O10B\
C53D4728F1A\
0F3674DA8F4\
535C3C6E99B\
C1AE928B888\
9C75EF6B3C6\
45042258710\
3E5158D8AD9\
D66718C3E27\
6005AD9FFB5\
231C1836C44\
47C2C4E51A3\
4592DCF6F04\
EBCF14120F2\
13D0A1D4C82\
0277A60B895\
F0AA21A7D52\
2AC5A5A14BB\
31,OE77BB91\
B2A28E5F5CD\
756309AAEC4\
BDE5326C721\
38E568504A4\
1CD37DB932C\
9AB04A8C2C4\
E802DC454EF\
C8EC4F691DE\
931F7D30B4B\
F8312538391\
C4EA81C68A6\
87F3839D21C\
1127E02217A\
64ED04EDDD1\
BC839709D7D\
67C110A29C3\
3AF17B00F,O\
53CC6879C3A\
FEEB7921F7D\
52E45887F38\
1A476F7C55E\
E2F719A0873\
4E4B90E732F\
D8C605CF15D\
E73BAEC8172\
DCBEE7B03E5\
BE1E01D13BA\
23AEBEFA480\
E2795D90C5A\
1C51296055B\
A928CC487C1\
8A79BF15869\
CAF31AB1DC6\
F6A59CD124E\
FAA13,OE336\
468575D91BB\
7558F542A6F\
62DB83E8023\
49C18150457\
94C843F3677\
040FC23D7D6\
D488BC4EBA5\
9FA834ED620\
A88BD962EE8\
DF5CF9EA7CB\
EBEBA445F99\
D7BE2BA0761\
A1A573E093C\
7092831FDBD\
C66782D4E15\
011973E04B8\
63EA001AEFA\
8,O9954E4DB\
B732D8A7DF1\
6ED198CCAE7\
6CD6612A36A\
3A1C11C8414\
3305C594C35\
EFC3F785112\
4D1FD39FDDE\
4073516A2DC\
E9FC403792B\
B73C7148BD4\
D68E392F113\
57C28E3E0A7\
DA0AE820C23\
F8DD181131D\
8A981D98ECC\
4A664FD3D48\
49DF9481){O\
22F518A33FB\
B50D3ADC353\
D2C22661CA9\
BC9FD756E10\
AFAFF10C304\
8B0A626F92B\
F114A4979C7\
4BF0B7B199F\
A1FD8880BB0\
3C4CBBB535F\
EE813CC15ED\
310668C4844\
4292F69A1D5\
C210AF0ECB9\
F413DCEEA47\
0D0DAADEB91\
4A0E8DA0437\
11D5C=O92A9\
37FBF1C9FDE\
3AE35161876\
DFAEF737646\
CC6E341BD1E\
244D3CFC429\
E21470A1979\
F93A393C85D\
90C2A367291\
74B0352A55F\
709A92A63FC\
FFB7DDD524F\
71DA429334E\
701901F2CDC\
130C897D8F9\
E9B1B86C42A\
62A6C5F4C78\
DC2E84C832B\
A;O34C82D72\
B2EC6D3E1C4\
A3CECD39A23\
FE3BB495833\
31A51EC2334\
13F53F22958\
CBBF7C78970\
8AB60B94DAC\
76090929DB1\
6E8F79DB639\
FDC3C61786E\
7AD154AFA06\
E490C027B72\
783D1C53907\
25DD6EB1283\
330FEF6B757\
67684D476A8\
C3D9A58E=OE\
E886CE2F8D6\
429242B17FD\
DACBDCBD31C\
A14339ECDA6\
3B3442CCF6F\
5CB019A525A\
E6E8F3A835D\
5532A43AFFE\
5B6F1BD47B5\
ECDDE5513C7\
6F587877C0F\
4CA61B4D57A\
F83F66BAC88\
FB1FC0313CB\
9D03C20C42C\
71035EA5537\
A78A572811B\
CA80;OB8B79\
213C36C2B10\
50347C74132\
8578BD1B0A9\
AFDA7783365\
42E31F3A21C\
1A4B89FCA3E\
39D4141DAB9\
F554C8E4621\
9E93324C0F4\
2D7E5351A4B\
71643103146\
E2AA993369D\
5F033D00F5D\
1DFF655B906\
631482D77C5\
2647A5F2189\
9DA4B7766DC\
=O10BC53D47\
28F1A0F3674\
DA8F4535C3C\
6E99BC1AE92\
8B8889C75EF\
6B3C6450422\
587103E5158\
D8AD9D66718\
C3E276005AD\
9FFB5231C18\
36C4447C2C4\
E51A34592DC\
F6F04EBCF14\
120F213D0A1\
D4C820277A6\
0B895F0AA21\
A7D522AC5A5\
A14BB31;O34\
C82D72B2EC6\
D3E1C4A3CEC\
D39A23FE3BB\
49583331A51\
EC233413F53\
F22958CBBF7\
C789708AB60\
B94DAC76090\
929DB16E8F7\
9DB639FDC3C\
61786E7AD15\
4AFA06E490C\
027B72783D1\
C5390725DD6\
EB1283330FE\
F6B75767684\
D476A8C3D9A\
58E=OE77BB9\
1B2A28E5F5C\
D756309AAEC\
4BDE5326C72\
138E568504A\
41CD37DB932\
C9AB04A8C2C\
4E802DC454E\
FC8EC4F691D\
E931F7D30B4\
BF831253839\
1C4EA81C68A\
687F3839D21\
C1127E02217\
A64ED04EDDD\
1BC839709D7\
D67C110A29C\
33AF17B00F;\
OE336468575\
D91BB7558F5\
42A6F62DB83\
E802349C181\
5045794C843\
F3677040FC2\
3D7D6D488BC\
4EBA59FA834\
ED620A88BD9\
62EE8DF5CF9\
EA7CBEBEBA4\
45F99D7BE2B\
A0761A1A573\
E093C709283\
1FDBDC66782\
D4E15011973\
E04B863EA00\
1AEFA8=O53C\
C6879C3AFEE\
B7921F7D52E\
45887F381A4\
76F7C55EE2F\
719A08734E4\
B90E732FD8C\
605CF15DE73\
BAEC8172DCB\
EE7B03E5BE1\
E01D13BA23A\
EBEFA480E27\
95D90C5A1C5\
1296055BA92\
8CC487C18A7\
9BF15869CAF\
31AB1DC6F6A\
59CD124EFAA\
13-O35C3A4F\
BFD3C3B02E8\
F91E11855E8\
844B3E42D03\
AC3F9FED8AF\
C7C75B37CE7\
B7DC7EBEFDC\
7B9E70CCCD4\
70203865C80\
B8D95403155\
8E94562EDF5\
F2CD9B3DA8D\
1FBA13755AD\
774A1586607\
6D5031028D4\
0F37ED4723B\
C14A79EB6A5\
80D6584EE;O\
9954E4DBB73\
2D8A7DF16ED\
198CCAE76CD\
6612A36A3A1\
C11C8414330\
5C594C35EFC\
3F7851124D1\
FD39FDDE407\
3516A2DCE9F\
C403792BB73\
C7148BD4D68\
E392F11357C\
28E3E0A7DA0\
AE820C23F8D\
D181131D8A9\
81D98ECC4A6\
64FD3D4849D\
F9481=O53CC\
6879C3AFEEB\
7921F7D52E4\
5887F381A47\
6F7C55EE2F7\
19A08734E4B\
90E732FD8C6\
05CF15DE73B\
AEC8172DCBE\
E7B03E5BE1E\
01D13BA23AE\
BEFA480E279\
5D90C5A1C51\
296055BA928\
CC487C18A79\
BF15869CAF3\
1AB1DC6F6A5\
9CD124EFAA1\
3+O35C3A4FB\
FD3C3B02E8F\
91E11855E88\
44B3E42D03A\
C3F9FED8AFC\
7C75B37CE7B\
7DC7EBEFDC7\
B9E70CCCD47\
0203865C80B\
8D954031558\
E94562EDF5F\
2CD9B3DA8D1\
FBA13755AD7\
74A15866076\
D5031028D40\
F37ED4723BC\
14A79EB6A58\
0D6584EE;}
#define O1C\
9BA8B140771\
516B468058D\
71D75D9CE77\
855709BC727\
B30EE4887F0\
53B0E2123B2\
76AB401AE57\
1719DCEAD01\
94BBD60BBD5\
F0B699716D5\
FB4E1594AB0\
8492D22ED3C\
930B7C2FF5E\
6DCE6FAE283\
0A32269FB16\
163020733F8\
30955DBF1F4\
491(O92A937\
FBF1C9FDE3A\
E35161876DF\
AEF737646CC\
6E341BD1E24\
4D3CFC429E2\
1470A1979F9\
3A393C85D90\
C2A36729174\
B0352A55F70\
9A92A63FCFF\
B7DDD524F71\
DA429334E70\
1901F2CDC13\
0C897D8F9E9\
B1B86C42A62\
A6C5F4C78DC\
2E84C832BA,\
OEE886CE2F8\
D6429242B17\
FDDACBDCBD3\
1CA14339ECD\
A63B3442CCF\
6F5CB019A52\
5AE6E8F3A83\
5D5532A43AF\
FE5B6F1BD47\
B5ECDDE5513\
C76F587877C\
0F4CA61B4D5\
7AF83F66BAC\
88FB1FC0313\
CB9D03C20C4\
2C71035EA55\
37A78A57281\
1BCA80){O92\
A937FBF1C9F\
DE3AE351618\
76DFAEF7376\
46CC6E341BD\
1E244D3CFC4\
29E21470A19\
79F93A393C8\
5D90C2A3672\
9174B0352A5\
5F709A92A63\
FCFFB7DDD52\
4F71DA42933\
4E701901F2C\
DC130C897D8\
F9E9B1B86C4\
2A62A6C5F4C\
78DC2E84C83\
2BA=OEE886C\
E2F8D642924\
2B17FDDACBD\
CBD31CA1433\
9ECDA63B344\
2CCF6F5CB01\
9A525AE6E8F\
3A835D5532A\
43AFFE5B6F1\
BD47B5ECDDE\
5513C76F587\
877C0F4CA61\
B4D57AF83F6\
6BAC88FB1FC\
0313CB9D03C\
20C42C71035\
EA5537A78A5\
72811BCA80;\
O92A937FBF1\
C9FDE3AE351\
61876DFAEF7\
37646CC6E34\
1BD1E244D3C\
FC429E21470\
A1979F93A39\
3C85D90C2A3\
6729174B035\
2A55F709A92\
A63FCFFB7DD\
D524F71DA42\
9334E701901\
F2CDC130C89\
7D8F9E9B1B8\
6C42A62A6C5\
F4C78DC2E84\
C832BA>>=1;\
}

