// MyFFT_TestHarness.c (Created by FFTDesigner - Version 3.70)

/******************************************************************************

COPYRIGHT.  This software is Copyright  2011 RHDC Services Ltd.

        !  DO NOT EDIT THIS FILE AS IT MAY BE OVERWRITTEN BY
        THE DESIGNER RESULTING IN YOUR CHANGES BEING LOST  !

DISTRIBUTION.  This software may NOT be distributed to a third party without
prior written approval of the copyright holder. Please see the FFT Designer
End User Licence Agreement for details about distribution in object-code form.

DISCLAIMER.  This software is provided "AS IS", without express or implied
warranty.  In no event shall the copyright holder, author(s) or provider(s)
of this software be held liable for any damages arising from its use.

        FFTLength ................................ 8
        WindowType ............................... Kaiser
        WindowLoss (dB) .......................... 8.27
        Equivalent Noise Bandwidth ENBW (Bins) ... 2.052
        Incoherent Power Gain .................... 0.3056
        Coherent Power Gain ...................... 0.1489
        WindowAlpha .............................. 3
        Language ................................. MSP430 Extended C
        Algorithm ................................ Integer (16 Bit)
        Use Shift Division ....................... True
        Use Direct MPY32 Access .................. True

NOTE. When option "Use Direct MPY32 Access" is True, this software will make
direct use of the MPY32 hardware multiplier module including its configuration
registers as well as the operand and result registers.  Therefore, if any ISR
needs to be active whilst the FFT methods are in use, they must comply with
either (a) or (b) below.

   (a). They must not use the MPY32 hardware multiplier module.
   (b). They must perform a full MPY32 context save and restore.

Refer to section "32-Bit Hardware Multiplier", sub-section "Using Interrupts"
of the MSP430x5xx User Guide for more details.

******************************************************************************/

#include "MyFFT_TestHarness.h"

// N FFT unwindowed input samples in Q15 (signed fraction) format
const MyFFT_Workspace_t MyFFT_SampledR[8]={0,23173,32766,23159,-18,-23181,-32759,-23142};

const MyFFT_Workspace_t MyFFT_SampledI[8]={0,0,0,0,0,0,0,0};

// N FFT windowed input samples in Q15 (signed fraction) format
const MyFFT_Workspace_t MyFFT_WindowedR[8]={0,1804,15236,23158,-17,-10779,-2551,-15};

const MyFFT_Workspace_t MyFFT_WindowedI[8]={0,0,0,0,0,0,0,0};

// N FFT output samples (FFT result) in Q15 (signed fraction) format
const MyFFT_Workspace_t MyFFT_TransformedR[8]={3352,-935,-1588,938,-188,939,-1588,-934};

const MyFFT_Workspace_t MyFFT_TransformedI[8]={0,-5385,4014,-938,0,937,-4014,5384};

void MyFFT_TestHarnessLoadComplex(const MyFFT_Workspace_t * table_pointer_r, const int * table_pointer_i)
{
	// Compare the complex result buffer from test vector table - Windowed
	MyFFT_Workspace_t * result_pointer_r = MyFFT_ResultR;
	MyFFT_Workspace_t * result_pointer_i = MyFFT_ResultI;
	
	int i=MyFFT_INPUT_LENGTH;
	do
	{
		*(result_pointer_r++) = *(table_pointer_r++); // copy the Real value
		*(result_pointer_i++) = *(table_pointer_i++); // copy the Imaginary value
	}
	while(--i);
}
void MyFFT_TestHarnessLoadSampled(void)
{
	// Compare the complex result buffer from test vector table - Sampled
	MyFFT_TestHarnessLoadComplex(MyFFT_SampledR, MyFFT_SampledI);
}
void MyFFT_TestHarnessLoadWindowed(void)
{
	// Compare the complex result buffer from test vector table - Windowed
	MyFFT_TestHarnessLoadComplex(MyFFT_WindowedR, MyFFT_WindowedI);
}
int MyFFT_TestHarnessCompareComplex(const MyFFT_Workspace_t * table_pointer_r, const MyFFT_Workspace_t * table_pointer_i)
{
	int ErrorCount=0; // return the number of errors found 
	// Compare the complex result buffer with test vector table - Transformed
	MyFFT_Workspace_t * result_pointer_r = MyFFT_ResultR;
	MyFFT_Workspace_t * result_pointer_i = MyFFT_ResultI;
	
	int i=MyFFT_INPUT_LENGTH;
	do
	{
		if(*(result_pointer_r++) != *(table_pointer_r++)) ErrorCount++; // check Real value
		if(*(result_pointer_i++) != *(table_pointer_i++)) ErrorCount++; // check Imag value
	}
	while(--i);
	return ErrorCount;
}
int MyFFT_TestHarnessCompareWindowed(void)
{
	return MyFFT_TestHarnessCompareComplex(MyFFT_WindowedR, MyFFT_WindowedI);
}
int MyFFT_TestHarnessCompareTransformed(void)
{
	return MyFFT_TestHarnessCompareComplex(MyFFT_TransformedR, MyFFT_TransformedI);
}
