/*
 * Task_AES.c
 *
 *  Created on: 2017. 6. 5.
 *      Author: Mirae
 */


 //Free RTOS
#include "FreeRTOS.h"
#include "task.h"
#include <msp430.h>
/* Demo includes. */
#include "partest.h"
#include "inc/hw_memmap.h"
/* TI includes. */
#include "driverlib.h"

#include "aes256.h"

#define mainTASK_LED                        ( 0 )


void vTask_AES(void)
{
    uint8_t Data[16] =
    {0x00, 0x11, 0x22, 0x33,
     0x44, 0x55, 0x66, 0x77,
     0x88, 0x99, 0xaa, 0xbb,
     0xcc, 0xdd, 0xee, 0xff};

    uint8_t CipherKey[32] =
    {0x00, 0x01, 0x02, 0x03,
     0x04, 0x05, 0x06, 0x07,
     0x08, 0x09, 0x0a, 0x0b,
     0x0c, 0x0d, 0x0e, 0x0f,
     0x10, 0x11, 0x12, 0x13,
     0x14, 0x15, 0x16, 0x17,
     0x18, 0x19, 0x1a, 0x1b,
     0x1c, 0x1d, 0x1e, 0x1f};

    uint8_t DataAESencrypted[16];           // Encrypted data
    uint8_t DataAESdecrypted[16];           // Decrypted data

    // stop watchdog
       WDT_A_hold(WDT_A_BASE);

       // Load a cipher key to module
       AES256_setCipherKey(AES256_BASE, CipherKey, AES256_KEYLENGTH_256BIT);

       // Encrypt data with preloaded cipher key
       AES256_encryptData(AES256_BASE, Data, DataAESencrypted);

       // Load a cipher key to module
       AES256_setDecipherKey(AES256_BASE, CipherKey, AES256_KEYLENGTH_256BIT);

       // Decrypt data
       AES256_decryptData(AES256_BASE, DataAESencrypted, DataAESdecrypted);

       // Array DataunAES should now contain the same data as array Data

       while(1)
       {

       }
       ;

}
