#include <stdint.h>
#include <log.h>
#include <SDRAMcheckCSLlibrarycfg.h>

#define MEMORY_SIZE		0x400000	// 0x400000 * 4 bytes = 0x1000000 => 16MB
#define SDRAMstart		0x80000000	// SDRAM origin
#define CHIP_6416 		1			// TMS320C6416

#include <csl.h>
#include <csl_emifa.h>

void initEMIFA(void);
void writeDataToSDRAM(void);
void readDataFromSDRAM(void);
void SDRAMtest(void);
//--------------------------------------------------------------------------------------
int main(void)
{
	// Must be done ALLWAYS and ONCE!
	CSL_init();

	initEMIFA();

    TSK_Attrs taskAttrs =
    {
        3, NULL, 1024, NULL, NULL, "SDRAMtask", TRUE, TRUE
    };
    TSK_create((Fxn)SDRAMtest, &taskAttrs);

	return 0;
}
//--------------------------------------------------------------------------------------
void SDRAMtest(void)
{
	writeDataToSDRAM();
	readDataFromSDRAM();
}
//--------------------------------------------------------------------------------------
void initEMIFA(void)
{
	EMIFA_Config EmifA;

	EMIFA_getConfig( &EmifA );
	EmifA.gblctl =  0x00012070;
	EmifA.cectl0 =  0xffffffd3;
	EmifA.sdctl  =  0x47116000;		// check 0x47116000
	EmifA.sdtim  =  0x00000750;  	// Optimally 0x00000750 at 120 MHz
	EmifA.sdext  =  0x001faf4d;
	EMIFA_config( &EmifA );
}
//--------------------------------------------------------------------------------------
void writeDataToSDRAM(void)
{
	uint32_t i = 0x00000000;
	uint32_t address = SDRAMstart;

	// Write data
	*(volatile uint32_t *)address = 0;
	do
	{
		*(volatile uint32_t *)address = (uint32_t)i;
		address = address + 4;
		i ++;
	}
	while (i < MEMORY_SIZE);
}
//--------------------------------------------------------------------------------------
void readDataFromSDRAM(void)
{
	uint32_t i = 0;
	uint32_t error = 0;
	uint32_t address = SDRAMstart;

	// Read data
	do
	{
		if (*(volatile uint32_t *)address != (uint32_t)i)
		{
			error ++;
		}
		address = address + 4;
		i ++;
	}
	while (i < MEMORY_SIZE);

	if (error != 0)
	{
		LOG_printf(&trace, "Wrong value in %u of cell SDRAM.\n", error);
	}
	else
	{
		LOG_printf(&trace, "No errors.\n");
	}
}
//--------------------------------------------------------------------------------------
