;******************************************************************************
;+--------------------------------------------------------------------------+**
;|                            ****                                          |**
;|                            ****                                          |**
;|                            ******o***                                    |**
;|                      ********_;/_****                                   |**
;|                      ***** /_;_/ ****                                   |**
;|                       ** ** (__/ ****                                    |**
;|                           *********                                      |**
;|                            ****                                          |**
;|                            ***                                           |**
;|                                                                          |**
;|         Copyright (c) 1998-2012 Texas Instruments Incorporated           |**
;|                        ALL RIGHTS RESERVED                               |**
;|                                                                          |**
;| Permission is hereby granted to licensees of Texas Instruments           |**
;| Incorporated (TI) products to use this computer program for the sole     |**
;| purpose of implementing a licensee product based on TI products.         |**
;| No other rights to reproduce, use, or disseminate this computer          |**
;| program, whether in part or in whole, are granted.                       |**
;|                                                                          |**
;| TI makes no representation or warranties with respect to the             |**
;| performance of this computer program, and specifically disclaims         |**
;| any responsibility for any damages, special or consequential,            |**
;| connected with the use of this program.                                  |**
;|                                                                          |**
;+--------------------------------------------------------------------------+**
;*****************************************************************************/
; file:  emac_MII_Rcv.hp
;
; brief:	Defines and macros to be used in receive task.
;
;
;  (C) Copyright 2012, Texas Instruments, Inc
;
;	Version		Description								Author
;
; 	0.1     	Created									Thomas Mauer
;	0.2			Updated for Common Baseline				Anjandeep Sahni
	
	.if !$isdefed("__mii_rcv_hp")	
__mii_rcv_hp	.set	1	
	
	.include "icss_emacSwitch.h"
	.include "icss_defines.h"
	
; MII receive structure definition
	.asg	t0, host_rcv_flag		; rcv will place frame into host queue
host_rcv_flag_shift	.set	0	
	.asg	t1, fwd_flag		; rcv will place frame into port queue
fwd_flag_shift	.set	1	
	.asg	t2, ct_bank_index		; indication for that data is either in R2..R5 or R6..R9; used only by rx function
ct_bank_index_shift	.set	2	
	.asg	t3, rx_bank_index		; indication for rcv of where to get the next 32 bytes of data (bank0/1)
rx_bank_index_shift	.set	3	
	.asg	t4, rx_frame_error		; used to indicate a frame error to Xmt function
rx_frame_error_shift	.set	4	
	.asg	t5, port_collision_queue_selected		; will indicate if the port collision queue has been selected
port_collision_queue_selected_shift	.set	5	
	.asg	t6, host_collision_queue_selected		; will indicate if the host collision queue has been selected
host_collision_queue_selected_shift	.set	6	
	.asg	t7, last_block_multi_bank_processing		; during last_block function, we need to process more than one bank of data
last_block_multi_bank_processing_shift	.set	7	
	
	.asg	t0, cut_through_flag		; rcv in cut-through (16 byte) mode
cut_through_flag_shift	.set	0	
	.asg	t1, ct_data_available		; indication for Xmt that new data is in bank0 (scratchpad)
ct_data_available_shift	.set	1	
	.asg	t2, ct_last_block		; indication for Xmt that this is the last block of data, R18.b0 provides the amount of data to transmit
ct_last_block_shift	.set	2	
	
	.asg	t0, delay_resp	
delay_resp_shift	.set	0	
	.asg	t1, delay_resp_followup	
delay_resp_followup_shift	.set	1	
	.asg	t2, delay_followup_resp	
delay_followup_resp_shift	.set	2	
	.asg	t3, delay_request	
delay_request_shift	.set	3	
	.asg	t4, process_lb_part1_executed		; When processing multibank, we spilt it into two parts ..this bit indicate that 1st part is done.
process_lb_part1_executed_shift	.set	4	
	.asg	t5, unicast_pkt_cut_through	
unicast_pkt_cut_through_shift	.set	5	
	.asg	t6, host_queue_overflow	
host_queue_overflow_shift	.set	6	
	.asg	t7, port_queue_overflow	
port_queue_overflow_shift	.set	7	
	
MII_RCV_DESC	.struct	
rx_flags	.ubyte	
tx_flags	.ubyte	
rx_flags_extended	.ubyte	
qos_queue	.ubyte	; for host/port queue, this stores the priority queue as determined by the frame
byte_cntr	.ushort	; total amount of bytes received
wrkng_wr_ptr	.ushort	; same as port, but points to the host buffer
rd_ptr	.ushort	
buffer_index	.ushort	;offset in L3 where data is to be stored
base_buffer_index	.ushort	; offset in L3 of 32 bytes data correspondin to first buffer_desc
rcv_queue_pointer	.ushort	; host queue  pointer
base_buffer_desc_offset	.ushort	; offset of the base buffer desc for the queue selected
top_most_buffer_desc_offset	.ushort	; offset of the last/top buffer desc for the queue selected
	.endstruct
	
; MII structure for PORT receive
MII_RCV_PORT_DESC	.struct	
byte_cntr	.ushort	; total amount of bytes received
wrkng_wr_ptr	.ushort	; same as port, but points to the host buffer
rd_ptr	.ushort	
buffer_index	.ushort	; offset in L3 where data is to be stored
base_buffer_index	.ushort	; offset in L3 of 32 bytes data correspondin to first buffer_desc
rcv_queue_pointer	.ushort	; port queue  pointer
base_buffer_desc_offset	.ushort	; offset of the base buffer desc for the queue selected
top_most_buffer_desc_offset	.ushort	; offset of the last/top buffer desc for the queue selected
	.endstruct
	
	.asg	R2.w0, RX_CONTEXT_OFFSET	
	.asg	R2.w2, RX_PORT_CONTEXT_OFFSET	
	
	.asg	R18.b0, R18_RCV_BYTECOUNT			; wrt pointer of L2 buffer, has amount of data
	.asg	R23.t0, Xmt_active			; global flag that indicates if transmission is ongoing
	.asg	R23.t1, Rcv_active			; global flag that indicates if reception is ongoing
	.asg	R23.t2, TX_STAT_PEND	
	.asg	R23.t3, RX_STAT_PEND	
	.asg	R23.t4, TX_DELAY_REQ      	; This flag is just for debug ...set when pkt is received and cleared in RX_FB and STATS
	.asg	R23.t5, TX_DELAY_RESP	
	.asg	R23.t6, TX_DELAY_FOLLOWUP_RESP	
	
	.asg	R23.t7, TX_PHY_SPEED   	 	; If 0 for 10 Mbps. 1 for 100 Mbps.
	
	.asg	R23.b1, PREVIOUS_R18_RCV_BYTECOUNT	
	.asg	R23.w2, CUT_THROUGH_BYTE_CNT	
	
	.asg	R21, COLLISION_STATUS_REG	
	.asg	R20, RCV_TEMP_REG_1			; buffer need to be in consecutive register space
	.asg	R21, RCV_TEMP_REG_2	
	.asg	R13, RCV_TEMP_REG_3	
	.asg	R12, RCV_TEMP_REG_4	
	.asg	R21, RCV_BUFFER_DESC_OFFSET	
	.asg	R6.t0, CODE_EXECUTING_FOR_PORT_RECEIVE	
	
PORT_COLLISION_BIT	.set	2	
	
QPR_ERROR_NO_SPACE_IN_QUEUE	.set	0xff	
QPR_ERROR_BYTES_TO_WRITE_IS_ZERO	.set	0xfe	
	
	.asg	RCV_TEMP_REG_2.w0, FORWARD_TABLE_POINTER 	; Warning: Some symbols not defined before.
	.asg	RCV_TEMP_REG_2.w0, RECEIVE_TABLE_POINTER 	; Warning: Some symbols not defined before.
	
; macro defines
Q_RD_PTR_OFFSET	.set	0	
Q_RD_PTR_SIZE	.set	2	
Q_WR_PTR_OFFSET	.set	2	
Q_WR_PTR_SIZE	.set	2	
Q_BUSY_S_OFFSET	.set	4	
Q_BUSY_S_SIZE	.set	1	
Q_STATUS_OFFSET	.set	5	
Q_STATUS_SIZE	.set	1	
	
Q_BUSY_S_BIT	.set	0	
Q_BUSY_M_BIT	.set	0	
Q_COLLISION_BIT	.set	1	
Q_OVERFLOW_BIT	.set	2	
	
QUEUE_FAILED	.set	0	
QUEUE_AQUIRED	.set	1	
COLLISION_AQUIRED	.set	2	
	
; RX L2 status register specific meanings
	.asg	t0, RXL2_RX_ERR_BIT	
	.asg	t1, RXL2_STATUS_RDY_BIT	
	.asg	t2, RXL2_RX_ERROR_BIT	
	.asg	t3, RXL2_RX_EOF_BIT	
	.asg	t4, RXL2_RX_SFD_BIT	
	.asg	t5, RXL2_RX_SOF_BIT	
	.asg	t6, RXL2_ERROR_NIBBLE	
	.asg	t7, RXL2_ERROR_CRC	
	
RANGE_R2_R5	.set					(4 * 4) 
RANGE_R2_R6	.set					(4 * 5) 
RANGE_R6_R9	.set					(4 * 4) 
RANGE_R2_R9	.set					(4 * 8)   ; used by XFER, amount of bytes from R2 - R9
RANGE_R2_R13	.set				(4 * 12) 
RANGE_R2_R18	.set				(4 * 17)  ; used by XFER, amount of bytes from R2 - R18
RANGE_R10_R18	.set				(4 * 9) 
RANGE_R10_R13	.set				(4 * 4) 
RANGE_R18_b0	.set	1	
	
	.asg	R0.b0, SHIFT_REG	
SHIFT_NONE	.set	0	
SHIFT_R2_TO_R5	.set	3	
SHIFT_R2_TO_R6	.set	4	
SHIFT_R2_TO_R8	.set	6	
SHIFT_R2_TO_R10	.set	8	
SHIFT_R2_TO_R17	.set	15	
SHIFT_R2_TO_R0	.set	28	
SHIFT_R7_TO_R18	.set	11	
SHIFT_R2_TO_R18	.set	16	
; Below are used for Port Receive code
SHIFT_R14_TO_R0	.set	16	
SHIFT_R14_TO_R4	.set	20	
SHIFT_R14_TO_R8	.set	24	
SHIFT_R10_TO_R6	.set	26	
SHIFT_R10_TO_R8	.set	28	
SHIFT_R9_TO_R0	.set	21	
	
SHIFT_R21_TO_R10	.set	19	
	
SHIFT_R12_TO_R9	.set	27	
SHIFT_R12_TO_R10	.set	28	
	
SHIFT_R14_TO_R18	.set	4	
SHIFT_R14_TO_R20	.set	6	
	
SHIFT_R18_TO_R16	.set	28	
SHIFT_R18_TO_R25	.set	7	
	
SHIFT_R2_TO_R26	.set	24	
SHIFT_R2_TO_R2	.set	0	
SHIFT_R2_TO_R4	.set	2	
	
; TPID = tag protocol ID, typ 8100 for tagged frames
; TCI  = tag control info with user priority in 3 MSBs
struct_Ethernet	.struct	
DstAddr_0123	.uint	;R2
DstAddr_45	.ushort	;R3
SrcAddr_01	.ushort	
SrcAddr_23	.ushort	;R4
SrcAddr_45	.ushort	
TPID	        .ushort	;R5
TCI	        .ushort	
ProtWord2	.ushort	;R6
ProtWord3	.ushort	
ProtWord4	.ushort	;R7
ProtWord5	.ushort	
ProtWord6	.ushort	;R8
ProtWord7	.ushort	
ProtWord8	.ushort	;R9
ProtWord9	.ushort	
	.endstruct
	
	.asg	t0, multicast					; multicast bit in DstByte_0
struct_EthByte	.struct	
DstByte_0	.ubyte	
DstByte_1	.ubyte	
DstByte_2	.ubyte	
DstByte_3	.ubyte	
DstByte_4	.ubyte	
DstByte_5	.ubyte	
SrcByte_0	.ubyte	
SrcByte_1	.ubyte	
SrcByte_2	.ubyte	
SrcByte_3	.ubyte	
SrcByte_4	.ubyte	
SrcByte_5	.ubyte	
	.endstruct
	
	.asg	R25, RCV_REGISTER_1	
	.asg	R29, RCV_REGISTER_2	
	
Ethernet	.sassign	 R2	,	struct_Ethernet	
EthByte	.sassign	 R2	,	struct_EthByte	
MII_RCV	.sassign	 RCV_REGISTER_1	,	MII_RCV_DESC	; This context is for Host Receive
MII_RCV_PORT	.sassign	 R14	,	MII_RCV_PORT_DESC	; This context is for Port Receive
RCV_CONTEXT	.sassign	 R2	,	MII_RCV_PORT_DESC	
RCV_QUEUE_DESC_REG	.sassign	 R20	,	struct_queue	
	
	.asg	R5, PROTOCOL_TYPE_FRAME_ID	
PTP_DELAY_REQUEST	.set	0x40ff9288	
PTP_DELAY_RESPONSE	.set	0x43ff9288	
PTP_DELAY_RESPONSE_FOLLLOWUP	.set	0x41ff9288	
PTP_DELAY_FOLLOWUP_RESPONSE	.set	0x42ff9288	
	
;-----------------------------------
; Macro Name: M_RCV_RX_EOF_CHECK_AM335x
; Description: Check for RX EOF on AM335x.
; Input Parameters: none
; Output Parameters: none
;-----------------------------------
M_RCV_RX_EOF_CHECK_AM335x	 .macro
	.if $isdefed("PRU0")	
	QBBS	process_rx_eof_rx_nb, R31, 30	 ;replaced: QBBS	process_rx_eof_rx_nb, R31.t30 ; Port0 Rx EOF
	.else
	QBBS	process_rx_eof_rx_nb, R31, 31	 ;replaced: QBBS	process_rx_eof_rx_nb, R31.t31 ; Port1 Rx EOF
	.endif
	.endm
	
;-----------------------------------
; Macro Name: M_RCV_RX_EOF_CHECK_AM571x
; Description: Check for RX EOF on AM571x.
; Input Parameters: none
; Output Parameters: none
;-----------------------------------
M_RCV_RX_EOF_CHECK_AM571x	 .macro
	QBBS	process_rx_eof_rx_nb, R31, 20	 ;replaced: QBBS	process_rx_eof_rx_nb, R31.t20 ; Port Rx EOF
	.endm
	
;-----------------------------------
; Macro Name: M_RCV_RX_EOF_CLEAR_INTC_AM335x
; Description: Clear RX EOF system event in INTC on AM335x.
; Input Parameters: none
; Output Parameters: none
;-----------------------------------
M_RCV_RX_EOF_CLEAR_INTC_AM335x	 .macro
	LDI	TEMP_REG_4.w0, 0x0284	; Clear RX_EOF
	.if $isdefed("PRU0")	
	LDI	TEMP_REG_3 , 0x00000410
	.else
	LDI	TEMP_REG_3.w0 , 0x00410000 & 0xFFFF
	LDI	TEMP_REG_3.w2 , 0x00410000 >> 16
	.endif
	SBCO	&TEMP_REG_3, ICSS_INTC_CONST, TEMP_REG_4.w0, 4	
	.endm
	
;-----------------------------------
; Macro Name: M_RCV_RX_EOF_CLEAR_INTC_AM571x
; Description: Clear RX EOF and CRC system event in INTC on AM571x.
; Input Parameters: none
; Output Parameters: none
;-----------------------------------
M_RCV_RX_EOF_CLEAR_INTC_AM571x	 .macro
	LDI	TEMP_REG_4.w0, 0x0284	; Clear RX CRC
	.if $isdefed("PRU0")	
	LDI	TEMP_REG_3 , 0x00000010
	.else
	LDI	TEMP_REG_3.w0 , 0x00010000 & 0xFFFF
	LDI	TEMP_REG_3.w2 , 0x00010000 >> 16
	.endif
	SBCO	&TEMP_REG_3, ICSS_INTC_CONST, TEMP_REG_4.w0, 4	
	SET	R31 , R31 , 22 ; Clear RX_EOF
	.endm
	
	.endif	;__mii_rcv_hp
