;******************************************************************************
;+--------------------------------------------------------------------------+**
;|                            ****                                          |**
;|                            ****                                          |**
;|                            ******o***                                    |**
;|                      ********_;/_****                                   |**
;|                      ***** /_;_/ ****                                   |**
;|                       ** ** (__/ ****                                    |**
;|                           *********                                      |**
;|                            ****                                          |**
;|                            ***                                           |**
;|                                                                          |**
;|         Copyright (c) 1998-2012 Texas Instruments Incorporated           |**
;|                        ALL RIGHTS RESERVED                               |**
;|                                                                          |**
;| Permission is hereby granted to licensees of Texas Instruments           |**
;| Incorporated (TI) products to use this computer program for the sole     |**
;| purpose of implementing a licensee product based on TI products.         |**
;| No other rights to reproduce, use, or disseminate this computer          |**
;| program, whether in part or in whole, are granted.                       |**
;|                                                                          |**
;| TI makes no representation or warranties with respect to the             |**
;| performance of this computer program, and specifically disclaims         |**
;| any responsibility for any damages, special or consequential,            |**
;| connected with the use of this program.                                  |**
;|                                                                          |**
;+--------------------------------------------------------------------------+**
;*****************************************************************************/
; file:   icss_defines.hp
;
; brief:  ICSS Global Defines
;
;
;  (C) Copyright 2010, Texas Instruments, Inc
;
;	Version		Description								Author
;
; 	0.1     	Created									Thomas
	
	.if !$isdefed("__icss_config_h")	
__icss_config_h	.set	1	
	
; Bank ids for Xfer instructions
BANK0	.set	10	
BANK1	.set	11	
BANK2	.set	12	
RX_L2_BANK0_ID	.set	20	
RX_L2_BANK1_ID	.set	21	
	
; Constants need to be defined with correct offset before using. Typically done on ARM side.
	.asg					c0  , ICSS_INTC_CONST 
	.asg					c3  , ICSS_ECAP_CONST
	
	.if $isdefed("PRU0")	
	.asg					c24  , PRU0_DMEM_CONST
	.asg					c25  , PRU1_DMEM_CONST
PRU0_DMEM	.set	0x0000	
PRU1_DMEM	.set	0x2000	
PRU_DMEM_ADDR	.set	       		PRU0_DMEM_CONST 
PRU_CROSS_DMEM	.set	      		PRU1_DMEM_CONST 
MII_CARRIER_SENSE_REG	.set			ICSS_MIIRT_PRS0
	.else
	.asg					c24  , PRU1_DMEM_CONST
	.asg					c25  , PRU0_DMEM_CONST
PRU0_DMEM	.set	0x2000	
PRU1_DMEM	.set	0x0000	
PRU_DMEM_ADDR	.set	       		PRU1_DMEM_CONST 
PRU_CROSS_DMEM	.set					PRU0_DMEM_CONST 
MII_CARRIER_SENSE_REG	.set	  		ICSS_MIIRT_PRS1
	.endif
	
	.asg					c21  , ICSS_MDIO_CONST
	.asg						c26  , IEP_CONST
	.asg				c27  , MII_RT_CFG_CONST
	.asg				c28  , ICSS_SHARED_CONST
ICSS_SHARED	.set	0x00010000	
	.asg				c30  , L3_OCMC_RAM_CONST
	
; Permanent Registers not used by other tasks
	.asg	R19, Reserved_R19	
	.asg	R20, Reserved_R20	
	.asg	R21, Reserved_R21	
	.asg	R22, Reserved_R22	
	.asg	R23.b0, Reserved_R23	
	
	.asg	R24.w2, CALL_REG	
	.asg	R24.w0, L1_CALL_REG	
	
; Note R25-R29 is multiplier
; R0 and R1 is used by some instructions
	
	.endif	;__icss_config_h
