;******************************************************************************
;+--------------------------------------------------------------------------+**
;|                            ****                                          |**
;|                            ****                                          |**
;|                            ******o***                                    |**
;|                      ********_;/_****                                   |**
;|                      ***** /_;_/ ****                                   |**
;|                       ** ** (__/ ****                                    |**
;|                           *********                                      |**
;|                            ****                                          |**
;|                            ***                                           |**
;|                                                                          |**
;|         Copyright (c) 1998-2010 Texas Instruments Incorporated           |**
;|                        ALL RIGHTS RESERVED                               |**
;|                                                                          |**
;| Permission is hereby granted to licensees of Texas Instruments           |**
;| Incorporated (TI) products to use this computer program for the sole     |**
;| purpose of implementing a licensee product based on TI products.         |**
;| No other rights to reproduce, use, or disseminate this computer          |**
;| program, whether in part or in whole, are granted.                       |**
;|                                                                          |**
;| TI makes no representation or warranties with respect to the             |**
;| performance of this computer program, and specifically disclaims         |**
;| any responsibility for any damages, special or consequential,            |**
;| connected with the use of this program.                                  |**
;|                                                                          |**
;+--------------------------------------------------------------------------+**
;*****************************************************************************/
; file:   icss_intc_regs.h
;
; brief:  ICSS Interrupt Controller Module Registers
;
;
;  (C) Copyright 2010, Texas Instruments, Inc
;
;	Version		Description								Author
;
; 	0.1     	Created									Vijaya Sarathy
	
	.if !$isdefed("__icss_intc_regs_h")	
__icss_intc_regs_h	.set	1	
	
ICSS_INTC_REVID	.set	0x0000	
ICSS_INTC_CR	.set	0x0004	
ICSS_INTC_HCR	.set	0x000C	
ICSS_INTC_GER	.set	0x0010	
ICSS_INTC_GNLR	.set	0x001C	
ICSS_INTC_SISR	.set	0x0020	
ICSS_INTC_SICR	.set	0x0024	
ICSS_INTC_EISR	.set	0x0028	
ICSS_INTC_EICR	.set	0x002C	
ICSS_INTC_HIEISR	.set	0x0034	
ICSS_INTC_HIDSR	.set	0x0038	
ICSS_INTC_GPIR	.set	0x0080	
ICSS_INTC_SRSR1	.set	0x0200	
ICSS_INTC_SRSR2	.set	0x0204	
ICSS_INTC_SECR1	.set	0x0280	
ICSS_INTC_SECR2	.set	0x0284	
ICSS_INTC_ESR1	.set	0x0300	
ICSS_INTC_ESR2	.set	0x0304	
ICSS_INTC_ECR1	.set	0x0380	
ICSS_INTC_ECR2	.set	0x0384	
ICSS_INTC_CMR1	.set	0x0400	
ICSS_INTC_CMR2	.set	0x0404	
ICSS_INTC_CMR3	.set	0x0408	
ICSS_INTC_CMR4	.set	0x040C	
ICSS_INTC_CMR5	.set	0x0410	
ICSS_INTC_CMR6	.set	0x0414	
ICSS_INTC_CMR7	.set	0x0418	
ICSS_INTC_CMR8	.set	0x041C	
ICSS_INTC_CMR9	.set	0x0420	
ICSS_INTC_CMR10	.set	0x0424	
ICSS_INTC_CMR11	.set	0x0428	
ICSS_INTC_CMR12	.set	0x042C	
ICSS_INTC_CMR13	.set	0x0430	
ICSS_INTC_CMR14	.set	0x0434	
ICSS_INTC_CMR15	.set	0x0438	
ICSS_INTC_CMR16	.set	0x043C	
ICSS_INTC_HMR1	.set	0x0800	
ICSS_INTC_HMR2	.set	0x0804	
ICSS_INTC_HMR3	.set	0x0808	
ICSS_INTC_HIPIR1	.set	0x0900	
ICSS_INTC_HIPIR2	.set	0x0904	
ICSS_INTC_HIPIR3	.set	0x0908	
ICSS_INTC_HIPIR4	.set	0x090C	
ICSS_INTC_HIPIR5	.set	0x0910	
ICSS_INTC_HIPIR6	.set	0x0914	
ICSS_INTC_HIPIR7	.set	0x0918	
ICSS_INTC_HIPIR8	.set	0x091C	
ICSS_INTC_HIPIR9	.set	0x0920	
ICSS_INTC_HIPIR10	.set	0x0924	
ICSS_INTC_SIPR1	.set	0x0D00	
ICSS_INTC_SIPR2	.set	0x0D04	
ICSS_INTC_SITR1	.set	0x0D80	
ICSS_INTC_SITR2	.set	0x0D84	
ICSS_INTC_HINLR1	.set	0x1100	
ICSS_INTC_HINLR2	.set	0x1104	
ICSS_INTC_HINLR3	.set	0x1108	
ICSS_INTC_HINLR4	.set	0x110C	
ICSS_INTC_HINLR5	.set	0x1110	
ICSS_INTC_HINLR6	.set	0x1114	
ICSS_INTC_HINLR7	.set	0x1118	
ICSS_INTC_HINLR8	.set	0x111C	
ICSS_INTC_HINLR9	.set	0x1120	
ICSS_INTC_HINLR10	.set	0x1124	
ICSS_INTC_HIER	.set	0x1500	
	
	.endif	;__icss_intc_regs_h
