//----------------------------------------------------------------------------------
//	FILE:			SolarMicroInv_F2803x-Main.C
//
//	Description:	Solar MicroInverter Project
//
//	Version: 		1.0
//
//  Target:  		TMS320F2803x(PiccoloB), 
//
//----------------------------------------------------------------------------------
//  Copyright Texas Instruments  2004-2013
//----------------------------------------------------------------------------------
//  Revision History:
//----------------------------------------------------------------------------------
//  Date	  | Description / Status
//----------------------------------------------------------------------------------
// June 26 2013 :  (Manish Bhardwaj, Shamim Choudhury)
//----------------------------------------------------------------------------------
//
// PLEASE READ - Useful notes about this Project
// Although this project is made up of several files, the most important ones are:
//	 "{ProjectName}-Main.C"	- this file
//		- Application Initialization, Peripheral config,
//		- Application management
//		- Slower background code loops and Task scheduling
//	 "{ProjectName}-DevInit_F28xxx.C
//		- Device Initialization, e.g. Clock, PLL, WD, GPIO mapping
//		- Peripheral clock enables
//		- DevInit file will differ per each F28xxx device series, e.g. F280x, F2833x,
//	 "{ProjectName}-Settings.h"
//		- Global defines (settings) project selections are found here
//		- This file is referenced by both C and ASM files.
//	 "{ProjectName}-Includes.h"
//		- Include file used by project are defined in this file
//
// Code is made up of sections, e.g. "FUNCTION PROTOTYPES", "VARIABLE DECLARATIONS" ,..etc
//	each section has FRAMEWORK and USER areas.
//  FRAMEWORK areas provide useful ready made "infrastructure" code which for the most part
//	does not need modification, e.g. Task scheduling, ISR call, GUI interface support,...etc
//  USER areas have functional example code which can be modified by USER to fit their appl.
//
// Code can be compiled with various build options (Incremental Builds IBx), these
//  options are selected in file "{ProjectName}-Settings.h".  Note: "Rebuild All" compile
//  tool bar button must be used if this file is modified.
//----------------------------------------------------------------------------------

//======================================================================================
// ======================================================================================
// Include files
// ======================================================================================

/*****************************************************************************/
/* STDINT.H v6.4.3                                                           */
/*                                                                           */
/* Copyright (c) 2002-2015 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/

/* 7.18.1.1 Exact-width integer types */

    typedef          int    int16_t;
    typedef unsigned int   uint16_t;
    typedef          long   int32_t;
    typedef unsigned long  uint32_t;


    typedef          long long  int64_t;
    typedef unsigned long long uint64_t;

/* 7.18.1.2 Minimum-width integer types */

    typedef  int16_t  int_least8_t;
    typedef uint16_t uint_least8_t;

    typedef  int16_t  int_least16_t;
    typedef uint16_t uint_least16_t;
    typedef  int32_t  int_least32_t;
    typedef uint32_t uint_least32_t;


    typedef  int64_t  int_least64_t;
    typedef uint64_t uint_least64_t;

/* 7.18.1.3 Fastest minimum-width integer types */

    typedef  int16_t  int_fast8_t;
    typedef uint16_t uint_fast8_t;
    typedef  int16_t  int_fast16_t;
    typedef uint16_t uint_fast16_t;

    typedef  int32_t  int_fast32_t;
    typedef uint32_t uint_fast32_t;


    typedef  int64_t  int_fast64_t;
    typedef uint64_t uint_fast64_t;

/* 7.18.1.4 Integer types capable of holding object pointers */
    typedef          long intptr_t;
    typedef unsigned long uintptr_t;

/* 7.18.1.5 Greatest-width integer types */
    typedef          long long intmax_t;
    typedef unsigned long long uintmax_t;

/* 
   According to footnotes in the 1999 C standard, "C++ implementations
   should define these macros only when __STDC_LIMIT_MACROS is defined
   before <stdint.h> is included." 
*/

/* 7.18.2 Limits of specified width integer types */
















/* 7.18.3 Limits of other integer types */







/* 7.18.4.1 Macros for minimum-width integer constants */

/*
   There is a defect report filed against the C99 standard concerning how 
   the (U)INTN_C macros should be implemented.  Please refer to --
   http://wwwold.dkuug.dk/JTC1/SC22/WG14/www/docs/dr_209.htm 
   for more information.  These macros are implemented according to the
   suggestion given at this web site.
*/




/* 7.18.4.2 Macros for greatest-width integer constants */



/*****************************************************************************/
/* string.h   v6.4.3                                                         */
/*                                                                           */
/* Copyright (c) 1993-2015 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/



#pragma diag_push
#pragma CHECK_MISRA("-6.3") /* standard types required for standard headers */
#pragma CHECK_MISRA("-19.1") /* #includes required for implementation */

 

typedef unsigned long size_t;

/*****************************************************************************/
/* linkage.h   v6.4.3                                                         */
/*                                                                           */
/* Copyright (c) 1998-2015 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


#pragma diag_push
#pragma CHECK_MISRA("-19.4") /* macros required for implementation */

/* No modifiers needed to access code */


/*--------------------------------------------------------------------------*/
/* Define _DATA_ACCESS ==> how to access RTS global or static data          */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* Define _OPTIMIZE_FOR_SPACE ==> Always optimize for space.                */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* Define _IDECL ==> how inline functions are declared                      */
/*--------------------------------------------------------------------------*/

#pragma diag_pop


#pragma diag_push
#pragma CHECK_MISRA("-19.4") /* macros required for implementation */


#pragma diag_pop

 size_t  strlen(const char *string);

 char *strcpy(char *dest, const char *src);
 char *strncpy(char *dest, const char *src, size_t n);
 char *strcat(char *string1, const char *string2);
 char *strncat(char *dest, const char *src, size_t n);
 char *strchr(const char *string, int c);
 char *strrchr(const char *string, int c);

 int  strcmp(const char *string1, const char *string2);
 int  strncmp(const char *string1, const char *string2, size_t n);

 int     strcoll(const char *string1, const char *_string2);
 size_t  strxfrm(char *to, const char *from, size_t n);
 char   *strpbrk(const char *string, const char *chs);
 size_t  strspn(const char *string, const char *chs);
 size_t  strcspn(const char *string, const char *chs);
 char   *strstr(const char *string1, const char *string2);
 char   *strtok(char *str1, const char *str2);
 char   *strerror(int _errno);
 char   *strdup(const char *string);


 void   *memmove(void *s1, const void *s2, size_t n);

 int     memcmp(const void *cs, const void *ct, size_t n);
 void   *memchr(const void *cs, int c, size_t n);

   void   *memset(void *mem, int ch, size_t length);



#pragma diag_push

/* keep macros as direct #defines and not function-like macros or function
   names surrounded by parentheses to support all original supported use cases
   including taking their address through the macros and prefixing with
   namespace macros */
#pragma CHECK_MISRA("-19.4")

#pragma diag_pop

size_t    far_strlen(const char *s);
char     *strcpy_nf(char *s1, const char *s2);
char *strcpy_fn(char *s1, const char *s2);
char *strcpy_ff(char *s1, const char *s2);
char *far_strncpy(char *s1, const char *s2, size_t n);
char *far_strcat(char *s1, const char *s2);
char *far_strncat(char *s1, const char *s2, size_t n);
char *far_strchr(const char *s, int c);
char *far_strrchr(const char *s, int c);
int       far_strcmp(const char *s1, const char *s2);
int       far_strncmp(const char *s1, const char *s2, size_t n);
int       far_strcoll(const char *s1, const char *s2);
size_t    far_strxfrm(char *s1, const char *s2, size_t n);
char *far_strpbrk(const char *s1, const char *s2);
size_t    far_strspn(const char *s1, const char *s2);
size_t    far_strcspn(const char *s1, const char *s2);
char *far_strstr(const char *s1, const char *s2);
char *far_strtok(char *s1, const char *s2);
char *far_strerror(int _errno);
void *far_memmove(void *s1, const void *s2, size_t n);
void     *__memcpy_nf (void *_s1, const void *_s2, size_t _n);
void *__memcpy_fn (void *_s1, const void *_s2, size_t _n);
void *__memcpy_ff (void *_s1, const void *_s2, size_t _n);
int       far_memcmp(const void *s1, const void *s2, size_t n);
void *far_memchr(const void *s, int c, size_t n);
void *far_memset(void *s, int c, size_t n);
void *far_memlcpy(void *to, const void *from,
                        unsigned long n);
void *far_memlmove(void *to, const void *from,
                         unsigned long n);






#pragma diag_pop


#pragma diag_push

/* using declarations must occur outside header guard to support including both
   C and C++-wrapped version of header; see _CPP_STYLE_HEADER check */
/* this code is for C++ mode only and thus also not relevant for MISRA */
#pragma CHECK_MISRA("-19.15")


#pragma diag_pop
// Include the IQmath Library First, define Global Q
// TI File $Revision: /main/7 $
// Checkin $Date: July 29, 2011   11:03:53 $
//###########################################################################
//
// FILE:    IQmathLib.h
//
// TITLE:   IQ Math library functions definitions.
//
//###########################################################################
//
// Ver  | dd-mmm-yyyy |  Who  | Description of changes
// =====|=============|=======|==============================================
//  1.3 | 19 Nov 2001 | A. T. | Original Release.
// -----|-------------|-------|----------------------------------------------
//  1.4 | 17 May 2002 | A. T. | Added new functions and support for
//      |             |       | intrinsics IQmpy, IQxmpy, IQsat.
// -----|-------------|-------|----------------------------------------------
//  1.4a| 12 Jun 2002 | A. T. | Fixed problem with _IQ() operation on
//      |             |       | variables.
// -----|-------------|-------|----------------------------------------------
//  1.4b| 18 Jun 2002 | A. T. | Fixed bug with _IQtoIQN() and _IQNtoIQ()
//      |             |       | operations.
// -----|-------------|-------|----------------------------------------------
//  1.4d| 30 Mar 2003 | DA/SD | 1. Added macro parameters in parentheses
//      |             |       |    in number of places where it matters
//      |             |       | 2. Added macro definition to include header
//      |             |       |    file multiple times in the program.
// -----|-------------|-------|----------------------------------------------
//  1.4e| 17 Jun 2004 | AT/DA | Added IQexp function.
//      |             |       | Added IQasin & IQacos functions (thanks DA).
// -----|-------------|-------|----------------------------------------------
//  1.4f| 10 Mar 2005 | AT    | Fixed Bug In IQexp function.
// -----|-------------|-------|----------------------------------------------
//  1.5 | 30 Jan 2008 | LH    | 1. Changed the definion of the _IQatan2PU(A,B)
//      |             |       |    macro for FLOAT_MATH so that a call to
//      |             |       |    divide will not occur.
//      |             |       | 2. If MATH_TYPE == FLOAT_MATH, then include the
//      |             |       |    following standard headers: math.h
//      |             |       |    stdlib.h.
//      |             |       | 3. Added missing #defines for the non-global
//      |             |       |    _IQatanN() function
//      |             |       | 4. Adding missing definitions for absolute
//      |             |       |    value when MATH_TYPE == FLOAT_MATH
//      |             |       | 5. Included limits.h and changed the definition
//      |             |       |    of MAX_IQ_NEG to LONG_MIN and MAX_IQ_POS
//      |             |       |    to LONG_MAX
// -----|-------------|-------|----------------------------------------------
//  1.5c| 8 June 2010 |  LH   | Changes made to improve porting between IQ and
//      |             |       | and float.
//      |             |       |
//      |             |       | 1. Added left shift and right shift #defines
//      |             |       |    for multiplying and dividing by power of
//      |             |       |    2 (up to 64) for IQ_MATH
//      |             |       |
//      |             |       | 2. Added corresponding multiply/divide #defines
//      |             |       |    for powers of 2 (up to 64) for FLOAT_MATH
//      |             |       |
//      |             |       | 3. FLOAT_MATH: Corrected the #defines for
//      |             |       |    conversion from IQ to Q15
//      |             |       |
//      |             |       |    a) removed the L on the constant to avoid
//      |             |       |       the 64-bit float multiply call to the
//      |             |       |       runtime support library.
//      |             |       |    b) removed the conversion from float to
//      |             |       |       int before the multiply.  This prevented
//      |             |       |       native floating point from being used.
//      |             |       |
//      |             |       | 4. FLOAT_MATH: Modified IQdiv and IQNdiv macros t
//      |             |       |    such that the arguments are cast to float before
//      |             |       |    he division.
//      |             |       |
//      |             |       |    In some cases the IQ_MATH verion was used to
//      |             |       |    divide an _iq type by an int32, which works fine.
//      |             |       |
//      |             |       |    This change will allow the FLOAT_TYPE macros to
//      |             |       |    to also be used with integer types, and not
//      |             |       |    just "_iq" (i.e. float) types.
//      |             |       |
//      |             |       | 5. FLOAT_MATH: Changed the definition of sat for float
//      |             |       |    math.  This new definition uses compiler intrinsics and
//      |             |       |    requires codegen tools V5.2.2 or later
//      |             |       |    The previous definition can be uncommented
//      |             |       |    if needed for previous versions of the codegen tools
//      |             |       |    however it will not be efficient.
// -----|-------------|-------|----------------------------------------------
// 1.6.0| August 2011 |       | Added LOG function
// -----|-------------|-------|----------------------------------------------
//###########################################################################
// $TI Release: Release 1.5c $
// $Release Date: June 8, 2010 $
//###########################################################################
//
// User needs to configure "MATH_TYPE" and "GLOBAL_Q" values:
//
//---------------------------------------------------------------------------
// Select math type, IQ_MATH or FLOAT_MATH:
//





//---------------------------------------------------------------------------
// Select global Q value and scaling. The Q value is limited to the
// following range for all functions:
//
//        30 <= GLOBAL_Q <=  1
//

//---------------------------------------------------------------------------
// If using FLOAT_MATH, include standard headers to avoid conversion issues
//
/*****************************************************************************/
/* limits.h   v6.4.3                                                         */
/*                                                                           */
/* Copyright (c) 1996-2015 Texas Instruments Incorporated                    */
/* http://www.ti.com/                                                        */
/*                                                                           */
/*  Redistribution and  use in source  and binary forms, with  or without    */
/*  modification,  are permitted provided  that the  following conditions    */
/*  are met:                                                                 */
/*                                                                           */
/*     Redistributions  of source  code must  retain the  above copyright    */
/*     notice, this list of conditions and the following disclaimer.         */
/*                                                                           */
/*     Redistributions in binary form  must reproduce the above copyright    */
/*     notice, this  list of conditions  and the following  disclaimer in    */
/*     the  documentation  and/or   other  materials  provided  with  the    */
/*     distribution.                                                         */
/*                                                                           */
/*     Neither the  name of Texas Instruments Incorporated  nor the names    */
/*     of its  contributors may  be used to  endorse or  promote products    */
/*     derived  from   this  software  without   specific  prior  written    */
/*     permission.                                                           */
/*                                                                           */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS    */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT    */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR    */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT    */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,    */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT    */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE    */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.     */
/*                                                                           */
/*****************************************************************************/


#pragma diag_push
#pragma CHECK_MISRA("-20.1") /* standard headers must define standard names */

 
 









#pragma diag_pop


//---------------------------------------------------------------------------
// Various Usefull Constant Definitions:
//


//###########################################################################
//###########################################################################
// If IQ_MATH is used, the following IQmath library function definitions
// are used:
//===========================================================================
typedef   long    _iq;
typedef   long    _iq30;
typedef   long    _iq29;
typedef   long    _iq28;
typedef   long    _iq27;
typedef   long    _iq26;
typedef   long    _iq25;
typedef   long    _iq24;
typedef   long    _iq23;
typedef   long    _iq22;
typedef   long    _iq21;
typedef   long    _iq20;
typedef   long    _iq19;
typedef   long    _iq18;
typedef   long    _iq17;
typedef   long    _iq16;
typedef   long    _iq15;
typedef   long    _iq14;
typedef   long    _iq13;
typedef   long    _iq12;
typedef   long    _iq11;
typedef   long    _iq10;
typedef   long    _iq9;
typedef   long    _iq8;
typedef   long    _iq7;
typedef   long    _iq6;
typedef   long    _iq5;
typedef   long    _iq4;
typedef   long    _iq3;
typedef   long    _iq2;
typedef   long    _iq1;
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
extern    float _IQ30toF(long A);
extern    float _IQ29toF(long A);
extern    float _IQ28toF(long A);
extern    float _IQ27toF(long A);
extern    float _IQ26toF(long A);
extern    float _IQ25toF(long A);
extern    float _IQ24toF(long A);
extern    float _IQ23toF(long A);
extern    float _IQ22toF(long A);
extern    float _IQ21toF(long A);
extern    float _IQ20toF(long A);
extern    float _IQ19toF(long A);
extern    float _IQ18toF(long A);
extern    float _IQ17toF(long A);
extern    float _IQ16toF(long A);
extern    float _IQ15toF(long A);
extern    float _IQ14toF(long A);
extern    float _IQ13toF(long A);
extern    float _IQ12toF(long A);
extern    float _IQ11toF(long A);
extern    float _IQ10toF(long A);
extern    float _IQ9toF(long A);
extern    float _IQ8toF(long A);
extern    float _IQ7toF(long A);
extern    float _IQ6toF(long A);
extern    float _IQ5toF(long A);
extern    float _IQ4toF(long A);
extern    float _IQ3toF(long A);
extern    float _IQ2toF(long A);
extern    float _IQ1toF(long A);

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------






























//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
extern    long _IQ30rmpy(long A, long B);
extern    long _IQ29rmpy(long A, long B);
extern    long _IQ28rmpy(long A, long B);
extern    long _IQ27rmpy(long A, long B);
extern    long _IQ26rmpy(long A, long B);
extern    long _IQ25rmpy(long A, long B);
extern    long _IQ24rmpy(long A, long B);
extern    long _IQ23rmpy(long A, long B);
extern    long _IQ22rmpy(long A, long B);
extern    long _IQ21rmpy(long A, long B);
extern    long _IQ20rmpy(long A, long B);
extern    long _IQ19rmpy(long A, long B);
extern    long _IQ18rmpy(long A, long B);
extern    long _IQ17rmpy(long A, long B);
extern    long _IQ16rmpy(long A, long B);
extern    long _IQ15rmpy(long A, long B);
extern    long _IQ14rmpy(long A, long B);
extern    long _IQ13rmpy(long A, long B);
extern    long _IQ12rmpy(long A, long B);
extern    long _IQ11rmpy(long A, long B);
extern    long _IQ10rmpy(long A, long B);
extern    long _IQ9rmpy(long A, long B);
extern    long _IQ8rmpy(long A, long B);
extern    long _IQ7rmpy(long A, long B);
extern    long _IQ6rmpy(long A, long B);
extern    long _IQ5rmpy(long A, long B);
extern    long _IQ4rmpy(long A, long B);
extern    long _IQ3rmpy(long A, long B);
extern    long _IQ2rmpy(long A, long B);
extern    long _IQ1rmpy(long A, long B);

//---------------------------------------------------------------------------
extern    long _IQ30rsmpy(long A, long B);
extern    long _IQ29rsmpy(long A, long B);
extern    long _IQ28rsmpy(long A, long B);
extern    long _IQ27rsmpy(long A, long B);
extern    long _IQ26rsmpy(long A, long B);
extern    long _IQ25rsmpy(long A, long B);
extern    long _IQ24rsmpy(long A, long B);
extern    long _IQ23rsmpy(long A, long B);
extern    long _IQ22rsmpy(long A, long B);
extern    long _IQ21rsmpy(long A, long B);
extern    long _IQ20rsmpy(long A, long B);
extern    long _IQ19rsmpy(long A, long B);
extern    long _IQ18rsmpy(long A, long B);
extern    long _IQ17rsmpy(long A, long B);
extern    long _IQ16rsmpy(long A, long B);
extern    long _IQ15rsmpy(long A, long B);
extern    long _IQ14rsmpy(long A, long B);
extern    long _IQ13rsmpy(long A, long B);
extern    long _IQ12rsmpy(long A, long B);
extern    long _IQ11rsmpy(long A, long B);
extern    long _IQ10rsmpy(long A, long B);
extern    long _IQ9rsmpy(long A, long B);
extern    long _IQ8rsmpy(long A, long B);
extern    long _IQ7rsmpy(long A, long B);
extern    long _IQ6rsmpy(long A, long B);
extern    long _IQ5rsmpy(long A, long B);
extern    long _IQ4rsmpy(long A, long B);
extern    long _IQ3rsmpy(long A, long B);
extern    long _IQ2rsmpy(long A, long B);
extern    long _IQ1rsmpy(long A, long B);

//---------------------------------------------------------------------------
extern    long _IQ30div(long A, long B);
extern    long _IQ29div(long A, long B);
extern    long _IQ28div(long A, long B);
extern    long _IQ27div(long A, long B);
extern    long _IQ26div(long A, long B);
extern    long _IQ25div(long A, long B);
extern    long _IQ24div(long A, long B);
extern    long _IQ23div(long A, long B);
extern    long _IQ22div(long A, long B);
extern    long _IQ21div(long A, long B);
extern    long _IQ20div(long A, long B);
extern    long _IQ19div(long A, long B);
extern    long _IQ18div(long A, long B);
extern    long _IQ17div(long A, long B);
extern    long _IQ16div(long A, long B);
extern    long _IQ15div(long A, long B);
extern    long _IQ14div(long A, long B);
extern    long _IQ13div(long A, long B);
extern    long _IQ12div(long A, long B);
extern    long _IQ11div(long A, long B);
extern    long _IQ10div(long A, long B);
extern    long _IQ9div(long A, long B);
extern    long _IQ8div(long A, long B);
extern    long _IQ7div(long A, long B);
extern    long _IQ6div(long A, long B);
extern    long _IQ5div(long A, long B);
extern    long _IQ4div(long A, long B);
extern    long _IQ3div(long A, long B);
extern    long _IQ2div(long A, long B);
extern    long _IQ1div(long A, long B);

//---------------------------------------------------------------------------
extern    long _IQ30sin(long A);
extern    long _IQ29sin(long A);
extern    long _IQ28sin(long A);
extern    long _IQ27sin(long A);
extern    long _IQ26sin(long A);
extern    long _IQ25sin(long A);
extern    long _IQ24sin(long A);
extern    long _IQ23sin(long A);
extern    long _IQ22sin(long A);
extern    long _IQ21sin(long A);
extern    long _IQ20sin(long A);
extern    long _IQ19sin(long A);
extern    long _IQ18sin(long A);
extern    long _IQ17sin(long A);
extern    long _IQ16sin(long A);
extern    long _IQ15sin(long A);
extern    long _IQ14sin(long A);
extern    long _IQ13sin(long A);
extern    long _IQ12sin(long A);
extern    long _IQ11sin(long A);
extern    long _IQ10sin(long A);
extern    long _IQ9sin(long A);
extern    long _IQ8sin(long A);
extern    long _IQ7sin(long A);
extern    long _IQ6sin(long A);
extern    long _IQ5sin(long A);
extern    long _IQ4sin(long A);
extern    long _IQ3sin(long A);
extern    long _IQ2sin(long A);
extern    long _IQ1sin(long A);

//---------------------------------------------------------------------------
extern    long _IQ30sinPU(long A);
extern    long _IQ29sinPU(long A);
extern    long _IQ28sinPU(long A);
extern    long _IQ27sinPU(long A);
extern    long _IQ26sinPU(long A);
extern    long _IQ25sinPU(long A);
extern    long _IQ24sinPU(long A);
extern    long _IQ23sinPU(long A);
extern    long _IQ22sinPU(long A);
extern    long _IQ21sinPU(long A);
extern    long _IQ20sinPU(long A);
extern    long _IQ19sinPU(long A);
extern    long _IQ18sinPU(long A);
extern    long _IQ17sinPU(long A);
extern    long _IQ16sinPU(long A);
extern    long _IQ15sinPU(long A);
extern    long _IQ14sinPU(long A);
extern    long _IQ13sinPU(long A);
extern    long _IQ12sinPU(long A);
extern    long _IQ11sinPU(long A);
extern    long _IQ10sinPU(long A);
extern    long _IQ9sinPU(long A);
extern    long _IQ8sinPU(long A);
extern    long _IQ7sinPU(long A);
extern    long _IQ6sinPU(long A);
extern    long _IQ5sinPU(long A);
extern    long _IQ4sinPU(long A);
extern    long _IQ3sinPU(long A);
extern    long _IQ2sinPU(long A);
extern    long _IQ1sinPU(long A);

//---------------------------------------------------------------------------
extern    long _IQ30asin(long A);
extern    long _IQ29asin(long A);
extern    long _IQ28asin(long A);
extern    long _IQ27asin(long A);
extern    long _IQ26asin(long A);
extern    long _IQ25asin(long A);
extern    long _IQ24asin(long A);
extern    long _IQ23asin(long A);
extern    long _IQ22asin(long A);
extern    long _IQ21asin(long A);
extern    long _IQ20asin(long A);
extern    long _IQ19asin(long A);
extern    long _IQ18asin(long A);
extern    long _IQ17asin(long A);
extern    long _IQ16asin(long A);
extern    long _IQ15asin(long A);
extern    long _IQ14asin(long A);
extern    long _IQ13asin(long A);
extern    long _IQ12asin(long A);
extern    long _IQ11asin(long A);
extern    long _IQ10asin(long A);
extern    long _IQ9asin(long A);
extern    long _IQ8asin(long A);
extern    long _IQ7asin(long A);
extern    long _IQ6asin(long A);
extern    long _IQ5asin(long A);
extern    long _IQ4asin(long A);
extern    long _IQ3asin(long A);
extern    long _IQ2asin(long A);
extern    long _IQ1asin(long A);

//---------------------------------------------------------------------------
extern    long _IQ30cos(long A);
extern    long _IQ29cos(long A);
extern    long _IQ28cos(long A);
extern    long _IQ27cos(long A);
extern    long _IQ26cos(long A);
extern    long _IQ25cos(long A);
extern    long _IQ24cos(long A);
extern    long _IQ23cos(long A);
extern    long _IQ22cos(long A);
extern    long _IQ21cos(long A);
extern    long _IQ20cos(long A);
extern    long _IQ19cos(long A);
extern    long _IQ18cos(long A);
extern    long _IQ17cos(long A);
extern    long _IQ16cos(long A);
extern    long _IQ15cos(long A);
extern    long _IQ14cos(long A);
extern    long _IQ13cos(long A);
extern    long _IQ12cos(long A);
extern    long _IQ11cos(long A);
extern    long _IQ10cos(long A);
extern    long _IQ9cos(long A);
extern    long _IQ8cos(long A);
extern    long _IQ7cos(long A);
extern    long _IQ6cos(long A);
extern    long _IQ5cos(long A);
extern    long _IQ4cos(long A);
extern    long _IQ3cos(long A);
extern    long _IQ2cos(long A);
extern    long _IQ1cos(long A);

//---------------------------------------------------------------------------
extern    long _IQ30cosPU(long A);
extern    long _IQ29cosPU(long A);
extern    long _IQ28cosPU(long A);
extern    long _IQ27cosPU(long A);
extern    long _IQ26cosPU(long A);
extern    long _IQ25cosPU(long A);
extern    long _IQ24cosPU(long A);
extern    long _IQ23cosPU(long A);
extern    long _IQ22cosPU(long A);
extern    long _IQ21cosPU(long A);
extern    long _IQ20cosPU(long A);
extern    long _IQ19cosPU(long A);
extern    long _IQ18cosPU(long A);
extern    long _IQ17cosPU(long A);
extern    long _IQ16cosPU(long A);
extern    long _IQ15cosPU(long A);
extern    long _IQ14cosPU(long A);
extern    long _IQ13cosPU(long A);
extern    long _IQ12cosPU(long A);
extern    long _IQ11cosPU(long A);
extern    long _IQ10cosPU(long A);
extern    long _IQ9cosPU(long A);
extern    long _IQ8cosPU(long A);
extern    long _IQ7cosPU(long A);
extern    long _IQ6cosPU(long A);
extern    long _IQ5cosPU(long A);
extern    long _IQ4cosPU(long A);
extern    long _IQ3cosPU(long A);
extern    long _IQ2cosPU(long A);
extern    long _IQ1cosPU(long A);

//---------------------------------------------------------------------------
extern    long _IQ30acos(long A);
extern    long _IQ29acos(long A);
extern    long _IQ28acos(long A);
extern    long _IQ27acos(long A);
extern    long _IQ26acos(long A);
extern    long _IQ25acos(long A);
extern    long _IQ24acos(long A);
extern    long _IQ23acos(long A);
extern    long _IQ22acos(long A);
extern    long _IQ21acos(long A);
extern    long _IQ20acos(long A);
extern    long _IQ19acos(long A);
extern    long _IQ18acos(long A);
extern    long _IQ17acos(long A);
extern    long _IQ16acos(long A);
extern    long _IQ15acos(long A);
extern    long _IQ14acos(long A);
extern    long _IQ13acos(long A);
extern    long _IQ12acos(long A);
extern    long _IQ11acos(long A);
extern    long _IQ10acos(long A);
extern    long _IQ9acos(long A);
extern    long _IQ8acos(long A);
extern    long _IQ7acos(long A);
extern    long _IQ6acos(long A);
extern    long _IQ5acos(long A);
extern    long _IQ4acos(long A);
extern    long _IQ3acos(long A);
extern    long _IQ2acos(long A);
extern    long _IQ1acos(long A);

//---------------------------------------------------------------------------
extern    long _IQ30atan2(long A, long B);
extern    long _IQ29atan2(long A, long B);
extern    long _IQ28atan2(long A, long B);
extern    long _IQ27atan2(long A, long B);
extern    long _IQ26atan2(long A, long B);
extern    long _IQ25atan2(long A, long B);
extern    long _IQ24atan2(long A, long B);
extern    long _IQ23atan2(long A, long B);
extern    long _IQ22atan2(long A, long B);
extern    long _IQ21atan2(long A, long B);
extern    long _IQ20atan2(long A, long B);
extern    long _IQ19atan2(long A, long B);
extern    long _IQ18atan2(long A, long B);
extern    long _IQ17atan2(long A, long B);
extern    long _IQ16atan2(long A, long B);
extern    long _IQ15atan2(long A, long B);
extern    long _IQ14atan2(long A, long B);
extern    long _IQ13atan2(long A, long B);
extern    long _IQ12atan2(long A, long B);
extern    long _IQ11atan2(long A, long B);
extern    long _IQ10atan2(long A, long B);
extern    long _IQ9atan2(long A, long B);
extern    long _IQ8atan2(long A, long B);
extern    long _IQ7atan2(long A, long B);
extern    long _IQ6atan2(long A, long B);
extern    long _IQ5atan2(long A, long B);
extern    long _IQ4atan2(long A, long B);
extern    long _IQ3atan2(long A, long B);
extern    long _IQ2atan2(long A, long B);
extern    long _IQ1atan2(long A, long B);

//---------------------------------------------------------------------------
extern    long _IQ30atan2PU(long A, long B);
extern    long _IQ29atan2PU(long A, long B);
extern    long _IQ28atan2PU(long A, long B);
extern    long _IQ27atan2PU(long A, long B);
extern    long _IQ26atan2PU(long A, long B);
extern    long _IQ25atan2PU(long A, long B);
extern    long _IQ24atan2PU(long A, long B);
extern    long _IQ23atan2PU(long A, long B);
extern    long _IQ22atan2PU(long A, long B);
extern    long _IQ21atan2PU(long A, long B);
extern    long _IQ20atan2PU(long A, long B);
extern    long _IQ19atan2PU(long A, long B);
extern    long _IQ18atan2PU(long A, long B);
extern    long _IQ17atan2PU(long A, long B);
extern    long _IQ16atan2PU(long A, long B);
extern    long _IQ15atan2PU(long A, long B);
extern    long _IQ14atan2PU(long A, long B);
extern    long _IQ13atan2PU(long A, long B);
extern    long _IQ12atan2PU(long A, long B);
extern    long _IQ11atan2PU(long A, long B);
extern    long _IQ10atan2PU(long A, long B);
extern    long _IQ9atan2PU(long A, long B);
extern    long _IQ8atan2PU(long A, long B);
extern    long _IQ7atan2PU(long A, long B);
extern    long _IQ6atan2PU(long A, long B);
extern    long _IQ5atan2PU(long A, long B);
extern    long _IQ4atan2PU(long A, long B);
extern    long _IQ3atan2PU(long A, long B);
extern    long _IQ2atan2PU(long A, long B);
extern    long _IQ1atan2PU(long A, long B);

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
extern    long _IQ30sqrt(long A);
extern    long _IQ29sqrt(long A);
extern    long _IQ28sqrt(long A);
extern    long _IQ27sqrt(long A);
extern    long _IQ26sqrt(long A);
extern    long _IQ25sqrt(long A);
extern    long _IQ24sqrt(long A);
extern    long _IQ23sqrt(long A);
extern    long _IQ22sqrt(long A);
extern    long _IQ21sqrt(long A);
extern    long _IQ20sqrt(long A);
extern    long _IQ19sqrt(long A);
extern    long _IQ18sqrt(long A);
extern    long _IQ17sqrt(long A);
extern    long _IQ16sqrt(long A);
extern    long _IQ15sqrt(long A);
extern    long _IQ14sqrt(long A);
extern    long _IQ13sqrt(long A);
extern    long _IQ12sqrt(long A);
extern    long _IQ11sqrt(long A);
extern    long _IQ10sqrt(long A);
extern    long _IQ9sqrt(long A);
extern    long _IQ8sqrt(long A);
extern    long _IQ7sqrt(long A);
extern    long _IQ6sqrt(long A);
extern    long _IQ5sqrt(long A);
extern    long _IQ4sqrt(long A);
extern    long _IQ3sqrt(long A);
extern    long _IQ2sqrt(long A);
extern    long _IQ1sqrt(long A);

//---------------------------------------------------------------------------
extern    long _IQ30isqrt(long A);
extern    long _IQ29isqrt(long A);
extern    long _IQ28isqrt(long A);
extern    long _IQ27isqrt(long A);
extern    long _IQ26isqrt(long A);
extern    long _IQ25isqrt(long A);
extern    long _IQ24isqrt(long A);
extern    long _IQ23isqrt(long A);
extern    long _IQ22isqrt(long A);
extern    long _IQ21isqrt(long A);
extern    long _IQ20isqrt(long A);
extern    long _IQ19isqrt(long A);
extern    long _IQ18isqrt(long A);
extern    long _IQ17isqrt(long A);
extern    long _IQ16isqrt(long A);
extern    long _IQ15isqrt(long A);
extern    long _IQ14isqrt(long A);
extern    long _IQ13isqrt(long A);
extern    long _IQ12isqrt(long A);
extern    long _IQ11isqrt(long A);
extern    long _IQ10isqrt(long A);
extern    long _IQ9isqrt(long A);
extern    long _IQ8isqrt(long A);
extern    long _IQ7isqrt(long A);
extern    long _IQ6isqrt(long A);
extern    long _IQ5isqrt(long A);
extern    long _IQ4isqrt(long A);
extern    long _IQ3isqrt(long A);
extern    long _IQ2isqrt(long A);
extern    long _IQ1isqrt(long A);

//---------------------------------------------------------------------------
extern    long _IQ30exp(long A);
extern    long _IQ29exp(long A);
extern    long _IQ28exp(long A);
extern    long _IQ27exp(long A);
extern    long _IQ26exp(long A);
extern    long _IQ25exp(long A);
extern    long _IQ24exp(long A);
extern    long _IQ23exp(long A);
extern    long _IQ22exp(long A);
extern    long _IQ21exp(long A);
extern    long _IQ20exp(long A);
extern    long _IQ19exp(long A);
extern    long _IQ18exp(long A);
extern    long _IQ17exp(long A);
extern    long _IQ16exp(long A);
extern    long _IQ15exp(long A);
extern    long _IQ14exp(long A);
extern    long _IQ13exp(long A);
extern    long _IQ12exp(long A);
extern    long _IQ11exp(long A);
extern    long _IQ10exp(long A);
extern    long _IQ9exp(long A);
extern    long _IQ8exp(long A);
extern    long _IQ7exp(long A);
extern    long _IQ6exp(long A);
extern    long _IQ5exp(long A);
extern    long _IQ4exp(long A);
extern    long _IQ3exp(long A);
extern    long _IQ2exp(long A);
extern    long _IQ1exp(long A);

//---------------------------------------------------------------------------
extern    long _IQ30int(long A);
extern    long _IQ29int(long A);
extern    long _IQ28int(long A);
extern    long _IQ27int(long A);
extern    long _IQ26int(long A);
extern    long _IQ25int(long A);
extern    long _IQ24int(long A);
extern    long _IQ23int(long A);
extern    long _IQ22int(long A);
extern    long _IQ21int(long A);
extern    long _IQ20int(long A);
extern    long _IQ19int(long A);
extern    long _IQ18int(long A);
extern    long _IQ17int(long A);
extern    long _IQ16int(long A);
extern    long _IQ15int(long A);
extern    long _IQ14int(long A);
extern    long _IQ13int(long A);
extern    long _IQ12int(long A);
extern    long _IQ11int(long A);
extern    long _IQ10int(long A);
extern    long _IQ9int(long A);
extern    long _IQ8int(long A);
extern    long _IQ7int(long A);
extern    long _IQ6int(long A);
extern    long _IQ5int(long A);
extern    long _IQ4int(long A);
extern    long _IQ3int(long A);
extern    long _IQ2int(long A);
extern    long _IQ1int(long A);

//---------------------------------------------------------------------------
extern    long _IQ30frac(long A);
extern    long _IQ29frac(long A);
extern    long _IQ28frac(long A);
extern    long _IQ27frac(long A);
extern    long _IQ26frac(long A);
extern    long _IQ25frac(long A);
extern    long _IQ24frac(long A);
extern    long _IQ23frac(long A);
extern    long _IQ22frac(long A);
extern    long _IQ21frac(long A);
extern    long _IQ20frac(long A);
extern    long _IQ19frac(long A);
extern    long _IQ18frac(long A);
extern    long _IQ17frac(long A);
extern    long _IQ16frac(long A);
extern    long _IQ15frac(long A);
extern    long _IQ14frac(long A);
extern    long _IQ13frac(long A);
extern    long _IQ12frac(long A);
extern    long _IQ11frac(long A);
extern    long _IQ10frac(long A);
extern    long _IQ9frac(long A);
extern    long _IQ8frac(long A);
extern    long _IQ7frac(long A);
extern    long _IQ6frac(long A);
extern    long _IQ5frac(long A);
extern    long _IQ4frac(long A);
extern    long _IQ3frac(long A);
extern    long _IQ2frac(long A);
extern    long _IQ1frac(long A);

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
extern    long _IQ30mpyI32int(long A, long B);
extern    long _IQ29mpyI32int(long A, long B);
extern    long _IQ28mpyI32int(long A, long B);
extern    long _IQ27mpyI32int(long A, long B);
extern    long _IQ26mpyI32int(long A, long B);
extern    long _IQ25mpyI32int(long A, long B);
extern    long _IQ24mpyI32int(long A, long B);
extern    long _IQ23mpyI32int(long A, long B);
extern    long _IQ22mpyI32int(long A, long B);
extern    long _IQ21mpyI32int(long A, long B);
extern    long _IQ20mpyI32int(long A, long B);
extern    long _IQ19mpyI32int(long A, long B);
extern    long _IQ18mpyI32int(long A, long B);
extern    long _IQ17mpyI32int(long A, long B);
extern    long _IQ16mpyI32int(long A, long B);
extern    long _IQ15mpyI32int(long A, long B);
extern    long _IQ14mpyI32int(long A, long B);
extern    long _IQ13mpyI32int(long A, long B);
extern    long _IQ12mpyI32int(long A, long B);
extern    long _IQ11mpyI32int(long A, long B);
extern    long _IQ10mpyI32int(long A, long B);
extern    long _IQ9mpyI32int(long A, long B);
extern    long _IQ8mpyI32int(long A, long B);
extern    long _IQ7mpyI32int(long A, long B);
extern    long _IQ6mpyI32int(long A, long B);
extern    long _IQ5mpyI32int(long A, long B);
extern    long _IQ4mpyI32int(long A, long B);
extern    long _IQ3mpyI32int(long A, long B);
extern    long _IQ2mpyI32int(long A, long B);
extern    long _IQ1mpyI32int(long A, long B);

//---------------------------------------------------------------------------
extern    long _IQ30mpyI32frac(long A, long B);
extern    long _IQ29mpyI32frac(long A, long B);
extern    long _IQ28mpyI32frac(long A, long B);
extern    long _IQ27mpyI32frac(long A, long B);
extern    long _IQ26mpyI32frac(long A, long B);
extern    long _IQ25mpyI32frac(long A, long B);
extern    long _IQ24mpyI32frac(long A, long B);
extern    long _IQ23mpyI32frac(long A, long B);
extern    long _IQ22mpyI32frac(long A, long B);
extern    long _IQ21mpyI32frac(long A, long B);
extern    long _IQ20mpyI32frac(long A, long B);
extern    long _IQ19mpyI32frac(long A, long B);
extern    long _IQ18mpyI32frac(long A, long B);
extern    long _IQ17mpyI32frac(long A, long B);
extern    long _IQ16mpyI32frac(long A, long B);
extern    long _IQ15mpyI32frac(long A, long B);
extern    long _IQ14mpyI32frac(long A, long B);
extern    long _IQ13mpyI32frac(long A, long B);
extern    long _IQ12mpyI32frac(long A, long B);
extern    long _IQ11mpyI32frac(long A, long B);
extern    long _IQ10mpyI32frac(long A, long B);
extern    long _IQ9mpyI32frac(long A, long B);
extern    long _IQ8mpyI32frac(long A, long B);
extern    long _IQ7mpyI32frac(long A, long B);
extern    long _IQ6mpyI32frac(long A, long B);
extern    long _IQ5mpyI32frac(long A, long B);
extern    long _IQ4mpyI32frac(long A, long B);
extern    long _IQ3mpyI32frac(long A, long B);
extern    long _IQ2mpyI32frac(long A, long B);
extern    long _IQ1mpyI32frac(long A, long B);

//---------------------------------------------------------------------------
extern    long _IQ30mag(long A, long B);
extern    long _IQ29mag(long A, long B);
extern    long _IQ28mag(long A, long B);
extern    long _IQ27mag(long A, long B);
extern    long _IQ26mag(long A, long B);
extern    long _IQ25mag(long A, long B);
extern    long _IQ24mag(long A, long B);
extern    long _IQ23mag(long A, long B);
extern    long _IQ22mag(long A, long B);
extern    long _IQ21mag(long A, long B);
extern    long _IQ20mag(long A, long B);
extern    long _IQ19mag(long A, long B);
extern    long _IQ18mag(long A, long B);
extern    long _IQ17mag(long A, long B);
extern    long _IQ16mag(long A, long B);
extern    long _IQ15mag(long A, long B);
extern    long _IQ14mag(long A, long B);
extern    long _IQ13mag(long A, long B);
extern    long _IQ12mag(long A, long B);
extern    long _IQ11mag(long A, long B);
extern    long _IQ10mag(long A, long B);
extern    long _IQ9mag(long A, long B);
extern    long _IQ8mag(long A, long B);
extern    long _IQ7mag(long A, long B);
extern    long _IQ6mag(long A, long B);
extern    long _IQ5mag(long A, long B);
extern    long _IQ4mag(long A, long B);
extern    long _IQ3mag(long A, long B);
extern    long _IQ2mag(long A, long B);
extern    long _IQ1mag(long A, long B);

//---------------------------------------------------------------------------
extern    long _atoIQN(const char *A, long q_value);
//---------------------------------------------------------------------------
extern    int __IQNtoa(char *A, const char *B, long C, int D);
extern    int _IQ30toa(char *A, const char *B, long C);
extern    int _IQ29toa(char *A, const char *B, long C);
extern    int _IQ28toa(char *A, const char *B, long C);
extern    int _IQ27toa(char *A, const char *B, long C);
extern    int _IQ26toa(char *A, const char *B, long C);
extern    int _IQ25toa(char *A, const char *B, long C);
extern    int _IQ24toa(char *A, const char *B, long C);
extern    int _IQ23toa(char *A, const char *B, long C);
extern    int _IQ22toa(char *A, const char *B, long C);
extern    int _IQ21toa(char *A, const char *B, long C);
extern    int _IQ20toa(char *A, const char *B, long C);
extern    int _IQ19toa(char *A, const char *B, long C);
extern    int _IQ18toa(char *A, const char *B, long C);
extern    int _IQ17toa(char *A, const char *B, long C);
extern    int _IQ16toa(char *A, const char *B, long C);
extern    int _IQ15toa(char *A, const char *B, long C);
extern    int _IQ14toa(char *A, const char *B, long C);
extern    int _IQ13toa(char *A, const char *B, long C);
extern    int _IQ12toa(char *A, const char *B, long C);
extern    int _IQ11toa(char *A, const char *B, long C);
extern    int _IQ10toa(char *A, const char *B, long C);
extern    int  _IQ9toa(char *A, const char *B, long C);
extern    int  _IQ8toa(char *A, const char *B, long C);
extern    int  _IQ7toa(char *A, const char *B, long C);
extern    int  _IQ6toa(char *A, const char *B, long C);
extern    int  _IQ5toa(char *A, const char *B, long C);
extern    int  _IQ4toa(char *A, const char *B, long C);
extern    int  _IQ3toa(char *A, const char *B, long C);
extern    int  _IQ2toa(char *A, const char *B, long C);
extern    int  _IQ1toa(char *A, const char *B, long C);




//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
extern    long _IQ30log(long A);
extern    long _IQ29log(long A);
extern    long _IQ28log(long A);
extern    long _IQ27log(long A);
extern    long _IQ26log(long A);
extern    long _IQ25log(long A);
extern    long _IQ24log(long A);
extern    long _IQ23log(long A);
extern    long _IQ22log(long A);
extern    long _IQ21log(long A);
extern    long _IQ20log(long A);
extern    long _IQ19log(long A);
extern    long _IQ18log(long A);
extern    long _IQ17log(long A);
extern    long _IQ16log(long A);
extern    long _IQ15log(long A);
extern    long _IQ14log(long A);
extern    long _IQ13log(long A);
extern    long _IQ12log(long A);
extern    long _IQ11log(long A);
extern    long _IQ10log(long A);
extern    long _IQ9log(long A);
extern    long _IQ8log(long A);
extern    long _IQ7log(long A);
extern    long _IQ6log(long A);
extern    long _IQ5log(long A);
extern    long _IQ4log(long A);
extern    long _IQ3log(long A);
extern    long _IQ2log(long A);
extern    long _IQ1log(long A);

//###########################################################################
//###########################################################################


//###########################################################################
//
// FILE:   SFO_V6.H
//
// TITLE:  Scale Factor Optimizer Library V6 Interface Header
//
//
//###########################################################################
//
//  Ver | dd mmm yyyy | Who  | Description of changes
// =====|=============|======|===============================================
//  0.03| 11 Aug 2008 | TI   | New version (V6) with calibration logic separate
//                           | from each ePWM channel.
//  0.04| 03 Aug 2009 | TI   | Minor update to set MEP_ScaleFactor limit to 255
//                           | instead of 254.
//                           | Now updates HRMSTEP register for
//                           | auto-conversion only of MEP_ScaleFactor is <= 255
//                           |
//###########################################################################


//============================================================================
// Description:     This header provides the function call interface
//                  for the scale factor optimizer
//============================================================================


//============================================================================
// Multiple include Guard
//============================================================================

//============================================================================
// C++ namespace
//============================================================================

//============================================================================
// USER MUST UPDATE THIS CONSTANT FOR NUMBER OF HRPWM CHANNELS USED
//============================================================================
                    // i.e. PWM_CH is 9 for 8 channels, 7 for 6 channels, etc.
//============================================================================
// Function prototypes for MEP SFO
//============================================================================

int SFO(void);             // SFO V6  Calibration Function
//============================================================================
// Useful Defines when Using SFO Functions
//============================================================================

//============================================================================
// Multiple include Guard
//============================================================================

//============================================================================
// C++ namespace
//============================================================================

// Include files for device support, F2803x in this case
//###########################################################################
//
// FILE:   DSP2803x_Device.h
//
// TITLE:  DSP2803x Device Definitions.
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



//---------------------------------------------------------------------------
// User To Select Target Device:









//---------------------------------------------------------------------------
// Common CPU Definitions:
//

extern __cregister volatile unsigned int IFR;
extern __cregister volatile unsigned int IER;




//---------------------------------------------------------------------------
// For Portability, User Is Recommended To Use Following Data Type Size
// Definitions For 16-bit and 32-Bit Signed/Unsigned Integers:
//

typedef int             int16;
typedef long            int32;
typedef unsigned int    Uint16;
typedef unsigned long   Uint32;
typedef float           float32;
typedef long double     float64;

//---------------------------------------------------------------------------
// Include All Peripheral Header Files:
//

//###########################################################################
//
// FILE:   DSP2803x_Adc.h
//
// TITLE:  DSP2803x Device ADC Register Definitions.
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################




//---------------------------------------------------------------------------
// ADC Individual Register Bit Definitions:

struct ADCCTL1_BITS {      // bits  description
    Uint16  TEMPCONV:1;    // 0     Temperature sensor connection
    Uint16  VREFLOCONV:1;  // 1     VSSA connection
    Uint16  INTPULSEPOS:1; // 2     INT pulse generation control
    Uint16  ADCREFSEL:1;   // 3     Internal/external reference select
    Uint16  rsvd1:1;       // 4     reserved
    Uint16  ADCREFPWD:1;   // 5     Reference buffers powerdown
    Uint16  ADCBGPWD:1;    // 6     ADC bandgap powerdown
    Uint16  ADCPWDN:1;     // 7     ADC powerdown
    Uint16  ADCBSYCHN:5;   // 12:8  ADC busy on a channel
    Uint16  ADCBSY:1;      // 13    ADC busy signal
    Uint16  ADCENABLE:1;   // 14    ADC enable
    Uint16  RESET:1;       // 15    ADC master reset
};


union ADCCTL1_REG {
   Uint16                all;
   struct ADCCTL1_BITS   bit;
};

// This register is not supported in Rev. 0 silicon.
struct ADCCTL2_BITS {        // bits  description
    Uint16  CLKDIV2EN:1;     // 0     ADC input clock /2 enable
    Uint16  ADCNONOVERLAP:1; // 1     ADCNONOVERLAP Control bit
    Uint16  rsvd1:14;        // 15:2  reserved
};


union ADCCTL2_REG {
   Uint16                all;
   struct ADCCTL2_BITS   bit;
};

struct ADCINT_BITS {       // bits   description
    Uint16  ADCINT1:1;     // 0      ADC Interrupt Flag 1
    Uint16  ADCINT2:1;     // 1      ADC Interrupt Flag 2
    Uint16  ADCINT3:1;     // 2      ADC Interrupt Flag 3
    Uint16  ADCINT4:1;     // 3      ADC Interrupt Flag 4
    Uint16  ADCINT5:1;     // 4      ADC Interrupt Flag 5
    Uint16  ADCINT6:1;     // 5      ADC Interrupt Flag 6
    Uint16  ADCINT7:1;     // 6      ADC Interrupt Flag 7
    Uint16  ADCINT8:1;     // 7      ADC Interrupt Flag 8
    Uint16  ADCINT9:1;     // 8      ADC Interrupt Flag 9
    Uint16  rsvd1:7;       // 15:9   reserved
};

union ADCINT_REG {
   Uint16                 all;
   struct ADCINT_BITS     bit;
};

struct INTSEL1N2_BITS {       // bits   description
    Uint16  INT1SEL:5;        // 4:0    INTx EOC Source Select
    Uint16  INT1E:1;          // 5      INTx Interrupt Enable
    Uint16  INT1CONT:1;       // 6      INTx Continuous Mode Enable
    Uint16  rsvd1:1;          // 7      reserved
    Uint16  INT2SEL:5;        // 12:8   INTy EOC Source Select
    Uint16  INT2E:1;          // 13     INTy Interrupt Enable
    Uint16  INT2CONT:1;       // 14     INTy Continuous Mode Enable
    Uint16  rsvd2:1;          // 15     reserved
};

union INTSEL1N2_REG {
    Uint16                all;
    struct INTSEL1N2_BITS bit;
};


struct INTSEL3N4_BITS {       // bits   description
    Uint16  INT3SEL:5;        // 4:0    INTx EOC Source Select
    Uint16  INT3E:1;          // 5      INTx Interrupt Enable
    Uint16  INT3CONT:1;       // 6      INTx Continuous Mode Enable
    Uint16  rsvd1:1;          // 7      reserved
    Uint16  INT4SEL:5;        // 12:8   INTy EOC Source Select
    Uint16  INT4E:1;          // 13     INTy Interrupt Enable
    Uint16  INT4CONT:1;       // 14     INTy Continuous Mode Enable
    Uint16  rsvd2:1;          // 15     reserved
};

union INTSEL3N4_REG {
    Uint16                all;
    struct INTSEL3N4_BITS bit;
};


struct INTSEL5N6_BITS {       // bits   description
    Uint16  INT5SEL:5;        // 4:0    INTx EOC Source Select
    Uint16  INT5E:1;          // 5      INTx Interrupt Enable
    Uint16  INT5CONT:1;       // 6      INTx Continuous Mode Enable
    Uint16  rsvd1:1;          // 7      reserved
    Uint16  INT6SEL:5;        // 12:8   INTy EOC Source Select
    Uint16  INT6E:1;          // 13     INTy Interrupt Enable
    Uint16  INT6CONT:1;       // 14     INTy Continuous Mode Enable
    Uint16  rsvd2:1;          // 15     reserved
};

union INTSEL5N6_REG {
    Uint16                all;
    struct INTSEL5N6_BITS bit;
};


struct INTSEL7N8_BITS {       // bits   description
    Uint16  INT7SEL:5;        // 4:0    INTx EOC Source Select
    Uint16  INT7E:1;          // 5      INTx Interrupt Enable
    Uint16  INT7CONT:1;       // 6      INTx Continuous Mode Enable
    Uint16  rsvd1:1;          // 7      reserved
    Uint16  INT8SEL:5;        // 12:8   INTy EOC Source Select
    Uint16  INT8E:1;          // 13     INTy Interrupt Enable
    Uint16  INT8CONT:1;       // 14     INTy Continuous Mode Enable
    Uint16  rsvd2:1;          // 15     reserved
};

union INTSEL7N8_REG {
    Uint16                all;
    struct INTSEL7N8_BITS bit;
};


struct INTSEL9N10_BITS {      // bits   description
    Uint16  INT9SEL:5;        // 4:0    INTx EOC Source Select
    Uint16  INT9E:1;          // 5      INTx Interrupt Enable
    Uint16  INT9CONT:1;       // 6      INTx Continuous Mode Enable
    Uint16  rsvd1:1;          // 7      reserved
    Uint16  INT10SEL:5;       // 12:8   INTy EOC Source Select
    Uint16  INT10E:1;         // 13     INTy Interrupt Enable
    Uint16  INT10CONT:1;      // 14     INTy Continuous Mode Enable
    Uint16  rsvd2:1;          // 15     reserved
};

union INTSEL9N10_REG {
    Uint16                all;
    struct INTSEL9N10_BITS bit;
};

struct SOCPRICTL_BITS {       // bits   description
    Uint16  SOCPRIORITY:5;    // 4:0    Start-of-conversion Priority
    Uint16  RRPOINTER:6;      // 10:5   Round Robin Pointer
    Uint16  rsvd1:4;          // 14:11  reserved
    Uint16  ONESHOT:1;        // 15     One Shot Mode Enabled - bit does not exist in Rev. 0 silicon
};

union SOCPRICTL_REG {
    Uint16                 all;
    struct SOCPRICTL_BITS  bit;
};

struct ADCSAMPLEMODE_BITS {   // bits   description
    Uint16 SIMULEN0:1;        // 0      SOC0 Simultaneous Sampling Enable
    Uint16 SIMULEN2:1;        // 1      SOC2 Simultaneous Sampling Enable
    Uint16 SIMULEN4:1;        // 2      SOC4 Simultaneous Sampling Enable
    Uint16 SIMULEN6:1;        // 3      SOC6 Simultaneous Sampling Enable
    Uint16 SIMULEN8:1;        // 4      SOC8 Simultaneous Sampling Enable
    Uint16 SIMULEN10:1;       // 5      SOC10 Simultaneous Sampling Enable
    Uint16 SIMULEN12:1;       // 6      SOC12 Simultaneous Sampling Enable
    Uint16 SIMULEN14:1;       // 7      SOC14 Simultaneous Sampling Enable
    Uint16 rsvd1:8;           //15:8    reserved
};

union ADCSAMPLEMODE_REG {
    Uint16                      all;
    struct ADCSAMPLEMODE_BITS   bit;
};

struct ADCINTSOCSEL1_BITS {   // bits   description
    Uint16 SOC0:2;            // 1:0      ADCINT Start-of-conversion Select
    Uint16 SOC1:2;            // 3:2      ADCINT Start-of-conversion Select
    Uint16 SOC2:2;            // 5:4      ADCINT Start-of-conversion Select
    Uint16 SOC3:2;            // 7:6      ADCINT Start-of-conversion Select
    Uint16 SOC4:2;            // 9:8      ADCINT Start-of-conversion Select
    Uint16 SOC5:2;            // 11:10    ADCINT Start-of-conversion Select
    Uint16 SOC6:2;            // 13:12    ADCINT Start-of-conversion Select
    Uint16 SOC7:2;            // 15:14    ADCINT Start-of-conversion Select
};

union ADCINTSOCSEL1_REG {
    Uint16                    all;
    struct ADCINTSOCSEL1_BITS bit;
};

struct ADCINTSOCSEL2_BITS {   // bits   description
    Uint16 SOC8:2;            // 1:0      ADCINT Start-of-conversion Select
    Uint16 SOC9:2;            // 3:2      ADCINT Start-of-conversion Select
    Uint16 SOC10:2;           // 5:4      ADCINT Start-of-conversion Select
    Uint16 SOC11:2;           // 7:6      ADCINT Start-of-conversion Select
    Uint16 SOC12:2;           // 9:8      ADCINT Start-of-conversion Select
    Uint16 SOC13:2;           // 11:10    ADCINT Start-of-conversion Select
    Uint16 SOC14:2;           // 13:12    ADCINT Start-of-conversion Select
    Uint16 SOC15:2;           // 15:14    ADCINT Start-of-conversion Select
};

union ADCINTSOCSEL2_REG {
    Uint16                    all;
    struct ADCINTSOCSEL2_BITS bit;
};

struct ADCSOC_BITS {          // bits  description
    Uint16 SOC0:1;            // 0     Start-of-conversion for CONV0
    Uint16 SOC1:1;            // 1     Start-of-conversion for CONV1
    Uint16 SOC2:1;            // 2     Start-of-conversion for CONV2
    Uint16 SOC3:1;            // 3     Start-of-conversion for CONV3
    Uint16 SOC4:1;            // 4     Start-of-conversion for CONV4
    Uint16 SOC5:1;            // 5     Start-of-conversion for CONV5
    Uint16 SOC6:1;            // 6     Start-of-conversion for CONV6
    Uint16 SOC7:1;            // 7     Start-of-conversion for CONV7
    Uint16 SOC8:1;            // 8     Start-of-conversion for CONV8
    Uint16 SOC9:1;            // 9     Start-of-conversion for CONV9
    Uint16 SOC10:1;           // 10    Start-of-conversion for CONV10
    Uint16 SOC11:1;           // 11    Start-of-conversion for CONV11
    Uint16 SOC12:1;           // 12    Start-of-conversion for CONV12
    Uint16 SOC13:1;           // 13    Start-of-conversion for CONV13
    Uint16 SOC14:1;           // 14    Start-of-conversion for CONV14
    Uint16 SOC15:1;           // 15    Start-of-conversion for CONV15
};

union ADCSOC_REG {
    Uint16                    all;
    struct ADCSOC_BITS        bit;
};

struct ADCSOCxCTL_BITS {      // bits  description
    Uint16 ACQPS:6;           // 5:0   Acquisition Pulse Size
    Uint16 CHSEL:4;           // 9:6   SOCx Channel Select
    Uint16 rsvd1:1;           // 10    reserved
    Uint16 TRIGSEL:5;         // 15:11 SOCx Trigger Select
};

union ADCSOCxCTL_REG {
    Uint16                  all;
    struct ADCSOCxCTL_BITS  bit;
};

// Rev. 0 silicon - BG_FINE_TRIM = bits 3:0.
//                  BG_COARSE_TRIM = bits : 8:4
// Rev. A and beyond silicon = below register definition:
struct ADCREFTRIM_BITS{         // bits   description
    Uint16  BG_FINE_TRIM:5;     // 4:0    Coarse trim for internal BG
    Uint16  BG_COARSE_TRIM:4;   // 8:5    Fine trim for internal BG
    Uint16  EXTREF_FINE_TRIM:5; // 13:9   Fine trim for external reference
    Uint16  rsvd1:2;            // 15:14  reserved
};

union ADCREFTRIM_REG{
    Uint16      all;
    struct ADCREFTRIM_BITS bit;
};

struct ADCOFFTRIM_BITS{       // bits   description
    int16   OFFTRIM:9;        // 8:0    Offset Trim
    Uint16  rsvd1:7;          // 15:9   reserved
};

union ADCOFFTRIM_REG{
    Uint16      all;
    struct ADCOFFTRIM_BITS bit;
};

struct COMPHYSTCTL_BITS{                // bits description
    Uint16  rsvd1:1;             	   // 0    reserved
    Uint16  COMP1_HYST_DISABLE:1;      // 1    Comparator 1 Hysteresis Disable
    Uint16  rsvd2:4;                   // 5:2  reserved
    Uint16  COMP2_HYST_DISABLE:1;      // 6    Comparator 2 Hysteresis Disable
    Uint16  rsvd3:4;                   // 10:7 reserved
    Uint16  COMP3_HYST_DISABLE:1;      // 11   Comparator 3 Hysteresis Disable
    Uint16  rsvd4:4;                   // 15:12 reserved
};

union COMPHYSTCTL_REG{
    Uint16      all;
    struct COMPHYSTCTL_BITS bit;
};

//---------------------------------------------------------------------------
// ADC Register Definitions:

struct ADC_REGS {
    union  ADCCTL1_REG           ADCCTL1;         // ADC Control 1
    union  ADCCTL2_REG           ADCCTL2;         // ADC Control 2 - not available in Rev. 0 silicon
    Uint16                       rsvd1[2];        // reserved
    union  ADCINT_REG            ADCINTFLG;       // ADC Interrupt Flag
    union  ADCINT_REG            ADCINTFLGCLR;    // ADC Interrupt Flag Clear
    union  ADCINT_REG            ADCINTOVF;       // ADC Interrupt Overflow
    union  ADCINT_REG            ADCINTOVFCLR;    // ADC Interrupt Overflow Clear
    union  INTSEL1N2_REG         INTSEL1N2;       // ADC Interrupt 1 and 2 Selection
    union  INTSEL3N4_REG         INTSEL3N4;       // ADC Interrupt 3 and 4 Selection
    union  INTSEL5N6_REG         INTSEL5N6;       // ADC Interrupt 5 and 6 Selection
    union  INTSEL7N8_REG         INTSEL7N8;       // ADC Interrupt 7 and 8 Selection
    union  INTSEL9N10_REG        INTSEL9N10;      // ADC Interrupt 9 and 10 Selection
    Uint16                       rsvd2[3];        // reserved
    union  SOCPRICTL_REG         SOCPRICTL;       // ADC SOC Priority Control
    Uint16                       rsvd3;           // reserved
    union  ADCSAMPLEMODE_REG     ADCSAMPLEMODE;   // ADC Sampling Mode
    Uint16                       rsvd4;           // reserved
    union  ADCINTSOCSEL1_REG     ADCINTSOCSEL1;   // ADC Interrupt SOC Selection 1
    union  ADCINTSOCSEL2_REG     ADCINTSOCSEL2;   // ADC Interrupt SOC Selection 2
    Uint16                       rsvd5[2];        // reserved
    union  ADCSOC_REG            ADCSOCFLG1;      // ADC SOC Flag 1
    Uint16                       rsvd6;           // reserved
    union  ADCSOC_REG            ADCSOCFRC1;      // ADC SOC Flag Force 1
    Uint16                       rsvd7;           // reserved
    union  ADCSOC_REG            ADCSOCOVF1;      // ADC SOC Overflow 1
    Uint16                       rsvd8;           // reserved
    union  ADCSOC_REG            ADCSOCOVFCLR1;   // ADC SOC Overflow Clear 1
    Uint16                       rsvd9;           // reserved
    union  ADCSOCxCTL_REG        ADCSOC0CTL;      // ADC SOC0 Control
    union  ADCSOCxCTL_REG        ADCSOC1CTL;      // ADC SOC1 Control
    union  ADCSOCxCTL_REG        ADCSOC2CTL;      // ADC SOC2 Control
    union  ADCSOCxCTL_REG        ADCSOC3CTL;      // ADC SOC3 Control
    union  ADCSOCxCTL_REG        ADCSOC4CTL;      // ADC SOC4 Control
    union  ADCSOCxCTL_REG        ADCSOC5CTL;      // ADC SOC5 Control
    union  ADCSOCxCTL_REG        ADCSOC6CTL;      // ADC SOC6 Control
    union  ADCSOCxCTL_REG        ADCSOC7CTL;      // ADC SOC7 Control
    union  ADCSOCxCTL_REG        ADCSOC8CTL;      // ADC SOC8 Control
    union  ADCSOCxCTL_REG        ADCSOC9CTL;      // ADC SOC9 Control
    union  ADCSOCxCTL_REG        ADCSOC10CTL;     // ADC SOC10 Control
    union  ADCSOCxCTL_REG        ADCSOC11CTL;     // ADC SOC11 Control
    union  ADCSOCxCTL_REG        ADCSOC12CTL;     // ADC SOC12 Control
    union  ADCSOCxCTL_REG        ADCSOC13CTL;     // ADC SOC13 Control
    union  ADCSOCxCTL_REG        ADCSOC14CTL;     // ADC SOC14 Control
    union  ADCSOCxCTL_REG        ADCSOC15CTL;     // ADC SOC15 Control
    Uint16                       rsvd10 [16];     // reserved
    union  ADCREFTRIM_REG        ADCREFTRIM;      // Reference Trim Register
    union  ADCOFFTRIM_REG        ADCOFFTRIM;      // Offset Trim Register
    Uint16                       rsvd11 [10];     // reserved
	union  COMPHYSTCTL_REG       COMPHYSTCTL;     // COMP Hysteresis Control Register
	Uint16                       rsvd12 [3];      // reserved
};


struct ADC_RESULT_REGS
{
    Uint16                 ADCRESULT0;    // Conversion Result Buffer 0
    Uint16                 ADCRESULT1;    // Conversion Result Buffer 1
    Uint16                 ADCRESULT2;    // Conversion Result Buffer 2
    Uint16                 ADCRESULT3;    // Conversion Result Buffer 3
    Uint16                 ADCRESULT4;    // Conversion Result Buffer 4
    Uint16                 ADCRESULT5;    // Conversion Result Buffer 5
    Uint16                 ADCRESULT6;    // Conversion Result Buffer 6
    Uint16                 ADCRESULT7;    // Conversion Result Buffer 7
    Uint16                 ADCRESULT8;    // Conversion Result Buffer 8
    Uint16                 ADCRESULT9;    // Conversion Result Buffer 9
    Uint16                 ADCRESULT10;   // Conversion Result Buffer 10
    Uint16                 ADCRESULT11;   // Conversion Result Buffer 11
    Uint16                 ADCRESULT12;   // Conversion Result Buffer 12
    Uint16                 ADCRESULT13;   // Conversion Result Buffer 13
    Uint16                 ADCRESULT14;   // Conversion Result Buffer 14
    Uint16                 ADCRESULT15;   // Conversion Result Buffer 15
    Uint16                 rsvd[16];      // reserved
};

//---------------------------------------------------------------------------
// ADC External References & Function Declarations:
//
extern volatile struct ADC_REGS AdcRegs;
extern volatile struct ADC_RESULT_REGS AdcResult;




//===========================================================================
// End of file.
//===========================================================================

//###########################################################################
//
// FILE:    DSP2803x_BootVars.h
//
// TITLE:   DSP2803x Boot Variable Definitions.
//
// NOTES:
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################





//---------------------------------------------------------------------------
// External Boot ROM variable definitions:
//
extern Uint16 EmuKey;
extern Uint16 EmuBMode;
extern Uint32 Flash_CPUScaleFactor;
extern void (*Flash_CallbackPtr) (void);



//===========================================================================
// End of file.
//===========================================================================

//###########################################################################
//
// FILE:   DSP2803x_DevEmu.h
//
// TITLE:  DSP2803x Device Emulation Register Definitions.
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



//---------------------------------------------------------------------------
// Device Emulation Register Bit Definitions:
//
// Device Configuration Register Bit Definitions
struct DEVICECNF_BITS  {     // bits  description
   Uint16 rsvd1:3;           // 2:0   reserved
   Uint16 VMAPS:1;           // 3     VMAP Status
   Uint16 rsvd2:1;           // 4     reserved
   Uint16 XRSn:1;            // 5     XRSn Signal Status
   Uint16 rsvd3:10;          // 15:6  reserved
   Uint16 rsvd4:3;           // 18:16 reserved
   Uint16 ENPROT:1;          // 19    Enable/Disable pipeline protection
   Uint16 rsvd5:7;           // 26:21 reserved
   Uint16 TRSTn:1;           // 27    Status of TRSTn signal
   Uint16 PINOUTSELSTS:1;    // 28    Status of PINOUSTSEL pin
   Uint16 PINOUTSELPUD:1;    // 29    PINOUTSEL pin pull-up disable
   Uint16 rsvd6:2;           // 31:30 reserved
};

union DEVICECNF_REG {
   Uint32                 all;
   struct DEVICECNF_BITS  bit;
};

// CLASSID
struct CLASSID_BITS   {  // bits  description
   Uint16 CLASSNO:8;     // 7:0   Class Number
   Uint16 PARTTYPE:8;    // 15:8  Part Type
};

union CLASSID_REG {
   Uint16               all;
   struct CLASSID_BITS  bit;
};


struct DEV_EMU_REGS {
   union DEVICECNF_REG DEVICECNF;  // Device Configuration
   union CLASSID_REG   CLASSID;    // Class ID
   Uint16              REVID;      // Device ID
};

// PARTID
struct PARTID_BITS   {  // bits  description
   Uint16 PARTNO:8;     // 7:0   Part Number
   Uint16 PARTTYPE:8;   // 15:8  Part Type
};

union PARTID_REG {
   Uint16               all;
   struct PARTID_BITS   bit;
};

struct PARTID_REGS {
   union PARTID_REG PARTID; // Part ID
};


//---------------------------------------------------------------------------
// Device Emulation Register References & Function Declarations:
//
extern volatile struct DEV_EMU_REGS DevEmuRegs;
extern volatile struct PARTID_REGS PartIdRegs;



//===========================================================================
// End of file.
//===========================================================================
//###########################################################################
//
// FILE:  DSP2803x_Cla.h
//
// TITLE: CLA Type 0 Register Definitions.
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



//---------------------------------------------------------------------------
// CLA Control Register
struct MCTL_BITS {             // bits   description
    Uint16   HARDRESET:1;      // 0      Issue a hard reset
    Uint16   SOFTRESET:1;      // 1      Issue a soft reset
    Uint16   IACKE:1;          // 2      Enable IACK for task start
    Uint16   rsvd1:13;         // 15:3   reserved
};

union MCTL_REG {
   Uint16                   all;
   struct MCTL_BITS         bit;
};

//---------------------------------------------------------------------------
// CLA Memory Configuration Register
struct MMEMCFG_BITS {          // bits   description
    Uint16   PROGE:1;          // 0      Program RAM enable
    Uint16   rsvd1:3;          // 3:1    reserved
    Uint16   RAM0E:1;          // 4      Data RAM 0 enable
    Uint16   RAM1E:1;          // 5      Data RAM 1 enable
    Uint16   rsvd2:10;         // 15:6   reserved
};

union MMEMCFG_REG {
   Uint16                   all;
   struct MMEMCFG_BITS      bit;
};

//---------------------------------------------------------------------------
// CLA Peripheral Interrupt Select Register
struct MPISRCSEL1_BITS {        // bits     description
    Uint16   PERINT1SEL:4;      // 3:0      Source for CLA interrupt 1
    Uint16   PERINT2SEL:4;      // 7:4      Source for CLA interrupt 2
    Uint16   PERINT3SEL:4;      // 11:8     Source for CLA interrupt 3
    Uint16   PERINT4SEL:4;      // 15:12    Source for CLA interrupt 4
    Uint16   PERINT5SEL:4;      // 19:16    Source for CLA interrupt 5
    Uint16   PERINT6SEL:4;      // 23:20    Source for CLA interrupt 6
    Uint16   PERINT7SEL:4;      // 27:24    Source for CLA interrupt 7
    Uint16   PERINT8SEL:4;      // 31:28    Source for CLA interrupt 8
};

union MPISRCSEL1_REG {
   Uint32                   all;
   struct MPISRCSEL1_BITS   bit;
};

//---------------------------------------------------------------------------
// CLA Interrupt Registers
struct MIFR_BITS {              // bits     description
    Uint16   INT1:1;            // 0        Interrupt 1 flag
    Uint16   INT2:1;            // 1        Interrupt 2 flag
    Uint16   INT3:1;            // 2        Interrupt 3 flag
    Uint16   INT4:1;            // 3        Interrupt 4 flag
    Uint16   INT5:1;            // 4        Interrupt 5 flag
    Uint16   INT6:1;            // 5        Interrupt 6 flag
    Uint16   INT7:1;            // 6        Interrupt 7 flag
    Uint16   INT8:1;            // 7        Interrupt 8 flag
    Uint16   rsvd:8;
};

union MIFR_REG {
   Uint16              all;
   struct MIFR_BITS    bit;
};

union MIOVF_REG {
   Uint16              all;
   struct MIFR_BITS    bit;
};

union MIFRC_REG {
   Uint16              all;
   struct MIFR_BITS    bit;
};

union MICLR_REG {
   Uint16              all;
   struct MIFR_BITS    bit;
};

union MICLROVF_REG {
   Uint16              all;
   struct MIFR_BITS    bit;
};

union MIER_REG {
   Uint16              all;
   struct MIFR_BITS    bit;
};

union MIRUN_REG {
   Uint16              all;
   struct MIFR_BITS    bit;
};

//---------------------------------------------------------------------------
// CLA Status Register
struct MSTF_BITS {              // bits     description
    Uint16   LVF:1;             // 0        Latched overflow flag
    Uint16   LUF:1;             // 1        Latched underflow flag
    Uint16   NF:1;              // 2        Negative float flag
    Uint16   ZF:1;              // 3        Zero float flag
    Uint16   rsvd1:2;           // 5,4
    Uint16   TF:1;              // 6        Test flag
    Uint16   rsvd2:2;           // 8,7
    Uint16   RNDF32:1;          // 9        Rounding mode
    Uint16   rsvd3:1;           // 10
    Uint16   MEALLOW:1;         // 11       MEALLOW status
    Uint16   RPCL:4;            // 15:12    Return PC, low portion
    Uint16   RPCH:8;            // 23:16    Return PC, high portion
    Uint16   rsvd4:8;           // 31:24
};

union MSTF_REG {
   Uint32              all;
   struct MSTF_BITS    bit;
};

union MR_REG {
   Uint32              i32;
   float               f32;
};

//---------------------------------------------------------------------------
// External Interrupt Register File:
struct CLA_REGS {
    Uint16  MVECT1;                           // Task 1 vector
    Uint16  MVECT2;                           // Task 2 vector
    Uint16  MVECT3;                           // Task 3 vector
    Uint16  MVECT4;                           // Task 4 vector
    Uint16  MVECT5;                           // Task 5 vector
    Uint16  MVECT6;                           // Task 6 vector
    Uint16  MVECT7;                           // Task 7 vector
    Uint16  MVECT8;                           // Task 8 vector
    Uint16  rsvd1[8];
    union   MCTL_REG        MCTL;             // CLA control
    union   MMEMCFG_REG     MMEMCFG;          // CLA memory configuration
    Uint16  rsvd2[2];
    union   MPISRCSEL1_REG  MPISRCSEL1;       // CLA interrupt source select
    Uint16  rsvd3[10];
    union   MIFR_REG        MIFR;             // CLA interrupt flag
    union   MIOVF_REG       MIOVF;            // CLA interrupt overflow flag
    union   MIFRC_REG       MIFRC;            // CLA interrupt force
    union   MICLR_REG       MICLR;            // CLA interrupt flag clear
    union   MICLROVF_REG    MICLROVF;         // CLA interrupt overflow flag clear
    union   MIER_REG        MIER;             // CLA interrupt enable
    union   MIRUN_REG       MIRUN;            // CLA interrupt run status
    Uint16  rsvd10;
	   // Leading _ in front of execution registers avoids
	   // conflicts when using this header in assembly files
    Uint16  _MPC;                              // CLA program counter
    Uint16  rsvd4;
    Uint16  _MAR0;                             // CLA auxillary register 0
    Uint16  _MAR1;                             // CLA auxillary register 1
    Uint16  rsvd5[2];
    union   MSTF_REG        _MSTF;             // CLA floating-point status register
    union   MR_REG          _MR0;              // CLA result register 0
    Uint32  rsvd6;
    union   MR_REG          _MR1;              // CLA result register 1
    Uint32  rsvd7;
    union   MR_REG          _MR2;              // CLA result register 2
    Uint32  rsvd8;
    union   MR_REG          _MR3;              // CLA result register 3
    Uint32  rsvd9;
};

//---------------------------------------------------------------------------
// External Interrupt References & Function Declarations:
//
extern volatile struct CLA_REGS Cla1Regs;



//===========================================================================
// End of file.
//===========================================================================

//###########################################################################
//
// FILE:   DSP2803x_Comp.h
//
// TITLE:  DSP2803x Device Comparator Register Definitions
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



//===========================================================================
//  Comparator Register Bit Definitions
//

struct COMPCTL_BITS {            // bit       description
    Uint16   COMPDACEN:1;        // 0         Comparator/DAC  Enable
    Uint16   COMPSOURCE:1;       // 1         Source select for comparator inverting input
    Uint16   CMPINV:1;           // 2         Invert select for Comparator
    Uint16   QUALSEL:5;          // 7:03      Qualification Period for synchronized output of the comparator
    Uint16   SYNCSEL:1;          // 8         Synchronization select for output of the comparator
    Uint16   rsvd1:7;            // 15:09     reserved
};

union COMPCTL_REG  {
    Uint16                         all;
    struct COMPCTL_BITS            bit;
};

struct COMPSTS_BITS {            // bit       description
    Uint16   COMPSTS:1;          // 0         Logical latched value of the comparator
    Uint16   rsvd1:15;           // 15:01     reserved
};

union COMPSTS_REG  {
    Uint16                         all;
    struct COMPSTS_BITS            bit;
};

struct DACCTL_BITS {            // bits      description
    Uint16   DACSOURCE:1;        // 0         DAC source control bits.
    Uint16   RAMPSOURCE:4;       // 4:01      Ramp generator source control bits
    Uint16   rsvd1:9;            // 13:05     reserved
    Uint16   FREE_SOFT:2;        // 15:14     Debug Mode Bit
};

union DACCTL_REG  {
    Uint16                         all;
    struct DACCTL_BITS             bit;
};

struct DACVAL_BITS {             // bit       description
    Uint16   DACVAL:10;          // 9:00      DAC Value bit
    Uint16   rsvd1:6;            // 15:10     reserved
};

union DACVAL_REG  {
    Uint16                         all;
    struct DACVAL_BITS             bit;
};

//===========================================================================
//  Comparator Register Definitions
//

struct COMP_REGS {
    union  COMPCTL_REG         COMPCTL;
    Uint16                     rsvd1;
    union  COMPSTS_REG         COMPSTS;
    Uint16                     rsvd2;
    union  DACCTL_REG          DACCTL;
    Uint16                     rsvd3;
    union  DACVAL_REG          DACVAL;
    Uint16                     rsvd4;
    Uint16                     RAMPMAXREF_ACTIVE;
    Uint16                     rsvd5;
    Uint16                     RAMPMAXREF_SHDW;
    Uint16                     rsvd6;
    Uint16                     RAMPDECVAL_ACTIVE;
    Uint16                     rsvd7;
    Uint16                     RAMPDECVAL_SHDW;
    Uint16                     rsvd8;
    Uint16                     RAMPSTS;
    Uint16                     rsvd9[3];
};

//===========================================================================
//  Comparator External References and Function Declarations
//

extern volatile struct COMP_REGS Comp1Regs;
extern volatile struct COMP_REGS Comp2Regs;
extern volatile struct COMP_REGS Comp3Regs;



//===========================================================================
// End of file
//===========================================================================
//###########################################################################
//
// FILE:    DSP2803x_CpuTimers.h
//
// TITLE:   DSP2803x CPU 32-bit Timers Register Definitions.
//
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



//---------------------------------------------------------------------------
// CPU Timer Register Bit Definitions:
//
//
// TCR: Control register bit definitions:
struct  TCR_BITS {          // bits  description
   Uint16    rsvd1:4;       // 3:0   reserved
   Uint16    TSS:1;         // 4     Timer Start/Stop
   Uint16    TRB:1;         // 5     Timer reload
   Uint16    rsvd2:4;       // 9:6   reserved
   Uint16    SOFT:1;        // 10    Emulation modes
   Uint16    FREE:1;        // 11
   Uint16    rsvd3:2;       // 12:13 reserved
   Uint16    TIE:1;         // 14    Output enable
   Uint16    TIF:1;         // 15    Interrupt flag
};

union TCR_REG {
   Uint16           all;
   struct TCR_BITS  bit;
};

// TPR: Pre-scale low bit definitions:
struct  TPR_BITS {        // bits  description
   Uint16     TDDR:8;     // 7:0   Divide-down low
   Uint16     PSC:8;      // 15:8  Prescale counter low
};

union TPR_REG {
   Uint16           all;
   struct TPR_BITS  bit;
};

// TPRH: Pre-scale high bit definitions:
struct  TPRH_BITS {       // bits  description
   Uint16     TDDRH:8;      // 7:0   Divide-down high
   Uint16     PSCH:8;       // 15:8  Prescale counter high
};

union TPRH_REG {
   Uint16           all;
   struct TPRH_BITS bit;
};

// TIM, TIMH: Timer register definitions:
struct TIM_REG {
   Uint16  LSW;
   Uint16  MSW;
};

union TIM_GROUP {
   Uint32          all;
   struct TIM_REG  half;
};

// PRD, PRDH: Period register definitions:
struct PRD_REG {
   Uint16  LSW;
   Uint16  MSW;
};

union PRD_GROUP {
   Uint32          all;
   struct PRD_REG  half;
};

//---------------------------------------------------------------------------
// CPU Timer Register File:
//
struct CPUTIMER_REGS {
   union TIM_GROUP TIM;   // Timer counter register
   union PRD_GROUP PRD;   // Period register
   union TCR_REG   TCR;   // Timer control register
   Uint16          rsvd1; // reserved
   union TPR_REG   TPR;   // Timer pre-scale low
   union TPRH_REG  TPRH;  // Timer pre-scale high
};

//---------------------------------------------------------------------------
// CPU Timer Support Variables:
//
struct CPUTIMER_VARS {
   volatile struct  CPUTIMER_REGS  *RegsAddr;
   Uint32    InterruptCount;
   float   CPUFreqInMHz;
   float   PeriodInUSec;
};

//---------------------------------------------------------------------------
// Function prototypes and external definitions:
//
void InitCpuTimers(void);
void ConfigCpuTimer(struct CPUTIMER_VARS *Timer, float Freq, float Period);

extern volatile struct CPUTIMER_REGS CpuTimer0Regs;
extern struct CPUTIMER_VARS CpuTimer0;

extern volatile struct CPUTIMER_REGS CpuTimer1Regs;
extern volatile struct CPUTIMER_REGS CpuTimer2Regs;

extern struct CPUTIMER_VARS CpuTimer1;
extern struct CPUTIMER_VARS CpuTimer2;

//---------------------------------------------------------------------------
// Usefull Timer Operations:
//
// Start Timer:

// Stop Timer:

// Reload Timer With period Value:

// Read 32-Bit Timer Value:

// Read 32-Bit Period Value:

// Start Timer:

// Stop Timer:

// Reload Timer With period Value:

// Read 32-Bit Timer Value:

// Read 32-Bit Period Value:



//===========================================================================
// End of file.
//===========================================================================
//###########################################################################
//
// FILE:   DSP2803x_ECan.h
//
// TITLE:  DSP2803x Device eCAN Register Definitions.
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



/* --------------------------------------------------- */
/* eCAN Control & Status Registers                     */
/* ----------------------------------------------------*/

/* eCAN Mailbox enable register (CANME) bit definitions */
struct  CANME_BITS {      // bit  description
   Uint16      ME0:1;     // 0   Enable Mailbox 0
   Uint16      ME1:1;     // 1   Enable Mailbox 1
   Uint16      ME2:1;     // 2   Enable Mailbox 2
   Uint16      ME3:1;     // 3   Enable Mailbox 3
   Uint16      ME4:1;     // 4   Enable Mailbox 4
   Uint16      ME5:1;     // 5   Enable Mailbox 5
   Uint16      ME6:1;     // 6   Enable Mailbox 6
   Uint16      ME7:1;     // 7   Enable Mailbox 7
   Uint16      ME8:1;     // 8   Enable Mailbox 8
   Uint16      ME9:1;     // 9   Enable Mailbox 9
   Uint16      ME10:1;    // 10  Enable Mailbox 10
   Uint16      ME11:1;    // 11  Enable Mailbox 11
   Uint16      ME12:1;    // 12  Enable Mailbox 12
   Uint16      ME13:1;    // 13  Enable Mailbox 13
   Uint16      ME14:1;    // 14  Enable Mailbox 14
   Uint16      ME15:1;    // 15  Enable Mailbox 15
   Uint16      ME16:1;    // 16  Enable Mailbox 16
   Uint16      ME17:1;    // 17  Enable Mailbox 17
   Uint16      ME18:1;    // 18  Enable Mailbox 18
   Uint16      ME19:1;    // 19  Enable Mailbox 19
   Uint16      ME20:1;    // 20  Enable Mailbox 20
   Uint16      ME21:1;    // 21  Enable Mailbox 21
   Uint16      ME22:1;    // 22  Enable Mailbox 22
   Uint16      ME23:1;    // 23  Enable Mailbox 23
   Uint16      ME24:1;    // 24  Enable Mailbox 24
   Uint16      ME25:1;    // 25  Enable Mailbox 25
   Uint16      ME26:1;    // 26  Enable Mailbox 26
   Uint16      ME27:1;    // 27  Enable Mailbox 27
   Uint16      ME28:1;    // 28  Enable Mailbox 28
   Uint16      ME29:1;    // 29  Enable Mailbox 29
   Uint16      ME30:1;    // 30  Enable Mailbox 30
   Uint16      ME31:1;    // 31  Enable Mailbox 31

};

/* Allow access to the bit fields or entire register */
union CANME_REG {
   Uint32             all;
   struct CANME_BITS  bit;
};

/* eCAN Mailbox direction register (CANMD) bit definitions */
struct  CANMD_BITS {      // bit  description
   Uint16      MD0:1;     // 0   0 -> Tx 1 -> Rx
   Uint16      MD1:1;     // 1   0 -> Tx 1 -> Rx
   Uint16      MD2:1;     // 2   0 -> Tx 1 -> Rx
   Uint16      MD3:1;     // 3   0 -> Tx 1 -> Rx
   Uint16      MD4:1;     // 4   0 -> Tx 1 -> Rx
   Uint16      MD5:1;     // 5   0 -> Tx 1 -> Rx
   Uint16      MD6:1;     // 6   0 -> Tx 1 -> Rx
   Uint16      MD7:1;     // 7   0 -> Tx 1 -> Rx
   Uint16      MD8:1;     // 8   0 -> Tx 1 -> Rx
   Uint16      MD9:1;     // 9   0 -> Tx 1 -> Rx
   Uint16      MD10:1;    // 10  0 -> Tx 1 -> Rx
   Uint16      MD11:1;    // 11  0 -> Tx 1 -> Rx
   Uint16      MD12:1;    // 12  0 -> Tx 1 -> Rx
   Uint16      MD13:1;    // 13  0 -> Tx 1 -> Rx
   Uint16      MD14:1;    // 14  0 -> Tx 1 -> Rx
   Uint16      MD15:1;    // 15  0 -> Tx 1 -> Rx
   Uint16      MD16:1;    // 16  0 -> Tx 1 -> Rx
   Uint16      MD17:1;    // 17  0 -> Tx 1 -> Rx
   Uint16      MD18:1;    // 18  0 -> Tx 1 -> Rx
   Uint16      MD19:1;    // 19  0 -> Tx 1 -> Rx
   Uint16      MD20:1;    // 20  0 -> Tx 1 -> Rx
   Uint16      MD21:1;    // 21  0 -> Tx 1 -> Rx
   Uint16      MD22:1;    // 22  0 -> Tx 1 -> Rx
   Uint16      MD23:1;    // 23  0 -> Tx 1 -> Rx
   Uint16      MD24:1;    // 24  0 -> Tx 1 -> Rx
   Uint16      MD25:1;    // 25  0 -> Tx 1 -> Rx
   Uint16      MD26:1;    // 26  0 -> Tx 1 -> Rx
   Uint16      MD27:1;    // 27  0 -> Tx 1 -> Rx
   Uint16      MD28:1;    // 28  0 -> Tx 1 -> Rx
   Uint16      MD29:1;    // 29  0 -> Tx 1 -> Rx
   Uint16      MD30:1;    // 30  0 -> Tx 1 -> Rx
   Uint16      MD31:1;    // 31  0 -> Tx 1 -> Rx

};

/* Allow access to the bit fields or entire register */
union CANMD_REG {
   Uint32             all;
   struct CANMD_BITS  bit;
};

/* eCAN Transmit Request Set register (CANTRS) bit definitions */
struct  CANTRS_BITS {      // bit  description
   Uint16      TRS0:1;     // 0   TRS for Mailbox 0
   Uint16      TRS1:1;     // 1   TRS for Mailbox 1
   Uint16      TRS2:1;     // 2   TRS for Mailbox 2
   Uint16      TRS3:1;     // 3   TRS for Mailbox 3
   Uint16      TRS4:1;     // 4   TRS for Mailbox 4
   Uint16      TRS5:1;     // 5   TRS for Mailbox 5
   Uint16      TRS6:1;     // 6   TRS for Mailbox 6
   Uint16      TRS7:1;     // 7   TRS for Mailbox 7
   Uint16      TRS8:1;     // 8   TRS for Mailbox 8
   Uint16      TRS9:1;     // 9   TRS for Mailbox 9
   Uint16      TRS10:1;    // 10  TRS for Mailbox 10
   Uint16      TRS11:1;    // 11  TRS for Mailbox 11
   Uint16      TRS12:1;    // 12  TRS for Mailbox 12
   Uint16      TRS13:1;    // 13  TRS for Mailbox 13
   Uint16      TRS14:1;    // 14  TRS for Mailbox 14
   Uint16      TRS15:1;    // 15  TRS for Mailbox 15
   Uint16      TRS16:1;    // 16  TRS for Mailbox 16
   Uint16      TRS17:1;    // 17  TRS for Mailbox 17
   Uint16      TRS18:1;    // 18  TRS for Mailbox 18
   Uint16      TRS19:1;    // 19  TRS for Mailbox 19
   Uint16      TRS20:1;    // 20  TRS for Mailbox 20
   Uint16      TRS21:1;    // 21  TRS for Mailbox 21
   Uint16      TRS22:1;    // 22  TRS for Mailbox 22
   Uint16      TRS23:1;    // 23  TRS for Mailbox 23
   Uint16      TRS24:1;    // 24  TRS for Mailbox 24
   Uint16      TRS25:1;    // 25  TRS for Mailbox 25
   Uint16      TRS26:1;    // 26  TRS for Mailbox 26
   Uint16      TRS27:1;    // 27  TRS for Mailbox 27
   Uint16      TRS28:1;    // 28  TRS for Mailbox 28
   Uint16      TRS29:1;    // 29  TRS for Mailbox 29
   Uint16      TRS30:1;    // 30  TRS for Mailbox 30
   Uint16      TRS31:1;    // 31  TRS for Mailbox 31

};

/* Allow access to the bit fields or entire register */
union CANTRS_REG {
   Uint32              all;
   struct CANTRS_BITS  bit;
};

/* eCAN Transmit Request Reset register (CANTRR) bit definitions */
struct  CANTRR_BITS {      // bit  description
   Uint16      TRR0:1;     // 0   TRR for Mailbox 0
   Uint16      TRR1:1;     // 1   TRR for Mailbox 1
   Uint16      TRR2:1;     // 2   TRR for Mailbox 2
   Uint16      TRR3:1;     // 3   TRR for Mailbox 3
   Uint16      TRR4:1;     // 4   TRR for Mailbox 4
   Uint16      TRR5:1;     // 5   TRR for Mailbox 5
   Uint16      TRR6:1;     // 6   TRR for Mailbox 6
   Uint16      TRR7:1;     // 7   TRR for Mailbox 7
   Uint16      TRR8:1;     // 8   TRR for Mailbox 8
   Uint16      TRR9:1;     // 9   TRR for Mailbox 9
   Uint16      TRR10:1;    // 10  TRR for Mailbox 10
   Uint16      TRR11:1;    // 11  TRR for Mailbox 11
   Uint16      TRR12:1;    // 12  TRR for Mailbox 12
   Uint16      TRR13:1;    // 13  TRR for Mailbox 13
   Uint16      TRR14:1;    // 14  TRR for Mailbox 14
   Uint16      TRR15:1;    // 15  TRR for Mailbox 15
   Uint16      TRR16:1;    // 16  TRR for Mailbox 16
   Uint16      TRR17:1;    // 17  TRR for Mailbox 17
   Uint16      TRR18:1;    // 18  TRR for Mailbox 18
   Uint16      TRR19:1;    // 19  TRR for Mailbox 19
   Uint16      TRR20:1;    // 20  TRR for Mailbox 20
   Uint16      TRR21:1;    // 21  TRR for Mailbox 21
   Uint16      TRR22:1;    // 22  TRR for Mailbox 22
   Uint16      TRR23:1;    // 23  TRR for Mailbox 23
   Uint16      TRR24:1;    // 24  TRR for Mailbox 24
   Uint16      TRR25:1;    // 25  TRR for Mailbox 25
   Uint16      TRR26:1;    // 26  TRR for Mailbox 26
   Uint16      TRR27:1;    // 27  TRR for Mailbox 27
   Uint16      TRR28:1;    // 28  TRR for Mailbox 28
   Uint16      TRR29:1;    // 29  TRR for Mailbox 29
   Uint16      TRR30:1;    // 30  TRR for Mailbox 30
   Uint16      TRR31:1;    // 31  TRR for Mailbox 31

};

/* Allow access to the bit fields or entire register */
union CANTRR_REG {
   Uint32              all;
   struct CANTRR_BITS  bit;
};

/* eCAN Transmit Acknowledge register (CANTA) bit definitions */
struct  CANTA_BITS {      // bit  description
   Uint16      TA0:1;     // 0   TA for Mailbox 0
   Uint16      TA1:1;     // 1   TA for Mailbox 1
   Uint16      TA2:1;     // 2   TA for Mailbox 2
   Uint16      TA3:1;     // 3   TA for Mailbox 3
   Uint16      TA4:1;     // 4   TA for Mailbox 4
   Uint16      TA5:1;     // 5   TA for Mailbox 5
   Uint16      TA6:1;     // 6   TA for Mailbox 6
   Uint16      TA7:1;     // 7   TA for Mailbox 7
   Uint16      TA8:1;     // 8   TA for Mailbox 8
   Uint16      TA9:1;     // 9   TA for Mailbox 9
   Uint16      TA10:1;    // 10  TA for Mailbox 10
   Uint16      TA11:1;    // 11  TA for Mailbox 11
   Uint16      TA12:1;    // 12  TA for Mailbox 12
   Uint16      TA13:1;    // 13  TA for Mailbox 13
   Uint16      TA14:1;    // 14  TA for Mailbox 14
   Uint16      TA15:1;    // 15  TA for Mailbox 15
   Uint16      TA16:1;    // 16  TA for Mailbox 16
   Uint16      TA17:1;    // 17  TA for Mailbox 17
   Uint16      TA18:1;    // 18  TA for Mailbox 18
   Uint16      TA19:1;    // 19  TA for Mailbox 19
   Uint16      TA20:1;    // 20  TA for Mailbox 20
   Uint16      TA21:1;    // 21  TA for Mailbox 21
   Uint16      TA22:1;    // 22  TA for Mailbox 22
   Uint16      TA23:1;    // 23  TA for Mailbox 23
   Uint16      TA24:1;    // 24  TA for Mailbox 24
   Uint16      TA25:1;    // 25  TA for Mailbox 25
   Uint16      TA26:1;    // 26  TA for Mailbox 26
   Uint16      TA27:1;    // 27  TA for Mailbox 27
   Uint16      TA28:1;    // 28  TA for Mailbox 28
   Uint16      TA29:1;    // 29  TA for Mailbox 29
   Uint16      TA30:1;    // 30  TA for Mailbox 30
   Uint16      TA31:1;    // 31  TA for Mailbox 31

};

/* Allow access to the bit fields or entire register */
union CANTA_REG {
   Uint32             all;
   struct CANTA_BITS  bit;
};

/* eCAN Transmit Abort Acknowledge register (CANAA) bit definitions */
struct  CANAA_BITS {      // bit  description
   Uint16      AA0:1;     // 0   AA for Mailbox 0
   Uint16      AA1:1;     // 1   AA for Mailbox 1
   Uint16      AA2:1;     // 2   AA for Mailbox 2
   Uint16      AA3:1;     // 3   AA for Mailbox 3
   Uint16      AA4:1;     // 4   AA for Mailbox 4
   Uint16      AA5:1;     // 5   AA for Mailbox 5
   Uint16      AA6:1;     // 6   AA for Mailbox 6
   Uint16      AA7:1;     // 7   AA for Mailbox 7
   Uint16      AA8:1;     // 8   AA for Mailbox 8
   Uint16      AA9:1;     // 9   AA for Mailbox 9
   Uint16      AA10:1;    // 10  AA for Mailbox 10
   Uint16      AA11:1;    // 11  AA for Mailbox 11
   Uint16      AA12:1;    // 12  AA for Mailbox 12
   Uint16      AA13:1;    // 13  AA for Mailbox 13
   Uint16      AA14:1;    // 14  AA for Mailbox 14
   Uint16      AA15:1;    // 15  AA for Mailbox 15
   Uint16      AA16:1;    // 16  AA for Mailbox 16
   Uint16      AA17:1;    // 17  AA for Mailbox 17
   Uint16      AA18:1;    // 18  AA for Mailbox 18
   Uint16      AA19:1;    // 19  AA for Mailbox 19
   Uint16      AA20:1;    // 20  AA for Mailbox 20
   Uint16      AA21:1;    // 21  AA for Mailbox 21
   Uint16      AA22:1;    // 22  AA for Mailbox 22
   Uint16      AA23:1;    // 23  AA for Mailbox 23
   Uint16      AA24:1;    // 24  AA for Mailbox 24
   Uint16      AA25:1;    // 25  AA for Mailbox 25
   Uint16      AA26:1;    // 26  AA for Mailbox 26
   Uint16      AA27:1;    // 27  AA for Mailbox 27
   Uint16      AA28:1;    // 28  AA for Mailbox 28
   Uint16      AA29:1;    // 29  AA for Mailbox 29
   Uint16      AA30:1;    // 30  AA for Mailbox 30
   Uint16      AA31:1;    // 31  AA for Mailbox 31

};

/* Allow access to the bit fields or entire register */
union CANAA_REG {
   Uint32             all;
   struct CANAA_BITS  bit;
};

/* eCAN Received Message Pending register (CANRMP) bit definitions */
struct  CANRMP_BITS {      // bit  description
   Uint16      RMP0:1;     // 0   RMP for Mailbox 0
   Uint16      RMP1:1;     // 1   RMP for Mailbox 1
   Uint16      RMP2:1;     // 2   RMP for Mailbox 2
   Uint16      RMP3:1;     // 3   RMP for Mailbox 3
   Uint16      RMP4:1;     // 4   RMP for Mailbox 4
   Uint16      RMP5:1;     // 5   RMP for Mailbox 5
   Uint16      RMP6:1;     // 6   RMP for Mailbox 6
   Uint16      RMP7:1;     // 7   RMP for Mailbox 7
   Uint16      RMP8:1;     // 8   RMP for Mailbox 8
   Uint16      RMP9:1;     // 9   RMP for Mailbox 9
   Uint16      RMP10:1;    // 10  RMP for Mailbox 10
   Uint16      RMP11:1;    // 11  RMP for Mailbox 11
   Uint16      RMP12:1;    // 12  RMP for Mailbox 12
   Uint16      RMP13:1;    // 13  RMP for Mailbox 13
   Uint16      RMP14:1;    // 14  RMP for Mailbox 14
   Uint16      RMP15:1;    // 15  RMP for Mailbox 15
   Uint16      RMP16:1;    // 16  RMP for Mailbox 16
   Uint16      RMP17:1;    // 17  RMP for Mailbox 17
   Uint16      RMP18:1;    // 18  RMP for Mailbox 18
   Uint16      RMP19:1;    // 19  RMP for Mailbox 19
   Uint16      RMP20:1;    // 20  RMP for Mailbox 20
   Uint16      RMP21:1;    // 21  RMP for Mailbox 21
   Uint16      RMP22:1;    // 22  RMP for Mailbox 22
   Uint16      RMP23:1;    // 23  RMP for Mailbox 23
   Uint16      RMP24:1;    // 24  RMP for Mailbox 24
   Uint16      RMP25:1;    // 25  RMP for Mailbox 25
   Uint16      RMP26:1;    // 26  RMP for Mailbox 26
   Uint16      RMP27:1;    // 27  RMP for Mailbox 27
   Uint16      RMP28:1;    // 28  RMP for Mailbox 28
   Uint16      RMP29:1;    // 29  RMP for Mailbox 29
   Uint16      RMP30:1;    // 30  RMP for Mailbox 30
   Uint16      RMP31:1;    // 31  RMP for Mailbox 31

};

/* Allow access to the bit fields or entire register */
union CANRMP_REG {
   Uint32              all;
   struct CANRMP_BITS  bit;
};

/* eCAN Received Message Lost register (CANRML) bit definitions */
struct  CANRML_BITS {      // bit  description
   Uint16      RML0:1;     // 0   RML for Mailbox 0
   Uint16      RML1:1;     // 1   RML for Mailbox 1
   Uint16      RML2:1;     // 2   RML for Mailbox 2
   Uint16      RML3:1;     // 3   RML for Mailbox 3
   Uint16      RML4:1;     // 4   RML for Mailbox 4
   Uint16      RML5:1;     // 5   RML for Mailbox 5
   Uint16      RML6:1;     // 6   RML for Mailbox 6
   Uint16      RML7:1;     // 7   RML for Mailbox 7
   Uint16      RML8:1;     // 8   RML for Mailbox 8
   Uint16      RML9:1;     // 9   RML for Mailbox 9
   Uint16      RML10:1;    // 10  RML for Mailbox 10
   Uint16      RML11:1;    // 11  RML for Mailbox 11
   Uint16      RML12:1;    // 12  RML for Mailbox 12
   Uint16      RML13:1;    // 13  RML for Mailbox 13
   Uint16      RML14:1;    // 14  RML for Mailbox 14
   Uint16      RML15:1;    // 15  RML for Mailbox 15
   Uint16      RML16:1;    // 16  RML for Mailbox 16
   Uint16      RML17:1;    // 17  RML for Mailbox 17
   Uint16      RML18:1;    // 18  RML for Mailbox 18
   Uint16      RML19:1;    // 19  RML for Mailbox 19
   Uint16      RML20:1;    // 20  RML for Mailbox 20
   Uint16      RML21:1;    // 21  RML for Mailbox 21
   Uint16      RML22:1;    // 22  RML for Mailbox 22
   Uint16      RML23:1;    // 23  RML for Mailbox 23
   Uint16      RML24:1;    // 24  RML for Mailbox 24
   Uint16      RML25:1;    // 25  RML for Mailbox 25
   Uint16      RML26:1;    // 26  RML for Mailbox 26
   Uint16      RML27:1;    // 27  RML for Mailbox 27
   Uint16      RML28:1;    // 28  RML for Mailbox 28
   Uint16      RML29:1;    // 29  RML for Mailbox 29
   Uint16      RML30:1;    // 30  RML for Mailbox 30
   Uint16      RML31:1;    // 31  RML for Mailbox 31

};

/* Allow access to the bit fields or entire register */
union CANRML_REG {
   Uint32              all;
   struct CANRML_BITS  bit;
};

/* eCAN Remote Frame Pending register (CANRFP) bit definitions */
struct  CANRFP_BITS {      // bit  description
   Uint16      RFP0:1;     // 0   RFP for Mailbox 0
   Uint16      RFP1:1;     // 1   RFP for Mailbox 1
   Uint16      RFP2:1;     // 2   RFP for Mailbox 2
   Uint16      RFP3:1;     // 3   RFP for Mailbox 3
   Uint16      RFP4:1;     // 4   RFP for Mailbox 4
   Uint16      RFP5:1;     // 5   RFP for Mailbox 5
   Uint16      RFP6:1;     // 6   RFP for Mailbox 6
   Uint16      RFP7:1;     // 7   RFP for Mailbox 7
   Uint16      RFP8:1;     // 8   RFP for Mailbox 8
   Uint16      RFP9:1;     // 9   RFP for Mailbox 9
   Uint16      RFP10:1;    // 10  RFP for Mailbox 10
   Uint16      RFP11:1;    // 11  RFP for Mailbox 11
   Uint16      RFP12:1;    // 12  RFP for Mailbox 12
   Uint16      RFP13:1;    // 13  RFP for Mailbox 13
   Uint16      RFP14:1;    // 14  RFP for Mailbox 14
   Uint16      RFP15:1;    // 15  RFP for Mailbox 15
   Uint16      RFP16:1;    // 16  RFP for Mailbox 16
   Uint16      RFP17:1;    // 17  RFP for Mailbox 17
   Uint16      RFP18:1;    // 18  RFP for Mailbox 18
   Uint16      RFP19:1;    // 19  RFP for Mailbox 19
   Uint16      RFP20:1;    // 20  RFP for Mailbox 20
   Uint16      RFP21:1;    // 21  RFP for Mailbox 21
   Uint16      RFP22:1;    // 22  RFP for Mailbox 22
   Uint16      RFP23:1;    // 23  RFP for Mailbox 23
   Uint16      RFP24:1;    // 24  RFP for Mailbox 24
   Uint16      RFP25:1;    // 25  RFP for Mailbox 25
   Uint16      RFP26:1;    // 26  RFP for Mailbox 26
   Uint16      RFP27:1;    // 27  RFP for Mailbox 27
   Uint16      RFP28:1;    // 28  RFP for Mailbox 28
   Uint16      RFP29:1;    // 29  RFP for Mailbox 29
   Uint16      RFP30:1;    // 30  RFP for Mailbox 30
   Uint16      RFP31:1;    // 31  RFP for Mailbox 31

};

/* Allow access to the bit fields or entire register */
union CANRFP_REG {
   Uint32              all;
   struct CANRFP_BITS  bit;
};

/* eCAN Global Acceptance Mask register (CANGAM) bit definitions */
struct  CANGAM_BITS {   // bits  description
   Uint16 GAM150:16;    // 15:0  Global acceptance mask bits 0-15
   Uint16 GAM2816:13;   // 28:16 Global acceptance mask bits 16-28
   Uint16 rsvd:2;       // 30:29 reserved
   Uint16 AMI:1;        // 31    AMI bit
};

/* Allow access to the bit fields or entire register */
union CANGAM_REG {
   Uint32              all;
   struct CANGAM_BITS  bit;
};

/* eCAN Master Control register (CANMC) bit definitions */
struct  CANMC_BITS {       // bits  description
   Uint16      MBNR:5;     // 4:0   MBX # for CDR bit
   Uint16      SRES:1;     // 5     Soft reset
   Uint16      STM:1;      // 6     Self-test mode
   Uint16      ABO:1;      // 7     Auto bus-on
   Uint16      CDR:1;      // 8     Change data request
   Uint16      WUBA:1;     // 9     Wake-up on bus activity
   Uint16      DBO:1;      // 10    Data-byte order
   Uint16      PDR:1;      // 11    Power-down mode request
   Uint16      CCR:1;      // 12    Change configuration request
   Uint16      SCB:1;      // 13    SCC compatibility bit
   Uint16      TCC:1;      // 14    TSC MSB clear bit
   Uint16      MBCC:1;     // 15    TSC clear bit thru mailbox 16
   Uint16      SUSP:1;     // 16    SUSPEND free/soft bit
   Uint16      rsvd:15;    // 31:17  reserved
};

/* Allow access to the bit fields or entire register */
union CANMC_REG {
   Uint32             all;
   struct CANMC_BITS  bit;
};

/* eCAN Bit -timing configuration register (CANBTC) bit definitions */
struct  CANBTC_BITS {  // bits  description
   Uint16  TSEG2REG:3; // 2:0   TSEG2 register value
   Uint16  TSEG1REG:4; // 6:3   TSEG1 register value
   Uint16  SAM:1;      // 7     Sample-point setting
   Uint16  SJWREG:2;   // 9:8   Synchroniztion Jump Width register value
   Uint16  rsvd1:6;    // 15:10 reserved
   Uint16  BRPREG:8;   // 23:16 Baudrate prescaler register value
   Uint16  rsvd2:8;    // 31:24 reserved
};

/* Allow access to the bit fields or entire register */
union CANBTC_REG {
   Uint32              all;
   struct CANBTC_BITS  bit;
};

/* eCAN Error & Status register (CANES) bit definitions */
struct  CANES_BITS {    // bits  description
   Uint16   TM:1;       // 0     Transmit Mode
   Uint16   RM:1;       // 1     Receive Mode
   Uint16   rsvd1:1;    // 2     reserved
   Uint16   PDA:1;      // 3     Power-down acknowledge
   Uint16   CCE:1;      // 4     Change Configuration Enable
   Uint16   SMA:1;      // 5     Suspend Mode Acknowledge
   Uint16   rsvd2:10;   // 15:6  reserved
   Uint16   EW:1;       // 16    Warning status
   Uint16   EP:1;       // 17    Error Passive status
   Uint16   BO:1;       // 18    Bus-off status
   Uint16   ACKE:1;     // 19    Acknowledge error
   Uint16   SE:1;       // 20    Stuff error
   Uint16   CRCE:1;     // 21    CRC error
   Uint16   SA1:1;      // 22    Stuck at Dominant error
   Uint16   BE:1;       // 23    Bit error
   Uint16   FE:1;       // 24    Framing error
   Uint16   rsvd3:7;    // 31:25 reserved
};

/* Allow access to the bit fields or entire register */
union CANES_REG {
   Uint32             all;
   struct CANES_BITS  bit;
};

/* eCAN Transmit Error Counter register (CANTEC) bit definitions */
struct  CANTEC_BITS {  // bits  description
   Uint16 TEC:8;       // 7:0   TEC
   Uint16 rsvd1:8;     // 15:8  reserved
   Uint16 rsvd2:16;    // 31:16  reserved
};

/* Allow access to the bit fields or entire register */
union CANTEC_REG {
   Uint32              all;
   struct CANTEC_BITS  bit;
};

/* eCAN Receive Error Counter register (CANREC) bit definitions */
struct  CANREC_BITS {  // bits  description
   Uint16 REC:8;       // 7:0   REC
   Uint16 rsvd1:8;     // 15:8  reserved
   Uint16 rsvd2:16;    // 31:16 reserved
};

/* Allow access to the bit fields or entire register */
union CANREC_REG {
   Uint32              all;
   struct CANREC_BITS  bit;
};

/* eCAN Global Interrupt Flag 0 (CANGIF0) bit definitions */
struct  CANGIF0_BITS {  // bits  description
   Uint16   MIV0:5;     // 4:0   Mailbox Interrupt Vector
   Uint16   rsvd1:3;    // 7:5   reserved
   Uint16   WLIF0:1;    // 8     Warning level interrupt flag
   Uint16   EPIF0:1;    // 9     Error-passive interrupt flag
   Uint16   BOIF0:1;    // 10    Bus-off interrupt flag
   Uint16   RMLIF0:1;   // 11    Received message lost interrupt flag
   Uint16   WUIF0:1;    // 12    Wakeup interrupt flag
   Uint16   WDIF0:1;    // 13    Write denied interrupt flag
   Uint16   AAIF0:1;    // 14    Abort Ack interrupt flag
   Uint16   GMIF0:1;    // 15    Global MBX interrupt flag
   Uint16   TCOF0:1;    // 16    TSC Overflow flag
   Uint16   MTOF0:1;    // 17    Mailbox Timeout flag
   Uint16   rsvd2:14;   // 31:18 reserved
};

/* Allow access to the bit fields or entire register */
union CANGIF0_REG {
   Uint32               all;
   struct CANGIF0_BITS  bit;
};

/* eCAN Global Interrupt Mask register (CANGIM) bit definitions */
struct  CANGIM_BITS { // bits  description
   Uint16  I0EN:1;    // 0      Interrupt 0 enable
   Uint16  I1EN:1;    // 1      Interrupt 1 enable
   Uint16  GIL:1;     // 2      Global Interrupt Level
   Uint16  rsvd1:5;   // 7:3    reserved
   Uint16  WLIM:1;    // 8      Warning level interrupt mask
   Uint16  EPIM:1;    // 9      Error-passive interrupt mask
   Uint16  BOIM:1;    // 10     Bus-off interrupt mask
   Uint16  RMLIM:1;   // 11     Received message lost interrupt mask
   Uint16  WUIM:1;    // 12     Wakeup interrupt mask
   Uint16  WDIM:1;    // 13     Write denied interrupt mask
   Uint16  AAIM:1;    // 14     Abort Ack interrupt mask
   Uint16  rsvd2:1;   // 15     reserved
   Uint16  TCOM:1;    // 16     TSC overflow interrupt mask
   Uint16  MTOM:1;    // 17     MBX Timeout interrupt mask
   Uint16  rsvd3:14;  // 31:18  reserved
};

/* Allow access to the bit fields or entire register */
union CANGIM_REG {
   Uint32              all;
   struct CANGIM_BITS  bit;
};

/* eCAN Global Interrupt Flag 1 (eCANGIF1) bit definitions */
struct  CANGIF1_BITS {     // bits  description
   Uint16      MIV1:5;     // 4:0   Mailbox Interrupt Vector
   Uint16      rsvd1:3;    // 7:5   reserved
   Uint16      WLIF1:1;    // 8     Warning level interrupt flag
   Uint16      EPIF1:1;    // 9     Error-passive interrupt flag
   Uint16      BOIF1:1;    // 10    Bus-off interrupt flag
   Uint16      RMLIF1:1;   // 11    Received message lost interrupt flag
   Uint16      WUIF1:1;    // 12    Wakeup interrupt flag
   Uint16      WDIF1:1;    // 13    Write denied interrupt flag
   Uint16      AAIF1:1;    // 14    Abort Ack interrupt flag
   Uint16      GMIF1:1;    // 15    Global MBX interrupt flag
   Uint16      TCOF1:1;    // 16    TSC Overflow flag
   Uint16      MTOF1:1;    // 17    Mailbox Timeout flag
   Uint16      rsvd2:14;   // 31:18 reserved
};

/* Allow access to the bit fields or entire register */
union CANGIF1_REG {
   Uint32               all;
   struct CANGIF1_BITS  bit;
};

/* eCAN Mailbox Interrupt Mask register (CANMIM) bit definitions */
struct  CANMIM_BITS {      // bit  description
   Uint16      MIM0:1;     // 0   MIM for Mailbox 0
   Uint16      MIM1:1;     // 1   MIM for Mailbox 1
   Uint16      MIM2:1;     // 2   MIM for Mailbox 2
   Uint16      MIM3:1;     // 3   MIM for Mailbox 3
   Uint16      MIM4:1;     // 4   MIM for Mailbox 4
   Uint16      MIM5:1;     // 5   MIM for Mailbox 5
   Uint16      MIM6:1;     // 6   MIM for Mailbox 6
   Uint16      MIM7:1;     // 7   MIM for Mailbox 7
   Uint16      MIM8:1;     // 8   MIM for Mailbox 8
   Uint16      MIM9:1;     // 9   MIM for Mailbox 9
   Uint16      MIM10:1;    // 10  MIM for Mailbox 10
   Uint16      MIM11:1;    // 11  MIM for Mailbox 11
   Uint16      MIM12:1;    // 12  MIM for Mailbox 12
   Uint16      MIM13:1;    // 13  MIM for Mailbox 13
   Uint16      MIM14:1;    // 14  MIM for Mailbox 14
   Uint16      MIM15:1;    // 15  MIM for Mailbox 15
   Uint16      MIM16:1;    // 16  MIM for Mailbox 16
   Uint16      MIM17:1;    // 17  MIM for Mailbox 17
   Uint16      MIM18:1;    // 18  MIM for Mailbox 18
   Uint16      MIM19:1;    // 19  MIM for Mailbox 19
   Uint16      MIM20:1;    // 20  MIM for Mailbox 20
   Uint16      MIM21:1;    // 21  MIM for Mailbox 21
   Uint16      MIM22:1;    // 22  MIM for Mailbox 22
   Uint16      MIM23:1;    // 23  MIM for Mailbox 23
   Uint16      MIM24:1;    // 24  MIM for Mailbox 24
   Uint16      MIM25:1;    // 25  MIM for Mailbox 25
   Uint16      MIM26:1;    // 26  MIM for Mailbox 26
   Uint16      MIM27:1;    // 27  MIM for Mailbox 27
   Uint16      MIM28:1;    // 28  MIM for Mailbox 28
   Uint16      MIM29:1;    // 29  MIM for Mailbox 29
   Uint16      MIM30:1;    // 30  MIM for Mailbox 30
   Uint16      MIM31:1;    // 31  MIM for Mailbox 31

};

/* Allow access to the bit fields or entire register */
union CANMIM_REG {
   Uint32              all;
   struct CANMIM_BITS  bit;
};

/* eCAN Mailbox Interrupt Level register (CANMIL) bit definitions */
struct  CANMIL_BITS {      // bit  description
   Uint16      MIL0:1;     // 0   0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL1:1;     // 1   0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL2:1;     // 2   0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL3:1;     // 3   0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL4:1;     // 4   0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL5:1;     // 5   0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL6:1;     // 6   0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL7:1;     // 7   0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL8:1;     // 8   0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL9:1;     // 9   0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL10:1;    // 10  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL11:1;    // 11  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL12:1;    // 12  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL13:1;    // 13  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL14:1;    // 14  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL15:1;    // 15  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL16:1;    // 16  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL17:1;    // 17  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL18:1;    // 18  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL19:1;    // 19  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL20:1;    // 20  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL21:1;    // 21  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL22:1;    // 22  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL23:1;    // 23  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL24:1;    // 24  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL25:1;    // 25  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL26:1;    // 26  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL27:1;    // 27  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL28:1;    // 28  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL29:1;    // 29  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL30:1;    // 30  0 -> Int 9.5   1 -> Int 9.6
   Uint16      MIL31:1;    // 31  0 -> Int 9.5   1 -> Int 9.6

};

/* Allow access to the bit fields or entire register */
union CANMIL_REG {
   Uint32              all;
   struct CANMIL_BITS  bit;
};

/* eCAN Overwrite Protection Control register (CANOPC) bit definitions */
struct  CANOPC_BITS {      // bit  description
   Uint16      OPC0:1;     // 0   OPC for Mailbox 0
   Uint16      OPC1:1;     // 1   OPC for Mailbox 1
   Uint16      OPC2:1;     // 2   OPC for Mailbox 2
   Uint16      OPC3:1;     // 3   OPC for Mailbox 3
   Uint16      OPC4:1;     // 4   OPC for Mailbox 4
   Uint16      OPC5:1;     // 5   OPC for Mailbox 5
   Uint16      OPC6:1;     // 6   OPC for Mailbox 6
   Uint16      OPC7:1;     // 7   OPC for Mailbox 7
   Uint16      OPC8:1;     // 8   OPC for Mailbox 8
   Uint16      OPC9:1;     // 9   OPC for Mailbox 9
   Uint16      OPC10:1;    // 10  OPC for Mailbox 10
   Uint16      OPC11:1;    // 11  OPC for Mailbox 11
   Uint16      OPC12:1;    // 12  OPC for Mailbox 12
   Uint16      OPC13:1;    // 13  OPC for Mailbox 13
   Uint16      OPC14:1;    // 14  OPC for Mailbox 14
   Uint16      OPC15:1;    // 15  OPC for Mailbox 15
   Uint16      OPC16:1;    // 16  OPC for Mailbox 16
   Uint16      OPC17:1;    // 17  OPC for Mailbox 17
   Uint16      OPC18:1;    // 18  OPC for Mailbox 18
   Uint16      OPC19:1;    // 19  OPC for Mailbox 19
   Uint16      OPC20:1;    // 20  OPC for Mailbox 20
   Uint16      OPC21:1;    // 21  OPC for Mailbox 21
   Uint16      OPC22:1;    // 22  OPC for Mailbox 22
   Uint16      OPC23:1;    // 23  OPC for Mailbox 23
   Uint16      OPC24:1;    // 24  OPC for Mailbox 24
   Uint16      OPC25:1;    // 25  OPC for Mailbox 25
   Uint16      OPC26:1;    // 26  OPC for Mailbox 26
   Uint16      OPC27:1;    // 27  OPC for Mailbox 27
   Uint16      OPC28:1;    // 28  OPC for Mailbox 28
   Uint16      OPC29:1;    // 29  OPC for Mailbox 29
   Uint16      OPC30:1;    // 30  OPC for Mailbox 30
   Uint16      OPC31:1;    // 31  OPC for Mailbox 31

};

/* Allow access to the bit fields or entire register */
union CANOPC_REG {
   Uint32              all;
   struct CANOPC_BITS  bit;
};

/* eCAN TX I/O Control Register (CANTIOC) bit definitions */
struct  CANTIOC_BITS { // bits  description
   Uint16  rsvd1:3;    // 2:0   reserved
   Uint16  TXFUNC:1;   // 3     TXFUNC
   Uint16  rsvd2:12;   // 15:4  reserved
   Uint16  rsvd3:16;   // 31:16 reserved
};

/* Allow access to the bit fields or entire register */
union CANTIOC_REG {
   Uint32               all;
   struct CANTIOC_BITS  bit;
};

/* eCAN RX I/O Control Register (CANRIOC) bit definitions */
struct  CANRIOC_BITS { // bits  description
   Uint16  rsvd1:3;    // 2:0   reserved
   Uint16  RXFUNC:1;   // 3     RXFUNC
   Uint16  rsvd2:12;   // 15:4  reserved
   Uint16  rsvd3:16;   // 31:16 reserved
};

/* Allow access to the bit fields or entire register */
union CANRIOC_REG {
   Uint32               all;
   struct CANRIOC_BITS  bit;
};

/* eCAN Time-out Control register (CANTOC) bit definitions */
struct  CANTOC_BITS {      // bit  description
   Uint16      TOC0:1;     // 0   TOC for Mailbox 0
   Uint16      TOC1:1;     // 1   TOC for Mailbox 1
   Uint16      TOC2:1;     // 2   TOC for Mailbox 2
   Uint16      TOC3:1;     // 3   TOC for Mailbox 3
   Uint16      TOC4:1;     // 4   TOC for Mailbox 4
   Uint16      TOC5:1;     // 5   TOC for Mailbox 5
   Uint16      TOC6:1;     // 6   TOC for Mailbox 6
   Uint16      TOC7:1;     // 7   TOC for Mailbox 7
   Uint16      TOC8:1;     // 8   TOC for Mailbox 8
   Uint16      TOC9:1;     // 9   TOC for Mailbox 9
   Uint16      TOC10:1;    // 10  TOC for Mailbox 10
   Uint16      TOC11:1;    // 11  TOC for Mailbox 11
   Uint16      TOC12:1;    // 12  TOC for Mailbox 12
   Uint16      TOC13:1;    // 13  TOC for Mailbox 13
   Uint16      TOC14:1;    // 14  TOC for Mailbox 14
   Uint16      TOC15:1;    // 15  TOC for Mailbox 15
   Uint16      TOC16:1;    // 16  TOC for Mailbox 16
   Uint16      TOC17:1;    // 17  TOC for Mailbox 17
   Uint16      TOC18:1;    // 18  TOC for Mailbox 18
   Uint16      TOC19:1;    // 19  TOC for Mailbox 19
   Uint16      TOC20:1;    // 20  TOC for Mailbox 20
   Uint16      TOC21:1;    // 21  TOC for Mailbox 21
   Uint16      TOC22:1;    // 22  TOC for Mailbox 22
   Uint16      TOC23:1;    // 23  TOC for Mailbox 23
   Uint16      TOC24:1;    // 24  TOC for Mailbox 24
   Uint16      TOC25:1;    // 25  TOC for Mailbox 25
   Uint16      TOC26:1;    // 26  TOC for Mailbox 26
   Uint16      TOC27:1;    // 27  TOC for Mailbox 27
   Uint16      TOC28:1;    // 28  TOC for Mailbox 28
   Uint16      TOC29:1;    // 29  TOC for Mailbox 29
   Uint16      TOC30:1;    // 30  TOC for Mailbox 30
   Uint16      TOC31:1;    // 31  TOC for Mailbox 31

};

/* Allow access to the bit fields or entire register */
union CANTOC_REG {
   Uint32              all;
   struct CANTOC_BITS  bit;
};

/* eCAN Time-out Status register (CANTOS) bit definitions */
struct  CANTOS_BITS {            // bit  description
   Uint16      TOS0:1;     // 0   TOS for Mailbox 0
   Uint16      TOS1:1;     // 1   TOS for Mailbox 1
   Uint16      TOS2:1;     // 2   TOS for Mailbox 2
   Uint16      TOS3:1;     // 3   TOS for Mailbox 3
   Uint16      TOS4:1;     // 4   TOS for Mailbox 4
   Uint16      TOS5:1;     // 5   TOS for Mailbox 5
   Uint16      TOS6:1;     // 6   TOS for Mailbox 6
   Uint16      TOS7:1;     // 7   TOS for Mailbox 7
   Uint16      TOS8:1;     // 8   TOS for Mailbox 8
   Uint16      TOS9:1;     // 9   TOS for Mailbox 9
   Uint16      TOS10:1;    // 10  TOS for Mailbox 10
   Uint16      TOS11:1;    // 11  TOS for Mailbox 11
   Uint16      TOS12:1;    // 12  TOS for Mailbox 12
   Uint16      TOS13:1;    // 13  TOS for Mailbox 13
   Uint16      TOS14:1;    // 14  TOS for Mailbox 14
   Uint16      TOS15:1;    // 15  TOS for Mailbox 15
   Uint16      TOS16:1;    // 16  TOS for Mailbox 16
   Uint16      TOS17:1;    // 17  TOS for Mailbox 17
   Uint16      TOS18:1;    // 18  TOS for Mailbox 18
   Uint16      TOS19:1;    // 19  TOS for Mailbox 19
   Uint16      TOS20:1;    // 20  TOS for Mailbox 20
   Uint16      TOS21:1;    // 21  TOS for Mailbox 21
   Uint16      TOS22:1;    // 22  TOS for Mailbox 22
   Uint16      TOS23:1;    // 23  TOS for Mailbox 23
   Uint16      TOS24:1;    // 24  TOS for Mailbox 24
   Uint16      TOS25:1;    // 25  TOS for Mailbox 25
   Uint16      TOS26:1;    // 26  TOS for Mailbox 26
   Uint16      TOS27:1;    // 27  TOS for Mailbox 27
   Uint16      TOS28:1;    // 28  TOS for Mailbox 28
   Uint16      TOS29:1;    // 29  TOS for Mailbox 29
   Uint16      TOS30:1;    // 30  TOS for Mailbox 30
   Uint16      TOS31:1;    // 31  TOS for Mailbox 31

};

/* Allow access to the bit fields or entire register */
union CANTOS_REG {
   Uint32              all;
   struct CANTOS_BITS  bit;
};

/**************************************/
/* eCAN Control & Status register file */
/**************************************/

struct ECAN_REGS {
   union CANME_REG   CANME;          // Mailbox Enable
   union CANMD_REG   CANMD;          // Mailbox Direction
   union CANTRS_REG  CANTRS;         // Transmit Request Set
   union CANTRR_REG  CANTRR;         // Transmit Request Reset
   union CANTA_REG   CANTA;          // Transmit Acknowledge
   union CANAA_REG   CANAA;          // Abort Acknowledge
   union CANRMP_REG  CANRMP;         // Received Message Pending
   union CANRML_REG  CANRML;         // Received Message Lost
   union CANRFP_REG  CANRFP;         // Remote Frame Pending
   union CANGAM_REG  CANGAM;         // Global Acceptance Mask
   union CANMC_REG   CANMC;          // Master Control
   union CANBTC_REG  CANBTC;         // Bit Timing
   union CANES_REG   CANES;          // Error Status
   union CANTEC_REG  CANTEC;         // Transmit Error Counter
   union CANREC_REG  CANREC;         // Receive Error Counter
   union CANGIF0_REG CANGIF0;        // Global Interrupt Flag 0
   union CANGIM_REG  CANGIM;         // Global Interrupt Mask 0
   union CANGIF1_REG CANGIF1;        // Global Interrupt Flag 1
   union CANMIM_REG  CANMIM;         // Mailbox Interrupt Mask
   union CANMIL_REG  CANMIL;         // Mailbox Interrupt Level
   union CANOPC_REG  CANOPC;         // Overwrite Protection Control
   union CANTIOC_REG CANTIOC;        // TX I/O Control
   union CANRIOC_REG CANRIOC;        // RX I/O Control
   Uint32            CANTSC;         // Time-stamp counter
   union CANTOC_REG  CANTOC;         // Time-out Control
   union CANTOS_REG  CANTOS;         // Time-out Status

};

/* --------------------------------------------------- */
/* eCAN Mailbox Registers                               */
/* ----------------------------------------------------*/

/* eCAN Message ID (MSGID) bit definitions */
struct  CANMSGID_BITS {        // bits  description
   Uint16      EXTMSGID_L:16;  // 0:15
   Uint16      EXTMSGID_H:2;   // 16:17
   Uint16      STDMSGID:11;    // 18:28
   Uint16      AAM:1;          // 29
   Uint16      AME:1;          // 30
   Uint16      IDE:1;          // 31

};

/* Allow access to the bit fields or entire register */
union CANMSGID_REG {
   Uint32                all;
   struct CANMSGID_BITS  bit;
};

/* eCAN Message Control Field (MSGCTRL) bit definitions */
struct  CANMSGCTRL_BITS {     // bits  description
   Uint16 DLC:4;          // 0:3
   Uint16 RTR:1;          // 4
   Uint16 rsvd1:3;        // 7:5   reserved
   Uint16 TPL:5;          // 12:8
   Uint16 rsvd2:3;        // 15:13 reserved
   Uint16 rsvd3:16;       // 31:16 reserved
};

/* Allow access to the bit fields or entire register */
union CANMSGCTRL_REG {
   Uint32                  all;
   struct CANMSGCTRL_BITS  bit;
};

/* eCAN Message Data Register low (MDR_L) word definitions */
struct  CANMDL_WORDS {      // bits  description
   Uint16      LOW_WORD:16; // 0:15
   Uint16      HI_WORD:16;  // 31:16
};

/* eCAN Message Data Register low (MDR_L) byte definitions */
struct  CANMDL_BYTES {      // bits   description
   Uint16      BYTE3:8;     // 31:24
   Uint16      BYTE2:8;     // 23:16
   Uint16      BYTE1:8;     // 15:8
   Uint16      BYTE0:8;     // 7:0
};

/* Allow access to the bit fields or entire register */

union CANMDL_REG {
   Uint32                all;
   struct CANMDL_WORDS   word;
   struct CANMDL_BYTES   byte;
};

/* eCAN Message Data Register high  (MDR_H) word definitions */
struct  CANMDH_WORDS {         // bits  description
   Uint16      LOW_WORD:16;    // 0:15
   Uint16      HI_WORD:16;     // 31:16
};

/* eCAN Message Data Register low (MDR_H) byte definitions */
struct  CANMDH_BYTES {      // bits   description
   Uint16      BYTE7:8;     // 63:56
   Uint16      BYTE6:8;     // 55:48
   Uint16      BYTE5:8;     // 47:40
   Uint16      BYTE4:8;     // 39:32
};

/* Allow access to the bit fields or entire register */
union CANMDH_REG {
   Uint32                  all;
   struct CANMDH_WORDS     word;
   struct CANMDH_BYTES     byte;
};

struct MBOX {
   union CANMSGID_REG     MSGID;
   union CANMSGCTRL_REG   MSGCTRL;
   union CANMDL_REG       MDL;
   union CANMDH_REG       MDH;
};

/**************************************/
/*          eCAN Mailboxes             */
/**************************************/

struct ECAN_MBOXES {
   struct MBOX MBOX0;
   struct MBOX MBOX1;
   struct MBOX MBOX2;
   struct MBOX MBOX3;
   struct MBOX MBOX4;
   struct MBOX MBOX5;
   struct MBOX MBOX6;
   struct MBOX MBOX7;
   struct MBOX MBOX8;
   struct MBOX MBOX9;
   struct MBOX MBOX10;
   struct MBOX MBOX11;
   struct MBOX MBOX12;
   struct MBOX MBOX13;
   struct MBOX MBOX14;
   struct MBOX MBOX15;
   struct MBOX MBOX16;
   struct MBOX MBOX17;
   struct MBOX MBOX18;
   struct MBOX MBOX19;
   struct MBOX MBOX20;
   struct MBOX MBOX21;
   struct MBOX MBOX22;
   struct MBOX MBOX23;
   struct MBOX MBOX24;
   struct MBOX MBOX25;
   struct MBOX MBOX26;
   struct MBOX MBOX27;
   struct MBOX MBOX28;
   struct MBOX MBOX29;
   struct MBOX MBOX30;
   struct MBOX MBOX31;
};

/* eCAN Local Acceptance Mask (LAM) bit definitions */
struct  CANLAM_BITS {                // bits  description
   Uint16      LAM_L:16;     // 0:15
   Uint16      LAM_H:13;     // 16:28
   Uint16 rsvd1:2;           // 29:30   reserved
   Uint16      LAMI:1;       // 31
};

/* Allow access to the bit fields or entire register */
union CANLAM_REG {
   Uint32        all;
   struct CANLAM_BITS  bit;
};

/**************************************/
/*    eCAN Local Acceptance Masks      */
/**************************************/

/* eCAN LAM File */
struct LAM_REGS {
   union CANLAM_REG LAM0;
   union CANLAM_REG LAM1;
   union CANLAM_REG LAM2;
   union CANLAM_REG LAM3;
   union CANLAM_REG LAM4;
   union CANLAM_REG LAM5;
   union CANLAM_REG LAM6;
   union CANLAM_REG LAM7;
   union CANLAM_REG LAM8;
   union CANLAM_REG LAM9;
   union CANLAM_REG LAM10;
   union CANLAM_REG LAM11;
   union CANLAM_REG LAM12;
   union CANLAM_REG LAM13;
   union CANLAM_REG LAM14;
   union CANLAM_REG LAM15;
   union CANLAM_REG LAM16;
   union CANLAM_REG LAM17;
   union CANLAM_REG LAM18;
   union CANLAM_REG LAM19;
   union CANLAM_REG LAM20;
   union CANLAM_REG LAM21;
   union CANLAM_REG LAM22;
   union CANLAM_REG LAM23;
   union CANLAM_REG LAM24;
   union CANLAM_REG LAM25;
   union CANLAM_REG LAM26;
   union CANLAM_REG LAM27;
   union CANLAM_REG LAM28;
   union CANLAM_REG LAM29;
   union CANLAM_REG LAM30;
   union CANLAM_REG LAM31;
};

/* Mailbox MOTS File */

struct MOTS_REGS {
   Uint32 MOTS0;
   Uint32 MOTS1;
   Uint32 MOTS2;
   Uint32 MOTS3;
   Uint32 MOTS4;
   Uint32 MOTS5;
   Uint32 MOTS6;
   Uint32 MOTS7;
   Uint32 MOTS8;
   Uint32 MOTS9;
   Uint32 MOTS10;
   Uint32 MOTS11;
   Uint32 MOTS12;
   Uint32 MOTS13;
   Uint32 MOTS14;
   Uint32 MOTS15;
   Uint32 MOTS16;
   Uint32 MOTS17;
   Uint32 MOTS18;
   Uint32 MOTS19;
   Uint32 MOTS20;
   Uint32 MOTS21;
   Uint32 MOTS22;
   Uint32 MOTS23;
   Uint32 MOTS24;
   Uint32 MOTS25;
   Uint32 MOTS26;
   Uint32 MOTS27;
   Uint32 MOTS28;
   Uint32 MOTS29;
   Uint32 MOTS30;
   Uint32 MOTS31;
};

/* Mailbox MOTO File */

struct MOTO_REGS {
   Uint32 MOTO0;
   Uint32 MOTO1;
   Uint32 MOTO2;
   Uint32 MOTO3;
   Uint32 MOTO4;
   Uint32 MOTO5;
   Uint32 MOTO6;
   Uint32 MOTO7;
   Uint32 MOTO8;
   Uint32 MOTO9;
   Uint32 MOTO10;
   Uint32 MOTO11;
   Uint32 MOTO12;
   Uint32 MOTO13;
   Uint32 MOTO14;
   Uint32 MOTO15;
   Uint32 MOTO16;
   Uint32 MOTO17;
   Uint32 MOTO18;
   Uint32 MOTO19;
   Uint32 MOTO20;
   Uint32 MOTO21;
   Uint32 MOTO22;
   Uint32 MOTO23;
   Uint32 MOTO24;
   Uint32 MOTO25;
   Uint32 MOTO26;
   Uint32 MOTO27;
   Uint32 MOTO28;
   Uint32 MOTO29;
   Uint32 MOTO30;
   Uint32 MOTO31;
};

//---------------------------------------------------------------------------
// eCAN External References & Function Declarations:
//
extern volatile struct ECAN_REGS ECanaRegs;
extern volatile struct ECAN_MBOXES ECanaMboxes;
extern volatile struct LAM_REGS ECanaLAMRegs;
extern volatile struct MOTO_REGS ECanaMOTORegs;
extern volatile struct MOTS_REGS ECanaMOTSRegs;



//===========================================================================
// End of file.
//===========================================================================
//###########################################################################
//
// FILE:   DSP2803x_ECap.h
//
// TITLE:  DSP2803x Enhanced Capture Module Register Bit Definitions.
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



//----------------------------------------------------
// Capture control register 1 bit definitions */
struct ECCTL1_BITS {          // bits   description
   Uint16 CAP1POL:1;          // 0      Capture Event 1 Polarity select
   Uint16 CTRRST1:1;          // 1      Counter Reset on Capture Event 1
   Uint16 CAP2POL:1;          // 2      Capture Event 2 Polarity select
   Uint16 CTRRST2:1;          // 3      Counter Reset on Capture Event 2
   Uint16 CAP3POL:1;          // 4      Capture Event 3 Polarity select
   Uint16 CTRRST3:1;          // 5      Counter Reset on Capture Event 3
   Uint16 CAP4POL:1;          // 6      Capture Event 4 Polarity select
   Uint16 CTRRST4:1;          // 7      Counter Reset on Capture Event 4
   Uint16 CAPLDEN:1;          // 8      Enable Loading CAP1-4 regs on a Cap Event
   Uint16 PRESCALE:5;         // 13:9   Event Filter prescale select
   Uint16 FREE_SOFT:2;        // 15:14  Emulation mode
};

union ECCTL1_REG {
   Uint16              all;
   struct ECCTL1_BITS  bit;
};

// In V1.1 the STOPVALUE bit field was changed to
// STOP_WRAP.  This correlated to a silicon change from
// F2803x Rev 0 to Rev A.
//----------------------------------------------------
// Capture control register 2 bit definitions */
struct ECCTL2_BITS {          // bits   description
   Uint16 CONT_ONESHT:1;      // 0      Continuous or one-shot
   Uint16 STOP_WRAP:2;        // 2:1    Stop value for one-shot, Wrap for continuous
   Uint16 REARM:1;            // 3      One-shot re-arm
   Uint16 TSCTRSTOP:1;        // 4      TSCNT counter stop
   Uint16 SYNCI_EN:1;         // 5      Counter sync-in select
   Uint16 SYNCO_SEL:2;        // 7:6    Sync-out mode
   Uint16 SWSYNC:1;           // 8      SW forced counter sync
   Uint16 CAP_APWM:1;         // 9      CAP/APWM operating mode select
   Uint16 APWMPOL:1;          // 10     APWM output polarity select
   Uint16 rsvd1:5;            // 15:11
};

union ECCTL2_REG {
   Uint16              all;
   struct ECCTL2_BITS  bit;
};

//----------------------------------------------------
// ECAP interrupt enable register bit definitions */
struct ECEINT_BITS {          // bits   description
   Uint16 rsvd1:1;            // 0      reserved
   Uint16 CEVT1:1;            // 1      Capture Event 1 Interrupt Enable
   Uint16 CEVT2:1;            // 2      Capture Event 2 Interrupt Enable
   Uint16 CEVT3:1;            // 3      Capture Event 3 Interrupt Enable
   Uint16 CEVT4:1;            // 4      Capture Event 4 Interrupt Enable
   Uint16 CTROVF:1;           // 5      Counter Overflow Interrupt Enable
   Uint16 CTR_EQ_PRD:1;       // 6      Period Equal Interrupt Enable
   Uint16 CTR_EQ_CMP:1;       // 7      Compare Equal Interrupt Enable
   Uint16 rsvd2:8;            // 15:8   reserved
};

union ECEINT_REG {
   Uint16              all;
   struct ECEINT_BITS  bit;
};

//----------------------------------------------------
// ECAP interrupt flag register bit definitions */
struct ECFLG_BITS {           // bits   description
   Uint16 INT:1;              // 0      Global Flag
   Uint16 CEVT1:1;            // 1      Capture Event 1 Interrupt Flag
   Uint16 CEVT2:1;            // 2      Capture Event 2 Interrupt Flag
   Uint16 CEVT3:1;            // 3      Capture Event 3 Interrupt Flag
   Uint16 CEVT4:1;            // 4      Capture Event 4 Interrupt Flag
   Uint16 CTROVF:1;           // 5      Counter Overflow Interrupt Flag
   Uint16 CTR_EQ_PRD:1;       // 6      Period Equal Interrupt Flag
   Uint16 CTR_EQ_CMP:1;       // 7      Compare Equal Interrupt Flag
   Uint16 rsvd2:8;            // 15:8   reserved
};

union ECFLG_REG {
   Uint16              all;
   struct ECFLG_BITS   bit;
};

//----------------------------------------------------

struct ECAP_REGS {
   Uint32              TSCTR;    // Time stamp counter
   Uint32              CTRPHS;   // Counter phase
   Uint32              CAP1;     // Capture 1
   Uint32              CAP2;     // Capture 2
   Uint32              CAP3;     // Capture 3
   Uint32              CAP4;     // Capture 4
   Uint16              rsvd1[8]; // reserved
   union   ECCTL1_REG  ECCTL1;   // Capture Control Reg 1
   union   ECCTL2_REG  ECCTL2;   // Capture Control Reg 2
   union   ECEINT_REG  ECEINT;   // ECAP interrupt enable
   union   ECFLG_REG   ECFLG;    // ECAP interrupt flags
   union   ECFLG_REG   ECCLR;    // ECAP interrupt clear
   union   ECEINT_REG  ECFRC;    // ECAP interrupt force
   Uint16              rsvd2[6]; // reserved
};

//---------------------------------------------------------------------------
// GPI/O External References & Function Declarations:
//
extern volatile struct ECAP_REGS ECap1Regs;



//===========================================================================
// End of file.
//===========================================================================
//###########################################################################
//
// FILE:   DSP2803x_EPWM.h
//
// TITLE:  DSP2803x Enhanced PWM Module Register Bit Definitions.
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################




//----------------------------------------------------
// Time base control register bit definitions */
struct TBCTL_BITS {          // bits   description
   Uint16 CTRMODE:2;         // 1:0    Counter Mode
   Uint16 PHSEN:1;           // 2      Phase load enable
   Uint16 PRDLD:1;           // 3      Active period load
   Uint16 SYNCOSEL:2;        // 5:4    Sync output select
   Uint16 SWFSYNC:1;         // 6      Software force sync pulse
   Uint16 HSPCLKDIV:3;       // 9:7    High speed time pre-scale
   Uint16 CLKDIV:3;          // 12:10  Timebase clock pre-scale
   Uint16 PHSDIR:1;          // 13     Phase Direction
   Uint16 FREE_SOFT:2;       // 15:14  Emulation mode
};

union TBCTL_REG {
   Uint16              all;
   struct TBCTL_BITS   bit;
};

//----------------------------------------------------
// Time base status register bit definitions */
struct TBSTS_BITS {          // bits   description
   Uint16 CTRDIR:1;          // 0      Counter direction status
   Uint16 SYNCI:1;           // 1      External input sync status
   Uint16 CTRMAX:1;          // 2      Counter max latched status
   Uint16 rsvd1:13;          // 15:3   reserved
};

union TBSTS_REG {
   Uint16              all;
   struct TBSTS_BITS   bit;
};

//----------------------------------------------------
// Compare control register bit definitions */
struct CMPCTL_BITS {          // bits   description
   Uint16 LOADAMODE:2;        // 0:1    Active compare A
   Uint16 LOADBMODE:2;        // 3:2    Active compare B
   Uint16 SHDWAMODE:1;        // 4      Compare A block operating mode
   Uint16 rsvd1:1;            // 5      reserved
   Uint16 SHDWBMODE:1;        // 6      Compare B block operating mode
   Uint16 rsvd2:1;            // 7      reserved
   Uint16 SHDWAFULL:1;        // 8      Compare A Shadow registers full Status
   Uint16 SHDWBFULL:1;        // 9      Compare B Shadow registers full Status
   Uint16 rsvd3:6;            // 15:10  reserved
};


union CMPCTL_REG {
   Uint16                all;
   struct CMPCTL_BITS    bit;
};

//----------------------------------------------------
// Action qualifier register bit definitions */
struct AQCTL_BITS {           // bits   description
   Uint16 ZRO:2;              // 1:0    Action Counter = Zero
   Uint16 PRD:2;              // 3:2    Action Counter = Period
   Uint16 CAU:2;              // 5:4    Action Counter = Compare A up
   Uint16 CAD:2;              // 7:6    Action Counter = Compare A down
   Uint16 CBU:2;              // 9:8    Action Counter = Compare B up
   Uint16 CBD:2;              // 11:10  Action Counter = Compare B down
   Uint16 rsvd:4;             // 15:12  reserved
};

union AQCTL_REG {
   Uint16                all;
   struct AQCTL_BITS     bit;
};

//----------------------------------------------------
// Action qualifier SW force register bit definitions */
struct AQSFRC_BITS {           // bits   description
   Uint16 ACTSFA:2;            // 1:0    Action when One-time SW Force A invoked
   Uint16 OTSFA:1;             // 2      One-time SW Force A output
   Uint16 ACTSFB:2;            // 4:3    Action when One-time SW Force B invoked
   Uint16 OTSFB:1;             // 5      One-time SW Force A output
   Uint16 RLDCSF:2;            // 7:6    Reload from Shadow options
   Uint16 rsvd1:8;             // 15:8   reserved
};

union AQSFRC_REG {
   Uint16                 all;
   struct AQSFRC_BITS     bit;
};

//----------------------------------------------------
// Action qualifier continuous SW force register bit definitions */
struct AQCSFRC_BITS {          // bits   description
   Uint16 CSFA:2;              // 1:0    Continuous Software Force on output A
   Uint16 CSFB:2;              // 3:2    Continuous Software Force on output B
   Uint16 rsvd1:12;            // 15:4   reserved
};

union AQCSFRC_REG {
   Uint16                  all;
   struct AQCSFRC_BITS     bit;
};


//----------------------------------------------------
// Dead-band generator control register bit definitions
struct DBCTL_BITS {          // bits   description
   Uint16 OUT_MODE:2;      	 // 1:0    Dead Band Output Mode Control
   Uint16 POLSEL:2;          // 3:2    Polarity Select Control
   Uint16 IN_MODE:2;         // 5:4    Dead Band Input Select Mode Control
   Uint16 rsvd1:9;           // 14:4   reserved
   Uint16 HALFCYCLE:1;       // 15     Half Cycle Clocking Enable
};

union DBCTL_REG {
   Uint16                  all;
   struct DBCTL_BITS       bit;
};


//----------------------------------------------------
// Trip zone select register bit definitions
struct TZSEL_BITS {           // bits   description
   Uint16  CBC1:1;            // 0      TZ1 CBC select
   Uint16  CBC2:1;            // 1      TZ2 CBC select
   Uint16  CBC3:1;            // 2      TZ3 CBC select
   Uint16  CBC4:1;            // 3      TZ4 CBC select
   Uint16  CBC5:1;            // 4      TZ5 CBC select
   Uint16  CBC6:1;            // 5      TZ6 CBC select
   Uint16  DCAEVT2:1;         // 6      DCAEVT2
   Uint16  DCBEVT2:1;         // 7      DCBEVT2
   Uint16  OSHT1:1;           // 8      One-shot TZ1 select
   Uint16  OSHT2:1;           // 9      One-shot TZ2 select
   Uint16  OSHT3:1;           // 10     One-shot TZ3 select
   Uint16  OSHT4:1;           // 11     One-shot TZ4 select
   Uint16  OSHT5:1;           // 12     One-shot TZ5 select
   Uint16  OSHT6:1;           // 13     One-shot TZ6 select
   Uint16  DCAEVT1:1;         // 14     DCAEVT1
   Uint16  DCBEVT1:1;         // 15     DCBEVT1
};

union TZSEL_REG {
   Uint16                  all;
   struct TZSEL_BITS       bit;
};


//----------------------------------------------------
// Trip zone digital compare event select register
struct TZDCSEL_BITS {        // bits   description
   Uint16  DCAEVT1:3;        // 2:0    Digital Compare Output A Event 1
   Uint16  DCAEVT2:3;        // 5:3    Digital Compare Output A Event 2
   Uint16  DCBEVT1:3;        // 8:6    Digital Compare Output B Event 1
   Uint16  DCBEVT2:3;        // 11:9   Digital Compare Output B Event 2
   Uint16  rsvd1:4;          // 15:12  reserved
};

union TZDCSEL_REG {
   Uint16                  all;
   struct TZDCSEL_BITS     bit;
};

//----------------------------------------------------
// Trip zone control register bit definitions */
struct TZCTL_BITS {         // bits   description
   Uint16 TZA:2;            // 1:0    TZ1 to TZ6 Trip Action On EPWMxA
   Uint16 TZB:2;            // 3:2    TZ1 to TZ6 Trip Action On EPWMxB
   Uint16 DCAEVT1:2;        // 5:4    EPWMxA action on DCAEVT1
   Uint16 DCAEVT2:2;        // 7:6    EPWMxA action on DCAEVT2
   Uint16 DCBEVT1:2;        // 9:8    EPWMxB action on DCBEVT1
   Uint16 DCBEVT2:2;        // 11:10  EPWMxB action on DCBEVT2
   Uint16 rsvd:4;           // 15:12  reserved
};

union TZCTL_REG {
   Uint16                  all;
   struct TZCTL_BITS       bit;
};


//----------------------------------------------------
// Trip zone control register bit definitions */
struct TZEINT_BITS {         // bits   description
   Uint16  rsvd1:1;          // 0      reserved
   Uint16  CBC:1;            // 1      Trip Zones Cycle By Cycle Int Enable
   Uint16  OST:1;            // 2      Trip Zones One Shot Int Enable
   Uint16  DCAEVT1:1;        // 3      Force DCAEVT1 event
   Uint16  DCAEVT2:1;        // 4      Force DCAEVT2 event
   Uint16  DCBEVT1:1;        // 5      Force DCBEVT1 event
   Uint16  DCBEVT2:1;        // 6      Force DCBEVT2 event
   Uint16  rsvd2:9;          // 15:7   reserved
};


union TZEINT_REG {
   Uint16                  all;
   struct TZEINT_BITS      bit;
};


//----------------------------------------------------
// Trip zone flag register bit definitions */
struct TZFLG_BITS {         // bits   description
   Uint16  INT:1;           // 0      Global status
   Uint16  CBC:1;           // 1      Trip Zones Cycle By Cycle Int
   Uint16  OST:1;           // 2      Trip Zones One Shot Int
   Uint16  DCAEVT1:1;       // 3      Force DCAEVT1 event
   Uint16  DCAEVT2:1;       // 4      Force DCAEVT2 event
   Uint16  DCBEVT1:1;       // 5      Force DCBEVT1 event
   Uint16  DCBEVT2:1;       // 6      Force DCBEVT2 event
   Uint16  rsvd2:9;         // 15:7   reserved
};

union TZFLG_REG {
   Uint16                  all;
   struct TZFLG_BITS       bit;
};

//----------------------------------------------------
// Trip zone flag clear register bit definitions */
struct TZCLR_BITS {         // bits   description
   Uint16  INT:1;           // 0      Global status
   Uint16  CBC:1;           // 1      Trip Zones Cycle By Cycle Int
   Uint16  OST:1;           // 2      Trip Zones One Shot Int
   Uint16  DCAEVT1:1;       // 3      Force DCAEVT1 event
   Uint16  DCAEVT2:1;       // 4      Force DCAEVT2 event
   Uint16  DCBEVT1:1;       // 5      Force DCBEVT1 event
   Uint16  DCBEVT2:1;       // 6      Force DCBEVT2 event
   Uint16  rsvd2:9;         // 15:7   reserved
};

union TZCLR_REG {
   Uint16                  all;
   struct TZCLR_BITS       bit;
};

//----------------------------------------------------
// Trip zone flag force register bit definitions */
struct TZFRC_BITS {         // bits   description
   Uint16  rsvd1:1;         // 0      reserved
   Uint16  CBC:1;           // 1      Trip Zones Cycle By Cycle Int
   Uint16  OST:1;           // 2      Trip Zones One Shot Int
   Uint16  DCAEVT1:1;       // 3      Force DCAEVT1 event
   Uint16  DCAEVT2:1;       // 4      Force DCAEVT2 event
   Uint16  DCBEVT1:1;       // 5      Force DCBEVT1 event
   Uint16  DCBEVT2:1;       // 6      Force DCBEVT2 event
   Uint16  rsvd2:9;        // 15:7   reserved
};

union TZFRC_REG {
   Uint16                  all;
   struct TZFRC_BITS       bit;
};

//----------------------------------------------------
// Event trigger select register bit definitions */
struct ETSEL_BITS {         // bits   description
   Uint16  INTSEL:3;        // 2:0    EPWMxINTn Select
   Uint16  INTEN:1;         // 3      EPWMxINTn Enable
   Uint16  rsvd1:4;         // 7:4    reserved
   Uint16  SOCASEL:3;       // 10:8   Start of conversion A Select
   Uint16  SOCAEN:1;        // 11     Start of conversion A Enable
   Uint16  SOCBSEL:3;       // 14:12  Start of conversion B Select
   Uint16  SOCBEN:1;        // 15     Start of conversion B Enable
};

union ETSEL_REG {
   Uint16                  all;
   struct ETSEL_BITS       bit;
};


//----------------------------------------------------
// Event trigger pre-scale register bit definitions */
struct ETPS_BITS {         // bits   description
   Uint16  INTPRD:2;       // 1:0    EPWMxINTn Period Select
   Uint16  INTCNT:2;       // 3:2    EPWMxINTn Counter Register
   Uint16  rsvd1:4;        // 7:4    reserved
   Uint16  SOCAPRD:2;      // 9:8    EPWMxSOCA Period Select
   Uint16  SOCACNT:2;      // 11:10  EPWMxSOCA Counter Register
   Uint16  SOCBPRD:2;      // 13:12  EPWMxSOCB Period Select
   Uint16  SOCBCNT:2;      // 15:14  EPWMxSOCB Counter Register
};

union ETPS_REG {
   Uint16                  all;
   struct ETPS_BITS        bit;
};

//----------------------------------------------------
// Event trigger Flag register bit definitions */
struct ETFLG_BITS {         // bits   description
   Uint16  INT:1;           // 0	  EPWMxINTn Flag
   Uint16  rsvd1:1;         // 1	  reserved
   Uint16  SOCA:1;          // 2	  EPWMxSOCA Flag
   Uint16  SOCB:1;          // 3	  EPWMxSOCB Flag
   Uint16  rsvd2:12;        // 15:4	  reserved
};

union ETFLG_REG {
   Uint16                   all;
   struct ETFLG_BITS        bit;
};


//----------------------------------------------------
// Event trigger Clear register bit definitions */
struct ETCLR_BITS {         // bits   description
   Uint16  INT:1;           // 0	  EPWMxINTn Clear
   Uint16  rsvd1:1;         // 1	  reserved
   Uint16  SOCA:1;          // 2	  EPWMxSOCA Clear
   Uint16  SOCB:1;          // 3	  EPWMxSOCB Clear
   Uint16  rsvd2:12;        // 15:4	  reserved
};

union ETCLR_REG {
   Uint16                   all;
   struct ETCLR_BITS        bit;
};

//----------------------------------------------------
// Event trigger Force register bit definitions */
struct ETFRC_BITS {         // bits   description
   Uint16  INT:1;           // 0	  EPWMxINTn Force
   Uint16  rsvd1:1;         // 1	  reserved
   Uint16  SOCA:1;          // 2	  EPWMxSOCA Force
   Uint16  SOCB:1;          // 3	  EPWMxSOCB Force
   Uint16  rsvd2:12;        // 15:4	  reserved
};

union ETFRC_REG {
   Uint16                  all;
   struct ETFRC_BITS        bit;
};
//----------------------------------------------------
// PWM chopper control register bit definitions */
struct PCCTL_BITS {         // bits   description
   Uint16  CHPEN:1;         // 0      PWM chopping enable
   Uint16  OSHTWTH:4;       // 4:1    One-shot pulse width
   Uint16  CHPFREQ:3;       // 7:5    Chopping clock frequency
   Uint16  CHPDUTY:3;       // 10:8   Chopping clock Duty cycle
   Uint16  rsvd1:5;         // 15:11  reserved
};


union PCCTL_REG {
   Uint16                  all;
   struct PCCTL_BITS       bit;
};


//----------------------------------------------------
// Enhanced Trip register bit definitions */

struct DCTRIPSEL_BITS {      // bits   description
   Uint16 DCAHCOMPSEL:4;     // 3:0    Digital Compare A High, COMP Input Select
   Uint16 DCALCOMPSEL:4;     // 7:4    Digital Compare A Low, COMP Input Select
   Uint16 DCBHCOMPSEL:4;     // 11:8   Digital Compare B High, COMP Input Select
   Uint16 DCBLCOMPSEL:4;     // 15:12  Digital Compare B Low, COMP Input Select
};

union DCTRIPSEL_REG {
   Uint16                  all;
   struct DCTRIPSEL_BITS   bit;
};

struct DCCTL_BITS {          // bits   description
   Uint16 EVT1SRCSEL:1;      // 0      DCBEVT1 Source Signal Select
   Uint16 EVT1FRCSYNCSEL:1;  // 1      DCBEVT1 Force Cynchronization Signal Select
   Uint16 EVT1SOCE:1;        // 2      DCEVT1 SOC, Enable/Disable
   Uint16 EVT1SYNCE:1;       // 3      DCEVT1 Sync, Enable/Disable
   Uint16 rsvd1:4;           // 7:4    reserved
   Uint16 EVT2SRCSEL:1;      // 8      DCEVT2 Source Signal Select
   Uint16 EVT2FRCSYNCSEL:1;  // 9      DCEVT2 Force Synchronization Signal Select
   Uint16 rsvd2:6;           // 15:10  reserved
};

union DCCTL_REG {
   Uint16                  all;
   struct DCCTL_BITS       bit;
};

struct DCCAPCTL_BITS {       // bits   description
   Uint16 CAPE:1;            // 0      Counter Capture Enable/Disable
   Uint16 SHDWMODE:1;        // 1      Counter Capture Mode
   Uint16 rsvd:14;           // 15:2   reserved
};

union DCCAPCTL_REG {
   Uint16                  all;
   struct DCCAPCTL_BITS    bit;
};

struct DCFCTL_BITS {         // bits   description
   Uint16 SRCSEL:2;          // 1:0    Filter Block Signal Source Select
   Uint16 BLANKE:1;          // 2      Blanking Enable/Disable
   Uint16 BLANKINV:1;        // 3      Blanking Window Inversion
   Uint16 PULSESEL:2;        // 5:4    Pulse Select for Blanking & Capture Alignment
   Uint16 rsvd:10;           // 15:6   reserved
};

union DCFCTL_REG {
   Uint16                  all;
   struct DCFCTL_BITS      bit;
};


//----------------------------------------------------
// High resolution period control register bit definitions */

struct HRPCTL_BITS {        // bits   description
   Uint16  HRPE:1;          // 0      High resolution period enable
   Uint16  PWMSYNCSEL:1;    // 1      PWMSYNC Source Select Bit 
   Uint16  TBPHSHRLOADE:1;  // 2      TBPHSHR Load Enable Bit
   Uint16  rsvd1:13;        // 15:3   reserved
};

union HRPCTL_REG {
   Uint16                  	all;
   struct HRPCTL_BITS       bit;
};

//----------------------------------------------------
// High Resolution Register bit definitions */

struct HRCNFG_BITS {       	// bits   description
   Uint16  EDGMODE:2;     	// 1:0    Edge Mode select Bits
   Uint16  CTLMODE:1;     	// 2      Control mode Select Bit
   Uint16  HRLOAD:2;      	// 4:3    Shadow mode Select Bit
   Uint16  SELOUTB:1;       // 5      EPWMB Output Select Bit
   Uint16  AUTOCONV:1;      // 6      Autoconversion Bit
   Uint16  SWAPAB:1;        // 7	  Swap EPWMA & EPWMB Outputs Bit
   Uint16  rsvd1:8;      	// 15:8   reserved
};

union HRCNFG_REG {
   Uint16                  	all;
   struct HRCNFG_BITS       bit;
};


struct HRPWR_BITS {       	// bits   description
   Uint16  rsvd1:6;     	// 5:0    reserved
   Uint16  MEPOFF:4;     	// 9:6    MEP Calibration Off Bits
   Uint16  rsvd2:6;      	// 15:10  reserved
};

union HRPWR_REG {
   Uint16                  	all;
   struct HRPWR_BITS        bit;
};

struct TBPHS_HRPWM_REG {   	// bits   description
   Uint16  TBPHSHR;     	// 15:0   Extension register for HRPWM Phase (8 bits)
   Uint16  TBPHS;           // 31:16  Phase offset register
};

union TBPHS_HRPWM_GROUP {
   Uint32                  all;
   struct TBPHS_HRPWM_REG  half;
};

struct CMPA_HRPWM_REG {   	// bits   description
   Uint16  CMPAHR;     	    // 15:0   Extension register for HRPWM compare (8 bits)
   Uint16  CMPA;            // 31:16  Compare A reg
};

union CMPA_HRPWM_GROUP {
   Uint32                 all;
   struct CMPA_HRPWM_REG  half;
};

struct TBPRD_HRPWM_REG {   	// bits   description
   Uint16  TBPRDHR;     	// 15:0   Extension register for HRPWM Period (8 bits)
   Uint16  TBPRD;           // 31:16  Timebase Period Register
};

union TBPRD_HRPWM_GROUP {
   Uint32                  all;
   struct TBPRD_HRPWM_REG  half;
};


struct EPWM_REGS {
   union  TBCTL_REG           TBCTL;       // Time Base Control Register
   union  TBSTS_REG           TBSTS;       // Time Base Status Register
   union  TBPHS_HRPWM_GROUP   TBPHS;       // Union of TBPHS:TBPHSHR
   Uint16                     TBCTR;       // Time Base Counter
   Uint16                     TBPRD;       // Time Base Period register set
   Uint16                     TBPRDHR;     // Time Base Period High Res Register
   union  CMPCTL_REG          CMPCTL;      // Compare control
   union  CMPA_HRPWM_GROUP    CMPA;        // Union of CMPA:CMPAHR
   Uint16                     CMPB;        // Compare B reg
   union  AQCTL_REG           AQCTLA;      // Action qual output A
   union  AQCTL_REG           AQCTLB;      // Action qual output B
   union  AQSFRC_REG          AQSFRC;      // Action qual SW force
   union  AQCSFRC_REG         AQCSFRC;     // Action qualifier continuous SW force
   union  DBCTL_REG           DBCTL;       // Dead-band control
   Uint16                     DBRED;       // Dead-band rising edge delay
   Uint16                     DBFED;       // Dead-band falling edge delay
   union  TZSEL_REG           TZSEL;       // Trip zone select
   union  TZDCSEL_REG         TZDCSEL;     // Trip zone digital comparator select
   union  TZCTL_REG           TZCTL;       // Trip zone control
   union  TZEINT_REG          TZEINT;      // Trip zone interrupt enable
   union  TZFLG_REG           TZFLG;       // Trip zone interrupt flags
   union  TZCLR_REG           TZCLR;       // Trip zone clear
   union  TZFRC_REG    	      TZFRC;       // Trip zone force interrupt
   union  ETSEL_REG           ETSEL;       // Event trigger selection
   union  ETPS_REG            ETPS;        // Event trigger pre-scaler
   union  ETFLG_REG           ETFLG;       // Event trigger flags
   union  ETCLR_REG           ETCLR;       // Event trigger clear
   union  ETFRC_REG           ETFRC;       // Event trigger force
   union  PCCTL_REG           PCCTL;       // PWM chopper control
   Uint16                     rsvd3;
   union  HRCNFG_REG          HRCNFG;      // HRPWM Config Reg
   union  HRPWR_REG			  HRPWR;       // HRPWM Power Register
   Uint16                     rsvd4[4];
   Uint16                     HRMSTEP;     // HRPWM MEP Step Register
   Uint16                     rsvd5;
   union  HRPCTL_REG          HRPCTL;      // High Resolution Period Control
   Uint16                     rsvd6;
   union  TBPRD_HRPWM_GROUP   TBPRDM;      // Union of TBPRD:TBPRDHR mirror registers
   union  CMPA_HRPWM_GROUP    CMPAM;       // Union of CMPA:CMPAHR mirror registers
   Uint16                     rsvd7[2];
   union  DCTRIPSEL_REG       DCTRIPSEL;   // Digital Compare Trip Select
   union  DCCTL_REG           DCACTL;      // Digital Compare A Control
   union  DCCTL_REG           DCBCTL;      // Digital Compare B Control
   union  DCFCTL_REG          DCFCTL;      // Digital Compare Filter Control
   union  DCCAPCTL_REG        DCCAPCTL;    // Digital Compare Capture Control
   Uint16                     DCFOFFSET;   // Digital Compare Filter Offset
   Uint16                     DCFOFFSETCNT;// Digital Compare Filter Offset Counter
   Uint16                     DCFWINDOW;   // Digital Compare Filter Window
   Uint16                     DCFWINDOWCNT;// Digital Compare Filter Window Counter
   Uint16                     DCCAP;       // Digital Compare Filter Counter Capture
   Uint16                     rsvd8[6]; 
};



//---------------------------------------------------------------------------
// External References & Function Declarations:
//
extern volatile struct EPWM_REGS EPwm1Regs;
extern volatile struct EPWM_REGS EPwm2Regs;
extern volatile struct EPWM_REGS EPwm3Regs;
extern volatile struct EPWM_REGS EPwm4Regs;
extern volatile struct EPWM_REGS EPwm5Regs;
extern volatile struct EPWM_REGS EPwm6Regs;
extern volatile struct EPWM_REGS EPwm7Regs;



//===========================================================================
// End of file.
//===========================================================================
//###########################################################################
//
// FILE:   DSP2803x_EQep.h
//
// TITLE:  DSP2803x Enhanced Quadrature Encoder Pulse Module
//         Register Bit Definitions.
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



//----------------------------------------------------
// Capture decoder control register bit definitions */
struct QDECCTL_BITS {         // bits   description
   Uint16 rsvd1:5;            // 4:0    reserved
   Uint16 QSP:1;              // 5      QEPS input polarity
   Uint16 QIP:1;              // 6      QEPI input polarity
   Uint16 QBP:1;              // 7      QEPB input polarity
   Uint16 QAP:1;              // 8      QEPA input polarity
   Uint16 IGATE:1;            // 9      Index pulse gating option
   Uint16 SWAP:1;             // 10     CLK/DIR signal source for Position Counter
   Uint16 XCR:1;              // 11     External clock rate
   Uint16 SPSEL:1;            // 12     Sync output pin select
   Uint16 SOEN:1;             // 13     Enable position compare sync
   Uint16 QSRC:2;             // 15:14  Position counter source
};

union QDECCTL_REG {
   Uint16              all;
   struct QDECCTL_BITS   bit;
};

//----------------------------------------------------
// QEP control register bit definitions */
struct QEPCTL_BITS {           // bits   description
   Uint16 WDE:1;               // 0      QEP watchdog enable
   Uint16 UTE:1;               // 1      QEP unit timer enable
   Uint16 QCLM:1;              // 2      QEP capture latch mode
   Uint16 QPEN:1;              // 3      Quadrature position counter enable
   Uint16 IEL:2;               // 5:4    Index event latch
   Uint16 SEL:1;               // 6      Strobe event latch
   Uint16 SWI:1;               // 7      Software init position counter
   Uint16 IEI:2;               // 9:8    Index event init of position count
   Uint16 SEI:2;               // 11:10  Strobe event init
   Uint16 PCRM:2;              // 13:12  Position counter reset
   Uint16 FREE_SOFT:2;         // 15:14  Emulation mode
};

union QEPCTL_REG {
   Uint16               all;
   struct QEPCTL_BITS   bit;
};

//----------------------------------------------------
// Quadrature capture control register bit definitions */
struct QCAPCTL_BITS {          // bits   description
   Uint16 UPPS:4;              // 3:0    Unit position pre-scale
   Uint16 CCPS:3;              // 6:4    QEP capture timer pre-scale
   Uint16 rsvd1:8;             // 14:7   reserved
   Uint16 CEN:1;               // 15     Enable QEP capture
};

union QCAPCTL_REG {
   Uint16               all;
   struct QCAPCTL_BITS  bit;
};

//----------------------------------------------------
// Position compare control register bit definitions */
struct QPOSCTL_BITS {          // bits   description
   Uint16 PCSPW:12;            // 11:0   Position compare sync pulse width
   Uint16 PCE:1;               // 12     Position compare enable/disable
   Uint16 PCPOL:1;             // 13     Polarity of sync output
   Uint16 PCLOAD:1;            // 14     Position compare of shadow load
   Uint16 PCSHDW:1;            // 15     Position compare shadow enable
};

union QPOSCTL_REG {
   Uint16               all;
   struct QPOSCTL_BITS  bit;
};

//----------------------------------------------------
// QEP interrupt control register bit definitions */
struct QEINT_BITS {          // bits   description
   Uint16 rsvd1:1;           // 0      reserved
   Uint16 PCE:1;             // 1      Position counter error
   Uint16 QPE:1;             // 2      Quadrature phase error
   Uint16 QDC:1;             // 3      Quadrature dir change
   Uint16 WTO:1;             // 4      Watchdog timeout
   Uint16 PCU:1;             // 5      Position counter underflow
   Uint16 PCO:1;             // 6      Position counter overflow
   Uint16 PCR:1;             // 7      Position compare ready
   Uint16 PCM:1;             // 8      Position compare match
   Uint16 SEL:1;             // 9      Strobe event latch
   Uint16 IEL:1;             // 10     Event latch
   Uint16 UTO:1;             // 11     Unit timeout
   Uint16 rsvd2:4;           // 15:12  reserved
};

union QEINT_REG {
   Uint16               all;
   struct QEINT_BITS    bit;
};

//----------------------------------------------------
// QEP interrupt status register bit definitions */
struct QFLG_BITS {          // bits   description
   Uint16 INT:1;            // 0      Global interrupt
   Uint16 PCE:1;            // 1      Position counter error
   Uint16 PHE:1;            // 2      Quadrature phase error
   Uint16 QDC:1;            // 3      Quadrature dir change
   Uint16 WTO:1;            // 4      Watchdog timeout
   Uint16 PCU:1;            // 5      Position counter underflow
   Uint16 PCO:1;            // 6      Position counter overflow
   Uint16 PCR:1;            // 7      Position compare ready
   Uint16 PCM:1;            // 8      Position compare match
   Uint16 SEL:1;            // 9      Strobe event latch
   Uint16 IEL:1;            // 10     Event latch
   Uint16 UTO:1;            // 11     Unit timeout
   Uint16 rsvd2:4;          // 15:12  reserved
};

union QFLG_REG {
   Uint16               all;
   struct QFLG_BITS     bit;
};

//----------------------------------------------------
// QEP interrupt force register bit definitions */
struct QFRC_BITS {          // bits   description
   Uint16 reserved:1;       // 0      Reserved
   Uint16 PCE:1;            // 1      Position counter error
   Uint16 PHE:1;            // 2      Quadrature phase error
   Uint16 QDC:1;            // 3      Quadrature dir change
   Uint16 WTO:1;            // 4      Watchdog timeout
   Uint16 PCU:1;            // 5      Position counter underflow
   Uint16 PCO:1;            // 6      Position counter overflow
   Uint16 PCR:1;            // 7      Position compare ready
   Uint16 PCM:1;            // 8      Position compare match
   Uint16 SEL:1;            // 9      Strobe event latch
   Uint16 IEL:1;            // 10     Event latch
   Uint16 UTO:1;            // 11     Unit timeout
   Uint16 rsvd2:4;          // 15:12  reserved
};

union QFRC_REG {
   Uint16               all;
   struct QFRC_BITS     bit;
};

// V1.1 Added UPEVNT (bit 7) This reflects changes
// made as of F2803x Rev A devices
//----------------------------------------------------
// QEP status register bit definitions */
struct QEPSTS_BITS {          // bits   description
   Uint16 PCEF:1;             // 0      Position counter error
   Uint16 FIMF:1;             // 1      First index marker
   Uint16 CDEF:1;             // 2      Capture direction error
   Uint16 COEF:1;             // 3      Capture overflow error
   Uint16 QDLF:1;             // 4      QEP direction latch
   Uint16 QDF:1;              // 5      Quadrature direction
   Uint16 FIDF:1;             // 6      Direction on first index marker
   Uint16 UPEVNT:1;           // 7      Unit position event flag
   Uint16 rsvd1:8;            // 15:8   reserved
};

union QEPSTS_REG {
   Uint16               all;
   struct QEPSTS_BITS   bit;
};

//----------------------------------------------------

struct EQEP_REGS {
   Uint32              QPOSCNT;   // Position counter
   Uint32              QPOSINIT;  // Position counter init
   Uint32              QPOSMAX;   // Maximum position count
   Uint32              QPOSCMP;   // Position compare
   Uint32              QPOSILAT;  // Index position latch
   Uint32              QPOSSLAT;  // Strobe position latch
   Uint32              QPOSLAT;   // Position latch
   Uint32              QUTMR;     // Unit timer
   Uint32              QUPRD;     // Unit period
   Uint16              QWDTMR;    // QEP watchdog timer
   Uint16              QWDPRD;    // QEP watchdog period
   union  QDECCTL_REG  QDECCTL;   // Quadrature decoder control
   union  QEPCTL_REG   QEPCTL;    // QEP control
   union  QCAPCTL_REG  QCAPCTL;   // Quadrature capture control
   union  QPOSCTL_REG  QPOSCTL;   // Position compare control
   union  QEINT_REG    QEINT;     // QEP interrupt control
   union  QFLG_REG     QFLG;      // QEP interrupt flag
   union  QFLG_REG     QCLR;      // QEP interrupt clear
   union  QFRC_REG     QFRC;      // QEP interrupt force
   union  QEPSTS_REG   QEPSTS;    // QEP status
   Uint16              QCTMR;     // QEP capture timer
   Uint16              QCPRD;     // QEP capture period
   Uint16              QCTMRLAT;  // QEP capture latch
   Uint16              QCPRDLAT;  // QEP capture period latch
   Uint16              rsvd1[30]; // reserved
};

//---------------------------------------------------------------------------
// GPI/O External References & Function Declarations:
//
extern volatile struct EQEP_REGS EQep1Regs;



//===========================================================================
// End of file.
//===========================================================================
//###########################################################################
//
// FILE:   DSP2803x_Gpio.h
//
// TITLE:  DSP2803x General Purpose I/O Definitions.
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



//----------------------------------------------------
// GPIO A control register bit definitions */
struct GPACTRL_BITS {        // bits   description
   Uint16 QUALPRD0:8;        // 7:0    Qual period
   Uint16 QUALPRD1:8;        // 15:8   Qual period
   Uint16 QUALPRD2:8;        // 23:16  Qual period
   Uint16 QUALPRD3:8;        // 31:24  Qual period
};

union GPACTRL_REG {
   Uint32              all;
   struct GPACTRL_BITS bit;
};

//----------------------------------------------------
// GPIO B control register bit definitions */
struct GPBCTRL_BITS {        // bits   description
   Uint16 QUALPRD0:8;        // 7:0    Qual period
   Uint16 QUALPRD1:8;        // 15:8   Qual period   
   Uint16 rsvd2:16;          // 31:16  reserved
};

union GPBCTRL_REG {
   Uint32              all;
   struct GPBCTRL_BITS bit;
};

//----------------------------------------------------
// GPIO Qual/MUX select register bit definitions */
struct GPA1_BITS {            // bits   description
   Uint16 GPIO0:2;            // 1:0    GPIO0
   Uint16 GPIO1:2;            // 3:2    GPIO1
   Uint16 GPIO2:2;            // 5:4    GPIO2
   Uint16 GPIO3:2;            // 7:6    GPIO3
   Uint16 GPIO4:2;            // 9:8    GPIO4
   Uint16 GPIO5:2;            // 11:10  GPIO5
   Uint16 GPIO6:2;            // 13:12  GPIO6
   Uint16 GPIO7:2;            // 15:14  GPIO7
   Uint16 GPIO8:2;            // 17:16  GPIO8
   Uint16 GPIO9:2;            // 19:18  GPIO9
   Uint16 GPIO10:2;           // 21:20  GPIO10
   Uint16 GPIO11:2;           // 23:22  GPIO11
   Uint16 GPIO12:2;           // 25:24  GPIO12
   Uint16 GPIO13:2;           // 27:26  GPIO13
   Uint16 GPIO14:2;           // 29:28  GPIO14
   Uint16 GPIO15:2;           // 31:30  GPIO15
};

struct GPA2_BITS {            // bits   description
   Uint16 GPIO16:2;           // 1:0    GPIO16
   Uint16 GPIO17:2;           // 3:2    GPIO17
   Uint16 GPIO18:2;           // 5:4    GPIO18
   Uint16 GPIO19:2;           // 7:6    GPIO19
   Uint16 GPIO20:2;           // 9:8    GPIO20
   Uint16 GPIO21:2;           // 11:10  GPIO21
   Uint16 GPIO22:2;           // 13:12  GPIO22
   Uint16 GPIO23:2;           // 15:14  GPIO23
   Uint16 GPIO24:2;           // 17:16  GPIO24
   Uint16 GPIO25:2;           // 19:18  GPIO25
   Uint16 GPIO26:2;           // 21:20  GPIO26
   Uint16 GPIO27:2;           // 23:22  GPIO27
   Uint16 GPIO28:2;           // 25:24  GPIO28
   Uint16 GPIO29:2;           // 27:26  GPIO29
   Uint16 GPIO30:2;           // 29:28  GPIO30
   Uint16 GPIO31:2;           // 31:30  GPIO31
};

struct GPB1_BITS {            // bits   description
   Uint16 GPIO32:2;           // 1:0    GPIO32
   Uint16 GPIO33:2;           // 3:2    GPIO33
   Uint16 GPIO34:2;           // 5:4    GPIO34
   Uint16 GPIO35:2;           // 7:6    GPIO35
   Uint16 GPIO36:2;           // 9:8    GPIO36
   Uint16 GPIO37:2;           // 11:10  GPIO37
   Uint16 GPIO38:2;           // 13:12  GPIO38
   Uint16 GPIO39:2;           // 15:14  GPIO39
   Uint16 GPIO40:2;           // 17:16  GPIO40
   Uint16 GPIO41:2;           // 19:18  GPIO41
   Uint16 GPIO42:2;           // 21:20  GPIO42
   Uint16 GPIO43:2;           // 23:22  GPIO43
   Uint16 GPIO44:2;           // 25:24  GPIO44
   Uint16 rsvd1:6;            // 31:26  reserved
};


struct AIO_BITS {            // bits   description
   Uint16 rsvd1:2;            // 1:0    AIO0
   Uint16 rsvd2:2;            // 3:2    AIO1
   Uint16 AIO2:2;             // 5:4    AIO2
   Uint16 rsvd3:2;            // 7:6    AIO3
   Uint16 AIO4:2;             // 9:8    AIO4
   Uint16 rsvd4:2;            // 11:10  AIO5
   Uint16 AIO6:2;             // 13:12  AIO6
   Uint16 rsvd5:2;            // 15:14  AIO7
   Uint16 rsvd6:2;            // 17:16  AIO8
   Uint16 rsvd7:2;            // 19:18  AIO9
   Uint16 AIO10:2;            // 21:20  AIO10
   Uint16 rsvd8:2;            // 23:22  AIO11
   Uint16 AIO12:2;            // 25:24  AIO12
   Uint16 rsvd9:2;            // 27:26  AIO13
   Uint16 AIO14:2;            // 29:28  AIO14
   Uint16 rsvd10:2;           // 31:30  AIO15
};

union GPA1_REG {
   Uint32              all;
   struct GPA1_BITS    bit;
};

union GPA2_REG {
   Uint32              all;
   struct GPA2_BITS    bit;
};

union GPB1_REG {
   Uint32              all;
   struct GPB1_BITS    bit;
};

union AIO_REG {
   Uint32              all;
   struct AIO_BITS     bit;
};

//----------------------------------------------------
// GPIO DIR/TOGGLE/SET/CLEAR register bit definitions */
struct GPADAT_BITS {          // bits   description
   Uint16 GPIO0:1;            // 0      GPIO0
   Uint16 GPIO1:1;            // 1      GPIO1
   Uint16 GPIO2:1;            // 2      GPIO2
   Uint16 GPIO3:1;            // 3      GPIO3
   Uint16 GPIO4:1;            // 4      GPIO4
   Uint16 GPIO5:1;            // 5      GPIO5
   Uint16 GPIO6:1;            // 6      GPIO6
   Uint16 GPIO7:1;            // 7      GPIO7
   Uint16 GPIO8:1;            // 8      GPIO8
   Uint16 GPIO9:1;            // 9      GPIO9
   Uint16 GPIO10:1;           // 10     GPIO10
   Uint16 GPIO11:1;           // 11     GPIO11
   Uint16 GPIO12:1;           // 12     GPIO12
   Uint16 GPIO13:1;           // 13     GPIO13
   Uint16 GPIO14:1;           // 14     GPIO14
   Uint16 GPIO15:1;           // 15     GPIO15
   Uint16 GPIO16:1;           // 16     GPIO16
   Uint16 GPIO17:1;           // 17     GPIO17
   Uint16 GPIO18:1;           // 18     GPIO18
   Uint16 GPIO19:1;           // 19     GPIO19
   Uint16 GPIO20:1;           // 20     GPIO20
   Uint16 GPIO21:1;           // 21     GPIO21
   Uint16 GPIO22:1;           // 22     GPIO22
   Uint16 GPIO23:1;           // 23     GPIO23
   Uint16 GPIO24:1;           // 24     GPIO24
   Uint16 GPIO25:1;           // 25     GPIO25
   Uint16 GPIO26:1;           // 26     GPIO26
   Uint16 GPIO27:1;           // 27     GPIO27
   Uint16 GPIO28:1;           // 28     GPIO28
   Uint16 GPIO29:1;           // 29     GPIO29
   Uint16 GPIO30:1;           // 30     GPIO30
   Uint16 GPIO31:1;           // 31     GPIO31
};

struct GPBDAT_BITS {          // bits   description
   Uint16 GPIO32:1;           // 0      GPIO32
   Uint16 GPIO33:1;           // 1      GPIO33
   Uint16 GPIO34:1;           // 2      GPIO34
   Uint16 GPIO35:1;           // 3      GPIO35
   Uint16 GPIO36:1;           // 4      GPIO36
   Uint16 GPIO37:1;           // 5      GPIO37
   Uint16 GPIO38:1;           // 6      GPIO38
   Uint16 GPIO39:1;           // 7      GPIO39
   Uint16 GPIO40:1;           // 8      GPIO40
   Uint16 GPIO41:1;           // 9      GPIO41
   Uint16 GPIO42:1;           // 10     GPIO42
   Uint16 GPIO43:1;           // 11     GPIO43
   Uint16 GPIO44:1;           // 12     GPIO44
   Uint16 rsvd1:3;            // 15:13  reserved
   Uint16 rsvd2:16;           // 31:16  reserved
};

struct AIODAT_BITS {         // bits   description
   Uint16 rsvd1:1;           // 0      reserved
   Uint16 rsvd2:1;           // 1      reserved
   Uint16 AIO2:1;            // 2      AIO2
   Uint16 rsvd3:1;           // 3      reserved
   Uint16 AIO4:1;            // 4      AIO4
   Uint16 rsvd4:1;           // 5      reserved
   Uint16 AIO6:1;            // 6      AIO6
   Uint16 rsvd5:1;           // 7      reserved
   Uint16 rsvd6:1;           // 8      reserved
   Uint16 rsvd7:1;           // 9      reserved
   Uint16 AIO10:1;           // 10     AIO10
   Uint16 rsvd8:1;           // 11     reserved
   Uint16 AIO12:1;           // 12     AIO12
   Uint16 rsvd9:1;           // 13     reserved
   Uint16 AIO14:1;           // 14     AIO14
   Uint16 rsvd10:1;          // 15     reserved
};

union GPADAT_REG {
   Uint32              all;
   struct GPADAT_BITS  bit;
};

union GPBDAT_REG {
   Uint32              all;
   struct GPBDAT_BITS  bit;
};

union AIODAT_REG {
   Uint16			   all;
   struct AIODAT_BITS  bit;
};

//----------------------------------------------------------------
// GPIO XINT1/XINT2/XNMIregister bit definitions */
struct GPIOXINT_BITS {        // bits   description
    Uint16 GPIOSEL:5;         // 4:0    Select GPIO interrupt input source
    Uint16 rsvd1:11;          // 15:5   reserved
};

union GPIOXINT_REG {
   Uint16                all;
   struct GPIOXINT_BITS  bit;
};

struct GPIO_CTRL_REGS {
   union  GPACTRL_REG  GPACTRL;   // GPIO A Control Register (GPIO0 to 31)
   union  GPA1_REG     GPAQSEL1;  // GPIO A Qualifier Select 1 Register (GPIO0 to 15)
   union  GPA2_REG     GPAQSEL2;  // GPIO A Qualifier Select 2 Register (GPIO16 to 31)
   union  GPA1_REG     GPAMUX1;   // GPIO A Mux 1 Register (GPIO0 to 15)
   union  GPA2_REG     GPAMUX2;   // GPIO A Mux 2 Register (GPIO16 to 31)
   union  GPADAT_REG   GPADIR;    // GPIO A Direction Register (GPIO0 to 31)
   union  GPADAT_REG   GPAPUD;    // GPIO A Pull Up Disable Register (GPIO0 to 31)
   Uint32              rsvd1;     // reserved
   union  GPBCTRL_REG  GPBCTRL;   // GPIO B Control Register (GPIO32 to 44)
   union  GPB1_REG     GPBQSEL1;  // GPIO B Qualifier Select 1 Register (GPIO32 to 44)
   Uint32              rsvd2;     // reserved
   union  GPB1_REG     GPBMUX1;   // GPIO B Mux 1 Register (GPIO32 to 44)
   Uint32              rsvd3;     // reserved
   union  GPBDAT_REG   GPBDIR;    // GPIO B Direction Register (GPIO32 to 44)
   union  GPBDAT_REG   GPBPUD;    // GPIO B Pull Up Disable Register (GPIO32 to 44)
   Uint16              rsvd4[24]; // reserved
   union  AIO_REG      AIOMUX1;   // Analog IO Mux 1 Register (AIO0 to 15)
   Uint32              rsvd5;     // reserved
   union  AIODAT_REG   AIODIR;    // Analog IO Direction Register (AIO0 to 15)
   Uint16              rsvd6[5];  // reserved
};

struct GPIO_DATA_REGS {
   union  GPADAT_REG       GPADAT;       // GPIO Data Register (GPIO0 to 31)
   union  GPADAT_REG       GPASET;       // GPIO Data Set Register (GPIO0 to 31)
   union  GPADAT_REG       GPACLEAR;     // GPIO Data Clear Register (GPIO0 to 31)
   union  GPADAT_REG       GPATOGGLE;    // GPIO Data Toggle Register (GPIO0 to 31)
   union  GPBDAT_REG       GPBDAT;       // GPIO Data Register (GPIO32 to 44)
   union  GPBDAT_REG       GPBSET;       // GPIO Data Set Register (GPIO32 to 44)
   union  GPBDAT_REG       GPBCLEAR;     // GPIO Data Clear Register (GPIO32 to 44)
   union  GPBDAT_REG       GPBTOGGLE;    // GPIO Data Toggle Register (GPIO32 to 44)
   Uint16                  rsvd1[8];     // reserved
   union  AIODAT_REG       AIODAT;       // Analog IO Data Register (AIO0-15)
   Uint16				   rsvd2;
   union  AIODAT_REG       AIOSET;       // Analog IO Data Set Register (AIO0-15)
   Uint16				   rsvd3;
   union  AIODAT_REG       AIOCLEAR;     // Analog IO Data Clear Register (AIO0-15)
   Uint16				   rsvd4;
   union  AIODAT_REG       AIOTOGGLE;    // Analog IO Data Toggle Register (AIO0-15)
   Uint16				   rsvd5;
};

struct GPIO_INT_REGS {
   union  GPIOXINT_REG     GPIOXINT1SEL; // XINT1 GPIO Input Selection
   union  GPIOXINT_REG     GPIOXINT2SEL; // XINT2 GPIO Input Selection
   union  GPIOXINT_REG     GPIOXINT3SEL; // XINT3 GPIO Input Selection
   Uint16                  rsvd1[5];
   union  GPADAT_REG       GPIOLPMSEL;   // Low power modes GPIO input select
   Uint16                  rsvd2;
};

//---------------------------------------------------------------------------
// GPI/O External References & Function Declarations:
//
extern volatile struct GPIO_CTRL_REGS GpioCtrlRegs;
extern volatile struct GPIO_DATA_REGS GpioDataRegs;
extern volatile struct GPIO_INT_REGS GpioIntRegs;



//===========================================================================
// End of file.
//===========================================================================
//###########################################################################
//
// FILE:   DSP2803x_HRCap.h
//
// TITLE:  DSP2803x High Resolution Capture Register Definitions
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



//===========================================================================
//  High-Resolution Capture Register Bit Definitions
//

struct HCCTL_BITS {            // bit       description
    Uint16   SOFTRESET:1;      // 0         Soft Reset
    Uint16   RISEINTE:1;       // 1         RISE Capture Interrupt Enable Bit
    Uint16   FALLINTE:1;       // 2         FALL Capture Interrupt Enable Bit
    Uint16   OVFINTE:1;        // 3         Counter Overflow Interrupt Enable Bit
    Uint16   rsvd1:4;          // 7:4       reserved
    Uint16   HCCAPCLKSEL:1;    // 8         Capture Clock Select Bit
	Uint16   rsvd2:7; 		   // 15:9	    reserved
};

union HCCTL_REG  {
    Uint16                       all;
    struct HCCTL_BITS            bit;
};

struct HCIFR_BITS {            // bit       description
    Uint16   INT:1;            // 0         Global Interrupt Flag
    Uint16   RISE:1;           // 1         RISE Capture Interrupt Flag
    Uint16   FALL:1;           // 2         FALL Capture Interrupt Flag
    Uint16   COUNTEROVF:1;     // 3         Counter Overflow Interrupt Flag
	Uint16   RISEOVF:1;  	   // 4         RISE Interrupt Overflow Event Flag
    Uint16   rsvd1:11;         // 15:5      reserved
};

union HCIFR_REG  {
    Uint16                       all;
    struct HCIFR_BITS            bit;
};

struct HCICLR_BITS {           // bit       description
    Uint16   INT:1;            // 0         Global Interrupt Flag Clear Bit
    Uint16   RISE:1;           // 1         RISE Capture Interrupt Flag Clear Bit
    Uint16   FALL:1;           // 2         FALL Capture Interrupt Flag Clear Bit
    Uint16   COUNTEROVF:1;     // 3         Counter Overflow Interrupt Flag Clear Bit
	Uint16   RISEOVF:1;  	   // 4         RISE Interrupt Overflow Event Flag Clear Bit
    Uint16   rsvd1:11;         // 15:5      reserved
};

union HCICLR_REG  {
    Uint16                       all;
    struct HCICLR_BITS           bit;
};

struct HCIFRC_BITS {           // bit       description
    Uint16   rsvd1:1;          // 0         reserved
    Uint16   RISE:1;           // 1         RISE Capture Interrupt Flag Force Bit
    Uint16   FALL:1;           // 2         FALL Capture Interrupt Flag Force Bit
    Uint16   COUNTEROVF:1;     // 3         Counter Overflow Interrupt Flag Force Bit
	Uint16   RISEOVF:1;  	   // 4         RISE Interrupt Overflow Event Flag Force Bit
    Uint16   rsvd2:11;         // 15:5      reserved
};

union HCIFRC_REG  {
    Uint16                       all;
    struct HCIFRC_BITS           bit;
};
/*
struct HCCAPDLYRISE0_BITS {   // bit        description
    Uint16  CAPDLYRISE:7;     // 6:0        Capture Delay on Rising Edge 0
	Uint16  rsvd1:9;          // 15:7		reserved
};

union HCCAPDLYRISE0_REG  {
	Uint16                       all;
	struct HCCAPDLYRISE0_BITS    bit;
};

struct HCCAPDLYRISE1_BITS {   // bit        description
    Uint16  CAPDLYRISE:7;     // 6:0        Capture Delay on Rising Edge 1
	Uint16  rsvd1:9;          // 15:7		reserved
};

union HCCAPDLYRISE1_REG  {
	Uint16                       all;
	struct HCCAPDLYRISE1_BITS    bit;
};

struct HCCAPDLYFALL0_BITS {   // bit        description
    Uint16  CAPDLYFALL:7;     // 6:0        Capture Delay on Falling Edge 0
	Uint16  rsvd1:9;          // 15:7		reserved
};

union HCCAPDLYFALL0_REG  {
	Uint16                       all;
	struct HCCAPDLYFALL0_BITS    bit;
};

struct HCCAPDLYFALL1_BITS {   // bit        description
    Uint16  CAPDLYFALL:7;     // 6:0        Capture Delay on Falling Edge 1
	Uint16  rsvd1:9;          // 15:7		reserved
};

union HCCAPDLYFALL1_REG  {
	Uint16                       all;
	struct HCCAPDLYFALL1_BITS    bit;
};

struct HCCALCTL_BITS {       // bit        description
    Uint16  HRPWMSEL:1;      // 0          Calibration Input Select bit
	Uint16  rsvd1:15;        // 15:1	   reserved
};

union HCCALCTL_REG  {
	Uint16                  all;
	struct HCCALCTL_BITS    bit;
};
*/


//===========================================================================
//  High Resolution Capture Register Definitions
//
/*
struct HRCAP_REGS {
    union  HCCTL_REG           HCCTL;
	union  HCIFR_REG           HCIFR;
	union  HCICLR_REG          HCICLR;
	union  HCIFRC_REG          HCIFRC;
	Uint16                     HCCOUNTER;
    Uint16                     rsvd1[3];
	union  HCCALCTL_REG        HCCALCTL;
	Uint16                     rsvd2[7];
	Uint16                     HCCAPCNTRISE0;
	Uint16                     rsvd3;
	Uint16                     HCCAPCNTFALL0;
	Uint16                     rsvd4;
	union  HCCAPDLYRISE0_REG   HCCAPDLYRISE0;
	union  HCCAPDLYFALL0_REG   HCCAPDLYFALL0;
	Uint16                     rsvd5[2];
	Uint16                     HCCAPCNTRISE1;
	Uint16                     rsvd6;
	Uint16                     HCCAPCNTFALL1;
	Uint16                     rsvd7;
	union  HCCAPDLYRISE1_REG   HCCAPDLYRISE1;
	union  HCCAPDLYFALL1_REG   HCCAPDLYFALL1;
    Uint16                     rsvd8[2];
};
*/

struct HRCAP_REGS {
    union  HCCTL_REG           HCCTL;
	union  HCIFR_REG           HCIFR;
	union  HCICLR_REG          HCICLR;
	union  HCIFRC_REG          HCIFRC;
	Uint16                     HCCOUNTER;
    Uint16                     rsvd1[4];
	Uint16                     rsvd2[7];
	Uint16                     HCCAPCNTRISE0;
	Uint16                     rsvd3;
	Uint16                     HCCAPCNTFALL0;
	Uint16                     rsvd4;
	Uint16                     rsvd5;
	Uint16                     rsvd6;
	Uint16                     rsvd7[2];
	Uint16                     HCCAPCNTRISE1;
	Uint16                     rsvd8;
	Uint16                     HCCAPCNTFALL1;
	Uint16                     rsvd9;
	Uint16                     rsvd10;
	Uint16                     rsvd11;
    Uint16                     rsvd12[2];
};

//===========================================================================
//  High Resolution Capture External References and Function Declarations
//

extern volatile struct HRCAP_REGS HRCap1Regs;
extern volatile struct HRCAP_REGS HRCap2Regs;



//===========================================================================
// End of file
//===========================================================================
//###########################################################################
//
// FILE:   DSP2803x_I2c.h
//
// TITLE:  DSP2803x Inter-Integrated Circuit (I2C) Module
//         Register Bit Definitions.
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



//----------------------------------------------------
// I2C interrupt vector register bit definitions */
struct I2CISRC_BITS {         // bits   description
   Uint16 INTCODE:3;          // 2:0    Interrupt code
   Uint16 rsvd1:13;           // 15:3   reserved
};

union I2CISRC_REG {
   Uint16                 all;
   struct I2CISRC_BITS    bit;
};

//----------------------------------------------------
// I2C interrupt mask register bit definitions */
struct I2CIER_BITS {          // bits   description
   Uint16 ARBL:1;               // 0      Arbitration lost interrupt
   Uint16 NACK:1;             // 1      No ack interrupt
   Uint16 ARDY:1;             // 2      Register access ready interrupt
   Uint16 RRDY:1;             // 3      Recieve data ready interrupt
   Uint16 XRDY:1;             // 4      Transmit data ready interrupt
   Uint16 SCD:1;              // 5      Stop condition detection
   Uint16 AAS:1;              // 6      Address as slave
   Uint16 rsvd:9;             // 15:7   reserved
};

union I2CIER_REG {
   Uint16                 all;
   struct I2CIER_BITS     bit;
};

//----------------------------------------------------
// I2C status register bit definitions */
struct I2CSTR_BITS {          // bits   description
   Uint16 ARBL:1;               // 0      Arbitration lost interrupt
   Uint16 NACK:1;             // 1      No ack interrupt
   Uint16 ARDY:1;             // 2      Register access ready interrupt
   Uint16 RRDY:1;             // 3      Recieve data ready interrupt
   Uint16 XRDY:1;             // 4      Transmit data ready interrupt
   Uint16 SCD:1;              // 5      Stop condition detection
   Uint16 rsvd1:2;            // 7:6    reserved
   Uint16 AD0:1;              // 8      Address Zero
   Uint16 AAS:1;              // 9      Address as slave
   Uint16 XSMT:1;             // 10     XMIT shift empty
   Uint16 RSFULL:1;           // 11     Recieve shift full
   Uint16 BB:1;               // 12     Bus busy
   Uint16 NACKSNT:1;          // 13     A no ack sent
   Uint16 SDIR:1;             // 14     Slave direction
   Uint16 rsvd2:1;            // 15     reserved
};

union I2CSTR_REG {
   Uint16                 all;
   struct I2CSTR_BITS     bit;
};

//----------------------------------------------------
// I2C mode control register bit definitions */
struct I2CMDR_BITS {          // bits   description
   Uint16 BC:3;               // 2:0    Bit count
   Uint16 FDF:1;              // 3      Free data format
   Uint16 STB:1;              // 4      Start byte
   Uint16 IRS:1;              // 5      I2C Reset not
   Uint16 DLB:1;              // 6      Digital loopback
   Uint16 RM:1;               // 7      Repeat mode
   Uint16 XA:1;               // 8      Expand address
   Uint16 TRX:1;              // 9      Transmitter/reciever
   Uint16 MST:1;              // 10     Master/slave
   Uint16 STP:1;              // 11     Stop condition
   Uint16 rsvd1:1;            // 12     reserved
   Uint16 STT:1;              // 13     Start condition
   Uint16 FREE:1;             // 14     Emulation mode
   Uint16 NACKMOD:1;          // 15     No Ack mode
};

union I2CMDR_REG {
   Uint16                 all;
   struct I2CMDR_BITS     bit;
};

//----------------------------------------------------
// I2C extended mode control register bit definitions */
struct I2CEMDR_BITS {          // bits   description
   Uint16 BCM:1;               // 0      Bit count
   Uint16 rsvd1:15;            // 15:1   reserved
};

union I2CEMDR_REG {
   Uint16                 all;
   struct I2CEMDR_BITS    bit;
};

//----------------------------------------------------
// I2C pre-scaler register bit definitions */
struct I2CPSC_BITS {         // bits   description
   Uint16 IPSC:8;            // 7:0    pre-scaler
   Uint16 rsvd1:8;           // 15:8   reserved
};

union I2CPSC_REG {
   Uint16                 all;
   struct I2CPSC_BITS     bit;
};

//----------------------------------------------------
// TX FIFO control register bit definitions */
struct I2CFFTX_BITS {         // bits   description
   Uint16 TXFFIL:5;           // 4:0    FIFO interrupt level
   Uint16 TXFFIENA:1;         // 5      FIFO interrupt enable/disable
   Uint16 TXFFINTCLR:1;       // 6      FIFO clear
   Uint16 TXFFINT:1;          // 7      FIFO interrupt flag
   Uint16 TXFFST:5;           // 12:8   FIFO level status
   Uint16 TXFFRST:1;          // 13     FIFO reset
   Uint16 I2CFFEN:1;          // 14     enable/disable TX & RX FIFOs
   Uint16 rsvd1:1;            // 15     reserved

};

union I2CFFTX_REG {
   Uint16                 all;
   struct I2CFFTX_BITS    bit;
};

//----------------------------------------------------
// RX FIFO control register bit definitions */
struct I2CFFRX_BITS {         // bits   description
   Uint16 RXFFIL:5;           // 4:0    FIFO interrupt level
   Uint16 RXFFIENA:1;         // 5      FIFO interrupt enable/disable
   Uint16 RXFFINTCLR:1;       // 6      FIFO clear
   Uint16 RXFFINT:1;          // 7      FIFO interrupt flag
   Uint16 RXFFST:5;           // 12:8   FIFO level
   Uint16 RXFFRST:1;          // 13     FIFO reset
   Uint16 rsvd1:2;            // 15:14  reserved
};

union I2CFFRX_REG {
   Uint16                 all;
   struct I2CFFRX_BITS    bit;
};

//----------------------------------------------------

struct I2C_REGS {
   Uint16              I2COAR;    // Own address register
   union  I2CIER_REG   I2CIER;    // Interrupt enable
   union  I2CSTR_REG   I2CSTR;    // Interrupt status
   Uint16              I2CCLKL;   // Clock divider low
   Uint16              I2CCLKH;   // Clock divider high
   Uint16              I2CCNT;    // Data count
   Uint16              I2CDRR;    // Data recieve
   Uint16              I2CSAR;    // Slave address
   Uint16              I2CDXR;    // Data transmit
   union  I2CMDR_REG   I2CMDR;    // Mode
   union  I2CISRC_REG  I2CISRC;   // Interrupt source
   union  I2CEMDR_REG  I2CEMDR;   // Extended mode
   union  I2CPSC_REG   I2CPSC;    // Pre-scaler
   Uint16              rsvd2[19]; // reserved
   union  I2CFFTX_REG  I2CFFTX;   // Transmit FIFO
   union  I2CFFRX_REG  I2CFFRX;   // Recieve FIFO
};



//---------------------------------------------------------------------------
// External References & Function Declarations:
//
extern volatile struct I2C_REGS I2caRegs;



//===========================================================================
// End of file.
//===========================================================================
//###########################################################################
//
// FILE:   DSP2803x_LIN.h
//
// TITLE:  DSP2803x Device LIN Register Definitions.
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



/* --------------------------------------------------- */
/* LIN Registers                                       */
/* ----------------------------------------------------*/

/* Global Control Register 0 (SCIGCR0) bit definitions */
struct SCIGCR0_BITS {      // bit    description
    Uint16  RESET:1;       // 0      LIN Module reset bit
    Uint16  rsvd1:15;      // 15:1   reserved
	Uint16  rsvd2:16;      // 31:16  reserved
};

/* Allow access to the bit fields or entire register */
union SCIGCR0_REG {
   Uint32               all;
   struct SCIGCR0_BITS  bit;
};

/* Global Control Register 1 (SCIGCR1) bit definitions */
struct SCIGCR1_BITS {      // bit    description
    Uint16  COMMMODE:1;    // 0      SCI/LIN communications mode bit
    Uint16  TIMINGMODE:1;  // 1      SCI timing mode bit. Should be set to 1 for SCI mode.
    Uint16  PARITYENA:1;   // 2      Parity enable
    Uint16  PARITY:1;      // 3      SCI parity odd/even selection
    Uint16  STOP:1;        // 4      SCI number of stop bits
    Uint16  CLK_MASTER:1;  // 5      LIN Master/Slave selection and SCI clock enable
    Uint16  LINMODE:1;     // 6      LIN Mode enable/disable
    Uint16  SWnRST:1;      // 7      Software reset
    Uint16  SLEEP:1;       // 8      SCI sleep (SCI compatibility mode)
    Uint16  ADAPT:1;       // 9      Automatic baudrate adjustment control(LIN mode)
    Uint16  MBUFMODE:1;    // 10     Multi-buffer mode
    Uint16  CTYPE:1;       // 11     Checksum type (LIN mode)
    Uint16  HGENCTRL:1;    // 12     Mask filtering comparison control (LIN mode)
    Uint16  STOPEXTFRAME:1;// 13     Stop extended frame communication (LIN mode)
    Uint16  rsvd2:2;       // 15:14  Reserved
    Uint16  LOOPBACK:1;    // 16     Digital loopback mode
    Uint16  CONT:1;        // 17     Continue on suspend
    Uint16  rsvd3:6;       // 23:18  reserved
    Uint16  RXENA:1;       // 24     SCI mode receiver enable
    Uint16  TXENA:1;       // 25     SCI mode transmitter enable
    Uint16  rsvd4:6;       // 31:26  reserved
};

/* Allow access to the bit fields or entire register */
union SCIGCR1_REG {
   Uint32               all;
   struct SCIGCR1_BITS  bit;
};

/* Global Control Register 2 (SCIGCR2) bit definitions */
struct SCIGCR2_BITS {      // bit    description
    Uint16  POWERDOWN:1;   // 0      Low-power mode PowerDown bit
    Uint16  rsvd1:7;       // 7:1    reserved
    Uint16  GENWU:1;       // 8      Generate Wakeup
    Uint16  rsvd2:7;       // 15:9   reserved
    Uint16  SC:1;          // 16     Send Checksum (LIN mode)
    Uint16  CC:1;          // 17     Compare Checksum (LIN mode)
    Uint16  rsvd3:14;      // 31:18  reserved
};

/* Allow access to the bit fields or entire register */
union SCIGCR2_REG {
   Uint32               all;
   struct SCIGCR2_BITS  bit;
};

/* SCI Set Interrupt Register (SCISETINT) bit definitions */
struct SCISETINT_BITS {      // bit    description
    Uint16  SETBRKDTINT:1;   // 0      Set Break-detect Interrupt (SCI compatible mode)
    Uint16  SETWAKEUPINT:1;  // 1      Set Wake-up Interrupt
    Uint16  rsvd1:2;         // 3:2    reserved
    Uint16  SETTIMEOUTINT:1; // 4      Set Timeout Interrupt (LIN only)
    Uint16  rsvd2:1;         // 5      reserved
    Uint16  SETTOAWUSINT:1;  // 6      Set Timeout After Wakeup Signal Interrupt (LIN only)
    Uint16  SETTOA3WUSINT:1; // 7      Set Timeout After 3 Wakeup Signals Interrupt (LIN only)
    Uint16  SETTXINT:1;      // 8      Set Transmitter Interrupt
    Uint16  SETRXINT:1;      // 9      Receiver Interrupt Enable
    Uint16  rsvd3:3;         // 12:10  reserved
    Uint16  SETIDINT:1;      // 13     Set Identifier Interrupt (LIN only)
    Uint16  rsvd4:2;         // 15:14  reserved
	Uint16  rsvd5:2;         // 17:16  reserved
    Uint16  rsvd6:1;         // 18     reserved
    Uint16  rsvd7:5;         // 23:19  reserved
    Uint16  SETPEINT:1;      // 24     Set Parity Interrupt
    Uint16  SETOEINT:1;      // 25     Set Overrun-Error Interrupt
    Uint16  SETFEINT:1;      // 26     Set Framing-Error Interrupt
    Uint16  SETNREINT:1;     // 27     Set No-Response-Error Interrupt (LIN only)
    Uint16  SETISFEINT:1;    // 28     Set Inconsistent-Synch-Field-Error Interrupt (LIN only)
    Uint16  SETCEINT:1;      // 29     Set Checksum-error Interrupt (LIN only)
    Uint16  SETPBEINT:1;     // 30     Set Physical Bus Error Interrupt (LIN only)
    Uint16  SETBEINT:1;      // 31     Set Bit Error Interrupt (LIN only)
};

/* Allow access to the bit fields or entire register */
union SCISETINT_REG {
   Uint32                 all;
   struct SCISETINT_BITS  bit;
};

/* SCI Clear Interrupt (SCICLEARINT) Register bit definitions */
struct SCICLEARINT_BITS {    // bit    description
    Uint16  CLRBRKDTINT:1;   // 0      Clear Break-detect Interrupt (SCI compatible mode)
    Uint16  CLRWAKEUPINT:1;  // 1      Clear Wake-up Interrupt
    Uint16  rsvd1:2;         // 3:2    reserved
    Uint16  CLRTIMEOUTINT:1; // 4      Clear Timeout Interrupt (LIN only)
    Uint16  rsvd2:1;         // 5      reserved
    Uint16  CLRTOAWUSINT:1;  // 6      Clear Timeout After Wakeup Signal Interrupt (LIN only)
    Uint16  CLRTOA3WUSINT:1; // 7      Clear Timeout After 3 Wakeup Signals Interrupt (LIN only)
    Uint16  CLRTXINT:1;      // 8      Clear Transmitter Interrupt
    Uint16  CLRRXINT:1;      // 9      Clear Receiver Interrupt
    Uint16  rsvd3:3;         // 12:10  reserved
    Uint16  CLRIDINT:1;      // 13     Clear Identifier Interrupt (LIN only)
    Uint16  rsvd4:2;         // 15:14  reserved
	Uint16  rsvd5:2;         // 17:16  reserved
    Uint16  rsvd6:1;         // 18     reserved
    Uint16  rsvd7:5;         // 23:19  reserved
    Uint16  CLRPEINT:1;      // 24     Clear Parity Interrupt
    Uint16  CLROEINT:1;      // 25     Clear Overrun-Error Interrupt
    Uint16  CLRFEINT:1;      // 26     Clear Framing-Error Interrupt
    Uint16  CLRNREINT:1;     // 27     Clear No-Response-Error Interrupt (LIN only)
    Uint16  CLRISFEINT:1;    // 28     Clear Inconsistent-Synch-Field-Error Interrupt (LIN only)
    Uint16  CLRCEINT:1;      // 29     Clear Checksum-error Interrupt (LIN only)
    Uint16  CLRPBEINT:1;     // 30     Clear Physical Bus Error Interrupt (LIN only)
    Uint16  CLRBEINT:1;      // 31     Clear Bit Error Interrupt (LIN only)
};

/* Allow access to the bit fields or entire register */
union SCICLEARINT_REG {
   Uint32                   all;
   struct SCICLEARINT_BITS  bit;
};

/* SCI Set Interrupt Level Register (SCISETINTLVL) bit definitions */
struct SCISETINTLVL_BITS {      // bit    description
    Uint16  SETBRKDTINTLVL:1;   // 0      Set Break-detect Interrupt Level (SCI compatible mode)
    Uint16  SETWAKEUPINTLVL:1;  // 1      Set Wake-up Interrupt Level
    Uint16  rsvd1:2;            // 3:2    reserved
    Uint16  SETTIMEOUTINTLVL:1; // 4      Set Timeout Interrupt Level (LIN only)
    Uint16  rsvd2:1;            // 5      reserved
    Uint16  SETTOAWUSINTLVL:1;  // 6      Set Timeout After Wakeup Signal Interrupt Level (LIN only)
    Uint16  SETTOA3WUSINTLVL:1; // 7      Set Timeout After 3 Wakeup Signals Interrupt Level (LIN only)
    Uint16  SETTXINTLVL:1;      // 8      Set Transmitter Interrupt Level
    Uint16  SETRXINTOVO:1;      // 9      Receiver Interrupt Enable Level
    Uint16  rsvd3:3;            // 12:10  reserved
    Uint16  SETIDINTLVL:1;      // 13     Set Identifier Interrupt Level (LIN only)
    Uint16  rsvd4:2;            // 15:14  reserved
	Uint16  rsvd5:2;            // 17:16  reserved
    Uint16  rsvd6:1;            // 18     reserved
    Uint16  rsvd7:5;            // 23:19  reserved
    Uint16  SETPEINTLVL:1;      // 24     Set Parity Interrupt Level
    Uint16  SETOEINTLVL:1;      // 25     Set Overrun-Error Interrupt Level
    Uint16  SETFEINTLVL:1;      // 26     Set Framing-Error Interrupt Level
    Uint16  SETNREINTLVL:1;     // 27     Set No-Response-Error Interrupt Level (LIN only)
    Uint16  SETISFEINTLVL:1;    // 28     Set Inconsistent-Synch-Field-Error Interrupt Level (LIN only)
    Uint16  SETCEINTLVL:1;      // 29     Set Checksum-error Interrupt Level (LIN only)
    Uint16  SETPBEINTLVL:1;     // 30     Set Physical Bus Error Interrupt Level (LIN only)
    Uint16  SETBEINTLVL:1;      // 31     Set Bit Error Interrupt Level(LIN only)
};

/* Allow access to the bit fields or entire register */
union SCISETINTLVL_REG {
   Uint32                    all;
   struct SCISETINTLVL_BITS  bit;
};

/* SCI Clear Interrupt Level (SCICLEARINTLVL) Register bit definitions */
struct SCICLEARINTLVL_BITS {    // bit    description
    Uint16  CLRBRKDTINTLVL:1;   // 0      Clear Break-detect Interrupt Level (SCI compatible mode)
    Uint16  CLRWAKEUPINTLVL:1;  // 1      Clear Wake-up Interrupt Level
    Uint16  rsvd1:2;            // 3:2    reserved
    Uint16  CLRTIMEOUTINTLVL:1; // 4      Clear Timeout Interrupt Level (LIN only)
    Uint16  rsvd2:1;            // 5      reserved
    Uint16  CLRTOAWUSINTLVL:1;  // 6      Clear Timeout After Wakeup Signal Interrupt Level (LIN only)
    Uint16  CLRTOA3WUSINTLVL:1; // 7      Clear Timeout After 3 Wakeup Signals Interrupt Level (LIN only)
    Uint16  CLRTXINTLVL:1;      // 8      Clear Transmitter Interrupt Level
    Uint16  CLRRXINTLVL:1;      // 9      Clear Receiver Interrupt Level
    Uint16  rsvd3:3;            // 12:10  reserved
    Uint16  CLRIDINTLVL:1;      // 13     Clear Identifier Interrupt Level (LIN only)
    Uint16  rsvd4:2;            // 15:14  reserved
	Uint16  rsvd5:2;            // 17:16  reserved
    Uint16  rsvd6:1;            // 18     reserved
    Uint16  rsvd7:5;            // 23:19  reserved
    Uint16  CLRPEINTLVL:1;      // 24     Clear Parity Interrupt Level
    Uint16  CLROEINTLVL:1;      // 25     Clear Overrun-Error Interrupt Level
    Uint16  CLRFEINTLVL:1;      // 26     Clear Framing-Error Interrupt Level
    Uint16  CLRNREINTLVL:1;     // 27     Clear No-Response-Error Interrupt Level (LIN only)
    Uint16  CLRISFEINTLVL:1;    // 28     Clear Inconsistent-Synch-Field-Error Interrupt Level (LIN only)
    Uint16  CLRCEINTLVL:1;      // 29     Clear Checksum-error Interrupt Level (LIN only)
    Uint16  CLRPBEINTLVL:1;     // 30     Clear Physical Bus Error Interrupt Level (LIN only)
    Uint16  CLRBEINTLVL:1;      // 31     Clear Bit Error Interrupt Level (LIN only)
};

/* Allow access to the bit fields or entire register */
union SCICLEARINTLVL_REG {
   Uint32                      all;
   struct SCICLEARINTLVL_BITS  bit;
};

/* SCI Flags Register (SCIFLR) bit definitions */
struct SCIFLR_BITS {            // bit    description
    Uint16  BRKDT:1;            // 0      Break-detect Flag (SCI compatible mode)
    Uint16  WAKEUP:1;           // 1      Wake-up Flag
    Uint16  IDLE:1;             // 2      SCI receiver in idle state (SCI compatible mode)
    Uint16  BUSY:1;             // 3      Busy Flag
    Uint16  TIMEOUT:1;          // 4      LIN Bus IDLE timeout Flag (LIN only)
    Uint16  rsvd2:1;            // 5      reserved
    Uint16  TOAWUS:1;           // 6      Timeout After Wakeup Signal Flag (LIN only)
    Uint16  TOA3WUS:1;          // 7      Timeout After 3 Wakeup Signals Flag (LIN only)
    Uint16  TXRDY:1;            // 8      Transmitter Buffer Ready Flag
    Uint16  RXRDY:1;            // 9      Receiver Buffer Ready Flag
    Uint16  TXWAKE:1;	        // 10     SCI Transmitter Wakeup Method Select
    Uint16  TXEMPTY:1;          // 11     Transmitter Empty Clag
    Uint16  RXWAKE:1;           // 12     Receiver Wakeup Detect Flag
    Uint16  IDTXFLAG:1;         // 13     Identifier On Transmit Flag (LIN only)
    Uint16  IDRXFLAG:1;         // 14     Identifier on Receive Flag
	Uint16	rsvd3:1;			// 15
    Uint16  rsvd4:8;            // 23:16  reserved
    Uint16  PE:1;               // 24     Parity Error Flag
    Uint16  OE:1;               // 25     Overrun Error Flag
    Uint16  FE:1;               // 26     Framing Error Flag
    Uint16  NRE:1;              // 27     No-Response Error Flag (LIN only)
    Uint16  ISFE:1;             // 28     Inconsistent Synch Field Error Flag (LIN only)
    Uint16  CE:1;               // 29     Checksum Error Flag (LIN only)
    Uint16  PBE:1;              // 30     Physical Bus Error Flag (LIN only)
    Uint16  BE:1;               // 31     Bit Error Flag (LIN only)
};

/* Allow access to the bit fields or entire register */
union SCIFLR_REG {
   Uint32             all;
   struct SCIFLR_BITS  bit;
};

/* SCI Interrupt Vector Offset 0 (SCIINTVECT0) bit definitions */
struct SCIINTVECT0_BITS {      // bit    description
    Uint16  INTVECT0:5;        // 4:0    Interrupt vector offset for INT0
    Uint16  rsvd1:11;          // 15:5   reserved
	Uint16  rsvd2:16;          // 31:16  reserved
};

/* Allow access to the bit fields or entire register */
union SCIINTVECT0_REG {
   Uint32               all;
   struct SCIINTVECT0_BITS  bit;
};

/* SCI Interrupt Vector Offset 1 (SCIINTVECT1) bit definitions */
struct SCIINTVECT1_BITS {      // bit    description
    Uint16  INTVECT1:5;        // 4:0    Interrupt vector offset for INT1
    Uint16  rsvd1:11;          // 15:5   reserved
	Uint16  rsvd2:16;          // 31:16  reserved
};

/* Allow access to the bit fields or entire register */
union SCIINTVECT1_REG {
   Uint32               all;
   struct SCIINTVECT1_BITS  bit;
};

/* SCI Format Control Register (SCIFORMAT) bit definitions */
struct SCIFORMAT_BITS {        // bit    description
    Uint16  CHAR:3;            // 2:0    Character Length Control Bits
    Uint16  rsvd1:13;          // 15:3   reserved
    Uint16  LENGTH:3;          // 18:16  Frame Length Control Bits
    Uint16  rsvd2:13;          // 31:19  reserved
};

/* Allow access to the bit fields or entire register */
union SCIFORMAT_REG {
   Uint32                 all;
   struct SCIFORMAT_BITS  bit;
};

/* Baud Rate Selection Register (BRSR) bit definitions */
struct BRSR_BITS {             // bit    description
	Uint16  SCI_LIN_PSL :16;   // 15:0   SCI/LIN Prescaler Low
	Uint16  SCI_LIN_PSH :8;    // 23:16  SCI/LIN Prescaler High
    Uint16  M:4;               // 27:24  SCI/LIN Fractional Divider Selection
    Uint16  rsvd1:4;           // 31:28     reserved
};

/* Allow access to the bit fields or entire register */
union BRSR_REG {
   Uint32               all;
   struct BRSR_BITS     bit;
};

/* SCI Pin I/O Control Register 2 (SCIPIO2) bit definitions */
struct SCIPIO2_BITS {          // bit    description
    Uint16  rsvd1:1;           // 0      reserved
    Uint16  RXIN:1;            // 1      SCIRX pin value
    Uint16  TXIN:1;            // 2      SCITX pin value
    Uint16  rsvd2:13;          // 15:3   reserved
	Uint16  rsvd3:16;          // 31:16  reserved
};

/* Allow access to the bit fields or entire register */
union SCIPIO2_REG {
   Uint32               all;
   struct SCIPIO2_BITS  bit;
};


/* LIN Compare Register (LINCOMP) bit definitions */
struct LINCOMP_BITS {          // bit    description
    Uint16  SBREAK:3;          // 2:0    Synch Break Extend
    Uint16  rsvd1:5;           // 7:3    reserved
    Uint16  SDEL:2;            // 9:8    Sync Delimiter Compare
	Uint16  rsvd2:6;           // 15:10  reserved
	Uint16  rsvd3:16;          // 31:16  reserved
};

/* Allow access to the bit fields or entire register */
union LINCOMP_REG {
   Uint32               all;
   struct LINCOMP_BITS  bit;
};


/* LIN Receive Data 0 Register (LINRD0) bit definitions */
struct LINRD0_BITS {           // bit    description
    Uint16  RD3:8;             // 7:0    Receive Buffer 3
    Uint16  RD2:8;             // 15:8   Receive Buffer 2
    Uint16  RD1:8;             // 23:16  Receive Buffer 1
    Uint16  RD0:8;             // 31:24  Receive Buffer 0
};

/* Allow access to the bit fields or entire register */
union LINRD0_REG {
   Uint32              all;
   struct LINRD0_BITS  bit;
};

/* LIN Receive Data 1 Register (LINRD1) bit definitions */
struct LINRD1_BITS {           // bit    description
    Uint16  RD7:8;             // 7:0    Receive Buffer 7
    Uint16  RD6:8;             // 15:8   Receive Buffer 6
    Uint16  RD5:8;             // 23:16  Receive Buffer 5
    Uint16  RD4:8;             // 31:24  Receive Buffer 4
};

/* Allow access to the bit fields or entire register */
union LINRD1_REG {
   Uint32              all;
   struct LINRD1_BITS  bit;
};

/* LIN Acceptance Mask Register (LINMASK) bit definitions */
struct LINMASK_BITS {          // bit    description
    Uint16  TXIDMASK:8;        // 7:0    TX ID Mask bits (LIN only)
    Uint16  rsvd1:8;           // 15:8   reserved
    Uint16  RXIDMASK:8;        // 23:16  RX ID Mask bits (LIN only)
    Uint16  rsvd2:8;           // 31:24  reserved
};

/* Allow access to the bit fields or entire register */
union LINMASK_REG {
   Uint32               all;
   struct LINMASK_BITS  bit;
};

/* LIN ID Register (LINID) bit definitions */
struct LINID_BITS {            // bit    description
    Uint16  IDBYTE:8;          // 7:0    LIN message ID (LIN only)
    Uint16  IDSLAVETASKBYTE:8; // 15:8   Received ID comparison ID (LIN only)
    Uint16  RECEIVEDID:8;      // 23:16  Current Message ID (LIN only)
    Uint16  rsvd1:8;           // 31:24  reserved
};

/* Allow access to the bit fields or entire register */
union LINID_REG {
   Uint32             all;
   struct LINID_BITS  bit;
};

/* LIN Transmit Data 0 Register (LINTD0) bit definitions */
struct LINTD0_BITS {           // bit    description
    Uint16  TD3:8;             // 7:0    Transmit Buffer 3
    Uint16  TD2:8;             // 15:8   Transmit Buffer 2
    Uint16  TD1:8;             // 23:16  Transmit Buffer 1
    Uint16  TD0:8;             // 31:24  Transmit Buffer 0
};

/* Allow access to the bit fields or entire register */
union LINTD0_REG {
   Uint32              all;
   struct LINTD0_BITS  bit;
};

/* LIN Transmit Data 1 Register (LINTD1) bit definitions */
struct LINTD1_BITS {           // bit    description
    Uint16  TD7:8;             // 7:0    Transmit Buffer 7
    Uint16  TD6:8;             // 15:8   Transmit Buffer 6
    Uint16  TD5:8;             // 23:16  Transmit Buffer 5
    Uint16  TD4:8;             // 31:24  Transmit Buffer 4
};

/* Allow access to the bit fields or entire register */
union LINTD1_REG {
   Uint32               all;
   struct LINTD1_BITS   bit;
};

/* IODFT for LIN (IODFTCTRL) bit definitions */
struct IODFTCTRL_BITS {        // bit    description
    Uint16  RXPENA:1;          // 0      Analog Loopback Via Receive Pin Enable
    Uint16  LPBENA:1;          // 1      Module Loopback Enable
    Uint16  rsvd1:6;           // 7:2    reserved
    Uint16  IODFTENA:4;        // 11:8   IO DFT Enable Key
    Uint16  rsvd2:4;           // 15:12  Reserved
    Uint16  TXSHIFT:3;         // 18:16  Transmit Delay Shift
    Uint16  PINSAMPLEMASK:2;   // 20:19  TX Pin Sample Mask
    Uint16  rsvd3:3;           // 23:21  Reserved
    Uint16  BRKDTERRENA:1;     // 24     Break Detect Error Enable (SCI compatibility mode)
    Uint16  PERRENA:1;         // 25     Parity Error Enable (SCI compatibility mode)
    Uint16  FERRENA:1;         // 26     Frame Error Enable (SCI compatibility mode)
    Uint16  rsvd:1;            // 27     reserved
    Uint16  ISFERRENA:1;       // 28     Inconsistent Synch Field Error Enable (LIN mode)
    Uint16  CERRENA:1;         // 29     Checksum Error Enable(LIN mode)
    Uint16  PBERRENA:1;        // 30     Physical Bus Error Enable (LIN mode)
    Uint16  BERRENA:1;         // 31     Bit Error Enable (LIN mode)
};

/* Allow access to the bit fields or entire register */
union IODFTCTRL_REG {
   Uint32                 all;
   struct IODFTCTRL_BITS  bit;
};


/**************************************/
/* LIN register file */
/**************************************/

struct LIN_REGS {
    union   SCIGCR0_REG         SCIGCR0;            // Global Control Register 0
	union	SCIGCR1_REG		    SCIGCR1;		    // Global Control Register 1
	union	SCIGCR2_REG		    SCIGCR2;		    // Global Control Register 2
	union	SCISETINT_REG		SCISETINT;		    // Interrupt Enable Register
	union	SCICLEARINT_REG		SCICLEARINT;		// Interrupt Disable Register
	union	SCISETINTLVL_REG	SCISETINTLVL;		// Set Interrupt Level Register
	union	SCICLEARINTLVL_REG	SCICLEARINTLVL;		// Clear Interrupt Level Register
	union	SCIFLR_REG		    SCIFLR;		        // Flag Register
	union	SCIINTVECT0_REG		SCIINTVECT0;		// Interrupt Vector Offset Register 0
	union	SCIINTVECT1_REG	 	SCIINTVECT1;	 	// Interrupt Vector Offset Register 1
	union	SCIFORMAT_REG		SCIFORMAT;		    // Length Control Register
	union	BRSR_REG			BRSR;				// Baud Rate Selection Register
	Uint32          			SCIED;				// Emulation buffer Register
	Uint32          			SCIRD;				// Receiver data buffer Register
	Uint32          			SCITD;				// Transmit data buffer Register
	Uint32                      rsvd1[2];			// reserved
	union	SCIPIO2_REG			SCIPIO2;			// Pin control Register 2
	Uint32                      rsvd2[6];           // reserved
	union	LINCOMP_REG			LINCOMP;		    // Compare register
	union	LINRD0_REG			LINRD0;				// Receive data register 0
	union	LINRD1_REG			LINRD1;				// Receive data register 1
	union	LINMASK_REG			LINMASK;		    // Acceptance mask register
	union	LINID_REG			LINID;				// LIN ID Register
	union	LINTD0_REG			LINTD0;				// Transmit Data Register 0
	union	LINTD1_REG			LINTD1;				// Transmit Data Register 1
	Uint32			            MBRSR;				// Baud Rate Selection Register
	Uint32						rsvd3[4];		    // reserved
	union   IODFTCTRL_REG		IODFTCTRL;			// IODFT for LIN
};

//---------------------------------------------------------------------------
// LIN External References & Function Declarations:
//
extern volatile struct LIN_REGS LinaRegs;



//===========================================================================
// End of file.
//===========================================================================
//###########################################################################
//
// FILE:   DSP2803x_NmiIntrupt.h
//
// TITLE:  DSP2803x Device NMI Interrupt Register Definitions
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



//===========================================================================
//  NMI Interrupt Register Bit Definitions
//

struct NMICFG_BITS {             // bits      description
    Uint16   rsvd1:1;            // 0         reserved
    Uint16   CLOCKFAIL:1;        // 1         Fail Interrupt Enable Bits
    Uint16   rsvd2:14;           // 15:02     reserved
};

union NMICFG_REG  {
    Uint16                         all;
    struct NMICFG_BITS             bit;
};

struct NMIFLG_BITS {             // bits      description
    Uint16   NMIINT:1;           // 0         NMI Interrupt Flag
    Uint16   CLOCKFAIL:1;        // 1         Clock Fail Interrupt Flags
    Uint16   rsvd1:14;           // 15:02     reserved
};

union NMIFLG_REG  {
    Uint16                         all;
    struct NMIFLG_BITS             bit;
};

struct NMIFLGCLR_BITS {          // bits      description
    Uint16   NMIINT:1;           // 0         NMIINT Flag Clear Bit
    Uint16   CLOCKFAIL:1;        // 1         CLOCKFAIL Flag Clear Bit
    Uint16   rsvd1:14;           // 15:02     reserved
};

union NMIFLGCLR_REG  {
    Uint16                         all;
    struct NMIFLGCLR_BITS          bit;
};

struct NMIFLGFRC_BITS {          // bits      description
    Uint16   rsvd1:1;            // 0         reserved
    Uint16   CLOCKFAIL:1;        // 1         CLOCKFAIL Flag Force Bit
    Uint16   rsvd2:14;           // 15:02     reserved
};

union NMIFLGFRC_REG  {
    Uint16                         all;
    struct NMIFLGFRC_BITS          bit;
};

//===========================================================================
//  NMI Interrupt Register Definitions
//

struct NMIINTRUPT_REGS {
    union  NMICFG_REG          NMICFG;
    union  NMIFLG_REG          NMIFLG;
    union  NMIFLGCLR_REG       NMIFLGCLR;
    union  NMIFLGFRC_REG       NMIFLGFRC;
    Uint16                     NMIWDCNT;
    Uint16                     NMIWDPRD;
    Uint16                     rsvd1[10];
};

//===========================================================================
//  NMI Interrupt External References and Function Declarations
//

extern volatile struct NMIINTRUPT_REGS NmiIntruptRegs;



//===========================================================================
// End of file
//===========================================================================
//###########################################################################
//
// FILE:   DSP2803x_PieCtrl.h
//
// TITLE:  DSP2803x Device PIE Control Register Definitions.
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



//---------------------------------------------------------------------------
// PIE Control Register Bit Definitions:
//
// PIECTRL: Register bit definitions:
struct PIECTRL_BITS {      // bits description
   Uint16  ENPIE:1;        // 0    Enable PIE block
   Uint16  PIEVECT:15;     // 15:1 Fetched vector address
};

union PIECTRL_REG {
   Uint16                 all;
   struct PIECTRL_BITS  bit;
};  

// PIEIER: Register bit definitions:
struct PIEIER_BITS {       // bits description
   Uint16 INTx1:1;         // 0    INTx.1
   Uint16 INTx2:1;         // 1    INTx.2
   Uint16 INTx3:1;         // 2    INTx.3
   Uint16 INTx4:1;         // 3    INTx.4
   Uint16 INTx5:1;         // 4    INTx.5
   Uint16 INTx6:1;         // 5    INTx.6
   Uint16 INTx7:1;         // 6    INTx.7
   Uint16 INTx8:1;         // 7    INTx.8
   Uint16 rsvd:8;          // 15:8 reserved
};

union PIEIER_REG {
   Uint16              all;
   struct PIEIER_BITS  bit;
}; 

// PIEIFR: Register bit definitions:
struct PIEIFR_BITS {       // bits description
   Uint16 INTx1:1;         // 0    INTx.1
   Uint16 INTx2:1;         // 1    INTx.2
   Uint16 INTx3:1;         // 2    INTx.3
   Uint16 INTx4:1;         // 3    INTx.4
   Uint16 INTx5:1;         // 4    INTx.5
   Uint16 INTx6:1;         // 5    INTx.6
   Uint16 INTx7:1;         // 6    INTx.7
   Uint16 INTx8:1;         // 7    INTx.8
   Uint16 rsvd:8;          // 15:8 reserved
};

union PIEIFR_REG {
   Uint16              all;
   struct PIEIFR_BITS  bit;
};

// PIEACK: Register bit definitions:
struct PIEACK_BITS {       // bits description
   Uint16 ACK1:1;          // 0    Acknowledge PIE interrupt group 1
   Uint16 ACK2:1;          // 1    Acknowledge PIE interrupt group 2
   Uint16 ACK3:1;          // 2    Acknowledge PIE interrupt group 3
   Uint16 ACK4:1;          // 3    Acknowledge PIE interrupt group 4
   Uint16 ACK5:1;          // 4    Acknowledge PIE interrupt group 5
   Uint16 ACK6:1;          // 5    Acknowledge PIE interrupt group 6
   Uint16 ACK7:1;          // 6    Acknowledge PIE interrupt group 7
   Uint16 ACK8:1;          // 7    Acknowledge PIE interrupt group 8
   Uint16 ACK9:1;          // 8    Acknowledge PIE interrupt group 9
   Uint16 ACK10:1;         // 9    Acknowledge PIE interrupt group 10
   Uint16 ACK11:1;         // 10   Acknowledge PIE interrupt group 11
   Uint16 ACK12:1;         // 11   Acknowledge PIE interrupt group 12
   Uint16 rsvd:4;          // 15:12 reserved
};

union PIEACK_REG {
   Uint16              all;
   struct PIEACK_BITS  bit;
};

//---------------------------------------------------------------------------
// PIE Control Register File:
//
struct PIE_CTRL_REGS {
   union PIECTRL_REG PIECTRL;       // PIE control register
   union PIEACK_REG  PIEACK;        // PIE acknowledge
   union PIEIER_REG  PIEIER1;       // PIE INT1 IER register  
   union PIEIFR_REG  PIEIFR1;       // PIE INT1 IFR register
   union PIEIER_REG  PIEIER2;       // PIE INT2 IER register 
   union PIEIFR_REG  PIEIFR2;       // PIE INT2 IFR register
   union PIEIER_REG  PIEIER3;       // PIE INT3 IER register 
   union PIEIFR_REG  PIEIFR3;       // PIE INT3 IFR register
   union PIEIER_REG  PIEIER4;       // PIE INT4 IER register             
   union PIEIFR_REG  PIEIFR4;       // PIE INT4 IFR register
   union PIEIER_REG  PIEIER5;       // PIE INT5 IER register  
   union PIEIFR_REG  PIEIFR5;       // PIE INT5 IFR register
   union PIEIER_REG  PIEIER6;       // PIE INT6 IER register 
   union PIEIFR_REG  PIEIFR6;       // PIE INT6 IFR register
   union PIEIER_REG  PIEIER7;       // PIE INT7 IER register 
   union PIEIFR_REG  PIEIFR7;       // PIE INT7 IFR register
   union PIEIER_REG  PIEIER8;       // PIE INT8 IER register
   union PIEIFR_REG  PIEIFR8;       // PIE INT8 IFR register
   union PIEIER_REG  PIEIER9;       // PIE INT9 IER register  
   union PIEIFR_REG  PIEIFR9;       // PIE INT9 IFR register
   union PIEIER_REG  PIEIER10;      // PIE INT10 IER register 
   union PIEIFR_REG  PIEIFR10;      // PIE INT10 IFR register
   union PIEIER_REG  PIEIER11;      // PIE INT11 IER register 
   union PIEIFR_REG  PIEIFR11;      // PIE INT11 IFR register
   union PIEIER_REG  PIEIER12;      // PIE INT12 IER register
   union PIEIFR_REG  PIEIFR12;      // PIE INT12 IFR register
};     


//---------------------------------------------------------------------------
// PIE Control Registers External References & Function Declarations:
//
extern volatile struct PIE_CTRL_REGS PieCtrlRegs;



//===========================================================================
// End of file.
//===========================================================================
//###########################################################################
//
// FILE:   DSP2803x_PieVect.h
//
// TITLE:  DSP2803x Devices PIE Vector Table Definitions.
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



//---------------------------------------------------------------------------
// PIE Interrupt Vector Table Definition:
//
// Create a user type called PINT (pointer to interrupt):

typedef interrupt void(*PINT)(void);

// Define Vector Table:
struct PIE_VECT_TABLE {

// Reset is never fetched from this table.
// It will always be fetched from 0x3FFFC0 in
// boot ROM

      PINT     PIE1_RESERVED;
      PINT     PIE2_RESERVED;
      PINT     PIE3_RESERVED;
      PINT     PIE4_RESERVED;
      PINT     PIE5_RESERVED;
      PINT     PIE6_RESERVED;
      PINT     PIE7_RESERVED;
      PINT     PIE8_RESERVED;
      PINT     PIE9_RESERVED;
      PINT     PIE10_RESERVED;
      PINT     PIE11_RESERVED;
      PINT     PIE12_RESERVED;
      PINT     PIE13_RESERVED;

// Non-Peripheral Interrupts:
      PINT     TINT1;     // CPU-Timer1
      PINT     TINT2;     // CPU-Timer2
      PINT     DATALOG;   // Datalogging interrupt
      PINT     RTOSINT;   // RTOS interrupt
      PINT     EMUINT;    // Emulation interrupt
      PINT     NMI;       // Non-maskable interrupt
      PINT     ILLEGAL;   // Illegal operation TRAP
      PINT     USER1;     // User Defined trap 1
      PINT     USER2;     // User Defined trap 2
      PINT     USER3;     // User Defined trap 3
      PINT     USER4;     // User Defined trap 4
      PINT     USER5;     // User Defined trap 5
      PINT     USER6;     // User Defined trap 6
      PINT     USER7;     // User Defined trap 7
      PINT     USER8;     // User Defined trap 8
      PINT     USER9;     // User Defined trap 9
      PINT     USER10;    // User Defined trap 10
      PINT     USER11;    // User Defined trap 11
      PINT     USER12;    // User Defined trap 12

// Group 1 PIE Peripheral Vectors:
      PINT     ADCINT1;   // ADC - if Group 10 ADCINT1 is enabled, this must be rsvd1_1
      PINT     ADCINT2;   // ADC - if Group 10 ADCINT2 is enabled, this must be rsvd1_2
      PINT     rsvd1_3;
      PINT     XINT1;
      PINT     XINT2;
      PINT     ADCINT9;   // ADC
      PINT     TINT0;     // Timer 0
      PINT     WAKEINT;   // WD

// Group 2 PIE Peripheral Vectors:
      PINT     EPWM1_TZINT; // EPWM-1
      PINT     EPWM2_TZINT; // EPWM-2
      PINT     EPWM3_TZINT; // EPWM-3
      PINT     EPWM4_TZINT; // EPWM-4
      PINT     EPWM5_TZINT; // EPWM-5
      PINT     EPWM6_TZINT; // EPWM-6
      PINT     EPWM7_TZINT; // EPWM-7
      PINT     rsvd2_8;

// Group 3 PIE Peripheral Vectors:
      PINT     EPWM1_INT;  // EPWM-1
      PINT     EPWM2_INT;  // EPWM-2
      PINT     EPWM3_INT;  // EPWM-3
      PINT     EPWM4_INT;  // EPWM-4
      PINT     EPWM5_INT;  // EPWM-5
      PINT     EPWM6_INT;  // EPWM-6
      PINT     EPWM7_INT;  // EPWM-7
      PINT     rsvd3_8;

// Group 4 PIE Peripheral Vectors:
      PINT     ECAP1_INT; // ECAP-1
      PINT     rsvd4_2;
      PINT     rsvd4_3;
      PINT     rsvd4_4;
      PINT     rsvd4_5;
      PINT     rsvd4_6;
      PINT     HRCAP1_INT; // HRCAP-1
      PINT     HRCAP2_INT; // HRCAP-2

// Group 5 PIE Peripheral Vectors:
      PINT     EQEP1_INT; // EQEP-1
      PINT     rsvd5_2;
      PINT     rsvd5_3;
      PINT     rsvd5_4;
      PINT     rsvd5_5;
      PINT     rsvd5_6;
      PINT     rsvd5_7;
      PINT     rsvd5_8;

// Group 6 PIE Peripheral Vectors:
      PINT     SPIRXINTA; // SPI-A
      PINT     SPITXINTA; // SPI-A
      PINT     SPIRXINTB; // SPI-B
      PINT     SPITXINTB; // SPI-B
      PINT     rsvd6_5;
      PINT     rsvd6_6;
      PINT     rsvd6_7;
      PINT     rsvd6_8;

// Group 7 PIE Peripheral Vectors:
      PINT     rsvd7_1;
      PINT     rsvd7_2;
      PINT     rsvd7_3;
      PINT     rsvd7_4;
      PINT     rsvd7_5;
      PINT     rsvd7_6;
      PINT     rsvd7_7;
      PINT     rsvd7_8;

// Group 8 PIE Peripheral Vectors:
      PINT     I2CINT1A;  // I2C-A
      PINT     I2CINT2A;  // I2C-A
      PINT     rsvd8_3;
      PINT     rsvd8_4;
      PINT     rsvd8_5;
      PINT     rsvd8_6;
      PINT     rsvd8_7;
      PINT     rsvd8_8;

// Group 9 PIE Peripheral Vectors:

      PINT     SCIRXINTA;  // SCI-A
      PINT     SCITXINTA;  // SCI-A
      PINT     LIN0INTA;   // LIN-A
      PINT     LIN1INTA;   // LIN-A
      PINT     ECAN0INTA;  // eCAN-A
      PINT     ECAN1INTA;  // eCAN-A
      PINT     rsvd9_7;
      PINT     rsvd9_8;

// Group 10 PIE Peripheral Vectors:
      PINT     rsvd10_1; // Can be ADCINT1, but must make ADCINT1 in Group 1 space "reserved".
      PINT     rsvd10_2; // Can be ADCINT2, but must make ADCINT2 in Group 1 space "reserved".
      PINT     ADCINT3;  // ADC
      PINT     ADCINT4;  // ADC
      PINT     ADCINT5;  // ADC
      PINT     ADCINT6;  // ADC
      PINT     ADCINT7;  // ADC
      PINT     ADCINT8;  // ADC

// Group 11 PIE Peripheral Vectors:

      PINT     CLA1_INT1;  // CLA
      PINT     CLA1_INT2;  // CLA
      PINT     CLA1_INT3;  // CLA
      PINT     CLA1_INT4;  // CLA
      PINT     CLA1_INT5;  // CLA
      PINT     CLA1_INT6;  // CLA
      PINT     CLA1_INT7;  // CLA
      PINT     CLA1_INT8;  // CLA

// Group 12 PIE Peripheral Vectors:
      PINT     XINT3;
      PINT     rsvd12_2;
      PINT     rsvd12_3;
      PINT     rsvd12_4;
      PINT     rsvd12_5;
      PINT     rsvd12_6;
      PINT     LVF;        // Latched overflow
      PINT     LUF;        // Latched underflow
};

//---------------------------------------------------------------------------
// PIE Interrupt Vector Table External References & Function Declarations:
//
extern struct PIE_VECT_TABLE PieVectTable;



//===========================================================================
// End of file.
//===========================================================================

//###########################################################################
//
// FILE:   DSP2803x_Spi.h
//
// TITLE:  DSP2803x Device SPI Register Definitions.
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



//---------------------------------------------------------------------------
// SPI Individual Register Bit Definitions:
//
// SPI FIFO Transmit register bit    definitions:
struct  SPIFFTX_BITS {       // bit    description
   Uint16 TXFFIL:5;          // 4:0    Interrupt level
   Uint16 TXFFIENA:1;        // 5      Interrupt enable
   Uint16 TXFFINTCLR:1;      // 6      Clear INT flag
   Uint16 TXFFINT:1;         // 7      INT flag
   Uint16 TXFFST:5;          // 12:8   FIFO status
   Uint16 TXFIFO:1;          // 13     FIFO reset
   Uint16 SPIFFENA:1;        // 14     Enhancement enable
   Uint16 SPIRST:1;          // 15     Reset SPI
};

union SPIFFTX_REG {
   Uint16               all;
   struct SPIFFTX_BITS  bit;
};

//--------------------------------------------
// SPI FIFO recieve register bit definitions:
//
//
struct  SPIFFRX_BITS {       // bits   description
   Uint16 RXFFIL:5;          // 4:0    Interrupt level
   Uint16 RXFFIENA:1;        // 5      Interrupt enable
   Uint16 RXFFINTCLR:1;      // 6      Clear INT flag
   Uint16 RXFFINT:1;         // 7      INT flag
   Uint16 RXFFST:5;          // 12:8   FIFO status
   Uint16 RXFIFORESET:1;     // 13     FIFO reset
   Uint16 RXFFOVFCLR:1;      // 14     Clear overflow
   Uint16 RXFFOVF:1;         // 15     FIFO overflow

};

union SPIFFRX_REG {
   Uint16               all;
   struct SPIFFRX_BITS  bit;
};

//--------------------------------------------
// SPI FIFO control register bit definitions:
//
//
struct  SPIFFCT_BITS {       // bits   description
   Uint16 TXDLY:8;           // 7:0    FIFO transmit delay
   Uint16 rsvd:8;            // 15:8   reserved
};

union SPIFFCT_REG {
   Uint16               all;
   struct SPIFFCT_BITS  bit;
};

//---------------------------------------------
// SPI configuration register bit definitions:
//
//
struct  SPICCR_BITS {        // bits   description
   Uint16 SPICHAR:4;         // 3:0    Character length control
   Uint16 SPILBK:1;          // 4      Loop-back enable/disable
   Uint16 rsvd1:1;           // 5      reserved
   Uint16 CLKPOLARITY:1;     // 6      Clock polarity
   Uint16 SPISWRESET:1;      // 7      SPI SW Reset
   Uint16 rsvd2:8;           // 15:8   reserved
};

union SPICCR_REG {
   Uint16              all;
   struct SPICCR_BITS  bit;
};

//-------------------------------------------------
// SPI operation control register bit definitions:
//
//
struct  SPICTL_BITS {        // bits   description
   Uint16 SPIINTENA:1;       // 0      Interrupt enable
   Uint16 TALK:1;            // 1      Master/Slave transmit enable
   Uint16 MASTER_SLAVE:1;    // 2      Network control mode
   Uint16 CLK_PHASE:1;       // 3      Clock phase select
   Uint16 OVERRUNINTENA:1;   // 4      Overrun interrupt enable
   Uint16 rsvd:11;           // 15:5   reserved
};

union SPICTL_REG {
   Uint16              all;
   struct SPICTL_BITS  bit;
};

//--------------------------------------
// SPI status register bit definitions:
//
//
struct  SPISTS_BITS {        // bits   description
   Uint16 rsvd1:5;           // 4:0    reserved
   Uint16 BUFFULL_FLAG:1;    // 5      SPI transmit buffer full flag
   Uint16 INT_FLAG:1;        // 6      SPI interrupt flag
   Uint16 OVERRUN_FLAG:1;    // 7      SPI reciever overrun flag
   Uint16 rsvd2:8;           // 15:8   reserved
};

union SPISTS_REG {
   Uint16              all;
   struct SPISTS_BITS  bit;
};

//------------------------------------------------
// SPI priority control register bit definitions:
//
//
struct  SPIPRI_BITS {        // bits   description
   Uint16 TRIWIRE:1;         // 0      3-wire mode select bit
   Uint16 STEINV:1;          // 1      SPISTE inversion bit
   Uint16 rsvd1:2;           // 3:2    reserved
   Uint16 FREE:1;            // 4      Free emulation mode control
   Uint16 SOFT:1;            // 5      Soft emulation mode control
   Uint16 PRIORITY:1;        // 6      Interrupt priority select
   Uint16 rsvd2:9;           // 15:7   reserved
};

union SPIPRI_REG {
   Uint16              all;
   struct SPIPRI_BITS  bit;
};

//---------------------------------------------------------------------------
// SPI Register File:
//
struct  SPI_REGS {
   union SPICCR_REG     SPICCR;      // Configuration register
   union SPICTL_REG     SPICTL;      // Operation control register
   union SPISTS_REG     SPISTS;      // Status register
   Uint16               rsvd1;       // reserved
   Uint16               SPIBRR;      // Baud Rate
   Uint16               rsvd2;       // reserved
   Uint16               SPIRXEMU;    // Emulation buffer
   Uint16               SPIRXBUF;    // Serial input buffer
   Uint16               SPITXBUF;    // Serial output buffer
   Uint16               SPIDAT;      // Serial data
   union SPIFFTX_REG    SPIFFTX;     // FIFO transmit register
   union SPIFFRX_REG    SPIFFRX;     // FIFO recieve register
   union SPIFFCT_REG    SPIFFCT;     // FIFO control register
   Uint16               rsvd3[2];    // reserved
   union SPIPRI_REG     SPIPRI;      // FIFO Priority control
};

//---------------------------------------------------------------------------
// SPI External References & Function Declarations:
//
extern volatile struct SPI_REGS SpiaRegs;
extern volatile struct SPI_REGS SpibRegs;



//===========================================================================
// End of file.
//===========================================================================

//###########################################################################
//
// FILE:	DSP2803x_Sci.h
//
// TITLE:	DSP2803x Device SCI Register Definitions.
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



//---------------------------------------------------------------------------
// SCI Individual Register Bit Definitions

//----------------------------------------------------------
// SCICCR communication control register bit definitions:
//

struct  SCICCR_BITS {        // bit    description
   Uint16 SCICHAR:3;         // 2:0    Character length control
   Uint16 ADDRIDLE_MODE:1;   // 3      ADDR/IDLE Mode control
   Uint16 LOOPBKENA:1;       // 4      Loop Back enable
   Uint16 PARITYENA:1;       // 5      Parity enable
   Uint16 PARITY:1;          // 6      Even or Odd Parity
   Uint16 STOPBITS:1;        // 7      Number of Stop Bits
   Uint16 rsvd1:8;           // 15:8   reserved
};

union SCICCR_REG {
   Uint16              all;
   struct SCICCR_BITS  bit;
};

//-------------------------------------------
// SCICTL1 control register 1 bit definitions:
//

struct  SCICTL1_BITS {       // bit    description
   Uint16 RXENA:1;           // 0      SCI receiver enable
   Uint16 TXENA:1;           // 1      SCI transmitter enable
   Uint16 SLEEP:1;           // 2      SCI sleep
   Uint16 TXWAKE:1;          // 3      Transmitter wakeup method
   Uint16 rsvd:1;            // 4      reserved
   Uint16 SWRESET:1;         // 5      Software reset
   Uint16 RXERRINTENA:1;     // 6      Recieve interrupt enable
   Uint16 rsvd1:9;           // 15:7   reserved

};

union SCICTL1_REG {
   Uint16               all;
   struct SCICTL1_BITS  bit;
};

//---------------------------------------------
// SCICTL2 control register 2 bit definitions:
//

struct  SCICTL2_BITS {       // bit    description
   Uint16 TXINTENA:1;        // 0      Transmit interrupt enable
   Uint16 RXBKINTENA:1;      // 1      Receiver-buffer break enable
   Uint16 rsvd:4;            // 5:2    reserved
   Uint16 TXEMPTY:1;         // 6      Transmitter empty flag
   Uint16 TXRDY:1;           // 7      Transmitter ready flag
   Uint16 rsvd1:8;           // 15:8   reserved

};

union SCICTL2_REG {
   Uint16               all;
   struct SCICTL2_BITS  bit;
};

//---------------------------------------------------
// SCIRXST Receiver status register bit definitions:
//

struct  SCIRXST_BITS {       // bit    description
   Uint16 rsvd:1;            // 0      reserved
   Uint16 RXWAKE:1;          // 1      Receiver wakeup detect flag
   Uint16 PE:1;              // 2      Parity error flag
   Uint16 OE:1;              // 3      Overrun error flag
   Uint16 FE:1;              // 4      Framing error flag
   Uint16 BRKDT:1;           // 5      Break-detect flag
   Uint16 RXRDY:1;           // 6      Receiver ready flag
   Uint16 RXERROR:1;         // 7      Receiver error flag
   Uint16 rsvd1:8;			 // 15-8   reserved
};

union SCIRXST_REG {
   Uint16               all;
   struct SCIRXST_BITS  bit;
};

//----------------------------------------------------
// SCIRXBUF Receiver Data Buffer with FIFO bit definitions:
//

struct  SCIRXBUF_BITS {      // bits   description
   Uint16 RXDT:8;            // 7:0    Receive word
   Uint16 rsvd:6;            // 13:8   reserved
   Uint16 SCIFFPE:1;         // 14     SCI PE error in FIFO mode
   Uint16 SCIFFFE:1;         // 15     SCI FE error in FIFO mode
};

union SCIRXBUF_REG {
   Uint16                all;
   struct SCIRXBUF_BITS  bit;
};

//--------------------------------------------------
// SCIPRI Priority control register bit definitions:
//
//

struct  SCIPRI_BITS {        // bit    description
   Uint16 rsvd:3;            // 2:0    reserved
   Uint16 FREE:1;            // 3      Free emulation suspend mode
   Uint16 SOFT:1;            // 4      Soft emulation suspend mode
   Uint16 rsvd1:11;          // 15:5    reserved
};

union SCIPRI_REG {
   Uint16              all;
   struct SCIPRI_BITS  bit;
};

//-------------------------------------------------
// SCI FIFO Transmit register bit definitions:
//
//

struct  SCIFFTX_BITS {       // bit    description
   Uint16 TXFFIL:5;          // 4:0    Interrupt level
   Uint16 TXFFIENA:1;        // 5      Interrupt enable
   Uint16 TXFFINTCLR:1;      // 6      Clear INT flag
   Uint16 TXFFINT:1;         // 7      INT flag
   Uint16 TXFFST:5;          // 12:8   FIFO status
   Uint16 TXFIFOXRESET:1;    // 13     FIFO reset
   Uint16 SCIFFENA:1;        // 14     Enhancement enable
   Uint16 SCIRST:1;          // 15     SCI reset rx/tx channels

};

union SCIFFTX_REG {
   Uint16               all;
   struct SCIFFTX_BITS  bit;
};

//------------------------------------------------
// SCI FIFO recieve register bit definitions:
//
//

struct  SCIFFRX_BITS {       // bits   description
   Uint16 RXFFIL:5;          // 4:0    Interrupt level
   Uint16 RXFFIENA:1;        // 5      Interrupt enable
   Uint16 RXFFINTCLR:1;      // 6      Clear INT flag
   Uint16 RXFFINT:1;         // 7      INT flag
   Uint16 RXFFST:5;          // 12:8   FIFO status
   Uint16 RXFIFORESET:1;     // 13     FIFO reset
   Uint16 RXFFOVRCLR:1;      // 14     Clear overflow
   Uint16 RXFFOVF:1;         // 15     FIFO overflow

};

union SCIFFRX_REG {
   Uint16               all;
   struct SCIFFRX_BITS  bit;
};

// SCI FIFO control register bit definitions:
struct  SCIFFCT_BITS {     // bits   description
   Uint16 FFTXDLY:8;         // 7:0    FIFO transmit delay
   Uint16 rsvd:5;            // 12:8   reserved
   Uint16 CDC:1;             // 13     Auto baud mode enable
   Uint16 ABDCLR:1;          // 14     Auto baud clear
   Uint16 ABD:1;             // 15     Auto baud detect
};

union SCIFFCT_REG {
   Uint16               all;
   struct SCIFFCT_BITS  bit;
};

//---------------------------------------------------------------------------
// SCI Register File:
//
struct  SCI_REGS {
   union SCICCR_REG     SCICCR;     // Communications control register
   union SCICTL1_REG    SCICTL1;    // Control register 1
   Uint16               SCIHBAUD;   // Baud rate (high) register
   Uint16               SCILBAUD;   // Baud rate (low) register
   union SCICTL2_REG    SCICTL2;    // Control register 2
   union SCIRXST_REG    SCIRXST;    // Recieve status register
   Uint16               SCIRXEMU;   // Recieve emulation buffer register
   union SCIRXBUF_REG   SCIRXBUF;   // Recieve data buffer
   Uint16               rsvd1;      // reserved
   Uint16               SCITXBUF;   // Transmit data buffer
   union SCIFFTX_REG    SCIFFTX;    // FIFO transmit register
   union SCIFFRX_REG    SCIFFRX;    // FIFO recieve register
   union SCIFFCT_REG    SCIFFCT;    // FIFO control register
   Uint16               rsvd2;      // reserved
   Uint16               rsvd3;      // reserved
   union SCIPRI_REG     SCIPRI;     // FIFO Priority control
};

//---------------------------------------------------------------------------
// SCI External References & Function Declarations:
//
extern volatile struct SCI_REGS SciaRegs;



//===========================================================================
// End of file.
//===========================================================================

//###########################################################################
//
// FILE:   DSP2803x_SysCtrl.h
//
// TITLE:  DSP2803x Device System Control Register Definitions.
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



//---------------------------------------------------------------------------
// System Control Individual Register Bit Definitions:
//

// XCLKOUT Control
struct XCLK_BITS   {    // bits  description
   Uint16 XCLKOUTDIV:2; // 1:0   XCLKOUT Divide Ratio
   Uint16 rsvd1:4;      // 5:2   reserved
   Uint16 XCLKINSEL:1;  // 6     XCLKIN Source Select
   Uint16 rsvd3:9;      // 15:7  reserved
};

union XCLK_REG {
   Uint16              all;
   struct XCLK_BITS    bit;
};

// PLL Status Register
struct PLLSTS_BITS   {    // bits  description
   Uint16 PLLLOCKS:1;     // 0     PLL lock status
   Uint16 rsvd1:1;        // 1     CLKIN div by 2 -reserved now
   Uint16 PLLOFF:1;       // 2     PLL off bit
   Uint16 MCLKSTS:1;      // 3     Missing clock status bit
   Uint16 MCLKCLR:1;      // 4     Missing clock clear bit
   Uint16 OSCOFF:1;       // 5     Oscillator clock off
   Uint16 MCLKOFF:1;      // 6     Missing clock detect
   Uint16 DIVSEL:2;       // 8:7   DIVSEL
   Uint16 rsvd2:6;        // 14:9  reserved
   Uint16 NORMRDYE:1;     // 15    VREG NORMRDY enable bit
};

union PLLSTS_REG {
   Uint16              all;
   struct PLLSTS_BITS  bit;
};

// Clock Control Register
struct CLKCTL_BITS   {        // bits  description
   Uint16 OSCCLKSRCSEL:1;     // 0     Oscillator clock source select bit
   Uint16 OSCCLKSRC2SEL:1;    // 1     Oscillator 2 clock source select bit
   Uint16 WDCLKSRCSEL:1;      // 2     Watchdog clock source select bit
   Uint16 TMR2CLKSRCSEL:2;    // 4:3   CPU timer 2 clock source select bit
   Uint16 TMR2CLKPRESCALE:3;  // 7:5   CPU timer 2 clock pre-scale value
   Uint16 INTOSC1OFF:1;       // 8     Internal oscillator off bit
   Uint16 INTOSC1HALTI:1;     // 9     Internal oscillator 1 halt mode ignore bit
   Uint16 INTOSC2OFF:1;       // 10    Internal oscillator 2 off bit
   Uint16 INTOSC2HALTI:1;     // 11    Internal oscillator 2 halt mode ignore bit
   Uint16 WDHALTI:1;          // 12    Watchdog halt mode ignore bit
   Uint16 XCLKINOFF:1;        // 13    XCLKIN off bit
   Uint16 XTALOSCOFF:1;       // 14    Crystal (External) oscillator off bit
   Uint16 NMIRESETSEL:1;      // 15    NMI reset select bit
};

union CLKCTL_REG {
   Uint16              all;
   struct CLKCTL_BITS  bit;
};

// Internal Oscillator 1 Trim
struct INTOSC1TRIM_BITS   {    // bits  description
   Uint16 COARSETRIM:8;        // 7:0   8-bit coarse trim value
   Uint16 rsvd1:1;             // 8     reserved
   Uint16 FINETRIM:6;          // 9:14  6-bit fine trim value
   Uint16 rsvd2:1;             // 15    reserved
};

union INTOSC1TRIM_REG {
   Uint16                     all;
   struct INTOSC1TRIM_BITS    bit;
};

// Internal Oscillator 2 Trim
struct INTOSC2TRIM_BITS   {    // bits  description
   Uint16 COARSETRIM:8;        // 7:0   8-bit coarse trim value
   Uint16 rsvd1:1;             // 8     reserved
   Uint16 FINETRIM:6;          // 9:14  6-bit fine trim value
   Uint16 rsvd2:1;             // 15    reserved
};

union INTOSC2TRIM_REG {
   Uint16                     all;
   struct INTOSC2TRIM_BITS    bit;
};

// Low speed peripheral clock register bit definitions:
struct LOSPCP_BITS  {   // bits  description
   Uint16 LSPCLK:3;     // 2:0   Rate relative to SYSCLKOUT
   Uint16 rsvd1:13;     // 15:3  reserved
};

union LOSPCP_REG {
   Uint16              all;
   struct LOSPCP_BITS  bit;
};

// Peripheral clock control register 0 bit definitions:
struct PCLKCR0_BITS  {  // bits  description
   Uint16 HRPWMENCLK:1; // 0     Enable low speed clk to HRPWM
   Uint16 LINAENCLK:1;  // 1     Enable low speed clk to LIN-A
   Uint16 TBCLKSYNC:1;  // 2     ETWPM Module TBCLK enable/sync
   Uint16 ADCENCLK:1;   // 3     Enable high speed clk to ADC
   Uint16 I2CAENCLK:1;  // 4     Enable SYSCLKOUT to I2C-A
   Uint16 rsvd1:3;      // 7:5   reserved
   Uint16 SPIAENCLK:1;  // 8     Enable low speed clk to SPI-A
   Uint16 SPIBENCLK:1;  // 9     Enable low speed clk to SPI-B
   Uint16 SCIAENCLK:1;  // 10    Enable low speed clk to SCI-A
   Uint16 rsvd3:3;      // 13:11 reserved
   Uint16 ECANAENCLK:1; // 14    Enable system clk to eCAN-A
   Uint16 rsvd5:1;      // 15    reserved
};

union PCLKCR0_REG {
   Uint16              all;
   struct PCLKCR0_BITS bit;
};

// Peripheral clock control register 1 bit definitions:
struct PCLKCR1_BITS  {    // bits  description
   Uint16 EPWM1ENCLK:1;   // 0     Enable SYSCLKOUT to EPWM1
   Uint16 EPWM2ENCLK:1;   // 1     Enable SYSCLKOUT to EPWM2
   Uint16 EPWM3ENCLK:1;   // 2     Enable SYSCLKOUT to EPWM3
   Uint16 EPWM4ENCLK:1;   // 3     Enable SYSCLKOUT to EPWM4
   Uint16 EPWM5ENCLK:1;   // 4     Enable SYSCLKOUT to EPWM5
   Uint16 EPWM6ENCLK:1;   // 5     Enable SYSCLKOUT to EPWM6
   Uint16 EPWM7ENCLK:1;   // 6     Enable SYSCLKOUT to EPWM7
   Uint16 rsvd1:1;        // 7     reserved
   Uint16 ECAP1ENCLK:1;   // 8     Enable SYSCLKOUT to ECAP1
   Uint16 rsvd2:5;        // 13:9  reserved
   Uint16 EQEP1ENCLK:1;   // 14    Enable SYSCLKOUT to EQEP1
   Uint16 rsvd3:1;        // 15    reserved
};

union PCLKCR1_REG {
   Uint16              all;
   struct PCLKCR1_BITS bit;
};

// Peripheral clock control register 3 bit definitions:
struct PCLKCR3_BITS  {       // bits  description
   Uint16 COMP1ENCLK:1;      // 0     Enable SYSCLKOUT to COMP1
   Uint16 COMP2ENCLK:1;      // 1     Enable SYSCLKOUT to COMP2
   Uint16 COMP3ENCLK:1;      // 2     Enable SYSCLKOUT to COMP3
   Uint16 rsvd1:5;           // 7:3   reserved
   Uint16 CPUTIMER0ENCLK:1;  // 8     Enable SYSCLKOUT to CPUTIMER0
   Uint16 CPUTIMER1ENCLK:1;  // 9     Enable SYSCLKOUT to CPUTIMER1
   Uint16 CPUTIMER2ENCLK:1;  // 10    Enable SYSCLKOUT to CPTIMER2
   Uint16 rsvd2:3;           // 13:11 reserved
   Uint16 CLA1ENCLK:1;       // 14    Enable SYSCLKOUT to CLA1
   Uint16 rsvd3:1;           // 15    reserved
};

union PCLKCR3_REG {
   Uint16              all;
   struct PCLKCR3_BITS bit;
};

struct PCLKCR2_BITS {       // bits   description
    Uint16 rsvd1:8;
	Uint16 HRCAP1ENCLK:1;
	Uint16 HRCAP2ENCLK:1;
	Uint16 rsvd2:5;
};

union PCLKCR2_REG {
   Uint16              all;
   struct PCLKCR2_BITS bit;
};

// PLL control register bit definitions:
struct PLLCR_BITS {      // bits  description
   Uint16 DIV:4;         // 3:0   Set clock ratio for the PLL
   Uint16 rsvd1:12;      // 15:4  reserved
};

union PLLCR_REG {
   Uint16             all;
   struct PLLCR_BITS  bit;
};

// Low Power Mode 0 control register bit definitions:
struct LPMCR0_BITS {     // bits  description
   Uint16 LPM:2;         // 1:0   Set the low power mode
   Uint16 QUALSTDBY:6;   // 7:2   Qualification
   Uint16 rsvd1:7;       // 14:8  reserved
   Uint16 WDINTE:1;      // 15    Enables WD to wake the device from STANDBY
};

union LPMCR0_REG {
   Uint16              all;
   struct LPMCR0_BITS  bit;
};

//---------------------------------------------------------------------------
// System Control Register File:
//
struct SYS_CTRL_REGS {
   union   XCLK_REG        XCLK;        // 0: XCLKOUT Control
   union   PLLSTS_REG      PLLSTS;      // 1: PLL Status Register
   union   CLKCTL_REG      CLKCTL;      // 2: Clock Control Register
   Uint16                  PLLLOCKPRD;  // 3: PLL Lock Period Register
   union   INTOSC1TRIM_REG INTOSC1TRIM; // 4: Internal Oscillator 1 Trim
   Uint16                  rsvd1;       // 5: reserved
   union   INTOSC2TRIM_REG INTOSC2TRIM; // 6: Internal Oscillator 2 Trim
   Uint16                  rsvd2[2];    // 8-7
   union   PCLKCR2_REG     PCLKCR2;     // 9: Peripheral clock control regsiter 2
   Uint16                  rsvd3;       // 10
   union   LOSPCP_REG      LOSPCP;      // 11: Low-speed peripheral clock pre-scaler
   union   PCLKCR0_REG     PCLKCR0;     // 12: Peripheral clock control register
   union   PCLKCR1_REG     PCLKCR1;     // 13: Peripheral clock control register
   union   LPMCR0_REG      LPMCR0;      // 14: Low-power mode control register 0
   Uint16                  rsvd4;       // 15: reserved
   union   PCLKCR3_REG     PCLKCR3;     // 16: Peripheral clock register
   union   PLLCR_REG       PLLCR;       // 17: PLL control register
   // No bit definitions are defined for SCSR because
   // a read-modify-write instruction can clear the WDOVERRIDE bit
   Uint16                  SCSR;        // 18: System control and status register
   Uint16                  WDCNTR;      // 19: WD counter register
   Uint16                  rsvd5;       // 20
   Uint16                  WDKEY;       // 21: WD reset key register
   Uint16                  rsvd6[3];    // 22-24
   // No bit definitions are defined for WDCR because
   // the proper value must be written to the WDCHK field
   // whenever writing to this register.
   Uint16                  WDCR;        // 25: WD timer control register
   Uint16                  rsvd7[6];    // 26-30
};

//---------------------------------------------------------------------------
// System Power Control Registers:
//

// BOR configuration register bit definitions:
struct BORCFG_BITS {     // bits  description
   Uint16 BORENZ:1;      // 0     BOR enable active low bit
   Uint16 rsvd1:15;      // 15:1  reserved
};

union BORCFG_REG {
   Uint16              all;
   struct BORCFG_BITS  bit;
};

struct SYS_PWR_CTRL_REGS {
    union    BORCFG_REG   BORCFG;       // 0: BOR Configuration Register
    Uint16   rsvd1[2];                  // 1-2
};


/* --------------------------------------------------- */
/* CSM Registers                                       */
/*                                                     */
/* ----------------------------------------------------*/

/* CSM Status & Control register bit definitions */
struct  CSMSCR_BITS {      // bit   description
   Uint16     SECURE:1;    // 0     Secure flag
   Uint16     rsvd1:14;    // 14-1  reserved
   Uint16     FORCESEC:1;  // 15    Force Secure control bit

};

/* Allow access to the bit fields or entire register */
union CSMSCR_REG {
   Uint16             all;
   struct CSMSCR_BITS bit;
};

/* CSM Register File */
struct  CSM_REGS {
   Uint16           KEY0;    // KEY reg bits 15-0
   Uint16           KEY1;    // KEY reg bits 31-16
   Uint16           KEY2;    // KEY reg bits 47-32
   Uint16           KEY3;    // KEY reg bits 63-48
   Uint16           KEY4;    // KEY reg bits 79-64
   Uint16           KEY5;    // KEY reg bits 95-80
   Uint16           KEY6;    // KEY reg bits 111-96
   Uint16           KEY7;    // KEY reg bits 127-112
   Uint16           rsvd1;   // reserved
   Uint16           rsvd2;   // reserved
   Uint16           rsvd3;   // reserved
   Uint16           rsvd4;   // reserved
   Uint16           rsvd5;   // reserved
   Uint16           rsvd6;   // reserved
   Uint16           rsvd7;   // reserved
   union CSMSCR_REG CSMSCR;  // CSM Status & Control register
};

/* Password locations */
struct  CSM_PWL {
   Uint16   PSWD0;  // PSWD bits 15-0
   Uint16   PSWD1;  // PSWD bits 31-16
   Uint16   PSWD2;  // PSWD bits 47-32
   Uint16   PSWD3;  // PSWD bits 63-48
   Uint16   PSWD4;  // PSWD bits 79-64
   Uint16   PSWD5;  // PSWD bits 95-80
   Uint16   PSWD6;  // PSWD bits 111-96
   Uint16   PSWD7;  // PSWD bits 127-112
};

/* Flash Registers */


/* Flash Option Register bit definitions */
struct  FOPT_BITS {       // bit   description
   Uint16     ENPIPE:1;   // 0     Enable Pipeline Mode
   Uint16     rsvd:15;    // 1-15  reserved
};

/* Allow access to the bit fields or entire register */
union FOPT_REG {
   Uint16           all;
   struct FOPT_BITS bit;
};

/* Flash Power Modes Register bit definitions */
struct  FPWR_BITS {       // bit   description
   Uint16     PWR:2;      // 0-1   Power Mode bits
   Uint16     rsvd:14;    // 2-15  reserved
};

/* Allow access to the bit fields or entire register */
union FPWR_REG {
   Uint16           all;
   struct FPWR_BITS bit;
};

/* Flash Status Register bit definitions */
struct  FSTATUS_BITS {       // bit   description
   Uint16     PWRS:2;        // 0-1   Power Mode Status bits
   Uint16     STDBYWAITS:1;  // 2     Bank/Pump Sleep to Standby Wait Counter Status bits
   Uint16     ACTIVEWAITS:1; // 3     Bank/Pump Standby to Active Wait Counter Status bits
   Uint16     rsvd1:4;       // 4-7   reserved
   Uint16     V3STAT:1;      // 8     VDD3V Status Latch bit
   Uint16     rsvd2:7;       // 9-15  reserved
};

/* Allow access to the bit fields or entire register */
union FSTATUS_REG {
   Uint16              all;
   struct FSTATUS_BITS bit;
};

/* Flash Sleep to Standby Wait Counter Register bit definitions */
struct  FSTDBYWAIT_BITS {    // bit   description
   Uint16     STDBYWAIT:9;   // 0-8   Bank/Pump Sleep to Standby Wait Count bits
   Uint16     rsvd:7;        // 9-15  reserved
};

/* Allow access to the bit fields or entire register */
union FSTDBYWAIT_REG {
   Uint16                 all;
   struct FSTDBYWAIT_BITS bit;
};

/* Flash Standby to Active Wait Counter Register bit definitions */
struct  FACTIVEWAIT_BITS {   // bit   description
   Uint16     ACTIVEWAIT:9;  // 0-8   Bank/Pump Standby to Active Wait Count bits
   Uint16     rsvd:7;        // 9-15  reserved
};

/* Allow access to the bit fields or entire register */
union FACTIVEWAIT_REG {
   Uint16                  all;
   struct FACTIVEWAIT_BITS bit;
};

/* Bank Read Access Wait State Register bit definitions */
struct  FBANKWAIT_BITS {     // bit   description
   Uint16     RANDWAIT:4;    // 0-3   Flash Random Read Wait State bits
   Uint16     rsvd1:4;       // 4-7   reserved
   Uint16     PAGEWAIT:4;    // 8-11  Flash Paged Read Wait State bits
   Uint16     rsvd2:4;       // 12-15 reserved
};

/* Allow access to the bit fields or entire register */
union FBANKWAIT_REG {
   Uint16                all;
   struct FBANKWAIT_BITS bit;
};

/* OTP Read Access Wait State Register bit definitions */
struct  FOTPWAIT_BITS {      // bit   description
   Uint16     OTPWAIT:5;     // 0-4   OTP Read Wait State bits
   Uint16     rsvd:11;       // 5-15  reserved
};

/* Allow access to the bit fields or entire register */
union FOTPWAIT_REG {
   Uint16               all;
   struct FOTPWAIT_BITS bit;
};

struct FLASH_REGS {
   union FOPT_REG        FOPT;        // Option Register
   Uint16                rsvd1;       // reserved
   union FPWR_REG        FPWR;        // Power Modes Register
   union FSTATUS_REG     FSTATUS;     // Status Register
   union FSTDBYWAIT_REG  FSTDBYWAIT;  // Pump/Bank Sleep to Standby Wait State Register
   union FACTIVEWAIT_REG FACTIVEWAIT; // Pump/Bank Standby to Active Wait State Register
   union FBANKWAIT_REG   FBANKWAIT;   // Bank Read Access Wait State Register
   union FOTPWAIT_REG    FOTPWAIT;    // OTP Read Access Wait State Register
};

//---------------------------------------------------------------------------
// System Control External References & Function Declarations:
//
extern volatile struct SYS_CTRL_REGS SysCtrlRegs;
extern volatile struct SYS_PWR_CTRL_REGS SysPwrCtrlRegs;
extern volatile struct CSM_REGS CsmRegs;
extern volatile struct CSM_PWL CsmPwl;
extern volatile struct FLASH_REGS FlashRegs;



//===========================================================================
// End of file.
//===========================================================================

//###########################################################################
//
// FILE:  DSP2803x_XIntrupt.h
//
// TITLE: DSP2803x Device External Interrupt Register Definitions.
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



//---------------------------------------------------------------------------

struct XINTCR_BITS {
    Uint16   ENABLE:1;    // 0      enable/disable
    Uint16   rsvd1:1;     // 1      reserved
    Uint16   POLARITY:2;  // 3:2    pos/neg, both triggered
    Uint16   rsvd2:12;    //15:4    reserved
};

union XINTCR_REG {
   Uint16               all;
   struct XINTCR_BITS   bit;
};

//---------------------------------------------------------------------------
// External Interrupt Register File:
//
struct XINTRUPT_REGS {
   union XINTCR_REG XINT1CR;
   union XINTCR_REG XINT2CR;
   union XINTCR_REG XINT3CR;
   Uint16           rsvd1[5];
   Uint16           XINT1CTR;
   Uint16           XINT2CTR;
   Uint16           XINT3CTR;
   Uint16           rsvd[5];
};

//---------------------------------------------------------------------------
// External Interrupt References & Function Declarations:
//
extern volatile struct XINTRUPT_REGS XIntruptRegs;



//===========================================================================
// End of file.
//===========================================================================





// Timer definitions based on System Clock
// 60 MHz devices 



//===========================================================================
// End of file.
//===========================================================================
//###########################################################################
//
// FILE:   DSP2803x_EPwm_defines.h
//
// TITLE:  #defines used in EPwm examples
//
//###########################################################################
// $TI Release: F2803x C/C++ Header Files and Peripheral Examples V126 $
// $Release Date: November 30, 2011 $
//###########################################################################



// TBCTL (Time-Base Control)
//==========================
// CTRMODE bits
// PHSEN bit
// PRDLD bit
// SYNCOSEL bits
// HSPCLKDIV and CLKDIV bits
// PHSDIR bit

// CMPCTL (Compare Control)
//==========================
// LOADAMODE and LOADBMODE bits
// SHDWAMODE and SHDWBMODE bits

// AQCTLA and AQCTLB (Action Qualifier Control)
//=============================================
// ZRO, PRD, CAU, CAD, CBU, CBD bits

// DBCTL (Dead-Band Control)
//==========================
// OUT MODE bits
// POLSEL bits
// IN MODE

// CHPCTL (chopper control)
//==========================
// CHPEN bit
// CHPFREQ bits
// CHPDUTY bits

// TZSEL (Trip Zone Select)
//==========================
// CBCn and OSHTn bits

// TZCTL (Trip Zone Control)
//==========================
// TZA and TZB bits

// TZDCSEL (Trip Zone Digital Compare)
//==========================
// DCAEVT1, DCAEVT2, DCBEVT1, DCBEVT2 bits


// ETSEL (Event Trigger Select)
//=============================

// ETPS (Event Trigger Pre-scale)
//===============================
// INTPRD, SOCAPRD, SOCBPRD bits

//--------------------------------
// HRPWM (High Resolution PWM)
//================================
// HRCNFG



//--------------------------------
// DC (Digital Compare)
//================================
// DCTRIPSEL
// DCFCTL



//DCACTL/DCBCTL




//===========================================================================
// End of file.
//===========================================================================

// Kit specific header files, 
// define incremnetal build and other defines used by the project
//----------------------------------------------------------------------------------
//	FILE:			{ProjectName}-Settings.h
//
//	Description:    This file contains the definitions for this project
//
//	Type: 			Device Independent
//
//----------------------------------------------------------------------------------
//  Copyright Texas Instruments  2010
//----------------------------------------------------------------------------------
//  Revision History:
//----------------------------------------------------------------------------------
//  Date	  | Description / Status
//----------------------------------------------------------------------------------
// 8 April 2013 - MB
//----------------------------------------------------------------------------------


//**********************************************************************************
//  NOTE: WHEN CHANGING THIS FILE PLEASE REBUILD ALL
//**********************************************************************************

//==================================================================================
// Incremental Build options for System check-out
//==================================================================================
// BUILD 1 	 Open Loop Check the Inverter and the DC-DC Flyback Stage, software test for SPLL
// BUILD 2   Closed Current Loop Inverter with forced/internal sine angle and Closed Current Loop DC-DC Flyback
// BUILD 3   Complete Closed loop operation test
// if BUILD==3 and 2 then
// GRID_CONNECT 0 without the Grid (Resistive load at the inverter output, forced sine angle)
// GRID_CONNECT 1 with the Grid
// MPPT 0 MPPT is off you can use a DC power supply instead of the PV panel, a fixed current will be commanded
// MPPT 1 MPPT is on, connect only a PV panel or a PV panel emulator
		
//==================================================================================
// System Settings
//----------------------------------------------------------------------------------
//Add any system specific setting below










// SPLL Settings
//#define ISR_FREQ_20KHZ


//#define DLOG_SIZE   200


/**
 * ADC trigger-source definitions.
 */



// Library header files

// Solar Lib




//*********** Structure Definition ********//
typedef struct{
	int32 a;
	int32 b;
	int32 c;
	int32 alpha;
	int32 beta;
	int32 sin;
	int32 cos;
	int32 d;
	int32 q;
	int32 z;
}ABC_DQ0_POS_IQ;

//*********** Function Declarations *******//
void ABC_DQ0_POS_IQ_init(ABC_DQ0_POS_IQ *v);
void ABC_DQ0_POS_IQ_FUNC(ABC_DQ0_POS_IQ *v);

//*********** Macro Definition ************//



//*********** Structure Definition ********//
typedef struct{
	int32 a;
	int32 b;
	int32 c;
	int32 alpha;
	int32 beta;
	int32 sin;
	int32 cos;
	int32 d;
	int32 q;
	int32 z;
}ABC_DQ0_NEG_IQ;

//*********** Function Declarations *******//
void ABC_DQ0_NEG_IQ_init(ABC_DQ0_NEG_IQ *v);
void ABC_DQ0_NEG_IQ_FUNC(ABC_DQ0_NEG_IQ *v);

//*********** Macro Definition ***********//



//*********** Structure Definition ********//
typedef struct{
	int32 a;
	int32 b;
	int32 c;
	int32 alpha;
	int32 beta;
	int32 zero;
}CLARKE_IQ;

//*********** Function Declarations *******//
void CLARKE_IQ_init(CLARKE_IQ *v);
void CLARKE_IQ_FUNC(CLARKE_IQ *v);

//*********** Macro Definition ************//



//*********** Structure Definition ********//

// Second order control law using an IIR filter structure with programmable output saturation.
// This macro uses CNTL_2P2Z_IQ structures to store coefficients & internal values.
// The structures should be initialized with the supplied CNTL_2P2Z_IQ_INIT macro.
// Within the structure the Max & Min parameters are the output bounds where as the IMin parameter
// is used for saturating the lower bound while keeping an internal history.  The IMin parameter
// should not be lower than -0.9.

typedef struct {
	// Coefficients
	int32 Coeff_B2;
	int32 Coeff_B1;
	int32 Coeff_B0;
	int32 Coeff_A2;
	int32 Coeff_A1;

	// Output saturation limits
	int32 Max;
	int32 IMin;
	int32 Min;
} CNTL_2P2Z_IQ_COEFFS;

typedef struct {
	int32 Out1;
	int32 Out2;
	// Internal values
	int32 Errn;
	int32 Errn1;
	int32 Errn2;
	// Inputs
	int32 Ref;
	int32 Fdbk;
	// Output values
	int32 Out;
} CNTL_2P2Z_IQ_VARS;

//*********** Function Declarations *******//
void CNTL_2P2Z_IQ_COEFFS_init(CNTL_2P2Z_IQ_COEFFS *v);
void CNTL_2P2Z_IQ_VARS_init(CNTL_2P2Z_IQ_VARS *k);
void CNTL_2P2Z_IQ_FUNC(CNTL_2P2Z_IQ_COEFFS *v, CNTL_2P2Z_IQ_VARS *k);
void CNTL_2P2Z_IQ_ASM(CNTL_2P2Z_IQ_COEFFS *v, CNTL_2P2Z_IQ_VARS *k);

//*********** Macro Definition ***********//



//*********** Structure Definition ********//

// Third order control law using an IIR filter structure with programmable output saturation.
// This macro uses CNTL_3P3Z_IQ structures to store coefficients & internal values.
// The structures should be initialized with the supplied CNTL_3P3Z_IQ_init function.
// Within the structure the Max & Min parameters are the output bounds where as the IMin parameter
// is used for saturating the lower bound while keeping an internal history.  The IMin parameter
// should not be lower than -0.9.

typedef struct {
	// Coefficients
	int32 Coeff_B3;
	int32 Coeff_B2;
	int32 Coeff_B1;
	int32 Coeff_B0;
	int32 Coeff_A3;
	int32 Coeff_A2;
	int32 Coeff_A1;

	// Output saturation limits
	int32 Max;
	int32 IMin;
	int32 Min;
} CNTL_3P3Z_IQ_COEFFS;

typedef struct {
	int32 Out1;
	int32 Out2;
	int32 Out3;
	// Internal values
	int32 Errn;
	int32 Errn1;
	int32 Errn2;
	int32 Errn3;
	// Inputs
	int32 Ref;
	int32 Fdbk;
	// Output values
	int32 Out;
} CNTL_3P3Z_IQ_VARS;

//*********** Function Declarations *******//
void CNTL_3P3Z_IQ_VARS_init(CNTL_3P3Z_IQ_VARS *k);
void CNTL_3P3Z_IQ_COEFFS_init(CNTL_3P3Z_IQ_COEFFS *v);
void CNTL_3P3Z_IQ_FUNC(CNTL_3P3Z_IQ_COEFFS *v, CNTL_3P3Z_IQ_VARS *k);
void CNTL_3P3Z_IQ_ASM(CNTL_3P3Z_IQ_COEFFS *v, CNTL_3P3Z_IQ_VARS *k);

//*********** Macro Definition ***********//



//*********** Structure Definition ********//

// PI control law with programmable output saturation.
// This macro uses CNTL_PI_IQ structures to store coefficients & internal values.
// The structures should be initialized with the supplied CNTL_PI_IQ_INIT macro.
// Within the structure the Max & Min parameters are the output bounds

typedef struct {
	int32 Ref;   			// Input: reference set-point
	int32 Fbk;   			// Input: feedback
	int32 Out;   			// Output: controller output
	int32 Kp;				// Parameter: proportional loop gain
	int32 Ki;			    // Parameter: integral gain
	int32 Umax;				// Parameter: upper saturation limit
	int32 Umin;				// Parameter: lower saturation limit
	int32 up;				// Data: proportional term
	int32 ui;				// Data: integral term
	int32 v1;				// Data: pre-saturated controller output
	int32 i1;				// Data: integrator storage: ui(k-1)
	int32 w1;				// Data: saturation record: [u(k-1) - v(k-1)]
} CNTL_PI_IQ;

//*********** Function Declarations *******//
void CNTL_PI_IQ_init(CNTL_PI_IQ *k);
void CNTL_PI_IQ_FUNC(CNTL_PI_IQ *v);

//*********** Macro Definition ***********//


//*********** Structure Definition ********//
typedef struct{
	int16 *input_ptr;
	int16 *output_ptr;
	int32 prev_value;
	int32 trig_value;
	int16 status;
	int16 pre_scalar;
	int16 skip_count;
	int16 size;
	int16 count;
}DLOG_1CH_IQ;

//*********** Function Declarations *******//
void DLOG_1CH_IQ_init(DLOG_1CH_IQ *v);
void DLOG_1CH_IQ_FUNC(DLOG_1CH_IQ *v);

//*********** Macro Definition ***********//


//*********** Structure Definition ********//
typedef struct{
	int16 *input_ptr1;
	int16 *input_ptr2;
	int16 *input_ptr3;
	int16 *input_ptr4;
	int16 *output_ptr1;
	int16 *output_ptr2;
	int16 *output_ptr3;
	int16 *output_ptr4;
	int16 prev_value;
	int16 trig_value;
	int16 status;
	int16 pre_scalar;
	int16 skip_count;
	int16 size;
	int16 count;
}DLOG_4CH_IQ;

//*********** Function Declarations *******//
void DLOG_4CH_IQ_init(DLOG_4CH_IQ *v);
void DLOG_4CH_IQ_FUNC(DLOG_4CH_IQ *v);

//*********** Macro Definition ***********//

	

//*********** Structure Definition ********//
typedef struct{
	int32 a;
	int32 b;
	int32 c;
	int32 alpha;
	int32 beta;
	int32 sin;
	int32 cos;
	int32 d;
	int32 q;
	int32 z;
}DQ0_ABC_IQ;

//*********** Function Declarations *******//
void DQ0_ABC_IQ_init(DQ0_ABC_IQ *v);
void DQ0_ABC_IQ_FUNC(DQ0_ABC_IQ *v);

//*********** Macro Definition ***********//



//*********** Structure Definition ********//
typedef struct{
	int32 a;
	int32 b;
	int32 c;
	int32 alpha;
	int32 beta;
	int32 zero;
}iCLARKE_IQ;

//*********** Function Declarations *******//
void iCLARKE_IQ_init(iCLARKE_IQ *v);
void iCLARKE_IQ_FUNC(iCLARKE_IQ *v);

//*********** Macro Definition ***********//



//*********** Structure Definition ********//
typedef struct{
	int32 alpha;
	int32 beta;
	int32 zero;
	int32 sin;
	int32 cos;
	int32 d;
	int32 q;
	int32 z;
}iPARK_IQ;

//*********** Function Declarations *******//
void iPARK_IQ_init(iPARK_IQ *v);
void iPARK_IQ_FUNC(iPARK_IQ *v);

//*********** Macro Definition ***********//



//*********** Structure Definition ********//

// Performs exponential moving average calculation.  This macro requires the use of the
// MATH_EMAVG_IQ structure.  The structure should be initialized with the MATH_EMAVG_IQ_INIT
// macro.

typedef struct {
	int32 In;
	int32 Out;
	int32 Multiplier;
} MATH_EMAVG_IQ;

//*********** Function Declarations *******//
void MATH_EMAVG_IQ_init(MATH_EMAVG_IQ *v);
void MATH_EMAVG_IQ_FUNC(MATH_EMAVG_IQ *v);

//*********** Macro Definition ***********//

//*********** Structure Definition ********//
typedef struct{
	int32  Ipv;
	int32  Vpv;
	int32  IpvH;
	int32  IpvL;
	int32  VpvH;
	int32  VpvL;
	int32  MaxI;
	int32  MinI;
	int32  Stepsize;
	int32  ImppOut;
	// internal variables
	int32  Cond;
	int32  IncCond;
	int32  DeltaV;
	int32  DeltaI;
	int32  VpvOld;
	int32  IpvOld;
	int32  StepFirst;
	int16 mppt_enable;
	int16 mppt_first;
} MPPT_INCC_I_IQ;

typedef MPPT_INCC_I_IQ *MPPT_INCC_I_handle;

//*********** Function Declarations *******//
void MPPT_INCC_I_IQ_init(MPPT_INCC_I_IQ *v);
void MPPT_INCC_I_IQ_FUNC(MPPT_INCC_I_IQ *v);

//*********** Macro Definition ***********//



//*********** Structure Definition ********//
typedef struct {
	int32  Ipv;
	int32  Vpv;
	int32  IpvH;
	int32  IpvL;
	int32  VpvH;
	int32  VpvL;
	int32  MaxVolt;
	int32  MinVolt;
	int32  Stepsize;
	int32  VmppOut;
	// internal variables
	int32  Cond;
	int32  IncCond;
	int32  DeltaV;
	int32  DeltaI;
	int32  VpvOld;
	int32  IpvOld;
	int32  StepFirst;
	int16 mppt_enable;
	int16 mppt_first;
} MPPT_INCC_IQ;

typedef MPPT_INCC_IQ *MPPT_INCC_handle;

//*********** Function Declarations *******//
void MPPT_INCC_IQ_init(MPPT_INCC_IQ *v);
void MPPT_INCC_IQ_FUNC(MPPT_INCC_IQ *v);

//*********** Macro Definition ***********//



//*********** Structure Definition ********//
typedef struct {
	int32  Ipv;
	int32  Vpv;
	int32  DeltaPmin;
	int32  MaxVolt;
	int32  MinVolt;
	int32  Stepsize;
	int32  VmppOut;
	int32  DeltaP;
	int32  PanelPower;
	int32  PanelPower_Prev;
	int16 mppt_enable;
	int16 mppt_first;
} MPPT_PNO_IQ;

typedef MPPT_PNO_IQ *MPPT_PNO_handle;

//*********** Function Declarations *******//
void MPPT_PNO_IQ_init(MPPT_PNO_IQ *v);
void MPPT_PNO_IQ_FUNC(MPPT_PNO_IQ *v);

//*********** Macro Definition ***********//



//*********** Structure Definition ********//
typedef struct{
	int32 alpha;
	int32 beta;
	int32 zero;
	int32 sin;
	int32 cos;
	int32 d;
	int32 q;
	int32 z;
}PARK_IQ;

//*********** Function Declarations *******//
void PARK_IQ_init(PARK_IQ *v);
void PARK_IQ_FUNC(PARK_IQ *v);

//*********** Macro Definition ***********//



//*********** Structure Definitions *******//
typedef struct {
	int32  Ref;  		// Input: reference set-point
	int32  Fbk;   		// Input: feedback
	int32  Out;   		// Output: controller output
	int32  c1;   		// Internal: derivative filter coefficient 1
	int32  c2;   		// Internal: derivative filter coefficient 2
} PID_GRANDO_IQ_TERMINALS;
// note: c1 & c2 placed here to keep structure size under 8 words

typedef struct {
	int32  Kr;			// Parameter: reference set-point weighting
	int32  Kp;			// Parameter: proportional loop gain
	int32  Ki;			// Parameter: integral gain
	int32  Kd; 		    // Parameter: derivative gain
	int32  Km; 		    // Parameter: derivative weighting
	int32  Umax;			// Parameter: upper saturation limit
	int32  Umin;			// Parameter: lower saturation limit
} PID_GRANDO_IQ_PARAMETERS;

typedef struct {
	int32  up;			// Data: proportional term
	int32  ui;			// Data: integral term
	int32  ud;			// Data: derivative term
	int32  v1;			// Data: pre-saturated controller output
	int32  i1;			// Data: integrator storage: ui(k-1)
	int32  d1;			// Data: differentiator storage: ud(k-1)
	int32  d2;			// Data: differentiator storage: d2(k-1)
	int32  w1;			// Data: saturation record: [u(k-1) - v(k-1)]
} PID_GRANDO_IQ_DATA;

typedef struct {
	PID_GRANDO_IQ_TERMINALS term;
	PID_GRANDO_IQ_PARAMETERS param;
	PID_GRANDO_IQ_DATA	data;
} PID_GRANDO_IQ_CONTROLLER;

typedef PID_GRANDO_IQ_CONTROLLER	*PID_handle;

//*********** Function Declarations *******//
void PID_GRANDO_IQ_init(PID_GRANDO_IQ_CONTROLLER *v);
void PID_GRANDO_IQ_FUNC(PID_GRANDO_IQ_CONTROLLER *v);

//*********** Macro Definition ***********//


//*********** Structure Definition ********//
typedef struct {
	int32  Freq; 		// Input: Ramp frequency (pu)
	int32  StepAngleMax;// Parameter: Maximum step angle (pu)
	int32  Angle;		// Variable: Step angle (pu)
	int32  Out;  	 	// Output: Ramp signal (pu)
} RAMPGEN_IQ;

//*********** Function Declarations *******//
void RAMPGEN_IQ_init(RAMPGEN_IQ *v);
void RAMPGEN_IQ_FUNC(RAMPGEN_IQ *v);

//*********** Macro Definition ***********//



//*********** Structure Definition ********//
typedef struct {
	int32 Vin;   			// Input: Sine Signal
	int32 SampleFreq;   	// Input: Signal Sampling Freq
	int32 Threshold;   		// Input: Voltage level corresponding to zero i/p
	int32 Vrms;   			// Output: RMS Value
	int32 Vavg;   			// Output: Average Value
	int32 Vema;   			// Output: Exponential Moving Average Value
	int32 SigFreq;   		// Output: Signal Freq
	Uint16 ZCD;   			// Output: Zero Cross detected
	// internal variables
	int32 Vacc_avg ;
	int32 Vacc_rms ;
	int32 Vacc_ema;
	int32 curr_sample_norm; // normalized value of current sample
	Uint16 prev_sign ;
	Uint16 curr_sign ;
	Uint32 nsamples ;		// samples in half cycle input waveform
	Uint32 nsamplesMin;
	Uint32 nsamplesMax;
	int32 inv_nsamples;
	int32 inv_sqrt_nsamples;
} SINEANALYZER_DIFF_IQ;

//*********** Function Declarations *******//
void SINEANALYZER_DIFF_IQ_init(SINEANALYZER_DIFF_IQ *v);
void SINEANALYZER_DIFF_IQ_FUNC(SINEANALYZER_DIFF_IQ *v);

//*********** Macro Definition ***********//


//*********** Structure Definition ********//
typedef struct {
	int32  Vin;   				// Input: Sine Signal
	int32  SampleFreq;   		// Input: Signal Sampling Freq
	int32  Threshold;   		// Input: Voltage level corresponding to zero i/p
	int32  Vrms;   				// Output: RMS Value
	int32  Vavg;   				// Output: Average Value
	int32  Vema;				// Output: Exponential Moving Average Value
	int32  SigFreq;   			// Output: Signal Freq
	int32  Iin;   				// Input Current Signal
	int32  Irms;   				// Output: RMS Value of current
	int32  Prms;   				// Output: RMS Value of input power
	Uint16 ZCD;   				// Output: Zero Cross detected
	int32  sum_Vacc_avg;		// Internal : running sum for vacc_avg calculation over one sine cycle
	int32  sum_Vacc_rms;      	// Internal : running sum for vacc_rms calculation over one sine cycle
	int32  sum_Vacc_ema;		// Internal : running sum for vacc_ema calculation over one sine cycle
	int32  sum_Iacc_rms;      	// Internal : running sum for Iacc_rms calculation over one sine cycle
	int32  sum_Pacc_rms;      	// Internal : running sum for Pacc_rms calculation over one sine cycle
	int32  curr_vin_norm; 		// Internal: Normalized value of the input voltage
	int32  curr_iin_norm; 		// Internal: Normalized value of the input current
	Uint16 prev_sign;			// Internal: Flag to detect ZCD
	Uint16 curr_sign;         	// Internal: Flag to detect ZCD
	Uint32 nsamples;			// Internal: No of samples in one cycle of the sine wave
	Uint32 nsamplesMin;			// Internal: Lowerbound for no of samples in one sine wave cycle
	Uint32 nsamplesMax;			// Internal: Upperbound for no of samples in one sine wave cycle
	int32  inv_nsamples;		// Internal: 1/( No of samples in one cycle of the sine wave)
	int32  inv_sqrt_nsamples;	// Internal: sqrt(1/( No of samples in one cycle of the sine wave))
	Uint16 slew_power_update; 	// Internal: used to slew update of the power value
	int32  sum_Pacc_mul;		// Internal: used to sum Pac value over multiple sine cycles (100)
} SINEANALYZER_DIFF_wPWR_IQ;

typedef SINEANALYZER_DIFF_wPWR_IQ *SINEANALYZER_DIFF_wPWR_IQ_HANDLE;

//*********** Function Declarations *******//
void SINEANALYZER_DIFF_wPWR_IQ_init(SINEANALYZER_DIFF_wPWR_IQ *v);
void SINEANALYZER_DIFF_wPWR_IQ_FUNC(SINEANALYZER_DIFF_wPWR_IQ *v);

//*********** Macro Definition ***********//




//*********** Structure Definition ********//
typedef struct{
	int32	B2_notch;
	int32	B1_notch;
	int32	B0_notch;
	int32	A2_notch;
	int32	A1_notch;
}SPLL_1ph_IQ_NOTCH_COEFF; 

typedef struct{
	int32	B1_lf;
	int32	B0_lf;
	int32	A1_lf;
}SPLL_1ph_IQ_LPF_COEFF;

typedef struct{
	int32	AC_input;
	int32	theta[2];
	int32	cos[2];
	int32	sin[2];
	int32	wo;
	int32	wn;
	
	SPLL_1ph_IQ_NOTCH_COEFF notch_coeff;
	SPLL_1ph_IQ_LPF_COEFF	lpf_coeff;
		
	int32	Upd[3];
	int32	ynotch[3];
	int32	ylf[2];
	int32	delta_t;
}SPLL_1ph_IQ;

//*********** Function Declarations *******//
void SPLL_1ph_IQ_init(int Grid_freq, long DELTA_T, SPLL_1ph_IQ *spll);
void SPLL_1ph_IQ_notch_coeff_update(float delta_T, float wn,float c2, float c1, SPLL_1ph_IQ *spll_obj);
void SPLL_1ph_IQ_FUNC(SPLL_1ph_IQ *spll1);

//*********** Macro Definition ***********//



//*********** Structure Definition ********//
typedef struct{
	int32	osg_k;
	int32	osg_x;
	int32	osg_y;
	int32	osg_b0;
	int32	osg_b2;
	int32	osg_a1;
	int32	osg_a2;
	int32	osg_qb0;
	int32	osg_qb1;
	int32	osg_qb2;
}SPLL_1ph_SOGI_IQ_OSG_COEFF;

typedef struct{
	int32	B1_lf;
	int32	B0_lf;
	int32	A1_lf;
}SPLL_1ph_SOGI_IQ_LPF_COEFF;

typedef struct{
	int32	u[3];  // Ac Input
	int32   osg_u[3]; 
	int32   osg_qu[3];
	int32   u_Q[2];
	int32   u_D[2];
	int32   ylf[2];
	int32   fo; // output frequency of PLL
	int32   fn; //nominal frequency
	int32	theta[2];
	int32	cos;
	int32	sin;
	int32   delta_T;
	SPLL_1ph_SOGI_IQ_OSG_COEFF osg_coeff;
	SPLL_1ph_SOGI_IQ_LPF_COEFF lpf_coeff;
}SPLL_1ph_SOGI_IQ;

//*********** Function Declarations *******//
void SPLL_1ph_SOGI_IQ_init(int Grid_freq, long DELTA_T, SPLL_1ph_SOGI_IQ *spll);
void SPLL_1ph_SOGI_IQ_coeff_update(float delta_T, float wn, SPLL_1ph_SOGI_IQ *spll);
void SPLL_1ph_SOGI_IQ_FUNC(SPLL_1ph_SOGI_IQ *spll1);

//*********** Macro Definition ***********//




//*********** Structure Definition ********//
typedef struct{
	int32	B1_lf;
	int32	B0_lf;
	int32	A1_lf;
}SPLL_3ph_SRF_IQ_LPF_COEFF;

typedef struct{
	int32 v_q[2];
	int32 ylf[2];
	int32 fo; // output frequency of PLL
	int32 fn; //nominal frequency
	int32 theta[2];
	int32 delta_T;
	SPLL_3ph_SRF_IQ_LPF_COEFF lpf_coeff;
}SPLL_3ph_SRF_IQ;

//*********** Function Declarations *******//
void SPLL_3ph_SRF_IQ_init(int Grid_freq, long DELTA_T, SPLL_3ph_SRF_IQ *spll);
void SPLL_3ph_SRF_IQ_FUNC(SPLL_3ph_SRF_IQ *spll_obj);

//*********** Macro Definition ***********//



//*********** Structure Definition ********//
typedef struct{
	int32	B1_lf;
	int32	B0_lf;
	int32	A1_lf;
}SPLL_3ph_DDSRF_IQ_LPF_COEFF;

typedef struct{
	int32 d_p;
	int32 d_n;
	int32 q_p;
	int32 q_n;

	int32 d_p_decoupl;
	int32 d_n_decoupl;
	int32 q_p_decoupl;
	int32 q_n_decoupl;

	int32 cos_2theta;
	int32 sin_2theta;

	int32 y[2];
	int32 x[2];
	int32 w[2];
	int32 z[2];
	int32 k1;
	int32 k2;
	int32 d_p_decoupl_lpf;
	int32 d_n_decoupl_lpf;
	int32 q_p_decoupl_lpf;
	int32 q_n_decoupl_lpf;

	int32 v_q[2];
	int32 theta[2];
	int32 ylf[2];
	int32 fo;
	int32 fn;
	int32 delta_T;
	SPLL_3ph_DDSRF_IQ_LPF_COEFF lpf_coeff;
}SPLL_3ph_DDSRF_IQ;

//*********** Function Declarations *******//
void SPLL_3ph_DDSRF_IQ_init(int Grid_freq, long DELTA_T, long k1, long k2, SPLL_3ph_DDSRF_IQ *spll);
void SPLL_3ph_DDSRF_IQ_FUNC(SPLL_3ph_DDSRF_IQ *spll_obj);

//*********** Macro Definition ***********//


/*********** Structure Definitions ***********/
typedef struct{
	_iq24	B2_notch;
	_iq24	B1_notch;
	_iq24	B0_notch;
	_iq24	A2_notch;
	_iq24	A1_notch;
}NOTCH_COEFF_IQ;

typedef struct{
	_iq24	Out1;
	_iq24	Out2;
	_iq24	In;
	_iq24	In1;
	_iq24 	In2;
	_iq24	Out;
}NOTCH_VARS_IQ;

//*********** Function Declarations *******//
void NOTCH_FLTR_IQ_VARS_init(NOTCH_VARS_IQ *v);
void NOTCH_FLTR_IQ_run(NOTCH_VARS_IQ *v,NOTCH_COEFF_IQ *w);
void NOTCH_FLTR_IQ_ASM(NOTCH_VARS_IQ *v,NOTCH_COEFF_IQ *w);
void NOTCH_FLTR_IQ_COEFF_Update(float32 delta_T, float32 wn,float32 c2, float32 c1, NOTCH_COEFF_IQ *notch_obj);

//*********** Macro Definition ***********//




//*********** Macro Definition ***********//





//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// FUNCTION PROTOTYPES
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// Add prototypes of functions being used in the project here

void DeviceInit(void);
void InitFlash();
void MemCopy();

#pragma CODE_SECTION(Inv_ISR,"ramfuncs");
#pragma CODE_SECTION(OneKhzISR,"ramfuncs");
//This is the control loop ISR run at 50Khz
interrupt void Inv_ISR(void);
//This is 1 Khz ISR slaved off CPU timer 2,
interrupt void OneKhzISR();

void InitECapture();

void ADC_SOC_CNF(int ChSel[], int Trigsel[], int ACQPS[], int IntChSel, int mode);

void PWM_1ch_UpDwnCnt_CNF(int16 n, Uint16 period, int16 mode, int16 phase);
void PWM_MicroInvLineClamp_CNF(int n,int period,int deadband_rising,int deadband_falling);

// -------------------------------- FRAMEWORK --------------------------------------
// State Machine function prototypes
//----------------------------------------------------------------------------------
// Alpha states
void A0(void);	//state A0
void B0(void);	//state B0

// A branch states
void A1(void);	//state A1
void A2(void);	//state A2
void A3(void);	//state A3
void A4(void);	//state A4

// B branch states
void B1(void);	//state B1
void B2(void);	//state B2
void B3(void);	//state B3

// Variable declarations
void (*Alpha_State_Ptr)(void);	// Base States pointer
void (*A_Task_Ptr)(void);		// State pointer A branch
void (*B_Task_Ptr)(void);		// State pointer B branch
//----------------------------------------------------------------------------------

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// VARIABLE DECLARATIONS - GENERAL
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// -------------------------------- FRAMEWORK --------------------------------------

int16 VTimer0[4];					// Virtual Timers slaved off CPU Timer 0
int16 VTimer1[4];					// Virtual Timers slaved off CPU Timer 1

// Used for running BackGround in flash, and ISR in RAM
extern Uint32 *RamfuncsLoadStart, *RamfuncsLoadEnd, *RamfuncsRunStart;
extern Uint32 *IQfuncsLoadStart, *IQfuncsLoadEnd, *IQfuncsRunStart;

// Used for ADC Configuration 
int ChSel[16] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
int TrigSel[16] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
int ACQPS[16] = { 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8 };

//---------------------------------------------------------------------------
// Used to indirectly access all EPWM modules
volatile struct EPWM_REGS *ePWM[] = {
		&EPwm1Regs,			//intentional: (ePWM[0] not used)
		&EPwm1Regs, &EPwm2Regs, &EPwm3Regs, &EPwm4Regs, &EPwm5Regs, &EPwm6Regs,
		&EPwm7Regs, };

// Used to indirectly access all Comparator modules
volatile struct COMP_REGS *Comp[] = { &Comp1Regs,//intentional: (Comp[0] not used)
		&Comp1Regs, &Comp2Regs, &Comp3Regs };
// ---------------------------------- USER -----------------------------------------

//-----------------------------Inverter & DC-DC Control Loop Variables -------------
// String to describe the state of the PV Inverter
char cPV_State[40];

// Solar Library Objects

// RAMP to generate forced angle when grid is not present
RAMPGEN_IQ rgen1;

// CNTL 3p3z for inverter current control
#pragma DATA_SECTION(cntl3p3z_InvI_vars,"cntl_var_RAM")
#pragma DATA_SECTION(cntl3p3z_InvI_coeff,"cntl_coeff_RAM")
CNTL_3P3Z_IQ_VARS cntl3p3z_InvI_vars;
CNTL_3P3Z_IQ_COEFFS cntl3p3z_InvI_coeff;

// CNTL 2p2z for flyback current control
#pragma DATA_SECTION(cntl2p2z_DCDCI_vars,"cntl_var_RAM")
#pragma DATA_SECTION(cntl2p2z_DCDCI_coeff,"cntl_coeff_RAM")
CNTL_2P2Z_IQ_VARS cntl2p2z_DCDCI_vars;
CNTL_2P2Z_IQ_COEFFS cntl2p2z_DCDCI_coeff;

// CNTL PI for bus control
CNTL_PI_IQ cntlPI_BusInv;
int16 UpdateCoef;
long Pgain_BusInv, Dgain_BusInv, Igain_BusInv, Dmax_BusInv;

// SPLL Objects of two types for grid angle lock
SPLL_1ph_IQ spll1;
SPLL_1ph_SOGI_IQ spll2;
float c2, c1;
long Phase_Jump, Phase_Jump_Trig;

// Sine analyzer block for RMS Volt, Curr and Power measurements
SINEANALYZER_DIFF_wPWR_IQ sine_mains;

// notch filter objects for filtering bus voltage, pv current and voltage sense signals
#pragma DATA_SECTION(Bus_Volt_notch,"cntl_var_RAM")
#pragma DATA_SECTION(PV_volt_notch,"cntl_var_RAM")
#pragma DATA_SECTION(PV_cur_notch,"cntl_var_RAM")
#pragma DATA_SECTION( notch_TwiceGridFreq,"cntl_coeff_RAM")
NOTCH_COEFF_IQ notch_TwiceGridFreq;
NOTCH_VARS_IQ Bus_Volt_notch,PV_volt_notch,PV_cur_notch;

// MPPT object for flyback current reference selection
MPPT_INCC_I_IQ mppt_incc_I1;
int16 MPPT_slew;
int16 Run_MPPT;
int16 MPPT_ENABLE;

// Datalogger to plot variables

//TODO
// Inverter and Flyback Variables
_iq24 inv_meas_cur_inst, inv_meas_vol_inst, vbus_meas_inst, vbus_meas_avg ;
// reference variable Inverter
_iq24 InvModIndex, inv_Iset, inv_ref_cur_inst, inv_bus_ref;
// Measure Values DC-DC Stage
long pv_meas_cur_inst,pv_meas_vol_inst,pv_meas_cur_avg, pv_meas_vol_avg;
// Reference Values DC-DC Stage
long pv_ref_cur_inst, pv_ref_cur_mppt, pv_ref_cur_fixed;
// Measurement Offsets
_iq24 offset_165, offset_GridCurrent, PV_SenseVolt_Offset, PV_SenseCurr_Offset,DC_Bus_Offset;
//Offset filter coefficient K1: 0.05/(T+0.05);
_iq K1 = (long) ((0.998) * 16777216.0L);
//Offset filter coefficient K2: T/(T+0.05)
_iq K2 = (long) ((0.001999) * 16777216.0L);
int16 OffsetCalCounter;
// Duty variables for flyback and inverter (per unit and compare register values)
_iq24 duty_flyback_pu, duty_inv_pu;
long duty_inv, duty_flyback;
// Duty for which the inverter is not switched around zero
int16 DontSwitchZeroLimit;
// Flags for clearing trips and closing the loops and the Relay
int16 CloseIloopInv, ClearInvTrip,CloseFlybackLoop, ClearFlyBackTrip, RlyConnect;
// Flags for detecting ZCD
_iq24 InvSine, InvSine_prev;
int16 ZCDDetect;
// State Machine Variable
enum PVInverterStates {
	Idle = 0,
	CheckGrid = 1,
	CheckPV = 2,
	MonitorDCBus = 3,
	EnableMPPT = 4,
	PVInverterActive = 5,
	ResetState1 = 6,
	ResetState2 = 7,
	FaultState=8
};
enum PVInverterStates PVInverterState = Idle;
enum PVInverterStates PVInverterState_Old= Idle;
int16 SlewState4;
int32 SlewClrInvTrip;
// Value that is emperically tested to make sure the relay connect happens at ZCD
// This accounts for any delay in the relay connection from the time the GPIO is triggered high
long RlyConnectVal;
// DC Bus voltage values where the state machine is triggered to connect relay,
// start the invetrter and flag faults
volatile long inv_bus_rly_connect, inv_bus_start_volt, inv_bus_UV, inv_bus_OV;
//detecting faults
enum Faults {
	NoFault = 0,
	OverVoltageDCBus = 1,
	UnderVoltageDCBus = 2,
	OverVoltageGrid = 3,
	UnderVoltageGrid = 4,
	OverCurrentFlag = 5
};
enum Faults FaultFlag = NoFault;
int16 BusOverVoltageTrip, BusUnderVoltageTrip,OverCurrent;
Uint16 Gui_InvStart;
Uint16 Gui_InvStop;
// Measuring AC signal
long ACFreq_SysTicks;
volatile float AC_Freq;
volatile _iq24 ACFreq;
_iq24 ACFreq2;
volatile int UF_Flag, OF_Flag, UV_Flag, OV_Flag;
volatile long GRID_MAX_VRMS, GRID_MIN_VRMS;
volatile long GRID_MIN_FREQ, GRID_MAX_FREQ;
int Grid_Freq = 60;
long ECAP_TimerMaxVal;
volatile long inv_emavg_vol;

// Stand Alone Flash Image Instrumentation
// GPIO toggles for different states
int16 LedBlinkCnt1, LedBlinkCnt2;
int16 timer1;

// Display Values 

// Monitor ("Get")						// Display as:
int32 Gui_Vbus;							//Q20
int32 Gui_Vpv;							//Q20
int32 Gui_Ipv;                          //Q20
int32 Gui_GridFreq;						//Q20
int32 Gui_Prms;							//Q6
int32 Gui_Irms;							//Q12
long Gui_Vrms;							//Q6
int32 Gui_Vavg;
int Gui_MPPTEnable;
long IRMS, VRMS, PRMS;
long K_Irms, K_Vrms, K_Prms, K_Vpv, K_Ipv;

// The following declarations are required in order to use the SFO
// library functions:
int MEP_ScaleFactor; // Global variable used by the SFO library
// Result can be used for all HRPWM channels
// This variable is also copied to HRMSTEP
// register by SFO() function.
int status;

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// MAIN CODE - starts here
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
void main(void) {
//=================================================================================
//	INITIALISATION - General
//=================================================================================

	// The DeviceInit() configures the clocks and pin mux registers 
	// The function is declared in {ProjectName}-DevInit_F2803/2x.c,
	// Please ensure/edit that all the desired components pin muxes 
	// are configured properly that clocks for the peripherals used
	// are enabled, for example the individual PWM clock must be enabled 
	// along with the Time Base Clock 

	DeviceInit();	// Device Life support & GPIO

//-------------------------------- FRAMEWORK --------------------------------------

// Only used if running from FLASH
// Note that the variable FLASH is defined by the compiler with -d FLASH

// Copy time critical code and Flash setup code to RAM
// The  RamfuncsLoadStart, RamfuncsLoadEnd, and RamfuncsRunStart
// symbols are created by the linker. Refer to the linker files. 
	MemCopy(&RamfuncsLoadStart, &RamfuncsLoadEnd, &RamfuncsRunStart);
	MemCopy(&IQfuncsLoadStart, &IQfuncsLoadEnd, &IQfuncsRunStart);

// Call Flash Initialization to setup flash waitstates
// This function must reside in RAM
	InitFlash();	// Call the flash wrapper init function

// Timing sync for background loops
// Timer period definitions found in PeripheralHeaderIncludes.h
	CpuTimer0Regs.PRD.all = 300000;		// A tasks
	CpuTimer1Regs.PRD.all = 3000000;	// B tasks
// Configure CPU-Timer 2 to interrupt every second:
// 60MHz CPU Freq, Period (in uSeconds)
// Configure CPU Timer interrupt for 1KHz interrupt
	ConfigCpuTimer(&CpuTimer2, 60, 1000);
	CpuTimer2Regs.TCR.all = 0x4001; // Use write-only instruction to set TSS bit = 0

// Tasks State-machine init
	Alpha_State_Ptr = &A0;
	A_Task_Ptr = &A1;
	B_Task_Ptr = &B1;

	VTimer0[0] = 0;
	VTimer1[0] = 0;

	LedBlinkCnt1 = 5;
	LedBlinkCnt2 = 5;

//==================================================================================
//	INCREMENTAL BUILD OPTIONS - NOTE: selected via {ProjectName-Settings.h
//==================================================================================
// ---------------------------------- USER -----------------------------------------

	//TODO PWM Configuration
	/*************  PWM Configuration **************************/
	SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;   // Disable clocks for EPWM

	// 50Khz at 60Mhz device = > 60*1000/50 =1200,
	PWM_MicroInvLineClamp_CNF(1, (60000000/(50000.0)), 20,
			20);

	// Put DC-DC PWM configuration here
	PWM_1ch_UpDwnCnt_CNF(3, (60000000 / (100000.0)), 0,
			(60000000 / (100000.0 * 2)) - 2);

	// PWM 4 configured only to verify the blanking pulse for over current trips
//	PWM_1ch_UpDwnCnt_CNF(4, (CPU_FREQ / (FLYBACK_FREQ)), 0,
//				(CPU_FREQ / (FLYBACK_FREQ * 2)) - 2);
//
//	EPwm4Regs.TBPHS.half.TBPHS=EPwm4Regs.TBPHS.half.TBPHS-2;
//
//	EPwm4Regs.AQCTLA.bit.CAD=AQ_SET;
//	EPwm4Regs.AQCTLA.bit.CBU=AQ_CLEAR;
//	EPwm4Regs.AQCTLA.bit.CAU=AQ_NO_ACTION;
//
//	EPwm4Regs.CMPA.half.CMPA=0;
//	EPwm4Regs.CMPB=0;

	// Add the dead band configuration for PWM3
	__asm(" EALLOW");
	EPwm3Regs.DBCTL.bit.OUT_MODE = 0x3; /* Rising Delay on 1A & Falling Delay on 1B*/
	EPwm3Regs.DBCTL.bit.POLSEL = 0x2; /* Active high complementary mode (EPWMxA is inverted)*/
	EPwm3Regs.DBCTL.bit.IN_MODE = 0x0; /* 1A for Rising& Falling*/
	EPwm3Regs.DBRED = 3; /* Delay at Rising edge*/
	EPwm3Regs.DBFED = 5; /* Delay at Falling edge*/
	__asm(" EDIS");

	SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;   // Enable TBCLK

	// Calling SFO() updates the HRMSTEP register with calibrated MEP_ScaleFactor.
	// MEP_ScaleFactor/HRMSTEP must be filled with calibrated value in order // for the module to work
	status = 0;
	while (status == 0) { // Call until complete
		status = SFO();
	}
	if (status != 2) { // IF SFO() is complete with no errors
		__asm(" EALLOW");
		EPwm1Regs.HRMSTEP = MEP_ScaleFactor;
		__asm(" EDIS");
	}
	if (status == 2) {
		while (1)
			; // SFO function returns 2 if an error occurs
		// The code would loop here for infinity if it // returns an error
	}

	/************ PWM Configuration END **********************/

	/****************** ADC  Configuration *******************/
	//TODO ADC Configuration


	//Map channel to ADC Pin
	// the dummy reads are to account for first sample issue in Rev 0 silicon
	// Please refer to the Errata and the datasheet, this would be fixed in later versions of the silicon

	// EPWM 3 SOC Signals
	ChSel[0] = 6;		// Dummy read for first
	ChSel[1] = 6;		// A6 - IPV, A2 - IP1 Sen - CT
	ChSel[2] = 11;		// B3 - VPV
	//ChSel[3] = 14;		// B6 - VBOOST in Rev 1 PCB
	ChSel[3] = 4;		// A4 - VBOOST in Rev 2 PCB

	// EPWM 1 SOC Signals
	ChSel[4] = 1;		// A1 - IGRID
	ChSel[5] = 1;		// A1 - IGRID
	ChSel[6] = 9;		// B1 - VGRID
	ChSel[7] = 7;		// A7 - Ref_1.65V
	ChSel[8] = 5;		// A5 - Ref_0.5V
	ChSel[9] = 8;		// B0 - LEM Current Reference Output
	//ChSel[10] = 0;		// A0 - PLC

	// Select Trigger Event 
	TrigSel[0] = 9;
	TrigSel[1] = 9;
	TrigSel[2] = 9;

	TrigSel[3] = 7;
	TrigSel[4] = 7;
	TrigSel[5] = 7;
	TrigSel[6] = 7;
	TrigSel[7] = 7;
	TrigSel[8] = 7;
	//TrigSel[9]= ADCTRIG_EPWM2_SOCA;
	//TrigSel[10]= ADCTRIG_EPWM2_SOCA;

	// use auto clr ADC int flag mode=2
	// end of conversion of inverter current triggers ADC INT 1
	ADC_SOC_CNF(ChSel, TrigSel, ACQPS, 5, 2);

	// Configure the PWM to issue appropriate Start of Conversion for the ADC
	// DC-DC Flyback
	EPwm3Regs.ETSEL.bit.SOCAEN = 1; /* Enable SOC on A group*/
	EPwm3Regs.ETSEL.bit.SOCASEL = 0x7; /* Select SOC from counter at ctr = 0*/
	EPwm3Regs.ETPS.bit.SOCAPRD = 0x1; /* Generate pulse on 1st even*/
	EPwm3Regs.ETSEL.bit.SOCAEN = 1; /* Enable SOC on A group*/
	EPwm3Regs.CMPB = 12;

	// DC-AC Inverter
	// Note: SOCA is configured by the PWM CNF macro
	// but we ovewirte it to make the adc sampling centered
	EPwm2Regs.ETSEL.bit.SOCAEN = 1;
	EPwm2Regs.ETSEL.bit.SOCASEL = 0x7;
	EPwm2Regs.ETPS.bit.SOCAPRD = 0x1;
	EPwm2Regs.ETSEL.bit.SOCAEN = 1;
	EPwm2Regs.CMPB = 70; // EPWM 2 is phase shifter by 50 i.e. when EPWM1 Ctr is zero then EPWM2 Ctr is 52
						 // The we take 8 cycles to sample + 6 cycles to covert the first dummy
						 // and add half the ADC sample width =? 52+8+6+4

	/************ ADC Configuration END **********************/

	/************ ECAP Init **********************************/
	InitECapture();
	/************ ECAP Init END ******************************/

	/************ Control Variable Initialization ************/
	//TODO Solar Library Module Initialization
	// Initialize the net variables
	//RAMPGEN
	RAMPGEN_IQ_init(&rgen1);
	rgen1.Freq = (long) ((60) * 16777216.0L);
	rgen1.StepAngleMax = (long) ((1.0/50000.0) * 16777216.0L);

	//CNTL3P3Z Inverter Current Loop
	CNTL_3P3Z_IQ_VARS_init(&cntl3p3z_InvI_vars);
	CNTL_3P3Z_IQ_COEFFS_init(&cntl3p3z_InvI_coeff);

	cntl3p3z_InvI_coeff.Coeff_A1 = (long) ((1.584) * 16777216.0L);
	cntl3p3z_InvI_coeff.Coeff_A2 = (long) ((-0.6978) * 16777216.0L);
	cntl3p3z_InvI_coeff.Coeff_A3 = (long) ((0.1137) * 16777216.0L);
	cntl3p3z_InvI_coeff.Coeff_B0 = (long) ((0.2866) * 16777216.0L);
	cntl3p3z_InvI_coeff.Coeff_B1 = (long) ((-0.3173) * 16777216.0L);
	cntl3p3z_InvI_coeff.Coeff_B2 = (long) ((0.3338) * 16777216.0L);
	cntl3p3z_InvI_coeff.Coeff_B3 = (long) ((-0.2616) * 16777216.0L);

	cntl3p3z_InvI_coeff.Max = (long) ((0.95) * 16777216.0L);
	cntl3p3z_InvI_coeff.Min = (long) ((-0.95) * 16777216.0L);

	//CNTL2P2Z Flyback DCDC Current Loop
	CNTL_2P2Z_IQ_VARS_init(&cntl2p2z_DCDCI_vars);
	CNTL_2P2Z_IQ_COEFFS_init(&cntl2p2z_DCDCI_coeff);

	cntl2p2z_DCDCI_coeff.Coeff_A1 = (long) ((1.0) * 16777216.0L);                       // A1 = 1
	cntl2p2z_DCDCI_coeff.Coeff_A2 = 0.0;                              // A2 = 0
	cntl2p2z_DCDCI_coeff.Coeff_B0 = (long) ((0.0917) * 16777216.0L);      			  // B0
	cntl2p2z_DCDCI_coeff.Coeff_B1 = (long) ((-0.07138) * 16777216.0L);                  // B1
	cntl2p2z_DCDCI_coeff.Coeff_B2 = (long) ((0.0) * 16777216.0L);                       // B2
	cntl2p2z_DCDCI_coeff.Max = (long) ((0.8) * 16777216.0L);
	cntl2p2z_DCDCI_coeff.Min = (long) ((0.0) * 16777216.0L);
	cntl2p2z_DCDCI_coeff.IMin = (long) ((-0.05) * 16777216.0L);

	//CNTL PI Inverter Bus Voltage Regulation Loop
	Dmax_BusInv = (long) ((0.80) * 16777216.0L);
	Pgain_BusInv = (long) ((1.0) * 16777216.0L);
	Igain_BusInv = (long) ((0.001) * 16777216.0L);

	CNTL_PI_IQ_init(&cntlPI_BusInv);
	cntlPI_BusInv.Kp = Pgain_BusInv;
	cntlPI_BusInv.Ki = Igain_BusInv;
	cntlPI_BusInv.Umax = Dmax_BusInv;
	cntlPI_BusInv.Umin = (long) ((0.025) * 16777216.0L);

	// MPPT
	MPPT_INCC_I_IQ_init(&mppt_incc_I1);
	mppt_incc_I1.IpvH = (long) ((0.000) * 16777216.0L);
	mppt_incc_I1.IpvL = (long) ((0.000) * 16777216.0L);
	mppt_incc_I1.VpvH = (long) ((0.000) * 16777216.0L);
	mppt_incc_I1.VpvL = (long) ((0.000) * 16777216.0L);
	mppt_incc_I1.MaxI = (long) ((0.5) * 16777216.0L);
	mppt_incc_I1.MinI = (long) ((0.0) * 16777216.0L);
	mppt_incc_I1.Stepsize = (long) ((0.005) * 16777216.0L);
	mppt_incc_I1.mppt_first = 1;
	mppt_incc_I1.mppt_enable = 1;
	mppt_incc_I1.StepFirst = (long) ((0.01) * 16777216.0L);

	// SPLL 1ph Notch Filter Method intialization
	SPLL_1ph_IQ_init(60, (long) (((float)(1.0/50000.0)) * 2097152.0L), &spll1);

	spll1.lpf_coeff.B0_lf = (long) (((166.7618719)) * 2097152.0L);
	spll1.lpf_coeff.B1_lf = (long) (((-166.4785831)) * 2097152.0L);
	spll1.lpf_coeff.A1_lf = (long) (((-1.0)) * 2097152.0L);

	c1 = 0.1;
	c2 = 0.00001;

	SPLL_1ph_IQ_notch_coeff_update(((float) (1.0 / 50000.0)),
			(float) (2 * 3.141592653589 * 60 * 2), (float) c2, (float) c1, &spll1);

	//SPLL 1ph SOGI Method initialization

	SPLL_1ph_SOGI_IQ_init(60, (long) (((float)(1.0/50000.0)) * 8388608.0L), &spll2);
	spll2.lpf_coeff.B0_lf = (long) (((166.7618719)) * 8388608.0L);
	spll2.lpf_coeff.B1_lf = (long) (((-166.4785831)) * 8388608.0L);
	spll2.lpf_coeff.A1_lf = (long) (((-1.0)) * 8388608.0L);
	SPLL_1ph_SOGI_IQ_coeff_update(((float) (1.0 / 50000.0)),
			(float) (2 * 3.141592653589 * 60), &spll2);

	// NOTCH COEFF update for measurement filtering
	NOTCH_FLTR_IQ_VARS_init(&Bus_Volt_notch);
	NOTCH_FLTR_IQ_VARS_init(&PV_volt_notch);
	NOTCH_FLTR_IQ_VARS_init(&PV_cur_notch);
	NOTCH_FLTR_IQ_COEFF_Update(((float)(1.0/50000.0)), (float)(2*3.141592653589*60*2),(float)c2,(float)c1, &notch_TwiceGridFreq);

	//sine analyzer initialization
	SINEANALYZER_DIFF_wPWR_IQ_init(&sine_mains);
	sine_mains.Vin = 0;
	sine_mains.Iin = 0;
	sine_mains.SampleFreq = (long) ((1000.0) * 32768.0L);
	sine_mains.Threshold = (long) ((0.1) * 32768.0L);
	sine_mains.nsamplesMax=1000/46;
	sine_mains.nsamplesMin=1000/64;

	// Initialize DATALOG module

	//Variable initialization
	// inverter measurement
	inv_meas_cur_inst=0;
	inv_meas_vol_inst=0;
	vbus_meas_inst=0;
	vbus_meas_avg=0;
	// reference variable Inverter
	InvModIndex=0;
	inv_Iset=0;
	inv_ref_cur_inst=0;
	inv_bus_ref = (long) ((0.657) * 16777216.0L);
	// Measure Values DC-DC Stage
	pv_meas_cur_inst=0;
	pv_meas_vol_inst=0;
	pv_meas_cur_avg=0;
	pv_meas_vol_avg=0;
	// Reference Values DC-DC Stage
	pv_ref_cur_inst=0;
	pv_ref_cur_mppt=0;
	pv_ref_cur_fixed = (long) ((0.15) * 16777216.0L);
	// Measurement Offsets
	offset_GridCurrent = (long) ((0.553) * 16777216.0L);
	PV_SenseVolt_Offset = (long) ((0.3939) * 16777216.0L);
	PV_SenseCurr_Offset = (long) ((0.03) * 16777216.0L);
	DC_Bus_Offset=(long) ((0.008) * 16777216.0L);
	offset_165=0;
	// Duty variables for flyback and inverter (per unit and compare register values)
	duty_flyback_pu=0;
	duty_inv_pu=0;;
	duty_inv=0;
	duty_flyback=0;
	// Duty for which the inverter is not switched around zero
	DontSwitchZeroLimit = 15;
	// Flags for clearing trips and closing the loops and the Relay
	CloseIloopInv=0;
	ClearInvTrip=0;
	CloseFlybackLoop=0;
	ClearFlyBackTrip=0;
	RlyConnect=0;
	// Flags for detecting ZCD
	InvSine=0;
	InvSine_prev=0;
	ZCDDetect=0;
	PVInverterState = Idle;
	PVInverterState_Old= Idle;
	SlewState4=0;
	SlewClrInvTrip=0;
	// Value that is emperically tested to make sure the relay connect happens at ZCD
	// This accounts for any delay in the relay connection from the time the GPIO is triggered high
	RlyConnectVal = (long) ((0.55) * 16777216.0L);
	// DC Bus voltage values where the state machine is triggered to connect relay,
	// start the invetrter and flag faults
	inv_bus_rly_connect = (long) ((0.598) * 16777216.0L);
	inv_bus_start_volt = (long) ((0.669) * 16777216.0L);
	inv_bus_UV = (long) ((0.526) * 16777216.0L);
	inv_bus_OV = (long) ((0.95) * 16777216.0L);
	FaultFlag = NoFault;
	BusOverVoltageTrip = 0;
	BusUnderVoltageTrip = 0;
	OverCurrent=0;
	Gui_InvStart=0;
	Gui_InvStop=0;
	// Measuring AC signal
	ACFreq_SysTicks=0;
	AC_Freq=0;
	ACFreq=0;
	ACFreq2=0;
	UF_Flag=0;
	OF_Flag=0;
	UV_Flag=0;
	OV_Flag=0;
	GRID_MIN_FREQ = 46;
	GRID_MAX_FREQ = 64;
	GRID_MIN_VRMS = 90;
	GRID_MAX_VRMS = 240;
	Grid_Freq = 60;
	ECAP_TimerMaxVal = (60000000 / 40) >> 1; // Where 40 is the lowest frequency measured by ECAP module
	inv_emavg_vol=0;
	// Gui Variables
	Gui_Vbus=0;
	Gui_Vpv=0;
	Gui_Ipv=0;
	Gui_GridFreq=0;						//Q20
	Gui_Prms=0;							//Q6
	Gui_Irms=0;							//Q12
	Gui_Vrms=0;							//Q6
	Gui_MPPTEnable=1;
	Gui_Vavg=0;

	K_Vrms = 26803;	//K_Vrms=(418/511)*32767 = 26803, //RMS voltage is viewed as a Q6 number
	K_Irms = 28671;	//K_Irms=(7/8)*32767 = 28671, //Current is viewed as a Q12 number
	K_Prms = 187624;//K_Prms=(7*418/511)*32767 = 187624, //Power is viewed as a Q6 number
	K_Vpv = 17732; //K_Vpv=(138/255)*32767= 17732, // Panel Voltage is viewed as Q8
	K_Ipv = 30719;//K_Ipv=(15/16)*32767=30719 // Panel Current is viewed in Q11 number

	UpdateCoef = 0;
	MPPT_ENABLE = 0;
	Run_MPPT = 0;
	MPPT_slew = 0;

	strcpy(cPV_State,"Idle");

	/************ Control Variable Initialization END *********/

	/*********  Protection Mechanisms *****************/
	//TODO Protection Code
	__asm(" EALLOW");
	// Cycle by cycle interrupt for CPU halt trip
	EPwm1Regs.TZSEL.bit.CBC6 = 0x1;
	EPwm2Regs.TZSEL.bit.CBC6 = 0x1;
	EPwm3Regs.TZSEL.bit.CBC6 = 0x1;

	// Adding one shot trip for over-current protection on the inverter TZ2
	EPwm1Regs.TZSEL.bit.OSHT2 = 0x1;
	EPwm2Regs.TZSEL.bit.OSHT2 = 0x1;

	// Adding one shot trip for over current of the flyback stage but avoid the <1% duty condition using blanking

	// First enable the COMP3
	Comp3Regs.COMPCTL.bit.COMPDACEN  =0x1;
	Comp3Regs.COMPCTL.bit.SYNCSEL    =0x0;	// asynchronous version of the COMP signal is passed to the EPWM/GPIO module
	Comp3Regs.COMPCTL.bit.CMPINV     =0x0;	// Output of the comparator is passed directly
	Comp3Regs.COMPCTL.bit.COMPSOURCE =0x0;	// inverting input of the comparator is connected to the internal DAC
	Comp3Regs.DACVAL.bit.DACVAL		 =700;	// set DAC input to peak trip point ~10 Amps, full scale is 15Amps
	AdcRegs.COMPHYSTCTL.bit.COMP1_HYST_DISABLE = 0x1;

	//Select COMP3 as one shot trip
	EPwm3Regs.DCTRIPSEL.bit.DCAHCOMPSEL=0xA ;
	EPwm3Regs.TZDCSEL.bit.DCAEVT1=0x2;
	EPwm3Regs.DCACTL.bit.EVT1SRCSEL = 0x1 ;
	EPwm3Regs.DCACTL.bit.EVT1FRCSYNCSEL=0x1;
	EPwm3Regs.TZSEL.bit.DCAEVT1=0x1;

	//Add blanking to avoid conditions where the over current trip generates <1% duty cycle

	EPwm3Regs.DCFCTL.bit.BLANKE=0x1; // Blanking window is enabled
	EPwm3Regs.DCFCTL.bit.BLANKINV=0x0; // Blanking window is not inverted
	EPwm3Regs.DCFCTL.bit.SRCSEL=0x0; //DCAEVT1
	EPwm3Regs.DCFCTL.bit.PULSESEL=0x0; // apply offset from TBCTR=TBPRD
	EPwm3Regs.DCFOFFSET=59;
	EPwm3Regs.DCFWINDOW=255;

	// What do we want the OST/CBC events to do?
	// TZA events can force EPWMxA
	// TZB events can force EPWMxB

	EPwm1Regs.TZCTL.bit.TZA = 0x2; // EPWMxA will go low
	EPwm1Regs.TZCTL.bit.TZB = 0x2; // EPWMxB will go low

	EPwm2Regs.TZCTL.bit.TZA = 0x2; // EPWMxA will go low
	EPwm2Regs.TZCTL.bit.TZB = 0x2; // EPWMxB will go low

	EPwm3Regs.TZCTL.bit.TZA = 0x2; // EPWMxA will go low
	EPwm3Regs.TZCTL.bit.TZB = 0x2; // EPWMxB will go low

	//clear any spurious trips
	EPwm1Regs.TZCLR.bit.OST = 1;
	EPwm2Regs.TZCLR.bit.OST = 1;
	EPwm3Regs.TZCLR.bit.OST = 1;

	// Force a trip event on all the PWM modules for safety
	EPwm1Regs.TZFRC.bit.OST = 0x1;
	EPwm2Regs.TZFRC.bit.OST = 0x1;
	EPwm3Regs.TZFRC.bit.OST = 0x1;
	__asm(" EDIS");

	/*********  Protection Mechanism END *****************/

	/********* Run Calibration for offset in grid and panel current ******/
//TODO Run Calibration Task
	OffsetCalCounter=0;
	offset_GridCurrent=0;
	PV_SenseCurr_Offset=0;

	while(OffsetCalCounter<5000)
		{
			if(AdcRegs.ADCINTFLG.bit.ADCINT1==1)
			{
			PV_SenseCurr_Offset= __IQmpy(K1,PV_SenseCurr_Offset,24)+__IQmpy(K2,((long) (AdcResult . ADCRESULT1) << (24 - 12)),24);
			offset_GridCurrent=__IQmpy(K1,offset_GridCurrent,24)+__IQmpy(K2,((long) (AdcResult . ADCRESULT5) << (24 - 12)),24);
			OffsetCalCounter++;
			AdcRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;		// Clear ADCINT1 flag
			}
		}

	/*********  INTERRUPTS & ISR INITIALIZATION ***********/
	// (best to run this section after other initialization)
	// Set up C28x Interrupt
	__asm(" EALLOW");
	PieVectTable.ADCINT1 = &Inv_ISR;		// Inverter Control Interrupt
	PieVectTable.TINT2 = &OneKhzISR;		// 1kHz interrupt from CPU timer 2
	PieCtrlRegs.PIEIER1.bit.INTx1 = 1;	// Enable ADCINT1 in PIE group 1

	//ADC interrupt already enabled by ADC SOC Cnf
	IER |= 0x0001;		// Enable CPU INT1 for ADCINT1,ADCINT2,ADCINT9,TripZone
	IER |= 0x2000;					// CPU timer 2 is connected to CPU INT 14
	__asm(" clrc INTM");
	// Enable Global interrupt INTM
	__asm(" clrc DBGM");
	// Enable Global realtime interrupt DBGM
	__asm(" EDIS");

	/************** BACKGROUND ********************/

//--------------------------------- FRAMEWORK -------------------------------------
	for (;;)  //infinite loop
			{
		// State machine entry & exit point
		//===========================================================
		(*Alpha_State_Ptr)();	// jump to an Alpha state (A0,B0,...)
		//===========================================================
	}
} //END MAIN CODE

//=================================================================================
//	STATE-MACHINE SEQUENCING AND SYNCRONIZATION
//=================================================================================

//--------------------------------- FRAMEWORK -------------------------------------
void A0(void) {
	// loop rate synchronizer for A-tasks
	if (CpuTimer0Regs.TCR.bit.TIF == 1) {
		CpuTimer0Regs.TCR.bit.TIF = 1;	// clear flag

		//-----------------------------------------------------------
		(*A_Task_Ptr)();		// jump to an A Task (A1,A2,A3,...)
		//-----------------------------------------------------------

		VTimer0[0]++;			// virtual timer 0, instance 0 (spare)
	}

	Alpha_State_Ptr = &B0;		// Comment out to allow only A tasks
}

void B0(void) {
	// loop rate synchronizer for B-tasks
	if (CpuTimer1Regs.TCR.bit.TIF == 1) {
		CpuTimer1Regs.TCR.bit.TIF = 1;				// clear flag

		//-----------------------------------------------------------
		(*B_Task_Ptr)();		// jump to a B Task (B1,B2,B3,...)
		//-----------------------------------------------------------
		VTimer1[0]++;			// virtual timer 1, instance 0 (spare)
	}

	Alpha_State_Ptr = &A0;		// Allow C state tasks
}

//=================================================================================
//	A - TASKS
//=================================================================================
//--------------------------------------------------------
void A1(void)
//--------------------------------------------------------
{
	if(PVInverterState_Old!=PVInverterState)
	{
		switch(PVInverterState)
		{
		case Idle:	strcpy(cPV_State,"Idle");
				break;
		case CheckGrid:	strcpy(cPV_State,"CheckGrid");
					break;
		case CheckPV:	strcpy(cPV_State,"CheckPV");
					break;
		case MonitorDCBus:	strcpy(cPV_State,"MonitorDCBus");
					break;
		case EnableMPPT:	strcpy(cPV_State,"EnableMPPT");
					break;
		case PVInverterActive:	strcpy(cPV_State,"PVInverterActive");
					break;
		case ResetState1:	strcpy(cPV_State,"ResetState1");
					break;
		case ResetState2:	strcpy(cPV_State,"ResetState2");
					break;
		case FaultState:if(FaultFlag==OverVoltageDCBus)
							strcpy(cPV_State,"FaultState: DC Bus Over Voltage");
						else if (FaultFlag==UnderVoltageDCBus)
							strcpy(cPV_State,"FaultState: DC Bus Under Voltage");
						else if (FaultFlag==OverVoltageGrid)
							strcpy(cPV_State,"FaultState: Over Voltage Grid");
						else if (FaultFlag==UnderVoltageGrid)
							strcpy(cPV_State,"FaultState: Under Voltage Grid");
						else if (FaultFlag==OverCurrentFlag)
							strcpy(cPV_State,"FaultState: Grid Current Over");
						else
							strcpy(cPV_State,"FaultState");
					break;
		}
	}

	PVInverterState_Old=PVInverterState;

	if(PVInverterState==Idle)
		Gui_GridFreq=ACFreq<<16;
	else
		Gui_GridFreq=(long)(spll2.fo)>>3;

	//-------------------
	//the next time CpuTimer0 'counter' reaches Period value go to A2
	A_Task_Ptr = &A2;
	//-------------------
}

//--------------------------------------------------------
void A2(void)  // Connect Disconnect
//-----------------------------------------------------------------
{
	//-------------------
	//the next time CpuTimer0 'counter' reaches Period value go to A1
	A_Task_Ptr = &A3;
	//-------------------
}

//--------------------------------------------------------
void A3(void)
//-----------------------------------------
{

	//-----------------
	//the next time CpuTimer0 'counter' reaches Period value go to A1
	A_Task_Ptr = &A4;
	//-----------------
}

//--------------------------------------------------------
void A4(void)  // Spare
//--------------------------------------------------------
{
	//-----------------
	//the next time CpuTimer0 'counter' reaches Period value go to A1
	A_Task_Ptr = &A1;
	//-----------------
}

//=================================================================================
//	B - TASKS
//=================================================================================
//----------------------------------------
void B1(void)
//----------------------------------------
{
	if (UpdateCoef == 1) {

		UpdateCoef = 0;

		//SPLL_1ph_IQ_notch_coeff_update(((float)(1.0/ISR_FREQUENCY)), (float)(2*PI*GRID_FREQ*2),c2,c1, &spll1);
	}

	//-----------------
	//the next time CpuTimer1 'counter' reaches Period value go to B2
	B_Task_Ptr = &B2;
	//-----------------
}

//----------------------------------------
void B2(void) // Blink LED on the control CArd
//----------------------------------------
{
	// Toggle LD3 on control card to show execution of code
	if (LedBlinkCnt1 == 0) {
		GpioDataRegs.GPBTOGGLE.bit.GPIO34 = 1;//turn on/off LD3 on the controlCARD
		LedBlinkCnt1 = 4;
	} else
		LedBlinkCnt1--;

	//-----------------
	//the next time CpuTimer1 'counter' reaches Period value go to B3
	B_Task_Ptr = &B3;
	//-----------------
}

//----------------------------------------
void B3(void) // State Machine, Enable Disable Loops, User Controls  
//----------------------------------------
{



	//-----------------
	//the next time CpuTimer1 'counter' reaches Period value go to B4
	B_Task_Ptr = &B1;
	//-----------------
}

// ISR for inverter 
interrupt void Inv_ISR() {

/*************************************************/
/************  Inverter Code *********************/
/*************************************************/

//-------------------------------------------------------------------
// Inverter Current and Voltage Measurements
//-------------------------------------------------------------------
	// TODO Inverter ISR
	offset_165 = ((int32) AdcResult . ADCRESULT7) << 12;
	vbus_meas_inst = (((long)AdcResult . ADCRESULT3<<12)-DC_Bus_Offset);
	inv_meas_vol_inst = ((long) (((long) AdcResult . ADCRESULT6 << 12) - offset_165)) << 1;
	inv_meas_cur_inst = (((int32) AdcResult . ADCRESULT5 << 12) - offset_GridCurrent) << 1;

//-----------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------

//-----------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------

	// Run the SPLL and compute the inverter sine value
	spll2.u[0]=(long)inv_meas_vol_inst>>1;// shift from Q24 to Q23
	spll2 . osg_u[0]=__IQmpy(spll2 . osg_coeff . osg_b0,(spll2 . u[0]-spll2 . u[2]),23)+__IQmpy(spll2 . osg_coeff . osg_a1,spll2 . osg_u[1],23)+__IQmpy(spll2 . osg_coeff . osg_a2,spll2 . osg_u[2],23); spll2 . osg_u[2]=spll2 . osg_u[1]; spll2 . osg_u[1]=spll2 . osg_u[0]; spll2 . osg_qu[0]=__IQmpy(spll2 . osg_coeff . osg_qb0,spll2 . u[0],23)+__IQmpy(spll2 . osg_coeff . osg_qb1,spll2 . u[1],23)+__IQmpy(spll2 . osg_coeff . osg_qb2,spll2 . u[2],23)+__IQmpy(spll2 . osg_coeff . osg_a1,spll2 . osg_qu[1],23)+__IQmpy(spll2 . osg_coeff . osg_a2,spll2 . osg_qu[2],23); spll2 . osg_qu[2]=spll2 . osg_qu[1]; spll2 . osg_qu[1]=spll2 . osg_qu[0]; spll2 . u[2]=spll2 . u[1]; spll2 . u[1]=spll2 . u[0]; spll2 . u_Q[0]=__IQmpy(spll2 . cos,spll2 . osg_u[0],23)+__IQmpy(spll2 . sin,spll2 . osg_qu[0],23); spll2 . u_D[0]=__IQmpy(spll2 . cos,spll2 . osg_qu[0],23)-__IQmpy(spll2 . sin,spll2 . osg_u[0],23); spll2 . ylf[0]=spll2 . ylf[1]+__IQmpy(spll2 . lpf_coeff . B0_lf,spll2 . u_Q[0],23)+__IQmpy(spll2 . lpf_coeff . B1_lf,spll2 . u_Q[1],23); spll2 . ylf[1]=spll2 . ylf[0]; spll2 . u_Q[1]=spll2 . u_Q[0]; spll2 . fo=spll2 . fn+spll2 . ylf[0]; spll2 . theta[0]=spll2 . theta[1]+__IQmpy(__IQmpy(spll2 . fo,spll2 . delta_T,23),__IQmpy((long) ((2.0) * 8388608.0L),(long) ((3.1415926) * 8388608.0L),23),23); if(spll2 . theta[0]>__IQmpy((long) ((2.0) * 8388608.0L),(long) ((3.1415926) * 8388608.0L),23)) spll2 . theta[0]=(long) ((0.0) * 8388608.0L); spll2 . theta[1]=spll2 . theta[0]; spll2 . sin=_IQ23sin(spll2 . theta[0]); spll2 . cos=_IQ23cos(spll2 . theta[0]);;

	InvSine=spll2.sin<<1;// shift from Q23 to Q24

	if((InvSine_prev<=(long) ((0.00) * 16777216.0L))&&(InvSine>(long) ((0.00) * 16777216.0L)))
	{
		ZCDDetect=1;

		if(MPPT_slew==0)
		{
			if(MPPT_ENABLE==1)
			{
				Run_MPPT=1;
			}
			MPPT_slew=10;
		}
		else
		MPPT_slew--;
	}
	else
	{
		ZCDDetect=0;
	}

	if((InvSine_prev<=RlyConnectVal)&&(InvSine>RlyConnectVal))
	{
		if(RlyConnect==1)
		{
			RlyConnect=0;
			GpioDataRegs.GPASET.bit.GPIO22=1;
		}
	}
	InvSine_prev=InvSine;

	if ( ClearInvTrip==1 && ZCDDetect==1 )
	{
		__asm(" EALLOW");
		EPwm1Regs.TZCLR.bit.OST=0x1;
		EPwm2Regs.TZCLR.bit.OST=0x1;
		__asm(" EDIS");
		ClearInvTrip=0;
		CloseIloopInv=1;
	}

	if(CloseIloopInv==1)
	{
		cntlPI_BusInv.Ref   =Bus_Volt_notch.Out;
		cntlPI_BusInv.Fbk	=inv_bus_ref;
		cntlPI_BusInv . up = __IQmpy((cntlPI_BusInv . Ref - cntlPI_BusInv . Fbk),cntlPI_BusInv . Kp,24); cntlPI_BusInv . ui = (cntlPI_BusInv . Out == cntlPI_BusInv . v1)?(__IQmpy(cntlPI_BusInv . Ki,cntlPI_BusInv . up,24)+ cntlPI_BusInv . i1) : cntlPI_BusInv . i1; cntlPI_BusInv . i1 = cntlPI_BusInv . ui; cntlPI_BusInv . v1 = (cntlPI_BusInv . up + cntlPI_BusInv . ui); cntlPI_BusInv . Out= __IQsat(cntlPI_BusInv . v1, cntlPI_BusInv . Umax, cntlPI_BusInv . Umin);
		inv_Iset=cntlPI_BusInv.Out;

		inv_ref_cur_inst = __IQmpy(inv_Iset,InvSine,24);
		cntl3p3z_InvI_vars.Ref=inv_ref_cur_inst;
		cntl3p3z_InvI_vars.Fdbk=inv_meas_cur_inst;
		CNTL_3P3Z_IQ_ASM(&cntl3p3z_InvI_coeff,&cntl3p3z_InvI_vars);
		duty_inv_pu=_IQ24div((cntl3p3z_InvI_vars.Out+inv_meas_vol_inst),vbus_meas_inst);
		duty_inv_pu= (duty_inv_pu>(long) ((1.0) * 16777216.0L))?(long) ((1.0) * 16777216.0L):duty_inv_pu;
		duty_inv_pu= (duty_inv_pu<(long) ((-1.0) * 16777216.0L))?(long) ((-1.0) * 16777216.0L):duty_inv_pu;
	}
//--------------------------------------------------------------------------------
// PWM Driver for the inverter
//--------------------------------------------------------------------------------
	duty_inv = __IQmpy((long)((60000000/(50000.0*2))),labs(duty_inv_pu),24);

	if (duty_inv < DontSwitchZeroLimit) {
		if (duty_inv_pu > 0) {
			EPwm1Regs.CMPA.half.CMPA = 0;
			EPwm1Regs.CMPB = 0;
			EPwm2Regs.CMPA.half.CMPA = (60000000/(50000.0*2));
		} else {
			EPwm1Regs.CMPB = 0;
			EPwm1Regs.CMPA.half.CMPA = 0;
			EPwm2Regs.CMPA.half.CMPA = 0;
		}
	} else {
		if (duty_inv_pu > 0) {
			EPwm1Regs.CMPA.half.CMPA = duty_inv;
			EPwm1Regs.CMPB = 0;
			EPwm2Regs.CMPA.half.CMPA = EPwm2Regs.TBPRD;

		} else {
			EPwm1Regs.CMPA.half.CMPA = 0;
			EPwm1Regs.CMPB = duty_inv;
			EPwm2Regs.CMPA.half.CMPA = 0;

		}
	}


/*************************************************/
/************  fly back Code **********************/
/*************************************************/
//TODO Fly Back ISR
//-------------------------------------------------------------------
// PV Current and Voltage
//-------------------------------------------------------------------
	pv_meas_cur_inst = __IQsat((((long)AdcResult . ADCRESULT1<<12)- PV_SenseCurr_Offset), (long) ((1.0) * 16777216.0L), (long) ((0.0) * 16777216.0L));
	//pv_meas_cur_inst=_IQsat((((long)IPV_FB<<12)- ((long)V0_5_REF<<12)),_IQ24(1.0),_IQ24(0.0)); // use this when using CT
	pv_meas_vol_inst = __IQsat((((long)AdcResult . ADCRESULT2<<12)-PV_SenseVolt_Offset), (long) ((1.0) * 16777216.0L), (long) ((0.0) * 16777216.0L));
	pv_meas_cur_inst=(pv_meas_cur_inst>0)?pv_meas_cur_inst:0;

//-----------------------------------------------------------------------------------------

//-----------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------

	if(CloseFlybackLoop==1)
	{
		cntl2p2z_DCDCI_vars.Ref=pv_ref_cur_inst; //cntl2p2z_DCDCV_vars.Out;
		cntl2p2z_DCDCI_vars.Fdbk=pv_meas_cur_inst;
		CNTL_2P2Z_IQ_ASM(&cntl2p2z_DCDCI_coeff,&cntl2p2z_DCDCI_vars);
		// fly back duty value
		duty_flyback_pu=cntl2p2z_DCDCI_vars.Out;
	}


//--------------------------------------------------------------------------------
// PWM Driver for fly back DC-DC
//--------------------------------------------------------------------------------

	duty_flyback =(__IQmpy((int32)((60000000/(100000.0*2)))<<22,(int32)duty_flyback_pu>>2,22))>> 6;

	if (duty_flyback > (long) ((25) * 65536.0L))
		EPwm3Regs.CMPA.all = duty_flyback;
	else
		EPwm3Regs.CMPA.all = 0;

//--------------------------------------------------------------------------------
// Moving Average for MPPT and Notch Filters
//--------------------------------------------------------------------------------
	Bus_Volt_notch.In=vbus_meas_inst;
	NOTCH_FLTR_IQ_ASM(&Bus_Volt_notch,&notch_TwiceGridFreq);

	PV_volt_notch.In=pv_meas_vol_inst;
	NOTCH_FLTR_IQ_ASM(&PV_volt_notch,&notch_TwiceGridFreq);

	PV_cur_notch.In=pv_meas_cur_inst;
	NOTCH_FLTR_IQ_ASM(&PV_cur_notch,&notch_TwiceGridFreq);

	vbus_meas_avg = (__IQmpy((Bus_Volt_notch . Out - vbus_meas_avg),(long) ((0.0005) * 16777216.0L),24) + vbus_meas_avg);;
	pv_meas_cur_avg = (__IQmpy((PV_cur_notch . Out - pv_meas_cur_avg),(long) ((0.0005) * 16777216.0L),24) + pv_meas_cur_avg);;
	pv_meas_cur_avg=(pv_meas_cur_avg>0)?pv_meas_cur_avg:0;
	pv_meas_vol_avg = (__IQmpy((PV_volt_notch . Out - pv_meas_vol_avg),(long) ((0.0005) * 16777216.0L),24) + pv_meas_vol_avg);;
	pv_meas_vol_avg=(pv_meas_vol_avg>0)?pv_meas_vol_avg:0;

// ------------------------------------------------------------------------------
//    Connect inputs of the Datalogger module
// ------------------------------------------------------------------------------


//-------------------------------------------------------------------
//	Acknowledge interrupt
//-------------------------------------------------------------------
	PieCtrlRegs.PIEACK.all = 0x0001;	// Must acknowledge the PIE group
	AdcRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;		// Clear ADCINT1 flag
//-------------------------------------------------------------------

	return;

}



// One KHz ISR
interrupt void OneKhzISR() {

	// Let the inv_ISR interrupt this routine
	__asm(" clrc INTM");

	//TODO State Machine
	// Inverter State ==0 , Idle state, wait for the inverter start command
	// Inverter State ==1 , Check if grid is present
	// Inverter State ==2 , Check if sufficient panel voltage is available
	// Inverter State ==3 , Check if dc bus is enough to feed power into the grid
	// Inverter State ==4 , wait for stop command, Check if dc bus goes into under volatage condition
	// Inverter State ==5 , if stop, trip all PWM's, shut down MPPT and return to state 0, reset all values
	switch(PVInverterState)
	{
		case Idle:
			// Wait for the command to start the inverter
		    if(Gui_InvStart==1)
		    {
		    	PVInverterState=CheckGrid;
		    	Gui_InvStart=0;
		    }
		    break;
		case CheckGrid:
			// once the inverter command is issued check if the grid is present
			// once identified re -initailize the VRMS and FREQ limit for that grid range
			// also modify the PLL coefficients for the grid frequency
			if(OV_Flag==0&&UV_Flag==0&&UF_Flag==0&&OF_Flag==0)
			{
				if(labs((ACFreq-(long) ((50.0) * 16.0L)))<(long) ((3) * 16.0L))
				{
					PVInverterState=CheckPV;
					Grid_Freq=50;
					GRID_MIN_FREQ=Grid_Freq-3;
					GRID_MAX_FREQ=Grid_Freq+3;
					GRID_MIN_VRMS=220-35;
					GRID_MAX_VRMS=220+35;

					// SPLL 1ph Notch Filter Method intialization
					SPLL_1ph_IQ_init(Grid_Freq,(long) (((float)(1.0/50000.0)) * 2097152.0L),&spll1);

					spll1.lpf_coeff.B0_lf=(166.7618719);
					spll1.lpf_coeff.B1_lf=(-166.4785831);
					spll1.lpf_coeff.A1_lf=(-1.0);

					c1=0.1;
					c2=0.00001;

					SPLL_1ph_IQ_notch_coeff_update(((float)(1.0/50000.0)), (float)(2*3.141592653589*Grid_Freq*2),(float)c2,(float)c1, &spll1);

					NOTCH_FLTR_IQ_COEFF_Update(((float)(1.0/50000.0)), (float)(2*3.141592653589*Grid_Freq*2),(float)c2,(float)c1, &notch_TwiceGridFreq);

					//SPLL 1ph SOGI Method initialization

					SPLL_1ph_SOGI_IQ_init(Grid_Freq,(long) (((float)(1.0/50000.0)) * 8388608.0L),&spll2);
					spll2.lpf_coeff.B0_lf=(long) ((166.877556) * 8388608.0L);
					spll2.lpf_coeff.B1_lf=(long) ((-166.322444) * 8388608.0L);
					spll2.lpf_coeff.A1_lf=(long) ((-1.0) * 8388608.0L);
					SPLL_1ph_SOGI_IQ_coeff_update(((float)(1.0/50000.0)),(float)(2*3.141592653589*Grid_Freq),&spll2);

					inv_bus_ref=(long) ((0.9210) * 16777216.0L);
					inv_bus_rly_connect= (long) ((0.8373) * 16777216.0L);
					inv_bus_start_volt=(long) ((0.922) * 16777216.0L);
					inv_bus_UV=(long) ((0.8373) * 16777216.0L);
					inv_bus_OV=(long) ((0.998) * 16777216.0L);
					cntlPI_BusInv.Umin =(long) ((0.015) * 16777216.0L);
					SlewClrInvTrip=10;
				}
				else if(labs((ACFreq-(long) ((60.0) * 16.0L)))<(long) ((3) * 16.0L))
				{
					PVInverterState=CheckPV;
					Grid_Freq=60;
					GRID_MIN_FREQ=Grid_Freq-3;
					GRID_MAX_FREQ=Grid_Freq+3;
					GRID_MIN_VRMS=110-35;
					GRID_MAX_VRMS=110+35;
					// SPLL 1ph Notch Filter Method intialization
					SPLL_1ph_IQ_init(Grid_Freq,(long) (((float)(1.0/50000.0)) * 2097152.0L),&spll1);

					spll1.lpf_coeff.B0_lf=(166.7618719);
					spll1.lpf_coeff.B1_lf=(-166.4785831);
					spll1.lpf_coeff.A1_lf=(-1.0);

					c1=0.1;
					c2=0.00001;

					SPLL_1ph_IQ_notch_coeff_update(((float)(1.0/50000.0)), (float)(2*3.141592653589*Grid_Freq*2),(float)c2,(float)c1, &spll1);
					NOTCH_FLTR_IQ_COEFF_Update(((float)(1.0/50000.0)), (float)(2*3.141592653589*Grid_Freq*2),(float)c2,(float)c1, &notch_TwiceGridFreq);

					//SPLL 1ph SOGI Method initialization

					SPLL_1ph_SOGI_IQ_init(Grid_Freq,(long) (((float)(1.0/50000.0)) * 8388608.0L),&spll2);
					spll2.lpf_coeff.B0_lf=(long) ((166.877556) * 8388608.0L);
					spll2.lpf_coeff.B1_lf=(long) ((-166.322444) * 8388608.0L);
					spll2.lpf_coeff.A1_lf=(long) ((-1.0) * 8388608.0L);
					SPLL_1ph_SOGI_IQ_coeff_update(((float)(1.0/50000.0)),(float)(2*3.141592653589*Grid_Freq),&spll2);

					inv_bus_ref=(long) ((0.657) * 16777216.0L);
					inv_bus_rly_connect= (long) ((0.598) * 16777216.0L);
					inv_bus_start_volt=(long) ((0.669) * 16777216.0L);
					inv_bus_UV=(long) ((0.526) * 16777216.0L);
					inv_bus_OV=(long) ((0.95) * 16777216.0L);
					cntlPI_BusInv.Umin =(long) ((0.025) * 16777216.0L);
					SlewClrInvTrip=10;
				}
			}
			if(Gui_InvStop==1)
			{
				PVInverterState=Idle;
				Gui_InvStop=0;
			}
			break;
		case CheckPV:
			// AC is present, check if PV is present
			if(Gui_InvStop==1)
			{
				PVInverterState=ResetState1; // go to the re-initalization state, this logs any fault conditions as well
				Gui_InvStop=0;
			}
			if(Gui_Vpv>(long) ((15.0) * 128.0L))
			{
				// sufficient PV voltage is present
				// Clear Fly Back Trip and monitor DC BUs
				PVInverterState=MonitorDCBus;
				__asm(" EALLOW");
				EPwm3Regs.TZCLR.bit.OST=0x1;
				CloseFlybackLoop=1;
				__asm(" EDIS");
				pv_ref_cur_inst=(long) ((0.1) * 16777216.0L);
				pv_ref_cur_fixed=(long) ((0.15) * 16777216.0L);
			}
		break;
		case MonitorDCBus:
			// Flyback is pumping current into the DC Bus
			// Monitor the DC Bus Value
			if(UV_Flag==1||OV_Flag==1) //UF_Flag==1||||OF_Flag==1
			{
				Gui_InvStop=1;
			}
			if(vbus_meas_inst>inv_bus_OV) // Check for Over Voltage Condition
			{
				BusOverVoltageTrip=1;
				Gui_InvStop=1;
			}
			if(Gui_InvStop==1)
			{
				PVInverterState=ResetState1; // go to the re-initalization state
				Gui_InvStop=0;
			}
			if(vbus_meas_inst>inv_bus_rly_connect)
			{
				RlyConnect=1;
			}

			// Check if DC Bus is greater than DC_BUS_INV_START_VOLT
			// Also Check if the Relay has been connected
			// As currently the inverter is off this will happen quickly
			if(vbus_meas_inst>inv_bus_start_volt && GpioDataRegs.GPADAT.bit.GPIO22==1)
			{
				SlewClrInvTrip--;
				if(SlewClrInvTrip==0)
				{
					PVInverterState=EnableMPPT;
					// Take inverter out of reset
					ClearInvTrip=1;
				}
			}
			SlewState4=250;
			break;
		case EnableMPPT:
			// Wait Before enabling MPPT
			SlewState4--;
			if(SlewState4==0)
			{
				PVInverterState=PVInverterActive;
				//Enable MPPT
				MPPT_ENABLE=1;
				mppt_incc_I1.mppt_first=1;
				mppt_incc_I1.mppt_enable=1;
			}
			// check for under voltage
			if(vbus_meas_inst<inv_bus_UV)
			{
				BusUnderVoltageTrip=1;
				Gui_InvStop=1;
			}
			// Check for Over Voltage Condition
			if(vbus_meas_inst>inv_bus_OV)
			{
				BusOverVoltageTrip=1;
				Gui_InvStop=1;
			}
			if(UV_Flag==1||OV_Flag==1) //UF_Flag==1||||OF_Flag==1
			{
				Gui_InvStop=1;
			}
			if(Gui_InvStop==1)
			{
				PVInverterState=ResetState1; // go to the re-initalization state
				Gui_InvStop=0;
			}
			break;
		case PVInverterActive:
			//Inverter is Fully Active Now
			// Check for Faults or Stop Command
			if(UV_Flag==1||OV_Flag==1) //||OF_Flag==1UF_Flag==1||
			{
				Gui_InvStop=1;
			}
			// check for under voltage
			if(vbus_meas_inst<inv_bus_UV)
			{
				BusUnderVoltageTrip=1;
				Gui_InvStop=1;
			}
			// Check for Over Voltage Condition
			if(vbus_meas_inst>inv_bus_OV)
			{
				BusOverVoltageTrip=1;
				Gui_InvStop=1;
			}
			if(Gui_InvStop==1)
			{
				PVInverterState=ResetState1; // go to the re-initalization state
				Gui_InvStop=0;
			}
			break;
		case ResetState1:
			/*if(UF_Flag==1)
			 {
			 FaultFlag=1;
			 Gui_InvStop=1;
			 }
			 else if (OF_Flag==1)
			 {
			 FaultFlag=2;
			 Gui_InvStop=1;
			 }
			 */
			if(UV_Flag==1)
			{
				FaultFlag=UnderVoltageGrid;
			}
			else if(OV_Flag==1)
			{
				FaultFlag=OverVoltageGrid;
			}
			else if(BusUnderVoltageTrip==1)
			{
				FaultFlag=UnderVoltageDCBus;
			}
			else if(BusOverVoltageTrip==1)
			{
				FaultFlag=OverVoltageDCBus;
			}
			// Run the reset sequence
			// Fist disable MPPT and set the ref current command to zero
			// This is done to make sure the flyback does not see <10% duty when tripping
			MPPT_ENABLE=0;
			mppt_incc_I1.mppt_first=1;
			mppt_incc_I1.mppt_enable=0;
			pv_ref_cur_inst=(long) ((0.0) * 16777216.0L);
			// zero the buffer values, this makes sure the DC-DC Flyback stage shuts down fast
			//DINT;
			//	CNTL_2P2Z_IQ_C_VAR_INIT(cntl2p2z_DCDCI_vars);
			//EINT;
			duty_flyback=0;
			duty_flyback_pu=0;
			CloseFlybackLoop=0;
			PVInverterState=ResetState2;
			break;
		case ResetState2:
			//Disconnect relay
			GpioDataRegs.GPACLEAR.bit.GPIO22=1;
			// by now the CMPA value should be zero
			if(EPwm3Regs.CMPA.half.CMPA==0)
			{
				// Trip the PWM for the inverter
				// software force the trip of inverter and flyback
				__asm(" EALLOW");
				EPwm1Regs.TZFRC.bit.OST=0x1;
				EPwm2Regs.TZFRC.bit.OST=0x1;
				EPwm3Regs.TZFRC.bit.OST=0x1;
				EPwm1Regs.CMPA.half.CMPA=0;
				EPwm1Regs.CMPB=0;
				EPwm2Regs.CMPA.half.CMPA=0;
				EPwm3Regs.CMPA.half.CMPA=0;
				__asm(" EDIS");
				duty_inv_pu=0;
				duty_inv=0;
				inv_Iset=0;
				CloseIloopInv=0;
					if(FaultFlag==0)
						PVInverterState=Idle;
					else
						PVInverterState=FaultState;
				CNTL_2P2Z_IQ_VARS_init(&cntl2p2z_DCDCI_vars);
				CNTL_3P3Z_IQ_VARS_init(&cntl3p3z_InvI_vars);
				cntlPI_BusInv.up=0;
				cntlPI_BusInv.ui=0;
				cntlPI_BusInv.v1=0;
				cntlPI_BusInv.i1=0;
				cntlPI_BusInv.up=0;
				cntlPI_BusInv.w1=0;
			}
		break;
		default:
		break;
	}

	//TODO AC Measurements
	//---------------------------------------------------------------------
	// Grid Frequency Measurements
	//---------------------------------------------------------------------
	ACFreq_SysTicks = (ECap1Regs.CAP1 + ECap1Regs.CAP2 + ECap1Regs.CAP3
			+ ECap1Regs.CAP4) << 3;
	ACFreq = _IQ4div((long) ((60000000) * 16.0L), ACFreq_SysTicks);

	if (ECap1Regs.TSCTR > ECAP_TimerMaxVal
			|| (ECap1Regs.CAP1 > ECAP_TimerMaxVal)
			|| (ECap1Regs.CAP2 > ECAP_TimerMaxVal)
			|| (ECap1Regs.CAP3 > ECAP_TimerMaxVal)) {
		ACFreq_SysTicks = 0;
		ACFreq = 0;
	}

	if (ACFreq < (long) ((GRID_MIN_FREQ) * 16.0L))
		UF_Flag = 1;
	else
		UF_Flag = 0;

	if (ACFreq > (long) ((GRID_MAX_FREQ) * 16.0L))
		OF_Flag = 1;
	else
		OF_Flag = 0;

	inv_emavg_vol = (__IQmpy(((labs(inv_meas_vol_inst)) - inv_emavg_vol),(long) ((0.0003) * 16777216.0L),24) + inv_emavg_vol);;
	Gui_Vavg = __IQmpy((int32)inv_emavg_vol>>8,(long) ((418) * 65536.0L),16);

	if (Gui_Vavg < (long) ((GRID_MIN_VRMS) * 65536.0L))
		UV_Flag = 1;
	else
		UV_Flag = 0;

	if (Gui_Vavg > (long) ((GRID_MAX_VRMS) * 65536.0L))
		OV_Flag = 1;
	else
		OV_Flag = 0;

	if (UF_Flag == 0 && Gui_Vavg > (long) ((40.0) * 65536.0L)) {
		//Calculate RMS input voltage and input frequency
		sine_mains.Iin = inv_meas_cur_inst >> 9;
		sine_mains.Vin = inv_meas_vol_inst >> 9;
		if ( sine_mains . Vin > sine_mains . Threshold) { sine_mains . curr_vin_norm = sine_mains . Vin; sine_mains . curr_iin_norm = sine_mains . Iin; sine_mains . curr_sign = 1; } else { sine_mains . curr_vin_norm = labs(sine_mains . Vin); sine_mains . curr_iin_norm = labs(sine_mains . Iin); sine_mains . curr_sign = 0; } if((sine_mains . prev_sign != sine_mains . curr_sign) && (sine_mains . curr_sign == 1)) { sine_mains . ZCD=1; sine_mains . inv_nsamples = _IQ15div((long) ((1.0) * 32768.0L), (sine_mains . nsamples<<15)); sine_mains . inv_sqrt_nsamples = _IQ15isqrt(sine_mains . nsamples<<15); if(sine_mains . nsamplesMin < sine_mains . nsamples < sine_mains . nsamplesMax) { sine_mains . Vavg = __IQmpy(sine_mains . sum_Vacc_avg,sine_mains . inv_nsamples,15); sine_mains . Vrms = __IQmpy(_IQ15sqrt(sine_mains . sum_Vacc_rms),sine_mains . inv_sqrt_nsamples,15); sine_mains . Vema = sine_mains . sum_Vacc_ema; sine_mains . Irms = _IQ15rmpy(_IQ15sqrt(sine_mains . sum_Iacc_rms),sine_mains . inv_sqrt_nsamples); sine_mains . slew_power_update ++ ; if(sine_mains . slew_power_update >= 101) { sine_mains . slew_power_update=0; sine_mains . Prms = __IQmpy(sine_mains . sum_Pacc_mul,(long) ((0.01) * 32768.0L),15); sine_mains . sum_Pacc_mul = 0; } else { sine_mains . sum_Pacc_mul = sine_mains . sum_Pacc_mul + _IQ15rmpy(sine_mains . sum_Pacc_rms, sine_mains . inv_nsamples); } } else { sine_mains . Vavg = 0; sine_mains . Vrms = 0; sine_mains . Vema = 0; sine_mains . Irms = 0; sine_mains . Prms = 0; } sine_mains . SigFreq = (__IQmpy(sine_mains . SampleFreq,sine_mains . inv_nsamples,15)>>1); sine_mains . prev_sign = sine_mains . curr_sign; sine_mains . sum_Vacc_avg = 0; sine_mains . sum_Vacc_rms = 0; sine_mains . sum_Vacc_ema = 0; sine_mains . sum_Iacc_rms = 0; sine_mains . sum_Pacc_rms = 0; sine_mains . nsamples=0; } else { sine_mains . nsamples++; sine_mains . sum_Vacc_avg = sine_mains . sum_Vacc_avg+sine_mains . curr_vin_norm; sine_mains . sum_Vacc_rms = sine_mains . sum_Vacc_rms+_IQ15rsmpy(sine_mains . curr_vin_norm,sine_mains . curr_vin_norm); sine_mains . sum_Vacc_ema = sine_mains . sum_Vacc_ema+_IQ15rsmpy((long) ((0.01) * 32768.0L),(sine_mains . curr_vin_norm - sine_mains . sum_Vacc_ema)); sine_mains . sum_Iacc_rms = sine_mains . sum_Iacc_rms+_IQ15rsmpy(sine_mains . curr_iin_norm,sine_mains . curr_iin_norm); sine_mains . sum_Pacc_rms = sine_mains . sum_Pacc_rms+_IQ15rsmpy(sine_mains . curr_iin_norm,sine_mains . curr_vin_norm); sine_mains . ZCD=0; sine_mains . prev_sign = sine_mains . curr_sign; };

		VRMS = (sine_mains.Vrms) << 9;//    Convert sine_mainsV.Vrms from Q15 to Q24 and save as VrectRMS
		IRMS = (sine_mains.Irms) << 9;//    Convert sine_mainsV.Irms from Q15 to Q24 and save as IrectRMS
		PRMS = (sine_mains.Prms) << 9;//    Convert sine_mainsV.Prms from Q15 to Q24 and save as PinRMS

		Gui_Prms = (sine_mains.Prms * K_Prms) >> 15;
		Gui_Irms = (sine_mains.Irms * K_Irms) >> 15;
		Gui_Vrms = (sine_mains.Vrms * K_Vrms) >> 15;

		/*if(Gui_Vrms<_IQ6(GRID_MIN_VRMS))
		 UV_Flag=1;
		 else
		 UV_Flag=0;

		 if(Gui_Vrms>_IQ6(GRID_MAX_VRMS))
		 OV_Flag=1;
		 else
		 OV_Flag=0;
		 */
	} else {
		VRMS = 0;//    Convert sine_mainsV.Vrms from Q15 to Q24 and save as VrectRMS
		IRMS = 0;//    Convert sine_mainsV.Irms from Q15 to Q24 and save as IrectRMS
		PRMS = 0;//    Convert sine_mainsV.Prms from Q15 to Q24 and save as PinRMS

		Gui_Prms = 0;
		Gui_Irms = 0;
		Gui_Vrms = 0;

		SINEANALYZER_DIFF_wPWR_IQ_init(&sine_mains);
		sine_mains.Vin = 0;
		sine_mains.Iin = 0;
		sine_mains.SampleFreq = (long) ((1000.0) * 32768.0L);
		sine_mains.Threshold = (long) ((0.1) * 32768.0L);
		sine_mains.nsamplesMax=1000/46;
		sine_mains.nsamplesMin=1000/64;

	}

	Gui_Vpv = __IQmpy(pv_meas_vol_avg>>4,(long) ((138.0) * 1048576.0L),20);
	Gui_Ipv = __IQmpy(pv_meas_cur_avg>>4,(long) ((15.0) * 1048576.0L),20);
	Gui_Vbus = __IQmpy(vbus_meas_avg>>4,(long) ((418.0) * 1048576.0L),20);

	//Freq_Vin = sine_mainsV.SigFreq;// Q15
	//VrmsReal = _IQ15mpy (KvInv, sine_mainsV.Vrms);

	//Gui_PinRMS = (sine_mainsV.Prms*K_Prms) >> 15;//Q15*Q15 >> 15 = Q15, When no calibration is used

//	if((sine_mainsV.Prms>123)&&(sine_mainsV.Prms <= 858)){	//Max Power used for normalization is 19.8*405.2=8022.96W.//
//										//So 210W = 210/8022.96 *32767 = 858 in Q15 format//
//										// 30W = 30/8022.96 *32767 = 123 in Q15 format//
//			Gui_PinRMS = (((sine_mainsV.Prms*slope_Pcorr) >> 15)- offset_Pcorr);//Q15*Q15 >> 15 = Q15,
//			//apply calibration between 30W and 210W
//		}
//		else{
//			Gui_PinRMS = (sine_mainsV.Prms*K_Prms) >> 15;//Q15*Q15 >> 15 = Q15, apply zero calibration
//		}
//
//
//	Gui_PinRMS_16 = (int16)(Gui_PinRMS);





	//TODO MPPT Task
	if (Run_MPPT == 1) {
		Run_MPPT = 0;

		// MPPT routine
		mppt_incc_I1.Ipv =pv_meas_cur_avg; //IpvRead;
		mppt_incc_I1.Vpv =pv_meas_vol_avg; //VpvRead;

		if (mppt_incc_I1 . mppt_enable==1) { if (mppt_incc_I1 . mppt_first == 1) { mppt_incc_I1 . ImppOut= mppt_incc_I1 . Ipv + mppt_incc_I1 . StepFirst; mppt_incc_I1 . VpvOld=mppt_incc_I1 . Vpv; mppt_incc_I1 . IpvOld=mppt_incc_I1 . Ipv; mppt_incc_I1 . mppt_first=0; } else { mppt_incc_I1 . DeltaV = mppt_incc_I1 . Vpv-mppt_incc_I1 . VpvOld ; mppt_incc_I1 . DeltaI = mppt_incc_I1 . Ipv-mppt_incc_I1 . IpvOld ; if(mppt_incc_I1 . DeltaV >= 0) { if(mppt_incc_I1 . DeltaI !=0 ) { if ( mppt_incc_I1 . DeltaI > 0 ) {mppt_incc_I1 . ImppOut=mppt_incc_I1 . Ipv-mppt_incc_I1 . Stepsize;} else {mppt_incc_I1 . ImppOut=mppt_incc_I1 . Ipv+mppt_incc_I1 . Stepsize;} } } else { mppt_incc_I1 . Cond = _IQ24div(mppt_incc_I1 . Ipv,mppt_incc_I1 . Vpv); mppt_incc_I1 . IncCond = _IQ24div(mppt_incc_I1 . DeltaI,mppt_incc_I1 . DeltaV); if (mppt_incc_I1 . IncCond != mppt_incc_I1 . Cond) { if (mppt_incc_I1 . IncCond > (-mppt_incc_I1 . Cond)) { mppt_incc_I1 . ImppOut=mppt_incc_I1 . Ipv-mppt_incc_I1 . Stepsize; } else { mppt_incc_I1 . ImppOut=mppt_incc_I1 . Ipv+mppt_incc_I1 . Stepsize; } } } mppt_incc_I1 . ImppOut=(mppt_incc_I1 . ImppOut<mppt_incc_I1 . MinI)?mppt_incc_I1 . MinI: mppt_incc_I1 . ImppOut; mppt_incc_I1 . ImppOut=(mppt_incc_I1 . ImppOut>mppt_incc_I1 . MaxI)?mppt_incc_I1 . MaxI: mppt_incc_I1 . ImppOut; mppt_incc_I1 . VpvOld = mppt_incc_I1 . Vpv; mppt_incc_I1 . IpvOld = mppt_incc_I1 . Ipv; } };

		pv_ref_cur_mppt = mppt_incc_I1.ImppOut;

		pv_ref_cur_inst = pv_ref_cur_fixed;

	}

	if (EPwm1Regs.TZFLG.bit.OST == 1 && RlyConnect == 1
			&& PVInverterState >= 4) {
		OverCurrent = 1;
	} else if (EPwm1Regs.TZFLG.bit.OST == 0) {
		OverCurrent = 0;
	}

}

/**********************************************************/
/********************** ECAP INIT *************************/
/**********************************************************/
void InitECapture() {

	ECap1Regs.ECEINT.all = 0x0000;             // Disable all capture interrupts
	ECap1Regs.ECCLR.all = 0xFFFF;              // Clear all CAP interrupt flags
	ECap1Regs.ECCTL1.bit.CAPLDEN = 0;        // Disable CAP1-CAP4 register loads
	ECap1Regs.ECCTL2.bit.TSCTRSTOP = 0;      // Make sure the counter is stopped

	// Configure peripheral registers
	ECap1Regs.ECCTL2.bit.CONT_ONESHT = 0;      // Operation in Continuous Mode
	ECap1Regs.ECCTL2.bit.STOP_WRAP = 3;        // Wrap after 4 events
	ECap1Regs.ECCTL1.bit.CAP1POL = 1;          // Falling edge
	ECap1Regs.ECCTL1.bit.CAP2POL = 0;          // Rising edge
	ECap1Regs.ECCTL1.bit.CAP3POL = 1;          // Falling edge
	ECap1Regs.ECCTL1.bit.CAP4POL = 0;          // Rising edge
	ECap1Regs.ECCTL1.bit.CTRRST1 = 1;          // Difference operation
	ECap1Regs.ECCTL1.bit.CTRRST2 = 1;          // Difference operation
	ECap1Regs.ECCTL1.bit.CTRRST3 = 1;          // Difference operation
	ECap1Regs.ECCTL1.bit.CTRRST4 = 1;          // Difference operation
	ECap1Regs.ECCTL2.bit.SYNCI_EN = 0;         // Enable sync in
	ECap1Regs.ECCTL2.bit.SYNCO_SEL = 0;        // Pass through
	ECap1Regs.ECCTL1.bit.CAPLDEN = 1;          // Enable capture units

	ECap1Regs.ECCTL2.bit.TSCTRSTOP = 1;        // Start Counter
	//ECap1Regs.ECCTL2.bit.REARM = 1;            // arm one-shot
	ECap1Regs.ECCTL1.bit.CAPLDEN = 1;         // Enable CAP1-CAP4 register loads
	// ECap1Regs.ECEINT.bit.CEVT4 = 1;            // 4 events = interrupt

}



