#include <stdint.h>
#include <log.h>
#include <TCFfileTestcfg.h>

#define CHIP_6416 		1			// TMS320C6416

#include <csl.h>
#include <csl_emifa.h>

void initEMIFA(void);
void testTask(void);
//--------------------------------------------------------------------------------------
int main(void)
{
	// Must be done ALLWAYS and ONCE!
	CSL_init();

	initEMIFA();

    TSK_Attrs taskAttrs =
    {
        3, NULL, 1024, NULL, NULL, "testTask", TRUE, TRUE
    };
    TSK_create((Fxn)testTask, &taskAttrs);

	return 0;
}
//--------------------------------------------------------------------------------------
void testTask(void)
{
	LOG_printf(&trace, "It works!!!\n");
}
//--------------------------------------------------------------------------------------
void initEMIFA(void)
{
	EMIFA_Config EmifA;

	EMIFA_getConfig( &EmifA );
	EmifA.gblctl =  0x00012070;
	EmifA.cectl0 =  0xffffffd3;
	EmifA.sdctl  =  0x47116000;		// check 0x47116000
	EmifA.sdtim  =  0x00000750;  	// Optimally 0x00000750 at 120 MHz
	EmifA.sdext  =  0x001faf4d;
	EMIFA_config( &EmifA );
}
//--------------------------------------------------------------------------------------
