#ifndef _PROFILE_H_
#define _PROFILE_H_

#include "glob_type.h"

#define XDC_BIOS
#ifdef XDC_BIOS
#include <xdc/runtime/Types.h>
#include <xdc/runtime/Timestamp.h>
#endif

typedef enum
{
	Smooth_c,
	Smooth_neon
}Func_list;

uint32 *runtime, *start_time;
uint32  ui32_End,result=0;
Types_FreqHz freq;
uint16 ui16_countspus;

#include <time.h>
#ifdef XDC_BIOS

void init_Profile()
{
	runtime = malloc(255*sizeof(uint32));
	memset(runtime, 0, 255*sizeof(uint32));
	start_time = malloc(255*sizeof(uint32));
	memset(start_time, 0, 255*sizeof(uint32));
}

uint32 Start_Profile(int index) {

    Timestamp_getFreq(&freq);
    ui16_countspus        = (uint16)((float32)freq.hi * 4294.967296f + (float32)freq.lo * 0.000001f);
    start_time[index] = Timestamp_get32();
}

uint32 End_Profile(int index) {
    ui32_End = Timestamp_get32();
    result =(ui32_End-start_time[index])/ui16_countspus  ;
    if(result>runtime[index]){
    	runtime[index] = result;
    }

}

void reset_Profile()
{
	free(runtime);
	free(start_time);
}
#endif
#endif
