# 1 "../source/HL_sys_pmu.s"
# 1 "/home/mr_halfword/workspace_v9/TMS570LC4357_GCC_halcogen/Debug//"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "../source/HL_sys_pmu.s"
# 38 "../source/HL_sys_pmu.s"
    .section .text
    .syntax unified
    .cpu cortex-r4
    .arm


@ Initialize Pmu
@ Note: It will reset all counters

    .weak _pmuInit_
    .type _pmuInit_, %function

_pmuInit_:

        @ set control register
        mrc p15, #0, r0, c9, c12, #0
        orr r0, r0, #(1 << 4) + 6 + 1
        mcr p15, #0, r0, c9, c12, #0
        @ clear flags
        mov r0, #0
        sub r0, r0, #1
        mcr p15, #0, r0, c9, c12, #3
        @ select counter 0 event
  mov r0, #0
        mcr p15, #0, r0, c9, c12, #5 @ select counter
        mov r0, #0x11
        mcr p15, #0, r0, c9, c13, #1 @ select event
        @ select counter 1 event
        mov r0, #1
        mcr p15, #0, r0, c9, c12, #5 @ select counter
        mov r0, #0x11
        mcr p15, #0, r0, c9, c13, #1 @ select event
        @ select counter 2 event
        mov r0, #2
        mcr p15, #0, r0, c9, c12, #5 @ select counter
        mov r0, #0x11
        mcr p15, #0, r0, c9, c13, #1 @ select event
        bx lr


@ Enable Counters Global [Cycle, Event [0..2]]
@ Note: It will reset all counters

    .weak _pmuEnableCountersGlobal_
    .type _pmuEnableCountersGlobal_, %function

_pmuEnableCountersGlobal_:

        mrc p15, #0, r0, c9, c12, #0
        orr r0, r0, #7
        mcr p15, #0, r0, c9, c12, #0
        bx lr


@ Disable Counters Global [Cycle, Event [0..2]]

    .weak _pmuDisableCountersGlobal_
    .type _pmuDisableCountersGlobal_, %function

_pmuDisableCountersGlobal_:

        mrc p15, #0, r0, c9, c12, #0
        bic r0, r0, #1
        mcr p15, #0, r0, c9, c12, #0
        bx lr


@ Reset Cycle Counter

    .weak _pmuResetCycleCounter_
    .type _pmuResetCycleCounter_, %function

_pmuResetCycleCounter_:

        mrc p15, #0, r0, c9, c12, #0
        orr r0, r0, #4
        mcr p15, #0, r0, c9, c12, #0
        bx lr


@ Reset Event Counters [0..2]

    .weak _pmuResetEventCounters_
    .type _pmuResetEventCounters_, %function

_pmuResetEventCounters_:

        mrc p15, #0, r0, c9, c12, #0
        orr r0, r0, #2
        mcr p15, #0, r0, c9, c12, #0
        bx lr


@ Reset Cycle Counter abd Event Counters [0..2]

    .weak _pmuResetCounters_
    .type _pmuResetCounters_, %function

_pmuResetCounters_:

        mrc p15, #0, r0, c9, c12, #0
        orr r0, r0, #6
        mcr p15, #0, r0, c9, c12, #0
        bx lr


@ Start Counters [Cycle, 0..2]

    .weak _pmuStartCounters_
    .type _pmuStartCounters_, %function

_pmuStartCounters_:

        mcr p15, #0, r0, c9, c12, #1
        bx lr


@ Stop Counters [Cycle, 0..2]

    .weak _pmuStopCounters_
    .type _pmuStopCounters_, %function

_pmuStopCounters_:

        mcr p15, #0, r0, c9, c12, #2
        bx lr


@ Set Count event

    .weak _pmuSetCountEvent_
    .type _pmuSetCountEvent_, %function

_pmuSetCountEvent_:

        mcr p15, #0, r0, c9, c12, #5 @ select counter
        mcr p15, #0, r1, c9, c13, #1 @ select event
        bx lr


@ Get Cycle Count

    .weak _pmuGetCycleCount_
    .type _pmuGetCycleCount_, %function

_pmuGetCycleCount_:

        mrc p15, #0, r0, c9, c13, #0
        bx lr


@ Get Event Counter Count Value

    .weak _pmuGetEventCount_
    .type _pmuGetEventCount_, %function

_pmuGetEventCount_:

        mcr p15, #0, r0, c9, c12, #5 @ select counter
        mrc p15, #0, r0, c9, c13, #2 @ read event counter
        bx lr


@ Get Overflow Flags

    .weak _pmuGetOverflow_
    .type _pmuGetOverflow_, %function

_pmuGetOverflow_:

        mrc p15, #0, r0, c9, c12, #3 @ read overflow
        mov r1, #0
        sub r1, r1, #1
        mcr p15, #0, r1, c9, c12, #3 @ clear flags
        bx lr
