#include <stdint.h>
#include <stdbool.h>
#include <string.h>

#include "TCPLog.h"

#include "TPIUSBInterface.h"


USB::USB(void)
{
  m_SaveThis = false;
}

USB::~USB(void)
{
}

/*----------------------------------------------------------------------------*/
/*--- Init                                                                 ---*/
/*----------------------------------------------------------------------------*/
bool USB::Init(USB_HID_CONFIG_MODE USBHIDMode)
{
  // Executing the following line will corrupt the value of USBHIDMode
  // Changing the compiler optimization setting to "Local Optimization" (and
  // presumably anything higher) causes this.
  TCPLogWrite("Test");

  SetHIDMode(USBHIDMode, false);

  return false;
}


/*----------------------------------------------------------------------------*/
/*--- SetHIDMode                                                           ---*/
/*----------------------------------------------------------------------------*/
void USB::SetHIDMode(USB_HID_CONFIG_MODE Mode, bool RestartInterface)
{
  if (RestartInterface)
  {
    if (Mode == USBHID_BIOS_BOOT)
      m_SaveThis = true;
  }
}


