
#include <stdint.h>
#include <stdbool.h>

#include "inc/hw_nvic.h"
#include "inc/hw_emac.h"
#include "inc/hw_types.h"
#include "inc/hw_ints.h"

#include "driverlib/interrupt.h"
#include "driverlib/systick.h"
#include "driverlib/sysctl.h"
#include "driverlib/rom.h"

#include "TCPLog.h"

#include "TPIUSBInterface.h"

#define SYSTICKHZ  100

volatile uint32_t g_ui32SysTickCount;

uint32_t SysClockFreq;
USB  g_USB;

//----------------------------------------------------------------------------//
//---                        SysTickIntHandler                             ---//
//----------------------------------------------------------------------------//
#ifdef  __cplusplus
  extern "C"
#endif
void SysTickIntHandler(void)
{
  g_ui32SysTickCount++;
}

uint8_t GetAValue(void)
{
  return 3;
}

//----------------------------------------------------------------------------//
//----------------------------------------------------------------------------//
//---                            main                                      ---//
//----------------------------------------------------------------------------//
//----------------------------------------------------------------------------//
int main(void)
{
  g_ui32SysTickCount = 0;

  // Disable all interrupts
  IntMasterDisable();

  // Run from the PLL at 120 MHz.
  SysClockFreq = SysCtlClockFreqSet((SYSCTL_XTAL_25MHZ |
                                     SYSCTL_OSC_MAIN | SYSCTL_USE_PLL |
                                     SYSCTL_CFG_VCO_480), 120000000);

  // Set Interrupt Priorities - Highest to lowest
  IntPrioritySet(FAULT_SYSTICK, 0x00000000);

  // Configure SysTick for a periodic interrupt.
  SysTickPeriodSet(SysClockFreq / SYSTICKHZ);
  SysTickEnable();
  SysTickIntEnable();

  // Enable processor interrupts.
  IntMasterEnable();

  // Set halt point on next line; single step to get into Init function
  bool USBInit = g_USB.Init((USB_HID_CONFIG_MODE)GetAValue());

  //================================================================================//
  //=== Main loop                                                                ===//
  //================================================================================//
  while(true)
  {

  }
}
