/*
 * main.c
 */
#include <stdio.h>


typedef char               int8;
typedef unsigned char      Uint8;
typedef int                int16;
typedef long               int32;
typedef long long          int64;
typedef unsigned int       Uint16;
typedef unsigned long      Uint32;
typedef unsigned long long Uint64;
typedef float              float32;
typedef long double        float64;

#define FILTER_FULL  1

typedef struct
{
   Uint16 uK;
   Uint16 uN;
   float32 fFull;
   float32 * pfData;
   float32 fY;
} objMavg;


float32 FilterLinReg (objMavg *p, float32 p_fDataX, float32 p_fDataY)
{
    volatile Uint16 i, j, k;
    volatile float32 fSumX, fSumY, fSumXx, fSumXy;
    fSumX = fSumY = fSumXy = fSumXx = 0.0;
    // check if memory is complete and mark as FULL
    if (p->uK >= p->uN)
    {
        p->uK    = 0;
        p->fFull = FILTER_FULL;
    }
    // store actual value to next position
    *(p->pfData + p->uK) = p_fDataY;
    // index to next position
    p->uK++;


    // regression length at start is shorter
    if (p->fFull == FILTER_FULL)
    {
        j = p->uN;
        // filter full, start at uK value
        k = p->uK;
    }
    else
    {
        j = p->uK;
        // filter not full, start at 0 value
        k = 0;
    }

    // calculate REGRESSION sums over the actual memory
    if( j>1)
    {
        for(i = 0; i <= (j-1); i++)
        {
            if(k >= p->uN)
                k=0;
            // sum of all y values
            // 23.02.16 bug ??? fSumY += *(p->pfData + i);
            fSumY += *(p->pfData + k);
            // sum of all x values
            fSumX += (i) * p_fDataX;
            // sum of all y * x values
            fSumXy += *(p->pfData + k) * ((i) * p_fDataX);
            // sum of all x values
            fSumXx += ((i) * p_fDataX) * ((i) * p_fDataX);
            k++;
        }
        // calculate regression y = a + bx, at the moment only b
        p->fY = (fSumXy-((fSumX*fSumY)/(float)j)) / (fSumXx-((fSumX*fSumX)/(float)j));
         }
    else
    {
        p->fY = 0.0;
    }
    return p->fY;
    //return fSumX;
}



/*!
\fn    void FiltLinRegInit(objMavg *p, float32 *data, const Uint16 n)
\brief Initilisation of Linear Regression with up to 2^16 values.

\author    R. Koester
\date        27.01.2016
\param[in]  *p - pointer to filter object
            data - adress of data buffer
            n - length of data buffer
\return    void

\details Changes:

*/
void FiltLinRegInit(objMavg *p, float32 *data, const Uint16 n)
{
    // set Buffer pointer to data array
    p->pfData = data;
    // store number of values (size of dataarray)
    p->uN    = n;
    // reset data array to 0.0
    for (p->uK = 0; p->uK < p->uN; p->uK++)
    {
        *(p->pfData + p->uK) = ((float32) 0.0);
    }
    // delete actual counter, sum and Full semaphore
    p->uK    = ((Uint32) 0);
    //p->fSum  = ((float32) 0.0);
    p->fFull = ((Uint16) 0);
}

float pfFilteredData[10] = {0,0,0,0,0,0,0,0,0,0};
objMavg ObjMavg;

int main(void)
{
    FILE * fpin;
    FILE * fpout;
    Uint16 i;
    float fdataX;
    float fdataY;

    fpin = fopen("..//testIn.txt","r");
    fpout = fopen("..//testOut.txt","w");

    if ((fpin != 0) || (fpout != 0))
    {
        FiltLinRegInit(&ObjMavg,pfFilteredData,10);

        while (!feof(fpin))
        {
            fscanf(fpin,"%f,%f",&fdataX,&fdataY);

            FilterLinReg (&ObjMavg, fdataX, fdataY);

            fprintf(fpout,"%f,%f,%f,%f\n",ObjMavg.fFull,ObjMavg.fY,ObjMavg.uK,ObjMavg.uN);

            for(i=0;i<10;i++)
            {
                fprintf(fpout,"%f\n",ObjMavg.pfData[i]);
            }
        }
    }

    fclose(fpin);
    fclose(fpout);


	return 0;
}
