#include "ActivityLed.h"
#include "LowResTimer.h"


static struct ActivityLed {
	uint32_t Ticks;
	bool On;
} ActLed = {0};


static void TurnOnActivityLed(void)
{
	GPIOPinWrite(ACT_LED_PORT, ACT_LED_PIN, ACT_LED_ON_MASK );
	ActLed.On = true ;
}


static void TurnOffActivityLed(void)
{
	GPIOPinWrite(ACT_LED_PORT, ACT_LED_PIN, ACT_LED_OFF_MASK);
	ActLed.On = false;
}


static bool ActivityLedTicksElapsed(void)
{
	uint32_t TempTicks = Global.Ticks;

	if (TempTicks - ActLed.Ticks < HALF_SECOND_TICKS)
		return false;

	ActLed.Ticks = TempTicks;
	return true;
}


void MonitorActivityLed(void)
{
	if (ActivityLedTicksElapsed() != true)
		return;

	if (ActLed.On)
		TurnOffActivityLed();
	else
		TurnOnActivityLed();
}


void InitActivityLed(void)
{
	ROM_GPIOPinTypeGPIOOutput(ACT_LED_PORT, ACT_LED_PIN);
	MAP_GPIOPadConfigSet(ACT_LED_PORT, ACT_LED_PIN, GPIO_STRENGTH_4MA, GPIO_PIN_TYPE_STD);

	TurnOffActivityLed();
}

