#include "Hardware.h"


void MonitorHardware(void)
{
}


void InitHardware(void)
{
	static uint32_t Peripherals[] = {
		SYSCTL_PERIPH_GPIOA,
		SYSCTL_PERIPH_GPIOB,
		SYSCTL_PERIPH_GPIOC,
		SYSCTL_PERIPH_GPIOD,
		SYSCTL_PERIPH_GPIOE,
		SYSCTL_PERIPH_GPIOF,
		SYSCTL_PERIPH_GPIOG,
		SYSCTL_PERIPH_GPIOH,
		SYSCTL_PERIPH_GPIOJ,
		SYSCTL_PERIPH_GPIOK,
		SYSCTL_PERIPH_GPIOL,
		SYSCTL_PERIPH_GPIOM,
		SYSCTL_PERIPH_GPION,
		SYSCTL_PERIPH_GPIOP,
		SYSCTL_PERIPH_GPIOQ,
	};
	uint32_t Peripheral;
	int i;

	Global.SysClockFreqHz = MAP_SysCtlClockFreqSet((SYSCTL_XTAL_25MHZ | SYSCTL_OSC_MAIN | SYSCTL_USE_PLL | SYSCTL_CFG_VCO_480), SYSTEM_CLOCK_FREQ_HZ);

	for (i = 0; i < sizeof(Peripherals) / sizeof(Peripherals[0]); i++) {
		Peripheral = Peripherals[i];
		ROM_SysCtlPeripheralDisable(Peripheral);
		ROM_SysCtlPeripheralReset(Peripheral);
		ROM_SysCtlPeripheralEnable(Peripheral);
		while (ROM_SysCtlPeripheralReady(Peripheral) != true) {
		}
	}
}

