#include "LowResTimer.h"


uint32_t TickGet(void)
{
	return Global.Ticks;
}


void StartTimer(struct TimeOutMonitor * Timer, uint32_t Interval)
{
	if (Timer == NULL)
		return;

	Timer->Start = TickGet();
	Timer->Interval = Interval;
}


bool TimerTimedOut(struct TimeOutMonitor * Timer)
{
	return ((TickGet() - Timer->Start) >= Timer->Interval) ? true : false;
}


void IsrSysTickIntHandler(void)
{
	Global.Ticks++;
}


void MonitorSysTickTimer(void)
{
}


void InitSysTickTimer(void)
{
	SysTickPeriodSet(Global.SysClockFreqHz / SYSTICKS_FREQ_HZ);
	SysTickEnable();
	SysTickIntEnable();
}

