#ifndef INCLUDE_LOW_RES_TIMER_H
#define INCLUDE_LOW_RES_TIMER_H


#include "Global.h"


#define ONE_SECOND_TICKS              (SYSTICKS_FREQ_HZ)
#define HALF_SECOND_TICKS             ((SYSTICKS_FREQ_HZ) / 2)


struct TimeOutMonitor {
	uint32_t Start;
	uint32_t Interval;
};


extern uint32_t TickGet(void);

extern void StartTimer(struct TimeOutMonitor * Timer, uint32_t Interval);
extern bool TimerTimedOut(struct TimeOutMonitor * Timer);

extern uint32_t GetUptimeSeconds(void);

extern void IsrSysTickIntHandler(void);

extern void MonitorSysTickTimer(void);
extern void InitSysTickTimer(void);


#endif

