
CLA_SCRATCHPAD_SIZE = 0x100;
--undef_sym=__cla_scratchpad_end
--undef_sym=__cla_scratchpad_start

MEMORY
{
PAGE 0 :  /* Program Memory */
          /* Memory (RAM/FLASH) blocks can be moved to PAGE1 for data allocation */
          /* BEGIN is used for the "boot to Flash" bootloader mode   */

   	//BEGIN_CODE      	: 	origin = 0x080000, length = 0x000002

	//BOOT_CODE			: 	origin = 0x080000, length = 0x004000

	BOOT_INIT      		: 	origin = 0x080000, length = 0x000008

	CRIPTO_CODE     	: 	origin = 0x080008, length = 0x000010

	BOOT_CODE			: 	origin = 0x080018, length = 0x003FCC

	PRODUCTION_DATA		:	origin = 0x083FE4, length = 0x00001C

	APPLICATION_START	:	origin = 0x084000, length = 0x000004

	FLASH_CODE			: 	origin = 0x084004, length = 0x039FF7

	CODE_DSP5000		: 	origin = 0x0BDCFFC, length = 0x002000

	//CODE_DSP4000		: 	origin = 0x0BEFFC, length = 0x001000

	CRC_FLASH			: 	origin = 0x0BFFFC, length = 0x000004

	//	RAMD0           	: 	origin = 0x00B000, length = 0x000800
	//	RAMD1           	: 	origin = 0x00B800, length = 0x000800
	RAMD_01           	: 	origin = 0x00B000, length = 0x001000

	//	RAMLS2      		: 	origin = 0x009000, length = 0x000800
	//	RAMLS3      		: 	origin = 0x009800, length = 0x000800
	//	RAMLS4      		: 	origin = 0x00A000, length = 0x000800
	//	RAMLS5      		: 	origin = 0x00A800, length = 0x000800
	RAMLS_2345     		: 	origin = 0x009000, length = 0x002000

	RESET           	: 	origin = 0x3FFFC0, length = 0x000002

   	OTP_TEXAS		: origin = 0x00070000, length = 0x000400			// OTP Texas

   	/* Part of Z1 OTP.  LinkPointers */
   	DCSM_OTP_Z1_LINKPOINTER		: origin = 0x78000, length = 0x00000C
    /* Z1 OTP.  PSWDLOCK/RESERVED */
    DCSM_OTP_Z1_PSWDLOCK	    : origin = 0x78010, length = 0x000004
    /* Z1 OTP.  CRCLOCK/RESERVED */
    DCSM_OTP_Z1_CRCLOCK	    	: origin = 0x78014, length = 0x000004
    /* Z1 OTP.  RESERVED/BOOTCTRL */
    DCSM_OTP_Z1_BOOTCTRL	    : origin = 0x7801C, length = 0x000004

    /* Z2 OTP.  LinkPointers */
    DCSM_OTP_Z2_LINKPOINTER		: origin = 0x78200, length = 0x00000C
    /* Z2 OTP.  GPREG1/GPREG2 */
    DCSM_OTP_Z2_GPREG	        : origin = 0x7820C, length = 0x000004
    /* Z2 OTP.  PSWDLOCK/RESERVED */
    DCSM_OTP_Z2_PSWDLOCK	    : origin = 0x78210, length = 0x000004
    /* Z2 OTP.  CRCLOCK/RESERVED */
    DCSM_OTP_Z2_CRCLOCK	    	: origin = 0x78214, length = 0x000004
    /* Z2 OTP.  GPREG3/BOOTCTRL */
    DCSM_OTP_Z2_BOOTCTRL	    : origin = 0x7821C, length = 0x000004

   	/* DCSM Z1 Zone Select Contents (!!Movable!!) */
   	/* Part of Z1 OTP.  Z1 password locations / Flash and RAM partitioning */
   	DCSM_ZSEL_Z1_P0				: origin = 0x78070, length = 0x000010

   	/* DCSM Z1 Zone Select Contents (!!Movable!!) */
   	/* Part of Z2 OTP.  Z2 password locations / Flash and RAM partitioning  */
   	DCSM_ZSEL_Z2_P0				: origin = 0x78220, length = 0x000010



PAGE 1 : /* Data Memory */
         /* Memory (RAM/FLASH) blocks can be moved to PAGE0 for program allocation */

	BOOT_RSVD       	: origin = 0x000002, length = 0x000120     /* Part of M0, BOOT rom will use this for stack */

	RAMM1           	: origin = 0x000400, length = 0x000400     /* on-chip RAM block M1 */

	//	RAMLS0          	: origin = 0x008000, length = 0x000800
	//	RAMLS1          	: origin = 0x008800, length = 0x000800
	RAMLS_01          	: origin = 0x008000, length = 0x001000

	//	RAMGS0      		: origin = 0x00C000, length = 0x001000
	//	RAMGS1     			: origin = 0x00D000, length = 0x001000
	//	RAMGS2      		: origin = 0x00E000, length = 0x001000
	//	RAMGS3      		: origin = 0x00F000, length = 0x001000
	//	RAMGS4      		: origin = 0x010000, length = 0x001000
	//	RAMGS5      		: origin = 0x011000, length = 0x001000
	//	RAMGS6      		: origin = 0x012000, length = 0x001000
	//	RAMGS7      		: origin = 0x013000, length = 0x001000
	RAMGS_07      		: origin = 0x00C000, length = 0x008000

   	CLA1_MSGRAMLOW   	: origin = 0x001480, length = 0x000080
   	CLA1_MSGRAMHIGH  	: origin = 0x001500, length = 0x000080
}


SECTIONS
{
   /* Allocate program areas: */
   	.cinit      			: > FLASH_CODE      PAGE = 0, ALIGN(4)
   	.pinit          		: > FLASH_CODE     	PAGE = 0, ALIGN(4)
   	.text           		: > FLASH_CODE      PAGE = 0, ALIGN(4)

	dclfuncs				: > FLASH_CODE      PAGE = 0, ALIGN(4)

//	codestart       		: > BEGIN_CODE      PAGE = 0

	application_start		: > APPLICATION_START      PAGE = 0, ALIGN(4)

  	ramfuncs       	: 	LOAD = FLASH_CODE,
                       	RUN = RAMD_01,
                       	LOAD_START(_RamfuncsLoadStart),
                       	LOAD_SIZE(_RamfuncsLoadSize),
                       	LOAD_END(_RamfuncsLoadEnd),
                       	RUN_START(_RamfuncsRunStart),
                       	RUN_SIZE(_RamfuncsRunSize),
                       	RUN_END(_RamfuncsRunEnd),
                       	PAGE = 0, ALIGN(4)
						 
	/* Allocate uninitalized data sections: */
	.stack              : > RAMM1        					PAGE = 1, ALIGN(4), FILL 0x0000
	.ebss               : > RAMGS_07       					PAGE = 1, ALIGN(4), FILL 0x0000
	.esysmem            : > RAMGS_07       					PAGE = 1, ALIGN(4), FILL 0x0000


   /* Initalized sections go in Flash */
	.econst     	: > FLASH_CODE      PAGE = 0, ALIGN(4)
   	.switch   		: > FLASH_CODE      PAGE = 0, ALIGN(4)

	.boot			: > BOOT_CODE      PAGE = 0, ALIGN(4)

	.bootinit		: > BOOT_INIT	   PAGE = 0, ALIGN(4)

	.bootcripto		: > CRIPTO_CODE		PAGE = 0, ALIGN(4), TYPE = DSECT /* not used, */

	.productiondata	: > PRODUCTION_DATA	PAGE = 0, ALIGN(4), TYPE = DSECT /* not used, */

	.CodeDsp5000	: > CODE_DSP5000   	PAGE = 0, ALIGN(4)

	//.CodeDsp4000	: > CODE_DSP4000   	PAGE = 0, ALIGN(4)

	.crc_flash		: > CRC_FLASH,		PAGE = 0, ALIGN(4)
   
   	.reset      	: > RESET,     		PAGE = 0, TYPE = DSECT /* not used, */

    dcsm_otp_z1_linkpointer 	: > DCSM_OTP_Z1_LINKPOINTER		PAGE = 0
    dcsm_otp_z1_pswdlock		: > DCSM_OTP_Z1_PSWDLOCK		PAGE = 0
    dcsm_otp_z1_crclock			: > DCSM_OTP_Z1_CRCLOCK			PAGE = 0
    dcsm_otp_z1_bootctrl		: > DCSM_OTP_Z1_BOOTCTRL		PAGE = 0
    dcsm_zsel_z1				: > DCSM_ZSEL_Z1_P0				PAGE = 0

    dcsm_otp_z2_linkpointer		: > DCSM_OTP_Z2_LINKPOINTER		PAGE = 0, type = DSECT
    dcsm_otp_z2_pswdlock		: > DCSM_OTP_Z2_PSWDLOCK		PAGE = 0, type = DSECT
    dcsm_otp_z2_crclock			: > DCSM_OTP_Z2_CRCLOCK			PAGE = 0, type = DSECT
    dcsm_otp_z2_bootctrl		: > DCSM_OTP_Z2_BOOTCTRL		PAGE = 0, type = DSECT
    dcsm_zsel_z2				: > DCSM_ZSEL_Z2_P0				PAGE = 0, type = DSECT


      /* CLA specific sections */
   Cla1Prog         : LOAD = FLASH_CODE,
                      RUN = RAMLS_2345,
                      LOAD_START(_Cla1funcsLoadStart),
                      LOAD_END(_Cla1funcsLoadEnd),
                      RUN_START(_Cla1funcsRunStart),
                      LOAD_SIZE(_Cla1funcsLoadSize),
                      PAGE = 0, ALIGN(4)

   CLADataLS0		: > RAMLS_01, 						PAGE = 1, ALIGN(4), FILL 0x0000

   CLA1mathTables   : > 0x01001870, 					PAGE = 0, TYPE = NOLOAD

   Cla1ToCpuMsgRAM  : > CLA1_MSGRAMLOW,   				PAGE = 1, ALIGN(4)
   CpuToCla1MsgRAM  : > CLA1_MSGRAMHIGH,  				PAGE = 1, ALIGN(4)

   CLAscratch       :
                     { *.obj(CLAscratch)
                     . += CLA_SCRATCHPAD_SIZE;
                     *.obj(CLAscratch_end) } >  RAMLS_01,  PAGE = 1, ALIGN(4)

   .scratchpad      : > RAMLS_01,       PAGE = 1
   .bss_cla		    : > RAMLS_01,       PAGE = 1
   .const_cla	    :  LOAD = FLASH_CODE,
                       RUN = RAMLS_01,
                       RUN_START(_Cla1ConstRunStart),
                       LOAD_START(_Cla1ConstLoadStart),
                       LOAD_SIZE(_Cla1ConstLoadSize),
                       PAGE = 1, ALIGN(4)
}

/*
//===========================================================================
// End of file.
//===========================================================================
*/
