
#include "Variabili.h"
#include "DCL.h"
#include "stdint.h"
#include "stdbool.h"


#define PWM_MOTORE_PHASE_A				EPwm6Regs
#define PWM_MOTORE_PHASE_B				EPwm7Regs
#define PWM_MOTORE_PHASE_C				EPwm8Regs


#define xMOTORE_DeadBand				1 		//Espressa in [us]

// ----------------------------------------------
// SV pwm modulator
typedef struct
{
	Uint32			PeriodMax;

	Uint32			u16DoublePeriod;

	Uint32			u16HalfPeriod;
	Uint32			u16Ta;
	Uint32			u16Tb;
	Uint32			u16Tc;

}St_x_SpaceVector;

// ----------------------------------------------

// Struttura Principale
typedef struct {

	volatile struct EPWM_REGS 	*PWM_1;
	volatile struct EPWM_REGS 	*PWM_2;
	volatile struct EPWM_REGS 	*PWM_3;

} St_x_Motore;

// ----------------------------------------------

typedef union{
	volatile struct EPWM_REGS *ptr; //Aligned to lower 16-bits
	Uint32 pad; //32-bits
}CLA_FPTR;

// ----------------------------------------------

typedef struct {

    St_x_SpaceVector			sPwmMod;

	CLA_FPTR					PWM_1;
	CLA_FPTR					PWM_2;
	CLA_FPTR					PWM_3;

} St_x_Motore_CLA;
// ----------------------------------------------

extern St_x_Motore		xMOTOR;
extern St_x_Motore_CLA	xMOTOR_CLA;

extern void xMOTOR_Init();

