//------------------------------------------------------------------------
//
//  Project		:	Ultra-feeder 2
//  Target		:	F28075
//------------------------------------------------------------------------
//  Filename	:	SysClk.h
//  Author 		:	A. G.
//  Date		:	20.04.2002
//------------------------------------------------------------------------
//  History		: 	20.04.2002 - Creation
//
//------------------------------------------------------------------------
//  Description:
//				
//
//------------------------------------------------------------------------
//	A.G:
//
//	File revision:	$revision
//	Project Label:	$label
//
//------------------------------------------------------------------------

#ifndef SYSCLK_H
#define SYSCLK_H


/* -------------------- COMMON section -------------------------------- */
/*																		*/
/* these defines are visibles in all files								*/
/*																		*/
/* -------------------------------------------------------------------- */

/* -------------------- COMMON defines -------------------------------- */


#define	iTIME(ms)	( (unsigned long)ms * (unsigned long)(Frequenza_PWM) )


typedef enum {

	TIMER_STATE_IDLE,
    TIMER_STATE_COUNTING,
    TIMER_STATE_END,

	NumberOf_TIMER_STATES
	
} TimerState;

typedef struct
{
	int32	            value;
	int32	            limit;
	TimerState			state;
		
}STimer;

typedef struct
{
	STimer	        SecTimer;
	unsigned int	Seconds;
	unsigned int	ElapsedSeconds;
	TimerState		state;
		
}LongSTimer;


#ifndef SYSCLK_C

/* -------------------- EXTERNAL section ------------------------------ */
/*																		*/
/* these defines are visibles in all files except "filename.c"			*/
/*																		*/
/* -------------------------------------------------------------------- */

/* -------------------- EXTERNAL defines ------------------------------ */
extern int			SysTime;


/* -------------------- External  Prototypes -------------------------- */
extern int			TimerInit(STimer *t, int limit);
extern void			TimerStop(STimer *t);

extern int			TimerIsWaiting(STimer *t);
extern int			TimerIsElapsed(STimer *t);

extern int	        LongTimerInit(LongSTimer *t, unsigned int SecLimit, unsigned int MsecLimit);
extern void	        LongTimerStop(LongSTimer *t);
extern int	        LongTimerIsWaiting(LongSTimer *t);
extern int	        LongTimerIsElapsed(LongSTimer *t);


/* -------------------- External  Vars -------------------------------- */

#else

/* -------------------- LOCAL section --------------------------------- */
/*																		*/
/* these defines are visibles only in the file "filename.c"				*/
/*																		*/
/* -------------------------------------------------------------------- */

/* -------------------- LOCAL defines --------------------------------- */


/* -------------------- LOCAL prototypes ------------------------------ */


/* -------------------- LOCAL variables ------------------------------- */


#endif	//c
#endif	//h
