
#include "Variabili.h"


// ---------------------------------------------------

void xAtoD_Init_Canali_Lavoro()
{
	EALLOW;

	// Assegnazione dei Canali x MODULO AD-A
	AdcaRegs.ADCSOC0CTL.bit.CHSEL = Ch_Seno_M1;
	AdcaRegs.ADCSOC0CTL.bit.ACQPS = AtoD_Sample_Window;
	AdcaRegs.ADCSOC0CTL.bit.TRIGSEL = 0x0F;

	AdcaRegs.ADCSOC1CTL.bit.CHSEL = Ch_Corrente_A_M1;
	AdcaRegs.ADCSOC1CTL.bit.ACQPS = AtoD_Sample_Window;
	AdcaRegs.ADCSOC1CTL.bit.TRIGSEL = 0x0F;

	AdcaRegs.ADCSOC2CTL.bit.CHSEL = Ch_Tensione_Filo_0;
	AdcaRegs.ADCSOC2CTL.bit.ACQPS = AtoD_Sample_Window;
	AdcaRegs.ADCSOC2CTL.bit.TRIGSEL = 0x0F;

	AdcaRegs.ADCSOC3CTL.bit.CHSEL = Ch_Alimentazione_Generale;
	AdcaRegs.ADCSOC3CTL.bit.ACQPS = AtoD_Sample_Window;
	AdcaRegs.ADCSOC3CTL.bit.TRIGSEL = 0x0F;

	AdcaRegs.ADCSOC4CTL.bit.CHSEL = Ch_Unico_Anl_1;
	AdcaRegs.ADCSOC4CTL.bit.ACQPS = AtoD_Sample_Window;
	AdcaRegs.ADCSOC4CTL.bit.TRIGSEL = 0x0F;

	AdcaRegs.ADCSOC5CTL.bit.CHSEL = Ch_Unico_Anl_2;
	AdcaRegs.ADCSOC5CTL.bit.ACQPS = AtoD_Sample_Window;
	AdcaRegs.ADCSOC5CTL.bit.TRIGSEL = 0x0F;


	// Assegnazione dei Canali x MODULO AD-B
	AdcbRegs.ADCSOC0CTL.bit.CHSEL = Ch_Coseno_M1;
	AdcbRegs.ADCSOC0CTL.bit.ACQPS = AtoD_Sample_Window;
	AdcbRegs.ADCSOC0CTL.bit.TRIGSEL = 0x0F;

	AdcbRegs.ADCSOC1CTL.bit.CHSEL = Ch_Corrente_B_M1;
	AdcbRegs.ADCSOC1CTL.bit.ACQPS = AtoD_Sample_Window;
	AdcbRegs.ADCSOC1CTL.bit.TRIGSEL = 0x0F;

	AdcbRegs.ADCSOC2CTL.bit.CHSEL = Ch_Tensione_Filo_1;
	AdcbRegs.ADCSOC2CTL.bit.ACQPS = AtoD_Sample_Window;
	AdcbRegs.ADCSOC2CTL.bit.TRIGSEL = 0x0F;

	AdcbRegs.ADCSOC3CTL.bit.CHSEL = Ch_Bus_Motore;
	AdcbRegs.ADCSOC3CTL.bit.ACQPS = AtoD_Sample_Window;
	AdcbRegs.ADCSOC3CTL.bit.TRIGSEL = 0x0F;

	AdcbRegs.ADCSOC4CTL.bit.CHSEL = Ch_External_Connection_Gnd_B1;
	AdcbRegs.ADCSOC4CTL.bit.ACQPS = AtoD_Sample_Window;
	AdcbRegs.ADCSOC4CTL.bit.TRIGSEL = 0x0F;

	AdcbRegs.ADCSOC5CTL.bit.CHSEL = Ch_External_Connection_Gnd_B2;
	AdcbRegs.ADCSOC5CTL.bit.ACQPS = AtoD_Sample_Window;
	AdcbRegs.ADCSOC5CTL.bit.TRIGSEL = 0x0F;

	EDIS;

}

// ---------------------------------------------------

void xAtoD_ROM_Trimming_Copy()
{
    // *IMPORTANT*
    // The Device_cal function, which copies the ADC & oscillator calibration values
    // from TI reserved OTP into the appropriate trim registers, occurs automatically
    // in the Boot ROM. If the boot ROM code is bypassed during the debug process, the
    // following function MUST be called for the ADC and oscillators to function according
    // to specification. The clocks to the ADC MUST be enabled before calling this
    // function.
    // See the device data manual and/or the ADC Reference
    // Manual for more information.

	EALLOW;

	// Verifica Esistenza di valori trimming da fabbrica x reference e linearit
	if(0xFFFF != *((Uint16*)CalAdcaINL))
	{
		//trim function is programmed into OTP, so call it
		(*CalAdcaINL)();
		//xAtoD.reg.bit.Trim_A_From_ROM = 1;
	}
	else
	{
		AnalogSubsysRegs.ANAREFTRIMA.all = 0x7BDD;

		AdcaRegs.ADCINLTRIM1 &= 0xFFFF0000;
		AdcaRegs.ADCINLTRIM2 &= 0xFFFF0000;
		AdcaRegs.ADCINLTRIM4 &= 0xFFFF0000;
		AdcaRegs.ADCINLTRIM5 &= 0xFFFF0000;

	}
	if(0xFFFF != *((Uint16*)CalAdcbINL))
	{
		//trim function is programmed into OTP, so call it
		(*CalAdcbINL)();
		//xAtoD.reg.bit.Trim_B_From_ROM = 1;
	}
	else
	{
		AnalogSubsysRegs.ANAREFTRIMB.all = 0x7BDD;

		AdcbRegs.ADCINLTRIM1 &= 0xFFFF0000;
		AdcbRegs.ADCINLTRIM2 &= 0xFFFF0000;
		AdcbRegs.ADCINLTRIM4 &= 0xFFFF0000;
		AdcbRegs.ADCINLTRIM5 &= 0xFFFF0000;
	}

	// Verifica Esistenza di valori trimming da fabbrica x Offset
	if(0xFFFF != *((Uint16*)GetAdcOffsetTrimOTP))
	{
		//offset trim function is programmed into OTP, so call it

		//calculate the index into OTP table of offset trims and call
		//function to return the correct offset trim
//		adcOffsetTrimOTPIndex = 4*adc + 2*resolution + 1*signalmode;
//		adcOffsetTrim = (*GetAdcOffsetTrimOTP)(adcOffsetTrimOTPIndex);
		AdcaRegs.ADCOFFTRIM.all = (*GetAdcOffsetTrimOTP)(0);
		AdcbRegs.ADCOFFTRIM.all = (*GetAdcOffsetTrimOTP)(4);
		//xAtoD.reg.bit.Trim_A_Offset_From_ROM = 1;
		//xAtoD.reg.bit.Trim_B_Offset_From_ROM = 1;
	}
	else {
		//offset trim function is not populated, so set offset trim to 0
		AdcaRegs.ADCOFFTRIM.all = 0;
		AdcbRegs.ADCOFFTRIM.all = 0;
	}

	EDIS;
}

// ---------------------------------------------------

void xAtoD_Init()
{
	xAtoD_ROM_Trimming_Copy();							// Copia Valori di Fabbrica da ROM a registro

	EALLOW;

	// --------
	AdcaRegs.ADCCTL2.bit.PRESCALE = AtoD_Prescaler;
	AdcaRegs.ADCCTL2.bit.RESOLUTION = 0;				// 12 bits
	AdcaRegs.ADCCTL2.bit.SIGNALMODE = 0;				// Conversione Single Ended

	AdcbRegs.ADCCTL2.bit.PRESCALE = AtoD_Prescaler;
	AdcbRegs.ADCCTL2.bit.RESOLUTION = 0;				// 12 bits
	AdcbRegs.ADCCTL2.bit.SIGNALMODE = 0;				// Conversione Single Ended

	// --------
	AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;			// Posiziona Interrupt a fine conversione ....
	AdcbRegs.ADCCTL1.bit.INTPULSEPOS = 1;			// Posiziona Interrupt a fine conversione ....

	// --------
	AdcaRegs.ADCCTL1.bit.ADCPWDNZ = 1;				// Accende A/D
	AdcbRegs.ADCCTL1.bit.ADCPWDNZ = 1;				// Accende A/D

	EDIS;

	DELAY_US(2000);									// Attesa del circuito di Alimentazione

	// -----------------

	xAtoD_Init_Canali_Lavoro();

	EALLOW;

	AdcaRegs.ADCINTSEL1N2.bit.INT1CONT = 1;			// Selezione modalita interrupt per A/D
	AdcaRegs.ADCINTSEL1N2.bit.INT1SEL = 0;
	AdcaRegs.ADCINTSEL1N2.bit.INT1E = 1;
	AdcaRegs.ADCINTSEL1N2.bit.INT1SEL = 5;         // Aspetta SOC-2
												   // Gli altri seguono a ruota e subiscono ritardo di un giro


	AdcaRegs.ADCINTFLG.bit.ADCINT1 = 1;				//Selezione Interrupt Attivi
	AdcaRegs.ADCINTFLGCLR.all = 0x000F;
	AdcaRegs.ADCINTOVFCLR.all = 0x000F;


	AdcaRegs.ADCINTSOCSEL1.all = 0;					// Servono per loop automatico conversion ?????
	AdcaRegs.ADCINTSOCSEL2.all = 0;


	AdcaRegs.ADCSOCOVFCLR1.all = 0xFFFF;
	AdcbRegs.ADCSOCOVFCLR1.all = 0xFFFF;

	EDIS;

}
// ---------------------------------------------------
